var $hxClasses = $hxClasses || {},$estr = function() { return js.Boot.__string_rec(this,''); };
function $extend(from, fields) {
	function inherit() {}; inherit.prototype = from; var proto = new inherit();
	for (var name in fields) proto[name] = fields[name];
	return proto;
}
var EReg = $hxClasses["EReg"] = function(r,opt) {
	opt = opt.split("u").join("");
	this.r = new RegExp(r,opt);
};
EReg.__name__ = ["EReg"];
EReg.prototype = {
	customReplace: function(s,f) {
		var buf = new StringBuf();
		while(true) {
			if(!this.match(s)) break;
			buf.b += Std.string(this.matchedLeft());
			buf.b += Std.string(f(this));
			s = this.matchedRight();
		}
		buf.b += Std.string(s);
		return buf.b;
	}
	,replace: function(s,by) {
		return s.replace(this.r,by);
	}
	,split: function(s) {
		var d = "#__delim__#";
		return s.replace(this.r,d).split(d);
	}
	,matchedPos: function() {
		if(this.r.m == null) throw "No string matched";
		return { pos : this.r.m.index, len : this.r.m[0].length};
	}
	,matchedRight: function() {
		if(this.r.m == null) throw "No string matched";
		var sz = this.r.m.index + this.r.m[0].length;
		return this.r.s.substr(sz,this.r.s.length - sz);
	}
	,matchedLeft: function() {
		if(this.r.m == null) throw "No string matched";
		return this.r.s.substr(0,this.r.m.index);
	}
	,matched: function(n) {
		return this.r.m != null && n >= 0 && n < this.r.m.length?this.r.m[n]:(function($this) {
			var $r;
			throw "EReg::matched";
			return $r;
		}(this));
	}
	,match: function(s) {
		if(this.r.global) this.r.lastIndex = 0;
		this.r.m = this.r.exec(s);
		this.r.s = s;
		return this.r.m != null;
	}
	,r: null
	,__class__: EReg
}
var Hash = $hxClasses["Hash"] = function() {
	this.h = { };
};
Hash.__name__ = ["Hash"];
Hash.prototype = {
	toString: function() {
		var s = new StringBuf();
		s.b += Std.string("{");
		var it = this.keys();
		while( it.hasNext() ) {
			var i = it.next();
			s.b += Std.string(i);
			s.b += Std.string(" => ");
			s.b += Std.string(Std.string(this.get(i)));
			if(it.hasNext()) s.b += Std.string(", ");
		}
		s.b += Std.string("}");
		return s.b;
	}
	,iterator: function() {
		return { ref : this.h, it : this.keys(), hasNext : function() {
			return this.it.hasNext();
		}, next : function() {
			var i = this.it.next();
			return this.ref["$" + i];
		}};
	}
	,keys: function() {
		var a = [];
		for( var key in this.h ) {
		if(this.h.hasOwnProperty(key)) a.push(key.substr(1));
		}
		return HxOverrides.iter(a);
	}
	,remove: function(key) {
		key = "$" + key;
		if(!this.h.hasOwnProperty(key)) return false;
		delete(this.h[key]);
		return true;
	}
	,exists: function(key) {
		return this.h.hasOwnProperty("$" + key);
	}
	,get: function(key) {
		return this.h["$" + key];
	}
	,set: function(key,value) {
		this.h["$" + key] = value;
	}
	,h: null
	,__class__: Hash
}
var HxOverrides = $hxClasses["HxOverrides"] = function() { }
HxOverrides.__name__ = ["HxOverrides"];
HxOverrides.dateStr = function(date) {
	var m = date.getMonth() + 1;
	var d = date.getDate();
	var h = date.getHours();
	var mi = date.getMinutes();
	var s = date.getSeconds();
	return date.getFullYear() + "-" + (m < 10?"0" + m:"" + m) + "-" + (d < 10?"0" + d:"" + d) + " " + (h < 10?"0" + h:"" + h) + ":" + (mi < 10?"0" + mi:"" + mi) + ":" + (s < 10?"0" + s:"" + s);
}
HxOverrides.strDate = function(s) {
	switch(s.length) {
	case 8:
		var k = s.split(":");
		var d = new Date();
		d.setTime(0);
		d.setUTCHours(k[0]);
		d.setUTCMinutes(k[1]);
		d.setUTCSeconds(k[2]);
		return d;
	case 10:
		var k = s.split("-");
		return new Date(k[0],k[1] - 1,k[2],0,0,0);
	case 19:
		var k = s.split(" ");
		var y = k[0].split("-");
		var t = k[1].split(":");
		return new Date(y[0],y[1] - 1,y[2],t[0],t[1],t[2]);
	default:
		throw "Invalid date format : " + s;
	}
}
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) return undefined;
	return x;
}
HxOverrides.substr = function(s,pos,len) {
	if(pos != null && pos != 0 && len != null && len < 0) return "";
	if(len == null) len = s.length;
	if(pos < 0) {
		pos = s.length + pos;
		if(pos < 0) pos = 0;
	} else if(len < 0) len = s.length + len - pos;
	return s.substr(pos,len);
}
HxOverrides.remove = function(a,obj) {
	var i = 0;
	var l = a.length;
	while(i < l) {
		if(a[i] == obj) {
			a.splice(i,1);
			return true;
		}
		i++;
	}
	return false;
}
HxOverrides.iter = function(a) {
	return { cur : 0, arr : a, hasNext : function() {
		return this.cur < this.arr.length;
	}, next : function() {
		return this.arr[this.cur++];
	}};
}
var IntHash = $hxClasses["IntHash"] = function() {
	this.h = { };
};
IntHash.__name__ = ["IntHash"];
IntHash.prototype = {
	toString: function() {
		var s = new StringBuf();
		s.b += Std.string("{");
		var it = this.keys();
		while( it.hasNext() ) {
			var i = it.next();
			s.b += Std.string(i);
			s.b += Std.string(" => ");
			s.b += Std.string(Std.string(this.get(i)));
			if(it.hasNext()) s.b += Std.string(", ");
		}
		s.b += Std.string("}");
		return s.b;
	}
	,iterator: function() {
		return { ref : this.h, it : this.keys(), hasNext : function() {
			return this.it.hasNext();
		}, next : function() {
			var i = this.it.next();
			return this.ref[i];
		}};
	}
	,keys: function() {
		var a = [];
		for( var key in this.h ) {
		if(this.h.hasOwnProperty(key)) a.push(key | 0);
		}
		return HxOverrides.iter(a);
	}
	,remove: function(key) {
		if(!this.h.hasOwnProperty(key)) return false;
		delete(this.h[key]);
		return true;
	}
	,exists: function(key) {
		return this.h.hasOwnProperty(key);
	}
	,get: function(key) {
		return this.h[key];
	}
	,set: function(key,value) {
		this.h[key] = value;
	}
	,h: null
	,__class__: IntHash
}
var IntIter = $hxClasses["IntIter"] = function(min,max) {
	this.min = min;
	this.max = max;
};
IntIter.__name__ = ["IntIter"];
IntIter.prototype = {
	next: function() {
		return this.min++;
	}
	,hasNext: function() {
		return this.min < this.max;
	}
	,max: null
	,min: null
	,__class__: IntIter
}
var List = $hxClasses["List"] = function() {
	this.length = 0;
};
List.__name__ = ["List"];
List.prototype = {
	map: function(f) {
		var b = new List();
		var l = this.h;
		while(l != null) {
			var v = l[0];
			l = l[1];
			b.add(f(v));
		}
		return b;
	}
	,filter: function(f) {
		var l2 = new List();
		var l = this.h;
		while(l != null) {
			var v = l[0];
			l = l[1];
			if(f(v)) l2.add(v);
		}
		return l2;
	}
	,join: function(sep) {
		var s = new StringBuf();
		var first = true;
		var l = this.h;
		while(l != null) {
			if(first) first = false; else s.b += Std.string(sep);
			s.b += Std.string(l[0]);
			l = l[1];
		}
		return s.b;
	}
	,toString: function() {
		var s = new StringBuf();
		var first = true;
		var l = this.h;
		s.b += Std.string("{");
		while(l != null) {
			if(first) first = false; else s.b += Std.string(", ");
			s.b += Std.string(Std.string(l[0]));
			l = l[1];
		}
		s.b += Std.string("}");
		return s.b;
	}
	,iterator: function() {
		return { h : this.h, hasNext : function() {
			return this.h != null;
		}, next : function() {
			if(this.h == null) return null;
			var x = this.h[0];
			this.h = this.h[1];
			return x;
		}};
	}
	,remove: function(v) {
		var prev = null;
		var l = this.h;
		while(l != null) {
			if(l[0] == v) {
				if(prev == null) this.h = l[1]; else prev[1] = l[1];
				if(this.q == l) this.q = prev;
				this.length--;
				return true;
			}
			prev = l;
			l = l[1];
		}
		return false;
	}
	,clear: function() {
		this.h = null;
		this.q = null;
		this.length = 0;
	}
	,isEmpty: function() {
		return this.h == null;
	}
	,pop: function() {
		if(this.h == null) return null;
		var x = this.h[0];
		this.h = this.h[1];
		if(this.h == null) this.q = null;
		this.length--;
		return x;
	}
	,last: function() {
		return this.q == null?null:this.q[0];
	}
	,first: function() {
		return this.h == null?null:this.h[0];
	}
	,push: function(item) {
		var x = [item,this.h];
		this.h = x;
		if(this.q == null) this.q = x;
		this.length++;
	}
	,add: function(item) {
		var x = [item];
		if(this.h == null) this.h = x; else this.q[1] = x;
		this.q = x;
		this.length++;
	}
	,length: null
	,q: null
	,h: null
	,__class__: List
}
var Reflect = $hxClasses["Reflect"] = function() { }
Reflect.__name__ = ["Reflect"];
Reflect.hasField = function(o,field) {
	return Object.prototype.hasOwnProperty.call(o,field);
}
Reflect.field = function(o,field) {
	var v = null;
	try {
		v = o[field];
	} catch( e ) {
	}
	return v;
}
Reflect.setField = function(o,field,value) {
	o[field] = value;
}
Reflect.getProperty = function(o,field) {
	var tmp;
	return o == null?null:o.__properties__ && (tmp = o.__properties__["get_" + field])?o[tmp]():o[field];
}
Reflect.setProperty = function(o,field,value) {
	var tmp;
	if(o.__properties__ && (tmp = o.__properties__["set_" + field])) o[tmp](value); else o[field] = value;
}
Reflect.callMethod = function(o,func,args) {
	return func.apply(o,args);
}
Reflect.fields = function(o) {
	var a = [];
	if(o != null) {
		var hasOwnProperty = Object.prototype.hasOwnProperty;
		for( var f in o ) {
		if(hasOwnProperty.call(o,f)) a.push(f);
		}
	}
	return a;
}
Reflect.isFunction = function(f) {
	return typeof(f) == "function" && !(f.__name__ || f.__ename__);
}
Reflect.compare = function(a,b) {
	return a == b?0:a > b?1:-1;
}
Reflect.compareMethods = function(f1,f2) {
	if(f1 == f2) return true;
	if(!Reflect.isFunction(f1) || !Reflect.isFunction(f2)) return false;
	return f1.scope == f2.scope && f1.method == f2.method && f1.method != null;
}
Reflect.isObject = function(v) {
	if(v == null) return false;
	var t = typeof(v);
	return t == "string" || t == "object" && !v.__enum__ || t == "function" && (v.__name__ || v.__ename__);
}
Reflect.deleteField = function(o,f) {
	if(!Reflect.hasField(o,f)) return false;
	delete(o[f]);
	return true;
}
Reflect.copy = function(o) {
	var o2 = { };
	var _g = 0, _g1 = Reflect.fields(o);
	while(_g < _g1.length) {
		var f = _g1[_g];
		++_g;
		o2[f] = Reflect.field(o,f);
	}
	return o2;
}
Reflect.makeVarArgs = function(f) {
	return function() {
		var a = Array.prototype.slice.call(arguments);
		return f(a);
	};
}
var Std = $hxClasses["Std"] = function() { }
Std.__name__ = ["Std"];
Std["is"] = function(v,t) {
	return js.Boot.__instanceof(v,t);
}
Std.string = function(s) {
	return js.Boot.__string_rec(s,"");
}
Std["int"] = function(x) {
	return x | 0;
}
Std.parseInt = function(x) {
	var v = parseInt(x,10);
	if(v == 0 && (HxOverrides.cca(x,1) == 120 || HxOverrides.cca(x,1) == 88)) v = parseInt(x);
	if(isNaN(v)) return null;
	return v;
}
Std.parseFloat = function(x) {
	return parseFloat(x);
}
Std.random = function(x) {
	return Math.floor(Math.random() * x);
}
var StringBuf = $hxClasses["StringBuf"] = function() {
	this.b = "";
};
StringBuf.__name__ = ["StringBuf"];
StringBuf.prototype = {
	toString: function() {
		return this.b;
	}
	,addSub: function(s,pos,len) {
		this.b += HxOverrides.substr(s,pos,len);
	}
	,addChar: function(c) {
		this.b += String.fromCharCode(c);
	}
	,add: function(x) {
		this.b += Std.string(x);
	}
	,b: null
	,__class__: StringBuf
}
var StringTools = $hxClasses["StringTools"] = function() { }
StringTools.__name__ = ["StringTools"];
StringTools.urlEncode = function(s) {
	return encodeURIComponent(s);
}
StringTools.urlDecode = function(s) {
	return decodeURIComponent(s.split("+").join(" "));
}
StringTools.htmlEscape = function(s) {
	return s.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;");
}
StringTools.htmlUnescape = function(s) {
	return s.split("&gt;").join(">").split("&lt;").join("<").split("&amp;").join("&");
}
StringTools.startsWith = function(s,start) {
	return s.length >= start.length && HxOverrides.substr(s,0,start.length) == start;
}
StringTools.endsWith = function(s,end) {
	var elen = end.length;
	var slen = s.length;
	return slen >= elen && HxOverrides.substr(s,slen - elen,elen) == end;
}
StringTools.isSpace = function(s,pos) {
	var c = HxOverrides.cca(s,pos);
	return c >= 9 && c <= 13 || c == 32;
}
StringTools.ltrim = function(s) {
	var l = s.length;
	var r = 0;
	while(r < l && StringTools.isSpace(s,r)) r++;
	if(r > 0) return HxOverrides.substr(s,r,l - r); else return s;
}
StringTools.rtrim = function(s) {
	var l = s.length;
	var r = 0;
	while(r < l && StringTools.isSpace(s,l - r - 1)) r++;
	if(r > 0) return HxOverrides.substr(s,0,l - r); else return s;
}
StringTools.trim = function(s) {
	return StringTools.ltrim(StringTools.rtrim(s));
}
StringTools.rpad = function(s,c,l) {
	var sl = s.length;
	var cl = c.length;
	while(sl < l) if(l - sl < cl) {
		s += HxOverrides.substr(c,0,l - sl);
		sl = l;
	} else {
		s += c;
		sl += cl;
	}
	return s;
}
StringTools.lpad = function(s,c,l) {
	var ns = "";
	var sl = s.length;
	if(sl >= l) return s;
	var cl = c.length;
	while(sl < l) if(l - sl < cl) {
		ns += HxOverrides.substr(c,0,l - sl);
		sl = l;
	} else {
		ns += c;
		sl += cl;
	}
	return ns + s;
}
StringTools.replace = function(s,sub,by) {
	return s.split(sub).join(by);
}
StringTools.hex = function(n,digits) {
	var s = "";
	var hexChars = "0123456789ABCDEF";
	do {
		s = hexChars.charAt(n & 15) + s;
		n >>>= 4;
	} while(n > 0);
	if(digits != null) while(s.length < digits) s = "0" + s;
	return s;
}
StringTools.fastCodeAt = function(s,index) {
	return s.charCodeAt(index);
}
StringTools.isEOF = function(c) {
	return c != c;
}
var ValueType = $hxClasses["ValueType"] = { __ename__ : ["ValueType"], __constructs__ : ["TNull","TInt","TFloat","TBool","TObject","TFunction","TClass","TEnum","TUnknown"] }
ValueType.TNull = ["TNull",0];
ValueType.TNull.toString = $estr;
ValueType.TNull.__enum__ = ValueType;
ValueType.TInt = ["TInt",1];
ValueType.TInt.toString = $estr;
ValueType.TInt.__enum__ = ValueType;
ValueType.TFloat = ["TFloat",2];
ValueType.TFloat.toString = $estr;
ValueType.TFloat.__enum__ = ValueType;
ValueType.TBool = ["TBool",3];
ValueType.TBool.toString = $estr;
ValueType.TBool.__enum__ = ValueType;
ValueType.TObject = ["TObject",4];
ValueType.TObject.toString = $estr;
ValueType.TObject.__enum__ = ValueType;
ValueType.TFunction = ["TFunction",5];
ValueType.TFunction.toString = $estr;
ValueType.TFunction.__enum__ = ValueType;
ValueType.TClass = function(c) { var $x = ["TClass",6,c]; $x.__enum__ = ValueType; $x.toString = $estr; return $x; }
ValueType.TEnum = function(e) { var $x = ["TEnum",7,e]; $x.__enum__ = ValueType; $x.toString = $estr; return $x; }
ValueType.TUnknown = ["TUnknown",8];
ValueType.TUnknown.toString = $estr;
ValueType.TUnknown.__enum__ = ValueType;
var Type = $hxClasses["Type"] = function() { }
Type.__name__ = ["Type"];
Type.getClass = function(o) {
	if(o == null) return null;
	return o.__class__;
}
Type.getEnum = function(o) {
	if(o == null) return null;
	return o.__enum__;
}
Type.getSuperClass = function(c) {
	return c.__super__;
}
Type.getClassName = function(c) {
	var a = c.__name__;
	return a.join(".");
}
Type.getEnumName = function(e) {
	var a = e.__ename__;
	return a.join(".");
}
Type.resolveClass = function(name) {
	var cl = $hxClasses[name];
	if(cl == null || !cl.__name__) return null;
	return cl;
}
Type.resolveEnum = function(name) {
	var e = $hxClasses[name];
	if(e == null || !e.__ename__) return null;
	return e;
}
Type.createInstance = function(cl,args) {
	switch(args.length) {
	case 0:
		return new cl();
	case 1:
		return new cl(args[0]);
	case 2:
		return new cl(args[0],args[1]);
	case 3:
		return new cl(args[0],args[1],args[2]);
	case 4:
		return new cl(args[0],args[1],args[2],args[3]);
	case 5:
		return new cl(args[0],args[1],args[2],args[3],args[4]);
	case 6:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5]);
	case 7:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6]);
	case 8:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7]);
	default:
		throw "Too many arguments";
	}
	return null;
}
Type.createEmptyInstance = function(cl) {
	function empty() {}; empty.prototype = cl.prototype;
	return new empty();
}
Type.createEnum = function(e,constr,params) {
	var f = Reflect.field(e,constr);
	if(f == null) throw "No such constructor " + constr;
	if(Reflect.isFunction(f)) {
		if(params == null) throw "Constructor " + constr + " need parameters";
		return f.apply(e,params);
	}
	if(params != null && params.length != 0) throw "Constructor " + constr + " does not need parameters";
	return f;
}
Type.createEnumIndex = function(e,index,params) {
	var c = e.__constructs__[index];
	if(c == null) throw index + " is not a valid enum constructor index";
	return Type.createEnum(e,c,params);
}
Type.getInstanceFields = function(c) {
	var a = [];
	for(var i in c.prototype) a.push(i);
	HxOverrides.remove(a,"__class__");
	HxOverrides.remove(a,"__properties__");
	return a;
}
Type.getClassFields = function(c) {
	var a = Reflect.fields(c);
	HxOverrides.remove(a,"__name__");
	HxOverrides.remove(a,"__interfaces__");
	HxOverrides.remove(a,"__properties__");
	HxOverrides.remove(a,"__super__");
	HxOverrides.remove(a,"prototype");
	return a;
}
Type.getEnumConstructs = function(e) {
	var a = e.__constructs__;
	return a.slice();
}
Type["typeof"] = function(v) {
	switch(typeof(v)) {
	case "boolean":
		return ValueType.TBool;
	case "string":
		return ValueType.TClass(String);
	case "number":
		if(Math.ceil(v) == v % 2147483648.0) return ValueType.TInt;
		return ValueType.TFloat;
	case "object":
		if(v == null) return ValueType.TNull;
		var e = v.__enum__;
		if(e != null) return ValueType.TEnum(e);
		var c = v.__class__;
		if(c != null) return ValueType.TClass(c);
		return ValueType.TObject;
	case "function":
		if(v.__name__ || v.__ename__) return ValueType.TObject;
		return ValueType.TFunction;
	case "undefined":
		return ValueType.TNull;
	default:
		return ValueType.TUnknown;
	}
}
Type.enumEq = function(a,b) {
	if(a == b) return true;
	try {
		if(a[0] != b[0]) return false;
		var _g1 = 2, _g = a.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(!Type.enumEq(a[i],b[i])) return false;
		}
		var e = a.__enum__;
		if(e != b.__enum__ || e == null) return false;
	} catch( e ) {
		return false;
	}
	return true;
}
Type.enumConstructor = function(e) {
	return e[0];
}
Type.enumParameters = function(e) {
	return e.slice(2);
}
Type.enumIndex = function(e) {
	return e[1];
}
Type.allEnums = function(e) {
	var all = [];
	var cst = e.__constructs__;
	var _g = 0;
	while(_g < cst.length) {
		var c = cst[_g];
		++_g;
		var v = Reflect.field(e,c);
		if(!Reflect.isFunction(v)) all.push(v);
	}
	return all;
}
var Xml = $hxClasses["Xml"] = function() {
};
Xml.__name__ = ["Xml"];
Xml.Element = null;
Xml.PCData = null;
Xml.CData = null;
Xml.Comment = null;
Xml.DocType = null;
Xml.Prolog = null;
Xml.Document = null;
Xml.parse = function(str) {
	return haxe.xml.Parser.parse(str);
}
Xml.createElement = function(name) {
	var r = new Xml();
	r.nodeType = Xml.Element;
	r._children = new Array();
	r._attributes = new Hash();
	r.setNodeName(name);
	return r;
}
Xml.createPCData = function(data) {
	var r = new Xml();
	r.nodeType = Xml.PCData;
	r.setNodeValue(data);
	return r;
}
Xml.createCData = function(data) {
	var r = new Xml();
	r.nodeType = Xml.CData;
	r.setNodeValue(data);
	return r;
}
Xml.createComment = function(data) {
	var r = new Xml();
	r.nodeType = Xml.Comment;
	r.setNodeValue(data);
	return r;
}
Xml.createDocType = function(data) {
	var r = new Xml();
	r.nodeType = Xml.DocType;
	r.setNodeValue(data);
	return r;
}
Xml.createProlog = function(data) {
	var r = new Xml();
	r.nodeType = Xml.Prolog;
	r.setNodeValue(data);
	return r;
}
Xml.createDocument = function() {
	var r = new Xml();
	r.nodeType = Xml.Document;
	r._children = new Array();
	return r;
}
Xml.prototype = {
	toString: function() {
		if(this.nodeType == Xml.PCData) return this._nodeValue;
		if(this.nodeType == Xml.CData) return "<![CDATA[" + this._nodeValue + "]]>";
		if(this.nodeType == Xml.Comment) return "<!--" + this._nodeValue + "-->";
		if(this.nodeType == Xml.DocType) return "<!DOCTYPE " + this._nodeValue + ">";
		if(this.nodeType == Xml.Prolog) return "<?" + this._nodeValue + "?>";
		var s = new StringBuf();
		if(this.nodeType == Xml.Element) {
			s.b += Std.string("<");
			s.b += Std.string(this._nodeName);
			var $it0 = this._attributes.keys();
			while( $it0.hasNext() ) {
				var k = $it0.next();
				s.b += Std.string(" ");
				s.b += Std.string(k);
				s.b += Std.string("=\"");
				s.b += Std.string(this._attributes.get(k));
				s.b += Std.string("\"");
			}
			if(this._children.length == 0) {
				s.b += Std.string("/>");
				return s.b;
			}
			s.b += Std.string(">");
		}
		var $it1 = this.iterator();
		while( $it1.hasNext() ) {
			var x = $it1.next();
			s.b += Std.string(x.toString());
		}
		if(this.nodeType == Xml.Element) {
			s.b += Std.string("</");
			s.b += Std.string(this._nodeName);
			s.b += Std.string(">");
		}
		return s.b;
	}
	,insertChild: function(x,pos) {
		if(this._children == null) throw "bad nodetype";
		if(x._parent != null) HxOverrides.remove(x._parent._children,x);
		x._parent = this;
		this._children.splice(pos,0,x);
	}
	,removeChild: function(x) {
		if(this._children == null) throw "bad nodetype";
		var b = HxOverrides.remove(this._children,x);
		if(b) x._parent = null;
		return b;
	}
	,addChild: function(x) {
		if(this._children == null) throw "bad nodetype";
		if(x._parent != null) HxOverrides.remove(x._parent._children,x);
		x._parent = this;
		this._children.push(x);
	}
	,firstElement: function() {
		if(this._children == null) throw "bad nodetype";
		var cur = 0;
		var l = this._children.length;
		while(cur < l) {
			var n = this._children[cur];
			if(n.nodeType == Xml.Element) return n;
			cur++;
		}
		return null;
	}
	,firstChild: function() {
		if(this._children == null) throw "bad nodetype";
		return this._children[0];
	}
	,elementsNamed: function(name) {
		if(this._children == null) throw "bad nodetype";
		return { cur : 0, x : this._children, hasNext : function() {
			var k = this.cur;
			var l = this.x.length;
			while(k < l) {
				var n = this.x[k];
				if(n.nodeType == Xml.Element && n._nodeName == name) break;
				k++;
			}
			this.cur = k;
			return k < l;
		}, next : function() {
			var k = this.cur;
			var l = this.x.length;
			while(k < l) {
				var n = this.x[k];
				k++;
				if(n.nodeType == Xml.Element && n._nodeName == name) {
					this.cur = k;
					return n;
				}
			}
			return null;
		}};
	}
	,elements: function() {
		if(this._children == null) throw "bad nodetype";
		return { cur : 0, x : this._children, hasNext : function() {
			var k = this.cur;
			var l = this.x.length;
			while(k < l) {
				if(this.x[k].nodeType == Xml.Element) break;
				k += 1;
			}
			this.cur = k;
			return k < l;
		}, next : function() {
			var k = this.cur;
			var l = this.x.length;
			while(k < l) {
				var n = this.x[k];
				k += 1;
				if(n.nodeType == Xml.Element) {
					this.cur = k;
					return n;
				}
			}
			return null;
		}};
	}
	,iterator: function() {
		if(this._children == null) throw "bad nodetype";
		return { cur : 0, x : this._children, hasNext : function() {
			return this.cur < this.x.length;
		}, next : function() {
			return this.x[this.cur++];
		}};
	}
	,attributes: function() {
		if(this.nodeType != Xml.Element) throw "bad nodeType";
		return this._attributes.keys();
	}
	,exists: function(att) {
		if(this.nodeType != Xml.Element) throw "bad nodeType";
		return this._attributes.exists(att);
	}
	,remove: function(att) {
		if(this.nodeType != Xml.Element) throw "bad nodeType";
		this._attributes.remove(att);
	}
	,set: function(att,value) {
		if(this.nodeType != Xml.Element) throw "bad nodeType";
		this._attributes.set(att,value);
	}
	,get: function(att) {
		if(this.nodeType != Xml.Element) throw "bad nodeType";
		return this._attributes.get(att);
	}
	,getParent: function() {
		return this._parent;
	}
	,setNodeValue: function(v) {
		if(this.nodeType == Xml.Element || this.nodeType == Xml.Document) throw "bad nodeType";
		return this._nodeValue = v;
	}
	,getNodeValue: function() {
		if(this.nodeType == Xml.Element || this.nodeType == Xml.Document) throw "bad nodeType";
		return this._nodeValue;
	}
	,setNodeName: function(n) {
		if(this.nodeType != Xml.Element) throw "bad nodeType";
		return this._nodeName = n;
	}
	,getNodeName: function() {
		if(this.nodeType != Xml.Element) throw "bad nodeType";
		return this._nodeName;
	}
	,_parent: null
	,_children: null
	,_attributes: null
	,_nodeValue: null
	,_nodeName: null
	,parent: null
	,nodeValue: null
	,nodeName: null
	,nodeType: null
	,__class__: Xml
	,__properties__: {set_nodeName:"setNodeName",get_nodeName:"getNodeName",set_nodeValue:"setNodeValue",get_nodeValue:"getNodeValue",get_parent:"getParent"}
}
var com = com || {}
if(!com.wiris) com.wiris = {}
if(!com.wiris.calc) com.wiris.calc = {}
com.wiris.calc.CalcModel = $hxClasses["com.wiris.calc.CalcModel"] = function() { }
com.wiris.calc.CalcModel.__name__ = ["com","wiris","calc","CalcModel"];
com.wiris.calc.CalcModel.prototype = {
	getFunctionNames: null
	,getVariableNames: null
	,addCalcModelListener: null
	,reset: null
	,getXml: null
	,setXml: null
	,actionWithParams: null
	,__class__: com.wiris.calc.CalcModel
}
com.wiris.calc.CalcModelListener = $hxClasses["com.wiris.calc.CalcModelListener"] = function() { }
com.wiris.calc.CalcModelListener.__name__ = ["com","wiris","calc","CalcModelListener"];
com.wiris.calc.CalcModelListener.prototype = {
	calcModelRebuilt: null
	,removeCookie: null
	,saveCookie: null
	,interfaceLanguageChanged: null
	,contentChanged: null
	,authorizationRequested: null
	,plotterDownloadRequested: null
	,downloadRequested: null
	,closeDialogRequested: null
	,openToolkitDialogRequested: null
	,openDialogRequested: null
	,openLinkRequested: null
	,uploadFileRequested: null
	,removeFileRequested: null
	,openFileRequested: null
	,saveFileRequested: null
	,newFileRequested: null
	,__class__: com.wiris.calc.CalcModelListener
}
if(!com.wiris.calc.dialog) com.wiris.calc.dialog = {}
com.wiris.calc.dialog.DialogModel = $hxClasses["com.wiris.calc.dialog.DialogModel"] = function() { }
com.wiris.calc.dialog.DialogModel.__name__ = ["com","wiris","calc","dialog","DialogModel"];
if(!com.wiris.common) com.wiris.common = {}
com.wiris.common.WInteger = $hxClasses["com.wiris.common.WInteger"] = function() { }
com.wiris.common.WInteger.__name__ = ["com","wiris","common","WInteger"];
com.wiris.common.WInteger.max = function(x,y) {
	if(x > y) return x;
	return y;
}
com.wiris.common.WInteger.min = function(x,y) {
	if(x < y) return x;
	return y;
}
com.wiris.common.WInteger.toHex = function(x,digits) {
	var s = "";
	while(x != 0 && digits > 0) {
		digits--;
		var d = x & 15;
		s = com.wiris.system.Utf8.uchr(d + (d >= 10?55:48)) + s;
		x = x >> 4;
	}
	while(digits-- > 0) s = "0" + s;
	return s;
}
com.wiris.common.WInteger.parseHex = function(str) {
	return Std.parseInt("0x" + str);
}
com.wiris.common.WInteger.isInteger = function(str) {
	str = StringTools.trim(str);
	var i = 0;
	var n = str.length;
	if(StringTools.startsWith(str,"-")) i++;
	if(StringTools.startsWith(str,"+")) i++;
	var c;
	while(i < n) {
		c = HxOverrides.cca(str,i);
		if(c < 48 || c > 57) return false;
		i++;
	}
	return true;
}
if(!com.wiris.editor) com.wiris.editor = {}
com.wiris.editor.EditorListener = $hxClasses["com.wiris.editor.EditorListener"] = function() { }
com.wiris.editor.EditorListener.__name__ = ["com","wiris","editor","EditorListener"];
com.wiris.editor.EditorListener.prototype = {
	transformationReceived: null
	,styleChanged: null
	,contentChanged: null
	,clipboardChanged: null
	,caretPositionChanged: null
	,__class__: com.wiris.editor.EditorListener
}
if(!com.wiris.graph) com.wiris.graph = {}
com.wiris.graph.GraphInterface = $hxClasses["com.wiris.graph.GraphInterface"] = function() { }
com.wiris.graph.GraphInterface.__name__ = ["com","wiris","graph","GraphInterface"];
com.wiris.graph.GraphInterface.prototype = {
	getGraphModel: null
	,close: null
	,__class__: com.wiris.graph.GraphInterface
}
com.wiris.graph.GraphModel = $hxClasses["com.wiris.graph.GraphModel"] = function() { }
com.wiris.graph.GraphModel.__name__ = ["com","wiris","graph","GraphModel"];
com.wiris.graph.GraphModel.prototype = {
	setDisplaySetting: null
	,changeMode: null
	,setHidingActionsEnabled: null
	,activateMainAction: null
	,exitViewOnly: null
	,enterViewOnly: null
	,setAwakeMode: null
	,insertInto: null
	,getGraphComponent: null
	,getDisplay: null
	,updateGraphToolbar: null
	,__class__: com.wiris.graph.GraphModel
}
if(!com.wiris.hand) com.wiris.hand = {}
com.wiris.hand.HandInterface = $hxClasses["com.wiris.hand.HandInterface"] = function() { }
com.wiris.hand.HandInterface.__name__ = ["com","wiris","hand","HandInterface"];
com.wiris.hand.HandInterface.prototype = {
	setParams: null
	,setStrokes: null
	,getStrokes: null
	,setMathML: null
	,getMathMLWithStrokes: null
	,getMathML: null
	,addHandListener: null
	,insertInto: null
	,__class__: com.wiris.hand.HandInterface
}
com.wiris.hand.HandListener = $hxClasses["com.wiris.hand.HandListener"] = function() { }
com.wiris.hand.HandListener.__name__ = ["com","wiris","hand","HandListener"];
com.wiris.hand.HandListener.prototype = {
	strokesChanged: null
	,recognitionError: null
	,contentChanged: null
	,__class__: com.wiris.hand.HandListener
}
if(!com.wiris.kernel) com.wiris.kernel = {}
if(!com.wiris.kernel.plotter) com.wiris.kernel.plotter = {}
com.wiris.kernel.plotter.QuizzesCorrectAnswerPlotter = $hxClasses["com.wiris.kernel.plotter.QuizzesCorrectAnswerPlotter"] = function() { }
com.wiris.kernel.plotter.QuizzesCorrectAnswerPlotter.__name__ = ["com","wiris","kernel","plotter","QuizzesCorrectAnswerPlotter"];
com.wiris.kernel.plotter.QuizzesCorrectAnswerPlotter.prototype = {
	getElementsThatCanBeGraded: null
	,getElementsToGrade: null
	,__class__: com.wiris.kernel.plotter.QuizzesCorrectAnswerPlotter
}
com.wiris.kernel.plotter.QuizzesCorrectAnswerPlotterParameters = $hxClasses["com.wiris.kernel.plotter.QuizzesCorrectAnswerPlotterParameters"] = function() {
	this.isSketch = false;
	this.includeImages = false;
	this.includeStatisticsCharts = false;
	this.includePartsOfElements = false;
	this.includeLabelsOfElements = false;
};
com.wiris.kernel.plotter.QuizzesCorrectAnswerPlotterParameters.__name__ = ["com","wiris","kernel","plotter","QuizzesCorrectAnswerPlotterParameters"];
com.wiris.kernel.plotter.QuizzesCorrectAnswerPlotterParameters.prototype = {
	isSketch: null
	,includeImages: null
	,includeStatisticsCharts: null
	,includePartsOfElements: null
	,includeLabelsOfElements: null
	,__class__: com.wiris.kernel.plotter.QuizzesCorrectAnswerPlotterParameters
}
if(!com.wiris.util) com.wiris.util = {}
if(!com.wiris.util.graphics) com.wiris.util.graphics = {}
com.wiris.util.graphics.Display = $hxClasses["com.wiris.util.graphics.Display"] = function() { }
com.wiris.util.graphics.Display.__name__ = ["com","wiris","util","graphics","Display"];
com.wiris.util.graphics.Display.prototype = {
	getInitialContent: null
	,getAllHiddenElements: null
	,setInitialContent: null
	,dispose: null
	,loadGeometryFile: null
	,getGeometryFile: null
	,setCursor: null
	,unfreeze: null
	,freeze: null
	,canUndo: null
	,canRedo: null
	,setId: null
	,getId: null
	,redoAction: null
	,undoAction: null
	,removeDisplayListeners: null
	,addDisplayDrawingListener: null
	,addDisplayListener: null
	,cancelAction: null
	,startAction: null
	,useCurrentActionParameters: null
	,setActionParameters: null
	,setActionParameter: null
	,pointerLeave: null
	,pointerEnter: null
	,pointerDrag: null
	,strokesDrawn: null
	,pointerMove: null
	,pointerUp: null
	,pointerDown: null
	,invalidate: null
	,animateFrame: null
	,update: null
	,isEmpty: null
	,setOption: null
	,setOptionDictionary: null
	,getOptionDictionary: null
	,__class__: com.wiris.util.graphics.Display
}
com.wiris.kernel.plotter.QuizzesValidationPlotter = $hxClasses["com.wiris.kernel.plotter.QuizzesValidationPlotter"] = function() { }
com.wiris.kernel.plotter.QuizzesValidationPlotter.__name__ = ["com","wiris","kernel","plotter","QuizzesValidationPlotter"];
com.wiris.kernel.plotter.QuizzesValidationPlotter.__interfaces__ = [com.wiris.util.graphics.Display];
com.wiris.kernel.plotter.QuizzesValidationPlotter.prototype = {
	unfocusElement: null
	,focusElement: null
	,setElementTolerances: null
	,setElementTolerance: null
	,getElementSummary: null
	,__class__: com.wiris.kernel.plotter.QuizzesValidationPlotter
}
if(!com.wiris.quizzes) com.wiris.quizzes = {}
if(!com.wiris.quizzes.api) com.wiris.quizzes.api = {}
if(!com.wiris.quizzes.api.ui) com.wiris.quizzes.api.ui = {}
com.wiris.quizzes.api.ui.MathViewer = $hxClasses["com.wiris.quizzes.api.ui.MathViewer"] = function() { }
com.wiris.quizzes.api.ui.MathViewer.__name__ = ["com","wiris","quizzes","api","ui","MathViewer"];
com.wiris.quizzes.api.ui.MathViewer.prototype = {
	filterConstructions: null
	,filterMathML: null
	,filter: null
	,graph: null
	,thumbnail: null
	,plot: null
	,render: null
	,renderCorrectAnswer: null
	,__class__: com.wiris.quizzes.api.ui.MathViewer
}
com.wiris.quizzes.HxMathViewer = $hxClasses["com.wiris.quizzes.HxMathViewer"] = function() {
	this.zoom = 1.0;
	this.centerBaseline = true;
	this.renderOffline = com.wiris.quizzes.api.Quizzes.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.RESOURCES_STATIC) == "true";
};
com.wiris.quizzes.HxMathViewer.__name__ = ["com","wiris","quizzes","HxMathViewer"];
com.wiris.quizzes.HxMathViewer.__interfaces__ = [com.wiris.quizzes.api.ui.MathViewer];
com.wiris.quizzes.HxMathViewer.prototype = {
	setMathMLAltText: function(img,mathml) {
		var c = com.wiris.quizzes.api.Quizzes.getInstance().getConfiguration();
		var url;
		if("true" == c.get(com.wiris.quizzes.api.ConfigurationKeys.CROSSORIGINCALLS_ENABLED)) url = c.get(com.wiris.quizzes.api.ConfigurationKeys.EDITOR_URL) + "/mathml2accessible?"; else url = c.get(com.wiris.quizzes.api.ConfigurationKeys.PROXY_URL) + "?service=mathml2accessible";
		url += "&stats-app=quizzes";
		var http = new haxe.Http(url);
		http.setParameter("mml",mathml);
		http.async = true;
		http.onData = function(data) {
			img.alt = data;
		};
		http.onError = function(error) {
			img.alt = error;
		};
		http.request(true);
	}
	,renderImage: function(mathml) {
		var img = js.Lib.document.createElement("img");
		var c = com.wiris.quizzes.api.Quizzes.getInstance().getConfiguration();
		var editorUrl = c.get(com.wiris.quizzes.api.ConfigurationKeys.EDITOR_URL);
		var proxyUrl = c.get(com.wiris.quizzes.api.ConfigurationKeys.PROXY_URL);
		var crossOriginEnabled = "true" == c.get(com.wiris.quizzes.api.ConfigurationKeys.CROSSORIGINCALLS_ENABLED);
		img.src = com.wiris.quizzes.impl.HTMLTools.mathMLImgSrc(mathml,this.centerBaseline,this.zoom,editorUrl,proxyUrl,crossOriginEnabled);
		img.align = "middle";
		img.className = "wirismathml";
		this.setMathMLAltText(img,mathml);
		return img;
	}
	,setCenterBaseline: function(centerBaseline) {
		this.centerBaseline = centerBaseline;
	}
	,setZoom: function(zoom) {
		this.zoom = zoom;
	}
	,graphImpl: function(construction,initialContent,container) {
		var _g = this;
		if(this.graphJSLoaded() && container.parentNode != null) {
			var graph = window.com.wiris.js.JsGraph.newInstance({ 
				viewOnly: true,
				allowAnimations: true
			});
			if(initialContent != null) graph.getGraphModel().getDisplay().setInitialContent(initialContent,true);
			graph.setContent(construction);
			graph.insertInto(container);
		} else haxe.Timer.delay(function() {
			_g.graphImpl(construction,initialContent,container);
		},100);
	}
	,graph: function(construction,initialContent) {
		if(!this.graphJSLoaded()) this.loadGraphJS();
		var div = js.Lib.document.createElement("div");
		this.graphImpl(construction,initialContent,div);
		return div;
	}
	,plotJS: function(construction,container,width,height) {
		var _g = this;
		if(this.graphJSLoaded() && container.offsetParent != null) {
			if(this.graphViewer == null) this.graphViewer = window.com.wiris.js.JsGraphViewer.newInstance(null);
			this.graphViewer.geometryFile2Canvas(construction,container,width,height);
		} else haxe.Timer.delay(function() {
			_g.plotJS(construction,container,width,height);
		},100);
	}
	,plotConstruction: function(construction,width,height) {
		var img = js.Lib.document.createElement("img");
		img.src = com.wiris.quizzes.impl.QuizzesImpl.getInstance().getResourceUrl("plotter_loading.png");
		img.align = "middle";
		img.className = "wirisgraphic";
		img.width = width;
		img.height = height;
		var c = com.wiris.quizzes.api.Quizzes.getInstance().getConfiguration();
		var url;
		if("true" == c.get(com.wiris.quizzes.api.ConfigurationKeys.CROSSORIGINCALLS_ENABLED)) url = c.get(com.wiris.quizzes.api.ConfigurationKeys.GRAPH_URL) + "/plot.png?"; else url = c.get(com.wiris.quizzes.api.ConfigurationKeys.PROXY_URL) + "?service=plot.png.base64";
		url += "&stats-app=quizzes";
		var http = new haxe.Http(url);
		http.setHeader("Accept","text/plain");
		http.setParameter("gf",construction);
		http.setParameter("width",width + "");
		http.setParameter("height",height + "");
		http.async = true;
		http.onData = function(data) {
			img.src = "data:image/png;base64, " + data;
		};
		http.request(true);
		return img;
	}
	,plotImpl: function(construction,width,height) {
		var container;
		if(this.renderOffline) {
			if(!this.graphJSLoaded()) this.loadGraphJS();
			container = js.Lib.document.createElement("div");
			this.plotJS(construction,container,width,height);
		} else container = this.plotConstruction(construction,width,height);
		return container;
	}
	,thumbnail: function(construction) {
		return this.plotImpl(construction,com.wiris.quizzes.HxMathViewer.THUMBNAIL_WIDTH,com.wiris.quizzes.HxMathViewer.THUMBNAIL_HEIGHT);
	}
	,getDimensionOrDefault: function(arg,width) {
		if(arg != null) {
			var parsed = Std.parseInt(arg);
			if(parsed != null && parsed > 0) return parsed;
		}
		return width?com.wiris.quizzes.HxMathViewer.PLOT_WIDTH:com.wiris.quizzes.HxMathViewer.PLOT_HEIGHT;
	}
	,plot: function(construction,widthArg,heightArg) {
		var width = this.getDimensionOrDefault(widthArg,true);
		var height = this.getDimensionOrDefault(heightArg,false);
		return this.plotImpl(construction,width,height);
	}
	,loadViewer: function() {
		if(this.isOffline()) {
			var url = com.wiris.quizzes.api.Quizzes.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.EDITOR_URL);
			this.viewer = new window.com.wiris.js.JsViewerMain(url);
		} else this.viewer = js.Lib.window.com.wiris.js.JsViewerMain.newInstance();
		this.viewer.insertCSS(null,null);
	}
	,isOffline: function() {
		var offline = com.wiris.quizzes.api.Quizzes.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.SERVICE_OFFLINE);
		return offline.toLowerCase() == "true";
	}
	,loadGraphJS: function() {
		var win = js.Lib.window;
		if(win.com_wiris_quizzes_isGraphScript == null) {
			win.com_wiris_quizzes_isGraphScript = true;
			var d = js.Lib.document;
			var script = d.createElement("script");
			script.setAttribute("type","text/javascript");
			var url = com.wiris.quizzes.api.Quizzes.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.GRAPH_URL) + "/graph.js";
			script.setAttribute("src",url);
			d.getElementsByTagName("head")[0].appendChild(script);
		}
	}
	,loadViewerJS: function() {
		var win = js.Lib.window;
		if(win.com_wiris_quizzes_isViewerScript == null) {
			win.com_wiris_quizzes_isViewerScript = true;
			var d = js.Lib.document;
			var script = d.createElement("script");
			script.setAttribute("type","text/javascript");
			var url;
			if(this.isOffline()) url = com.wiris.quizzes.api.Quizzes.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.EDITOR_URL) + "/viewer_offline.js"; else url = com.wiris.quizzes.api.Quizzes.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.EDITOR_URL) + "/viewer";
			script.setAttribute("src",url);
			d.getElementsByTagName("head")[0].appendChild(script);
		}
	}
	,graphJSLoaded: function() {
		var win = js.Lib.window;
		return win.com != null && win.com.wiris != null && win.com.wiris.js != null && win.com.wiris.js.JsGraphViewer != null;
	}
	,viewerJSLoaded: function() {
		var win = js.Lib.window;
		return win.com != null && win.com.wiris != null && win.com.wiris.js != null && win.com.wiris.js.JsViewerMain != null;
	}
	,exposeViewer: function() {
		var _g = this;
		if(!this.viewerJSLoaded()) this.loadViewerJS();
		var win = js.Lib.window;
		if(this.viewerJSLoaded()) {
			var url = com.wiris.quizzes.api.Quizzes.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.EDITOR_URL);
			if (win.viewer == null) win.viewer = new window.com.wiris.js.JsViewerMain(url);
		} else haxe.Timer.delay(function() {
			_g.exposeViewer();
		},100);
	}
	,renderJS: function(mathml,container) {
		var _g = this;
		if(this.viewerJSLoaded() && container.offsetParent != null) {
			if(this.viewer == null) this.loadViewer();
			this.viewer.paintFormulaOnContainer(mathml,container,null);
		} else haxe.Timer.delay(function() {
			_g.renderJS(mathml,container);
		},100);
	}
	,unescapeIfNecessary: function(s) {
		if(s != null && s.indexOf("<") == -1 && s.indexOf(">") == -1 && s.indexOf("\"") == -1 && (s.indexOf("&lt;") != -1 || s.indexOf("&gt;") != -1 || s.indexOf("&quot;") != -1)) return com.wiris.util.xml.WXmlUtils.htmlUnescape(s);
		return s;
	}
	,filterConstructions: function(root) {
		var plotters = com.wiris.quizzes.JsDomUtils.getElementsByClassName("wirisconstruction",null,root);
		var n = plotters.length - 1;
		while(n >= 0) {
			var imgTag = plotters[n];
			var construction = imgTag.getAttribute("data-wirisconstruction");
			var initialContent = imgTag.getAttribute("data-wirisinitialcontent");
			var width = imgTag.getAttribute("data-wiriswidth");
			var height = imgTag.getAttribute("data-wirisheight");
			var canvas;
			if(imgTag.className.indexOf("wirisgraphanimate") > -1) canvas = this.graph(this.unescapeIfNecessary(construction),this.unescapeIfNecessary(initialContent)); else canvas = this.plot(this.unescapeIfNecessary(construction),width,height);
			imgTag.parentNode.replaceChild(canvas,imgTag);
			n--;
		}
	}
	,getOuterHTMLIE11: function(elem) {
		var a = elem.ownerDocument.createElement("div");
		a.appendChild(elem.cloneNode(true));
		return a.innerHTML;
	}
	,filterMathML: function(root) {
		var maths = root.getElementsByTagName("math");
		var n = maths.length - 1;
		while(n >= 0) {
			var elem = maths[n];
			var mathml = elem.outerHTML || this.getOuterHTMLIE11(elem);
			var render = this.render(mathml);
			elem.parentNode.replaceChild(render,elem);
			n--;
		}
	}
	,filter: function(root) {
		this.filterMathML(root);
		this.filterConstructions(root);
	}
	,render: function(mathml) {
		var container;
		if(this.renderOffline) {
			container = js.Lib.document.createElement("span");
			if(!this.viewerJSLoaded()) this.loadViewerJS();
			this.renderJS(mathml,container);
		} else container = this.renderImage(mathml);
		return container;
	}
	,renderCorrectAnswer: function(instance,slot,authorAnswer) {
		if(slot.getSyntax().getName() == com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC) return this.graph(authorAnswer.getValue(),slot.getInitialContent()); else {
			var value = authorAnswer.getValue();
			var valueExpanded = instance.expandVariablesMathML(value);
			return this.render(valueExpanded);
		}
	}
	,graphViewer: null
	,viewer: null
	,centerBaseline: null
	,renderOffline: null
	,zoom: null
	,__class__: com.wiris.quizzes.HxMathViewer
}
com.wiris.quizzes.JsDomUtils = $hxClasses["com.wiris.quizzes.JsDomUtils"] = function() { }
com.wiris.quizzes.JsDomUtils.__name__ = ["com","wiris","quizzes","JsDomUtils"];
com.wiris.quizzes.JsDomUtils.getElementsByClassName = function(className,tagName,element) {
	if(element == null) element = js.Lib.document;
	if(tagName == null) tagName = "*";
	try {
		if(typeof(element.getElementsByClassName) != 'undefined') return element.getElementsByClassName(className,tagName);
	} catch( e ) {
	}
	var elements = element.getElementsByTagName(tagName);
	var selected = new Array();
	var i;
	var n = elements.length;
	var _g = 0;
	while(_g < n) {
		var i1 = _g++;
		var elem = elements[i1];
		if(com.wiris.quizzes.JsDomUtils.hasClass(elem,className)) selected.push(elem);
	}
	return selected;
}
com.wiris.quizzes.JsDomUtils.hasClass = function(elem,className) {
	return elem.nodeType == 1 && (" " + elem.className + " ").indexOf(" " + className + " ") >= 0;
}
com.wiris.quizzes.JsDomUtils.addClass = function(element,className) {
	element.className = com.wiris.quizzes.JsDomUtils.addClassToString(element.className,className);
}
com.wiris.quizzes.JsDomUtils.removeClass = function(element,className) {
	element.className = com.wiris.quizzes.JsDomUtils.removeClassFromString(element.className,className);
}
com.wiris.quizzes.JsDomUtils.hasClassString = function(elemClass,className) {
	return elemClass != null && (" " + elemClass + " ").indexOf(" " + className + " ") >= 0;
}
com.wiris.quizzes.JsDomUtils.addClassToString = function(str,className) {
	if(!com.wiris.quizzes.JsDomUtils.hasClassString(str,className)) {
		if(str == null || str.length == 0) str = className; else str += " " + className;
	}
	return str;
}
com.wiris.quizzes.JsDomUtils.removeClassFromString = function(elemClass,className) {
	if(com.wiris.quizzes.JsDomUtils.hasClassString(elemClass,className)) {
		elemClass = StringTools.replace(elemClass," " + className + " "," ");
		if(StringTools.startsWith(elemClass,className + " ")) elemClass = HxOverrides.substr(elemClass,className.length + 1,null);
		if(StringTools.endsWith(elemClass," " + className)) elemClass = HxOverrides.substr(elemClass,0,elemClass.length - (className.length + 1));
		if(elemClass == className) elemClass = "";
	}
	return elemClass;
}
com.wiris.quizzes.JsDomUtils.addEvent = function(element,event,func) {
	var useCapture = false;
	if(event == "focusin" || event == "focusout") {
		if(!'onfocusin' in window) {
			event = event == "focusin"?"focus":"blur";
			useCapture = true;
		}
	}
	if(element.addEventListener) element.addEventListener(event,func,useCapture); else if(element.attachEvent) element.attachEvent("on" + event,func);
}
com.wiris.quizzes.JsDomUtils.removeEvent = function(element,event,func) {
	if(element.removeEventListener) element.removeEventListener(event,func,false); else if(element.detachEvent) element.detachEvent("on" + event,func);
}
com.wiris.quizzes.JsDomUtils.getNearestElementByClassName = function(element,className) {
	var target = com.wiris.quizzes.JsDomUtils.getChildByClassName(element,className);
	while(target == null && element.parentNode != null) {
		var brothers = element.parentNode.childNodes;
		var i = 0;
		var n = brothers.length;
		while(target == null && i < n) {
			var brother = brothers[i];
			if(element != brother) target = com.wiris.quizzes.JsDomUtils.getChildByClassName(brother,className);
			i++;
		}
		element = element.parentNode;
	}
	return target;
}
com.wiris.quizzes.JsDomUtils.getChildByClassName = function(element,className) {
	if(com.wiris.quizzes.JsDomUtils.hasClass(element,className)) return element; else if(element.hasChildNodes()) {
		var i;
		var n = element.childNodes.length;
		var _g = 0;
		while(_g < n) {
			var i1 = _g++;
			var target = com.wiris.quizzes.JsDomUtils.getChildByClassName(element.childNodes[i1],className);
			if(target != null) return target;
		}
	}
	return null;
}
com.wiris.quizzes.JsDomUtils.loadFilePost = function(elem,url,func,params) {
	var d = elem.ownerDocument;
	var iframe = d.createElement("iframe");
	var submitted = false;
	com.wiris.quizzes.JsDomUtils.addEvent(iframe,"load",function(e) {
		if(submitted) {
			var node = iframe.contentWindow.document.body.firstChild;
			while(node.nodeType != 3) node = node.firstChild;
			var text = node.nodeValue;
			while(node.nextSibling != null) {
				node = node.nextSibling;
				text += node.nodeValue;
			}
			elem.removeChild(iframe);
			func(text);
		}
	});
	elem.appendChild(iframe);
	var form = com.wiris.quizzes.JsDomUtils.createForm(iframe.contentWindow.document,url,params);
	form.setAttribute("enctype","multipart/form-data");
	var fileInput = d.createElement("input");
	fileInput.setAttribute("name","data");
	fileInput.setAttribute("type","file");
	form.appendChild(fileInput);
	com.wiris.quizzes.JsDomUtils.addEvent(fileInput,"change",function(e) {
		iframe.contentWindow.document.body.appendChild(form);
		submitted = true;
		form.submit();
	});
	fileInput.click();
}
com.wiris.quizzes.JsDomUtils.loadFile = function(elem,url,func,params) {
	try {
		var browser = new com.wiris.system.JsBrowser();
		if(browser.isIE() || browser.isEdge()) {
			var temp = js.Lib.document.createElement("div");
			temp.style.display = "none";
			js.Lib.document.body.appendChild(temp);
			com.wiris.system.JsDOMUtils.loadTextFile(temp,function(content) {
				js.Lib.document.body.removeChild(temp);
				com.wiris.quizzes.JsDomUtils.getDocumentWindow(elem.ownerDocument).focus();
				func(content);
			});
		} else com.wiris.system.JsDOMUtils.loadTextFile(elem,func);
	} catch( e ) {
		if(url != null) com.wiris.quizzes.JsDomUtils.loadFilePost(elem,url,func,params); else throw e;
	}
}
com.wiris.quizzes.JsDomUtils.saveFile = function(elem,url,filename,contents,params) {
	try {
		com.wiris.system.JsDOMUtils.saveTextFile(elem,filename,"application/xml",contents);
	} catch( e ) {
		if(url != null) com.wiris.quizzes.JsDomUtils.saveFilePost(elem,url,filename,contents,params); else throw e;
	}
}
com.wiris.quizzes.JsDomUtils.saveFilePost = function(elem,url,filename,contents,params) {
	var d = elem.ownerDocument;
	var iframe = d.createElement("iframe");
	var submitted = false;
	com.wiris.quizzes.JsDomUtils.addEvent(iframe,"load",function(e) {
		if(!submitted) {
			submitted = true;
			var iframedoc = iframe.contentWindow.document;
			params.set("data",contents);
			params.set("filename",filename);
			var form = com.wiris.quizzes.JsDomUtils.createForm(iframedoc,url,params);
			iframedoc.body.appendChild(form);
			form.submit();
		} else elem.removeChild(iframe);
	});
	elem.appendChild(iframe);
}
com.wiris.quizzes.JsDomUtils.createForm = function(d,action,items) {
	var form = d.createElement("form");
	form.setAttribute("action",action);
	form.setAttribute("method","POST");
	var $it0 = items.keys();
	while( $it0.hasNext() ) {
		var name = $it0.next();
		var input = d.createElement("input");
		input.setAttribute("type","hidden");
		input.setAttribute("name",name);
		input.setAttribute("value",items.get(name));
		form.appendChild(input);
	}
	return form;
}
com.wiris.quizzes.JsDomUtils.getComputedStyle = function(d,x,styleProp) {
	if(x.currentStyle) return x.currentStyle[styleProp]; else if(window.getComputedStyle) return d.defaultView.getComputedStyle(x,null).getPropertyValue(styleProp); else return null;
}
com.wiris.quizzes.JsDomUtils.isImageLoaded = function(image) {
	return image.complete && image.naturalWidth === undefined || image.naturalWidth != 0;
}
com.wiris.quizzes.JsDomUtils.getImageNaturalSize = function(image,f) {
	if(image.naturalWidth !== undefined) f(image.naturalWidth,image.naturalHeight); else {
		var aux = js.Lib.document.createElement("img");
		aux.src = image.src;
		if(aux.complete) f(aux.width,aux.height); else com.wiris.quizzes.JsDomUtils.addEvent(aux,"load",function(e) {
			f(aux.width,aux.height);
		});
	}
}
com.wiris.quizzes.JsDomUtils.getEventTarget = function(e) {
	return e.target?e.target:e.srcElement;
}
com.wiris.quizzes.JsDomUtils.addScript = function(d,win,url) {
	com.wiris.system.JsDOMUtils.addScript(d,win,url);
}
com.wiris.quizzes.JsDomUtils.removeDuplicatedCSS = function(d,source,name) {
	var head = d.getElementsByTagName("head")[0];
	var links = head.getElementsByTagName("link");
	var i = 0;
	var n = links.length;
	var found = false;
	while(i < n) {
		var link = links[i];
		var type = link.getAttribute("type");
		if(type == "text/css") {
			var href = link.getAttribute("href");
			var k = href.indexOf(source);
			if(k >= 0) {
				if(found && href.indexOf(name,k + 1) >= 0) {
					head.removeChild(link);
					i--;
					n--;
				}
			} else if(!found && href.indexOf(name) > -1) {
				found = true;
				i = 0;
			}
		}
		i++;
	}
}
com.wiris.quizzes.JsDomUtils.getDocumentWindow = function(doc) {
	var ownerWindow = null;
	if('defaultView' in doc) ownerWindow = doc.defaultView; else if('parentWindow' in doc) ownerWindow = doc.parentWindow;
	return ownerWindow;
}
com.wiris.quizzes.api.ui.QuizzesComponent = $hxClasses["com.wiris.quizzes.api.ui.QuizzesComponent"] = function() { }
com.wiris.quizzes.api.ui.QuizzesComponent.__name__ = ["com","wiris","quizzes","api","ui","QuizzesComponent"];
com.wiris.quizzes.api.ui.QuizzesComponent.prototype = {
	getElement: null
	,__class__: com.wiris.quizzes.api.ui.QuizzesComponent
}
com.wiris.quizzes.api.ui.QuizzesField = $hxClasses["com.wiris.quizzes.api.ui.QuizzesField"] = function() { }
com.wiris.quizzes.api.ui.QuizzesField.__name__ = ["com","wiris","quizzes","api","ui","QuizzesField"];
com.wiris.quizzes.api.ui.QuizzesField.__interfaces__ = [com.wiris.quizzes.api.ui.QuizzesComponent];
com.wiris.quizzes.api.ui.QuizzesField.prototype = {
	setReadOnly: null
	,addQuizzesFieldListener: null
	,setValue: null
	,getValue: null
	,__class__: com.wiris.quizzes.api.ui.QuizzesField
}
com.wiris.quizzes.api.ui.AuthoringField = $hxClasses["com.wiris.quizzes.api.ui.AuthoringField"] = function() { }
com.wiris.quizzes.api.ui.AuthoringField.__name__ = ["com","wiris","quizzes","api","ui","AuthoringField"];
com.wiris.quizzes.api.ui.AuthoringField.__interfaces__ = [com.wiris.quizzes.api.ui.QuizzesField];
com.wiris.quizzes.api.ui.AuthoringField.prototype = {
	showAnswerFieldPlainText: null
	,showAnswerFieldPopupEditor: null
	,showAnswerFieldInlineEditor: null
	,showGraphicSyntax: null
	,showGradingFunction: null
	,showAuxiliaryTextInput: null
	,showAuxiliarTextInput: null
	,showAuxiliaryCasReplaceEditor: null
	,showAuxiliarCasReplaceEditor: null
	,showAuxiliaryCas: null
	,showAuxiliarCas: null
	,showCorrectAnswer: null
	,showGradingCriteria: null
	,showVariablesDefinition: null
	,showPreviewTab: null
	,showVariablesTab: null
	,showValidationTab: null
	,showCorrectAnswerTab: null
	,setConfiguration: null
	,getFieldType: null
	,setFieldType: null
	,__class__: com.wiris.quizzes.api.ui.AuthoringField
}
com.wiris.quizzes.api.ui.EmbeddedAnswersEditor = $hxClasses["com.wiris.quizzes.api.ui.EmbeddedAnswersEditor"] = function() { }
com.wiris.quizzes.api.ui.EmbeddedAnswersEditor.__name__ = ["com","wiris","quizzes","api","ui","EmbeddedAnswersEditor"];
com.wiris.quizzes.api.ui.EmbeddedAnswersEditor.__interfaces__ = [com.wiris.quizzes.api.ui.AuthoringField];
com.wiris.quizzes.api.ui.EmbeddedAnswersEditor.prototype = {
	setEditableElement: null
	,newEmbeddedAuthoringElement: null
	,filterHTML: null
	,analyzeHTML: null
	,__class__: com.wiris.quizzes.api.ui.EmbeddedAnswersEditor
}
if(!com.wiris.quizzes.impl) com.wiris.quizzes.impl = {}
if(!com.wiris.quizzes.impl.ui) com.wiris.quizzes.impl.ui = {}
com.wiris.quizzes.impl.ui.EmbeddedAnswersEditorImpl = $hxClasses["com.wiris.quizzes.impl.ui.EmbeddedAnswersEditorImpl"] = function(question,questionInstance,componentBuilder) {
	this.question = question;
	this.questionInstance = questionInstance;
	this.componentBuilder = componentBuilder;
	this.globalContext = com.wiris.quizzes.impl.ui.QuizzesContext.getInstance();
	this.embeddedAuthoringFields = new Array();
};
com.wiris.quizzes.impl.ui.EmbeddedAnswersEditorImpl.__name__ = ["com","wiris","quizzes","impl","ui","EmbeddedAnswersEditorImpl"];
com.wiris.quizzes.impl.ui.EmbeddedAnswersEditorImpl.__interfaces__ = [com.wiris.quizzes.api.ui.EmbeddedAnswersEditor,com.wiris.quizzes.api.ui.AuthoringField];
com.wiris.quizzes.impl.ui.EmbeddedAnswersEditorImpl.prototype = {
	destroyAuthoringField: function(authoringField) {
		HxOverrides.remove(this.embeddedAuthoringFields,authoringField);
	}
	,getElement: function() {
		return null;
	}
	,setReadOnly: function(readOnly) {
	}
	,addQuizzesFieldListener: function(listener) {
	}
	,setValue: function(value) {
	}
	,getValue: function() {
		return null;
	}
	,getQuestion: function() {
		return this.question;
	}
	,showAnswerFieldPlainText: function(visible) {
	}
	,showAnswerFieldPopupEditor: function(visible) {
	}
	,showAnswerFieldInlineEditor: function(visible) {
	}
	,showGraphicSyntax: function(visible) {
	}
	,showGradingFunction: function(visible) {
	}
	,showAuxiliaryTextInput: function(visible) {
	}
	,showAuxiliaryCasReplaceEditor: function(visible) {
	}
	,showAuxiliaryCas: function(visible) {
	}
	,showAuxiliarTextInput: function(visible) {
	}
	,showAuxiliarCasReplaceEditor: function(visible) {
	}
	,showAuxiliarCas: function(visible) {
	}
	,showCorrectAnswer: function(visible) {
	}
	,showGradingCriteria: function(visible) {
	}
	,showVariablesDefinition: function(visible) {
	}
	,showPreviewTab: function(visible) {
	}
	,showVariablesTab: function(visible) {
	}
	,showValidationTab: function(visible) {
	}
	,showCorrectAnswerTab: function(visible) {
	}
	,setConfiguration: function(configuration) {
	}
	,getFieldType: function() {
		return com.wiris.quizzes.api.ui.AuthoringFieldType.EMBEDDED_ANSWERS_EDITOR;
	}
	,setFieldType: function(type) {
		if(type != com.wiris.quizzes.api.ui.AuthoringFieldType.EMBEDDED_ANSWERS_EDITOR) throw "Invalid parameter type.";
	}
	,buildEmbeddedAuthoringElement: function(slot,authorAnswer) {
		var context = new com.wiris.quizzes.impl.ui.QuizzesStudioContext(this.question,slot,authorAnswer);
		context.setOptAnswerFieldInlineEditor(false);
		var embeddedElement = new com.wiris.quizzes.impl.ui.EmbeddedAuthoringField(context,this.componentBuilder);
		embeddedElement.setEmbeddedAnswersEditor(this);
		this.embeddedAuthoringFields.push(embeddedElement);
		return embeddedElement;
	}
	,setEditableElement: function(element) {
		this.editableElement = element;
		this.analyzeHTML();
	}
	,newEmbeddedAuthoringElement: function() {
		var slot = this.question.addNewSlot();
		var authorAnswer = slot.addNewAuthorAnswer("");
		var context = new com.wiris.quizzes.impl.ui.QuizzesStudioContext(this.question,slot,authorAnswer);
		context.setOptAnswerFieldInlineEditor(false);
		var embeddedElement = new com.wiris.quizzes.impl.ui.EmbeddedAuthoringField(context,this.componentBuilder);
		embeddedElement.setEmbeddedAnswersEditor(this);
		this.embeddedAuthoringFields.push(embeddedElement);
		return embeddedElement.getElement();
	}
	,filterHTML: function(questionText,mode) {
		return com.wiris.quizzes.impl.EmbeddedAnswerFilter.filterHTML(questionText,mode,this.question.getImpl(),this.questionInstance);
	}
	,analyzeHTML: function() {
		var _g = 0, _g1 = this.embeddedAuthoringFields;
		while(_g < _g1.length) {
			var authoringField = _g1[_g];
			++_g;
			authoringField.setEditableElement(this.editableElement);
			authoringField.changeState();
		}
	}
	,embeddedAuthoringFields: null
	,editableElement: null
	,componentBuilder: null
	,globalContext: null
	,questionInstance: null
	,question: null
	,__class__: com.wiris.quizzes.impl.ui.EmbeddedAnswersEditorImpl
}
com.wiris.quizzes.JsEmbeddedAnswersEditor = $hxClasses["com.wiris.quizzes.JsEmbeddedAnswersEditor"] = function(question,questionInstance,componentBuilder) {
	com.wiris.quizzes.impl.ui.EmbeddedAnswersEditorImpl.call(this,question,questionInstance,componentBuilder);
};
com.wiris.quizzes.JsEmbeddedAnswersEditor.__name__ = ["com","wiris","quizzes","JsEmbeddedAnswersEditor"];
com.wiris.quizzes.JsEmbeddedAnswersEditor.__super__ = com.wiris.quizzes.impl.ui.EmbeddedAnswersEditorImpl;
com.wiris.quizzes.JsEmbeddedAnswersEditor.prototype = $extend(com.wiris.quizzes.impl.ui.EmbeddedAnswersEditorImpl.prototype,{
	filterAuthoringField: function(element,index) {
		var slot = null;
		var authorAnswer = null;
		var slots = this.question.getSlots();
		var _g = 0;
		while(_g < slots.length) {
			var s = slots[_g];
			++_g;
			var authorAnswers = s.getAuthorAnswers();
			var _g1 = 0;
			while(_g1 < authorAnswers.length) {
				var aa = authorAnswers[_g1];
				++_g1;
				var aai = aa;
				if(Std.parseInt(aai.id) == index) {
					slot = s;
					authorAnswer = aai;
					break;
				}
			}
		}
		if(slot == null) slot = this.question.addNewSlot();
		if(authorAnswer == null) while(authorAnswer == null || Std.parseInt(authorAnswer.id) < index) authorAnswer = slot.addNewAuthorAnswer("");
		var component = this.buildEmbeddedAuthoringElement(slot,authorAnswer);
		element.parentNode.replaceChild(component.getElement(),element);
	}
	,analyzeHTML: function() {
		var root = this.editableElement;
		var elementsLive = com.wiris.quizzes.JsDomUtils.getElementsByClassName(com.wiris.quizzes.JsEmbeddedAnswersEditor.CLASS_AUTHOR_FIELD_EMBEDDED,null,root);
		var elements = new Array();
		var _g = 0;
		while(_g < elementsLive.length) {
			var element = elementsLive[_g];
			++_g;
			elements.push(element);
		}
		var _g1 = 0, _g = elements.length;
		while(_g1 < _g) {
			var i = _g1++;
			var element = elements[i];
			this.filterAuthoringField(element,i);
		}
		com.wiris.quizzes.impl.ui.EmbeddedAnswersEditorImpl.prototype.analyzeHTML.call(this);
	}
	,__class__: com.wiris.quizzes.JsEmbeddedAnswersEditor
});
com.wiris.quizzes.api.Quizzes = $hxClasses["com.wiris.quizzes.api.Quizzes"] = function() {
};
com.wiris.quizzes.api.Quizzes.__name__ = ["com","wiris","quizzes","api","Quizzes"];
com.wiris.quizzes.api.Quizzes.getInstance = function() {
	return com.wiris.quizzes.JsQuizzes.getInstance();
}
com.wiris.quizzes.api.Quizzes.prototype = {
	newFeaturedAssertionsRequest: function(question) {
		return null;
	}
	,newFeaturedSyntaxAssertionsRequest: function(question) {
		return null;
	}
	,getResourceUrl: function(name) {
		return null;
	}
	,getConfiguration: function() {
		return null;
	}
	,getMathFilter: function() {
		return null;
	}
	,getQuizzesService: function() {
		return null;
	}
	,newFeedbackRequest: function(html,instance) {
		return null;
	}
	,newMultipleAnswersGradeRequest: function(correctAnswers,studentAnswers) {
		return null;
	}
	,newSimpleGradeRequest: function(correctAnswer,studentAnswer) {
		return null;
	}
	,newGradeRequest: function(instance) {
		return null;
	}
	,newVariablesRequestWithQuestionData: function(html,instance) {
		return null;
	}
	,newVariablesRequest: function(html,instance) {
		return null;
	}
	,readQuestionInstance: function(xml,question) {
		return null;
	}
	,readQuestion: function(xml) {
		return null;
	}
	,newQuestionInstance: function(q) {
		return null;
	}
	,newQuestion: function() {
		return null;
	}
	,getQuizzesComponentBuilder: function() {
		return null;
	}
	,__class__: com.wiris.quizzes.api.Quizzes
}
com.wiris.quizzes.impl.QuizzesImpl = $hxClasses["com.wiris.quizzes.impl.QuizzesImpl"] = function() {
	this.componentBuilder = null;
	com.wiris.quizzes.api.Quizzes.call(this);
};
com.wiris.quizzes.impl.QuizzesImpl.__name__ = ["com","wiris","quizzes","impl","QuizzesImpl"];
com.wiris.quizzes.impl.QuizzesImpl.getInstance = function() {
	if(com.wiris.quizzes.impl.QuizzesImpl.singleton == null) com.wiris.quizzes.impl.QuizzesImpl.singleton = new com.wiris.quizzes.impl.QuizzesImpl();
	return com.wiris.quizzes.impl.QuizzesImpl.singleton;
}
com.wiris.quizzes.impl.QuizzesImpl.getIndex = function(id) {
	var i = id.indexOf("_") + 1;
	return Std.parseInt(HxOverrides.substr(id,i,null));
}
com.wiris.quizzes.impl.QuizzesImpl.extractQuestionInstanceVariableNames = function(qi) {
	var vars = new Array();
	var i = qi.variables.keys();
	while(i.hasNext()) {
		var h = qi.variables.get(i.next());
		var j = h.keys();
		while(j.hasNext()) com.wiris.quizzes.impl.HTMLTools.insertStringInSortedArray(j.next(),vars);
	}
	return com.wiris.quizzes.impl.HTMLTools.toNativeArray(vars);
}
com.wiris.quizzes.impl.QuizzesImpl.removeAnswerVariables = function(variables,q,qi) {
	var qq = q.getImpl();
	if(qq.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_STUDENT_ANSWER_PARAMETER) == "true") {
		var name = qq.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_STUDENT_ANSWER_PARAMETER_NAME);
		var defname = qq.defaultOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_STUDENT_ANSWER_PARAMETER_NAME);
		if(defname == name) {
			var lang = com.wiris.quizzes.impl.CalcDocumentTools.casSessionLang(qq.getAlgorithm());
			name = com.wiris.quizzes.impl.QuizzesTranslator.getInstance(lang).t(name);
		}
		var n = 0;
		var i;
		var _g1 = 0, _g = variables.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(StringTools.startsWith(variables[i1],name)) {
				var after = HxOverrides.substr(variables[i1],name.length,null);
				if(after.length == 0 || com.wiris.util.type.IntegerTools.isInt(after) && Std.parseInt(after) <= qi.getStudentAnswersLength()) {
					variables[i1] = null;
					n++;
				} else if(qq.getLocalData(com.wiris.quizzes.impl.LocalData.KEY_OPENANSWER_COMPOUND_ANSWER) == com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_COMPOUND_ANSWER_TRUE && q.getCorrectAnswersLength() > 0) {
					var correctAnswer = qq.correctAnswers[0];
					var parts = com.wiris.quizzes.impl.CompoundAnswerParser.parseCompoundAnswer(correctAnswer);
					if(com.wiris.util.type.IntegerTools.isInt(after) && Std.parseInt(after) <= parts.length) {
						variables[i1] = null;
						n++;
					}
				} else if(com.wiris.util.type.IntegerTools.isInt(after) && com.wiris.quizzes.impl.QuizzesImpl.containsCorrectAnswerWithCompoundName(qq,Std.parseInt(after))) {
					variables[i1] = null;
					n++;
				}
			}
		}
		if(n > 0) {
			var newvariables = new Array();
			var j = 0;
			var _g1 = 0, _g = variables.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				if(variables[i1] != null) {
					newvariables[j] = variables[i1];
					j++;
				}
			}
			variables = newvariables;
		}
	}
	return variables;
}
com.wiris.quizzes.impl.QuizzesImpl.containsCorrectAnswerWithCompoundName = function(q,after) {
	var it = HxOverrides.iter(q.correctAnswers);
	while(it.hasNext()) {
		var id = it.next().id;
		if(id != null && StringTools.endsWith(id,"_c" + (after - 1))) return true;
	}
	return false;
}
com.wiris.quizzes.impl.QuizzesImpl.setVariables = function(html,q,qi,qr) {
	var variables = null;
	if(html == null) variables = com.wiris.quizzes.impl.QuizzesImpl.extractQuestionInstanceVariableNames(qi); else {
		var h = new com.wiris.quizzes.impl.HTMLTools();
		var computedVariables = new Hash();
		html = h.extractActionExpressions(html,computedVariables);
		q.setAlgorithm(h.addComputedVariablesToAlgorithm(q.getAlgorithm(),computedVariables));
		variables = h.extractVariableNames(html);
		variables = com.wiris.quizzes.impl.QuizzesImpl.removeAnswerVariables(variables,q,qi);
	}
	if(variables.length > 0) {
		qr.variables(variables,com.wiris.quizzes.impl.MathContent.TYPE_TEXT);
		qr.variables(variables,com.wiris.quizzes.impl.MathContent.TYPE_MATHML);
	}
}
com.wiris.quizzes.impl.QuizzesImpl.__super__ = com.wiris.quizzes.api.Quizzes;
com.wiris.quizzes.impl.QuizzesImpl.prototype = $extend(com.wiris.quizzes.api.Quizzes.prototype,{
	mathContentToFilterableValue: function(value,initialContent) {
		if(value.type == com.wiris.quizzes.impl.MathContent.TYPE_GEOMETRY_FILE) return "<img " + "src=\"" + com.wiris.quizzes.impl.QuizzesImpl.getInstance().getResourceUrl("plotter_loading.png") + "\" " + "alt=\"Plotter\" " + "class=\"wirisconstruction wirisgraphanimate\" " + "data-wirisconstruction=\"" + com.wiris.util.xml.WXmlUtils.htmlEscape(value.content) + "\"" + (initialContent != null && !(initialContent == "")?"data-wirisinitialcontent=\"" + com.wiris.util.xml.WXmlUtils.htmlEscape(initialContent) + "\"":"") + "/>";
		return value.content;
	}
	,answerToFilterableValue: function(value,initialContent) {
		var mc = new com.wiris.quizzes.impl.MathContent();
		mc.set(value);
		return this.mathContentToFilterableValue(mc,initialContent);
	}
	,getElementsToGrade: function(geometryFile,assertion) {
		if(assertion.getParam(com.wiris.quizzes.impl.Assertion.PARAM_ELEMENTS_TO_GRADE) != null) {
			var ao = com.wiris.util.json.JSon.getArray(com.wiris.util.json.JSon.decode(assertion.getParam(com.wiris.quizzes.impl.Assertion.PARAM_ELEMENTS_TO_GRADE)));
			var strings = new Array();
			var _g = 0;
			while(_g < ao.length) {
				var o = ao[_g];
				++_g;
				strings.push(com.wiris.util.json.JSon.getString(o));
			}
			return strings;
		} else {
			var g = com.wiris.util.geometry.GeometryFile.readJSON(geometryFile);
			return g.getDisplaysLength() >= 1?g.getDisplay(0).getElementNames():new Array();
		}
	}
	,getElementsToGradeFromAuthorAnswer: function(authorAnswer) {
		return this.getElementsToGrade(authorAnswer.getValue(),authorAnswer.getComparison());
	}
	,getHttpObject: function(httpl,serviceUrl,service,postData) {
		var http;
		var config = com.wiris.quizzes.impl.QuizzesImpl.getInstance().getConfiguration();
		var clientSide = com.wiris.settings.PlatformSettings.IS_JAVASCRIPT || com.wiris.settings.PlatformSettings.IS_FLASH;
		var allowCors = clientSide && "true" == config.get(com.wiris.quizzes.api.ConfigurationKeys.CROSSORIGINCALLS_ENABLED);
		if(clientSide && !allowCors) {
			var url = config.get(com.wiris.quizzes.api.ConfigurationKeys.PROXY_URL);
			http = new com.wiris.quizzes.impl.HttpImpl(url,httpl);
			http.setParameter("service",service);
			if(postData != null) {
				http.setParameter("rawpostdata","true");
				http.setParameter("postdata",postData);
				http.setHeader("Content-Type","application/x-www-form-urlencoded; charset=UTF-8");
			} else http.setParameter("url",serviceUrl);
		} else {
			if(clientSide) http = new com.wiris.quizzes.impl.HttpImpl(serviceUrl,httpl); else {
				http = new com.wiris.quizzes.impl.MaxConnectionsHttpImpl(serviceUrl,httpl);
				var referrer = config.get(com.wiris.quizzes.api.ConfigurationKeys.REFERER_URL);
				if(referrer == null || StringTools.trim(referrer) == "") com.wiris.system.Logger.log(900,"'quizzes.referer.url' configuration item is not set so requests to the " + "service can not be identified. Unidentified requests may be blocked by the server " + "and will certainly be blocked in future releases." + "\n" + "Setup the referrer editing your configuration.ini file or setting it programmatically " + "through the Configuration interface." + "\n"); else http.setHeader("Referer",referrer);
			}
			if(postData != null) {
				http.setHeader("Content-Type","text/xml; charset=UTF-8");
				http.setPostData(postData);
			} else http.setHeader("Content-Type","application/x-www-form-urlencoded; charset=UTF-8");
		}
		return http;
	}
	,newMultipleAnswersGradeRequest: function(correctAnswers,studentAnswers) {
		return this.newEvalMultipleAnswersRequest(correctAnswers,studentAnswers,null,null);
	}
	,newSimpleGradeRequest: function(correctAnswer,studentAnswer) {
		return this.newEvalMultipleAnswersRequest([correctAnswer],[studentAnswer],null,null);
	}
	,newMultipleResponseFromXml: function(xml) {
		var s = this.getSerializer();
		var elem = s.read(xml);
		var mqr;
		var tag = s.getTagName(elem);
		if(tag == com.wiris.quizzes.impl.QuestionResponseImpl.tagName) {
			var res = elem;
			mqr = new com.wiris.quizzes.impl.MultipleQuestionResponse();
			mqr.questionResponses = new Array();
			mqr.questionResponses.push(res);
		} else if(tag == com.wiris.quizzes.impl.MultipleQuestionResponse.tagName) mqr = elem; else throw "Unexpected XML root tag " + tag + ".";
		return mqr;
	}
	,newResponseFromXml: function(xml) {
		var mqr = this.newMultipleResponseFromXml(xml);
		return mqr.questionResponses[0];
	}
	,newRequestFromXml: function(xml) {
		var s = this.getSerializer();
		var elem = s.read(xml);
		var req;
		var tag = s.getTagName(elem);
		if(tag == com.wiris.quizzes.impl.QuestionRequestImpl.tagName) req = elem; else if(tag == com.wiris.quizzes.impl.MultipleQuestionRequest.tagName) {
			var mqr = elem;
			req = mqr.questionRequests[0];
		} else throw "Unexpected XML root tag " + tag + ".";
		return req;
	}
	,newTranslationRequest: function(q,lang) {
		var r = new com.wiris.quizzes.impl.QuestionRequestImpl();
		r.question = q;
		var p = new com.wiris.quizzes.impl.ProcessGetTranslation();
		p.lang = lang;
		r.addProcess(p);
		return r;
	}
	,replicateCompoundAnswerAssertionsImpl: function(aa,aux) {
		var assertions = new Array();
		var _g = 0;
		while(_g < aa.length) {
			var a = aa[_g];
			++_g;
			var n = aux.get(a.getCorrectAnswer());
			var k;
			var _g1 = 0;
			while(_g1 < n) {
				var k1 = _g1++;
				var ca = new com.wiris.quizzes.impl.Assertion();
				ca.name = a.name;
				ca.parameters = a.parameters;
				assertions.push(ca);
				if(a.name == com.wiris.quizzes.impl.Assertion.EQUIVALENT_FUNCTION) {
					var caa = new Array();
					var uaa = new Array();
					var l;
					var _g2 = 0;
					while(_g2 < n) {
						var l1 = _g2++;
						caa[l1] = a.getCorrectAnswer() + "_c" + l1;
						uaa[l1] = a.getAnswer() + "_c" + l1;
					}
					ca.setCorrectAnswers(caa);
					ca.setAnswers(uaa);
					break;
				} else {
					ca.setCorrectAnswer(a.getCorrectAnswer() + "_c" + k1);
					ca.setAnswer(a.getAnswer() + "_c" + k1);
				}
			}
		}
		return assertions;
	}
	,spliceEqualAssertion: function(a,assertions) {
		if(assertions == null) return null;
		var _g = 0;
		while(_g < assertions.length) {
			var ass = assertions[_g];
			++_g;
			if(ass.isEquivalent(a)) {
				HxOverrides.remove(assertions,ass);
				return ass;
			}
		}
		return null;
	}
	,replicateCompoundAnswerAssertions: function(qa,qq,aux) {
		if(qq.assertions == null) return;
		if(qa.getImpl().isQuestionCompoundAnswer()) {
			qq.assertions = this.replicateCompoundAnswerAssertionsImpl(qq.assertions,aux);
			return;
		}
		var slots = qa.getSlots();
		var _g = 0;
		while(_g < slots.length) {
			var s = slots[_g];
			++_g;
			if(s.isSlotCompoundAnswer()) {
				var assertions = new Array();
				var a = s.getSyntax();
				a = this.spliceEqualAssertion(a,qq.assertions);
				if(a != null) assertions.push(a);
				var authorAnswers = s.getAuthorAnswers();
				var _g1 = 0;
				while(_g1 < authorAnswers.length) {
					var aa = authorAnswers[_g1];
					++_g1;
					a = aa.getComparison();
					a = this.spliceEqualAssertion(a,qq.assertions);
					if(a != null) assertions.push(a);
					var validations = aa.getValidations();
					var _g2 = 0;
					while(_g2 < validations.length) {
						var v = validations[_g2];
						++_g2;
						a = v;
						a = this.spliceEqualAssertion(a,qq.assertions);
						if(a != null) assertions.push(a);
					}
				}
				qq.assertions = qq.assertions.concat(this.replicateCompoundAnswerAssertionsImpl(assertions,aux));
			}
		}
	}
	,breakCompoundUserAnswersImpl: function(answers) {
		var userAns = new Array();
		if(answers == null) return userAns;
		var _g = 0;
		while(_g < answers.length) {
			var a = answers[_g];
			++_g;
			var parts = com.wiris.quizzes.impl.CompoundAnswerParser.parseCompoundAnswer(a);
			var k;
			var _g2 = 0, _g1 = parts.length;
			while(_g2 < _g1) {
				var k1 = _g2++;
				var ca = new com.wiris.quizzes.impl.Answer();
				ca.id = a.id + "_c" + k1;
				ca.set(parts[k1][1]);
				userAns.push(ca);
			}
		}
		return userAns;
	}
	,breakCompoundUserAnswers: function(qa,qq,uu) {
		if(uu.answers == null) return;
		if(qa.getImpl().isQuestionCompoundAnswer()) {
			uu.answers = this.breakCompoundUserAnswersImpl(uu.answers);
			return;
		}
		var slots = qa.getSlots();
		var _g = 0;
		while(_g < slots.length) {
			var s = slots[_g];
			++_g;
			if(s.isSlotCompoundAnswer()) {
				var compound = new Array();
				var i = uu.answers.length - 1;
				while(i >= 0) {
					var a = uu.answers[i--];
					if(s.id == a.id) {
						compound.push(a);
						HxOverrides.remove(uu.answers,a);
					}
				}
				uu.answers = uu.answers.concat(this.breakCompoundUserAnswersImpl(compound));
			}
		}
	}
	,breakCompoundCorrectAnswersImpl: function(qq,aux) {
		var correctAnswers = new Array();
		if(qq == null) return correctAnswers;
		var _g = 0;
		while(_g < qq.length) {
			var c = qq[_g];
			++_g;
			if(c == null) continue;
			var parts = com.wiris.quizzes.impl.CompoundAnswerParser.parseCompoundAnswer(c);
			if(aux != null) aux.set(c.id,parts.length);
			var k;
			var _g2 = 0, _g1 = parts.length;
			while(_g2 < _g1) {
				var k1 = _g2++;
				var cc = new com.wiris.quizzes.impl.CorrectAnswer();
				cc.type = c.type;
				cc.id = c.id + "_c" + k1;
				cc.content = parts[k1][1];
				cc.weight = 1.0 / parts.length;
				correctAnswers.push(cc);
			}
		}
		return correctAnswers;
	}
	,breakCompoundCorrectAnswers: function(qa,qq,aux,instance) {
		if(qq.correctAnswers == null) return;
		if(qa.getImpl().isQuestionCompoundAnswer()) {
			qq.correctAnswers = this.breakCompoundCorrectAnswersImpl(qq.correctAnswers,aux);
			return;
		}
		var slots = qa.getSlots();
		var _g = 0;
		while(_g < slots.length) {
			var s = slots[_g];
			++_g;
			if(s.isSlotCompoundAnswer()) {
				var authorAnswers = s.getAuthorAnswers();
				var correctAnswers = new Array();
				var _g1 = 0;
				while(_g1 < authorAnswers.length) {
					var aa = authorAnswers[_g1];
					++_g1;
					correctAnswers.push(aa.value);
				}
				var separated = this.breakCompoundCorrectAnswersImpl(correctAnswers,aux);
				var _g1 = 0;
				while(_g1 < correctAnswers.length) {
					var ca = correctAnswers[_g1];
					++_g1;
					HxOverrides.remove(qq.correctAnswers,ca);
				}
				if(instance != null && instance.hasVariables()) {
					var _g1 = 0;
					while(_g1 < separated.length) {
						var sepCA = separated[_g1];
						++_g1;
						var isPlainTextField = s.getAnswerFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD;
						var isStringSyntax = s.getSyntax().getName() == com.wiris.quizzes.api.assertion.SyntaxName.STRING;
						var value = sepCA.content;
						if(isPlainTextField || isStringSyntax) value = instance.expandVariablesText(value); else value = instance.expandVariablesMathMLEval(value);
						sepCA.set(value);
					}
				}
				qq.correctAnswers = qq.correctAnswers.concat(separated);
			}
		}
	}
	,isCompoundGraphicalAssertion: function(a) {
		return a.name == com.wiris.quizzes.impl.Assertion.EQUIVALENT_GRAPHIC || a.name == com.wiris.quizzes.impl.Assertion.CHECK_COLOR || a.name == com.wiris.quizzes.impl.Assertion.CHECK_LINESTYLE;
	}
	,breakCompoundGraphical: function(qq) {
		var toAdd = new Array();
		var toRemove = new Array();
		var _g1 = 0, _g = qq.getAssertionsLength();
		while(_g1 < _g) {
			var i = _g1++;
			if(this.isCompoundGraphicalAssertion(qq.getAssertion(i))) {
				var ass = qq.getAssertion(i);
				var ca = null;
				var _g3 = 0, _g2 = qq.correctAnswers.length;
				while(_g3 < _g2) {
					var j = _g3++;
					if(com.wiris.util.type.Arrays.containsArray(ass.getCorrectAnswers(),qq.correctAnswers[j].id)) ca = qq.correctAnswers[j];
				}
				if(ca == null) return;
				var elements = this.getElementsToGrade(ca.content,ass);
				var steppedElements = new Array();
				var _g3 = 0, _g2 = elements.length;
				while(_g3 < _g2) {
					var j = _g3++;
					var elemId = elements[j];
					steppedElements.push(elemId);
					var ca_j = new com.wiris.quizzes.impl.CorrectAnswer();
					ca_j.id = ca.id + "_cg" + j + "_" + elemId;
					ca_j.reference = ca.id;
					var ass_j = new com.wiris.quizzes.impl.Assertion();
					ass_j.name = ass.name;
					ass_j.addCorrectAnswer(ca_j.id);
					ass_j.answer = ass.answer;
					ass_j.setParam(com.wiris.quizzes.impl.Assertion.PARAM_ELEMENTS_TO_GRADE,com.wiris.util.json.JSon.encode(steppedElements));
					if(ass.getParam(com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE) != null) ass_j.setParam(com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE,ass.getParam(com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE));
					qq.correctAnswers.push(ca_j);
					toAdd.push(ass_j);
				}
				toRemove.push(ass);
			}
		}
		var _g = 0;
		while(_g < toRemove.length) {
			var a = toRemove[_g];
			++_g;
			HxOverrides.remove(qq.assertions,a);
		}
		var _g = 0;
		while(_g < toAdd.length) {
			var a = toAdd[_g];
			++_g;
			qq.assertions.push(a);
		}
	}
	,isCompoundGraphical: function(qq) {
		var _g1 = 0, _g = qq.getAssertionsLength();
		while(_g1 < _g) {
			var i = _g1++;
			if(this.isCompoundGraphicalAssertion(qq.getAssertion(i))) return true;
		}
		return false;
	}
	,newEvalMultipleAnswersRequest: function(correctAnswers,userAnswers,question,instance) {
		var q = null;
		var qi = null;
		if(question != null) q = question.getImpl();
		if(instance != null) qi = instance;
		var qq = new com.wiris.quizzes.impl.QuestionImpl();
		var uu = new com.wiris.quizzes.impl.UserData();
		uu.answers = new Array();
		if(q != null) {
			qq.wirisCasSession = q.wirisCasSession;
			qq.options = q.options;
		}
		if(qi != null && qi.userData != null) {
			uu.randomSeed = qi.userData.randomSeed;
			uu.parameters = qi.userData.parameters;
		} else {
			var qqi = new com.wiris.quizzes.impl.QuestionInstanceImpl();
			uu.randomSeed = qqi.userData.randomSeed;
		}
		var i = 0;
		if(correctAnswers != null) {
			var _g1 = 0, _g = correctAnswers.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var value = com.wiris.util.xml.MathMLUtils.removeStrokesAnnotation(correctAnswers[i1]);
				if(value == null) value = "";
				qq.setCorrectAnswer(i1,value);
			}
		}
		if(userAnswers != null) {
			var _g1 = 0, _g = userAnswers.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				uu.setUserAnswer(i1,this.removeHandAnnotations(userAnswers[i1]));
			}
		}
		qq.assertions = new Array();
		var qa = q;
		var ua = null;
		if(qi != null) ua = qi.userData;
		var j;
		if(correctAnswers == null && qa != null) {
			qq.correctAnswers = new Array();
			var cas = qa.correctAnswers;
			var _g1 = 0, _g = cas.length;
			while(_g1 < _g) {
				var j1 = _g1++;
				var ca = cas[j1];
				if(ca != null && ca.content != null) {
					var newCA = new com.wiris.quizzes.impl.CorrectAnswer();
					newCA.type = ca.type;
					newCA.content = com.wiris.util.xml.MathMLUtils.removeStrokesAnnotation(ca.content);
					newCA.weight = ca.weight;
					newCA.id = ca.id;
					qq.correctAnswers.push(newCA);
				}
			}
		}
		if(userAnswers == null && ua != null && ua.answers != null) {
			var _g1 = 0, _g = ua.answers.length;
			while(_g1 < _g) {
				var j1 = _g1++;
				var aa = ua.answers[j1].content;
				if(aa != null) {
					aa = this.removeHandAnnotations(aa);
					uu.setUserAnswer(j1,aa);
				}
			}
		}
		var syntax = null;
		if(qa != null && qa.assertions != null) {
			var _g1 = 0, _g = qa.assertions.length;
			while(_g1 < _g) {
				var j1 = _g1++;
				var ass = qa.assertions[j1].copy();
				if(ass.isSyntactic()) syntax = ass;
				if(correctAnswers != null) {
					var assCA = ass.getCorrectAnswers();
					var caCounter = assCA.length - 1;
					while(caCounter >= 0) {
						var ca = assCA[caCounter];
						if(Std.parseInt(ca) >= correctAnswers.length) ass.removeCorrectAnswer(ca);
						caCounter--;
					}
					if(ass.getCorrectAnswers().length == 0) continue;
				}
				qq.assertions.push(ass);
			}
		}
		if(syntax == null) {
			syntax = new com.wiris.quizzes.impl.Assertion();
			syntax.addCorrectAnswer("0");
			syntax.name = com.wiris.quizzes.impl.Assertion.SYNTAX_MATH;
			qq.assertions.push(syntax);
		}
		var _g1 = 0, _g = uu.answers.length;
		while(_g1 < _g) {
			var j1 = _g1++;
			var foundSyntax = false;
			var k;
			var _g3 = 0, _g2 = qq.assertions.length;
			while(_g3 < _g2) {
				var k1 = _g3++;
				var ass = qq.assertions[k1];
				if(ass.isSyntactic() && com.wiris.util.type.Arrays.containsArray(ass.getAnswers(),j1)) foundSyntax = true;
			}
			if(!foundSyntax) syntax.addAnswer(j1 + "");
		}
		if(qi != null && qi.hasVariables()) {
			var _g1 = 0, _g = qq.getCorrectAnswersLength();
			while(_g1 < _g) {
				var j1 = _g1++;
				var ca = qq.correctAnswers[j1];
				var value = ca.content;
				var isPlainTextField = qa.getAnswerFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD;
				var isStringSyntax = syntax.name == com.wiris.quizzes.impl.Assertion.SYNTAX_STRING;
				var slots = qa.slots;
				if(slots != null) {
					var _g2 = 0;
					while(_g2 < slots.length) {
						var slot = slots[_g2];
						++_g2;
						var authorAnswers = slot.authorAnswers;
						var _g3 = 0;
						while(_g3 < authorAnswers.length) {
							var authorAnswer = authorAnswers[_g3];
							++_g3;
							if(authorAnswer.id == ca.id) {
								isPlainTextField = slot.getAnswerFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD;
								isStringSyntax = slot.getSyntax().getName() == com.wiris.quizzes.api.assertion.SyntaxName.STRING;
							}
						}
					}
				}
				var isTextFormat = ca.type == com.wiris.quizzes.impl.MathContent.TYPE_TEXT;
				var hasMultiletterIdentifierInTextFormat = false;
				if(isTextFormat) {
					var splitByRegularSp = ca.content.split(" ");
					var words = new Array();
					var _g2 = 0;
					while(_g2 < splitByRegularSp.length) {
						var word = splitByRegularSp[_g2];
						++_g2;
						var splitByNbsp = word.split(com.wiris.system.Utf8.uchr(160));
						words = words.concat(splitByNbsp);
					}
					var _g2 = 0;
					while(_g2 < words.length) {
						var word = words[_g2];
						++_g2;
						if(!StringTools.startsWith(word,"#") && word.length > 1) {
							hasMultiletterIdentifierInTextFormat = true;
							break;
						}
					}
				}
				if(isPlainTextField || isStringSyntax || hasMultiletterIdentifierInTextFormat) value = qi.expandVariablesText(value); else value = qi.expandVariablesMathMLEval(value);
				qq.setCorrectAnswer(j1,value);
			}
		}
		j = qq.assertions.length - 1;
		while(j >= 0) {
			if(qq.assertions[j].name == com.wiris.quizzes.impl.Assertion.EQUIVALENT_ALL) {
				var correctanswer = qq.assertions[j].getCorrectAnswer();
				var k = qq.assertions.length - 1;
				while(k >= 0) {
					if(qq.assertions[k].isSyntactic()) {
						qq.assertions[k].removeCorrectAnswer(correctanswer);
						if(qq.assertions[k].getCorrectAnswers().length == 0) {
							HxOverrides.remove(qq.assertions,qq.assertions[k]);
							if(k < j) j--;
						}
					}
					k--;
				}
			}
			j--;
		}
		var usedcorrectanswers = new Array();
		var _g1 = 0, _g = qq.getCorrectAnswersLength();
		while(_g1 < _g) {
			var j1 = _g1++;
			usedcorrectanswers[j1] = false;
		}
		var usedanswers = new Array();
		var _g1 = 0, _g = uu.answers.length;
		while(_g1 < _g) {
			var j1 = _g1++;
			usedanswers[j1] = false;
		}
		var _g1 = 0, _g = qq.assertions.length;
		while(_g1 < _g) {
			var j1 = _g1++;
			var ass = qq.assertions[j1];
			var corr = com.wiris.quizzes.impl.QuizzesImpl.getIndex(ass.getCorrectAnswer());
			var ans = com.wiris.quizzes.impl.QuizzesImpl.getIndex(ass.getAnswer());
			if(ass.isEquivalence()) {
				if(corr < usedcorrectanswers.length) usedcorrectanswers[corr] = true;
				if(ans < usedanswers.length) usedanswers[ans] = true;
			} else if(ass.isCheck()) {
				if(ans < usedanswers.length) usedanswers[ans] = true;
			}
		}
		var pairs = this.getPairings(qq.getCorrectAnswersLength(),uu.answers.length);
		var _g1 = 0, _g = usedcorrectanswers.length;
		while(_g1 < _g) {
			var j1 = _g1++;
			if(!usedcorrectanswers[j1]) {
				var k;
				var _g3 = 0, _g2 = pairs.length;
				while(_g3 < _g2) {
					var k1 = _g3++;
					if(pairs[k1][0] == j1) {
						var user = pairs[k1][1];
						qq.setParametrizedAssertion(com.wiris.quizzes.impl.Assertion.EQUIVALENT_SYMBOLIC,j1 + "",user + "",null);
						usedanswers[user] = true;
					}
				}
			}
		}
		var _g1 = 0, _g = usedanswers.length;
		while(_g1 < _g) {
			var j1 = _g1++;
			if(!usedanswers[j1]) {
				var k;
				var _g3 = 0, _g2 = pairs.length;
				while(_g3 < _g2) {
					var k1 = _g3++;
					if(pairs[k1][1] == j1) qq.setParametrizedAssertion(com.wiris.quizzes.impl.Assertion.EQUIVALENT_SYMBOLIC,pairs[k1][0] + "",j1 + "",null);
				}
			}
		}
		if(qa != null && qa.getImpl().isCompoundAnswer()) {
			if(this.isCompoundGraphical(qq)) this.breakCompoundGraphical(qq); else {
				var aux = new Hash();
				this.breakCompoundCorrectAnswers(qa,qq,aux,qi);
				this.breakCompoundUserAnswers(qa,qq,uu);
				this.replicateCompoundAnswerAssertions(qa,qq,aux);
			}
		}
		var qr = new com.wiris.quizzes.impl.QuestionRequestImpl();
		qr.question = qq;
		qr.userData = uu;
		qr.checkAssertions();
		return qr;
	}
	,removeHandAnnotations: function(mathml) {
		var conf = this.getConfiguration();
		if(!(conf.get(com.wiris.quizzes.api.ConfigurationKeys.HAND_LOGTRACES) == "true") || conf.get(com.wiris.quizzes.api.ConfigurationKeys.SERVICE_URL).indexOf("www.wiris.net") == -1) return com.wiris.util.xml.MathMLUtils.removeStrokesAnnotation(mathml);
		return mathml;
	}
	,getPairings: function(c,u) {
		var p = new Array();
		var reverse;
		if(c >= u) reverse = false; else {
			var aux = c;
			c = u;
			u = aux;
			reverse = true;
		}
		if(u == 0) return p;
		var n = c / u | 0;
		var d = c % u | 0;
		var i;
		var cc = 0;
		var cu = 0;
		var _g = 0;
		while(_g < u) {
			var i1 = _g++;
			var j;
			var _g1 = 0;
			while(_g1 < n) {
				var j1 = _g1++;
				p.push([reverse?cu:cc,reverse?cc:cu]);
				cc++;
			}
			if(i1 < d) {
				p.push([reverse?cu:cc,reverse?cc:cu]);
				cc++;
			}
			cu++;
		}
		return p;
	}
	,getSerializer: function() {
		var s = new com.wiris.util.xml.XmlSerializer();
		s.register(new com.wiris.quizzes.impl.Answer());
		s.register(new com.wiris.quizzes.impl.Assertion());
		s.register(new com.wiris.quizzes.impl.AssertionCheckImpl());
		s.register(new com.wiris.quizzes.impl.AssertionParam());
		s.register(new com.wiris.quizzes.impl.CorrectAnswer());
		s.register(new com.wiris.quizzes.impl.InitialContent());
		s.register(new com.wiris.quizzes.impl.LocalData());
		s.register(new com.wiris.quizzes.impl.MathContent());
		s.register(new com.wiris.quizzes.impl.MultipleQuestionRequest());
		s.register(new com.wiris.quizzes.impl.MultipleQuestionResponse());
		s.register(new com.wiris.quizzes.impl.Option());
		s.register(new com.wiris.quizzes.impl.ProcessGetCheckAssertions());
		s.register(new com.wiris.quizzes.impl.ProcessGetFeaturedAssertions());
		s.register(new com.wiris.quizzes.impl.ProcessGetFeaturedSyntaxAssertions());
		s.register(new com.wiris.quizzes.impl.ProcessGetTranslation());
		s.register(new com.wiris.quizzes.impl.ProcessGetVariables());
		s.register(new com.wiris.quizzes.impl.ProcessStoreQuestion());
		s.register(new com.wiris.quizzes.impl.QuestionImpl());
		s.register(new com.wiris.quizzes.impl.QuestionRequestImpl());
		s.register(new com.wiris.quizzes.impl.QuestionResponseImpl());
		s.register(new com.wiris.quizzes.impl.QuestionInstanceImpl());
		s.register(new com.wiris.quizzes.impl.ResultError());
		s.register(new com.wiris.quizzes.impl.ResultErrorLocation());
		s.register(new com.wiris.quizzes.impl.ResultGetCheckAssertions());
		s.register(new com.wiris.quizzes.impl.ResultGetTranslation());
		s.register(new com.wiris.quizzes.impl.ResultGetVariables());
		s.register(new com.wiris.quizzes.impl.ResultStoreQuestion());
		s.register(new com.wiris.quizzes.impl.ResultGetFeaturedSyntaxAssertions());
		s.register(new com.wiris.quizzes.impl.ResultGetFeaturedAssertions());
		s.register(new com.wiris.quizzes.impl.SlotImpl());
		s.register(new com.wiris.quizzes.impl.TranslationNameChange());
		s.register(new com.wiris.quizzes.impl.UserData());
		s.register(new com.wiris.quizzes.impl.Variable());
		s.register(new com.wiris.quizzes.impl.Parameter());
		return s;
	}
	,cloneAndProcessCompoundAnswers: function(question) {
		var q = question;
		if(!q.getImpl().isCompoundAnswer()) return q;
		var qq = new com.wiris.quizzes.impl.QuestionImpl();
		var ca = q.getImpl().correctAnswers;
		qq.importQuestion(q.getImpl());
		var aux = new Hash();
		if(ca != null) {
			qq.correctAnswers = ca.concat(new Array());
			this.breakCompoundCorrectAnswers(qq,qq,aux,null);
		}
		var aa = q.getImpl().assertions;
		if(aa != null) {
			qq.assertions = aa.concat(new Array());
			this.replicateCompoundAnswerAssertions(qq,qq,aux);
		}
		return qq;
	}
	,newFeaturedAssertionsRequest: function(question) {
		if(question == null) throw "Question cannot be null.";
		var qr = new com.wiris.quizzes.impl.QuestionRequestImpl();
		qr.question = this.cloneAndProcessCompoundAnswers(question);
		qr.addProcess(new com.wiris.quizzes.impl.ProcessGetFeaturedAssertions());
		return qr;
	}
	,newFeaturedSyntaxAssertionsRequest: function(question) {
		if(question == null) throw "Question cannot be null.";
		var qr = new com.wiris.quizzes.impl.QuestionRequestImpl();
		qr.question = question;
		qr.addProcess(new com.wiris.quizzes.impl.ProcessGetFeaturedSyntaxAssertions());
		return qr;
	}
	,getLockProvider: function() {
		if(this.locker == null) {
			var className = this.getConfiguration().get(com.wiris.quizzes.impl.ConfigurationImpl.LOCKPROVIDER_CLASS);
			if(!(className == "")) this.locker = Type.createInstance(Type.resolveClass(className),new Array()); else this.locker = new com.wiris.quizzes.impl.FileLockProvider(this.getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.CACHE_DIR));
		}
		return this.locker;
	}
	,getVariablesCache: function() {
		if(this.variablesCache == null) this.variablesCache = this.createCache(com.wiris.quizzes.impl.ConfigurationImpl.VARIABLESCACHE_CLASS);
		return this.variablesCache;
	}
	,getImagesCache: function() {
		if(this.imagesCache == null) this.imagesCache = this.createCache(com.wiris.quizzes.impl.ConfigurationImpl.IMAGESCACHE_CLASS);
		return this.imagesCache;
	}
	,newStoreCache: function() {
		return new com.wiris.util.sys.StoreCache(this.getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.CACHE_DIR));
	}
	,createCache: function(configKey) {
		var cache;
		var className = this.getConfiguration().get(configKey);
		if(!(className == "")) cache = Type.createInstance(Type.resolveClass(className),new Array()); else cache = this.newStoreCache();
		return cache;
	}
	,getAccessProvider: function() {
		if(this.accessProvider == null) {
			var classpath = this.getConfiguration().get(com.wiris.quizzes.impl.ConfigurationImpl.ACCESSPROVIDER_CLASSPATH);
			if(!(classpath == "")) com.wiris.quizzes.impl.ClasspathLoader.load(classpath);
			var className = this.getConfiguration().get(com.wiris.quizzes.impl.ConfigurationImpl.ACCESSPROVIDER_CLASS);
			if(!(className == "")) this.accessProvider = Type.createInstance(Type.resolveClass(className),new Array());
		}
		return this.accessProvider;
	}
	,getTracker: function() {
		return this.tracker;
	}
	,getTelemetryService: function() {
		return this.telemetryService;
	}
	,getResourceUrl: function(name) {
		var c = this.getConfiguration();
		var version = c.get(com.wiris.quizzes.api.ConfigurationKeys.VERSION);
		if("true" == c.get(com.wiris.quizzes.api.ConfigurationKeys.RESOURCES_STATIC)) return c.get(com.wiris.quizzes.api.ConfigurationKeys.RESOURCES_URL) + "/" + name + "?v=" + version; else return c.get(com.wiris.quizzes.api.ConfigurationKeys.PROXY_URL) + "?service=resource&name=" + name + "&v=" + version;
	}
	,getConfiguration: function() {
		return com.wiris.quizzes.impl.ConfigurationImpl.getInstance();
	}
	,getMathFilter: function() {
		return new com.wiris.quizzes.impl.MathMLFilter();
	}
	,getQuizzesService: function() {
		return new com.wiris.quizzes.impl.QuizzesServiceImpl();
	}
	,newFeedbackRequest: function(html,instance) {
		if(instance == null) throw "The question instance cannot be null!";
		var r = this.newGradeRequest(instance);
		var qr = r;
		var qi = instance;
		qr.question = this.copyQuestion(qr.question);
		com.wiris.quizzes.impl.QuizzesImpl.setVariables(html,qr.question,qi,qr);
		return r;
	}
	,newGradeRequest: function(instance) {
		if(instance == null) throw "The question instance cannot be null!";
		return this.newEvalMultipleAnswersRequest(null,null,instance.question,instance);
	}
	,newVariablesRequestWithQuestionData: function(html,instance) {
		if(instance == null) throw "The question instance cannot be null!";
		var qi = instance;
		var question = qi.question;
		var sb = new StringBuf();
		if(question != null) {
			var slots = question.getSlots();
			var _g = 0;
			while(_g < slots.length) {
				var slot = slots[_g];
				++_g;
				if(slot.getSyntax().getName() == com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC) continue;
				if(slot.getInitialContent() != null) sb.b += Std.string(slot.getInitialContent() + " ");
				var authorAnswers = slot.getAuthorAnswers();
				var _g1 = 0;
				while(_g1 < authorAnswers.length) {
					var authorAnswer = authorAnswers[_g1];
					++_g1;
					if(authorAnswer.getValue() != null) sb.b += Std.string(authorAnswer.getValue() + " ");
				}
			}
		}
		if(html != null) sb.b += Std.string(html);
		return this.newVariablesRequest(sb.b,instance);
	}
	,copyQuestion: function(question) {
		var copy = this.newQuestion().getImpl();
		var original = question.getImpl();
		copy.id = original.id;
		copy.localData = original.localData;
		copy.assertions = original.assertions;
		copy.slots = original.slots;
		copy.correctAnswers = original.correctAnswers;
		copy.options = original.options;
		copy.wirisCasSession = original.wirisCasSession;
		return copy;
	}
	,newVariablesRequest: function(html,instance) {
		if(instance == null) throw "The question instance cannot be null!";
		var qi = instance;
		var question = qi.question;
		if(question == null) throw "The question must be specified, either as a parameter" + " of this function or as a field of the question instance";
		question = this.copyQuestion(question);
		var qr = new com.wiris.quizzes.impl.QuestionRequestImpl();
		qr.question = question;
		qr.userData = qi.userData;
		com.wiris.quizzes.impl.QuizzesImpl.setVariables(html,question,qi,qr);
		return qr;
	}
	,readQuestionInstance: function(xml,q) {
		var s = this.getSerializer();
		var elem = s.read(xml);
		var tag = s.getTagName(elem);
		if(!(tag == "questionInstance")) throw "Unexpected root tag " + tag + ". Expected questionInstance.";
		if(q != null) elem.question = q;
		return elem;
	}
	,readQuestion: function(xml) {
		return new com.wiris.quizzes.impl.QuestionLazy(xml);
	}
	,newQuestionInstance: function(q) {
		var qi = new com.wiris.quizzes.impl.QuestionInstanceImpl();
		qi.question = q;
		return qi;
	}
	,newQuestion: function() {
		return new com.wiris.quizzes.impl.QuestionImpl();
	}
	,getQuizzesComponentBuilder: function() {
		if(this.componentBuilder == null) this.componentBuilder = new com.wiris.quizzes.impl.QuizzesComponentBuilderImpl();
		return this.componentBuilder;
	}
	,tracker: null
	,telemetryService: null
	,accessProvider: null
	,locker: null
	,imagesCache: null
	,variablesCache: null
	,componentBuilder: null
	,__class__: com.wiris.quizzes.impl.QuizzesImpl
});
com.wiris.quizzes.JsQuizzes = $hxClasses["com.wiris.quizzes.JsQuizzes"] = function() {
	com.wiris.quizzes.impl.QuizzesImpl.call(this);
	var telemetryUrl = this.getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.TELEMETRY_URL);
	var telemetryToken = this.getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.TELEMETRY_TOKEN);
	var deploymentId = this.getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.DEPLOYMENT_ID);
	this.telemetryService = new com.wiris.util.telemetry.TelemetryServiceImpl(telemetryUrl,telemetryToken,deploymentId);
	this.telemetryService.getSender().setParameters(this.getTelemetryServerParameters());
	this.tracker = new com.wiris.quizzes.telemetry.QuizzesTracker(this.telemetryService);
};
com.wiris.quizzes.JsQuizzes.__name__ = ["com","wiris","quizzes","JsQuizzes"];
com.wiris.quizzes.JsQuizzes.singleton = null;
com.wiris.quizzes.JsQuizzes.getInstance = function() {
	if(com.wiris.quizzes.JsQuizzes.singleton == null) {
		com.wiris.quizzes.JsQuizzes.singleton = new com.wiris.quizzes.JsQuizzes();
		com.wiris.quizzes.impl.QuizzesImpl.singleton = com.wiris.quizzes.JsQuizzes.singleton;
	}
	return com.wiris.quizzes.JsQuizzes.singleton;
}
com.wiris.quizzes.JsQuizzes.__super__ = com.wiris.quizzes.impl.QuizzesImpl;
com.wiris.quizzes.JsQuizzes.prototype = $extend(com.wiris.quizzes.impl.QuizzesImpl.prototype,{
	getQuizzesService: function() {
		var config = com.wiris.quizzes.JsQuizzes.getInstance().getConfiguration();
		var offline = "true" == config.get(com.wiris.quizzes.api.ConfigurationKeys.SERVICE_OFFLINE);
		if(offline) return new com.wiris.quizzes.impl.OfflineQuizzesServiceImpl();
		return new com.wiris.quizzes.impl.QuizzesServiceImpl();
	}
	,canonicalURL: function(url) {
		var div = js.Lib.document.createElement("div");
		div.innerHTML = "<a></a>";
		div.firstChild.href = url;
		div.innerHTML = div.innerHTML;
		return div.firstChild.href;
	}
	,isHttps: function() {
		return js.Lib.window.location.protocol == "https:";
	}
	,isAbsolute: function(url) {
		return StringTools.startsWith(url,"http://") || StringTools.startsWith(url,"https://");
	}
	,getConfiguration: function() {
		if(this.config == null) {
			com.wiris.quizzes.impl.ConfigurationImpl.setIsHttps(this.isHttps());
			var c = com.wiris.quizzes.impl.ConfigurationImpl.getInstance();
			if(c.get(com.wiris.quizzes.api.ConfigurationKeys.RESOURCES_STATIC) == "true") {
				var scriptPath = com.wiris.system.JsDOMUtils.findServicePath("quizzes.js");
				if(scriptPath != null) {
					c.set(com.wiris.quizzes.api.ConfigurationKeys.RESOURCES_URL,scriptPath);
					com.wiris.system.JsDOMUtils.addEventListener(js.Lib.window,"beforeunload",function(e) {
						var data = com.wiris.quizzes.JsQuizzes.getInstance().getTelemetryService().getBatch();
						if(data != null) com.wiris.system.TelemetryUtils.sendBatch(data);
					});
				}
			}
			var urlconfigs = com.wiris.quizzes.impl.ConfigurationImpl.getUrlKeys();
			var _g = 0;
			while(_g < urlconfigs.length) {
				var key = urlconfigs[_g];
				++_g;
				var url = c.get(key);
				if(url != null) {
					if(!this.isAbsolute(url)) url = this.canonicalURL(url);
					c.set(key,url);
				}
			}
			this.config = c;
		}
		return this.config;
	}
	,getQuizzesComponentBuilder: function() {
		if(this.componentBuilder == null) this.componentBuilder = new com.wiris.quizzes.JsQuizzesApiComponentBuilder();
		return this.componentBuilder;
	}
	,getTelemetryServerParameters: function() {
		var h = com.wiris.system.TelemetryUtils.getSenderParameters();
		h.set(com.wiris.util.telemetry.Sender.PRODUCT_VERSION_KEY,this.getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.VERSION));
		return h;
	}
	,config: null
	,__class__: com.wiris.quizzes.JsQuizzes
});
com.wiris.quizzes.api.ui.QuizzesComponentBuilder = $hxClasses["com.wiris.quizzes.api.ui.QuizzesComponentBuilder"] = function() { }
com.wiris.quizzes.api.ui.QuizzesComponentBuilder.__name__ = ["com","wiris","quizzes","api","ui","QuizzesComponentBuilder"];
com.wiris.quizzes.api.ui.QuizzesComponentBuilder.prototype = {
	replaceFields: null
	,getMathViewer: null
	,newAuxiliaryCasField: null
	,newEmbeddedAnswersEditor: null
	,newAuthoringField: null
	,newAnswerField: null
	,newAnswerFeedback: null
	,setLanguage: null
	,__class__: com.wiris.quizzes.api.ui.QuizzesComponentBuilder
}
com.wiris.quizzes.impl.QuizzesComponentBuilderImpl = $hxClasses["com.wiris.quizzes.impl.QuizzesComponentBuilderImpl"] = function() {
};
com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.__name__ = ["com","wiris","quizzes","impl","QuizzesComponentBuilderImpl"];
com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.__interfaces__ = [com.wiris.quizzes.api.ui.QuizzesComponentBuilder];
com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology = function() {
	throw "Not implemented in server technology. This method should be called from client-side.";
}
com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.prototype = {
	replaceFields: function(question,instance,element) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,newAuxiliaryCasField: function(instance,slot) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
		return null;
	}
	,newEmbeddedAnswersEditor: function(question,instance) {
		return new com.wiris.quizzes.impl.EmbeddedAnswersEditorImpl(question,instance);
	}
	,newAuthoringField: function(question,slot,authorAnswer) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
		return null;
	}
	,newAnswerField: function(instance,slot) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
		return null;
	}
	,newAnswerFeedback: function(instance,slot,authorAnswer) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
		return null;
	}
	,getMathViewer: function() {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
		return null;
	}
	,setLanguage: function(lang) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,__class__: com.wiris.quizzes.impl.QuizzesComponentBuilderImpl
}
com.wiris.quizzes.JsQuizzesApiComponentBuilder = $hxClasses["com.wiris.quizzes.JsQuizzesApiComponentBuilder"] = function() {
	this.resourceLoader = com.wiris.quizzes.QuizzesResourceLoader.newInstance();
	var quizzesComponentBuilder = new com.wiris.quizzes.JsQuizzesComponentBuilder(this.resourceLoader);
	var jsComponentBuilder = new com.wiris.system.ui.JsComponentBuilder(this.resourceLoader);
	this.componentBuilder = new com.wiris.util.ui.component.CompoundComponentBuilder();
	this.componentBuilder.addComponentBuilder(quizzesComponentBuilder);
	this.componentBuilder.addComponentBuilder(jsComponentBuilder);
	com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.call(this);
};
com.wiris.quizzes.JsQuizzesApiComponentBuilder.__name__ = ["com","wiris","quizzes","JsQuizzesApiComponentBuilder"];
com.wiris.quizzes.JsQuizzesApiComponentBuilder.__super__ = com.wiris.quizzes.impl.QuizzesComponentBuilderImpl;
com.wiris.quizzes.JsQuizzesApiComponentBuilder.prototype = $extend(com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.prototype,{
	replaceFields: function(question,instance,element) {
		if(question == null) question = com.wiris.quizzes.api.Quizzes.getInstance().newQuestion();
		if(instance == null) instance = com.wiris.quizzes.api.Quizzes.getInstance().newQuestionInstance(question);
		var node = element;
		var filter = new com.wiris.quizzes.JsQuizzesFilter();
		filter.replaceFields(question,instance,node);
	}
	,getMathViewer: function() {
		return new com.wiris.quizzes.HxMathViewer();
	}
	,newAuxiliaryCasField: function(instance,slot) {
		if(instance == null) {
			var question = com.wiris.quizzes.api.Quizzes.getInstance().newQuestion();
			slot = question.addNewSlot();
			instance = com.wiris.quizzes.api.Quizzes.getInstance().newQuestionInstance(question);
		}
		return new com.wiris.quizzes.impl.ui.AuxiliaryCalcInputImpl(instance,slot,this.componentBuilder);
	}
	,newEmbeddedAnswersEditor: function(question,instance) {
		if(question == null) question = com.wiris.quizzes.api.Quizzes.getInstance().newQuestion();
		if(instance == null) instance = com.wiris.quizzes.api.Quizzes.getInstance().newQuestionInstance(question);
		return new com.wiris.quizzes.JsEmbeddedAnswersEditor(question,instance,this.componentBuilder);
	}
	,newAuthoringField: function(question,slot,authorAnswer) {
		if(question == null) question = com.wiris.quizzes.api.Quizzes.getInstance().newQuestion();
		if(slot == null) slot = question.addNewSlot();
		if(authorAnswer == null) authorAnswer = slot.addNewAuthorAnswer("");
		var studioContext = new com.wiris.quizzes.impl.ui.QuizzesStudioContext(question,slot,authorAnswer);
		return new com.wiris.quizzes.impl.ui.AuthoringFieldImpl(studioContext,this.componentBuilder);
	}
	,newAnswerField: function(instance,slot) {
		if(instance == null) {
			var question = com.wiris.quizzes.api.Quizzes.getInstance().newQuestion();
			slot = question.addNewSlot();
			instance = com.wiris.quizzes.api.Quizzes.getInstance().newQuestionInstance(question);
		}
		return new com.wiris.quizzes.impl.ui.AnswerFieldImpl(instance,slot,this.componentBuilder);
	}
	,newAnswerFeedback: function(instance,slot,authorAnswer) {
		var question = this.getQuestionFromInstance(instance);
		if(instance == null) {
			slot = question.addNewSlot();
			authorAnswer = slot.addNewAuthorAnswer("");
			instance = com.wiris.quizzes.api.Quizzes.getInstance().newQuestionInstance(question);
		}
		return new com.wiris.quizzes.impl.ui.AnswerFeedbackImpl(instance,slot,authorAnswer,this.componentBuilder);
	}
	,getQuestionFromInstance: function(instance) {
		var question;
		if(instance == null) question = com.wiris.quizzes.api.Quizzes.getInstance().newQuestion(); else {
			var instanceImpl = js.Boot.__cast(instance , com.wiris.quizzes.impl.QuestionInstanceImpl);
			if(instanceImpl == null) {
				question = com.wiris.quizzes.api.Quizzes.getInstance().newQuestion();
				instanceImpl.question = js.Boot.__cast(question , com.wiris.quizzes.impl.QuestionInternal);
			} else question = instanceImpl.question;
		}
		return question;
	}
	,setLanguage: function(lang) {
		com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().setLanguage(lang);
	}
	,componentBuilder: null
	,resourceLoader: null
	,__class__: com.wiris.quizzes.JsQuizzesApiComponentBuilder
});
com.wiris.quizzes.api.QuizzesBuilder = $hxClasses["com.wiris.quizzes.api.QuizzesBuilder"] = function() {
};
com.wiris.quizzes.api.QuizzesBuilder.__name__ = ["com","wiris","quizzes","api","QuizzesBuilder"];
com.wiris.quizzes.api.QuizzesBuilder.getInstance = function() {
	return com.wiris.quizzes.JsQuizzesBuilder.getInstance();
}
com.wiris.quizzes.api.QuizzesBuilder.prototype = {
	newFeaturedAssertionsRequest: function(question) {
		return null;
	}
	,newFeaturedSyntaxAssertionsRequest: function(question) {
		return null;
	}
	,getResourceUrl: function(name) {
		return null;
	}
	,getQuizzesUIBuilder: function() {
		return null;
	}
	,getConfiguration: function() {
		return null;
	}
	,getMathFilter: function() {
		return null;
	}
	,getQuizzesService: function() {
		return null;
	}
	,newGradeRequest: function(question,instance) {
		return null;
	}
	,newFeedbackRequest: function(html,question,instance) {
		return null;
	}
	,newEvalMultipleAnswersRequest: function(correctAnswer,studentAnswer,question,instance) {
		return null;
	}
	,newEvalRequest: function(correctAnswer,studentAnswer,question,instance) {
		return null;
	}
	,newVariablesRequest: function(html,question,instance) {
		return null;
	}
	,readQuestionInstance: function(xml) {
		return null;
	}
	,readQuestion: function(xml) {
		return null;
	}
	,newQuestionInstanceImpl: function(question) {
		return null;
	}
	,newQuestionInstance: function(question) {
		return this.newQuestionInstanceImpl(question);
	}
	,newQuestion: function() {
		return null;
	}
	,__class__: com.wiris.quizzes.api.QuizzesBuilder
}
com.wiris.quizzes.impl.QuizzesBuilderImpl = $hxClasses["com.wiris.quizzes.impl.QuizzesBuilderImpl"] = function() {
	this.uibuilder = null;
	com.wiris.quizzes.api.QuizzesBuilder.call(this);
};
com.wiris.quizzes.impl.QuizzesBuilderImpl.__name__ = ["com","wiris","quizzes","impl","QuizzesBuilderImpl"];
com.wiris.quizzes.impl.QuizzesBuilderImpl.getInstance = function() {
	if(com.wiris.quizzes.impl.QuizzesBuilderImpl.singleton == null) com.wiris.quizzes.impl.QuizzesBuilderImpl.singleton = new com.wiris.quizzes.impl.QuizzesBuilderImpl();
	return com.wiris.quizzes.impl.QuizzesBuilderImpl.singleton;
}
com.wiris.quizzes.impl.QuizzesBuilderImpl.__super__ = com.wiris.quizzes.api.QuizzesBuilder;
com.wiris.quizzes.impl.QuizzesBuilderImpl.prototype = $extend(com.wiris.quizzes.api.QuizzesBuilder.prototype,{
	setQuestionInInstance: function(question,questionInstance) {
		if(questionInstance == null) questionInstance = new com.wiris.quizzes.impl.QuestionInstanceImpl();
		questionInstance.question = question;
		return questionInstance;
	}
	,getAccessProvider: function() {
		return com.wiris.quizzes.impl.QuizzesImpl.getInstance().getAccessProvider();
	}
	,getLockProvider: function() {
		return com.wiris.quizzes.impl.QuizzesImpl.getInstance().getLockProvider();
	}
	,getVariablesCache: function() {
		return com.wiris.quizzes.impl.QuizzesImpl.getInstance().getVariablesCache();
	}
	,getImagesCache: function() {
		return com.wiris.quizzes.impl.QuizzesImpl.getInstance().getImagesCache();
	}
	,getResourceUrl: function(name) {
		return com.wiris.quizzes.impl.QuizzesImpl.getInstance().getResourceUrl(name);
	}
	,newTranslationRequest: function(q,lang) {
		return com.wiris.quizzes.impl.QuizzesImpl.getInstance().newTranslationRequest(q,lang);
	}
	,newFeedbackRequest: function(html,question,instance) {
		return com.wiris.quizzes.impl.QuizzesImpl.getInstance().newFeedbackRequest(html,this.setQuestionInInstance(question,instance));
	}
	,newEvalMultipleAnswersRequest: function(correctAnswers,userAnswers,question,instance) {
		return com.wiris.quizzes.impl.QuizzesImpl.getInstance().newEvalMultipleAnswersRequest(correctAnswers,userAnswers,question,instance);
	}
	,newEvalRequest: function(correctAnswer,userAnswer,q,qi) {
		var correctAnswers = correctAnswer == null?null:[correctAnswer];
		var userAnswers = userAnswer == null?null:[userAnswer];
		return this.newEvalMultipleAnswersRequest(correctAnswers,userAnswers,q,qi);
	}
	,getConfiguration: function() {
		return com.wiris.quizzes.impl.QuizzesImpl.getInstance().getConfiguration();
	}
	,newVariablesRequest: function(html,question,instance) {
		return com.wiris.quizzes.impl.QuizzesImpl.getInstance().newVariablesRequest(html,this.setQuestionInInstance(question,instance));
	}
	,readQuestionInstance: function(xml) {
		return com.wiris.quizzes.impl.QuizzesImpl.getInstance().readQuestionInstance(xml,this.newQuestion());
	}
	,readQuestion: function(xml) {
		return com.wiris.quizzes.impl.QuizzesImpl.getInstance().readQuestion(xml);
	}
	,getMathFilter: function() {
		return com.wiris.quizzes.impl.QuizzesImpl.getInstance().getMathFilter();
	}
	,getQuizzesService: function() {
		return com.wiris.quizzes.impl.QuizzesImpl.getInstance().getQuizzesService();
	}
	,newQuestionInstanceImpl: function(question) {
		return com.wiris.quizzes.impl.QuizzesImpl.getInstance().newQuestionInstance(question);
	}
	,newQuestion: function() {
		return com.wiris.quizzes.impl.QuizzesImpl.getInstance().newQuestion();
	}
	,getQuizzesUIBuilder: function() {
		if(this.uibuilder == null) this.uibuilder = new com.wiris.quizzes.impl.QuizzesUIBuilderImpl();
		return this.uibuilder;
	}
	,uibuilder: null
	,__class__: com.wiris.quizzes.impl.QuizzesBuilderImpl
});
com.wiris.quizzes.JsQuizzesBuilder = $hxClasses["com.wiris.quizzes.JsQuizzesBuilder"] = function() {
	com.wiris.quizzes.impl.QuizzesBuilderImpl.call(this);
};
com.wiris.quizzes.JsQuizzesBuilder.__name__ = ["com","wiris","quizzes","JsQuizzesBuilder"];
com.wiris.quizzes.JsQuizzesBuilder.singleton = null;
com.wiris.quizzes.JsQuizzesBuilder.getInstance = function() {
	if(com.wiris.quizzes.JsQuizzesBuilder.singleton == null) com.wiris.quizzes.JsQuizzesBuilder.singleton = new com.wiris.quizzes.JsQuizzesBuilder();
	return com.wiris.quizzes.JsQuizzesBuilder.singleton;
}
com.wiris.quizzes.JsQuizzesBuilder.__super__ = com.wiris.quizzes.impl.QuizzesBuilderImpl;
com.wiris.quizzes.JsQuizzesBuilder.prototype = $extend(com.wiris.quizzes.impl.QuizzesBuilderImpl.prototype,{
	getQuizzesService: function() {
		return com.wiris.quizzes.JsQuizzes.getInstance().getQuizzesService();
	}
	,getConfiguration: function() {
		return com.wiris.quizzes.JsQuizzes.getInstance().getConfiguration();
	}
	,__class__: com.wiris.quizzes.JsQuizzesBuilder
});
if(!com.wiris.util.ui) com.wiris.util.ui = {}
if(!com.wiris.util.ui.component) com.wiris.util.ui.component = {}
com.wiris.util.ui.component.ComponentBuilder = $hxClasses["com.wiris.util.ui.component.ComponentBuilder"] = function() { }
com.wiris.util.ui.component.ComponentBuilder.__name__ = ["com","wiris","util","ui","component","ComponentBuilder"];
com.wiris.util.ui.component.ComponentBuilder.prototype = {
	setMainComponentBuilder: null
	,buildComponent: null
	,__class__: com.wiris.util.ui.component.ComponentBuilder
}
if(!com.wiris.system) com.wiris.system = {}
if(!com.wiris.system.ui) com.wiris.system.ui = {}
com.wiris.system.ui.JsComponentBuilder = $hxClasses["com.wiris.system.ui.JsComponentBuilder"] = function(resourceLoader) {
	this.resourceLoader = resourceLoader;
	this.mainBuilder = this;
};
com.wiris.system.ui.JsComponentBuilder.__name__ = ["com","wiris","system","ui","JsComponentBuilder"];
com.wiris.system.ui.JsComponentBuilder.__interfaces__ = [com.wiris.util.ui.component.ComponentBuilder];
com.wiris.system.ui.JsComponentBuilder.prototype = {
	buildComponent: function(component,parent) {
		component.setComponentBuilder(this.mainBuilder);
		var jsComponent = null;
		if(js.Boot.__instanceof(component,com.wiris.util.ui.component.Panel)) {
			if(js.Boot.__instanceof(component,com.wiris.util.ui.component.ContextPanel)) jsComponent = new com.wiris.system.ui.JsContextPanel(js.Boot.__cast(component , com.wiris.util.ui.component.ContextPanel)); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.ButtonPanel)) jsComponent = new com.wiris.system.ui.JsButtonPanel(js.Boot.__cast(component , com.wiris.util.ui.component.ButtonPanel)); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.PlotterPanel)) jsComponent = new com.wiris.system.ui.JsPlotterPanel(js.Boot.__cast(component , com.wiris.util.ui.component.PlotterPanel),this.resourceLoader); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.OpenIdSignInPanel)) jsComponent = new com.wiris.system.ui.JsOpenIdSignInPanel(js.Boot.__cast(component , com.wiris.util.ui.component.OpenIdSignInPanel),this.resourceLoader); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.FloatingPanel)) jsComponent = new com.wiris.system.ui.JsFloatingPanel(js.Boot.__cast(component , com.wiris.util.ui.component.FloatingPanel)); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.DrawingPanel)) jsComponent = new com.wiris.system.ui.JsDrawingPanel(js.Boot.__cast(component , com.wiris.util.ui.component.DrawingPanel)); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.TabbedPanel)) jsComponent = new com.wiris.system.ui.JsTabbedPanel(js.Boot.__cast(component , com.wiris.util.ui.component.TabbedPanel),this.resourceLoader); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.OpenFileDialog)) jsComponent = new com.wiris.system.ui.JsOpenFileDialog(js.Boot.__cast(component , com.wiris.util.ui.component.OpenFileDialog)); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.ExpansionPanel)) jsComponent = new com.wiris.system.ui.JsExpansionPanel(js.Boot.__cast(component , com.wiris.util.ui.component.ExpansionPanel)); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.ResponsiveToolbar)) jsComponent = new com.wiris.system.ui.JsResponsiveToolbar(js.Boot.__cast(component , com.wiris.util.ui.component.ResponsiveToolbar)); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.DrawerPanel)) jsComponent = new com.wiris.system.ui.JsDrawerPanel(js.Boot.__cast(component , com.wiris.util.ui.component.DrawerPanel)); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.ActivityContainer)) jsComponent = new com.wiris.system.ui.JsActivityContainer(js.Boot.__cast(component , com.wiris.util.ui.component.ActivityContainer)); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.DialogStack)) jsComponent = new com.wiris.system.ui.JsDialogStack(js.Boot.__cast(component , com.wiris.util.ui.component.DialogStack)); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.Window)) jsComponent = new com.wiris.system.ui.JsWindow(js.Boot.__cast(component , com.wiris.util.ui.component.Window)); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.CheckBox)) jsComponent = new com.wiris.system.ui.JsCheckBox(js.Boot.__cast(component , com.wiris.util.ui.component.CheckBox)); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.RadioButton)) jsComponent = new com.wiris.system.ui.JsRadioButton(js.Boot.__cast(component , com.wiris.util.ui.component.RadioButton)); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.BorderPanel)) jsComponent = new com.wiris.system.ui.JsBorderPanel(js.Boot.__cast(component , com.wiris.util.ui.component.BorderPanel)); else jsComponent = new com.wiris.system.ui.JsPanel(js.Boot.__cast(component , com.wiris.util.ui.component.Panel));
		} else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.Button)) {
			if(js.Boot.__instanceof(component,com.wiris.util.ui.component.Dropdown)) jsComponent = new com.wiris.system.ui.JsDropdown(js.Boot.__cast(component , com.wiris.util.ui.component.Dropdown),this.resourceLoader); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.SignInButton)) jsComponent = new com.wiris.system.ui.JsSignInButton(js.Boot.__cast(component , com.wiris.util.ui.component.SignInButton),this.resourceLoader); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.ContextPanelButton)) jsComponent = new com.wiris.system.ui.JsContextPanelButton(js.Boot.__cast(component , com.wiris.util.ui.component.ContextPanelButton),this.resourceLoader); else jsComponent = new com.wiris.system.ui.JsButton(js.Boot.__cast(component , com.wiris.util.ui.component.Button),this.resourceLoader);
		} else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.Chip)) jsComponent = new com.wiris.system.ui.JsChip(js.Boot.__cast(component , com.wiris.util.ui.component.Chip),this.resourceLoader); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.Switch)) jsComponent = new com.wiris.system.ui.JsSwitch(js.Boot.__cast(component , com.wiris.util.ui.component.Switch)); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.TextComponent)) {
			if(js.Boot.__instanceof(component,com.wiris.util.ui.component.DropdownTextField)) jsComponent = new com.wiris.system.ui.JsDropdownTextField(js.Boot.__cast(component , com.wiris.util.ui.component.DropdownTextField)); else jsComponent = new com.wiris.system.ui.JsTextComponent(js.Boot.__cast(component , com.wiris.util.ui.component.TextComponent));
		} else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.Label)) {
			if(js.Boot.__instanceof(component,com.wiris.util.ui.component.CompositeLabel)) jsComponent = new com.wiris.system.ui.JsCompositeLabel(js.Boot.__cast(component , com.wiris.util.ui.component.CompositeLabel)); else jsComponent = new com.wiris.system.ui.JsLabel(js.Boot.__cast(component , com.wiris.util.ui.component.Label));
		} else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.ProgressBar)) jsComponent = new com.wiris.system.ui.JsProgressBar(js.Boot.__cast(component , com.wiris.util.ui.component.ProgressBar)); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.ProgressCircle)) jsComponent = new com.wiris.system.ui.JsProgressCircle(js.Boot.__cast(component , com.wiris.util.ui.component.ProgressCircle)); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.FormulaViewer)) jsComponent = new com.wiris.system.ui.JsFormulaViewer(js.Boot.__cast(component , com.wiris.util.ui.component.FormulaViewer)); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.IconBox)) jsComponent = new com.wiris.system.ui.JsIconBox(js.Boot.__cast(component , com.wiris.util.ui.component.IconBox),this.resourceLoader); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.ImageContainer)) jsComponent = new com.wiris.system.ui.JsImageContainer(js.Boot.__cast(component , com.wiris.util.ui.component.ImageContainer)); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.Slider)) jsComponent = new com.wiris.system.ui.JsSlider(js.Boot.__cast(component , com.wiris.util.ui.component.Slider)); else if(js.Boot.__instanceof(component,com.wiris.util.ui.component.ShadowComponent)) jsComponent = new com.wiris.system.ui.JsShadowComponent(js.Boot.__cast(component , com.wiris.util.ui.component.ShadowComponent));
		if(jsComponent != null) {
			if(parent != null) jsComponent.setParent(parent);
			jsComponent.getElement();
			return jsComponent;
		}
		return null;
	}
	,setMainComponentBuilder: function(builder) {
		this.mainBuilder = builder;
	}
	,mainBuilder: null
	,resourceLoader: null
	,__class__: com.wiris.system.ui.JsComponentBuilder
}
com.wiris.quizzes.JsQuizzesComponentBuilder = $hxClasses["com.wiris.quizzes.JsQuizzesComponentBuilder"] = function(resourceLoader) {
	com.wiris.system.ui.JsComponentBuilder.call(this,resourceLoader);
};
com.wiris.quizzes.JsQuizzesComponentBuilder.__name__ = ["com","wiris","quizzes","JsQuizzesComponentBuilder"];
com.wiris.quizzes.JsQuizzesComponentBuilder.__super__ = com.wiris.system.ui.JsComponentBuilder;
com.wiris.quizzes.JsQuizzesComponentBuilder.prototype = $extend(com.wiris.system.ui.JsComponentBuilder.prototype,{
	buildComponent: function(component,parent) {
		component.setComponentBuilder(this.mainBuilder);
		var jsComponent = null;
		if(js.Boot.__instanceof(component,com.wiris.quizzes.impl.ui.EmbeddedAuthoringField)) jsComponent = new com.wiris.quizzes.ui.JsEmbeddedAuthoringField(js.Boot.__cast(component , com.wiris.quizzes.impl.ui.EmbeddedAuthoringField)); else if(js.Boot.__instanceof(component,com.wiris.quizzes.impl.ui.component.MathTypeInputComponent)) jsComponent = new com.wiris.quizzes.ui.JsMathTypeInputComponent(js.Boot.__cast(component , com.wiris.quizzes.impl.ui.component.MathTypeInputComponent),this.resourceLoader); else if(js.Boot.__instanceof(component,com.wiris.quizzes.impl.ui.component.GraphInputComponent)) jsComponent = new com.wiris.quizzes.ui.JsGraphInputComponent(js.Boot.__cast(component , com.wiris.quizzes.impl.ui.component.GraphInputComponent),this.resourceLoader); else if(js.Boot.__instanceof(component,com.wiris.quizzes.impl.ui.component.CalcMeInputComponent)) jsComponent = new com.wiris.quizzes.ui.JsCalcMeInputComponent(js.Boot.__cast(component , com.wiris.quizzes.impl.ui.component.CalcMeInputComponent)); else if(js.Boot.__instanceof(component,com.wiris.quizzes.impl.ui.component.WirisCasInputComponent)) jsComponent = new com.wiris.quizzes.ui.JsWirisCasInputComponent(js.Boot.__cast(component , com.wiris.quizzes.impl.ui.component.WirisCasInputComponent)); else if(js.Boot.__instanceof(component,com.wiris.quizzes.impl.ui.component.MathTextField)) {
			if(js.Boot.__instanceof(component,com.wiris.quizzes.impl.ui.component.PopupTextField)) {
				if(js.Boot.__instanceof(component,com.wiris.quizzes.impl.ui.component.QuizzesStudioPopupTextField)) jsComponent = new com.wiris.quizzes.ui.JsQuizzesStudioPopupTextField(js.Boot.__cast(component , com.wiris.quizzes.impl.ui.component.QuizzesStudioPopupTextField)); else jsComponent = new com.wiris.quizzes.ui.JsPopupTextField(js.Boot.__cast(component , com.wiris.quizzes.impl.ui.component.PopupTextField));
			} else jsComponent = new com.wiris.quizzes.ui.JsMathTextField(js.Boot.__cast(component , com.wiris.quizzes.impl.ui.component.MathTextField));
		} else if(js.Boot.__instanceof(component,com.wiris.quizzes.impl.ui.component.MathLabel)) jsComponent = new com.wiris.quizzes.ui.JsMathLabel(js.Boot.__cast(component , com.wiris.quizzes.impl.ui.component.MathLabel)); else if(js.Boot.__instanceof(component,com.wiris.quizzes.impl.ui.AnswerFieldImpl)) jsComponent = new com.wiris.quizzes.ui.JsAnswerFieldComponent(js.Boot.__cast(component , com.wiris.quizzes.impl.ui.AnswerFieldImpl)); else if(js.Boot.__instanceof(component,com.wiris.quizzes.impl.ui.AuthoringFieldImpl)) jsComponent = new com.wiris.quizzes.ui.JsAuthoringFieldComponent(js.Boot.__cast(component , com.wiris.quizzes.impl.ui.AuthoringFieldImpl));
		if(jsComponent != null) {
			if(parent != null) jsComponent.setParent(parent);
			jsComponent.getElement();
			return jsComponent;
		}
		return null;
	}
	,__class__: com.wiris.quizzes.JsQuizzesComponentBuilder
});
com.wiris.quizzes.JsQuizzesFilter = $hxClasses["com.wiris.quizzes.JsQuizzesFilter"] = function() {
	this.defaultInstance = null;
	this.defaultQuestion = null;
	this.builder = com.wiris.quizzes.api.Quizzes.getInstance();
	this.uibuilder = this.builder.getQuizzesComponentBuilder();
};
com.wiris.quizzes.JsQuizzesFilter.__name__ = ["com","wiris","quizzes","JsQuizzesFilter"];
com.wiris.quizzes.JsQuizzesFilter.main = function() {
	if(js.Lib.document.readyState == "complete") com.wiris.quizzes.JsQuizzesFilter.init(); else com.wiris.quizzes.JsDomUtils.addEvent(js.Lib.window,"load",function(e) {
		com.wiris.quizzes.JsQuizzesFilter.init();
	});
	delete Array.prototype.__class__;
}
com.wiris.quizzes.JsQuizzesFilter.init = function() {
	new com.wiris.quizzes.JsQuizzesFilter().run();
}
com.wiris.quizzes.JsQuizzesFilter.prototype = {
	copyStyle: function(oldElement,newElement) {
		var doc = element.ownerDocument;
		var width = com.wiris.quizzes.JsDomUtils.getComputedStyle(doc,oldElement,"width");
		newElement.style.width = width;
	}
	,getSubmitElements: function(elem) {
		var submits = new Array();
		var form = elem.form;
		if(form != null) {
			var markedSubmits = com.wiris.quizzes.JsDomUtils.getElementsByClassName(com.wiris.quizzes.JsQuizzesFilter.CLASS_SUBMIT,null,form);
			if(markedSubmits.length > 0) {
				var submit;
				var _g = 0;
				while(_g < markedSubmits.length) {
					var submit1 = markedSubmits[_g];
					++_g;
					submits.push(submit1);
				}
			} else {
				var inputs = form.getElementsByTagName("input");
				var i;
				var _g1 = 0, _g = inputs.length;
				while(_g1 < _g) {
					var i1 = _g1++;
					if(inputs[i1].getAttribute("type") == "submit") submits.push(inputs[i1]);
				}
			}
		}
		return submits;
	}
	,getUniqueId: function(prefix) {
		var ident = prefix + Std.random(65536);
		while(js.Lib.document.getElementById(ident) != null) ident = prefix + Std.random(65536);
		return ident;
	}
	,getInstanceObject: function(instanceElement) {
		if(instanceElement == null) {
			if(this.defaultInstance == null) this.defaultInstance = com.wiris.quizzes.api.Quizzes.getInstance().newQuestionInstance(com.wiris.quizzes.api.Quizzes.getInstance().newQuestion());
			return this.defaultInstance;
		}
		if(instanceElement.id == null || instanceElement.id == "") instanceElement.id = this.getUniqueId("wirisquestioninstance");
		if(!this.instances.exists(instanceElement.id)) {
			var instance;
			var question;
			if(this.questions.exists(instanceElement.id)) question = this.questions.get(instanceElement.id); else question = com.wiris.quizzes.api.Quizzes.getInstance().newQuestion();
			if(instanceElement.value == "") instance = com.wiris.quizzes.api.Quizzes.getInstance().newQuestionInstance(question); else instance = com.wiris.quizzes.api.Quizzes.getInstance().readQuestionInstance(instanceElement.value,question);
			this.instances.set(instanceElement.id,instance);
		}
		return this.instances.get(instanceElement.id);
	}
	,getQuestionObject: function(questionElement) {
		if(questionElement == null) {
			if(this.defaultQuestion == null) this.defaultQuestion = com.wiris.quizzes.api.Quizzes.getInstance().newQuestion();
			return this.defaultQuestion;
		}
		if(questionElement.id == null || questionElement.id == "") questionElement.id = this.getUniqueId("wirisquestion");
		if(!this.questions.exists(questionElement.id)) {
			var question;
			if(questionElement.value == "") question = com.wiris.quizzes.api.Quizzes.getInstance().newQuestion(); else {
				question = com.wiris.quizzes.api.Quizzes.getInstance().readQuestion(questionElement.value);
				question.getImpl().forceSlotStructure();
			}
			this.questions.set(questionElement.id,question);
		}
		return this.questions.get(questionElement.id);
	}
	,filterAnswerFeedback: function(element,index,question,instance,options) {
		var component = this.createAnswerFeedback(index,question,instance,options,null,null);
		if(component != null) element.parentNode.insertBefore(component.getElement(),element);
	}
	,cloneLastSlotUntilIndexAchieved: function(question,slots,index) {
		if(index < 0 || index < slots.length) return;
		var model = slots.length > 0?slots[slots.length - 1]:null;
		while(slots.length <= index) slots.push(question.addNewSlotFromModel(model));
	}
	,createAnswerFeedback: function(index,question,instance,options,slot,authorAnswer) {
		var component = null;
		var ii = instance;
		var incorrectClass = com.wiris.quizzes.JsDomUtils.hasClassString(options,"wirisincorrect");
		var correctClass = com.wiris.quizzes.JsDomUtils.hasClassString(options,"wiriscorrect");
		var partiallyCorrectClass = com.wiris.quizzes.JsDomUtils.hasClassString(options,"wirispartiallycorrect");
		if(ii.hasEvaluation() || incorrectClass || correctClass || partiallyCorrectClass) {
			var cfg = new com.wiris.quizzes.impl.HtmlUiConfig(options);
			ii.cloneCheckStructureIntoQuestion(question);
			ii.question = question;
			if(slot == null) {
				var slots = question.getSlots();
				this.cloneLastSlotUntilIndexAchieved(question,slots,index);
				slot = slots[index];
			}
			if(authorAnswer == null) {
				var correctAnswer = ii.getMatchingCorrectAnswer(index,question);
				var authorAnswers = slot.getAuthorAnswers();
				var _g = 0;
				while(_g < authorAnswers.length) {
					var aa = authorAnswers[_g];
					++_g;
					var aai = aa;
					if(Std.parseInt(aai.id) == correctAnswer) {
						authorAnswer = aai;
						break;
					}
				}
			}
			component = this.uibuilder.newAnswerFeedback(instance,slot,authorAnswer);
			component.showCorrectAnswerFeedback(cfg.showCorrectAnswerFeedback);
			component.showAssertionsFeedback(cfg.showAssertionsFeedback);
			component.showFieldDecorationFeedback(cfg.showFieldDecorationFeedback);
			if(incorrectClass) component.setAnswerWeight(0.0); else if(partiallyCorrectClass) component.setAnswerWeight(0.5); else if(correctClass) component.setAnswerWeight(1);
		}
		return component;
	}
	,filterAuxiliarCasApplet: function(element,index,question,questionElement,instance,instanceElement,options) {
		var qq = question.getImpl();
		var instanceImpl = instance;
		instanceImpl.question = question;
		var slots = question.getSlots();
		this.cloneLastSlotUntilIndexAchieved(question,slots,index);
		var slot = slots[index];
		if(qq.getProperty(com.wiris.quizzes.api.PropertyName.SHOW_CAS) != com.wiris.quizzes.impl.LocalData.VALUE_SHOW_CAS_FALSE || slot.getProperty(com.wiris.quizzes.api.PropertyName.SHOW_CAS) != com.wiris.quizzes.impl.LocalData.VALUE_SHOW_CAS_FALSE) {
			var component = this.uibuilder.newAuxiliaryCasField(instance,slot);
			component.addQuizzesFieldListener(new com.wiris.quizzes.FieldSynchronizer(element,instanceElement,instance));
			element.parentNode.insertBefore(component.getElement(),element);
		}
	}
	,filterAnswerField: function(element,index,question,questionElement,instance,instanceElement,options,submitElements) {
		var cfg = new com.wiris.quizzes.impl.HtmlUiConfig(options);
		var embedded = com.wiris.quizzes.JsDomUtils.hasClassString(options,"wirisembedded");
		var readOnly = com.wiris.quizzes.JsDomUtils.hasClassString(options,"wirisreadonly");
		if(embedded) {
			var qq = question.getImpl();
			if(qq.getLocalData(com.wiris.quizzes.impl.LocalData.KEY_OPENANSWER_INPUT_FIELD) == com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_INPUT_FIELD_INLINE_EDITOR) qq.setLocalData(com.wiris.quizzes.impl.LocalData.KEY_OPENANSWER_INPUT_FIELD,com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_INPUT_FIELD_PLAIN_TEXT);
		}
		var instanceImpl = instance;
		instanceImpl.question = question;
		var slots = question.getSlots();
		this.cloneLastSlotUntilIndexAchieved(question,slots,index);
		var slot = slots[index];
		var elemValue = element.value;
		if(elemValue != null || elemValue != "") {
			if(elemValue.indexOf("&lt;math") != -1) elemValue = com.wiris.util.xml.WXmlUtils.htmlUnescape(elemValue);
			instance.setSlotAnswer(slot,elemValue);
		}
		var component = this.uibuilder.newAnswerField(instance,slot);
		if(readOnly) component.setReadOnly(readOnly);
		component.addQuizzesFieldListener(new com.wiris.quizzes.FieldSynchronizer(element,instanceElement,instance,submitElements));
		var answerElement = component.getElement();
		if(embedded) component.setEmbeddedAnswerFieldStyle(true);
		if(com.wiris.quizzes.JsDomUtils.hasClassString(options,"wiriscopystyle")) {
			var width = element.clientWidth;
			var size = element.size;
			if(width > component.getComponent().getStyle().getMinWidth()) component.getComponent().getStyle().setMinWidth(width);
			component.setTextInputSize(size);
		}
		element.parentNode.insertBefore(answerElement,element);
		if(com.wiris.quizzes.JsDomUtils.hasClassString(options,"wirisembeddedfeedback")) {
			var authorAnswer = null;
			if(element.getAttribute("wirisauthoranswer") != null) {
				var authorAnswerId = Std.parseInt(element.getAttribute("wirisauthoranswer"));
				var authorAnswers = slot.getAuthorAnswers();
				var _g = 0;
				while(_g < authorAnswers.length) {
					var aa = authorAnswers[_g];
					++_g;
					var aai = aa;
					if(Std.parseInt(aai.id) == authorAnswerId) {
						authorAnswer = aai;
						break;
					}
				}
			}
			var feedback = this.createAnswerFeedback(index,question,instance,options,slot,authorAnswer);
			if(feedback != null) feedback.setEmbedded(component);
		}
		if(instanceElement != null) this.numUserAnswers.set(instanceElement.id,this.numUserAnswers.exists(instanceElement.id)?this.numUserAnswers.get(instanceElement.id) + 1:1);
	}
	,findAuthorAnswer: function(s,index) {
		var authorAnswers = s.getAuthorAnswers();
		var _g = 0;
		while(_g < authorAnswers.length) {
			var aa = authorAnswers[_g];
			++_g;
			var aai = aa;
			if(Std.parseInt(aai.id) == index) return aai;
		}
		return null;
	}
	,filterAuthoringField: function(element,index,question,questionElement,instance,instanceElement,options) {
		var cfg = new com.wiris.quizzes.impl.HtmlUiConfig(options);
		if(cfg.optOpenAnswer && element.value != null && element.value.length > 0) question.setCorrectAnswer(index,element.value);
		var slotId = -1;
		if(element.getAttribute("wirisslot") != null) slotId = Std.parseInt(element.getAttribute("wirisslot"));
		var slot = null;
		var authorAnswer = null;
		var slots = question.getSlots();
		if(slotId >= 0 && slots.length > slotId) {
			slot = slots[slotId];
			authorAnswer = this.findAuthorAnswer(slot,index);
		} else {
			var _g = 0;
			while(_g < slots.length) {
				var s = slots[_g];
				++_g;
				authorAnswer = this.findAuthorAnswer(s,index);
				if(authorAnswer != null) {
					slot = s;
					break;
				}
			}
		}
		if(slot == null) slot = question.addNewSlot();
		if(authorAnswer == null) while(authorAnswer == null || Std.parseInt(authorAnswer.id) < index) authorAnswer = slot.addNewAuthorAnswer("");
		var component = this.uibuilder.newAuthoringField(question,slot,authorAnswer);
		if(com.wiris.quizzes.JsDomUtils.hasClassString(options,"wirisstudio")) {
			component.setFieldType(com.wiris.quizzes.api.ui.AuthoringFieldType.STUDIO);
			component.showGradingCriteria(cfg.gradingCriteria);
			component.showVariablesDefinition(cfg.variablesDefinition);
			component.showCorrectAnswer(cfg.optOpenAnswer);
			component.showAuxiliaryCas(cfg.optAuxiliaryCas);
			component.showAuxiliaryCasReplaceEditor(cfg.optAuxiliaryCasReplaceEditor);
			component.showAuxiliaryTextInput(cfg.optAuxiliaryTextInput);
			component.showGradingFunction(cfg.optGradingFunction);
			component.showGraphicSyntax(cfg.optGraphicSyntax);
			component.showAnswerFieldPlainText(cfg.optAnswerFieldPlainText);
			component.showAnswerFieldPopupEditor(cfg.optAnswerFieldPopupEditor);
			component.showAnswerFieldInlineEditor(cfg.optAnswerFieldInlineEditor);
		}
		component.addQuizzesFieldListener(new com.wiris.quizzes.FieldSynchronizer(element,questionElement,question));
		element.parentNode.insertBefore(component.getElement(),element);
		if(questionElement != null) {
			if(cfg.optOpenAnswer) this.numCorrectAnswers.set(questionElement.id,this.numCorrectAnswers.exists(questionElement.id)?this.numCorrectAnswers.get(questionElement.id) + 1:1); else this.numCorrectAnswers.set(questionElement.id,1);
		}
	}
	,filterQuestion: function(element,index,question,instance,options) {
		var qq = question.getImpl();
		if(this.numCorrectAnswers.exists(element.id) && qq.correctAnswers != null && qq.correctAnswers.length > 0) {
			var i = qq.correctAnswers.length - 1;
			var n = this.numCorrectAnswers.get(element.id);
			while(i >= n) {
				qq.removeCorrectAnswer(i);
				i--;
			}
		}
		element.value = question.serialize();
	}
	,filterQuestionInstance: function(element,index,question,instance,options) {
		var ii = instance;
		if(this.numUserAnswers.exists(element.id)) {
			var i = ii.userData.answers.length - 1;
			var n = this.numUserAnswers.get(element.id);
			while(i >= n) {
				HxOverrides.remove(ii.userData.answers,ii.userData.answers[i]);
				i = ii.userData.answers.length - 1;
			}
		}
		element.value = instance.serialize();
	}
	,getFormElement: function(elem) {
		var nodeNames = ["input","textarea"];
		var _g = 0;
		while(_g < nodeNames.length) {
			var name = nodeNames[_g];
			++_g;
			if(elem.nodeName.toLowerCase() == name) return elem;
		}
		var _g = 0;
		while(_g < nodeNames.length) {
			var name = nodeNames[_g];
			++_g;
			var inputs = elem.getElementsByTagName(name);
			if(inputs.length > 0) return inputs[0];
		}
		return elem;
	}
	,filterFields: function(className,root) {
		var elementsLive = com.wiris.quizzes.JsDomUtils.getElementsByClassName(className,null,root);
		var i;
		var index = 0;
		var currentQuestionIndex = 0;
		var lastQuestionElement = null;
		var elements = new Array();
		var _g = 0;
		while(_g < elementsLive.length) {
			var element = elementsLive[_g];
			++_g;
			elements.push(element);
		}
		var embeddedAnswersEditor = null;
		var _g1 = 0, _g = elements.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			var options = elements[i1].className;
			var element = this.getFormElement(elements[i1]);
			if(!com.wiris.quizzes.JsDomUtils.hasClass(element,"wirisprocessed")) {
				var questionElement = null;
				if(this.defaultQuestion == null) questionElement = com.wiris.quizzes.JsDomUtils.getNearestElementByClassName(element,com.wiris.quizzes.JsQuizzesFilter.CLASS_QUESTION);
				var question = this.getQuestionObject(questionElement);
				var instanceElement = null;
				if(this.defaultInstance == null) instanceElement = com.wiris.quizzes.JsDomUtils.getNearestElementByClassName(element,com.wiris.quizzes.JsQuizzesFilter.CLASS_QUESTION_INSTANCE);
				var instance = this.getInstanceObject(instanceElement);
				var submitElements = this.getSubmitElements(element);
				if(lastQuestionElement != questionElement) {
					index = 0;
					currentQuestionIndex++;
				}
				lastQuestionElement = questionElement;
				try {
					switch(className) {
					case com.wiris.quizzes.JsQuizzesFilter.CLASS_LANG:
						this.uibuilder.setLanguage(element.value);
						break;
					case com.wiris.quizzes.JsQuizzesFilter.CLASS_AUTHOR_FIELD:
						this.filterAuthoringField(element,index,question,questionElement,instance,instanceElement,options);
						break;
					case com.wiris.quizzes.JsQuizzesFilter.CLASS_ANSWER_FIELD:
						this.filterAnswerField(element,index,question,questionElement,instance,instanceElement,options,submitElements);
						break;
					case com.wiris.quizzes.JsQuizzesFilter.CLASS_AUXILIAR_CAS_APPLET:
						this.filterAuxiliarCasApplet(element,index,question,questionElement,instance,instanceElement,options);
						break;
					case com.wiris.quizzes.JsQuizzesFilter.CLASS_ANSWER_FEEDBACK:
						this.filterAnswerFeedback(element,index,question,instance,options);
						break;
					case com.wiris.quizzes.JsQuizzesFilter.CLASS_QUESTION:
						this.filterQuestion(element,index,question,instance,options);
						break;
					case com.wiris.quizzes.JsQuizzesFilter.CLASS_QUESTION_INSTANCE:
						this.filterQuestionInstance(element,index,question,instance,options);
						break;
					}
				} catch( e ) {
					com.wiris.quizzes.JsDomUtils.addClass(element,"wiriserrorprocessing");
					haxe.Log.trace("An error occurred processing the field with class name " + className + " and index " + index + ".",{ fileName : "JsQuizzesFilter.hx", lineNumber : 253, className : "com.wiris.quizzes.JsQuizzesFilter", methodName : "filterFields"});
					haxe.Log.trace(e,{ fileName : "JsQuizzesFilter.hx", lineNumber : 254, className : "com.wiris.quizzes.JsQuizzesFilter", methodName : "filterFields"});
				}
				element.style.display = "none";
				com.wiris.quizzes.JsDomUtils.addClass(element,"wirisprocessed");
				index++;
			}
		}
	}
	,loadCSS: function() {
		if(!com.wiris.system.JsDOMUtils.existsCSS(js.Lib.document,"wirisquizzes.css")) {
			var quizzesStyles = js.Lib.document.createElement("link");
			quizzesStyles.setAttribute("type","text/css");
			quizzesStyles.setAttribute("rel","stylesheet");
			quizzesStyles.setAttribute("href",com.wiris.quizzes.api.Quizzes.getInstance().getResourceUrl("wirisquizzes.css"));
			js.Lib.document.getElementsByTagName("head")[0].appendChild(quizzesStyles);
			var serviceFonts = js.Lib.document.createElement("style");
			serviceFonts.setAttribute("type","text/css");
			serviceFonts.innerHTML = "@font-face { font-family: 'Material Icons'; font-weight: 400; font-style: normal; src: url('" + com.wiris.quizzes.api.Quizzes.getInstance().getResourceUrl("fonts/MaterialIcons-Regular.eot") + "'); src: url('" + com.wiris.quizzes.api.Quizzes.getInstance().getResourceUrl("fonts/MaterialIcons-Regular.eot#iefix") + "') format('eot'), url('" + com.wiris.quizzes.api.Quizzes.getInstance().getResourceUrl("fonts/MaterialIcons-Regular.woff") + "') format('woff'), url('" + com.wiris.quizzes.api.Quizzes.getInstance().getResourceUrl("fonts/MaterialIcons-Regular.ttf&v=4.0.0") + "') format('truetype'), url('" + com.wiris.quizzes.api.Quizzes.getInstance().getResourceUrl("fonts/MaterialIcons-Regular.svg&v=4.0.0") + "') format('svg'); }";
			js.Lib.document.getElementsByTagName("head")[0].appendChild(serviceFonts);
		}
		if(!com.wiris.system.JsDOMUtils.existsCSS(js.Lib.document,"util.css")) {
			var wirisStyles = js.Lib.document.createElement("link");
			wirisStyles.setAttribute("type","text/css");
			wirisStyles.setAttribute("rel","stylesheet");
			wirisStyles.setAttribute("href",com.wiris.quizzes.api.Quizzes.getInstance().getResourceUrl("util.css"));
			js.Lib.document.getElementsByTagName("head")[0].appendChild(wirisStyles);
		}
	}
	,replaceFields: function(question,instance,element) {
		this.defaultQuestion = question;
		this.defaultInstance = instance;
		this.questions = new Hash();
		this.instances = new Hash();
		this.numCorrectAnswers = new Hash();
		this.numUserAnswers = new Hash();
		this.filterFields(com.wiris.quizzes.JsQuizzesFilter.CLASS_LANG,element);
		this.filterFields(com.wiris.quizzes.JsQuizzesFilter.CLASS_AUTHOR_FIELD,element);
		this.filterFields(com.wiris.quizzes.JsQuizzesFilter.CLASS_ANSWER_FIELD,element);
		this.filterFields(com.wiris.quizzes.JsQuizzesFilter.CLASS_AUXILIAR_CAS_APPLET,element);
		this.filterFields(com.wiris.quizzes.JsQuizzesFilter.CLASS_QUESTION,element);
		this.filterFields(com.wiris.quizzes.JsQuizzesFilter.CLASS_QUESTION_INSTANCE,element);
		this.filterFields(com.wiris.quizzes.JsQuizzesFilter.CLASS_ANSWER_FEEDBACK,element);
	}
	,loadQuizzesFields: function() {
		var _g = this;
		if(com.wiris.system.ui.JsComponent.isCSSLoaded()) {
			this.replaceFields(this.defaultQuestion,this.defaultInstance,null);
			this.uibuilder.getMathViewer().filterConstructions(js.Lib.document);
		} else haxe.Timer.delay(function() {
			_g.loadQuizzesFields();
		},200);
	}
	,run: function() {
		this.loadCSS();
		this.loadQuizzesFields();
	}
	,uibuilder: null
	,builder: null
	,numUserAnswers: null
	,numCorrectAnswers: null
	,defaultInstance: null
	,defaultQuestion: null
	,instances: null
	,questions: null
	,__class__: com.wiris.quizzes.JsQuizzesFilter
}
com.wiris.quizzes.api.ui.QuizzesFieldListener = $hxClasses["com.wiris.quizzes.api.ui.QuizzesFieldListener"] = function() { }
com.wiris.quizzes.api.ui.QuizzesFieldListener.__name__ = ["com","wiris","quizzes","api","ui","QuizzesFieldListener"];
com.wiris.quizzes.api.ui.QuizzesFieldListener.prototype = {
	contentChangeStarted: null
	,contentChanged: null
	,__class__: com.wiris.quizzes.api.ui.QuizzesFieldListener
}
com.wiris.quizzes.FieldSynchronizer = $hxClasses["com.wiris.quizzes.FieldSynchronizer"] = function(element,questionElement,question,submitElements) {
	this.element = element;
	this.questionElement = questionElement;
	this.question = question;
	this.submitElements = submitElements;
};
com.wiris.quizzes.FieldSynchronizer.__name__ = ["com","wiris","quizzes","FieldSynchronizer"];
com.wiris.quizzes.FieldSynchronizer.__interfaces__ = [com.wiris.quizzes.api.ui.QuizzesFieldListener];
com.wiris.quizzes.FieldSynchronizer.prototype = {
	contentChangeStarted: function(source) {
		if(this.submitElements != null) {
			var elem;
			var _g = 0, _g1 = this.submitElements;
			while(_g < _g1.length) {
				var elem1 = _g1[_g];
				++_g;
				elem1.disabled = true;
			}
		}
	}
	,contentChanged: function(source) {
		this.element.value = source.getValue();
		if(this.questionElement != null && this.question != null) this.questionElement.value = this.question.serialize();
		if(this.submitElements != null) {
			var elem;
			var _g = 0, _g1 = this.submitElements;
			while(_g < _g1.length) {
				var elem1 = _g1[_g];
				++_g;
				elem1.disabled = false;
			}
		}
	}
	,submitElements: null
	,question: null
	,questionElement: null
	,element: null
	,__class__: com.wiris.quizzes.FieldSynchronizer
}
com.wiris.system.ResourceLoader = $hxClasses["com.wiris.system.ResourceLoader"] = function() {
	com.wiris.system.ResourceLoader.initialize();
	this.basePath = "";
};
com.wiris.system.ResourceLoader.__name__ = ["com","wiris","system","ResourceLoader"];
com.wiris.system.ResourceLoader.resourcesCache = null;
com.wiris.system.ResourceLoader.initialize = function() {
	if(com.wiris.system.ResourceLoader.resourcesCache == null) com.wiris.system.ResourceLoader.resourcesCache = new Hash();
}
com.wiris.system.ResourceLoader.newInstance = function(basePath) {
	var resourceLoader = new com.wiris.system.ResourceLoader();
	if(basePath.length > 0 && !StringTools.endsWith(basePath,"/")) basePath += "/";
	resourceLoader.basePath = basePath;
	return resourceLoader;
}
com.wiris.system.ResourceLoader.prototype = {
	getPath: function(path) {
		path += "?v=" + this.loadResource("version.txt");
		if(StringTools.startsWith(path,"http://") || StringTools.startsWith(path,"https://")) return path;
		return this.basePath + path;
	}
	,loadStaticResource: function(path) {
		if(path == "editor_definition.xml") return com.wiris.system.ResourceLoader.editorDefinition;
		if(path == "characters.xml") return com.wiris.system.ResourceLoader.charactersDefinition;
		if(path == "version.txt") {
			if(com.wiris.system.ResourceLoader.version == null) {
			}
			return com.wiris.system.ResourceLoader.version;
		}
		if(path == "font_adjust.xml") return com.wiris.system.ResourceLoader.fontAdjust;
		if(StringTools.startsWith(path,"lang/")) {
			var lang = HxOverrides.substr(path,5,path.lastIndexOf(".") - 5);
			if(com.wiris.system.ResourceLoader.translations[lang]) return com.wiris.system.ResourceLoader.translations[lang];
			lang = lang.toLowerCase();
			lang = lang.split("-").join("_");
			if(com.wiris.system.ResourceLoader.translations[lang]) return com.wiris.system.ResourceLoader.translations[lang];
			lang = HxOverrides.substr(lang,0,2);
			if(com.wiris.system.ResourceLoader.translations[lang]) return com.wiris.system.ResourceLoader.translations[lang];
		}
		return null;
	}
	,loadResource: function(path) {
		var staticResource = this.loadStaticResource(path);
		if(staticResource != null) return staticResource;
		staticResource = haxe.Resource.getString(path);
		if(staticResource != null) return staticResource;
		return null;
	}
	,basePath: null
	,__class__: com.wiris.system.ResourceLoader
}
com.wiris.quizzes.QuizzesResourceLoader = $hxClasses["com.wiris.quizzes.QuizzesResourceLoader"] = function() {
	com.wiris.system.ResourceLoader.call(this);
};
com.wiris.quizzes.QuizzesResourceLoader.__name__ = ["com","wiris","quizzes","QuizzesResourceLoader"];
com.wiris.quizzes.QuizzesResourceLoader.newInstance = function() {
	var resourceLoader = new com.wiris.quizzes.QuizzesResourceLoader();
	if(com.wiris.quizzes.impl.ConfigurationImpl.getInstance().get(com.wiris.quizzes.api.ConfigurationKeys.RESOURCES_STATIC) == "true") resourceLoader.basePath = com.wiris.system.JsDOMUtils.findServicePath("quizzes.js") + "/"; else {
		var proxyUrl = com.wiris.quizzes.impl.ConfigurationImpl.getInstance().get(com.wiris.quizzes.api.ConfigurationKeys.PROXY_URL);
		if(StringTools.startsWith(proxyUrl,"http://") || StringTools.startsWith(proxyUrl,"https://")) resourceLoader.basePath = proxyUrl + "?service=resource&name="; else resourceLoader.basePath = com.wiris.system.JsDOMUtils.findServicePath(proxyUrl) + "/" + proxyUrl + "?service=resource&name=";
	}
	return resourceLoader;
}
com.wiris.quizzes.QuizzesResourceLoader.__super__ = com.wiris.system.ResourceLoader;
com.wiris.quizzes.QuizzesResourceLoader.prototype = $extend(com.wiris.system.ResourceLoader.prototype,{
	getPath: function(path) {
		path += (com.wiris.quizzes.impl.ConfigurationImpl.getInstance().get(com.wiris.quizzes.api.ConfigurationKeys.RESOURCES_STATIC) == "true"?"?":"&") + "v=" + com.wiris.quizzes.impl.ConfigurationImpl.getInstance().get(com.wiris.quizzes.api.ConfigurationKeys.VERSION);
		if(StringTools.startsWith(path,"http://") || StringTools.startsWith(path,"https://")) return path;
		return this.basePath + path;
	}
	,__class__: com.wiris.quizzes.QuizzesResourceLoader
});
com.wiris.quizzes.api.AssertionCheck = $hxClasses["com.wiris.quizzes.api.AssertionCheck"] = function() { }
com.wiris.quizzes.api.AssertionCheck.__name__ = ["com","wiris","quizzes","api","AssertionCheck"];
com.wiris.quizzes.api.AssertionCheck.prototype = {
	getValue: null
	,getAssertionName: null
	,__class__: com.wiris.quizzes.api.AssertionCheck
}
com.wiris.quizzes.api.Serializable = $hxClasses["com.wiris.quizzes.api.Serializable"] = function() { }
com.wiris.quizzes.api.Serializable.__name__ = ["com","wiris","quizzes","api","Serializable"];
com.wiris.quizzes.api.Serializable.prototype = {
	serialize: null
	,__class__: com.wiris.quizzes.api.Serializable
}
com.wiris.quizzes.api.AuthorAnswer = $hxClasses["com.wiris.quizzes.api.AuthorAnswer"] = function() { }
com.wiris.quizzes.api.AuthorAnswer.__name__ = ["com","wiris","quizzes","api","AuthorAnswer"];
com.wiris.quizzes.api.AuthorAnswer.__interfaces__ = [com.wiris.quizzes.api.Serializable];
com.wiris.quizzes.api.AuthorAnswer.prototype = {
	getValueAsMathML: null
	,copy: null
	,setWeight: null
	,getWeight: null
	,removeValidation: null
	,getValidation: null
	,addNewValidation: null
	,getValidations: null
	,getComparison: null
	,setComparison: null
	,setValue: null
	,getFilterableValue: null
	,getValue: null
	,__class__: com.wiris.quizzes.api.AuthorAnswer
}
com.wiris.quizzes.api.Configuration = $hxClasses["com.wiris.quizzes.api.Configuration"] = function() { }
com.wiris.quizzes.api.Configuration.__name__ = ["com","wiris","quizzes","api","Configuration"];
com.wiris.quizzes.api.Configuration.prototype = {
	set: null
	,get: null
	,__class__: com.wiris.quizzes.api.Configuration
}
com.wiris.quizzes.api.ConfigurationKeys = $hxClasses["com.wiris.quizzes.api.ConfigurationKeys"] = function() { }
com.wiris.quizzes.api.ConfigurationKeys.__name__ = ["com","wiris","quizzes","api","ConfigurationKeys"];
com.wiris.quizzes.api.MathFilter = $hxClasses["com.wiris.quizzes.api.MathFilter"] = function() { }
com.wiris.quizzes.api.MathFilter.__name__ = ["com","wiris","quizzes","api","MathFilter"];
com.wiris.quizzes.api.MathFilter.prototype = {
	filter: null
	,__class__: com.wiris.quizzes.api.MathFilter
}
com.wiris.quizzes.api.PropertyName = $hxClasses["com.wiris.quizzes.api.PropertyName"] = { __ename__ : ["com","wiris","quizzes","api","PropertyName"], __constructs__ : ["STUDENT_ANSWER_PARAMETER","STUDENT_ANSWER_PARAMETER_NAME","ANSWER_FIELD_TYPE","COMPOUND_ANSWER","COMPOUND_ANSWER_GRADE","COMPOUND_ANSWER_GRADE_DISTRIBUTION","SHOW_CAS","CAS_SESSION","SHOW_AUXILIARY_TEXT_INPUT","AUXILIARY_TEXT","AUXILIARY_CAS_HIDE_FILE_MENU","USER_ID","GRAPH_TOOLBAR","HANDWRITING_CONSTRAINTS","ELEMENTS_TO_HANDWRITE","GRAPH_LOCK_INITIAL_CONTENT","GRAPH_SHOW_NAME_IN_LABEL","GRAPH_SHOW_VALUE_IN_LABEL","GRAPH_MAGNETIC_GRID"] }
com.wiris.quizzes.api.PropertyName.STUDENT_ANSWER_PARAMETER = ["STUDENT_ANSWER_PARAMETER",0];
com.wiris.quizzes.api.PropertyName.STUDENT_ANSWER_PARAMETER.toString = $estr;
com.wiris.quizzes.api.PropertyName.STUDENT_ANSWER_PARAMETER.__enum__ = com.wiris.quizzes.api.PropertyName;
com.wiris.quizzes.api.PropertyName.STUDENT_ANSWER_PARAMETER_NAME = ["STUDENT_ANSWER_PARAMETER_NAME",1];
com.wiris.quizzes.api.PropertyName.STUDENT_ANSWER_PARAMETER_NAME.toString = $estr;
com.wiris.quizzes.api.PropertyName.STUDENT_ANSWER_PARAMETER_NAME.__enum__ = com.wiris.quizzes.api.PropertyName;
com.wiris.quizzes.api.PropertyName.ANSWER_FIELD_TYPE = ["ANSWER_FIELD_TYPE",2];
com.wiris.quizzes.api.PropertyName.ANSWER_FIELD_TYPE.toString = $estr;
com.wiris.quizzes.api.PropertyName.ANSWER_FIELD_TYPE.__enum__ = com.wiris.quizzes.api.PropertyName;
com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER = ["COMPOUND_ANSWER",3];
com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER.toString = $estr;
com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER.__enum__ = com.wiris.quizzes.api.PropertyName;
com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER_GRADE = ["COMPOUND_ANSWER_GRADE",4];
com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER_GRADE.toString = $estr;
com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER_GRADE.__enum__ = com.wiris.quizzes.api.PropertyName;
com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER_GRADE_DISTRIBUTION = ["COMPOUND_ANSWER_GRADE_DISTRIBUTION",5];
com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER_GRADE_DISTRIBUTION.toString = $estr;
com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER_GRADE_DISTRIBUTION.__enum__ = com.wiris.quizzes.api.PropertyName;
com.wiris.quizzes.api.PropertyName.SHOW_CAS = ["SHOW_CAS",6];
com.wiris.quizzes.api.PropertyName.SHOW_CAS.toString = $estr;
com.wiris.quizzes.api.PropertyName.SHOW_CAS.__enum__ = com.wiris.quizzes.api.PropertyName;
com.wiris.quizzes.api.PropertyName.CAS_SESSION = ["CAS_SESSION",7];
com.wiris.quizzes.api.PropertyName.CAS_SESSION.toString = $estr;
com.wiris.quizzes.api.PropertyName.CAS_SESSION.__enum__ = com.wiris.quizzes.api.PropertyName;
com.wiris.quizzes.api.PropertyName.SHOW_AUXILIARY_TEXT_INPUT = ["SHOW_AUXILIARY_TEXT_INPUT",8];
com.wiris.quizzes.api.PropertyName.SHOW_AUXILIARY_TEXT_INPUT.toString = $estr;
com.wiris.quizzes.api.PropertyName.SHOW_AUXILIARY_TEXT_INPUT.__enum__ = com.wiris.quizzes.api.PropertyName;
com.wiris.quizzes.api.PropertyName.AUXILIARY_TEXT = ["AUXILIARY_TEXT",9];
com.wiris.quizzes.api.PropertyName.AUXILIARY_TEXT.toString = $estr;
com.wiris.quizzes.api.PropertyName.AUXILIARY_TEXT.__enum__ = com.wiris.quizzes.api.PropertyName;
com.wiris.quizzes.api.PropertyName.AUXILIARY_CAS_HIDE_FILE_MENU = ["AUXILIARY_CAS_HIDE_FILE_MENU",10];
com.wiris.quizzes.api.PropertyName.AUXILIARY_CAS_HIDE_FILE_MENU.toString = $estr;
com.wiris.quizzes.api.PropertyName.AUXILIARY_CAS_HIDE_FILE_MENU.__enum__ = com.wiris.quizzes.api.PropertyName;
com.wiris.quizzes.api.PropertyName.USER_ID = ["USER_ID",11];
com.wiris.quizzes.api.PropertyName.USER_ID.toString = $estr;
com.wiris.quizzes.api.PropertyName.USER_ID.__enum__ = com.wiris.quizzes.api.PropertyName;
com.wiris.quizzes.api.PropertyName.GRAPH_TOOLBAR = ["GRAPH_TOOLBAR",12];
com.wiris.quizzes.api.PropertyName.GRAPH_TOOLBAR.toString = $estr;
com.wiris.quizzes.api.PropertyName.GRAPH_TOOLBAR.__enum__ = com.wiris.quizzes.api.PropertyName;
com.wiris.quizzes.api.PropertyName.HANDWRITING_CONSTRAINTS = ["HANDWRITING_CONSTRAINTS",13];
com.wiris.quizzes.api.PropertyName.HANDWRITING_CONSTRAINTS.toString = $estr;
com.wiris.quizzes.api.PropertyName.HANDWRITING_CONSTRAINTS.__enum__ = com.wiris.quizzes.api.PropertyName;
com.wiris.quizzes.api.PropertyName.ELEMENTS_TO_HANDWRITE = ["ELEMENTS_TO_HANDWRITE",14];
com.wiris.quizzes.api.PropertyName.ELEMENTS_TO_HANDWRITE.toString = $estr;
com.wiris.quizzes.api.PropertyName.ELEMENTS_TO_HANDWRITE.__enum__ = com.wiris.quizzes.api.PropertyName;
com.wiris.quizzes.api.PropertyName.GRAPH_LOCK_INITIAL_CONTENT = ["GRAPH_LOCK_INITIAL_CONTENT",15];
com.wiris.quizzes.api.PropertyName.GRAPH_LOCK_INITIAL_CONTENT.toString = $estr;
com.wiris.quizzes.api.PropertyName.GRAPH_LOCK_INITIAL_CONTENT.__enum__ = com.wiris.quizzes.api.PropertyName;
com.wiris.quizzes.api.PropertyName.GRAPH_SHOW_NAME_IN_LABEL = ["GRAPH_SHOW_NAME_IN_LABEL",16];
com.wiris.quizzes.api.PropertyName.GRAPH_SHOW_NAME_IN_LABEL.toString = $estr;
com.wiris.quizzes.api.PropertyName.GRAPH_SHOW_NAME_IN_LABEL.__enum__ = com.wiris.quizzes.api.PropertyName;
com.wiris.quizzes.api.PropertyName.GRAPH_SHOW_VALUE_IN_LABEL = ["GRAPH_SHOW_VALUE_IN_LABEL",17];
com.wiris.quizzes.api.PropertyName.GRAPH_SHOW_VALUE_IN_LABEL.toString = $estr;
com.wiris.quizzes.api.PropertyName.GRAPH_SHOW_VALUE_IN_LABEL.__enum__ = com.wiris.quizzes.api.PropertyName;
com.wiris.quizzes.api.PropertyName.GRAPH_MAGNETIC_GRID = ["GRAPH_MAGNETIC_GRID",18];
com.wiris.quizzes.api.PropertyName.GRAPH_MAGNETIC_GRID.toString = $estr;
com.wiris.quizzes.api.PropertyName.GRAPH_MAGNETIC_GRID.__enum__ = com.wiris.quizzes.api.PropertyName;
com.wiris.quizzes.api.Question = $hxClasses["com.wiris.quizzes.api.Question"] = function() { }
com.wiris.quizzes.api.Question.__name__ = ["com","wiris","quizzes","api","Question"];
com.wiris.quizzes.api.Question.__interfaces__ = [com.wiris.quizzes.api.Serializable];
com.wiris.quizzes.api.Question.prototype = {
	getDeprecationWarnings: null
	,setOption: null
	,addAssertion: null
	,getCorrectAnswersLength: null
	,getCorrectAnswer: null
	,setCorrectAnswer: null
	,getStudentQuestion: null
	,getProperty: null
	,setProperty: null
	,getAlgorithm: null
	,setAlgorithm: null
	,getAnswerFieldType: null
	,setAnswerFieldType: null
	,removeSlot: null
	,addNewSlotFromModel: null
	,addNewSlot: null
	,getSlots: null
	,__class__: com.wiris.quizzes.api.Question
}
com.wiris.quizzes.api.QuestionInstance = $hxClasses["com.wiris.quizzes.api.QuestionInstance"] = function() { }
com.wiris.quizzes.api.QuestionInstance.__name__ = ["com","wiris","quizzes","api","QuestionInstance"];
com.wiris.quizzes.api.QuestionInstance.__interfaces__ = [com.wiris.quizzes.api.Serializable];
com.wiris.quizzes.api.QuestionInstance.prototype = {
	setParameter: null
	,getProperty: null
	,setProperty: null
	,areVariablesReady: null
	,getChecks: null
	,getAssertionChecks: null
	,getStudentAnswersLength: null
	,setSlotAnswer: null
	,getSlotAnswer: null
	,getStudentAnswer: null
	,setStudentAnswer: null
	,setAuxiliaryText: null
	,setAuxiliarText: null
	,setCasSession: null
	,setRandomSeed: null
	,getStudentQuestionInstance: null
	,getCompoundGrade: null
	,getCompoundAnswerGrade: null
	,getGrade: null
	,getAnswerGrade: null
	,expandVariablesText: null
	,expandVariablesMathML: null
	,expandVariables: null
	,isSlotAnswerCorrect: null
	,areAllAnswersCorrect: null
	,isAnswerCorrect: null
	,updateFromStudentQuestionInstance: null
	,update: null
	,__class__: com.wiris.quizzes.api.QuestionInstance
}
com.wiris.quizzes.api.QuestionRequest = $hxClasses["com.wiris.quizzes.api.QuestionRequest"] = function() { }
com.wiris.quizzes.api.QuestionRequest.__name__ = ["com","wiris","quizzes","api","QuestionRequest"];
com.wiris.quizzes.api.QuestionRequest.__interfaces__ = [com.wiris.quizzes.api.Serializable];
com.wiris.quizzes.api.QuestionRequest.prototype = {
	isEmpty: null
	,addMetaProperty: null
	,__class__: com.wiris.quizzes.api.QuestionRequest
}
com.wiris.quizzes.api.QuestionResponse = $hxClasses["com.wiris.quizzes.api.QuestionResponse"] = function() { }
com.wiris.quizzes.api.QuestionResponse.__name__ = ["com","wiris","quizzes","api","QuestionResponse"];
com.wiris.quizzes.api.QuestionResponse.__interfaces__ = [com.wiris.quizzes.api.Serializable];
com.wiris.quizzes.api.QuizzesConstants = $hxClasses["com.wiris.quizzes.api.QuizzesConstants"] = function() {
};
com.wiris.quizzes.api.QuizzesConstants.__name__ = ["com","wiris","quizzes","api","QuizzesConstants"];
com.wiris.quizzes.api.QuizzesConstants.prototype = {
	__class__: com.wiris.quizzes.api.QuizzesConstants
}
com.wiris.quizzes.api.QuizzesService = $hxClasses["com.wiris.quizzes.api.QuizzesService"] = function() { }
com.wiris.quizzes.api.QuizzesService.__name__ = ["com","wiris","quizzes","api","QuizzesService"];
com.wiris.quizzes.api.QuizzesService.prototype = {
	executeAsync: null
	,execute: null
	,__class__: com.wiris.quizzes.api.QuizzesService
}
com.wiris.quizzes.api.QuizzesServiceListener = $hxClasses["com.wiris.quizzes.api.QuizzesServiceListener"] = function() { }
com.wiris.quizzes.api.QuizzesServiceListener.__name__ = ["com","wiris","quizzes","api","QuizzesServiceListener"];
com.wiris.quizzes.api.QuizzesServiceListener.prototype = {
	onResponse: null
	,__class__: com.wiris.quizzes.api.QuizzesServiceListener
}
com.wiris.quizzes.api.Slot = $hxClasses["com.wiris.quizzes.api.Slot"] = function() { }
com.wiris.quizzes.api.Slot.__name__ = ["com","wiris","quizzes","api","Slot"];
com.wiris.quizzes.api.Slot.__interfaces__ = [com.wiris.quizzes.api.Serializable];
com.wiris.quizzes.api.Slot.prototype = {
	getGrammarUrl: null
	,copy: null
	,getAnswerFieldType: null
	,setAnswerFieldType: null
	,setInitialContent: null
	,getInitialContent: null
	,setSyntax: null
	,getSyntax: null
	,getProperty: null
	,setProperty: null
	,removeAuthorAnswer: null
	,addNewAuthorAnswer: null
	,getAuthorAnswers: null
	,__class__: com.wiris.quizzes.api.Slot
}
if(!com.wiris.quizzes.api.assertion) com.wiris.quizzes.api.assertion = {}
com.wiris.quizzes.api.assertion.Comparison = $hxClasses["com.wiris.quizzes.api.assertion.Comparison"] = function() { }
com.wiris.quizzes.api.assertion.Comparison.__name__ = ["com","wiris","quizzes","api","assertion","Comparison"];
com.wiris.quizzes.api.assertion.Comparison.__interfaces__ = [com.wiris.quizzes.api.Serializable];
com.wiris.quizzes.api.assertion.Comparison.prototype = {
	removeParameter: null
	,getParameter: null
	,setParameter: null
	,getName: null
	,__class__: com.wiris.quizzes.api.assertion.Comparison
}
com.wiris.quizzes.api.assertion.ComparisonName = $hxClasses["com.wiris.quizzes.api.assertion.ComparisonName"] = { __ename__ : ["com","wiris","quizzes","api","assertion","ComparisonName"], __constructs__ : ["MATHEMATICALLY_EQUAL","LITERALLY_EQUAL","EQUIVALENT_EQUATIONS","GRADING_FUNCTION","ANY_ANSWER","GRAPHICALLY_EQUAL","SKETCH_EQUAL"] }
com.wiris.quizzes.api.assertion.ComparisonName.MATHEMATICALLY_EQUAL = ["MATHEMATICALLY_EQUAL",0];
com.wiris.quizzes.api.assertion.ComparisonName.MATHEMATICALLY_EQUAL.toString = $estr;
com.wiris.quizzes.api.assertion.ComparisonName.MATHEMATICALLY_EQUAL.__enum__ = com.wiris.quizzes.api.assertion.ComparisonName;
com.wiris.quizzes.api.assertion.ComparisonName.LITERALLY_EQUAL = ["LITERALLY_EQUAL",1];
com.wiris.quizzes.api.assertion.ComparisonName.LITERALLY_EQUAL.toString = $estr;
com.wiris.quizzes.api.assertion.ComparisonName.LITERALLY_EQUAL.__enum__ = com.wiris.quizzes.api.assertion.ComparisonName;
com.wiris.quizzes.api.assertion.ComparisonName.EQUIVALENT_EQUATIONS = ["EQUIVALENT_EQUATIONS",2];
com.wiris.quizzes.api.assertion.ComparisonName.EQUIVALENT_EQUATIONS.toString = $estr;
com.wiris.quizzes.api.assertion.ComparisonName.EQUIVALENT_EQUATIONS.__enum__ = com.wiris.quizzes.api.assertion.ComparisonName;
com.wiris.quizzes.api.assertion.ComparisonName.GRADING_FUNCTION = ["GRADING_FUNCTION",3];
com.wiris.quizzes.api.assertion.ComparisonName.GRADING_FUNCTION.toString = $estr;
com.wiris.quizzes.api.assertion.ComparisonName.GRADING_FUNCTION.__enum__ = com.wiris.quizzes.api.assertion.ComparisonName;
com.wiris.quizzes.api.assertion.ComparisonName.ANY_ANSWER = ["ANY_ANSWER",4];
com.wiris.quizzes.api.assertion.ComparisonName.ANY_ANSWER.toString = $estr;
com.wiris.quizzes.api.assertion.ComparisonName.ANY_ANSWER.__enum__ = com.wiris.quizzes.api.assertion.ComparisonName;
com.wiris.quizzes.api.assertion.ComparisonName.GRAPHICALLY_EQUAL = ["GRAPHICALLY_EQUAL",5];
com.wiris.quizzes.api.assertion.ComparisonName.GRAPHICALLY_EQUAL.toString = $estr;
com.wiris.quizzes.api.assertion.ComparisonName.GRAPHICALLY_EQUAL.__enum__ = com.wiris.quizzes.api.assertion.ComparisonName;
com.wiris.quizzes.api.assertion.ComparisonName.SKETCH_EQUAL = ["SKETCH_EQUAL",6];
com.wiris.quizzes.api.assertion.ComparisonName.SKETCH_EQUAL.toString = $estr;
com.wiris.quizzes.api.assertion.ComparisonName.SKETCH_EQUAL.__enum__ = com.wiris.quizzes.api.assertion.ComparisonName;
com.wiris.quizzes.api.assertion.ComparisonParameterName = $hxClasses["com.wiris.quizzes.api.assertion.ComparisonParameterName"] = { __ename__ : ["com","wiris","quizzes","api","assertion","ComparisonParameterName"], __constructs__ : ["ORDER_MATTERS","REPETITION_MATTERS","TOLERANCE","TOLERANCE_DIGITS","RELATIVE_TOLERANCE","FUNCTION_NAME","MATCH_CASES","MATCH_SPACES","NOT_EVALUATE","FUNCTION_ARGUMENT_MODE","ELEMENTS_TO_GRADE"] }
com.wiris.quizzes.api.assertion.ComparisonParameterName.ORDER_MATTERS = ["ORDER_MATTERS",0];
com.wiris.quizzes.api.assertion.ComparisonParameterName.ORDER_MATTERS.toString = $estr;
com.wiris.quizzes.api.assertion.ComparisonParameterName.ORDER_MATTERS.__enum__ = com.wiris.quizzes.api.assertion.ComparisonParameterName;
com.wiris.quizzes.api.assertion.ComparisonParameterName.REPETITION_MATTERS = ["REPETITION_MATTERS",1];
com.wiris.quizzes.api.assertion.ComparisonParameterName.REPETITION_MATTERS.toString = $estr;
com.wiris.quizzes.api.assertion.ComparisonParameterName.REPETITION_MATTERS.__enum__ = com.wiris.quizzes.api.assertion.ComparisonParameterName;
com.wiris.quizzes.api.assertion.ComparisonParameterName.TOLERANCE = ["TOLERANCE",2];
com.wiris.quizzes.api.assertion.ComparisonParameterName.TOLERANCE.toString = $estr;
com.wiris.quizzes.api.assertion.ComparisonParameterName.TOLERANCE.__enum__ = com.wiris.quizzes.api.assertion.ComparisonParameterName;
com.wiris.quizzes.api.assertion.ComparisonParameterName.TOLERANCE_DIGITS = ["TOLERANCE_DIGITS",3];
com.wiris.quizzes.api.assertion.ComparisonParameterName.TOLERANCE_DIGITS.toString = $estr;
com.wiris.quizzes.api.assertion.ComparisonParameterName.TOLERANCE_DIGITS.__enum__ = com.wiris.quizzes.api.assertion.ComparisonParameterName;
com.wiris.quizzes.api.assertion.ComparisonParameterName.RELATIVE_TOLERANCE = ["RELATIVE_TOLERANCE",4];
com.wiris.quizzes.api.assertion.ComparisonParameterName.RELATIVE_TOLERANCE.toString = $estr;
com.wiris.quizzes.api.assertion.ComparisonParameterName.RELATIVE_TOLERANCE.__enum__ = com.wiris.quizzes.api.assertion.ComparisonParameterName;
com.wiris.quizzes.api.assertion.ComparisonParameterName.FUNCTION_NAME = ["FUNCTION_NAME",5];
com.wiris.quizzes.api.assertion.ComparisonParameterName.FUNCTION_NAME.toString = $estr;
com.wiris.quizzes.api.assertion.ComparisonParameterName.FUNCTION_NAME.__enum__ = com.wiris.quizzes.api.assertion.ComparisonParameterName;
com.wiris.quizzes.api.assertion.ComparisonParameterName.MATCH_CASES = ["MATCH_CASES",6];
com.wiris.quizzes.api.assertion.ComparisonParameterName.MATCH_CASES.toString = $estr;
com.wiris.quizzes.api.assertion.ComparisonParameterName.MATCH_CASES.__enum__ = com.wiris.quizzes.api.assertion.ComparisonParameterName;
com.wiris.quizzes.api.assertion.ComparisonParameterName.MATCH_SPACES = ["MATCH_SPACES",7];
com.wiris.quizzes.api.assertion.ComparisonParameterName.MATCH_SPACES.toString = $estr;
com.wiris.quizzes.api.assertion.ComparisonParameterName.MATCH_SPACES.__enum__ = com.wiris.quizzes.api.assertion.ComparisonParameterName;
com.wiris.quizzes.api.assertion.ComparisonParameterName.NOT_EVALUATE = ["NOT_EVALUATE",8];
com.wiris.quizzes.api.assertion.ComparisonParameterName.NOT_EVALUATE.toString = $estr;
com.wiris.quizzes.api.assertion.ComparisonParameterName.NOT_EVALUATE.__enum__ = com.wiris.quizzes.api.assertion.ComparisonParameterName;
com.wiris.quizzes.api.assertion.ComparisonParameterName.FUNCTION_ARGUMENT_MODE = ["FUNCTION_ARGUMENT_MODE",9];
com.wiris.quizzes.api.assertion.ComparisonParameterName.FUNCTION_ARGUMENT_MODE.toString = $estr;
com.wiris.quizzes.api.assertion.ComparisonParameterName.FUNCTION_ARGUMENT_MODE.__enum__ = com.wiris.quizzes.api.assertion.ComparisonParameterName;
com.wiris.quizzes.api.assertion.ComparisonParameterName.ELEMENTS_TO_GRADE = ["ELEMENTS_TO_GRADE",10];
com.wiris.quizzes.api.assertion.ComparisonParameterName.ELEMENTS_TO_GRADE.toString = $estr;
com.wiris.quizzes.api.assertion.ComparisonParameterName.ELEMENTS_TO_GRADE.__enum__ = com.wiris.quizzes.api.assertion.ComparisonParameterName;
com.wiris.quizzes.api.assertion.Syntax = $hxClasses["com.wiris.quizzes.api.assertion.Syntax"] = function() { }
com.wiris.quizzes.api.assertion.Syntax.__name__ = ["com","wiris","quizzes","api","assertion","Syntax"];
com.wiris.quizzes.api.assertion.Syntax.__interfaces__ = [com.wiris.quizzes.api.Serializable];
com.wiris.quizzes.api.assertion.Syntax.prototype = {
	removeParameter: null
	,getParameter: null
	,setParameter: null
	,getName: null
	,__class__: com.wiris.quizzes.api.assertion.Syntax
}
com.wiris.quizzes.api.assertion.SyntaxName = $hxClasses["com.wiris.quizzes.api.assertion.SyntaxName"] = { __ename__ : ["com","wiris","quizzes","api","assertion","SyntaxName"], __constructs__ : ["MATH","GRAPHIC","STRING"] }
com.wiris.quizzes.api.assertion.SyntaxName.MATH = ["MATH",0];
com.wiris.quizzes.api.assertion.SyntaxName.MATH.toString = $estr;
com.wiris.quizzes.api.assertion.SyntaxName.MATH.__enum__ = com.wiris.quizzes.api.assertion.SyntaxName;
com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC = ["GRAPHIC",1];
com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC.toString = $estr;
com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC.__enum__ = com.wiris.quizzes.api.assertion.SyntaxName;
com.wiris.quizzes.api.assertion.SyntaxName.STRING = ["STRING",2];
com.wiris.quizzes.api.assertion.SyntaxName.STRING.toString = $estr;
com.wiris.quizzes.api.assertion.SyntaxName.STRING.__enum__ = com.wiris.quizzes.api.assertion.SyntaxName;
com.wiris.quizzes.api.assertion.SyntaxParameterName = $hxClasses["com.wiris.quizzes.api.assertion.SyntaxParameterName"] = { __ename__ : ["com","wiris","quizzes","api","assertion","SyntaxParameterName"], __constructs__ : ["CONSTANTS","FUNCTIONS","GROUP_OPERATORS","LIST_OPERATORS","UNITS","UNIT_PREFIXES","MIXED_FRACTIONS","ITEM_SEPARATORS","DECIMAL_SEPARATORS","DIGIT_GROUP_SEPARATORS","NO_BRACKETS_LIST","INTERVALS","RATIO","SCIENTIFIC_NOTATION","GRAPH_MODE"] }
com.wiris.quizzes.api.assertion.SyntaxParameterName.CONSTANTS = ["CONSTANTS",0];
com.wiris.quizzes.api.assertion.SyntaxParameterName.CONSTANTS.toString = $estr;
com.wiris.quizzes.api.assertion.SyntaxParameterName.CONSTANTS.__enum__ = com.wiris.quizzes.api.assertion.SyntaxParameterName;
com.wiris.quizzes.api.assertion.SyntaxParameterName.FUNCTIONS = ["FUNCTIONS",1];
com.wiris.quizzes.api.assertion.SyntaxParameterName.FUNCTIONS.toString = $estr;
com.wiris.quizzes.api.assertion.SyntaxParameterName.FUNCTIONS.__enum__ = com.wiris.quizzes.api.assertion.SyntaxParameterName;
com.wiris.quizzes.api.assertion.SyntaxParameterName.GROUP_OPERATORS = ["GROUP_OPERATORS",2];
com.wiris.quizzes.api.assertion.SyntaxParameterName.GROUP_OPERATORS.toString = $estr;
com.wiris.quizzes.api.assertion.SyntaxParameterName.GROUP_OPERATORS.__enum__ = com.wiris.quizzes.api.assertion.SyntaxParameterName;
com.wiris.quizzes.api.assertion.SyntaxParameterName.LIST_OPERATORS = ["LIST_OPERATORS",3];
com.wiris.quizzes.api.assertion.SyntaxParameterName.LIST_OPERATORS.toString = $estr;
com.wiris.quizzes.api.assertion.SyntaxParameterName.LIST_OPERATORS.__enum__ = com.wiris.quizzes.api.assertion.SyntaxParameterName;
com.wiris.quizzes.api.assertion.SyntaxParameterName.UNITS = ["UNITS",4];
com.wiris.quizzes.api.assertion.SyntaxParameterName.UNITS.toString = $estr;
com.wiris.quizzes.api.assertion.SyntaxParameterName.UNITS.__enum__ = com.wiris.quizzes.api.assertion.SyntaxParameterName;
com.wiris.quizzes.api.assertion.SyntaxParameterName.UNIT_PREFIXES = ["UNIT_PREFIXES",5];
com.wiris.quizzes.api.assertion.SyntaxParameterName.UNIT_PREFIXES.toString = $estr;
com.wiris.quizzes.api.assertion.SyntaxParameterName.UNIT_PREFIXES.__enum__ = com.wiris.quizzes.api.assertion.SyntaxParameterName;
com.wiris.quizzes.api.assertion.SyntaxParameterName.MIXED_FRACTIONS = ["MIXED_FRACTIONS",6];
com.wiris.quizzes.api.assertion.SyntaxParameterName.MIXED_FRACTIONS.toString = $estr;
com.wiris.quizzes.api.assertion.SyntaxParameterName.MIXED_FRACTIONS.__enum__ = com.wiris.quizzes.api.assertion.SyntaxParameterName;
com.wiris.quizzes.api.assertion.SyntaxParameterName.ITEM_SEPARATORS = ["ITEM_SEPARATORS",7];
com.wiris.quizzes.api.assertion.SyntaxParameterName.ITEM_SEPARATORS.toString = $estr;
com.wiris.quizzes.api.assertion.SyntaxParameterName.ITEM_SEPARATORS.__enum__ = com.wiris.quizzes.api.assertion.SyntaxParameterName;
com.wiris.quizzes.api.assertion.SyntaxParameterName.DECIMAL_SEPARATORS = ["DECIMAL_SEPARATORS",8];
com.wiris.quizzes.api.assertion.SyntaxParameterName.DECIMAL_SEPARATORS.toString = $estr;
com.wiris.quizzes.api.assertion.SyntaxParameterName.DECIMAL_SEPARATORS.__enum__ = com.wiris.quizzes.api.assertion.SyntaxParameterName;
com.wiris.quizzes.api.assertion.SyntaxParameterName.DIGIT_GROUP_SEPARATORS = ["DIGIT_GROUP_SEPARATORS",9];
com.wiris.quizzes.api.assertion.SyntaxParameterName.DIGIT_GROUP_SEPARATORS.toString = $estr;
com.wiris.quizzes.api.assertion.SyntaxParameterName.DIGIT_GROUP_SEPARATORS.__enum__ = com.wiris.quizzes.api.assertion.SyntaxParameterName;
com.wiris.quizzes.api.assertion.SyntaxParameterName.NO_BRACKETS_LIST = ["NO_BRACKETS_LIST",10];
com.wiris.quizzes.api.assertion.SyntaxParameterName.NO_BRACKETS_LIST.toString = $estr;
com.wiris.quizzes.api.assertion.SyntaxParameterName.NO_BRACKETS_LIST.__enum__ = com.wiris.quizzes.api.assertion.SyntaxParameterName;
com.wiris.quizzes.api.assertion.SyntaxParameterName.INTERVALS = ["INTERVALS",11];
com.wiris.quizzes.api.assertion.SyntaxParameterName.INTERVALS.toString = $estr;
com.wiris.quizzes.api.assertion.SyntaxParameterName.INTERVALS.__enum__ = com.wiris.quizzes.api.assertion.SyntaxParameterName;
com.wiris.quizzes.api.assertion.SyntaxParameterName.RATIO = ["RATIO",12];
com.wiris.quizzes.api.assertion.SyntaxParameterName.RATIO.toString = $estr;
com.wiris.quizzes.api.assertion.SyntaxParameterName.RATIO.__enum__ = com.wiris.quizzes.api.assertion.SyntaxParameterName;
com.wiris.quizzes.api.assertion.SyntaxParameterName.SCIENTIFIC_NOTATION = ["SCIENTIFIC_NOTATION",13];
com.wiris.quizzes.api.assertion.SyntaxParameterName.SCIENTIFIC_NOTATION.toString = $estr;
com.wiris.quizzes.api.assertion.SyntaxParameterName.SCIENTIFIC_NOTATION.__enum__ = com.wiris.quizzes.api.assertion.SyntaxParameterName;
com.wiris.quizzes.api.assertion.SyntaxParameterName.GRAPH_MODE = ["GRAPH_MODE",14];
com.wiris.quizzes.api.assertion.SyntaxParameterName.GRAPH_MODE.toString = $estr;
com.wiris.quizzes.api.assertion.SyntaxParameterName.GRAPH_MODE.__enum__ = com.wiris.quizzes.api.assertion.SyntaxParameterName;
com.wiris.quizzes.api.assertion.Validation = $hxClasses["com.wiris.quizzes.api.assertion.Validation"] = function() { }
com.wiris.quizzes.api.assertion.Validation.__name__ = ["com","wiris","quizzes","api","assertion","Validation"];
com.wiris.quizzes.api.assertion.Validation.__interfaces__ = [com.wiris.quizzes.api.Serializable];
com.wiris.quizzes.api.assertion.Validation.prototype = {
	removeParameter: null
	,getParameter: null
	,setParameter: null
	,getName: null
	,__class__: com.wiris.quizzes.api.assertion.Validation
}
com.wiris.quizzes.api.assertion.ValidationName = $hxClasses["com.wiris.quizzes.api.assertion.ValidationName"] = { __ename__ : ["com","wiris","quizzes","api","assertion","ValidationName"], __constructs__ : ["CHECK_SYMBOLIC","CHECK_SCIENTIFIC_NOTATION","CHECK_DECIMAL_NOTATION","CHECK_SIMPLIFIED","CHECK_EXPANDED","CHECK_FACTORIZED","CHECK_NO_COMMON_FACTOR","CHECK_COMMON_DENOMINATOR","CHECK_RATIONALIZED","CHECK_MINIMAL_RADICANDS","CHECK_EQUIVALENT_UNITS","CHECK_PRECISION","CHECK_COLOR","CHECK_NO_SUPERFLUOUS","CHECK_LINE_STYLE"] }
com.wiris.quizzes.api.assertion.ValidationName.CHECK_SYMBOLIC = ["CHECK_SYMBOLIC",0];
com.wiris.quizzes.api.assertion.ValidationName.CHECK_SYMBOLIC.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_SYMBOLIC.__enum__ = com.wiris.quizzes.api.assertion.ValidationName;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_SCIENTIFIC_NOTATION = ["CHECK_SCIENTIFIC_NOTATION",1];
com.wiris.quizzes.api.assertion.ValidationName.CHECK_SCIENTIFIC_NOTATION.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_SCIENTIFIC_NOTATION.__enum__ = com.wiris.quizzes.api.assertion.ValidationName;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_DECIMAL_NOTATION = ["CHECK_DECIMAL_NOTATION",2];
com.wiris.quizzes.api.assertion.ValidationName.CHECK_DECIMAL_NOTATION.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_DECIMAL_NOTATION.__enum__ = com.wiris.quizzes.api.assertion.ValidationName;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_SIMPLIFIED = ["CHECK_SIMPLIFIED",3];
com.wiris.quizzes.api.assertion.ValidationName.CHECK_SIMPLIFIED.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_SIMPLIFIED.__enum__ = com.wiris.quizzes.api.assertion.ValidationName;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_EXPANDED = ["CHECK_EXPANDED",4];
com.wiris.quizzes.api.assertion.ValidationName.CHECK_EXPANDED.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_EXPANDED.__enum__ = com.wiris.quizzes.api.assertion.ValidationName;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_FACTORIZED = ["CHECK_FACTORIZED",5];
com.wiris.quizzes.api.assertion.ValidationName.CHECK_FACTORIZED.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_FACTORIZED.__enum__ = com.wiris.quizzes.api.assertion.ValidationName;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_NO_COMMON_FACTOR = ["CHECK_NO_COMMON_FACTOR",6];
com.wiris.quizzes.api.assertion.ValidationName.CHECK_NO_COMMON_FACTOR.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_NO_COMMON_FACTOR.__enum__ = com.wiris.quizzes.api.assertion.ValidationName;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_COMMON_DENOMINATOR = ["CHECK_COMMON_DENOMINATOR",7];
com.wiris.quizzes.api.assertion.ValidationName.CHECK_COMMON_DENOMINATOR.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_COMMON_DENOMINATOR.__enum__ = com.wiris.quizzes.api.assertion.ValidationName;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_RATIONALIZED = ["CHECK_RATIONALIZED",8];
com.wiris.quizzes.api.assertion.ValidationName.CHECK_RATIONALIZED.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_RATIONALIZED.__enum__ = com.wiris.quizzes.api.assertion.ValidationName;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_MINIMAL_RADICANDS = ["CHECK_MINIMAL_RADICANDS",9];
com.wiris.quizzes.api.assertion.ValidationName.CHECK_MINIMAL_RADICANDS.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_MINIMAL_RADICANDS.__enum__ = com.wiris.quizzes.api.assertion.ValidationName;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_EQUIVALENT_UNITS = ["CHECK_EQUIVALENT_UNITS",10];
com.wiris.quizzes.api.assertion.ValidationName.CHECK_EQUIVALENT_UNITS.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_EQUIVALENT_UNITS.__enum__ = com.wiris.quizzes.api.assertion.ValidationName;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_PRECISION = ["CHECK_PRECISION",11];
com.wiris.quizzes.api.assertion.ValidationName.CHECK_PRECISION.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_PRECISION.__enum__ = com.wiris.quizzes.api.assertion.ValidationName;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_COLOR = ["CHECK_COLOR",12];
com.wiris.quizzes.api.assertion.ValidationName.CHECK_COLOR.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_COLOR.__enum__ = com.wiris.quizzes.api.assertion.ValidationName;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_NO_SUPERFLUOUS = ["CHECK_NO_SUPERFLUOUS",13];
com.wiris.quizzes.api.assertion.ValidationName.CHECK_NO_SUPERFLUOUS.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_NO_SUPERFLUOUS.__enum__ = com.wiris.quizzes.api.assertion.ValidationName;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_LINE_STYLE = ["CHECK_LINE_STYLE",14];
com.wiris.quizzes.api.assertion.ValidationName.CHECK_LINE_STYLE.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationName.CHECK_LINE_STYLE.__enum__ = com.wiris.quizzes.api.assertion.ValidationName;
com.wiris.quizzes.api.assertion.ValidationParameterName = $hxClasses["com.wiris.quizzes.api.assertion.ValidationParameterName"] = { __ename__ : ["com","wiris","quizzes","api","assertion","ValidationParameterName"], __constructs__ : ["MIN","MAX","RELATIVE","ALLOW_PREFIXES","ELEMENTS_TO_GRADE"] }
com.wiris.quizzes.api.assertion.ValidationParameterName.MIN = ["MIN",0];
com.wiris.quizzes.api.assertion.ValidationParameterName.MIN.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationParameterName.MIN.__enum__ = com.wiris.quizzes.api.assertion.ValidationParameterName;
com.wiris.quizzes.api.assertion.ValidationParameterName.MAX = ["MAX",1];
com.wiris.quizzes.api.assertion.ValidationParameterName.MAX.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationParameterName.MAX.__enum__ = com.wiris.quizzes.api.assertion.ValidationParameterName;
com.wiris.quizzes.api.assertion.ValidationParameterName.RELATIVE = ["RELATIVE",2];
com.wiris.quizzes.api.assertion.ValidationParameterName.RELATIVE.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationParameterName.RELATIVE.__enum__ = com.wiris.quizzes.api.assertion.ValidationParameterName;
com.wiris.quizzes.api.assertion.ValidationParameterName.ALLOW_PREFIXES = ["ALLOW_PREFIXES",3];
com.wiris.quizzes.api.assertion.ValidationParameterName.ALLOW_PREFIXES.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationParameterName.ALLOW_PREFIXES.__enum__ = com.wiris.quizzes.api.assertion.ValidationParameterName;
com.wiris.quizzes.api.assertion.ValidationParameterName.ELEMENTS_TO_GRADE = ["ELEMENTS_TO_GRADE",4];
com.wiris.quizzes.api.assertion.ValidationParameterName.ELEMENTS_TO_GRADE.toString = $estr;
com.wiris.quizzes.api.assertion.ValidationParameterName.ELEMENTS_TO_GRADE.__enum__ = com.wiris.quizzes.api.assertion.ValidationParameterName;
com.wiris.quizzes.api.ui.AnswerFeedback = $hxClasses["com.wiris.quizzes.api.ui.AnswerFeedback"] = function() { }
com.wiris.quizzes.api.ui.AnswerFeedback.__name__ = ["com","wiris","quizzes","api","ui","AnswerFeedback"];
com.wiris.quizzes.api.ui.AnswerFeedback.__interfaces__ = [com.wiris.quizzes.api.ui.QuizzesComponent];
com.wiris.quizzes.api.ui.AnswerFeedback.prototype = {
	setAnswerWeight: null
	,showFieldDecorationFeedback: null
	,showAssertionsFeedback: null
	,showCorrectAnswerFeedback: null
	,removeEmbedded: null
	,setEmbedded: null
	,__class__: com.wiris.quizzes.api.ui.AnswerFeedback
}
com.wiris.quizzes.api.ui.AnswerField = $hxClasses["com.wiris.quizzes.api.ui.AnswerField"] = function() { }
com.wiris.quizzes.api.ui.AnswerField.__name__ = ["com","wiris","quizzes","api","ui","AnswerField"];
com.wiris.quizzes.api.ui.AnswerField.__interfaces__ = [com.wiris.quizzes.api.ui.QuizzesField];
com.wiris.quizzes.api.ui.AnswerField.prototype = {
	reuseComponent: null
	,getAnswerFieldComponent: null
	,setEditorInitialParams: null
	,getFieldType: null
	,__class__: com.wiris.quizzes.api.ui.AnswerField
}
com.wiris.quizzes.api.ui.AnswerFieldComponentListener = $hxClasses["com.wiris.quizzes.api.ui.AnswerFieldComponentListener"] = function() { }
com.wiris.quizzes.api.ui.AnswerFieldComponentListener.__name__ = ["com","wiris","quizzes","api","ui","AnswerFieldComponentListener"];
com.wiris.quizzes.api.ui.AnswerFieldComponentListener.prototype = {
	onGetAnswerFieldComponent: null
	,__class__: com.wiris.quizzes.api.ui.AnswerFieldComponentListener
}
com.wiris.quizzes.api.ui.AnswerFieldType = $hxClasses["com.wiris.quizzes.api.ui.AnswerFieldType"] = { __ename__ : ["com","wiris","quizzes","api","ui","AnswerFieldType"], __constructs__ : ["TEXT_FIELD","INLINE_MATH_EDITOR","POPUP_MATH_EDITOR","INLINE_GRAPH_EDITOR"] }
com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD = ["TEXT_FIELD",0];
com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD.toString = $estr;
com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD.__enum__ = com.wiris.quizzes.api.ui.AnswerFieldType;
com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_MATH_EDITOR = ["INLINE_MATH_EDITOR",1];
com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_MATH_EDITOR.toString = $estr;
com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_MATH_EDITOR.__enum__ = com.wiris.quizzes.api.ui.AnswerFieldType;
com.wiris.quizzes.api.ui.AnswerFieldType.POPUP_MATH_EDITOR = ["POPUP_MATH_EDITOR",2];
com.wiris.quizzes.api.ui.AnswerFieldType.POPUP_MATH_EDITOR.toString = $estr;
com.wiris.quizzes.api.ui.AnswerFieldType.POPUP_MATH_EDITOR.__enum__ = com.wiris.quizzes.api.ui.AnswerFieldType;
com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR = ["INLINE_GRAPH_EDITOR",3];
com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR.toString = $estr;
com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR.__enum__ = com.wiris.quizzes.api.ui.AnswerFieldType;
com.wiris.quizzes.api.ui.AuthoringFieldType = $hxClasses["com.wiris.quizzes.api.ui.AuthoringFieldType"] = { __ename__ : ["com","wiris","quizzes","api","ui","AuthoringFieldType"], __constructs__ : ["STUDIO","INLINE_STUDIO","INLINE_MATH_EDITOR","EMBEDDED_ANSWERS_EDITOR"] }
com.wiris.quizzes.api.ui.AuthoringFieldType.STUDIO = ["STUDIO",0];
com.wiris.quizzes.api.ui.AuthoringFieldType.STUDIO.toString = $estr;
com.wiris.quizzes.api.ui.AuthoringFieldType.STUDIO.__enum__ = com.wiris.quizzes.api.ui.AuthoringFieldType;
com.wiris.quizzes.api.ui.AuthoringFieldType.INLINE_STUDIO = ["INLINE_STUDIO",1];
com.wiris.quizzes.api.ui.AuthoringFieldType.INLINE_STUDIO.toString = $estr;
com.wiris.quizzes.api.ui.AuthoringFieldType.INLINE_STUDIO.__enum__ = com.wiris.quizzes.api.ui.AuthoringFieldType;
com.wiris.quizzes.api.ui.AuthoringFieldType.INLINE_MATH_EDITOR = ["INLINE_MATH_EDITOR",2];
com.wiris.quizzes.api.ui.AuthoringFieldType.INLINE_MATH_EDITOR.toString = $estr;
com.wiris.quizzes.api.ui.AuthoringFieldType.INLINE_MATH_EDITOR.__enum__ = com.wiris.quizzes.api.ui.AuthoringFieldType;
com.wiris.quizzes.api.ui.AuthoringFieldType.EMBEDDED_ANSWERS_EDITOR = ["EMBEDDED_ANSWERS_EDITOR",3];
com.wiris.quizzes.api.ui.AuthoringFieldType.EMBEDDED_ANSWERS_EDITOR.toString = $estr;
com.wiris.quizzes.api.ui.AuthoringFieldType.EMBEDDED_ANSWERS_EDITOR.__enum__ = com.wiris.quizzes.api.ui.AuthoringFieldType;
com.wiris.quizzes.api.ui.AuxiliaryCasField = $hxClasses["com.wiris.quizzes.api.ui.AuxiliaryCasField"] = function() { }
com.wiris.quizzes.api.ui.AuxiliaryCasField.__name__ = ["com","wiris","quizzes","api","ui","AuxiliaryCasField"];
com.wiris.quizzes.api.ui.AuxiliaryCasField.__interfaces__ = [com.wiris.quizzes.api.ui.QuizzesField];
com.wiris.quizzes.api.ui.EmbeddedAnswersEditorMode = $hxClasses["com.wiris.quizzes.api.ui.EmbeddedAnswersEditorMode"] = { __ename__ : ["com","wiris","quizzes","api","ui","EmbeddedAnswersEditorMode"], __constructs__ : ["AUTHORING","DELIVERY","REVIEW"] }
com.wiris.quizzes.api.ui.EmbeddedAnswersEditorMode.AUTHORING = ["AUTHORING",0];
com.wiris.quizzes.api.ui.EmbeddedAnswersEditorMode.AUTHORING.toString = $estr;
com.wiris.quizzes.api.ui.EmbeddedAnswersEditorMode.AUTHORING.__enum__ = com.wiris.quizzes.api.ui.EmbeddedAnswersEditorMode;
com.wiris.quizzes.api.ui.EmbeddedAnswersEditorMode.DELIVERY = ["DELIVERY",1];
com.wiris.quizzes.api.ui.EmbeddedAnswersEditorMode.DELIVERY.toString = $estr;
com.wiris.quizzes.api.ui.EmbeddedAnswersEditorMode.DELIVERY.__enum__ = com.wiris.quizzes.api.ui.EmbeddedAnswersEditorMode;
com.wiris.quizzes.api.ui.EmbeddedAnswersEditorMode.REVIEW = ["REVIEW",2];
com.wiris.quizzes.api.ui.EmbeddedAnswersEditorMode.REVIEW.toString = $estr;
com.wiris.quizzes.api.ui.EmbeddedAnswersEditorMode.REVIEW.__enum__ = com.wiris.quizzes.api.ui.EmbeddedAnswersEditorMode;
com.wiris.quizzes.api.ui.QuizzesUIBuilder = $hxClasses["com.wiris.quizzes.api.ui.QuizzesUIBuilder"] = function() { }
com.wiris.quizzes.api.ui.QuizzesUIBuilder.__name__ = ["com","wiris","quizzes","api","ui","QuizzesUIBuilder"];
com.wiris.quizzes.api.ui.QuizzesUIBuilder.prototype = {
	replaceFields: null
	,getMathViewer: null
	,newAuxiliarCasField: null
	,newEmbeddedAnswersEditor: null
	,newAuthoringField: null
	,newAnswerField: null
	,newAnswerFeedback: null
	,setLanguage: null
	,__class__: com.wiris.quizzes.api.ui.QuizzesUIBuilder
}
com.wiris.quizzes.api.ui.QuizzesUIConstants = $hxClasses["com.wiris.quizzes.api.ui.QuizzesUIConstants"] = function() { }
com.wiris.quizzes.api.ui.QuizzesUIConstants.__name__ = ["com","wiris","quizzes","api","ui","QuizzesUIConstants"];
com.wiris.system.Utf8 = $hxClasses["com.wiris.system.Utf8"] = function() {
};
com.wiris.system.Utf8.__name__ = ["com","wiris","system","Utf8"];
com.wiris.system.Utf8.findUTF8Position = function(s,position,carry8,carry16) {
	if(carry16 == null) carry16 = 0;
	if(carry8 == null) carry8 = 0;
	var i8 = carry8;
	var i16 = carry16;
	var n8 = s.length;
	while(i8 < n8 && i16 < position) {
		var charCode = HxOverrides.cca(s,i8);
		if(charCode < 55296 || charCode > 56319) ++i16;
		++i8;
	}
	return i8;
}
com.wiris.system.Utf8.getLength = function(s) {
	var i8 = 0;
	var n8 = s.length;
	var counter16 = 0;
	while(i8 < n8) {
		var charCode = HxOverrides.cca(s,i8);
		if(charCode < 55296 || charCode > 56319) ++counter16;
		++i8;
	}
	return counter16;
}
com.wiris.system.Utf8.charCodeAt = function(s,i) {
	var i8 = com.wiris.system.Utf8.findUTF8Position(s,i,null,null);
	var charCode = HxOverrides.cca(s,i8);
	return charCode < 55296 || charCode > 56319?charCode:(charCode - 55296) * 1024 + HxOverrides.cca(s,i8 + 1) - 56320 + 65536;
}
com.wiris.system.Utf8.mbSubstring = function(s,i,len) {
	return HxOverrides.substr(s,i,len);
}
com.wiris.system.Utf8.charValueAt = function(s,i) {
	return HxOverrides.cca(s,i);
}
com.wiris.system.Utf8.charAt = function(s,i) {
	return com.wiris.system.Utf8.uchr(com.wiris.system.Utf8.charCodeAt(s,i));
}
com.wiris.system.Utf8.uchr = function(i) {
	var s = new haxe.Utf8();
	if(i < 65536) s.__b += String.fromCharCode(i); else if(i <= 1114111) {
		s.__b += String.fromCharCode((i >> 10) + 55232);
		s.__b += String.fromCharCode((i & 1023) + 56320);
	} else throw "Invalid code point.";
	return s.__b;
}
com.wiris.system.Utf8.sub = function(s,pos,len) {
	var start = com.wiris.system.Utf8.findUTF8Position(s,pos,null,null);
	var end = com.wiris.system.Utf8.findUTF8Position(s,pos + len,start,pos);
	return HxOverrides.substr(s,start,end - start);
}
com.wiris.system.Utf8.toBytes = function(s) {
	return haxe.io.Bytes.ofString(s).b;
}
com.wiris.system.Utf8.fromBytes = function(s) {
	var bs = haxe.io.Bytes.ofData(s);
	return bs.toString();
}
com.wiris.system.Utf8.getIterator = function(s) {
	return new com.wiris.system._Utf8.StringIterator(s);
}
com.wiris.system.Utf8.prototype = {
	__class__: com.wiris.system.Utf8
}
var haxe = haxe || {}
haxe.Utf8 = $hxClasses["haxe.Utf8"] = function(size) {
	this.__b = "";
};
haxe.Utf8.__name__ = ["haxe","Utf8"];
haxe.Utf8.iter = function(s,chars) {
	var _g1 = 0, _g = s.length;
	while(_g1 < _g) {
		var i = _g1++;
		chars(HxOverrides.cca(s,i));
	}
}
haxe.Utf8.encode = function(s) {
	throw "Not implemented";
	return s;
}
haxe.Utf8.decode = function(s) {
	throw "Not implemented";
	return s;
}
haxe.Utf8.charCodeAt = function(s,index) {
	return HxOverrides.cca(s,index);
}
haxe.Utf8.validate = function(s) {
	return true;
}
haxe.Utf8.compare = function(a,b) {
	return a > b?1:a == b?0:-1;
}
haxe.Utf8.sub = function(s,pos,len) {
	return HxOverrides.substr(s,pos,len);
}
haxe.Utf8.prototype = {
	toString: function() {
		return this.__b;
	}
	,addChar: function(c) {
		this.__b += String.fromCharCode(c);
	}
	,__b: null
	,__class__: haxe.Utf8
}
com.wiris.quizzes.impl.ActionCommands = $hxClasses["com.wiris.quizzes.impl.ActionCommands"] = function() { }
com.wiris.quizzes.impl.ActionCommands.__name__ = ["com","wiris","quizzes","impl","ActionCommands"];
if(!com.wiris.util.xml) com.wiris.util.xml = {}
com.wiris.util.xml.SerializableImpl = $hxClasses["com.wiris.util.xml.SerializableImpl"] = function() {
};
com.wiris.util.xml.SerializableImpl.__name__ = ["com","wiris","util","xml","SerializableImpl"];
com.wiris.util.xml.SerializableImpl.prototype = {
	serialize: function() {
		var s = new com.wiris.util.xml.XmlSerializer();
		return s.write(this);
	}
	,newInstance: function() {
		return new com.wiris.util.xml.SerializableImpl();
	}
	,onSerialize: function(s) {
	}
	,__class__: com.wiris.util.xml.SerializableImpl
}
com.wiris.quizzes.impl.MathContent = $hxClasses["com.wiris.quizzes.impl.MathContent"] = function() {
	com.wiris.util.xml.SerializableImpl.call(this);
};
com.wiris.quizzes.impl.MathContent.__name__ = ["com","wiris","quizzes","impl","MathContent"];
com.wiris.quizzes.impl.MathContent.getMathType = function(content) {
	if(content == null || content == "") return com.wiris.quizzes.impl.MathContent.TYPE_TEXT;
	content = StringTools.trim(content);
	var i;
	if(StringTools.startsWith(content,"<") && StringTools.endsWith(content,">")) {
		var mathmltags = ["math","mn","mo","mi","mrow","mfrac","mtext","ms","mroot","msqrt","mfenced","msub","msup","msubsup","mover","munder","munderover"];
		var _g1 = 0, _g = mathmltags.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(StringTools.startsWith(content,"<" + mathmltags[i1])) return com.wiris.quizzes.impl.MathContent.TYPE_MATHML;
		}
	}
	if(com.wiris.util.geometry.GeometryFile.isGeometryFile(content)) return com.wiris.quizzes.impl.MathContent.TYPE_GEOMETRY_FILE;
	return com.wiris.quizzes.impl.MathContent.TYPE_TEXT;
}
com.wiris.quizzes.impl.MathContent.isEmpty = function(content) {
	content = StringTools.trim(content);
	if(StringTools.startsWith(content,"<math")) {
		content = HxOverrides.substr(content,content.indexOf(">") + 1,null);
		if(content.length > 0) content = HxOverrides.substr(content,0,content.lastIndexOf("<"));
	}
	while(StringTools.startsWith(content,"<mrow")) {
		content = HxOverrides.substr(content,content.indexOf(">") + 1,null);
		content = HxOverrides.substr(content,0,content.lastIndexOf("<"));
	}
	return content.length == 0;
}
com.wiris.quizzes.impl.MathContent.__super__ = com.wiris.util.xml.SerializableImpl;
com.wiris.quizzes.impl.MathContent.prototype = $extend(com.wiris.util.xml.SerializableImpl.prototype,{
	newInstance: function() {
		return new com.wiris.quizzes.impl.MathContent();
	}
	,onSerializeInner: function(s) {
		this.type = s.attributeString("type",this.type,"text");
		this.content = s.textContent(this.content);
	}
	,onSerialize: function(s) {
		s.beginTag("math");
		this.onSerializeInner(s);
		s.endTag();
	}
	,set: function(content) {
		this.type = com.wiris.quizzes.impl.MathContent.getMathType(content);
		this.content = content;
	}
	,content: null
	,type: null
	,__class__: com.wiris.quizzes.impl.MathContent
});
com.wiris.quizzes.impl.Answer = $hxClasses["com.wiris.quizzes.impl.Answer"] = function() {
	com.wiris.quizzes.impl.MathContent.call(this);
	this.id = "0";
};
com.wiris.quizzes.impl.Answer.__name__ = ["com","wiris","quizzes","impl","Answer"];
com.wiris.quizzes.impl.Answer.__super__ = com.wiris.quizzes.impl.MathContent;
com.wiris.quizzes.impl.Answer.prototype = $extend(com.wiris.quizzes.impl.MathContent.prototype,{
	onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.Answer.tagName);
		this.id = s.attributeString("id",this.id,"0");
		com.wiris.quizzes.impl.MathContent.prototype.onSerializeInner.call(this,s);
		s.endTag();
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.Answer();
	}
	,id: null
	,__class__: com.wiris.quizzes.impl.Answer
});
com.wiris.quizzes.impl.Assertion = $hxClasses["com.wiris.quizzes.impl.Assertion"] = function() {
	com.wiris.util.xml.SerializableImpl.call(this);
};
com.wiris.quizzes.impl.Assertion.__name__ = ["com","wiris","quizzes","impl","Assertion"];
com.wiris.quizzes.impl.Assertion.paramdefault = null;
com.wiris.quizzes.impl.Assertion.paramnames = null;
com.wiris.quizzes.impl.Assertion.initParams = function() {
	com.wiris.quizzes.impl.Assertion.paramnames = new Hash();
	com.wiris.quizzes.impl.Assertion.paramnames.set(com.wiris.quizzes.impl.Assertion.SYNTAX_EXPRESSION,[com.wiris.quizzes.impl.Assertion.PARAM_CONSTANTS,com.wiris.quizzes.impl.Assertion.PARAM_FUNCTIONS,com.wiris.quizzes.impl.Assertion.PARAM_LIST_OPERATORS,com.wiris.quizzes.impl.Assertion.PARAM_GROUP_OPERATORS,com.wiris.quizzes.impl.Assertion.PARAM_ITEM_SEPARATORS,com.wiris.quizzes.impl.Assertion.PARAM_DECIMAL_SEPARATORS,com.wiris.quizzes.impl.Assertion.PARAM_DIGIT_GROUP_SEPARATORS,com.wiris.quizzes.impl.Assertion.PARAM_NO_BRACKETS_LIST,com.wiris.quizzes.impl.Assertion.PARAM_INTERVALS,com.wiris.quizzes.impl.Assertion.PARAM_TEXT_LOGIC_OPERATORS]);
	com.wiris.quizzes.impl.Assertion.paramnames.set(com.wiris.quizzes.impl.Assertion.SYNTAX_LIST,[com.wiris.quizzes.impl.Assertion.PARAM_CONSTANTS,com.wiris.quizzes.impl.Assertion.PARAM_FUNCTIONS]);
	com.wiris.quizzes.impl.Assertion.paramnames.set(com.wiris.quizzes.impl.Assertion.SYNTAX_QUANTITY,[com.wiris.quizzes.impl.Assertion.PARAM_CONSTANTS,com.wiris.quizzes.impl.Assertion.PARAM_UNITS,com.wiris.quizzes.impl.Assertion.PARAM_UNIT_PREFIXES,com.wiris.quizzes.impl.Assertion.PARAM_GROUP_OPERATORS,com.wiris.quizzes.impl.Assertion.PARAM_MIXED_FRACTIONS,com.wiris.quizzes.impl.Assertion.PARAM_ITEM_SEPARATORS,com.wiris.quizzes.impl.Assertion.PARAM_DECIMAL_SEPARATORS,com.wiris.quizzes.impl.Assertion.PARAM_DIGIT_GROUP_SEPARATORS,com.wiris.quizzes.impl.Assertion.PARAM_NO_BRACKETS_LIST]);
	com.wiris.quizzes.impl.Assertion.paramnames.set(com.wiris.quizzes.impl.Assertion.CHECK_DIVISIBLE,[com.wiris.quizzes.impl.Assertion.PARAM_VALUE]);
	com.wiris.quizzes.impl.Assertion.paramnames.set(com.wiris.quizzes.impl.Assertion.CHECK_UNIT,[com.wiris.quizzes.impl.Assertion.PARAM_UNIT]);
	com.wiris.quizzes.impl.Assertion.paramnames.set(com.wiris.quizzes.impl.Assertion.CHECK_UNIT_LITERAL,[com.wiris.quizzes.impl.Assertion.PARAM_UNIT]);
	com.wiris.quizzes.impl.Assertion.paramnames.set(com.wiris.quizzes.impl.Assertion.CHECK_NO_MORE_DECIMALS,[com.wiris.quizzes.impl.Assertion.PARAM_DIGITS]);
	com.wiris.quizzes.impl.Assertion.paramnames.set(com.wiris.quizzes.impl.Assertion.CHECK_NO_MORE_DIGITS,[com.wiris.quizzes.impl.Assertion.PARAM_DIGITS]);
	com.wiris.quizzes.impl.Assertion.paramnames.set(com.wiris.quizzes.impl.Assertion.CHECK_PRECISION,[com.wiris.quizzes.impl.Assertion.PARAM_MIN,com.wiris.quizzes.impl.Assertion.PARAM_MAX,com.wiris.quizzes.impl.Assertion.PARAM_RELATIVE]);
	com.wiris.quizzes.impl.Assertion.paramnames.set(com.wiris.quizzes.impl.Assertion.EQUIVALENT_FUNCTION,[com.wiris.quizzes.impl.Assertion.PARAM_NAME,com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE,com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE_DIGITS,com.wiris.quizzes.impl.Assertion.PARAM_RELATIVE_TOLERANCE,com.wiris.quizzes.impl.Assertion.PARAM_NOT_EVALUATE,com.wiris.quizzes.impl.Assertion.PARAM_FUNCTION_ARGUMENT_MODE]);
	com.wiris.quizzes.impl.Assertion.paramnames.set(com.wiris.quizzes.impl.Assertion.EQUIVALENT_SYMBOLIC,[com.wiris.quizzes.impl.Assertion.PARAM_ORDER_MATTERS,com.wiris.quizzes.impl.Assertion.PARAM_REPETITION_MATTERS,com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE,com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE_DIGITS,com.wiris.quizzes.impl.Assertion.PARAM_RELATIVE_TOLERANCE]);
	com.wiris.quizzes.impl.Assertion.paramnames.set(com.wiris.quizzes.impl.Assertion.EQUIVALENT_LITERAL,[com.wiris.quizzes.impl.Assertion.PARAM_ORDER_MATTERS,com.wiris.quizzes.impl.Assertion.PARAM_REPETITION_MATTERS,com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE,com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE_DIGITS,com.wiris.quizzes.impl.Assertion.PARAM_RELATIVE_TOLERANCE,com.wiris.quizzes.impl.Assertion.PARAM_USE_CASE,com.wiris.quizzes.impl.Assertion.PARAM_USE_SPACES]);
	com.wiris.quizzes.impl.Assertion.paramnames.set(com.wiris.quizzes.impl.Assertion.EQUIVALENT_EQUATIONS,[com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE,com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE_DIGITS,com.wiris.quizzes.impl.Assertion.PARAM_RELATIVE_TOLERANCE]);
	com.wiris.quizzes.impl.Assertion.paramnames.set(com.wiris.quizzes.impl.Assertion.SYNTAX_MATH,[com.wiris.quizzes.impl.Assertion.PARAM_CONSTANTS,com.wiris.quizzes.impl.Assertion.PARAM_FUNCTIONS,com.wiris.quizzes.impl.Assertion.PARAM_LIST_OPERATORS,com.wiris.quizzes.impl.Assertion.PARAM_GROUP_OPERATORS,com.wiris.quizzes.impl.Assertion.PARAM_ITEM_SEPARATORS,com.wiris.quizzes.impl.Assertion.PARAM_DECIMAL_SEPARATORS,com.wiris.quizzes.impl.Assertion.PARAM_DIGIT_GROUP_SEPARATORS,com.wiris.quizzes.impl.Assertion.PARAM_NO_BRACKETS_LIST,com.wiris.quizzes.impl.Assertion.PARAM_INTERVALS,com.wiris.quizzes.impl.Assertion.PARAM_TEXT_LOGIC_OPERATORS,com.wiris.quizzes.impl.Assertion.PARAM_RATIO,com.wiris.quizzes.impl.Assertion.PARAM_SCIENTIFIC_NOTATION,com.wiris.quizzes.impl.Assertion.PARAM_UNITS,com.wiris.quizzes.impl.Assertion.PARAM_UNIT_PREFIXES,com.wiris.quizzes.impl.Assertion.PARAM_MIXED_FRACTIONS]);
	com.wiris.quizzes.impl.Assertion.paramnames.set(com.wiris.quizzes.impl.Assertion.SYNTAX_GRAPHIC,[com.wiris.quizzes.impl.Assertion.PARAM_GRAPH_MODE]);
	var paramvalues;
	com.wiris.quizzes.impl.Assertion.paramdefault = new Hash();
	var constantsExpression = com.wiris.system.Utf8.uchr(960) + ", e, i, j";
	var functions = "exp, log, ln, sin, cos, tan, asin, acos, atan, arcsin, arccos, arctan, cosec, csc, sec, cotan, cot, acosec, acsc, arccosec, arccsc, asec, arcsec, acotan, acot, arccotan, arccot, sen, asen, arcsen, sinh, cosh, tanh, asinh, acosh, atanh, arcsinh, arccosh, arctanh, arsinh, arcosh, artanh, cosech, csch, sech, cotanh, coth, acosech, acsch, arccosech, arccsch, arcosech, arcsch, asech, arcsech, arsech, acotanh, acoth, arccotanh, arccoth, arcotanh, arcoth, senh, asenh, arcsenh, arsenh, min, max, sign";
	var groupoperators = "(,[";
	var listoperators = "{";
	paramvalues = new Hash();
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_CONSTANTS,constantsExpression);
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_FUNCTIONS,functions);
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_GROUP_OPERATORS,groupoperators);
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_LIST_OPERATORS,listoperators);
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_ITEM_SEPARATORS,";, \\n, \\,");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_DECIMAL_SEPARATORS,".");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_DIGIT_GROUP_SEPARATORS,"");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_NO_BRACKETS_LIST,"false");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_INTERVALS,"false");
	com.wiris.quizzes.impl.Assertion.paramdefault.set(com.wiris.quizzes.impl.Assertion.SYNTAX_EXPRESSION,paramvalues);
	paramvalues = new Hash();
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_CONSTANTS,constantsExpression);
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_FUNCTIONS,functions);
	com.wiris.quizzes.impl.Assertion.paramdefault.set(com.wiris.quizzes.impl.Assertion.SYNTAX_LIST,paramvalues);
	var constantsQuantity = com.wiris.system.Utf8.uchr(960) + ", i, j";
	paramvalues = new Hash();
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_CONSTANTS,constantsQuantity);
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_GROUP_OPERATORS,groupoperators);
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_LIST_OPERATORS,listoperators);
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_UNITS,com.wiris.quizzes.impl.Assertion.ALL_UNITS_LIST);
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_UNIT_PREFIXES,"m, c, k, M");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_MIXED_FRACTIONS,"false");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_ITEM_SEPARATORS,";, \\n");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_DECIMAL_SEPARATORS,"', " + com.wiris.system.Utf8.uchr(180) + ", ., \\,");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_DIGIT_GROUP_SEPARATORS,"");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_NO_BRACKETS_LIST,"false");
	com.wiris.quizzes.impl.Assertion.paramdefault.set(com.wiris.quizzes.impl.Assertion.SYNTAX_QUANTITY,paramvalues);
	paramvalues = new Hash();
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_CONSTANTS,constantsExpression);
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_FUNCTIONS,functions);
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_GROUP_OPERATORS,groupoperators);
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_LIST_OPERATORS,listoperators);
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_UNITS,"");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_UNIT_PREFIXES,"");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_MIXED_FRACTIONS,"false");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_ITEM_SEPARATORS,";, \\n, \\,");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_DECIMAL_SEPARATORS,".");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_DIGIT_GROUP_SEPARATORS,"");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_NO_BRACKETS_LIST,"false");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_INTERVALS,"false");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_RATIO,"false");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_SCIENTIFIC_NOTATION,"false");
	com.wiris.quizzes.impl.Assertion.paramdefault.set(com.wiris.quizzes.impl.Assertion.SYNTAX_MATH,paramvalues);
	paramvalues = new Hash();
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_ORDER_MATTERS,"true");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_REPETITION_MATTERS,"true");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE,"");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE_DIGITS,"");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_RELATIVE_TOLERANCE,"");
	com.wiris.quizzes.impl.Assertion.paramdefault.set(com.wiris.quizzes.impl.Assertion.EQUIVALENT_SYMBOLIC,paramvalues);
	paramvalues = new Hash();
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_ORDER_MATTERS,"true");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_REPETITION_MATTERS,"true");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE,"");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE_DIGITS,"");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_RELATIVE_TOLERANCE,"");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_USE_CASE,"true");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_USE_SPACES,"true");
	com.wiris.quizzes.impl.Assertion.paramdefault.set(com.wiris.quizzes.impl.Assertion.EQUIVALENT_LITERAL,paramvalues);
	paramvalues = new Hash();
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_NAME,"");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE,"");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE_DIGITS,"");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_RELATIVE_TOLERANCE,"");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_FUNCTION_ARGUMENT_MODE,com.wiris.quizzes.impl.Assertion.PARAM_VALUE_FUNCTION_ARGUMENT_EVALUATED);
	com.wiris.quizzes.impl.Assertion.paramdefault.set(com.wiris.quizzes.impl.Assertion.EQUIVALENT_FUNCTION,paramvalues);
	paramvalues = new Hash();
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE,"");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE_DIGITS,"");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_RELATIVE_TOLERANCE,"");
	com.wiris.quizzes.impl.Assertion.paramdefault.set(com.wiris.quizzes.impl.Assertion.EQUIVALENT_EQUATIONS,paramvalues);
	paramvalues = new Hash();
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_VALUE,"");
	com.wiris.quizzes.impl.Assertion.paramdefault.set(com.wiris.quizzes.impl.Assertion.CHECK_DIVISIBLE,paramvalues);
	paramvalues = new Hash();
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_UNIT,"");
	com.wiris.quizzes.impl.Assertion.paramdefault.set(com.wiris.quizzes.impl.Assertion.CHECK_UNIT,paramvalues);
	paramvalues = new Hash();
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_UNIT,"");
	com.wiris.quizzes.impl.Assertion.paramdefault.set(com.wiris.quizzes.impl.Assertion.CHECK_UNIT_LITERAL,paramvalues);
	paramvalues = new Hash();
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_DIGITS,"");
	com.wiris.quizzes.impl.Assertion.paramdefault.set(com.wiris.quizzes.impl.Assertion.CHECK_NO_MORE_DECIMALS,paramvalues);
	paramvalues = new Hash();
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_DIGITS,"");
	com.wiris.quizzes.impl.Assertion.paramdefault.set(com.wiris.quizzes.impl.Assertion.CHECK_NO_MORE_DIGITS,paramvalues);
	paramvalues = new Hash();
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_MIN,"");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_MAX,"");
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_RELATIVE,"true");
	com.wiris.quizzes.impl.Assertion.paramdefault.set(com.wiris.quizzes.impl.Assertion.CHECK_PRECISION,paramvalues);
	paramvalues = new Hash();
	paramvalues.set(com.wiris.quizzes.impl.Assertion.PARAM_GRAPH_MODE,com.wiris.quizzes.impl.Assertion.GRAPH_MODE_STANDARD);
	com.wiris.quizzes.impl.Assertion.paramdefault.set(com.wiris.quizzes.impl.Assertion.SYNTAX_GRAPHIC,paramvalues);
}
com.wiris.quizzes.impl.Assertion.getParameterNames = function(name) {
	if(com.wiris.quizzes.impl.Assertion.paramnames == null) com.wiris.quizzes.impl.Assertion.initParams();
	return com.wiris.quizzes.impl.Assertion.paramnames.get(name);
}
com.wiris.quizzes.impl.Assertion.getParameterDefaultValue = function(assertion,parameter) {
	var value;
	if(com.wiris.quizzes.impl.Assertion.paramdefault == null) com.wiris.quizzes.impl.Assertion.initParams();
	if(com.wiris.quizzes.impl.Assertion.paramdefault.exists(assertion) && com.wiris.quizzes.impl.Assertion.paramdefault.get(assertion).exists(parameter)) value = com.wiris.quizzes.impl.Assertion.paramdefault.get(assertion).get(parameter); else value = "";
	return value;
}
com.wiris.quizzes.impl.Assertion.isSyntacticName = function(name) {
	return com.wiris.util.type.Arrays.containsArray(com.wiris.quizzes.impl.Assertion.syntactic,name);
}
com.wiris.quizzes.impl.Assertion.isEquivalenceName = function(name) {
	return com.wiris.util.type.Arrays.containsArray(com.wiris.quizzes.impl.Assertion.equivalent,name);
}
com.wiris.quizzes.impl.Assertion.__super__ = com.wiris.util.xml.SerializableImpl;
com.wiris.quizzes.impl.Assertion.prototype = $extend(com.wiris.util.xml.SerializableImpl.prototype,{
	isEquivalent: function(a) {
		if(!(a.name == this.name)) return false;
		if(this.correctAnswer.length != a.correctAnswer.length) return false;
		var i;
		var _g1 = 0, _g = this.correctAnswer.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(!(this.correctAnswer[i1] == a.correctAnswer[i1])) return false;
		}
		if(this.answer.length != a.answer.length) return false;
		var _g1 = 0, _g = this.answer.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(!(this.answer[i1] == a.answer[i1])) return false;
		}
		if(this.parameters != null && a.parameters != null) {
			var _g1 = 0, _g = this.parameters.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var p = this.parameters[i1];
				var q = a.parameters[i1];
				if(!(p.name == q.name)) return false;
				if(!(p.type == q.type)) return false;
				if(!(p.content == q.content)) return false;
			}
			return true;
		}
		return this.parameters == null && a.parameters == null;
	}
	,copyArrayString: function(a) {
		var b = new Array();
		var i;
		var _g1 = 0, _g = a.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			b[i1] = a[i1];
		}
		return b;
	}
	,importAssertionNameAndParams: function(a) {
		this.name = a.name;
		this.parameters = a.parameters;
	}
	,copy: function() {
		var a = new com.wiris.quizzes.impl.Assertion();
		a.name = this.name;
		if(this.correctAnswer != null) a.correctAnswer = this.copyArrayString(this.correctAnswer);
		if(this.answer != null) a.answer = this.copyArrayString(this.answer);
		if(this.parameters != null) {
			a.parameters = new Array();
			var i;
			var _g1 = 0, _g = this.parameters.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var p = this.parameters[i1];
				var q = new com.wiris.quizzes.impl.AssertionParam();
				q.name = p.name;
				q.type = p.type;
				q.content = p.content;
				a.parameters.push(q);
			}
		}
		return a;
	}
	,isStructure: function() {
		return com.wiris.util.type.Arrays.containsArray(com.wiris.quizzes.impl.Assertion.structure,this.name);
	}
	,isCheck: function() {
		return com.wiris.util.type.Arrays.containsArray(com.wiris.quizzes.impl.Assertion.checks,this.name) || com.wiris.quizzes.impl.Assertion.CHECK_NO_MORE_DIGITS == this.name || com.wiris.quizzes.impl.Assertion.CHECK_NO_MORE_DECIMALS == this.name;
	}
	,isEquivalence: function() {
		return com.wiris.quizzes.impl.Assertion.isEquivalenceName(this.name) || com.wiris.quizzes.impl.Assertion.EQUIVALENT_SET == this.name;
	}
	,isSyntactic: function() {
		return com.wiris.quizzes.impl.Assertion.isSyntacticName(this.name) || com.wiris.quizzes.impl.Assertion.SYNTAX_EXPRESSION == this.name || com.wiris.quizzes.impl.Assertion.SYNTAX_QUANTITY == this.name;
	}
	,equalLists: function(a,b) {
		if(a == null || b == null) return a == null && b == null;
		var aa = a.split(",");
		var bb = b.split(",");
		if(aa.length != bb.length) return false;
		var i;
		var _g1 = 0, _g = aa.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(!com.wiris.util.type.Arrays.containsArray(bb,aa[i1])) return false;
		}
		return true;
	}
	,isDefaultParameterValue: function(name,value) {
		var defValue = com.wiris.quizzes.impl.Assertion.getParameterDefaultValue(this.name,name);
		return this.equalLists(defValue,value);
	}
	,hasParam: function(name) {
		if(this.parameters != null) {
			var i;
			var _g1 = 0, _g = this.parameters.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				if(this.parameters[i1].name == name) return true;
			}
		}
		return false;
	}
	,getParam: function(name) {
		if(this.parameters != null) {
			var i;
			var _g1 = 0, _g = this.parameters.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				if(this.parameters[i1].name == name) return this.parameters[i1].content;
			}
		}
		if(com.wiris.quizzes.impl.Assertion.paramdefault == null) com.wiris.quizzes.impl.Assertion.initParams();
		if(com.wiris.quizzes.impl.Assertion.paramdefault.exists(this.name)) {
			var values = com.wiris.quizzes.impl.Assertion.paramdefault.get(this.name);
			if(values.exists(name)) return values.get(name);
		}
		return null;
	}
	,setParam: function(name,value) {
		if(this.parameters == null) this.parameters = new Array();
		if(this.isDefaultParameterValue(name,value)) this.removeParam(name); else {
			var found = false;
			var i;
			var _g1 = 0, _g = this.parameters.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var p = this.parameters[i1];
				if(p.name == name) {
					p.content = value;
					found = true;
				}
			}
			if(!found) {
				var q = new com.wiris.quizzes.impl.AssertionParam();
				q.name = name;
				q.content = value;
				q.type = com.wiris.quizzes.impl.MathContent.TYPE_TEXT;
				this.parameters.push(q);
			}
		}
	}
	,removeParam: function(name) {
		if(this.parameters != null) {
			var j = this.parameters.length - 1;
			while(j >= 0) {
				if(this.parameters[j].name == name) HxOverrides.remove(this.parameters,this.parameters[j]);
				j--;
			}
		}
	}
	,getAnswers: function() {
		if(this.answer != null) return this.answer; else return new Array();
	}
	,getAnswer: function() {
		if(this.answer != null && this.answer.length > 0) return this.answer[0]; else return "-1";
	}
	,addAnswer: function(a) {
		var current = this.getAnswers();
		if(!com.wiris.util.type.Arrays.containsArray(current,a)) {
			var newa = new Array();
			var i;
			var _g1 = 0, _g = current.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				newa[i1] = current[i1];
			}
			newa[current.length] = a;
			this.setAnswers(newa);
		}
	}
	,setAnswers: function(a) {
		this.answer = a;
	}
	,setAnswer: function(a) {
		this.setAnswers([a]);
	}
	,getCorrectAnswers: function() {
		if(this.correctAnswer != null) return this.correctAnswer; else return new Array();
	}
	,getCorrectAnswer: function() {
		if(this.correctAnswer != null && this.correctAnswer.length > 0) return this.correctAnswer[0]; else return "-1";
	}
	,removeCorrectAnswer: function(ca) {
		if(this.hasCorrectAnswer(ca)) {
			var current = this.getCorrectAnswers();
			var newca = new Array();
			var i;
			var j = 0;
			var _g1 = 0, _g = current.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				if(!(current[i1] == ca)) {
					newca[j] = current[i1];
					j++;
				}
			}
			this.setCorrectAnswers(newca);
		}
	}
	,hasAnswer: function(a) {
		return com.wiris.util.type.Arrays.containsArray(this.getAnswers(),a);
	}
	,hasCorrectAnswer: function(ca) {
		return com.wiris.util.type.Arrays.containsArray(this.getCorrectAnswers(),ca);
	}
	,addCorrectAnswer: function(ca) {
		var current = this.getCorrectAnswers();
		if(!com.wiris.util.type.Arrays.containsArray(current,ca)) {
			var newca = new Array();
			var i;
			var _g1 = 0, _g = current.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				newca[i1] = current[i1];
			}
			newca[current.length] = ca;
			this.setCorrectAnswers(newca);
		}
	}
	,setCorrectAnswers: function(ca) {
		this.correctAnswer = ca;
	}
	,setCorrectAnswer: function(ca) {
		this.setCorrectAnswers([ca]);
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.Assertion();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.Assertion.tagName);
		this.name = s.attributeString(com.wiris.quizzes.impl.Assertion.PARAM_NAME,this.name,null);
		this.correctAnswer = s.attributeStringArray("correctAnswer",this.correctAnswer,["0"]);
		this.answer = s.attributeStringArray("answer",this.answer,["0"]);
		this.parameters = s.serializeArray(this.parameters,com.wiris.quizzes.impl.AssertionParam.TAGNAME);
		s.endTag();
	}
	,parameters: null
	,answer: null
	,correctAnswer: null
	,name: null
	,__class__: com.wiris.quizzes.impl.Assertion
});
com.wiris.quizzes.impl.AssertionCheckImpl = $hxClasses["com.wiris.quizzes.impl.AssertionCheckImpl"] = function() {
	com.wiris.util.xml.SerializableImpl.call(this);
};
com.wiris.quizzes.impl.AssertionCheckImpl.__name__ = ["com","wiris","quizzes","impl","AssertionCheckImpl"];
com.wiris.quizzes.impl.AssertionCheckImpl.__interfaces__ = [com.wiris.quizzes.api.AssertionCheck];
com.wiris.quizzes.impl.AssertionCheckImpl.__super__ = com.wiris.util.xml.SerializableImpl;
com.wiris.quizzes.impl.AssertionCheckImpl.prototype = $extend(com.wiris.util.xml.SerializableImpl.prototype,{
	getValue: function() {
		return this.value;
	}
	,getAssertionName: function() {
		return this.assertion;
	}
	,getAnswers: function() {
		return this.answer;
	}
	,getAnswer: function() {
		return this.answer[0];
	}
	,setAnswers: function(a) {
		this.answer = a;
	}
	,setAnswer: function(a) {
		this.setAnswers([a]);
	}
	,getCorrectAnswers: function() {
		return this.correctAnswer;
	}
	,getCorrectAnswer: function() {
		return this.correctAnswer[0];
	}
	,setCorrectAnswers: function(ca) {
		this.correctAnswer = ca;
	}
	,setCorrectAnswer: function(ca) {
		this.setCorrectAnswers([ca]);
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.AssertionCheckImpl();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.AssertionCheckImpl.tagName);
		this.assertion = s.attributeString("assertion",this.assertion,null);
		this.answer = s.attributeStringArray("answer",this.answer,["0"]);
		this.correctAnswer = s.attributeStringArray("correctAnswer",this.correctAnswer,["0"]);
		this.value = s.floatContent(this.value);
		s.endTag();
	}
	,correctAnswer: null
	,answer: null
	,assertion: null
	,value: null
	,__class__: com.wiris.quizzes.impl.AssertionCheckImpl
});
com.wiris.quizzes.impl.AssertionParam = $hxClasses["com.wiris.quizzes.impl.AssertionParam"] = function() {
	com.wiris.quizzes.impl.MathContent.call(this);
};
com.wiris.quizzes.impl.AssertionParam.__name__ = ["com","wiris","quizzes","impl","AssertionParam"];
com.wiris.quizzes.impl.AssertionParam.__super__ = com.wiris.quizzes.impl.MathContent;
com.wiris.quizzes.impl.AssertionParam.prototype = $extend(com.wiris.quizzes.impl.MathContent.prototype,{
	normalizeContent: function() {
		if(this.name == "name") {
			if(StringTools.startsWith(this.content,"#")) this.content = HxOverrides.substr(this.content,1,null);
		}
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.AssertionParam.TAGNAME);
		this.name = s.attributeString("name",this.name,null);
		com.wiris.quizzes.impl.MathContent.prototype.onSerializeInner.call(this,s);
		s.endTag();
		if(s.getMode() == com.wiris.util.xml.XmlSerializer.MODE_WRITE) this.normalizeContent();
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.AssertionParam();
	}
	,name: null
	,__class__: com.wiris.quizzes.impl.AssertionParam
});
com.wiris.quizzes.impl.AuthorAnswerImpl = $hxClasses["com.wiris.quizzes.impl.AuthorAnswerImpl"] = function() {
	com.wiris.util.xml.SerializableImpl.call(this);
	this.value = new com.wiris.quizzes.impl.CorrectAnswer();
	this.validations = new Array();
};
com.wiris.quizzes.impl.AuthorAnswerImpl.__name__ = ["com","wiris","quizzes","impl","AuthorAnswerImpl"];
com.wiris.quizzes.impl.AuthorAnswerImpl.__interfaces__ = [com.wiris.quizzes.api.AuthorAnswer];
com.wiris.quizzes.impl.AuthorAnswerImpl.newWithQuestionCallback = function(question,slot) {
	var aa = new com.wiris.quizzes.impl.AuthorAnswerImpl();
	aa.question = question;
	aa.slot = slot;
	aa.comparison = com.wiris.quizzes.impl.ComparisonAssertion.getDefaultComparison(slot.getSyntax().getName());
	return aa;
}
com.wiris.quizzes.impl.AuthorAnswerImpl.__super__ = com.wiris.util.xml.SerializableImpl;
com.wiris.quizzes.impl.AuthorAnswerImpl.prototype = $extend(com.wiris.util.xml.SerializableImpl.prototype,{
	importAuthorAnswer: function(authorAnswer) {
		this.id = authorAnswer.id;
		this.value = authorAnswer.value;
		this.comparison = authorAnswer.comparison;
		this.validations = authorAnswer.validations;
		this.question = authorAnswer.question;
		this.slot = authorAnswer.slot;
	}
	,removeValidation: function(validation) {
		if(HxOverrides.remove(this.validations,validation) && this.question != null) this.question.assertionRemoved(validation);
	}
	,getValidation: function(name) {
		var _g = 0, _g1 = this.validations;
		while(_g < _g1.length) {
			var validation = _g1[_g];
			++_g;
			if(validation.getName() == name) return validation;
		}
		return null;
	}
	,addNewValidation: function(name) {
		if(name == null) return null;
		var prev = this.getValidation(name);
		if(prev != null) return prev;
		var v = new com.wiris.quizzes.impl.ValidationAssertion();
		v.setName(name);
		this.validations.push(v);
		if(this.question != null && this.slot != null) this.question.assertionAdded(v,this.id,this.slot.id);
		return v;
	}
	,getValidations: function() {
		var vv = new Array();
		vv = this.validations.slice();
		return vv;
	}
	,getComparison: function() {
		return this.comparison;
	}
	,setComparison: function(name) {
		if(name == null || name == this.comparison.getName()) return this.comparison;
		this.question.id = null;
		this.comparison.setName(name);
		this.comparison.parameters = new Array();
		return this.comparison;
	}
	,setWeight: function(weight) {
		this.value.weight = weight;
	}
	,getWeight: function() {
		return this.value.weight;
	}
	,setValue: function(value) {
		if(value == null || value == this.getValue()) return;
		this.value.set(value);
		this.question.id = null;
	}
	,getFilterableValue: function() {
		return com.wiris.quizzes.impl.QuizzesImpl.getInstance().mathContentToFilterableValue(this.value,this.slot.getInitialContent());
	}
	,getValueAsMathML: function() {
		if(this.value.type == com.wiris.quizzes.impl.MathContent.TYPE_MATHML) return this.value.content; else if(this.value.type == com.wiris.quizzes.impl.MathContent.TYPE_TEXT) {
			var html = new com.wiris.quizzes.impl.HTMLTools();
			return html.textToMathML(this.value.content);
		}
		throw "Type not compatible with MathML";
	}
	,getValue: function() {
		return this.value.content;
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.AuthorAnswerImpl();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.AuthorAnswerImpl.TAGNAME);
		s.attributeString(com.wiris.quizzes.impl.AuthorAnswerImpl.ATTRIBUTE_ID,this.id,"0");
		s.serializeChildName(this.value,com.wiris.quizzes.impl.CorrectAnswer.TAGNAME);
		s.serializeChildName(this.comparison,com.wiris.quizzes.impl.ComparisonAssertion.TAGNAME);
		s.serializeArrayName(this.validations,com.wiris.quizzes.impl.AuthorAnswerImpl.VALIDATIONS_TAGNAME);
		s.endTag();
	}
	,copy: function(model) {
		var aa = model;
		this.setValue(aa.getValue());
		this.comparison.importAssertionNameAndParams(aa.comparison.copy());
		if(this.validations == null) this.validations = new Array();
		while(this.validations.length > 0) this.removeValidation(this.validations[this.validations.length - 1]);
		if(aa.validations != null) {
			var vals = aa.validations;
			var _g = 0;
			while(_g < vals.length) {
				var val = vals[_g];
				++_g;
				var val2 = com.wiris.quizzes.impl.ValidationAssertion.fromAssertion(val);
				this.validations.push(val2);
			}
		}
		return this;
	}
	,slot: null
	,question: null
	,validations: null
	,comparison: null
	,value: null
	,id: null
	,__class__: com.wiris.quizzes.impl.AuthorAnswerImpl
});
haxe.BaseCode = $hxClasses["haxe.BaseCode"] = function(base) {
	var len = base.length;
	var nbits = 1;
	while(len > 1 << nbits) nbits++;
	if(nbits > 8 || len != 1 << nbits) throw "BaseCode : base length must be a power of two.";
	this.base = base;
	this.nbits = nbits;
};
haxe.BaseCode.__name__ = ["haxe","BaseCode"];
haxe.BaseCode.encode = function(s,base) {
	var b = new haxe.BaseCode(haxe.io.Bytes.ofString(base));
	return b.encodeString(s);
}
haxe.BaseCode.decode = function(s,base) {
	var b = new haxe.BaseCode(haxe.io.Bytes.ofString(base));
	return b.decodeString(s);
}
haxe.BaseCode.prototype = {
	decodeString: function(s) {
		return this.decodeBytes(haxe.io.Bytes.ofString(s)).toString();
	}
	,encodeString: function(s) {
		return this.encodeBytes(haxe.io.Bytes.ofString(s)).toString();
	}
	,decodeBytes: function(b) {
		var nbits = this.nbits;
		var base = this.base;
		if(this.tbl == null) this.initTable();
		var tbl = this.tbl;
		var size = b.length * nbits >> 3;
		var out = haxe.io.Bytes.alloc(size);
		var buf = 0;
		var curbits = 0;
		var pin = 0;
		var pout = 0;
		while(pout < size) {
			while(curbits < 8) {
				curbits += nbits;
				buf <<= nbits;
				var i = tbl[b.b[pin++]];
				if(i == -1) throw "BaseCode : invalid encoded char";
				buf |= i;
			}
			curbits -= 8;
			out.b[pout++] = buf >> curbits & 255 & 255;
		}
		return out;
	}
	,initTable: function() {
		var tbl = new Array();
		var _g = 0;
		while(_g < 256) {
			var i = _g++;
			tbl[i] = -1;
		}
		var _g1 = 0, _g = this.base.length;
		while(_g1 < _g) {
			var i = _g1++;
			tbl[this.base.b[i]] = i;
		}
		this.tbl = tbl;
	}
	,encodeBytes: function(b) {
		var nbits = this.nbits;
		var base = this.base;
		var size = b.length * 8 / nbits | 0;
		var out = haxe.io.Bytes.alloc(size + (b.length * 8 % nbits == 0?0:1));
		var buf = 0;
		var curbits = 0;
		var mask = (1 << nbits) - 1;
		var pin = 0;
		var pout = 0;
		while(pout < size) {
			while(curbits < nbits) {
				curbits += 8;
				buf <<= 8;
				buf |= b.b[pin++];
			}
			curbits -= nbits;
			out.b[pout++] = base.b[buf >> curbits & mask] & 255;
		}
		if(curbits > 0) out.b[pout++] = base.b[buf << nbits - curbits & mask] & 255;
		return out;
	}
	,tbl: null
	,nbits: null
	,base: null
	,__class__: haxe.BaseCode
}
com.wiris.quizzes.impl.Base64 = $hxClasses["com.wiris.quizzes.impl.Base64"] = function() {
	haxe.BaseCode.call(this,haxe.io.Bytes.ofString("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"));
};
com.wiris.quizzes.impl.Base64.__name__ = ["com","wiris","quizzes","impl","Base64"];
com.wiris.quizzes.impl.Base64.__super__ = haxe.BaseCode;
com.wiris.quizzes.impl.Base64.prototype = $extend(haxe.BaseCode.prototype,{
	__class__: com.wiris.quizzes.impl.Base64
});
com.wiris.quizzes.impl.CalcDocumentTools = $hxClasses["com.wiris.quizzes.impl.CalcDocumentTools"] = function(calcDocument) {
	if(calcDocument != null) {
		this.calcDocument = com.wiris.util.xml.WXmlUtils.parseXML(calcDocument);
		this.stringCalcDocument = calcDocument;
	}
};
com.wiris.quizzes.impl.CalcDocumentTools.__name__ = ["com","wiris","quizzes","impl","CalcDocumentTools"];
com.wiris.quizzes.impl.CalcDocumentTools.calcSessionLang = function(value) {
	var lang = com.wiris.quizzes.impl.CalcDocumentTools.casSessionLang(value);
	if(lang == null) {
		var start = value.indexOf("<properties");
		var end = value.indexOf("</properties>",start);
		start = value.indexOf("<property name=\"lang\"",start);
		if(end >= start) return null;
		start = value.indexOf(">",start) + 1;
		end = value.indexOf("</property>",start);
		lang = HxOverrides.substr(value,start,end - start);
	}
	return lang;
}
com.wiris.quizzes.impl.CalcDocumentTools.casSessionLang = function(value) {
	var start = value.indexOf("<session");
	if(start == -1) return null;
	var end = value.indexOf(">",start + 1);
	start = value.indexOf("lang",start);
	if(start == -1 || start > end) return null;
	start = value.indexOf("\"",start) + 1;
	return HxOverrides.substr(value,start,2);
}
com.wiris.quizzes.impl.CalcDocumentTools.isCalc = function(session) {
	if(session == null) return false;
	var i = session.indexOf("<wiriscalc");
	if(i > -1) return true;
	var start = session.indexOf("<session");
	if(start == -1) return false;
	var end = session.indexOf(">",start);
	start = session.indexOf("version",start);
	if(start > end) return false;
	start = session.indexOf("\"",start);
	end = session.indexOf("\"",start + 1);
	var version = HxOverrides.substr(session,start + 1,end - start - 1);
	version = HxOverrides.substr(version,0,version.indexOf("."));
	var num = Std.parseInt(version);
	return num >= 3;
}
com.wiris.quizzes.impl.CalcDocumentTools.getCalcSessionTitle = function(calcSession) {
	if(com.wiris.quizzes.impl.CalcDocumentTools.isCalc(calcSession)) {
		var start = calcSession.indexOf("<wiriscalc");
		var end = calcSession.indexOf("</wiriscalc>",start + 1);
		start = calcSession.indexOf("<title",start + 1);
		if(start > -1 && start < end) {
			end = calcSession.indexOf("</title>",start + 1);
			start = calcSession.indexOf("<math",start + 1);
			if(start > -1 && start < end) {
				start = calcSession.indexOf("<mtext",start + 1);
				end = calcSession.indexOf("</mtext>",start + 1);
				if(start > -1 && start < end) {
					start = calcSession.indexOf(">",start + 1) + 1;
					if(start > -1 && start < end) {
						var title = HxOverrides.substr(calcSession,start,end - start);
						return title;
					}
				}
			}
		}
	}
	return null;
}
com.wiris.quizzes.impl.CalcDocumentTools.setCalcSessionTitle = function(calcSession,title) {
	if(com.wiris.quizzes.impl.CalcDocumentTools.isCalc(calcSession)) {
		var start = calcSession.indexOf("<wiriscalc");
		var end = calcSession.indexOf("</wiriscalc>",start + 1);
		start = calcSession.indexOf("<title",start + 1);
		if(start > -1 && start < end) {
			end = calcSession.indexOf("</title>",start + 1);
			start = calcSession.indexOf("<math",start + 1);
			if(start > -1 && start < end) {
				start = calcSession.indexOf("<mtext",start + 1);
				end = calcSession.indexOf("</mtext>",start + 1);
				if(start > -1 && start < end) {
					start = calcSession.indexOf(">",start + 1) + 1;
					if(start > -1 && start < end) {
						var s1 = HxOverrides.substr(calcSession,0,start);
						var s2 = HxOverrides.substr(calcSession,end,null);
						return s1 + title + s2;
					}
				}
			}
		}
	}
	return calcSession;
}
com.wiris.quizzes.impl.CalcDocumentTools.prototype = {
	getPropertiesElement: function() {
		var it = this.getCalcDocumentElement().elements();
		while(it.hasNext()) {
			var elem = it.next();
			if(elem.getNodeName() == "properties") return elem;
		}
		return null;
	}
	,getCalcDocumentElement: function() {
		if(this.calcDocument.nodeType == Xml.Document) {
			this.calcDocument = this.calcDocument.firstElement();
			return this.getCalcDocumentElement();
		}
		if(this.calcDocument.nodeType != Xml.Element || !(this.calcDocument.getNodeName() == "wiriscalc")) throw "This is not a well-formed Calc document!";
		return this.calcDocument;
	}
	,getOption: function(name) {
		var props = this.getPropertiesElement();
		if(props == null) return null;
		var it = props.elements();
		while(it.hasNext()) {
			var prop = it.next();
			if(name == com.wiris.util.xml.WXmlUtils.getAttribute(prop,"name")) return com.wiris.util.xml.WXmlUtils.getInnerText(prop);
		}
		return null;
	}
	,removeOption: function(name) {
		var props = this.getPropertiesElement();
		if(props == null) return this.stringCalcDocument;
		var it = props.elements();
		while(it.hasNext()) {
			var prop = it.next();
			if(name == com.wiris.util.xml.WXmlUtils.getAttribute(prop,"name")) {
				props.removeChild(prop);
				this.stringCalcDocument = com.wiris.util.xml.WXmlUtils.serializeXML(this.calcDocument);
				return this.stringCalcDocument;
			}
		}
		return this.stringCalcDocument;
	}
	,setOption: function(name,value) {
		var props = this.getPropertiesElement();
		if(props == null) {
			var documentElement = this.getCalcDocumentElement();
			props = Xml.createElement("properties");
			documentElement.addChild(props);
		}
		var it = props.elements();
		while(it.hasNext()) {
			var prop = it.next();
			if(name == com.wiris.util.xml.WXmlUtils.getAttribute(prop,"name")) {
				if(value == com.wiris.util.xml.WXmlUtils.getInnerText(prop)) return this.stringCalcDocument;
				prop.removeChild(prop.firstChild());
				prop.addChild(Xml.createPCData(value));
				this.stringCalcDocument = com.wiris.util.xml.WXmlUtils.serializeXML(this.calcDocument);
				return this.stringCalcDocument;
			}
		}
		var prop2 = Xml.createElement("property");
		com.wiris.util.xml.WXmlUtils.setAttribute(prop2,"name",name);
		props.addChild(prop2);
		prop2.addChild(Xml.createPCData(value));
		this.stringCalcDocument = com.wiris.util.xml.WXmlUtils.serializeXML(this.calcDocument);
		return this.stringCalcDocument;
	}
	,getVersion: function() {
		return com.wiris.util.xml.WXmlUtils.getAttribute(this.getCalcDocumentElement(),"version");
	}
	,hasQuizzesQuestionOptions: function() {
		return this.calcDocument != null && com.wiris.util.type.StringUtils.compareVersions(this.getVersion(),"3.2") >= 0 && this.getOption(com.wiris.quizzes.impl.CalcDocumentTools.QUIZZES_QUESTION_OPTIONS) != null && this.getOption(com.wiris.quizzes.impl.CalcDocumentTools.QUIZZES_QUESTION_OPTIONS) == "true";
	}
	,stringCalcDocument: null
	,calcDocument: null
	,__class__: com.wiris.quizzes.impl.CalcDocumentTools
}
com.wiris.quizzes.impl.ClasspathLoader = $hxClasses["com.wiris.quizzes.impl.ClasspathLoader"] = function() { }
com.wiris.quizzes.impl.ClasspathLoader.__name__ = ["com","wiris","quizzes","impl","ClasspathLoader"];
com.wiris.quizzes.impl.ClasspathLoader.load = function(classpath) {
}
com.wiris.quizzes.impl.ClasspathLoader.loadImpl = function(classpath) {
}
com.wiris.quizzes.impl.ClasspathLoader.registerClass = function(path,file) {
}
com.wiris.quizzes.impl.ComparisonAssertion = $hxClasses["com.wiris.quizzes.impl.ComparisonAssertion"] = function() {
	com.wiris.quizzes.impl.Assertion.call(this);
};
com.wiris.quizzes.impl.ComparisonAssertion.__name__ = ["com","wiris","quizzes","impl","ComparisonAssertion"];
com.wiris.quizzes.impl.ComparisonAssertion.__interfaces__ = [com.wiris.quizzes.api.assertion.Comparison];
com.wiris.quizzes.impl.ComparisonAssertion.fromAssertion = function(a) {
	var c = new com.wiris.quizzes.impl.ComparisonAssertion();
	c.correctAnswer = a.correctAnswer;
	c.answer = a.answer;
	c.parameters = a.parameters;
	c.name = com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonName2String(com.wiris.quizzes.impl.QuizzesEnumUtils.string2ComparisonName(a.name));
	return c;
}
com.wiris.quizzes.impl.ComparisonAssertion.getDefaultComparison = function(syntaxName) {
	var c = new com.wiris.quizzes.impl.ComparisonAssertion();
	var name;
	if(syntaxName == com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC) name = com.wiris.quizzes.impl.ComparisonAssertion.DEFAULT_COMPARISON_GRAPHIC; else if(syntaxName == com.wiris.quizzes.api.assertion.SyntaxName.STRING) name = com.wiris.quizzes.impl.ComparisonAssertion.DEFAULT_COMPARISON_STRING; else name = com.wiris.quizzes.impl.ComparisonAssertion.DEFAULT_COMPARISON_MATH;
	c.setName(name);
	return c;
}
com.wiris.quizzes.impl.ComparisonAssertion.__super__ = com.wiris.quizzes.impl.Assertion;
com.wiris.quizzes.impl.ComparisonAssertion.prototype = $extend(com.wiris.quizzes.impl.Assertion.prototype,{
	removeParameter: function(name) {
		var value = this.getParameter(name);
		this.removeParam(com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonParameterName2String(name));
		return value;
	}
	,getParameter: function(name) {
		return this.getParam(com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonParameterName2String(name));
	}
	,setParameter: function(name,value) {
		this.setParam(com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonParameterName2String(name),value);
	}
	,getName: function() {
		return com.wiris.quizzes.impl.QuizzesEnumUtils.string2ComparisonName(this.name);
	}
	,setName: function(name) {
		this.name = com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonName2String(name);
	}
	,__class__: com.wiris.quizzes.impl.ComparisonAssertion
});
com.wiris.quizzes.impl.CompoundAnswerParser = $hxClasses["com.wiris.quizzes.impl.CompoundAnswerParser"] = function() { }
com.wiris.quizzes.impl.CompoundAnswerParser.__name__ = ["com","wiris","quizzes","impl","CompoundAnswerParser"];
com.wiris.quizzes.impl.CompoundAnswerParser.parseCompoundAnswer = function(math) {
	if(math == null || math.content == null) return new Array();
	if("text" == math.type) return com.wiris.quizzes.impl.CompoundAnswerParser.parseCompoundAnswerText(math.content); else if("mathml" == math.type) return com.wiris.quizzes.impl.CompoundAnswerParser.parseCompoundAnswerMathML(math.content); else return new Array();
}
com.wiris.quizzes.impl.CompoundAnswerParser.parseCompoundAnswerText = function(correctAnswer) {
	var answers = new Array();
	var lines = correctAnswer.split("\n");
	var i;
	var _g1 = 0, _g = lines.length;
	while(_g1 < _g) {
		var i1 = _g1++;
		var line = lines[i1];
		var p = line.indexOf("=");
		if(p != -1) {
			var label = HxOverrides.substr(line,0,p + 1);
			var value = StringTools.trim(HxOverrides.substr(line,p + 1,null));
			answers.push([label,value]);
		}
	}
	return answers;
}
com.wiris.quizzes.impl.CompoundAnswerParser.parseCompoundAnswerMathML = function(correctAnswer) {
	var answers = new Array();
	var newline = "<mspace linebreak=\"newline\"/>";
	var equal = "<mo>=</mo>";
	var mml = com.wiris.util.xml.MathMLUtils.convertEditor2Newlines(correctAnswer);
	var s = com.wiris.util.xml.MathMLUtils.splitRootTag(mml,"math");
	mml = com.wiris.util.xml.MathMLUtils.stripRootTag(s[1],"mrow");
	var lines = new Array();
	var start = 0;
	var end = 0;
	do {
		end = mml.indexOf(newline,start);
		var line = end > -1?HxOverrides.substr(mml,start,end - start):HxOverrides.substr(mml,start,null);
		if(lines.length > 0 && line.indexOf("<mo>=</mo>") == -1) {
			var lastElem = lines[lines.length - 1] + newline + line;
			lines[lines.length - 1] = lastElem;
		} else lines.push(line);
		start = end + newline.length;
	} while(end != -1);
	var i;
	var _g1 = 0, _g = lines.length;
	while(_g1 < _g) {
		var i1 = _g1++;
		var line = com.wiris.util.xml.MathMLUtils.stripRootTag(lines[i1],"mrow");
		var equalIndex = line.indexOf(equal);
		if(equalIndex != -1) {
			equalIndex += equal.length;
			var label = s[0] + HxOverrides.substr(line,0,equalIndex) + s[2];
			var value = HxOverrides.substr(line,equalIndex,null);
			var a = value.indexOf("<annotation encoding=\"text/plain\">");
			if(a != -1) {
				a = value.indexOf(">",a) + 1;
				var b = value.indexOf("</annotation>",a);
				value = HxOverrides.substr(value,a,b - a);
			} else value = s[0] + value + s[2];
			var answer = [label,value];
			answers.push(answer);
		}
	}
	return answers;
}
com.wiris.quizzes.impl.CompoundAnswerParser.compoundAnswerIsEquality = function(compoundAnswer) {
	if(compoundAnswer.length == 1) {
		var lhs = com.wiris.util.xml.MathMLUtils.mathMLToText(compoundAnswer[0][0]);
		return com.wiris.util.type.StringUtils.contains(lhs,"+") || com.wiris.util.type.StringUtils.contains(lhs,"*") || com.wiris.util.type.StringUtils.contains(lhs,"/") || lhs.indexOf("-") != lhs.lastIndexOf("-") || lhs == "y=" || lhs == "x=";
	} else return false;
}
com.wiris.quizzes.impl.CompoundAnswerParser.joinCompoundAnswer = function(answers) {
	var sb = new StringBuf();
	var m = new com.wiris.quizzes.impl.MathContent();
	if(answers.length > 0) {
		var mml = com.wiris.quizzes.impl.MathContent.getMathType(answers[0][0]) == com.wiris.quizzes.impl.MathContent.TYPE_MATHML;
		m.type = mml?com.wiris.quizzes.impl.MathContent.TYPE_MATHML:com.wiris.quizzes.impl.MathContent.TYPE_TEXT;
		var root = "<math>";
		var i;
		var _g1 = 0, _g = answers.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(i1 != 0) sb.b += Std.string(mml?"<mspace linebreak=\"newline\"/>":"\n");
			var ans = answers[i1];
			var s = com.wiris.util.xml.MathMLUtils.splitRootTag(ans[0],"math");
			sb.b += Std.string(s[1]);
			root = com.wiris.quizzes.impl.CompoundAnswerParser.combineTagAtts(root,s[0]);
			s = com.wiris.util.xml.MathMLUtils.splitRootTag(ans[1],"math");
			sb.b += Std.string(s[1]);
			root = com.wiris.quizzes.impl.CompoundAnswerParser.combineTagAtts(root,s[0]);
		}
		m.content = sb.b;
		if(mml) m.content = root + m.content + "</math>";
	} else m.set("");
	return m;
}
com.wiris.quizzes.impl.CompoundAnswerParser.combineTagAtts = function(t1,t2) {
	var p1 = t1.indexOf(" ");
	var p2 = t2.indexOf(" ");
	if(p1 == -1) return t2;
	if(p2 == -1) return t1;
	t1 = HxOverrides.substr(t1,0,t1.length - 1);
	t2 = HxOverrides.substr(t2,0,t2.length - 1);
	t2 = HxOverrides.substr(t2,p2 + 1,null);
	var atts = t2.split(" ");
	var i = 0;
	var _g1 = 0, _g = atts.length;
	while(_g1 < _g) {
		var i1 = _g1++;
		if(t1.indexOf(atts[i1]) == -1) t1 = t1 + " " + atts[i1];
	}
	t1 = t1 + ">";
	return t1;
}
com.wiris.quizzes.impl.CompoundAnswerParser.getCompoundInitialContent = function(correctAnswer,previousInitialContent,mathml) {
	var content = new com.wiris.quizzes.impl.MathContent();
	content.set(correctAnswer);
	var compoundModel = com.wiris.quizzes.impl.CompoundAnswerParser.parseCompoundAnswer(content);
	content.set(previousInitialContent);
	var compoundInitialContent = com.wiris.quizzes.impl.CompoundAnswerParser.parseCompoundAnswer(content);
	var i = 0;
	while(i < compoundModel.length) {
		if(i >= compoundInitialContent.length) {
			var part = new Array();
			part[0] = compoundModel[i][0];
			part[1] = "";
			compoundInitialContent.push(part);
		} else {
			compoundInitialContent[i][0] = compoundModel[i][0];
			if(mathml && com.wiris.quizzes.impl.MathContent.getMathType(compoundInitialContent[i][1]) == com.wiris.quizzes.impl.MathContent.TYPE_TEXT) {
				var tools = new com.wiris.quizzes.impl.HTMLTools();
				compoundInitialContent[i][1] = tools.textToMathML(compoundInitialContent[i][1]);
			}
		}
		i++;
	}
	while(i < compoundInitialContent.length) compoundInitialContent.pop();
	return com.wiris.quizzes.impl.CompoundAnswerParser.joinCompoundAnswer(compoundInitialContent).content;
}
com.wiris.quizzes.impl.ConfigurationImpl = $hxClasses["com.wiris.quizzes.impl.ConfigurationImpl"] = function() {
	this.properties = new Hash();
	this.set(com.wiris.quizzes.api.ConfigurationKeys.WIRIS_URL,com.wiris.quizzes.impl.ConfigurationImpl.DEF_WIRIS_URL);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.CALC_URL,com.wiris.quizzes.impl.ConfigurationImpl.DEF_CALC_URL);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.EDITOR_URL,com.wiris.quizzes.impl.ConfigurationImpl.DEF_EDITOR_URL);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.HAND_URL,com.wiris.quizzes.impl.ConfigurationImpl.DEF_HAND_URL);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.SERVICE_URL,com.wiris.quizzes.impl.ConfigurationImpl.DEF_SERVICE_URL);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.PROXY_URL,com.wiris.quizzes.impl.ConfigurationImpl.DEF_PROXY_URL);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.CACHE_DIR,com.wiris.quizzes.impl.ConfigurationImpl.DEF_CACHE_DIR);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.MAXCONNECTIONS,com.wiris.quizzes.impl.ConfigurationImpl.DEF_MAXCONNECTIONS);
	this.set(com.wiris.quizzes.impl.ConfigurationImpl.CONFIG_FILE,com.wiris.quizzes.impl.ConfigurationImpl.DEF_CONFIG_FILE);
	this.set(com.wiris.quizzes.impl.ConfigurationImpl.CONFIG_CLASS,com.wiris.quizzes.impl.ConfigurationImpl.DEF_CONFIG_CLASS);
	this.set(com.wiris.quizzes.impl.ConfigurationImpl.CONFIG_CLASSPATH,com.wiris.quizzes.impl.ConfigurationImpl.DEF_CONFIG_CLASSPATH);
	this.set(com.wiris.quizzes.impl.ConfigurationImpl.IMAGESCACHE_CLASS,com.wiris.quizzes.impl.ConfigurationImpl.DEF_IMAGESCACHE_CLASS);
	this.set(com.wiris.quizzes.impl.ConfigurationImpl.VARIABLESCACHE_CLASS,com.wiris.quizzes.impl.ConfigurationImpl.DEF_VARIABLESCACHE_CLASS);
	this.set(com.wiris.quizzes.impl.ConfigurationImpl.LOCKPROVIDER_CLASS,com.wiris.quizzes.impl.ConfigurationImpl.DEF_LOCKPROVIDER_CLASS);
	this.set(com.wiris.quizzes.impl.ConfigurationImpl.ACCESSPROVIDER_CLASS,com.wiris.quizzes.impl.ConfigurationImpl.DEF_ACCESSPROVIDER_CLASS);
	this.set(com.wiris.quizzes.impl.ConfigurationImpl.ACCESSPROVIDER_CLASSPATH,com.wiris.quizzes.impl.ConfigurationImpl.DEF_ACCESSPROVIDER_CLASSPATH);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.HTTPPROXY_HOST,com.wiris.quizzes.impl.ConfigurationImpl.DEF_HTTPPROXY_HOST);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.HTTPPROXY_PORT,com.wiris.quizzes.impl.ConfigurationImpl.DEF_HTTPPROXY_PORT);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.HTTPPROXY_USER,com.wiris.quizzes.impl.ConfigurationImpl.DEF_HTTPPROXY_USER);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.HTTPPROXY_PASS,com.wiris.quizzes.impl.ConfigurationImpl.DEF_HTTPPROXY_PASS);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.REFERER_URL,com.wiris.quizzes.impl.ConfigurationImpl.DEF_REFERER_URL);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.HAND_ENABLED,com.wiris.quizzes.impl.ConfigurationImpl.DEF_HAND_ENABLED);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.CALC_ENABLED,com.wiris.quizzes.impl.ConfigurationImpl.DEF_CALC_ENABLED);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.SERVICE_OFFLINE,com.wiris.quizzes.impl.ConfigurationImpl.DEF_SERVICE_OFFLINE);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.HAND_LOGTRACES,com.wiris.quizzes.impl.ConfigurationImpl.DEF_HAND_LOGTRACES);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.WIRISLAUNCHER_URL,com.wiris.quizzes.impl.ConfigurationImpl.DEF_WIRISLAUNCHER_URL);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.CROSSORIGINCALLS_ENABLED,com.wiris.quizzes.impl.ConfigurationImpl.DEF_CROSSORIGINCALLS_ENABLED);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.RESOURCES_STATIC,com.wiris.quizzes.impl.ConfigurationImpl.DEF_RESOURCES_STATIC);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.GRAPH_URL,com.wiris.quizzes.impl.ConfigurationImpl.DEF_GRAPH_URL);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.VERSION,com.wiris.quizzes.impl.ConfigurationImpl.DEF_VERSION);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.DEPLOYMENT_ID,com.wiris.quizzes.impl.ConfigurationImpl.DEF_DEPLOYMENT_ID);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.LICENSE_ID,com.wiris.quizzes.impl.ConfigurationImpl.DEF_LICENSE_ID);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.TELEMETRY_URL,com.wiris.quizzes.impl.ConfigurationImpl.DEF_TELEMETRY_URL);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.TELEMETRY_TOKEN,com.wiris.quizzes.impl.ConfigurationImpl.DEF_TELEMETRY_TOKEN);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.QUIZZES_LOGGING_LEVEL,com.wiris.quizzes.impl.ConfigurationImpl.DEF_QUIZZES_LOGGING_LEVEL);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.QUIZZES_TRACKING_ENABLED,com.wiris.quizzes.impl.ConfigurationImpl.DEF_QUIZZES_TRACKING_ENABLED);
	this.set(com.wiris.quizzes.api.ConfigurationKeys.GRAPH_TRACK_INSTANCES,com.wiris.quizzes.impl.ConfigurationImpl.DEF_GRAPH_TRACK_INSTANCES);
	if(!com.wiris.settings.PlatformSettings.IS_JAVASCRIPT) {
		try {
			var s = com.wiris.system.Storage.newStorage(com.wiris.quizzes.impl.ConfigurationImpl.DEF_DIST_CONFIG_FILE);
			if(!s.exists()) s = com.wiris.system.Storage.newResourceStorage(com.wiris.quizzes.impl.ConfigurationImpl.DEF_DIST_CONFIG_FILE);
			var content = s.read();
			var ini = com.wiris.util.sys.IniFile.newIniFileFromString(content);
			this.setAll(ini.getProperties());
		} catch( e ) {
			throw "Could not read the configuration file \"" + com.wiris.quizzes.impl.ConfigurationImpl.DEF_DIST_CONFIG_FILE + "\".";
		}
		var classpath = this.get(com.wiris.quizzes.impl.ConfigurationImpl.CONFIG_CLASSPATH);
		if(!(classpath == "")) com.wiris.quizzes.impl.ClasspathLoader.load(classpath);
		var className = this.get(com.wiris.quizzes.impl.ConfigurationImpl.CONFIG_CLASS);
		if(!(className == "")) try {
			var config = Type.createInstance(Type.resolveClass(className),new Array());
			var keys = [com.wiris.quizzes.api.ConfigurationKeys.WIRIS_URL,com.wiris.quizzes.api.ConfigurationKeys.WIRISLAUNCHER_URL,com.wiris.quizzes.api.ConfigurationKeys.CALC_URL,com.wiris.quizzes.api.ConfigurationKeys.EDITOR_URL,com.wiris.quizzes.api.ConfigurationKeys.HAND_URL,com.wiris.quizzes.api.ConfigurationKeys.SERVICE_URL,com.wiris.quizzes.api.ConfigurationKeys.PROXY_URL,com.wiris.quizzes.api.ConfigurationKeys.CACHE_DIR,com.wiris.quizzes.api.ConfigurationKeys.MAXCONNECTIONS,com.wiris.quizzes.api.ConfigurationKeys.HTTPPROXY_HOST,com.wiris.quizzes.api.ConfigurationKeys.HTTPPROXY_PORT,com.wiris.quizzes.api.ConfigurationKeys.HTTPPROXY_USER,com.wiris.quizzes.api.ConfigurationKeys.HTTPPROXY_PASS,com.wiris.quizzes.api.ConfigurationKeys.REFERER_URL,com.wiris.quizzes.api.ConfigurationKeys.HAND_ENABLED,com.wiris.quizzes.api.ConfigurationKeys.CALC_ENABLED,com.wiris.quizzes.api.ConfigurationKeys.HAND_LOGTRACES,com.wiris.quizzes.api.ConfigurationKeys.SERVICE_OFFLINE,com.wiris.quizzes.api.ConfigurationKeys.CROSSORIGINCALLS_ENABLED,com.wiris.quizzes.api.ConfigurationKeys.RESOURCES_STATIC,com.wiris.quizzes.api.ConfigurationKeys.RESOURCES_URL,com.wiris.quizzes.api.ConfigurationKeys.GRAPH_URL,com.wiris.quizzes.api.ConfigurationKeys.DEPLOYMENT_ID,com.wiris.quizzes.api.ConfigurationKeys.LICENSE_ID,com.wiris.quizzes.impl.ConfigurationImpl.IMAGESCACHE_CLASS,com.wiris.quizzes.impl.ConfigurationImpl.VARIABLESCACHE_CLASS,com.wiris.quizzes.impl.ConfigurationImpl.LOCKPROVIDER_CLASS,com.wiris.quizzes.impl.ConfigurationImpl.ACCESSPROVIDER_CLASS];
			var i;
			var _g1 = 0, _g = keys.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var value = config.get(keys[i1]);
				if(value != null) this.set(keys[i1],value);
			}
		} catch( e ) {
			throw "Could not find the Configuration class \"" + className + "\".";
		}
		var file = this.properties.get(com.wiris.quizzes.impl.ConfigurationImpl.CONFIG_FILE);
		if(com.wiris.system.Storage.newStorage(file).exists() || com.wiris.system.Storage.newResourceStorage(file).exists()) try {
			var ini = com.wiris.util.sys.IniFile.newIniFileFromFilename(file);
			this.setAll(ini.getProperties());
		} catch( e ) {
			throw "Could not read configuration file \"" + file + "\".";
		}
		var vs = com.wiris.system.Storage.newResourceStorage(com.wiris.quizzes.impl.ConfigurationImpl.DEF_VERSION_FILE);
		if(vs.exists()) {
			var version = vs.read();
			this.set(com.wiris.quizzes.api.ConfigurationKeys.VERSION,version);
		}
	}
};
com.wiris.quizzes.impl.ConfigurationImpl.__name__ = ["com","wiris","quizzes","impl","ConfigurationImpl"];
com.wiris.quizzes.impl.ConfigurationImpl.__interfaces__ = [com.wiris.quizzes.api.Configuration];
com.wiris.quizzes.impl.ConfigurationImpl.getInstance = function() {
	if(com.wiris.quizzes.impl.ConfigurationImpl.config == null) com.wiris.quizzes.impl.ConfigurationImpl.config = new com.wiris.quizzes.impl.ConfigurationImpl();
	return com.wiris.quizzes.impl.ConfigurationImpl.config;
}
com.wiris.quizzes.impl.ConfigurationImpl.getUrlKeys = function() {
	var urls = [com.wiris.quizzes.api.ConfigurationKeys.WIRIS_URL,com.wiris.quizzes.api.ConfigurationKeys.EDITOR_URL,com.wiris.quizzes.api.ConfigurationKeys.SERVICE_URL,com.wiris.quizzes.api.ConfigurationKeys.PROXY_URL,com.wiris.quizzes.api.ConfigurationKeys.HAND_URL,com.wiris.quizzes.api.ConfigurationKeys.RESOURCES_URL,com.wiris.quizzes.api.ConfigurationKeys.WIRISLAUNCHER_URL,com.wiris.quizzes.api.ConfigurationKeys.CALC_URL,com.wiris.quizzes.api.ConfigurationKeys.GRAPH_URL];
	return urls;
}
com.wiris.quizzes.impl.ConfigurationImpl.setIsHttps = function(https) {
	com.wiris.quizzes.impl.ConfigurationImpl.isHttps = https;
}
com.wiris.quizzes.impl.ConfigurationImpl.prototype = {
	setHttps: function(url) {
		var newUrl = url;
		if(StringTools.startsWith(url,"http://")) newUrl = "https://" + HxOverrides.substr(url,7,null);
		return newUrl;
	}
	,jsEscape: function(text) {
		text = StringTools.replace(text,"\\","\\\\");
		text = StringTools.replace(text,"\"","\\\"");
		text = StringTools.replace(text,"\n","\\n");
		text = StringTools.replace(text,"\r","\\r");
		text = StringTools.replace(text,"\t","\\t");
		return text;
	}
	,getJSConfig: function() {
		var sb = new StringBuf();
		var prefix = "com.wiris.quizzes.impl.ConfigurationImpl.";
		sb.b += Std.string(prefix + "DEF_WIRIS_URL" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.WIRIS_URL)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_CALC_URL" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.CALC_URL)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_EDITOR_URL" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.EDITOR_URL)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_HAND_URL" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.HAND_URL)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_SERVICE_URL" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.SERVICE_URL)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_PROXY_URL" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.PROXY_URL)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_CACHE_DIR" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.CACHE_DIR)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_MAXCONNECTIONS" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.MAXCONNECTIONS)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_HAND_ENABLED" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.HAND_ENABLED)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_CALC_ENABLED" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.CALC_ENABLED)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_SERVICE_OFFLINE" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.SERVICE_OFFLINE)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_WIRISLAUNCHER_URL" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.WIRISLAUNCHER_URL)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_CROSSORIGINCALLS_ENABLED" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.CROSSORIGINCALLS_ENABLED)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_RESOURCES_STATIC" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.RESOURCES_STATIC)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_HAND_LOGTRACES" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.HAND_LOGTRACES)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_GRAPH_URL" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.GRAPH_URL)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_VERSION" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.VERSION)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_DEPLOYMENT_ID" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.DEPLOYMENT_ID)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_LICENSE_ID" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.LICENSE_ID)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_TELEMETRY_URL" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.TELEMETRY_URL)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_TELEMETRY_TOKEN" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.TELEMETRY_TOKEN)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_QUIZZES_LOGGING_LEVEL" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.QUIZZES_LOGGING_LEVEL)) + "\";\n");
		sb.b += Std.string(prefix + "DEF_QUIZZES_TRACKING_ENABLED" + " = \"" + this.jsEscape(this.get(com.wiris.quizzes.api.ConfigurationKeys.QUIZZES_TRACKING_ENABLED)) + "\";\n");
		return sb.b;
	}
	,set: function(key,value) {
		if(com.wiris.quizzes.impl.ConfigurationImpl.isHttps) {
			var urls = com.wiris.quizzes.impl.ConfigurationImpl.getUrlKeys();
			if(com.wiris.util.type.Arrays.containsArray(urls,key)) value = this.setHttps(value);
		}
		this.properties.set(key,value);
	}
	,get: function(key) {
		return this.properties.get(key);
	}
	,setAll: function(props) {
		var it = props.keys();
		while(it.hasNext()) {
			var key = it.next();
			this.set(key,props.get(key));
		}
	}
	,loadFile: function(file) {
		var ini = com.wiris.util.sys.IniFile.newIniFileFromFilename(file);
		this.setAll(ini.getProperties());
	}
	,load: function(text) {
		var ini = com.wiris.util.sys.IniFile.newIniFileFromString(text);
		this.setAll(ini.getProperties());
	}
	,properties: null
	,__class__: com.wiris.quizzes.impl.ConfigurationImpl
}
com.wiris.quizzes.impl.CorrectAnswer = $hxClasses["com.wiris.quizzes.impl.CorrectAnswer"] = function() {
	com.wiris.quizzes.impl.MathContent.call(this);
	this.weight = 1.0;
	this.id = "0";
};
com.wiris.quizzes.impl.CorrectAnswer.__name__ = ["com","wiris","quizzes","impl","CorrectAnswer"];
com.wiris.quizzes.impl.CorrectAnswer.__super__ = com.wiris.quizzes.impl.MathContent;
com.wiris.quizzes.impl.CorrectAnswer.prototype = $extend(com.wiris.quizzes.impl.MathContent.prototype,{
	onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.CorrectAnswer.TAGNAME);
		this.id = s.attributeString("id",this.id,"0");
		this.weight = s.attributeFloat("weight",this.weight,1.0);
		this.reference = s.attributeString("ref",this.reference,null);
		com.wiris.quizzes.impl.MathContent.prototype.onSerializeInner.call(this,s);
		s.endTag();
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.CorrectAnswer();
	}
	,reference: null
	,id: null
	,weight: null
	,__class__: com.wiris.quizzes.impl.CorrectAnswer
});
com.wiris.quizzes.impl.EmbeddedAnswerFilter = $hxClasses["com.wiris.quizzes.impl.EmbeddedAnswerFilter"] = function() { }
com.wiris.quizzes.impl.EmbeddedAnswerFilter.__name__ = ["com","wiris","quizzes","impl","EmbeddedAnswerFilter"];
com.wiris.quizzes.impl.EmbeddedAnswerFilter.filterHTML = function(html,mode,q,qi) {
	if(html == null || html == "") return "";
	var regexp = new EReg("<(input|img|span)[^>]*(wrsUI_quizzesEmbeddedAuthoringField|wirisauthoringfield|wirisembeddedauthoringfield|wirisanswerfield)[^>]*(\\/>|>[^<]*<\\/(input|img|span)>)","gm");
	html = regexp.replace(html,"<<wirisembeddedanswerfield>>");
	var i = 0;
	var start = 0;
	var pos;
	var sb = new StringBuf();
	while((pos = html.indexOf("<<wirisembeddedanswerfield>>",start)) != -1) {
		sb.b += Std.string(HxOverrides.substr(html,start,pos - start));
		if(mode == com.wiris.quizzes.api.ui.EmbeddedAnswersEditorMode.AUTHORING) {
			var value = q.getCorrectAnswer(i);
			sb.b += Std.string("<input type=\"hidden\" class=\"wirisembeddedauthoringfield\" value=\"" + com.wiris.util.xml.WXmlUtils.htmlEscape(value) + "\" data-answer-index=\"" + i + "\" />");
		} else if(mode == com.wiris.quizzes.api.ui.EmbeddedAnswersEditorMode.DELIVERY) sb.b += Std.string("<input type=\"hidden\" class=\"wirisanswerfield wirisembedded\" value=\"\" />"); else if(mode == com.wiris.quizzes.api.ui.EmbeddedAnswersEditorMode.REVIEW) {
			var value = qi.getStudentAnswer(i);
			if(value == null) value = "";
			sb.b += Std.string("<input type=\"hidden\" class=\"wirisanswerfield wirisembedded wirisembeddedfeedback wirisassertionsfeedback wiriscorrectfeedback\" value=\"" + com.wiris.util.xml.WXmlUtils.htmlEscape(value) + "\" />");
		}
		i++;
		start = pos + 28;
	}
	sb.b += Std.string(HxOverrides.substr(html,start,null));
	return sb.b;
}
com.wiris.quizzes.impl.EmbeddedAnswersEditorImpl = $hxClasses["com.wiris.quizzes.impl.EmbeddedAnswersEditorImpl"] = function(question,instance) {
	this.question = question;
	this.instance = instance;
};
com.wiris.quizzes.impl.EmbeddedAnswersEditorImpl.__name__ = ["com","wiris","quizzes","impl","EmbeddedAnswersEditorImpl"];
com.wiris.quizzes.impl.EmbeddedAnswersEditorImpl.__interfaces__ = [com.wiris.quizzes.api.ui.EmbeddedAnswersEditor];
com.wiris.quizzes.impl.EmbeddedAnswersEditorImpl.prototype = {
	setReadOnly: function(readOnly) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,setStyle: function(key,value) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,showAnswerFieldPlainText: function(visible) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,showAnswerFieldPopupEditor: function(visible) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,showAnswerFieldInlineEditor: function(visible) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,getElement: function() {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
		return null;
	}
	,addQuizzesFieldListener: function(listener) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,setValue: function(value) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,getValue: function() {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
		return null;
	}
	,showGraphicSyntax: function(visible) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,showGradingFunction: function(visible) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,showAuxiliaryTextInput: function(visible) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,showAuxiliaryCasReplaceEditor: function(visible) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,showAuxiliaryCas: function(visible) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,showAuxiliarTextInput: function(visible) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,showAuxiliarCasReplaceEditor: function(visible) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,showAuxiliarCas: function(visible) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,showCorrectAnswer: function(visible) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,showGradingCriteria: function(visible) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,showVariablesDefinition: function(visible) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,showPreviewTab: function(visible) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,showVariablesTab: function(visible) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,showValidationTab: function(visible) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,showCorrectAnswerTab: function(visible) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,setConfiguration: function(configuration) {
	}
	,getFieldType: function() {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
		return com.wiris.quizzes.api.ui.AuthoringFieldType.EMBEDDED_ANSWERS_EDITOR;
	}
	,setFieldType: function(type) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,setEditableElement: function(element) {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,newEmbeddedAuthoringElement: function() {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
		return null;
	}
	,filterHTML: function(questionText,mode) {
		var q = this.question.getImpl();
		var qi = this.instance;
		return com.wiris.quizzes.impl.EmbeddedAnswerFilter.filterHTML(questionText,mode,q,qi);
	}
	,analyzeHTML: function() {
		com.wiris.quizzes.impl.QuizzesComponentBuilderImpl.throwNotImplementedInServerTechnology();
	}
	,instance: null
	,question: null
	,__class__: com.wiris.quizzes.impl.EmbeddedAnswersEditorImpl
}
if(!com.wiris.util.sys) com.wiris.util.sys = {}
com.wiris.util.sys.LockProvider = $hxClasses["com.wiris.util.sys.LockProvider"] = function() { }
com.wiris.util.sys.LockProvider.__name__ = ["com","wiris","util","sys","LockProvider"];
com.wiris.util.sys.LockProvider.prototype = {
	getLock: null
	,__class__: com.wiris.util.sys.LockProvider
}
com.wiris.quizzes.impl.FileLockProvider = $hxClasses["com.wiris.quizzes.impl.FileLockProvider"] = function(basedir) {
	this.basedir = com.wiris.system.Storage.newStorage(basedir);
};
com.wiris.quizzes.impl.FileLockProvider.__name__ = ["com","wiris","quizzes","impl","FileLockProvider"];
com.wiris.quizzes.impl.FileLockProvider.__interfaces__ = [com.wiris.util.sys.LockProvider];
com.wiris.quizzes.impl.FileLockProvider.prototype = {
	getLock: function(id) {
		var filename = com.wiris.system.Storage.newStorageWithParent(this.basedir,id).toString();
		return new com.wiris.quizzes.impl.FileLockWrapper(com.wiris.system.FileLock.getLock(filename,com.wiris.quizzes.impl.FileLockProvider.WAIT,com.wiris.quizzes.impl.FileLockProvider.TIMEOUT));
	}
	,basedir: null
	,__class__: com.wiris.quizzes.impl.FileLockProvider
}
com.wiris.util.sys.Lock = $hxClasses["com.wiris.util.sys.Lock"] = function() { }
com.wiris.util.sys.Lock.__name__ = ["com","wiris","util","sys","Lock"];
com.wiris.util.sys.Lock.prototype = {
	release: null
	,__class__: com.wiris.util.sys.Lock
}
com.wiris.quizzes.impl.FileLockWrapper = $hxClasses["com.wiris.quizzes.impl.FileLockWrapper"] = function(fl) {
	this.fl = fl;
};
com.wiris.quizzes.impl.FileLockWrapper.__name__ = ["com","wiris","quizzes","impl","FileLockWrapper"];
com.wiris.quizzes.impl.FileLockWrapper.__interfaces__ = [com.wiris.util.sys.Lock];
com.wiris.quizzes.impl.FileLockWrapper.prototype = {
	release: function() {
		this.fl.release();
	}
	,fl: null
	,__class__: com.wiris.quizzes.impl.FileLockWrapper
}
com.wiris.quizzes.impl.HTML = $hxClasses["com.wiris.quizzes.impl.HTML"] = function() {
	this.s = new StringBuf();
	this.tags = new Array();
};
com.wiris.quizzes.impl.HTML.__name__ = ["com","wiris","quizzes","impl","HTML"];
com.wiris.quizzes.impl.HTML.prototype = {
	openTd: function(className) {
		this.open("td",[["class",className]]);
	}
	,openTr: function(className) {
		this.open("tr",[["class",className]]);
	}
	,openTable: function(id,className) {
		this.open("table",[["id",id],["class",className]]);
	}
	,jsComponent: function(id,className,arg) {
		this.input("hidden",id,null,arg,null,"wirisjscomponent " + className);
	}
	,dd: function(text) {
		this.open("dd",null);
		this.text(text);
		this.close();
	}
	,dt: function(text) {
		this.open("dt",null);
		this.text(text);
		this.close();
	}
	,openDl: function(id,classes) {
		this.open("dl",[["id",id],["class",classes]]);
	}
	,formatText: function(text) {
		var ps = text.split("\n");
		var i;
		var _g1 = 0, _g = ps.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			this.openP();
			this.text(ps[i1]);
			this.close();
		}
	}
	,openPWithClass: function(className) {
		this.open("p",[["class",className]]);
	}
	,openP: function() {
		this.open("p",null);
	}
	,help: function(id,href,title) {
		this.openSpan(id + "span","wirishelp");
		this.open("a",[["id",id],["href",href],["class","wirishelp"],["title",title],["target","_blank"]]);
		this.close();
		this.close();
	}
	,openStrong: function() {
		this.open("strong",null);
	}
	,openA: function(id,href,className,target) {
		this.open("a",[["id",id],["href",href],["class",className],["target",target]]);
	}
	,select: function(id,name,options) {
		this.open("select",[["id",id],["name",name]]);
		var i;
		var _g1 = 0, _g = options.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			this.open("option",[["value",options[i1][0]]]);
			this.text(options[i1][1]);
			this.close();
		}
		this.close();
	}
	,openFieldset: function(id,legend,classes) {
		this.openCollapsibleFieldset(id,legend,classes,false,false);
	}
	,openCollapsibleFieldset: function(id,legend,classes,collapsible,collapsed) {
		var className = "wirisfieldset";
		if(classes != null && classes.length > 0) className += " " + classes;
		if(collapsible) {
			className += " wiriscollapsible";
			className += collapsed?" wiriscollapsed":" wirisexpanded";
		}
		this.open("fieldset",[["id",id],["class",className]]);
		this.open("legend",[["class",classes]]);
		if(collapsible) {
			className = "wiriscollapsiblea " + (collapsed?" wiriscollapsed":" wirisexpanded");
			this.open("a",[["href","#"],["class",className]]);
		}
		this.text(legend);
		if(collapsible) this.close();
		this.close();
		if(collapsible) {
			className = "wirisfieldsetwrapper " + (collapsed?" wiriscollapsed":" wirisexpanded");
			this.openDivClass(id + "-wrapper",className);
		}
	}
	,labelTitle: function(text,id,className,title) {
		this.open("label",[["for",id],["class",className],["title",title]]);
		this.text(text);
		this.close();
	}
	,label: function(text,id,className) {
		this.labelTitle(text,id,className,null);
	}
	,openLiClass: function(className) {
		this.open("li",[["class",className]]);
	}
	,openLi: function() {
		this.open("li",[]);
	}
	,li: function(content) {
		this.open("li",[]);
		this.text(content);
		this.close();
	}
	,openUl: function(id,className) {
		this.open("ul",[["id",id],["class",className]]);
	}
	,imageClass: function(src,title,className) {
		this.openclose("img",[["src",src],["alt",title],["title",title],["class",className]]);
	}
	,image: function(id,src,title,style) {
		this.openclose("img",[["id",id],["src",src],["alt",title],["title",title],["style",style]]);
	}
	,textarea: function(id,name,value,className,lang) {
		this.open("textarea",[["id",id],["name",name],["class",className],["lang",lang]]);
		this.text(value);
		this.close();
	}
	,input: function(type,id,name,value,title,className) {
		this.openclose("input",[["type",type],["id",id],["name",name],["value",value],["title",title],["class",className]]);
	}
	,js: function(code) {
		this.open("script",[["type","text/javascript"]]);
		this.text(code);
		this.close();
	}
	,openSpan: function(id,className) {
		this.open("span",[["id",id],["class",className]]);
	}
	,openDivClass: function(id,className) {
		this.open("div",[["id",id],["class",className]]);
	}
	,openDiv: function(id) {
		this.open("div",[["id",id]]);
	}
	,raw: function(raw) {
		this.s.b += Std.string(raw);
	}
	,getString: function() {
		if(this.tags.length > 0) throw "Malformed XML: tag " + this.tags.pop() + " is not closed.";
		return this.s.b;
	}
	,close: function() {
		if(this.tags.length == 0) throw "Malformed XML. No tag to close!";
		this.s.b += Std.string("</");
		this.s.b += Std.string(this.tags.pop());
		this.s.b += Std.string(">");
	}
	,text: function(text) {
		if(text != null) this.s.b += Std.string(com.wiris.util.xml.WXmlUtils.htmlEscape(text));
	}
	,textEm: function(text) {
		this.open("em",null);
		this.text(text);
		this.close();
	}
	,openclose: function(name,attributes) {
		this.start(name,attributes);
		this.s.b += Std.string("/>");
	}
	,open: function(name,attributes) {
		this.tags.push(name);
		this.start(name,attributes);
		this.s.b += Std.string(">");
	}
	,start: function(name,attributes) {
		this.s.b += Std.string("<");
		this.s.b += Std.string(name);
		if(attributes != null) {
			var i;
			var _g1 = 0, _g = attributes.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				if(attributes[i1].length == 2 && attributes[i1][0] != null && attributes[i1][1] != null) {
					this.s.b += Std.string(" ");
					this.s.b += Std.string(attributes[i1][0]);
					this.s.b += Std.string("=\"");
					this.s.b += Std.string(com.wiris.util.xml.WXmlUtils.htmlEscape(attributes[i1][1]));
					this.s.b += Std.string("\"");
				}
			}
		}
	}
	,tags: null
	,s: null
	,__class__: com.wiris.quizzes.impl.HTML
}
com.wiris.quizzes.impl.HTMLTableTools = $hxClasses["com.wiris.quizzes.impl.HTMLTableTools"] = function(separator) {
	this.separator = separator;
};
com.wiris.quizzes.impl.HTMLTableTools.__name__ = ["com","wiris","quizzes","impl","HTMLTableTools"];
com.wiris.quizzes.impl.HTMLTableTools.stripTags = function(html) {
	var e = new EReg("<[^>]*>","g");
	return e.replace(html,"");
}
com.wiris.quizzes.impl.HTMLTableTools.prototype = {
	removeRootTag: function(xml,name) {
		if(StringTools.startsWith(xml,"<" + name) && StringTools.endsWith(xml,"</" + name + ">")) {
			xml = HxOverrides.substr(xml,xml.indexOf(">") + 1,null);
			xml = HxOverrides.substr(xml,0,xml.length - (name.length + 3));
		}
		return xml;
	}
	,parseTabularVariableMathML: function(value) {
		var parts = new Array();
		value = this.removeRootTag(value,"math");
		value = this.removeRootTag(value,"mrow");
		value = this.removeRootTag(value,"mfenced");
		value = this.removeRootTag(value,"mrow");
		var level = 0;
		var end = 0;
		var start;
		var lastindex = 0;
		while((start = value.indexOf("<",end)) != -1) {
			var closing = false;
			end = value.indexOf(">",start);
			if(HxOverrides.cca(value,start + 1) == HxOverrides.cca("/",0)) {
				start++;
				closing = true;
			}
			var name = HxOverrides.substr(value,start + 1,end - start - 1);
			if(!closing) {
				var aux = name.indexOf(" ");
				if(aux != -1) name = HxOverrides.substr(name,0,aux);
				if(name == "mo" && !closing) {
					var op = HxOverrides.substr(value,end + 1,1);
					if(op == "{" || op == "[" || op == "(") level++; else if(op == "}" || op == "]" || op == ")") level--; else if(op == this.separator && level == 0) {
						parts.push(com.wiris.quizzes.impl.HTMLTools.addMathTag(HxOverrides.substr(value,lastindex,start - lastindex)));
						lastindex = end + 7;
					}
				}
			}
			if(name == "mfenced") level += closing?-1:1;
		}
		parts.push(com.wiris.quizzes.impl.HTMLTools.addMathTag(HxOverrides.substr(value,lastindex,null)));
		return parts;
	}
	,parseTabularVariableText: function(value) {
		var parts = new Array();
		value = HxOverrides.substr(value,1,value.length - 2);
		var s = this.separator != null?HxOverrides.cca(this.separator,0):HxOverrides.cca(",",0);
		var i;
		var level = 0;
		var token = new StringBuf();
		var open = [HxOverrides.cca("{",0),HxOverrides.cca("[",0),HxOverrides.cca("(",0)];
		var close = [HxOverrides.cca("}",0),HxOverrides.cca("]",0),HxOverrides.cca(")",0)];
		var _g1 = 0, _g = value.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			var c = HxOverrides.cca(value,i1);
			if(c == s && level == 0) {
				parts.push(token.b);
				token = new StringBuf();
			} else {
				token.b += String.fromCharCode(c);
				if(c == open[0] || c == open[1] || c == open[2]) level++; else if(c == close[0] || c == close[1] || c == close[2]) level--;
			}
		}
		parts.push(token.b);
		return parts;
	}
	,parseTabularVariable: function(name,variables) {
		var v = variables.get(com.wiris.quizzes.impl.MathContent.TYPE_MATHML);
		if(v != null && v.exists(name)) return this.parseTabularVariableMathML(v.get(name));
		v = variables.get(com.wiris.quizzes.impl.MathContent.TYPE_TEXT);
		if(v != null && v.exists(name)) return this.parseTabularVariableText(v.get(name));
		return null;
	}
	,parseMathMLMatrix: function(mathml) {
		var res = new Array();
		var start;
		var end = 0;
		while((start = mathml.indexOf("<mtr",end)) != -1) {
			start = mathml.indexOf(">",start) + 1;
			end = mathml.indexOf("</mtr>",start);
			var row = HxOverrides.substr(mathml,start,end - start);
			var a = new Array();
			var rstart;
			var rend = 0;
			while((rstart = row.indexOf("<mtd",rend)) != -1) {
				rstart = row.indexOf(">",rstart) + 1;
				rend = row.indexOf("</mtd>",rstart);
				var cell = com.wiris.quizzes.impl.HTMLTools.addMathTag(HxOverrides.substr(row,rstart,rend - rstart));
				a.push(cell);
			}
			res.push(a);
		}
		return res;
	}
	,parseTabularVariable2d: function(name,variables) {
		var v = variables.get(com.wiris.quizzes.impl.MathContent.TYPE_MATHML);
		if(v != null && v.exists(name)) {
			var mathml = v.get(name);
			if(mathml.indexOf("<mtable") != -1) return this.parseMathMLMatrix(mathml); else {
				var res = new Array();
				var rows = this.parseTabularVariableMathML(mathml);
				var i;
				var _g1 = 0, _g = rows.length;
				while(_g1 < _g) {
					var i1 = _g1++;
					res.push(this.parseTabularVariableMathML(rows[i1]));
				}
				return res;
			}
		}
		v = variables.get(com.wiris.quizzes.impl.MathContent.TYPE_TEXT);
		if(v != null && v.exists(name)) {
			var res = new Array();
			var rows = this.parseTabularVariableText(v.get(name));
			var i;
			var _g1 = 0, _g = rows.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				res.push(this.parseTabularVariableText(rows[i1]));
			}
			return res;
		}
		return null;
	}
	,isTabularMathMLVariable2d: function(value) {
		this.initTabularERegs();
		return this.mathmllist2d.match(value) || this.mathmlmatrix.match(value);
	}
	,isTabularTextVariable2d: function(value) {
		this.initTabularERegs();
		return this.textlist2d.match(value);
	}
	,isTabularTextVariable: function(value) {
		this.initTabularERegs();
		return this.textlist.match(value);
	}
	,isTabularMathMLVariable: function(value) {
		this.initTabularERegs();
		return this.mathmllist.match(value);
	}
	,initMathMLTabularERegs: function() {
		var om = "(<math[^>]*>)?(<mrow[^>]*>)?";
		var cm = "(</mrow>)?(</math>)?";
		var ol = "<mfenced(\\s+open\\s*=\\s*\"[\\[\\{]\"|\\s+close\\s*=\\s*\"[\\]\\}]\"){2}\\s*><mrow>";
		var cl = "</mrow></mfenced>";
		var s = "<mo>\\" + this.separator + "</mo>";
		var x = "[^\\" + this.separator + "]*";
		var list = ol + "(" + x + s + ")*" + x + cl;
		var list2d = ol + "(" + list + s + ")*" + list + cl;
		this.mathmllist = new EReg(om + list + cm,"m");
		this.mathmllist2d = new EReg(om + list2d + cm,"m");
		var ot = "<mfenced><mtable>";
		var ct = "</mtable></mfenced>";
		var cell = "<mtd>.*?</mtd>";
		var row = "<mtr>" + "(" + cell + ")+" + "</mtr>";
		var matrix = ot + "(" + row + ")+" + ct;
		this.mathmlmatrix = new EReg(om + matrix + cm,"g");
	}
	,initTextTabularERegs: function() {
		var s = "\\" + this.separator;
		var o = "[\\[\\{]";
		var c = "[\\}\\]]";
		var x = "[^\\[\\{\\}\\]" + s + "]*";
		var list = o + "(" + x + s + ")*" + x + c;
		var list2d = o + "(" + list + s + ")*" + list + c;
		this.textlist = new EReg(list,"g");
		this.textlist2d = new EReg(list2d,"g");
	}
	,initTabularERegs: function() {
		if(this.textlist == null) {
			this.initTextTabularERegs();
			this.initMathMLTabularERegs();
		}
	}
	,isCellExpandableImpl: function(cell,variables,is2d) {
		if(cell.indexOf("<input") != -1) return false;
		var h = new com.wiris.quizzes.impl.HTMLTools();
		var start;
		var end = 0;
		while((start = cell.indexOf("<math",end)) != -1) {
			end = cell.indexOf("</math>",start) + 7;
			if(!h.isTokensMathML(HxOverrides.substr(cell,start,end - start))) return false;
		}
		var content = StringTools.trim(com.wiris.quizzes.impl.HTMLTableTools.stripTags(cell));
		if(StringTools.startsWith(content,"#")) {
			content = HxOverrides.substr(content,1,null);
			if(cell.indexOf("#" + content) != -1) {
				var v = variables.get(com.wiris.quizzes.impl.MathContent.TYPE_MATHML);
				if(v != null && v.exists(content)) {
					if(is2d && this.isTabularMathMLVariable2d(v.get(content)) || !is2d && this.isTabularMathMLVariable(v.get(content))) return true;
				}
				v = variables.get(com.wiris.quizzes.impl.MathContent.TYPE_TEXT);
				if(v != null && v.exists(content)) {
					if(is2d && this.isTabularTextVariable2d(v.get(content)) || !is2d && this.isTabularTextVariable(v.get(content))) return true;
				}
			}
		}
		return false;
	}
	,isCellExpandable: function(cell,variables) {
		return this.isCellExpandableImpl(cell,variables,false);
	}
	,isCellExpandable2d: function(cell,variables) {
		return this.isCellExpandableImpl(cell,variables,true);
	}
	,setClass: function(element,name) {
		var end = element.indexOf(">");
		if(end != -1) {
			var tag = HxOverrides.substr(element,0,end + 1);
			var e = new EReg("<\\w+[^>]*\\s+class\\s*=\\s*\"[^\"]*\"[^>]*>","g");
			if(!e.match(tag)) {
				tag = HxOverrides.substr(tag,0,end) + " class=\"" + name + "\">";
				element = tag + HxOverrides.substr(element,end + 1,null);
			}
		}
		return element;
	}
	,expandVertical: function(rows,grid,variables) {
		var i;
		var _g1 = 0, _g = grid.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			var thisrow = true;
			var j = 0;
			while(thisrow && j < grid[i1].length) {
				thisrow = this.isCellExpandable(grid[i1][j],variables);
				j++;
			}
			if(thisrow && j > 0) {
				var opentds = new Array();
				var closetds = new Array();
				var vars = new Array();
				var n = -1;
				var _g3 = 0, _g2 = grid[i1].length;
				while(_g3 < _g2) {
					var j1 = _g3++;
					var model = this.getModel(grid[i1][j1]);
					var placeholder = StringTools.trim(com.wiris.quizzes.impl.HTMLTableTools.stripTags(model));
					var pos = model.indexOf(placeholder);
					opentds[j1] = HxOverrides.substr(model,0,pos);
					closetds[j1] = HxOverrides.substr(model,pos + placeholder.length,null);
					var parsed = this.parseTabularVariable(HxOverrides.substr(placeholder,1,null),variables);
					vars.push(parsed);
					if(parsed.length > n) n = parsed.length;
				}
				var original = rows[2 * i1 + 1];
				var bounds = this.rowBounds(original);
				var row = new StringBuf();
				var k;
				var _g2 = 0;
				while(_g2 < n) {
					var k1 = _g2++;
					row.b += Std.string(bounds[0]);
					var _g4 = 0, _g3 = opentds.length;
					while(_g4 < _g3) {
						var j1 = _g4++;
						row.b += Std.string(opentds[j1]);
						if(k1 < vars[j1].length) row.b += Std.string(vars[j1][k1]);
						row.b += Std.string(closetds[j1]);
					}
					row.b += Std.string(bounds[1]);
				}
				rows[2 * i1 + 1] = row.b;
				return rows.join("");
			}
		}
		return null;
	}
	,reconstructHorizontalExpand: function(rows,grid) {
		var newTable = new StringBuf();
		var i;
		var _g1 = 0, _g = grid.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			newTable.b += Std.string(rows[2 * i1]);
			var row = rows[2 * i1 + 1];
			var bounds = this.rowBounds(row);
			newTable.b += Std.string(bounds[0]);
			var j;
			var _g3 = 0, _g2 = grid[i1].length;
			while(_g3 < _g2) {
				var j1 = _g3++;
				newTable.b += Std.string(grid[i1][j1]);
			}
			newTable.b += Std.string(bounds[1]);
		}
		newTable.b += Std.string(rows[2 * grid.length]);
		return newTable.b;
	}
	,joinTds: function(model,values) {
		var placeholder = StringTools.trim(com.wiris.quizzes.impl.HTMLTableTools.stripTags(model));
		var pos = model.indexOf(placeholder);
		var prefix = HxOverrides.substr(model,0,pos);
		var suffix = HxOverrides.substr(model,pos + placeholder.length,null);
		var sb = new StringBuf();
		var k;
		var _g1 = 0, _g = values.length;
		while(_g1 < _g) {
			var k1 = _g1++;
			sb.b += Std.string(prefix);
			sb.b += Std.string(values[k1]);
			sb.b += Std.string(suffix);
		}
		return sb.b;
	}
	,getModel: function(cell) {
		if(cell.indexOf("<math") == -1) return cell;
		var placeholder = StringTools.trim(com.wiris.quizzes.impl.HTMLTableTools.stripTags(cell));
		var pos = cell.indexOf(placeholder);
		var prefix = HxOverrides.substr(cell,0,pos);
		var suffix = HxOverrides.substr(cell,pos + placeholder.length,null);
		if((pos = prefix.indexOf("<math")) != -1) prefix = HxOverrides.substr(prefix,0,pos);
		if((pos = suffix.indexOf("</math>")) != -1) suffix = HxOverrides.substr(suffix,pos + 7,null);
		return prefix + placeholder + suffix;
	}
	,expandHorizontal: function(rows,grid,variables) {
		var j = 0;
		var end = false;
		while(!end) {
			var thiscolumn = true;
			var i = 0;
			while(i < grid.length && thiscolumn && !end) {
				var thiscell = false;
				if(j < grid[i].length) thiscell = this.isCellExpandable(grid[i][j],variables); else end = true;
				thiscolumn = thiscolumn && thiscell;
				i++;
			}
			end = end || i == 0;
			if(thiscolumn && !end) {
				end = true;
				var _g1 = 0, _g = grid.length;
				while(_g1 < _g) {
					var i1 = _g1++;
					var model = this.getModel(grid[i1][j]);
					var parsed = this.parseTabularVariable(HxOverrides.substr(StringTools.trim(com.wiris.quizzes.impl.HTMLTableTools.stripTags(model)),1,null),variables);
					var tds = this.joinTds(model,parsed);
					grid[i1][j] = tds;
				}
				return this.reconstructHorizontalExpand(rows,grid);
			}
			j++;
		}
		return null;
	}
	,expand2d: function(rows,grid,variables) {
		var expand = this.expandVertical2d(rows,grid,variables);
		if(expand == null) expand = this.expandHorizontal2d(rows,grid,variables);
		if(expand == null) expand = this.expandBoth(rows,grid,variables);
		return expand;
	}
	,expandBoth: function(rows,grid,variables) {
		var i;
		var j;
		var vars = new Array();
		var expand = true;
		i = 0;
		while(expand && i < grid.length) {
			var nrows = -1;
			var row = grid[i];
			vars.push(new Array());
			j = 0;
			while(expand && j < row.length) {
				var cell = row[j];
				if(this.isCellExpandable2d(cell,variables)) {
					var name = HxOverrides.substr(StringTools.trim(com.wiris.quizzes.impl.HTMLTableTools.stripTags(cell)),1,null);
					var p = this.parseTabularVariable2d(name,variables);
					vars[i].push(p);
					if(nrows == -1) nrows = p.length; else if(nrows != p.length) expand = false;
				} else if(this.isCellExpandable(cell,variables)) {
					var name = HxOverrides.substr(StringTools.trim(com.wiris.quizzes.impl.HTMLTableTools.stripTags(cell)),1,null);
					var p = this.parseTabularVariable(name,variables);
					if(nrows == -1) {
						if(row.length == 1) nrows = 1; else nrows = p.length;
					}
					var pp;
					if(nrows == 1) {
						pp = new Array();
						pp.push(p);
						vars[i].push(pp);
					} else if(nrows == p.length) {
						pp = this.transposeColumn(p);
						vars[i].push(pp);
					} else expand = false;
				} else expand = false;
				j++;
			}
			expand = expand && j > 0;
			i++;
		}
		if(expand && i > 0) {
			var _g1 = 0, _g = grid.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var original = rows[2 * i1 + 1];
				var bounds = this.rowBounds(original);
				var sb = new StringBuf();
				var k;
				var first = vars[i1][0];
				var _g3 = 0, _g2 = first.length;
				while(_g3 < _g2) {
					var k1 = _g3++;
					sb.b += Std.string(bounds[0]);
					var _g5 = 0, _g4 = grid[i1].length;
					while(_g5 < _g4) {
						var j1 = _g5++;
						var model = this.getModel(grid[i1][j1]);
						var x = vars[i1][j1];
						var tds = this.joinTds(model,x[k1]);
						sb.b += Std.string(tds);
					}
					sb.b += Std.string(bounds[1]);
				}
				rows[2 * i1 + 1] = sb.b;
			}
			return rows.join("");
		}
		return null;
	}
	,expandHorizontal2d: function(rows,grid,variables) {
		var i;
		var j = 0;
		var end = grid.length == 0;
		while(!end) {
			var thiscolumn = true;
			i = 0;
			while(i < grid.length && thiscolumn && !end) {
				var thiscell = false;
				if(j < grid[i].length) {
					var cell = grid[i][j];
					thiscell = this.isCellExpandable2d(cell,variables);
					if(thiscell) {
						var name = HxOverrides.substr(StringTools.trim(com.wiris.quizzes.impl.HTMLTableTools.stripTags(cell)),1,null);
						var p = this.parseTabularVariable2d(name,variables);
						thiscell = this.isSubgridEmpty(grid,i,j,p.length,1);
						i += p.length;
					}
				} else end = true;
				thiscolumn = thiscolumn && thiscell;
			}
			if(thiscolumn && !end) {
				end = true;
				i = 0;
				while(i < grid.length) {
					var model = grid[i][j];
					var name = HxOverrides.substr(StringTools.trim(com.wiris.quizzes.impl.HTMLTableTools.stripTags(model)),1,null);
					var p = this.parseTabularVariable2d(name,variables);
					var k;
					var _g1 = 0, _g = p.length;
					while(_g1 < _g) {
						var k1 = _g1++;
						var tds = this.joinTds(model,p[k1]);
						grid[i + k1][j] = tds;
					}
					i += p.length;
				}
				return this.reconstructHorizontalExpand(rows,grid);
			}
			j++;
		}
		return null;
	}
	,expandVertical2d: function(rows,grid,variables) {
		var i;
		var _g1 = 0, _g = grid.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			var row = grid[i1];
			var thisrow = true;
			var n = -1;
			var j = 0;
			while(thisrow && j < row.length) {
				var cell = row[j];
				if(this.isCellExpandable2d(cell,variables)) {
					var name = HxOverrides.substr(StringTools.trim(com.wiris.quizzes.impl.HTMLTableTools.stripTags(cell)),1,null);
					var p = this.parseTabularVariable2d(name,variables);
					if(p.length > n) n = p.length;
					if(this.isSubgridEmpty(grid,i1,j,1,p[0].length)) j += p[0].length; else thisrow = false;
				} else thisrow = false;
			}
			if(thisrow && j > 0) {
				var opentds = new Array();
				var closetds = new Array();
				var vars = new Array();
				var k;
				var _g2 = 0;
				while(_g2 < n) {
					var k1 = _g2++;
					vars[k1] = new Array();
				}
				j = 0;
				while(j < row.length) {
					var model = grid[i1][j];
					var placeholder = StringTools.trim(com.wiris.quizzes.impl.HTMLTableTools.stripTags(model));
					var pos = model.indexOf(placeholder);
					opentds[j] = HxOverrides.substr(model,0,pos);
					closetds[j] = HxOverrides.substr(model,pos + placeholder.length,null);
					var name = HxOverrides.substr(placeholder,1,null);
					var p = this.parseTabularVariable2d(name,variables);
					var _g3 = 0, _g2 = p[0].length;
					while(_g3 < _g2) {
						var k1 = _g3++;
						opentds[j + k1] = opentds[j];
						closetds[j + k1] = closetds[j];
						var l;
						var _g5 = 0, _g4 = p.length;
						while(_g5 < _g4) {
							var l1 = _g5++;
							vars[l1][j + k1] = p[l1][k1];
						}
					}
					j += p[0].length;
				}
				var original = rows[2 * i1 + 1];
				var bounds = this.rowBounds(original);
				var s = new StringBuf();
				var _g2 = 0;
				while(_g2 < n) {
					var k1 = _g2++;
					s.b += Std.string(bounds[0]);
					var _g4 = 0, _g3 = row.length;
					while(_g4 < _g3) {
						var j1 = _g4++;
						s.b += Std.string(opentds[j1]);
						s.b += Std.string(vars[k1][j1]);
						s.b += Std.string(closetds[j1]);
					}
					s.b += Std.string(bounds[1]);
				}
				rows[2 * i1 + 1] = s.b;
				return rows.join("");
			}
		}
		return null;
	}
	,expandNoGrow: function(rows,grid,variables) {
		var expanded = false;
		var i;
		var _g1 = 0, _g = grid.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			var j;
			var _g3 = 0, _g2 = grid[i1].length;
			while(_g3 < _g2) {
				var j1 = _g3++;
				var cell = grid[i1][j1];
				if(this.isCellExpandable2d(cell,variables)) {
					var name = HxOverrides.substr(StringTools.trim(com.wiris.quizzes.impl.HTMLTableTools.stripTags(cell)),1,null);
					var p = this.parseTabularVariable2d(name,variables);
					if(this.isSubgridEmpty(grid,i1,j1,p.length,p[0].length)) {
						this.expandOnEmptySubgrid(grid,i1,j1,p);
						expanded = true;
					}
				} else if(this.isCellExpandable(cell,variables)) {
					var name = HxOverrides.substr(StringTools.trim(com.wiris.quizzes.impl.HTMLTableTools.stripTags(cell)),1,null);
					var p = this.parseTabularVariable(name,variables);
					if(this.isSubgridEmpty(grid,i1,j1,1,p.length)) {
						var row = new Array();
						row.push(p);
						this.expandOnEmptySubgrid(grid,i1,j1,row);
						expanded = true;
					} else if(this.isSubgridEmpty(grid,i1,j1,p.length,1)) {
						var column = this.transposeColumn(p);
						this.expandOnEmptySubgrid(grid,i1,j1,column);
						expanded = true;
					}
				}
			}
		}
		if(expanded) return this.reconstructHorizontalExpand(rows,grid);
		return null;
	}
	,transposeColumn: function(p) {
		var column = new Array();
		var k;
		var _g1 = 0, _g = p.length;
		while(_g1 < _g) {
			var k1 = _g1++;
			var a = new Array();
			a.push(p[k1]);
			column.push(a);
		}
		return column;
	}
	,expandOnEmptySubgrid: function(grid,i,j,p) {
		var k;
		var _g1 = 0, _g = p.length;
		while(_g1 < _g) {
			var k1 = _g1++;
			var l;
			var _g3 = 0, _g2 = p[k1].length;
			while(_g3 < _g2) {
				var l1 = _g3++;
				var cell = grid[i + k1][j + l1];
				var prefix = HxOverrides.substr(cell,0,cell.indexOf(">") + 1);
				var suffix = HxOverrides.substr(cell,cell.lastIndexOf("<"),null);
				grid[i + k1][j + l1] = prefix + p[k1][l1] + suffix;
			}
		}
	}
	,isEmptyCell: function(cell) {
		cell = com.wiris.quizzes.impl.HTMLTableTools.stripTags(cell);
		cell = com.wiris.util.xml.WXmlUtils.htmlUnescape(cell);
		cell = StringTools.replace(cell,"&nbsp;","");
		cell = StringTools.replace(cell,com.wiris.system.Utf8.uchr(160),"");
		cell = StringTools.trim(cell);
		return cell == "";
	}
	,isSubgridEmpty: function(grid,i,j,w,h) {
		if(i + w > grid.length) return false;
		var k;
		var _g1 = i, _g = i + w;
		while(_g1 < _g) {
			var k1 = _g1++;
			if(j + h > grid[k1].length) return false;
			var l;
			var _g3 = j, _g2 = j + h;
			while(_g3 < _g2) {
				var l1 = _g3++;
				if(k1 != i || l1 != j) {
					if(!this.isEmptyCell(grid[k1][l1])) return false;
				}
			}
		}
		return true;
	}
	,parseTableCells: function(rows) {
		var grid = new Array();
		var i = 1;
		while(i < rows.length) {
			var cells = new Array();
			var row = rows[i];
			var tdstart;
			var tdend = 0;
			while((tdstart = this.tdStartPosition(row,tdend)) != -1) {
				tdend = this.tdEndPosition(row,tdstart);
				if(tdend == -1) tdend = row.length; else tdend += 5;
				cells.push(HxOverrides.substr(row,tdstart,tdend - tdstart));
			}
			grid.push(cells);
			i += 2;
		}
		return grid;
	}
	,rowBounds: function(row) {
		var bounds = new Array();
		bounds[0] = HxOverrides.substr(row,0,this.tdStartPosition(row,0));
		var pos = com.wiris.util.type.IntegerTools.max(row.lastIndexOf("</td>"),row.lastIndexOf("</th>")) + "</th>".length;
		bounds[1] = HxOverrides.substr(row,pos,null);
		return bounds;
	}
	,tdEndPosition: function(row,offset) {
		var a = row.indexOf("</td>",offset);
		var b = row.indexOf("</th>",offset);
		return b == -1?a:a == -1?b:com.wiris.util.type.IntegerTools.min(a,b);
	}
	,tdStartPosition: function(row,offset) {
		var pos = -1;
		var start = ["<td ","<td>","<th ","<th>"];
		var i;
		var _g1 = 0, _g = start.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			var c = row.indexOf(start[i1],offset);
			if(c != -1 && c < pos || pos == -1) pos = c;
		}
		return pos;
	}
	,splitTableRows: function(table) {
		var rows = new Array();
		var trend = 0;
		var trstart;
		while((trstart = table.indexOf("<tr",trend)) != -1) {
			rows.push(HxOverrides.substr(table,trend,trstart - trend));
			trend = table.indexOf("</tr>",trstart);
			if(trend == -1) {
				var last = rows[rows.length - 1];
				rows[rows.length - 1] = last + HxOverrides.substr(table,trstart,null);
				trend = table.length;
			} else {
				trend += "</tr>".length;
				rows.push(HxOverrides.substr(table,trstart,trend - trstart));
			}
		}
		if(trend < table.length) rows.push(HxOverrides.substr(table,trend,null));
		return rows;
	}
	,replaceVariablesInsideHTMLTables: function(html,variables) {
		var tend = 0;
		var tstart;
		while((tstart = html.indexOf("<table",tend)) != -1) {
			tend = html.indexOf("</table>",tstart);
			if(tend == -1) return html;
			tend += "</table>".length;
			var table = HxOverrides.substr(html,tstart,tend - tstart);
			var rows = this.splitTableRows(table);
			var grid = this.parseTableCells(rows);
			var expanded = this.expandNoGrow(rows,grid,variables);
			if(expanded == null) {
				expanded = this.expand2d(rows,grid,variables);
				if(expanded == null) {
					expanded = this.expandHorizontal(rows,grid,variables);
					if(expanded == null) expanded = this.expandVertical(rows,grid,variables);
				}
			}
			if(expanded != null) {
				expanded = this.setClass(expanded,"wiristable");
				html = HxOverrides.substr(html,0,tstart) + expanded + HxOverrides.substr(html,tend,null);
				tend = tstart + expanded.length;
			}
		}
		return html;
	}
	,mathmlmatrix: null
	,mathmllist2d: null
	,textlist2d: null
	,mathmllist: null
	,textlist: null
	,separator: null
	,__class__: com.wiris.quizzes.impl.HTMLTableTools
}
com.wiris.quizzes.impl.HTMLTools = $hxClasses["com.wiris.quizzes.impl.HTMLTools"] = function() {
	this.separator = ",";
};
com.wiris.quizzes.impl.HTMLTools.__name__ = ["com","wiris","quizzes","impl","HTMLTools"];
com.wiris.quizzes.impl.HTMLTools.toNativeArray = function(a) {
	var n = new Array();
	var k;
	var _g1 = 0, _g = a.length;
	while(_g1 < _g) {
		var k1 = _g1++;
		n[k1] = a[k1];
	}
	return n;
}
com.wiris.quizzes.impl.HTMLTools.insertStringInSortedArray = function(s,a) {
	if(s != null) {
		var i = 0;
		while(i < a.length) {
			if(com.wiris.quizzes.impl.HTMLTools.compareStrings(a[i],s) >= 0) break;
			i++;
		}
		if(i < a.length) {
			if(!(a[i] == s)) a.splice(i,0,s);
		} else a.push(s);
	}
}
com.wiris.quizzes.impl.HTMLTools.encodeUnicodeChars = function(mathml) {
	var sb = new StringBuf();
	var i;
	var _g1 = 0, _g = mathml.length;
	while(_g1 < _g) {
		var i1 = _g1++;
		var c = HxOverrides.cca(mathml,i1);
		if(c > 127) {
			sb.b += Std.string("&#");
			sb.b += Std.string(c);
			sb.b += Std.string(";");
		} else sb.b += String.fromCharCode(c);
	}
	return sb.b;
}
com.wiris.quizzes.impl.HTMLTools.compareStrings = function(a,b) {
	var i;
	var an = a.length;
	var bn = b.length;
	var n = an > bn?bn:an;
	var _g = 0;
	while(_g < n) {
		var i1 = _g++;
		var c = HxOverrides.cca(a,i1) - HxOverrides.cca(b,i1);
		if(c != 0) return c;
	}
	return a.length - b.length;
}
com.wiris.quizzes.impl.HTMLTools.addMathTag = function(mathml) {
	if(!StringTools.startsWith(mathml,"<math")) mathml = "<math xmlns=\"http://www.w3.org/1998/Math/MathML\">" + mathml + "</math>";
	return mathml;
}
com.wiris.quizzes.impl.HTMLTools.emptyCasSession = function(value) {
	return value == null || value.indexOf("<mo") == -1 && value.indexOf("<mi") == -1 && value.indexOf("<mn") == -1 && value.indexOf("<csymbol") == -1 && value.indexOf("algorithm") == -1;
}
com.wiris.quizzes.impl.HTMLTools.hasCasSessionParameter = function(session,parameter,name) {
	session = com.wiris.util.xml.WXmlUtils.resolveEntities(session);
	var expr = com.wiris.quizzes.impl.HTMLTools.getParameterEReg(parameter,name);
	var exprAL = com.wiris.quizzes.impl.HTMLTools.getParameterFromAlgorithmLine(parameter,name);
	if(expr.match(session) || exprAL.match(session)) return true; else {
		var noaccents = com.wiris.util.type.StringUtils.stripAccents(parameter);
		if(!(noaccents == parameter)) {
			expr = com.wiris.quizzes.impl.HTMLTools.getParameterEReg(noaccents,name);
			exprAL = com.wiris.quizzes.impl.HTMLTools.getParameterFromAlgorithmLine(noaccents,name);
			return expr.match(session) || exprAL.match(session);
		}
		return false;
	}
}
com.wiris.quizzes.impl.HTMLTools.getParameterEReg = function(parameter,name) {
	return new EReg(".*<input>\\s*<math[^>]*>\\s*<mi>" + parameter + "</mi>\\s*<mo>\\s*(" + com.wiris.system.Utf8.uchr(160) + "|\\s)\\s*</mo><mi>" + name + "\\d*</mi>.*","gmi");
}
com.wiris.quizzes.impl.HTMLTools.getParameterFromAlgorithmLine = function(parameter,name) {
	return new EReg(".*" + parameter + "\\s*" + name + ".*","gmi");
}
com.wiris.quizzes.impl.HTMLTools.stripConstructionsFromCalcSession = function(calcSession) {
	if(com.wiris.quizzes.impl.CalcDocumentTools.isCalc(calcSession)) {
		var start = calcSession.indexOf("<wiriscalc");
		var end = calcSession.indexOf("</wiriscalc>",start);
		start = calcSession.indexOf("<constructions",start);
		if(start > -1 && start < end) {
			end = calcSession.indexOf("</constructions>",start);
			var sb = new StringBuf();
			sb.b += Std.string(HxOverrides.substr(calcSession,0,start));
			sb.b += Std.string(HxOverrides.substr(calcSession,end + "</constructions>".length,null));
			calcSession = sb.b;
		}
	}
	return calcSession;
}
com.wiris.quizzes.impl.HTMLTools.mathMLImgSrc = function(mathml,centerBaseline,zoom,editorUrl,proxyUrl,crossOriginEnabled) {
	var src = crossOriginEnabled?editorUrl + "/render?":proxyUrl + "?service=render&";
	src += "stats-app=quizzes&";
	if(!centerBaseline) src += "centerbaseline=false&";
	if(zoom != 1.0) src += "zoom=" + zoom + "&";
	mathml = com.wiris.util.xml.MathMLUtils.removeStrokesAnnotation(mathml);
	mathml = StringTools.urlEncode(com.wiris.quizzes.impl.HTMLTools.encodeUnicodeChars(mathml));
	src += "mml=" + mathml;
	return src;
}
com.wiris.quizzes.impl.HTMLTools.getEmptyCalcMeSession = function() {
	return "<wiriscalc version=\"3.1\"><title><math xmlns=\"http://www.w3.org/1998/Math/MathML\"><mtext>Untitled calc</mtext></math></title><properties><property name=\"lang\">en</property><property name=\"precision\">4</property><property name=\"use_degrees\">false</property></properties><session version=\"3.0\" lang=\"en\"><task><title><math xmlns=\"http://www.w3.org/1998/Math/MathML\"><mtext>Sheet 1</mtext></math></title><group><command><input><math xmlns=\"http://www.w3.org/1998/Math/MathML\"/></input></command></group></task></session></wiriscalc>";
}
com.wiris.quizzes.impl.HTMLTools.prototype = {
	isMathMLString: function(math) {
		math = StringTools.trim(math);
		return StringTools.startsWith(math,"<math") && StringTools.endsWith(math,"</math>");
	}
	,setPlotterLoadingSrc: function(src) {
		this.plotterLoadingSrc = src;
	}
	,setProxyUrl: function(proxyUrl) {
		this.proxyUrl = proxyUrl;
	}
	,setAnswerKeyword: function(keyword) {
		this.answerKeyword = keyword;
	}
	,getAnswerVariables: function(answers,compound) {
		var h = new Hash();
		var i;
		if(!compound) {
			var _g1 = 0, _g = answers.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var a = answers[i1];
				if(!h.exists(a.type)) h.set(a.type,new Hash());
				h.get(a.type).set(this.answerKeyword + (i1 + 1),a.content);
			}
			if(answers.length == 1) h.get(answers[0].type).set(this.answerKeyword,answers[0].content);
		} else {
			var answer = answers[0];
			var a = com.wiris.quizzes.impl.CompoundAnswerParser.parseCompoundAnswer(answer);
			var _g1 = 0, _g = a.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var s = a[i1][1];
				var type = this.isMathMLString(s)?com.wiris.quizzes.impl.MathContent.TYPE_MATHML:com.wiris.quizzes.impl.MathContent.TYPE_TEXT;
				if(!h.exists(type)) h.set(type,new Hash());
				h.get(type).set(this.answerKeyword + (i1 + 1),s);
			}
			if(!h.exists(answer.type)) h.set(answer.type,new Hash());
			h.get(answer.type).set(this.answerKeyword,answer.content);
		}
		return h;
	}
	,expandAnswersText: function(text,answers,compound) {
		if(answers == null || answers.length == 0 || this.answerKeyword == null || text.indexOf("#" + this.answerKeyword) == -1) return text;
		var h = this.getAnswerVariables(answers,compound);
		var textvariables = h.get(com.wiris.quizzes.impl.MathContent.TYPE_TEXT);
		return this.expandVariablesText(text,textvariables);
	}
	,expandAnswers: function(text,answers,compound) {
		if(answers == null || answers.length == 0 || this.answerKeyword == null || text.indexOf("#" + this.answerKeyword) == -1) return text;
		var h = this.getAnswerVariables(answers,compound);
		return this.expandVariables(text,h);
	}
	,setItemSeparator: function(sep) {
		this.separator = sep == null?",":sep;
	}
	,isImplicitArgumentFactor: function(x) {
		if(x.getNodeName() == "mi" || x.getNodeName() == "mn") return true;
		if(x.getNodeName() == "msup") {
			var c = x.firstElement();
			if(c != null && c.getNodeName() == "mi" || c.getNodeName() == "mn") return true;
		}
		return false;
	}
	,fullMathML2TextImpl: function(e) {
		var sb = new StringBuf();
		if(e.getNodeName() == "mo" || e.getNodeName() == "mn" || e.getNodeName() == "mi" || e.getNodeName() == "mtext") sb.b += Std.string(com.wiris.util.xml.WXmlUtils.getNodeValue(e.firstChild())); else if(e.getNodeName() == "mfenced" || e.getNodeName() == "mtr" || e.getNodeName() == "mtable") {
			var open = e.get("open");
			if(open == null) open = "(";
			var close = e.get("close");
			if(close == null) close = ")";
			var separators = e.get("separators");
			if(separators == null) separators = ",";
			if(open == "(" && close == ")" && e.firstElement() != null && e.firstElement().getNodeName() == "mtable") {
				open = "";
				close = "";
			}
			sb.b += Std.string(open);
			var it = e.elements();
			var i = 0;
			var n = com.wiris.system.Utf8.getLength(separators);
			while(it.hasNext()) {
				if(i > 0 && n > 0) sb.b += Std.string(com.wiris.system.Utf8.uchr(com.wiris.system.Utf8.charCodeAt(separators,i < n?i:n - 1)));
				sb.b += Std.string(this.fullMathML2TextImpl(it.next()));
				i++;
			}
			sb.b += Std.string(close);
		} else if(e.getNodeName() == "mfrac") {
			var it = e.elements();
			var num = this.fullMathML2TextImpl(it.next());
			if(num.length > 1) num = "(" + num + ")";
			var den = this.fullMathML2TextImpl(it.next());
			if(den.length > 1) den = "(" + den + ")";
			sb.b += Std.string(num);
			sb.b += Std.string("/");
			sb.b += Std.string(den);
		} else if(e.getNodeName() == "msup") {
			var it = e.elements();
			var bas = this.fullMathML2TextImpl(it.next());
			if(bas.length > 1) bas = "(" + bas + ")";
			var exp = this.fullMathML2TextImpl(it.next());
			if(exp.length > 1) exp = "(" + exp + ")";
			sb.b += Std.string(bas);
			sb.b += Std.string("^");
			sb.b += Std.string(exp);
		} else if(e.getNodeName() == "msqrt") {
			sb.b += Std.string("sqrt(");
			e.setNodeName("math");
			sb.b += Std.string(this.fullMathML2TextImpl(e));
			sb.b += Std.string(")");
		} else if(e.getNodeName() == "mroot") {
			var it = e.elements();
			var rad = this.fullMathML2TextImpl(it.next());
			var ind = this.fullMathML2TextImpl(it.next());
			sb.b += Std.string("root(");
			sb.b += Std.string(rad);
			sb.b += Std.string(",");
			sb.b += Std.string(ind);
			sb.b += Std.string(")");
		} else if(e.getNodeName() == "mspace" && "newline" == e.get("linebreak")) sb.b += Std.string("\n"); else if(e.getNodeName() == "semantics") {
			var it = e.elements();
			if(it.hasNext()) {
				var mml = it.next();
				if(it.hasNext()) {
					var ann = it.next();
					if(ann.getNodeName() == "annotation" && "text/plain" == ann.get("encoding")) return com.wiris.util.xml.WXmlUtils.getText(ann);
				}
				return this.fullMathML2TextImpl(mml);
			}
		} else {
			var it = e.elements();
			while(it.hasNext()) {
				var x = it.next();
				sb.b += Std.string(this.fullMathML2TextImpl(x));
				if(x.getNodeName() == "mi" && this.isFunctionName(com.wiris.util.xml.WXmlUtils.getNodeValue(x.firstChild())) && it.hasNext()) {
					var y = it.next();
					if(y.getNodeName() == "msqrt" || y.getNodeName() == "mfrac" || y.getNodeName() == "mroot") {
						sb.b += Std.string("(");
						sb.b += Std.string(this.fullMathML2TextImpl(y));
						sb.b += Std.string(")");
					} else {
						var parentheses = false;
						var argument = new StringBuf();
						while(y != null && this.isImplicitArgumentFactor(y)) {
							if(y.getNodeName() == "msup") parentheses = true;
							argument.b += Std.string(this.fullMathML2TextImpl(y));
							y = it.hasNext()?it.next():null;
						}
						if(parentheses) sb.b += Std.string("(");
						sb.b += Std.string(argument.b);
						if(parentheses) sb.b += Std.string(")");
						if(y != null) sb.b += Std.string(this.fullMathML2TextImpl(y));
					}
				}
			}
		}
		return sb.b;
	}
	,mathMLToText: function(mathml) {
		var root = com.wiris.util.xml.WXmlUtils.parseXML(mathml);
		if(root.nodeType == Xml.Document) root = root.firstElement();
		this.removeMrows(root);
		return StringTools.replace(this.fullMathML2TextImpl(root),com.wiris.system.Utf8.uchr(160)," ");
	}
	,isReservedWordPrefix: function(token,words) {
		var i;
		var _g1 = 0, _g = words.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(StringTools.startsWith(words[i1],token)) return true;
		}
		return false;
	}
	,reservedWordTokens: function(elem,words) {
		var it = elem.elements();
		while(it.hasNext()) this.reservedWordTokens(it.next(),words);
		if(com.wiris.quizzes.impl.HTMLTools.MROWS.indexOf("@" + elem.getNodeName() + "@") != -1) {
			var children = new Array();
			it = elem.elements();
			while(it.hasNext()) children.push(it.next());
			var index = 0;
			while(index < children.length) {
				var c = children[index];
				if(c.getNodeName() == "mi") {
					var mis = new Array();
					var mitexts = new Array();
					while(c != null && c.getNodeName() == "mi") {
						var text = com.wiris.util.xml.WXmlUtils.getNodeValue(c.firstChild());
						mitexts.push(text);
						mis.push(c);
						index++;
						c = index < children.length?children[index]:null;
					}
					var k = 0;
					while(k < mis.length) {
						var word = mitexts[k];
						var lastReservedWord = null;
						var j = 0;
						var l = 0;
						while(this.isReservedWordPrefix(word,words)) {
							if(com.wiris.system.ArrayEx.contains(words,word)) {
								lastReservedWord = word;
								l = j;
							}
							j++;
							if(j + k >= mis.length) break;
							word += mitexts[k + j];
						}
						if(lastReservedWord != null) {
							if(mitexts[k] == lastReservedWord) mis[k].set("mathvariant","normal"); else {
								mis[k].removeChild(mis[k].firstChild());
								mis[k].addChild(com.wiris.util.xml.WXmlUtils.createPCData(elem,lastReservedWord));
								var m;
								var _g = 0;
								while(_g < l) {
									var m1 = _g++;
									k++;
									var mi = mis[k];
									elem.removeChild(mi);
								}
							}
						}
						k++;
					}
				} else if(c.getNodeName() == "mn") {
					var first = c;
					index++;
					c = index < children.length?children[index]:null;
					if(c != null && c.getNodeName() == "mn") {
						var mns = new Array();
						var num = new StringBuf();
						num.b += Std.string(com.wiris.util.xml.WXmlUtils.getNodeValue(first.firstChild()));
						while(c != null && c.getNodeName() == "mn") {
							mns.push(c);
							num.b += Std.string(com.wiris.util.xml.WXmlUtils.getNodeValue(c.firstChild()));
							index++;
							c = index < children.length?children[index]:null;
						}
						first.removeChild(first.firstChild());
						first.addChild(com.wiris.util.xml.WXmlUtils.createPCData(first,num.b));
						var m;
						var _g1 = 0, _g = mns.length;
						while(_g1 < _g) {
							var m1 = _g1++;
							elem.removeChild(mns[m1]);
						}
					}
				} else {
					index++;
					c = index < children.length?children[index]:null;
				}
			}
		}
	}
	,restoreFlatMathML: function(elem) {
		var it = elem.elements();
		while(it.hasNext()) this.restoreFlatMathML(it.next());
		if(com.wiris.quizzes.impl.HTMLTools.MROWS.indexOf("@" + elem.getNodeName() + "@") != -1) {
			var children = elem.elements();
			var elements = new Array();
			while(children.hasNext()) elements.push(children.next());
			if(elements.length > 0) {
				var current = elements[0];
				var i = 1;
				while(i < elements.length) {
					var previous = current;
					current = elements[i++];
					if(com.wiris.quizzes.impl.HTMLTools.MSUPS.indexOf("@" + current.getNodeName() + "@") != -1) {
						elem.removeChild(previous);
						current.insertChild(previous,0);
					}
				}
			}
		}
	}
	,removeMrows: function(elem) {
		if(elem.nodeType != Xml.Element && elem.nodeType != Xml.Document) return;
		var children = elem.iterator();
		while(children.hasNext()) this.removeMrows(children.next());
		children = elem.iterator();
		var i = 0;
		while(children.hasNext()) {
			var c = children.next();
			if(c.nodeType == Xml.Element) {
				if(c.getNodeName() == "mrow") {
					var mrowChildren = c.elements();
					var singlechild = false;
					if(mrowChildren.hasNext()) {
						mrowChildren.next();
						singlechild = !mrowChildren.hasNext();
					}
					if(singlechild || com.wiris.quizzes.impl.HTMLTools.MROWS.indexOf(elem.getNodeName()) != -1) {
						elem.removeChild(c);
						var n;
						var count = 0;
						while((n = c.firstChild()) != null) {
							c.removeChild(n);
							elem.insertChild(n,i + count);
							count++;
						}
						if(count != 1) {
							i = -1;
							children = elem.iterator();
						}
					}
				} else if(c.getNodeName() == "mfenced") {
					if("(" == c.get("open")) c.remove("open");
					if(")" == c.get("close")) c.remove("close");
				}
			}
			i++;
		}
	}
	,breakMis: function(elem,pos) {
		if(elem.nodeType != Xml.Element && elem.nodeType != Xml.Document) return;
		var children = elem.iterator();
		var i = 0;
		while(children.hasNext()) {
			this.breakMis(children.next(),i);
			i++;
		}
		if(elem.nodeType == Xml.Element && elem.getNodeName() == "mi") {
			var text = com.wiris.util.xml.WXmlUtils.getNodeValue(elem.firstChild());
			if(com.wiris.system.Utf8.getLength(text) > 1) {
				var p = elem.getParent();
				var mrow = Xml.createElement("mrow");
				p.removeChild(elem);
				p.insertChild(mrow,pos);
				while(text.length > 0) {
					var mi = Xml.createElement("mi");
					var chartext = com.wiris.system.Utf8.sub(text,0,1);
					mi.addChild(com.wiris.util.xml.WXmlUtils.createPCData(elem,chartext));
					text = HxOverrides.substr(text,chartext.length,null);
					mrow.addChild(mi);
				}
			} else elem.remove("mathvariant");
		}
	}
	,flattenMsups: function(elem,pos) {
		if(elem.nodeType != Xml.Element && elem.nodeType != Xml.Document) return;
		var children = elem.iterator();
		var i = 0;
		while(children.hasNext()) {
			this.flattenMsups(children.next(),i);
			i++;
		}
		if(elem.nodeType == Xml.Element && com.wiris.quizzes.impl.HTMLTools.MSUPS.indexOf("@" + elem.getNodeName() + "@") != -1) {
			var n = elem.getParent();
			var mrow = Xml.createElement("mrow");
			var c = elem.firstElement();
			elem.removeChild(c);
			mrow.addChild(c);
			n.removeChild(elem);
			mrow.addChild(elem);
			n.insertChild(mrow,pos);
		}
	}
	,updateReservedWords: function(mathml,words) {
		if(mathml == null || StringTools.trim(mathml) == "") return "";
		mathml = com.wiris.util.xml.WXmlUtils.resolveEntities(mathml);
		var doc = Xml.parse(mathml);
		this.flattenMsups(doc,0);
		this.breakMis(doc,0);
		this.removeMrows(doc);
		this.reservedWordTokens(doc.firstElement(),words);
		this.restoreFlatMathML(doc.firstElement());
		return com.wiris.util.xml.WXmlUtils.serializeXML(doc);
	}
	,getParentTag: function(s,n) {
		var stack = new Array();
		var error = false;
		while((n = s.indexOf("<",n)) != -1 && !error) {
			if(this.isQuizzesIdentifierStart(HxOverrides.cca(s,n + 1))) {
				var close = s.indexOf(">",n);
				var space = s.indexOf(" ",n);
				if(space != -1 && space < close) close = space;
				if(close != -1) stack.push(HxOverrides.substr(s,n + 1,close - n - 1)); else error = true;
			} else if(HxOverrides.cca(s,n + 1) == 47) {
				var close = s.indexOf(">",n);
				var tag = HxOverrides.substr(s,n + 2,close - n - 2);
				if(stack.length == 0) return tag; else if(!(stack.pop() == tag)) error = true;
			} else if(HxOverrides.substr(s,n,4) == "<!--") {
				n = s.indexOf("-->",n);
				if(n == -1) error = true;
			}
			n++;
		}
		return null;
	}
	,isColor: function(s,n) {
		var gfColor = "color\":\"";
		var gfFill = "\"fill\":\"";
		var l = gfColor.length;
		return n > l && (HxOverrides.substr(s,n - l,l) == gfColor || HxOverrides.substr(s,n - l,l) == gfFill);
	}
	,isEntity: function(s,n) {
		if(n > 0 && HxOverrides.cca(s,n - 1) == 38) {
			n++;
			var end = s.indexOf(";",n);
			if(end != -1) {
				while(this.isQuizzesIdentifierPart(HxOverrides.cca(s,n))) n++;
				return n == end;
			}
		}
		return false;
	}
	,variablePosition: function(s,n) {
		if(this.insideTag(s,n) || this.isEntity(s,n) || this.insideComment(s,n) || this.isColor(s,n)) return com.wiris.quizzes.impl.HTMLTools.POSITION_NONE; else {
			var parent = this.getParentTag(s,n);
			if(parent == null) return com.wiris.quizzes.impl.HTMLTools.POSITION_ALL;
			if(parent == "script" || parent == "option") return com.wiris.quizzes.impl.HTMLTools.POSITION_ONLY_TEXT; else if(parent == "style") return com.wiris.quizzes.impl.HTMLTools.POSITION_NONE; else if(parent == "mi" || parent == "mo" || parent == "mtext" || parent == "ms") return com.wiris.quizzes.impl.HTMLTools.POSITION_ONLY_MATHML; else if(parent == "td") return com.wiris.quizzes.impl.HTMLTools.POSITION_TABLE; else return com.wiris.quizzes.impl.HTMLTools.POSITION_ALL;
		}
	}
	,extractTextFromMathML: function(formula) {
		if(formula.indexOf("<mtext") == -1) return formula;
		var allowedTags = ["math","mrow"];
		var stack = new Array();
		var omittedcontent = false;
		var lasttag = null;
		var beginformula = formula.indexOf("<");
		var start;
		var end = 0;
		while(end < formula.length && (start = formula.indexOf("<",end)) != -1) {
			end = formula.indexOf(">",start);
			var tag = HxOverrides.substr(formula,start,end - start + 1);
			var trimmedTag = HxOverrides.substr(formula,start + 1,end - start - 1);
			if(HxOverrides.substr(trimmedTag,trimmedTag.length - 1,null) == "/") continue;
			var spacepos = tag.indexOf(" ");
			if(spacepos != -1) trimmedTag = HxOverrides.substr(tag,1,spacepos - 1);
			if(this.inArray(trimmedTag,allowedTags)) {
				stack.push([trimmedTag,tag]);
				lasttag = trimmedTag;
			} else if(trimmedTag == "/" + lasttag) {
				stack.pop();
				if(stack.length > 0) {
					var lastpair = stack[stack.length - 1];
					lasttag = lastpair[0];
				} else lasttag = null;
				if(stack.length == 0 && !omittedcontent) {
					var formula1 = HxOverrides.substr(formula,0,beginformula);
					if(end < formula.length - 1) {
						var formula2 = HxOverrides.substr(formula,end + 1,null);
						formula = formula1 + formula2;
					} else formula = formula1;
				}
			} else if(trimmedTag == "mtext") {
				var pos2 = formula.indexOf("</mtext>",start);
				var text = HxOverrides.substr(formula,start + 7,pos2 - start - 7);
				text = com.wiris.util.xml.WXmlUtils.resolveEntities(text);
				var nbsp = com.wiris.system.Utf8.uchr(160);
				var nbspLength = nbsp.length;
				if(text.length >= nbspLength) {
					if(HxOverrides.substr(text,0,nbspLength) == nbsp) text = " " + HxOverrides.substr(text,nbspLength,null);
					if(text.length >= nbspLength && HxOverrides.substr(text,text.length - nbspLength,null) == nbsp) text = HxOverrides.substr(text,0,text.length - nbspLength) + " ";
				}
				var formula1 = HxOverrides.substr(formula,0,start);
				var formula2 = HxOverrides.substr(formula,pos2 + 8,null);
				if(omittedcontent) {
					var tail1 = "";
					var head2 = "";
					var i = stack.length - 1;
					while(i >= 0) {
						var pair = stack[i];
						tail1 = tail1 + "</" + pair[0] + ">";
						head2 = pair[1] + head2;
						i--;
					}
					formula1 = formula1 + tail1;
					formula2 = head2 + formula2;
					if(com.wiris.quizzes.impl.MathContent.isEmpty(formula2)) formula2 = "";
					formula = formula1 + text + formula2;
					beginformula = start + tail1.length + text.length;
					end = beginformula + head2.length;
				} else {
					var head = HxOverrides.substr(formula1,0,beginformula);
					var head2 = HxOverrides.substr(formula1,beginformula,null);
					formula2 = head2 + formula2;
					if(com.wiris.quizzes.impl.MathContent.isEmpty(formula2)) formula2 = "";
					formula = head + text + formula2;
					beginformula += text.length;
					end = beginformula + formula1.length;
				}
				omittedcontent = false;
			} else {
				var num = 1;
				var pos = start + tag.length;
				while(num > 0) {
					end = formula.indexOf("</" + trimmedTag + ">",pos);
					var mid = formula.indexOf("<" + trimmedTag,pos);
					if(end == -1) return formula; else if(mid == -1 || end < mid) {
						num--;
						pos = end + ("</" + trimmedTag + ">").length;
					} else {
						pos = mid + ("<" + trimmedTag).length;
						num++;
					}
				}
				end += ("</" + trimmedTag + ">").length;
				omittedcontent = true;
			}
		}
		return formula;
	}
	,ImageB64Url: function(b64) {
		return "data:image/png;base64," + b64;
	}
	,addPlotterImageB64Tag: function(value) {
		var h = new com.wiris.quizzes.impl.HTML();
		h.imageClass(this.ImageB64Url(value),null,"wirisplotter");
		return h.getString();
	}
	,addConstructionImageTag: function(value,width,height) {
		var h = new com.wiris.quizzes.impl.HTML();
		h.openclose("img",[["src",this.plotterLoadingSrc],["alt","Plotter"],["title","Plotter"],["class","wirisconstruction"],["data-wirisconstruction",value],["data-wiriswidth",width + ""],["data-wirisheight",height + ""]]);
		return h.getString();
	}
	,addPlotterImageTag: function(filename) {
		var url;
		if(com.wiris.settings.PlatformSettings.IS_JAVASCRIPT && StringTools.endsWith(filename,".b64")) {
			var s = com.wiris.system.Storage.newStorage(filename);
			url = this.ImageB64Url(s.read());
		} else url = this.proxyUrl + "?service=cache&name=" + filename;
		var h = new com.wiris.quizzes.impl.HTML();
		h.imageClass(url,null,"wirisplotter");
		return h.getString();
	}
	,isTokensMathML: function(mathml) {
		return com.wiris.util.xml.MathMLUtils.isTokensMathML(mathml);
	}
	,textToMathMLImpl: function(text) {
		var n = com.wiris.system.Utf8.getLength(text);
		if(n == 0) return text;
		var mathml = new StringBuf();
		var token;
		var i = 0;
		var c = com.wiris.system.Utf8.charCodeAt(text,i);
		while(i < n) if(com.wiris.util.xml.WCharacterBase.isDigit(c)) {
			token = new StringBuf();
			while(i < n && com.wiris.util.xml.WCharacterBase.isDigit(c)) {
				token.b += String.fromCharCode(c);
				if(++i < n) c = com.wiris.system.Utf8.charCodeAt(text,i);
			}
			mathml.b += Std.string("<mn>");
			mathml.b += Std.string(token.b);
			mathml.b += Std.string("</mn>");
		} else if(com.wiris.util.xml.WCharacterBase.isLetter(c)) {
			token = new StringBuf();
			while(i < n && com.wiris.util.xml.WCharacterBase.isLetter(c)) {
				token.b += Std.string(com.wiris.system.Utf8.uchr(c));
				if(++i < n) c = com.wiris.system.Utf8.charCodeAt(text,i);
			}
			var tok = token.b;
			var tokens;
			if(this.isReservedWord(tok)) tokens = [tok]; else {
				var m = com.wiris.system.Utf8.getLength(tok);
				tokens = new Array();
				var j;
				var _g = 0;
				while(_g < m) {
					var j1 = _g++;
					tokens[j1] = com.wiris.system.Utf8.uchr(com.wiris.system.Utf8.charCodeAt(tok,j1));
				}
			}
			var k;
			var _g1 = 0, _g = tokens.length;
			while(_g1 < _g) {
				var k1 = _g1++;
				mathml.b += Std.string("<mi>");
				mathml.b += Std.string(tokens[k1]);
				mathml.b += Std.string("</mi>");
			}
		} else {
			if(c == 10) mathml.b += Std.string("<mspace linebreak=\"newline\"/>"); else {
				mathml.b += Std.string("<mo>");
				if(c == 160 || c == 32) mathml.b += Std.string("&#xA0;"); else mathml.b += Std.string(com.wiris.util.xml.WXmlUtils.htmlEscape(com.wiris.system.Utf8.uchr(c)));
				mathml.b += Std.string("</mo>");
			}
			if(++i < n) c = com.wiris.system.Utf8.charCodeAt(text,i);
		}
		return mathml.b;
	}
	,textToMathMLWithSemantics: function(text) {
		var mathml = this.textToMathMLImpl(text);
		mathml = "<semantics><mrow>" + mathml + "</mrow><annotation encoding=\"text/plain\">" + text + "</annotation></semantics>";
		var result = com.wiris.quizzes.impl.HTMLTools.addMathTag(mathml);
		return result;
	}
	,textToMathML: function(text) {
		var mathml = this.textToMathMLImpl(text);
		var result = com.wiris.quizzes.impl.HTMLTools.addMathTag(mathml);
		return result;
	}
	,isReservedWord: function(word) {
		return this.isFunctionName(word);
	}
	,isFunctionName: function(word) {
		var functionNames = ["exp","ln","log","sin","sen","cos","tan","tg","asin","arcsin","asen","arcsen","acos","arccos","atan","arctan","cosec","csc","sec","cotan","acosec","acsc","asec","acotan","sinh","senh","cosh","tanh","asinh","arcsinh","asenh","arcsenh","acosh","arccosh","atanh","arctanh","cosech","csch","sech","cotanh","acosech","acsch","asech","acotanh","sign"];
		return this.inArray(word,functionNames) || this.inArray(word,com.wiris.quizzes.impl.ActionCommands.COMMANDS);
	}
	,toSubFormula: function(mathml) {
		mathml = com.wiris.util.xml.MathMLUtils.stripRootTag(mathml,"math");
		return "<mrow>" + mathml + "</mrow>";
	}
	,inArray: function(value,array) {
		var i;
		var _g1 = 0, _g = array.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(array[i1] == value) return true;
		}
		return false;
	}
	,prepareFormulas: function(text) {
		var start = 0;
		while((start = text.indexOf("<math",start)) != -1) {
			if(text.indexOf("/>",start) != -1 && text.indexOf("/>",start) < text.indexOf(">",start)) {
				start = text.indexOf(">",start) + 1;
				continue;
			}
			var length = text.indexOf("</math>",start) - start + "</math>".length;
			var formula = HxOverrides.substr(text,start,length);
			var pos = 0;
			while((pos = formula.indexOf("#",pos)) != -1) {
				var initag = pos;
				while(initag >= 0 && HxOverrides.cca(formula,initag) != 60) initag--;
				var parentpos = initag;
				var parenttag = null;
				var parenttagname = null;
				while(parenttag == null) {
					while(parentpos >= 2 && HxOverrides.cca(formula,parentpos - 2) == 47 && HxOverrides.cca(formula,parentpos - 1) == 62) {
						parentpos -= 2;
						while(parentpos >= 0 && HxOverrides.cca(formula,parentpos) != 60) parentpos--;
					}
					parentpos--;
					while(parentpos >= 0 && HxOverrides.cca(formula,parentpos) != 60) parentpos--;
					if(HxOverrides.cca(formula,parentpos) == 60 && HxOverrides.cca(formula,parentpos + 1) == 47) {
						var namepos = parentpos + "</".length;
						var character = HxOverrides.cca(formula,namepos);
						var nameBuf = new StringBuf();
						while(this.isQuizzesIdentifierPart(character)) {
							nameBuf.b += String.fromCharCode(character);
							namepos++;
							character = HxOverrides.cca(formula,namepos);
						}
						var name = nameBuf.b;
						var depth = 1;
						var namelength = name.length;
						while(depth > 0 && parentpos >= 0) {
							var currentTagName = HxOverrides.substr(formula,parentpos,namelength);
							if(name == currentTagName) {
								var currentStartTag = HxOverrides.substr(formula,parentpos - "<".length,namelength + "<".length);
								if("<" + name == currentStartTag && formula.indexOf(">",parentpos) < formula.indexOf("/",parentpos)) depth--; else {
									var currentOpenCloseTag = HxOverrides.substr(formula,parentpos - "</".length,namelength + "</".length);
									if("</" + name == currentOpenCloseTag) depth++;
								}
							}
							if(depth > 0) parentpos--; else parentpos -= "<".length;
						}
						if(depth > 0) return text;
					} else {
						parenttag = HxOverrides.substr(formula,parentpos,formula.indexOf(">",parentpos) - parentpos + 1);
						parenttagname = HxOverrides.substr(parenttag,1,parenttag.length - 2);
						if(parenttagname.indexOf(" ") != -1) parenttagname = HxOverrides.substr(parenttagname,0,parenttagname.indexOf(" "));
					}
				}
				if(com.wiris.quizzes.impl.HTMLTools.MROWS.indexOf("@" + parenttagname + "@") != -1) {
					var firstchar = true;
					var appendpos = pos + 1;
					var character = com.wiris.util.xml.WXmlUtils.getUtf8Char(formula,appendpos);
					while(this.isQuizzesIdentifierStart(character) || this.isQuizzesIdentifierPart(character) && !firstchar) {
						appendpos += com.wiris.system.Utf8.uchr(character).length;
						character = com.wiris.util.xml.WXmlUtils.getUtf8Char(formula,appendpos);
						firstchar = false;
					}
					if(HxOverrides.cca(formula,appendpos) != 60) {
						pos++;
						continue;
					}
					var nextpos = formula.indexOf(">",pos);
					var end = false;
					while(!end && nextpos != -1 && pos + ">".length < formula.length) {
						nextpos += ">".length;
						var nexttaglength = formula.indexOf(">",nextpos) - nextpos + ">".length;
						var nexttag = HxOverrides.substr(formula,nextpos,nexttaglength);
						var nexttagname = HxOverrides.substr(nexttag,1,nexttag.length - 2);
						if(nexttagname.indexOf(" ") != -1) nexttagname = HxOverrides.substr(nexttagname,0,nexttagname.indexOf(" "));
						var specialtag = null;
						var speciallength = 0;
						if(nexttagname == "msup" || nexttagname == "msub" || nexttagname == "msubsup") {
							specialtag = nexttag;
							speciallength = nexttaglength;
							nextpos = nextpos + nexttaglength;
							nexttaglength = formula.indexOf(">",nextpos) - nextpos + ">".length;
							nexttag = HxOverrides.substr(formula,nextpos,nexttaglength);
							nexttagname = HxOverrides.substr(nexttag,1,nexttag.length - 2);
							if(nexttagname.indexOf(" ") != -1) nexttagname = HxOverrides.substr(nexttagname,0,nexttagname.indexOf(" "));
						}
						if(nexttagname == "mi" || nexttagname == "mn" || nexttagname == "mo") {
							var contentpos = nextpos + nexttaglength;
							var toappend = new StringBuf();
							character = com.wiris.util.xml.WXmlUtils.getUtf8Char(formula,contentpos);
							while(this.isQuizzesIdentifierStart(character) || this.isQuizzesIdentifierPart(character) && !firstchar) {
								var charstr = com.wiris.system.Utf8.uchr(character);
								contentpos += charstr.length;
								toappend.b += Std.string(charstr);
								character = com.wiris.util.xml.WXmlUtils.getUtf8Char(formula,contentpos);
								firstchar = false;
							}
							var toAppendStr = toappend.b;
							var nextclosepos = formula.indexOf("<",contentpos);
							var nextcloseend = formula.indexOf(">",nextclosepos) + ">".length;
							if(toAppendStr.length == 0) end = true; else if(nextclosepos != contentpos) {
								var content = HxOverrides.substr(formula,contentpos,nextclosepos - contentpos);
								var nextclosetag = HxOverrides.substr(formula,nextclosepos,nextcloseend - nextclosepos);
								var newnexttag = nexttag + content + nextclosetag;
								formula = HxOverrides.substr(formula,0,nextpos) + newnexttag + HxOverrides.substr(formula,nextcloseend,null);
								formula = HxOverrides.substr(formula,0,appendpos) + toAppendStr + HxOverrides.substr(formula,appendpos,null);
								end = true;
							} else {
								formula = HxOverrides.substr(formula,0,nextpos) + HxOverrides.substr(formula,nextcloseend,null);
								formula = HxOverrides.substr(formula,0,appendpos) + toAppendStr + HxOverrides.substr(formula,appendpos,null);
								if(specialtag != null) {
									var fulltaglength = formula.indexOf(">",appendpos) + ">".length - initag;
									formula = HxOverrides.substr(formula,0,initag) + specialtag + HxOverrides.substr(formula,initag,fulltaglength) + HxOverrides.substr(formula,initag + fulltaglength + speciallength,null);
									end = true;
								}
							}
							appendpos += toAppendStr.length;
						} else end = true;
						if(!end) nextpos = formula.indexOf(">",pos);
					}
				}
				pos++;
			}
			text = HxOverrides.substr(text,0,start) + formula + HxOverrides.substr(text,start + length,null);
			start = start + formula.length;
		}
		return text;
	}
	,sortIterator: function(it) {
		var sorted = new Array();
		while(it.hasNext()) {
			var a = it.next();
			var j = 0;
			while(j < sorted.length) {
				if(com.wiris.quizzes.impl.HTMLTools.compareStrings(sorted[j],a) > 0) break;
				j++;
			}
			sorted.splice(j,0,a);
		}
		return sorted;
	}
	,getPlaceHolder: function(name) {
		return "#" + name;
	}
	,insideComment: function(html,pos) {
		var beginComment = this.lastIndexOf(html,"<!--",pos);
		if(beginComment != -1) {
			var endComment = this.lastIndexOf(html,"-->",pos);
			return endComment < beginComment;
		}
		return false;
	}
	,lastIndexOf: function(src,str,pos) {
		return HxOverrides.substr(src,0,pos).lastIndexOf(str);
	}
	,insideTag: function(html,pos) {
		var beginTag = this.lastIndexOf(html,"<",pos);
		while(beginTag != -1 && !this.isQuizzesIdentifierStart(HxOverrides.cca(html,beginTag + 1))) {
			if(beginTag == 0) return false;
			beginTag = this.lastIndexOf(html,"<",beginTag - 1);
		}
		if(beginTag == -1) return false;
		var endTag = html.indexOf(">",beginTag);
		return endTag > pos;
	}
	,isQuizzesIdentifierPart: function(c) {
		return this.isQuizzesIdentifierStart(c) || com.wiris.util.xml.WCharacterBase.isDigit(c);
	}
	,isQuizzesIdentifierStart: function(c) {
		return com.wiris.util.xml.WCharacterBase.isLetter(c) || c == 95;
	}
	,isQuizzesIdentifier: function(s) {
		if(s == null) return false;
		var i = com.wiris.system.Utf8.getIterator(s);
		if(!i.hasNext()) return false;
		if(!this.isQuizzesIdentifierStart(i.next())) return false;
		while(i.hasNext()) if(!this.isQuizzesIdentifierPart(i.next())) return false;
		return true;
	}
	,getVariableName: function(html,pos) {
		var name = null;
		if(HxOverrides.cca(html,pos) == 35) {
			var end = pos + 1;
			if(end < html.length) {
				var c = com.wiris.util.xml.WXmlUtils.getUtf8Char(html,end);
				if(this.isQuizzesIdentifierStart(c)) {
					end += com.wiris.system.Utf8.uchr(c).length;
					if(end < html.length) {
						c = com.wiris.util.xml.WXmlUtils.getUtf8Char(html,end);
						while(c > 0 && this.isQuizzesIdentifierPart(c)) {
							end += com.wiris.system.Utf8.uchr(c).length;
							c = end < html.length?com.wiris.util.xml.WXmlUtils.getUtf8Char(html,end):-1;
						}
					}
					name = HxOverrides.substr(html,pos + 1,end - (pos + 1));
				}
			}
		}
		return name;
	}
	,replaceVariablesInsideHTMLTables: function(html,variables) {
		var h = new com.wiris.quizzes.impl.HTMLTableTools(this.separator);
		return h.replaceVariablesInsideHTMLTables(html,variables);
	}
	,replaceVariablesInsideHTML: function(token,variables,type,escapeText) {
		var mathml = type == com.wiris.quizzes.impl.MathContent.TYPE_MATHML;
		var text = type == com.wiris.quizzes.impl.MathContent.TYPE_TEXT;
		var imageRef = type == com.wiris.quizzes.impl.MathContent.TYPE_IMAGE_REF;
		var imageData = type == com.wiris.quizzes.impl.MathContent.TYPE_IMAGE;
		var construction = type == com.wiris.quizzes.impl.MathContent.TYPE_GEOMETRY_FILE;
		var keys = this.sortIterator(variables.keys());
		var j = keys.length - 1;
		while(j >= 0) {
			var name = keys[j];
			var placeholder = this.getPlaceHolder(name);
			var formula = null;
			var posFormula = 0;
			var oldName = null;
			var oldValue = null;
			if(name.indexOf("_") > 0 && token.indexOf(name) != -1 && variables.get(name).indexOf(name) != -1) {
				oldName = name;
				name = HxOverrides.substr(name,0,name.indexOf("_"));
				if(this.assertTextSyntax(oldName)) formula = this.replaceTextWithMathml(oldName);
				HxOverrides.remove(keys,oldName);
			}
			var pos = 0;
			while((pos = token.indexOf(placeholder,pos)) != -1) {
				var v = this.variablePosition(token,pos);
				if((v == com.wiris.quizzes.impl.HTMLTools.POSITION_ALL || v == com.wiris.quizzes.impl.HTMLTools.POSITION_TABLE || text && v == com.wiris.quizzes.impl.HTMLTools.POSITION_ONLY_TEXT || mathml && v == com.wiris.quizzes.impl.HTMLTools.POSITION_ONLY_MATHML) && (name == this.getVariableName(token,pos) || oldName != null && oldName == this.getVariableName(token,pos))) {
					var value = variables.get(name);
					if(text && escapeText) value = com.wiris.util.xml.WXmlUtils.htmlEscape(value); else if(mathml) {
						if(oldName != null) {
							if(formula != null) {
								posFormula = formula.indexOf(this.getPlaceHolder(name),posFormula);
								var itemSelector = this.isPartOfMatrixVectorOrList(formula,value,posFormula);
								try {
									value = this.selectElementOfArray(value,itemSelector,formula,posFormula);
								} catch( t ) {
									itemSelector = com.wiris.quizzes.impl.HTMLTools.NOT_A_SELECTOR;
								}
								value = "<mrow>" + HxOverrides.substr(value,"<math>".length,value.length - "<math></math>".length) + "</mrow>";
								var array = this.returnFormula(formula,value,this.getPlaceHolder(name),itemSelector,posFormula);
								value = array[0];
								value = this.extractTextFromMathML(value);
							} else {
								value = variables.get(oldName) != null?variables.get(oldName):oldValue;
								oldValue = value;
								value = com.wiris.quizzes.impl.HTMLTools.addMathTag(value);
								value = this.extractTextFromMathML(value);
							}
						} else {
							value = com.wiris.quizzes.impl.HTMLTools.addMathTag(value);
							value = this.extractTextFromMathML(value);
						}
					} else if(imageRef) value = this.addPlotterImageTag(value); else if(imageData) value = this.addPlotterImageB64Tag(value); else if(construction) {
						var width = 450;
						var height = 450;
						if(oldName != null && formula != null) {
							var parts = oldName.split("_");
							if(parts.length == 2) {
								var square = parts[1];
								var squareInt = Std.parseInt(square);
								if(squareInt > 0) {
									width = squareInt;
									height = squareInt;
								}
							} else if(parts.length == 3) {
								var fst = parts[1];
								var snd = parts[2];
								var fstInt = Std.parseInt(fst);
								var sndInt = Std.parseInt(snd);
								if(fstInt > 0 && sndInt > 0) {
									width = fstInt;
									height = sndInt;
								}
							}
						}
						value = this.addConstructionImageTag(value,width,height);
					}
					token = HxOverrides.substr(token,0,pos) + value + HxOverrides.substr(token,pos + placeholder.length,null);
					if(value != null) pos += value.length;
				} else pos++;
			}
			j--;
		}
		return token;
	}
	,checkSubstringParameterAnswer: function(formula,name,lastPos,pos) {
		if(this.answerKeyword == null) return true;
		if(formula.indexOf(this.getPlaceHolder(this.answerKeyword),lastPos) != pos) return true;
		return name.indexOf(this.answerKeyword) != -1;
	}
	,failOnOutOfBounds: function(outOfBounds) {
		if(outOfBounds) throw "Out of bounds";
	}
	,selectElementOfArray: function(value,itemSelector,formula,pos) {
		if(itemSelector == com.wiris.quizzes.impl.HTMLTools.NOT_A_SELECTOR) return value;
		var positionToBeWritten = this.position(formula,pos);
		if(positionToBeWritten[0] == -1) throw "Positions are not integers!";
		if(itemSelector == com.wiris.quizzes.impl.HTMLTools.SELECTOR_2D) {
			if(this.isPosition(formula,pos)) return this.returnPositionOfElementOfArray(value.indexOf("<mtr>"),value,itemSelector,positionToBeWritten); else return this.returnRowOfElementOfArray(value.indexOf("<mtr>"),value,itemSelector,positionToBeWritten);
		} else {
			var iniWant = value.indexOf("<mrow>",value.indexOf("open"));
			if(value.indexOf("<mrow>",iniWant + 1) != -1) {
				iniWant = value.indexOf("<mrow>",iniWant + 1) + "<mrow>".length;
				if(this.isPosition(formula,pos)) return this.returnPositionOfElementOfArray(iniWant,value,itemSelector,positionToBeWritten); else return this.returnRowOfElementOfArray(iniWant,value,itemSelector,positionToBeWritten);
			} else {
				var outOfBounds = iniWant == -1;
				iniWant += "<mrow>".length;
				var k = 0;
				while(k < positionToBeWritten[0] - 1 && !outOfBounds) {
					iniWant = value.indexOf(this.separator,iniWant + 1);
					outOfBounds = iniWant == -1;
					k++;
				}
				if(k != 0) iniWant += this.separator.length + "</mo>".length;
				var endWant = value.indexOf(this.separator,iniWant) - "<mo>".length;
				if(endWant < 0) endWant = value.indexOf("</mrow></mfenced>");
				outOfBounds = outOfBounds || endWant == -1;
				this.failOnOutOfBounds(outOfBounds);
				var block = HxOverrides.substr(value,iniWant,endWant - iniWant);
				return "<mrow>" + block + "</mrow>";
			}
		}
	}
	,returnRowOfElementOfArray: function(iniWant,value,itemSelector,positionToBeWritten) {
		var outOfBounds = false;
		var rowStart = itemSelector == com.wiris.quizzes.impl.HTMLTools.SELECTOR_2D?"<mtr>":"<mrow>";
		var rowFinish = itemSelector == com.wiris.quizzes.impl.HTMLTools.SELECTOR_2D?"</mtr>":"</mrow>";
		var endWant = value.indexOf(rowFinish);
		var k = 0;
		while(k < positionToBeWritten[0] - 1 && !outOfBounds) {
			iniWant = value.indexOf(rowStart,iniWant + 1);
			endWant = value.indexOf(rowFinish,endWant + 1);
			outOfBounds = iniWant == -1 || endWant == -1;
			k++;
		}
		this.failOnOutOfBounds(outOfBounds);
		if(itemSelector == com.wiris.quizzes.impl.HTMLTools.SELECTOR_2D) endWant += rowFinish.length;
		var blockFromStartToEndWant = HxOverrides.substr(value,0,endWant);
		var isVector = blockFromStartToEndWant.lastIndexOf("]") != -1 && blockFromStartToEndWant.lastIndexOf("]") == this.maxValue(blockFromStartToEndWant.lastIndexOf("]"),blockFromStartToEndWant.lastIndexOf("}"));
		var block = HxOverrides.substr(value,iniWant,endWant - iniWant);
		return itemSelector == com.wiris.quizzes.impl.HTMLTools.SELECTOR_2D?"<mrow><mfenced><mtable>" + block + "</mtable></mfenced></mrow>":isVector?"<mrow><mrow><mfenced close=\"]\" open=\"[\"><mrow>" + block + "</mrow></mfenced></mrow></mrow>":"<mrow><mrow><mfenced close=\"}\" open=\"{\"><mrow>" + block + "</mrow></mfenced></mrow></mrow>";
	}
	,returnPositionOfElementOfArray: function(iniWant,value,itemSelector,positionToBeWritten) {
		var outOfBounds = false;
		var rowStart = itemSelector == com.wiris.quizzes.impl.HTMLTools.SELECTOR_2D?"<mtr>":"<mrow>";
		var rowFinish = itemSelector == com.wiris.quizzes.impl.HTMLTools.SELECTOR_2D?"</mtr>":"</mrow>";
		var elementStart = itemSelector == com.wiris.quizzes.impl.HTMLTools.SELECTOR_2D?"<mtd>":this.separator;
		var elementFinish = itemSelector == com.wiris.quizzes.impl.HTMLTools.SELECTOR_2D?"</mtd>":this.separator;
		var k = 0;
		while(k < positionToBeWritten[0] - 1 && !outOfBounds) {
			iniWant = value.indexOf(rowStart,iniWant + 1);
			outOfBounds = iniWant == -1;
			k++;
		}
		this.failOnOutOfBounds(outOfBounds);
		value = HxOverrides.substr(value,0,value.indexOf(rowFinish,iniWant));
		iniWant = itemSelector == com.wiris.quizzes.impl.HTMLTools.SELECTOR_2D?value.indexOf(elementStart,iniWant):this.minValue(value.indexOf(elementStart,iniWant),this.minValue(value.indexOf("<mn>",iniWant),value.indexOf("<mi>",iniWant)));
		outOfBounds = iniWant == -1;
		k = 0;
		while(k < positionToBeWritten[1] - 1 && !outOfBounds) {
			iniWant = value.indexOf(elementStart,iniWant + 1);
			outOfBounds = iniWant == -1;
			k++;
		}
		if(itemSelector == com.wiris.quizzes.impl.HTMLTools.SELECTOR_2D) iniWant += elementStart.length; else if(k != 0) iniWant += this.separator.length + "</mo>".length;
		var endWant = value.indexOf(elementFinish,iniWant);
		if(itemSelector == com.wiris.quizzes.impl.HTMLTools.SELECTOR_1D) {
			endWant = value.indexOf(this.separator,iniWant) - "<mo>".length;
			if(endWant < 0) endWant = value.length;
		}
		outOfBounds = outOfBounds || endWant == -1;
		this.failOnOutOfBounds(outOfBounds);
		var block = HxOverrides.substr(value,iniWant,endWant - iniWant);
		return "<mrow>" + block + "</mrow>";
	}
	,returnFormula: function(formula,value,placeholder,itemSelector,pos) {
		var splittag = false;
		var formula1 = HxOverrides.substr(formula,0,pos);
		var formula2 = HxOverrides.substr(formula,pos + placeholder.length,null);
		if(itemSelector != com.wiris.quizzes.impl.HTMLTools.NOT_A_SELECTOR) {
			var newPosition = formula1.lastIndexOf("<msub>");
			var target = HxOverrides.substr(formula1,newPosition,"<msub>".length);
			if(newPosition != -1) formula1 = com.wiris.util.type.StringUtils.replaceLastOccurrence(formula1,target,"");
			var targetPosition1 = formula2.indexOf("<mn>");
			var targetPosition2 = formula2.indexOf("</msub>") + "</msub>".length;
			target = HxOverrides.substr(formula2,targetPosition1,targetPosition2 - targetPosition1);
			formula2 = com.wiris.util.type.StringUtils.replaceFirstOccurrence(formula2,target,"");
			if(itemSelector == com.wiris.quizzes.impl.HTMLTools.SELECTOR_2D && this.isPosition(formula,pos)) {
				newPosition = formula2.indexOf("<mrow>");
				target = HxOverrides.substr(formula2,newPosition,"<mrow>".length);
				if(newPosition != -1) formula2 = com.wiris.util.type.StringUtils.replaceFirstOccurrence(formula2,target,"");
			}
		}
		var openTag1 = formula1.lastIndexOf("<");
		var closeTag1 = formula1.lastIndexOf(">");
		var openTag2 = formula2.indexOf("<");
		var closeTag2 = formula2.indexOf(">");
		var after = "";
		var before = "";
		if(closeTag1 + 1 < formula1.length) {
			splittag = true;
			var closeTag = HxOverrides.substr(formula2,openTag2,closeTag2 - openTag2 + 1);
			before = HxOverrides.substr(formula1,openTag1,null) + closeTag;
		}
		if(openTag2 > 0) {
			splittag = true;
			var openTag = HxOverrides.substr(formula1,openTag1,closeTag1 - openTag1 + 1);
			after = openTag + HxOverrides.substr(formula2,0,closeTag2 + 1);
		}
		var tag1 = HxOverrides.substr(formula1,openTag1,closeTag1 + 1 - openTag1);
		var isAnnotation = StringTools.startsWith(tag1,"<annotation");
		var space = tag1.indexOf(" ");
		if(space != -1 || isAnnotation) {
			var attribs = space != -1?" " + HxOverrides.substr(tag1,space + 1,tag1.length - 1 - (space + 1)):"";
			var replaceTag = isAnnotation?"annotation":"mstyle";
			if(attribs == " encoding=\"text/plain\"") value = this.mathMLToText(value);
			value = "<" + replaceTag + attribs + ">" + value + "</" + replaceTag + ">";
		}
		formula1 = HxOverrides.substr(formula1,0,openTag1);
		formula2 = HxOverrides.substr(formula2,closeTag2 + 1,null);
		if(splittag) formula = formula1 + "<mrow>" + before + value + after + "</mrow>" + formula2; else formula = formula1 + value + formula2;
		var array = new Array();
		array.push(formula);
		array.push(value);
		return array;
	}
	,replaceMathMLVariablesInsideMathML: function(formula,variables) {
		var keys = this.sortIterator(variables.keys());
		var j = keys.length - 1;
		while(j >= 0) {
			var name = keys[j];
			var placeholder = this.getPlaceHolder(name);
			var pos = 0;
			var lastPos = 0;
			while((pos = formula.indexOf(placeholder,pos)) != -1) {
				if(this.variablePosition(formula,pos) >= 2 && this.checkSubstringParameterAnswer(formula,name,lastPos,pos)) {
					var value = this.toSubFormula(variables.get(name));
					var itemSelector = this.isPartOfMatrixVectorOrList(formula,value,pos);
					try {
						value = this.selectElementOfArray(value,itemSelector,formula,pos);
					} catch( t ) {
						itemSelector = com.wiris.quizzes.impl.HTMLTools.NOT_A_SELECTOR;
					}
					var array = this.returnFormula(formula,value,placeholder,itemSelector,pos);
					formula = array[0];
				}
				pos++;
				lastPos = pos;
			}
			j--;
		}
		return formula;
	}
	,fixPlottersWithDimensions: function(variables) {
		var v = variables.get(com.wiris.quizzes.impl.MathContent.TYPE_GEOMETRY_FILE);
		var plotters = v.keys();
		while(plotters.hasNext()) {
			var plotter = plotters.next();
			var mathmlV = variables.get(com.wiris.quizzes.impl.MathContent.TYPE_MATHML);
			if(mathmlV != null) {
				var mathmls = mathmlV.keys();
				while(mathmls.hasNext()) {
					var mathml = mathmls.next();
					if(StringTools.startsWith(mathml,plotter + "_") && mathmlV.get(mathml).indexOf(mathml) != -1) {
						var parts = mathml.split("_");
						if(parts.length == 2 && Std.parseInt(parts[1]) > 0 || parts.length == 3 && Std.parseInt(parts[1]) > 0 && Std.parseInt(parts[2]) > 0) {
							v.set(mathml,mathmlV.get(mathml));
							mathmlV.remove(mathml);
						}
					}
				}
			}
		}
		return v;
	}
	,maxValue: function(a,b) {
		if(a == -1 && b != -1) return b;
		if(a != -1 && b == -1) return a;
		if(a == -1 && b == -1) return -1;
		return Math.max(a,b) | 0;
	}
	,minValue: function(a,b) {
		if(a == -1 && b != -1) return b;
		if(a != -1 && b == -1) return a;
		if(a == -1 && b == -1) return -1;
		return Math.min(a,b) | 0;
	}
	,position: function(formula,pos) {
		var x;
		var y = -1;
		var posX = formula.indexOf("<mn>",pos) + "<mn>".length;
		if(this.isPosition(formula,pos)) {
			var posY = formula.indexOf("<mn>",posX) + "<mn>".length;
			var valueStringX = HxOverrides.substr(formula,posX,formula.indexOf("</mn>",posX) - posX);
			x = com.wiris.util.type.IntegerTools.isInt(valueStringX)?Std.parseInt(valueStringX):-1;
			var valueStringY = HxOverrides.substr(formula,posY,formula.indexOf("</mn>",posY) - posY);
			y = com.wiris.util.type.IntegerTools.isInt(valueStringY)?Std.parseInt(valueStringY):-1;
			var start = formula.indexOf("</mn>",posX) + "</mn><mo>".length;
			var finish = posY - "</mo><mn>".length;
			if(start > finish || HxOverrides.substr(formula,start,finish - start).indexOf(this.separator) == -1) {
				x = -1;
				y = -1;
			}
		} else {
			var valueStringX = HxOverrides.substr(formula,posX,formula.indexOf("</mn>",posX) - posX);
			x = com.wiris.util.type.IntegerTools.isInt(valueStringX)?Std.parseInt(valueStringX):-1;
		}
		return [x,y];
	}
	,isPosition: function(formula,pos) {
		return (formula.indexOf("<mo>,</mo>") != -1 || formula.indexOf("<mo>;</mo>") != -1) && StringTools.startsWith(HxOverrides.substr(formula,formula.indexOf("</mn>",pos) + "</mn>".length,null),"<mo>,</mo>") || StringTools.startsWith(HxOverrides.substr(formula,formula.indexOf("</mn>",pos) + "</mn>".length,null),"<mo>;</mo>");
	}
	,isPartOfMatrixVectorOrList: function(formula,value,pos) {
		if(formula.indexOf("<msub>") != -1 && StringTools.startsWith(HxOverrides.substr(formula,pos - "<mo>".length - "<msub>".length,null),"<msub>")) {
			if(value.indexOf("<mtable><mtr>") != -1 && this.isPosition(formula,pos) && StringTools.startsWith(HxOverrides.substr(formula,pos - "<mo>".length - "<msub>".length,null),"<msub>") && StringTools.startsWith(HxOverrides.substr(formula,formula.indexOf("</mo>",pos) + "</mo>".length,null),"<mrow><mn>") && (formula.indexOf("<mo>,</mo>") != -1 || formula.indexOf("<mo>;</mo>") != -1) && StringTools.startsWith(HxOverrides.substr(formula,formula.indexOf("</mn>",pos) + "</mn>".length,null),"<mo>,</mo>") && StringTools.startsWith(HxOverrides.substr(formula,this.minValue(formula.indexOf("<mo>,</mo>",pos),formula.indexOf("<mo>;</mo>",pos)) + "<mo>,</mo>".length,null),"<mn>") && StringTools.startsWith(HxOverrides.substr(formula,formula.indexOf("</mn>",this.minValue(formula.indexOf("<mo>,</mo>",pos),formula.indexOf("<mo>;</mo>",pos))) + "</mn>".length,null),"</mrow></msub>")) return com.wiris.quizzes.impl.HTMLTools.SELECTOR_2D;
			if(value.indexOf("<mtable><mtr>") != -1 && !this.isPosition(formula,pos) && (StringTools.startsWith(HxOverrides.substr(formula,pos - "<mo>".length - "<msub>".length,null),"<msub>") && StringTools.startsWith(HxOverrides.substr(formula,formula.indexOf("</mo>",pos) + "</mo>".length,null),"<mn>") && StringTools.startsWith(HxOverrides.substr(formula,formula.indexOf("</mn>",pos) + "</mn>".length,null),"</msub>"))) return com.wiris.quizzes.impl.HTMLTools.SELECTOR_2D;
			if((value.indexOf("[") != -1 || value.indexOf("{") != -1) && (StringTools.startsWith(HxOverrides.substr(formula,pos - "<mo>".length - "<msub>".length,null),"<msub>") && StringTools.startsWith(HxOverrides.substr(formula,formula.indexOf("</mo>",pos) + "</mo>".length,null),"<mn>") || StringTools.startsWith(HxOverrides.substr(formula,formula.indexOf("</mo>",pos) + "</mo>".length,null),"<mrow>"))) return com.wiris.quizzes.impl.HTMLTools.SELECTOR_1D;
		}
		return com.wiris.quizzes.impl.HTMLTools.NOT_A_SELECTOR;
	}
	,splitHTMLbyMathML: function(html) {
		var tokens = new Array();
		var start = 0;
		var end = 0;
		while((start = html.indexOf("<math",end)) != -1) {
			if(start - end > 0) tokens.push(HxOverrides.substr(html,end,start - end));
			var firstClose = html.indexOf(">",start);
			if(firstClose != -1 && HxOverrides.substr(html,firstClose - 1,1) == "/") end = firstClose + 1; else end = html.indexOf("</math>",start) + "</math>".length;
			tokens.push(HxOverrides.substr(html,start,end - start));
			if(end + "</p><p>".length <= html.length && !StringTools.startsWith(HxOverrides.substr(html,end + "</p><p>".length,null),"<math") && !StringTools.startsWith(HxOverrides.substr(html,end,null),"<math") && end + "</p>".length >= html.length + 1) {
				if(StringTools.startsWith(HxOverrides.substr(html,end,null),"</p>")) {
					tokens.push("</p>");
					start = html.indexOf("<p>",end);
					end = html.indexOf("</p>",start);
					tokens.push(HxOverrides.substr(html,start,end - start));
					start = html.indexOf("<p>",end);
					end = html.indexOf("</p>",start);
				} else {
					start = end;
					end = HxOverrides.substr(html,start,null).indexOf("<math") != -1?this.minValue(html.indexOf("<math",start),html.indexOf("</p>",start)):html.indexOf("</p>",start);
					tokens.push(HxOverrides.substr(html,start,end - start));
					start = end;
					end = HxOverrides.substr(html,start,null).indexOf("<math") != -1?this.minValue(html.indexOf("<math",start),html.indexOf("</p>",start)):html.indexOf("</p>",start);
				}
			}
		}
		if(end < html.length) tokens.push(HxOverrides.substr(html,end,null));
		return tokens;
	}
	,assertTextSyntax: function(name) {
		var first = name.indexOf("_");
		var second = name.lastIndexOf("_");
		if(StringTools.startsWith(HxOverrides.substr(name,first + 1,null),"_") || first + 1 == name.length || StringTools.startsWith(HxOverrides.substr(name,second - 1,null),"_") || second + 1 == name.length) return false;
		return true;
	}
	,replaceTextWithMathml: function(name) {
		var previous = "<math xmlns=\"http://www.w3.org/1998/Math/MathML\"><msub><mo>#";
		var end = "</msub></math>";
		var variableName = HxOverrides.substr(name,0,name.indexOf("_"));
		if(name.indexOf("_",name.indexOf("_") + 1) != -1) {
			var first = name.indexOf("_");
			var second = name.indexOf("_",name.indexOf("_") + 1);
			var subscript1 = HxOverrides.substr(name,first + 1,second - (first + 1));
			var openTag1 = com.wiris.util.type.IntegerTools.isInt(subscript1)?"<mn>":"<mi>";
			var closeTag1 = com.wiris.util.type.IntegerTools.isInt(subscript1)?"</mn>":"</mi>";
			var subscript2 = HxOverrides.substr(name,second + 1,null);
			var openTag2 = com.wiris.util.type.IntegerTools.isInt(subscript2)?"<mn>":"<mi>";
			var closeTag2 = com.wiris.util.type.IntegerTools.isInt(subscript2)?"</mn>":"</mi>";
			return previous + variableName + "</mo><mrow>" + openTag1 + subscript1 + closeTag1 + "<mo>,</mo>" + openTag2 + subscript2 + closeTag2 + "</mrow>" + end;
		} else {
			var subscript = HxOverrides.substr(name,name.indexOf("_") + 1,null);
			var openTag = com.wiris.util.type.IntegerTools.isInt(subscript)?"<mn>":"<mi>";
			var closeTag = com.wiris.util.type.IntegerTools.isInt(subscript)?"</mn>":"</mi>";
			return previous + variableName + "</mo>" + openTag + subscript + closeTag + end;
		}
	}
	,expandVariables: function(html,variables) {
		if(variables == null || html.indexOf("#") == -1) return html;
		html = this.extractActionExpressions(html,null);
		var encoded = this.isMathMLEncoded(html);
		if(encoded) html = this.decodeMathML(html);
		html = com.wiris.util.xml.WXmlUtils.resolveEntities(html);
		html = this.prepareFormulas(html);
		html = this.replaceVariablesInsideHTMLTables(html,variables);
		var tokens = this.splitHTMLbyMathML(html);
		var sb = new StringBuf();
		var _g1 = 0, _g = tokens.length;
		while(_g1 < _g) {
			var i = _g1++;
			var token = tokens[i];
			var v;
			if(StringTools.startsWith(token,"<math")) {
				v = variables.get(com.wiris.quizzes.impl.MathContent.TYPE_MATHML);
				if(v != null) token = this.replaceMathMLVariablesInsideMathML(token,v);
				v = variables.get(com.wiris.quizzes.impl.MathContent.TYPE_TEXT);
				if(v != null) token = this.replaceMathMLVariablesInsideMathML(token,v);
			} else {
				v = variables.get(com.wiris.quizzes.impl.MathContent.TYPE_IMAGE_REF);
				if(v != null) token = this.replaceVariablesInsideHTML(token,v,com.wiris.quizzes.impl.MathContent.TYPE_IMAGE_REF,true);
				v = variables.get(com.wiris.quizzes.impl.MathContent.TYPE_IMAGE);
				if(v != null) token = this.replaceVariablesInsideHTML(token,v,com.wiris.quizzes.impl.MathContent.TYPE_IMAGE,true);
				v = variables.get(com.wiris.quizzes.impl.MathContent.TYPE_GEOMETRY_FILE);
				if(v != null) {
					v = this.fixPlottersWithDimensions(variables);
					token = this.replaceVariablesInsideHTML(token,v,com.wiris.quizzes.impl.MathContent.TYPE_GEOMETRY_FILE,true);
				}
				v = variables.get(com.wiris.quizzes.impl.MathContent.TYPE_MATHML);
				if(v != null) token = this.replaceVariablesInsideHTML(token,v,com.wiris.quizzes.impl.MathContent.TYPE_MATHML,true);
				v = variables.get(com.wiris.quizzes.impl.MathContent.TYPE_TEXT);
				if(v != null) token = this.replaceVariablesInsideHTML(token,v,com.wiris.quizzes.impl.MathContent.TYPE_TEXT,true);
			}
			sb.b += Std.string(token);
		}
		var result = sb.b;
		if(encoded) result = this.encodeMathML(result);
		return result;
	}
	,expandVariablesText: function(text,textvariables) {
		return this.replaceVariablesInsideHTML(text,textvariables,com.wiris.quizzes.impl.MathContent.TYPE_TEXT,false);
	}
	,encodeMathML: function(html) {
		var start;
		var end = 0;
		while((start = html.indexOf("<math",end)) != -1) {
			var closemath = "</math>";
			end = html.indexOf(closemath,start) + closemath.length;
			var formula = HxOverrides.substr(html,start,end - start);
			formula = StringTools.replace(formula,"<",com.wiris.quizzes.impl.HTMLTools.SAFE_MATHML_LT);
			formula = StringTools.replace(formula,">",com.wiris.quizzes.impl.HTMLTools.SAFE_MATHML_GT);
			formula = StringTools.replace(formula,"\"",com.wiris.quizzes.impl.HTMLTools.SAFE_MATHML_QUOT);
			formula = StringTools.replace(formula,"&",com.wiris.quizzes.impl.HTMLTools.SAFE_MATHML_AMP);
			html = HxOverrides.substr(html,0,start) + formula + HxOverrides.substr(html,end,null);
			end = start + formula.length;
		}
		return html;
	}
	,decodeMathML: function(html) {
		var closemath = com.wiris.quizzes.impl.HTMLTools.SAFE_MATHML_LT + "/math" + com.wiris.quizzes.impl.HTMLTools.SAFE_MATHML_GT;
		var start;
		var end = 0;
		while((start = html.indexOf(com.wiris.quizzes.impl.HTMLTools.SAFE_MATHML_LT + "math",end)) != -1) {
			end = html.indexOf(closemath,start) + closemath.length;
			var formula = HxOverrides.substr(html,start,end - start);
			formula = com.wiris.util.xml.WXmlUtils.htmlUnescape(formula);
			formula = StringTools.replace(formula,com.wiris.quizzes.impl.HTMLTools.SAFE_MATHML_LT,"<");
			formula = StringTools.replace(formula,com.wiris.quizzes.impl.HTMLTools.SAFE_MATHML_GT,">");
			formula = StringTools.replace(formula,com.wiris.quizzes.impl.HTMLTools.SAFE_MATHML_QUOT,"\"");
			formula = StringTools.replace(formula,com.wiris.quizzes.impl.HTMLTools.SAFE_MATHML_AMP,"&");
			html = HxOverrides.substr(html,0,start) + formula + HxOverrides.substr(html,end,null);
			end = start + formula.length;
		}
		return html;
	}
	,isMathMLEncoded: function(html) {
		return html.indexOf(com.wiris.quizzes.impl.HTMLTools.SAFE_MATHML_LT + "math") != -1;
	}
	,extractVariableNames: function(html) {
		if(this.isMathMLEncoded(html)) html = this.decodeMathML(html);
		html = com.wiris.util.xml.WXmlUtils.resolveEntities(html);
		html = this.prepareFormulas(html);
		var names = new Array();
		var start = 0;
		while((start = html.indexOf("#",start)) != -1) {
			if(this.variablePosition(html,start) > 0) {
				var name = this.getVariableName(html,start);
				com.wiris.quizzes.impl.HTMLTools.insertStringInSortedArray(name,names);
				if(name != null && name.indexOf("_") != -1 && this.assertTextSyntax(name)) {
					name = HxOverrides.substr(name,0,name.indexOf("_"));
					com.wiris.quizzes.impl.HTMLTools.insertStringInSortedArray(name,names);
				}
			}
			start++;
		}
		return com.wiris.quizzes.impl.HTMLTools.toNativeArray(names);
	}
	,addComputedVariablesToAlgorithm: function(algorithm,computedVariables) {
		var it = computedVariables.keys();
		if(it.hasNext() && algorithm == null) algorithm = com.wiris.quizzes.impl.HTMLTools.EMPTY_CALCME_SESSION;
		while(it.hasNext()) {
			var name = it.next();
			var value = computedVariables.get(name);
			var isMathML = value.indexOf("<mi>") != -1;
			if(isMathML) {
				value = StringTools.replace(value,"<mo>#</mo>","<mi>#</mi>");
				value = this.prepareFormulas("<math>" + value + "</math>");
				value = HxOverrides.substr(value,"<math>".length,null);
				value = HxOverrides.substr(value,0,value.length - "</math>".length);
			}
			value = StringTools.replace(value,"#","");
			if(isMathML) {
				var auxiliarString = [HxOverrides.substr(algorithm,0,algorithm.lastIndexOf("</group>")),HxOverrides.substr(algorithm,algorithm.lastIndexOf("</group>"),null)];
				algorithm = auxiliarString[0] + "<command><input><math xmlns=\"http://www.w3.org/1998/Math/MathML\">" + "<mi>" + name + "</mi>" + "<mo>=</mo><mrow>" + value + "</mrow></math></input></command>" + auxiliarString[1];
			} else {
				var auxiliarString = [HxOverrides.substr(algorithm,0,algorithm.lastIndexOf("</group>")),HxOverrides.substr(algorithm,algorithm.lastIndexOf("</group>"),null)];
				algorithm = auxiliarString[0] + "<algorithm>" + name + "=" + value + "</algorithm>" + auxiliarString[1];
			}
		}
		return algorithm;
	}
	,extractActionExpressions: function(html,variables) {
		var originalHtml = html;
		html = com.wiris.util.xml.WXmlUtils.resolveEntities(html);
		var actions = com.wiris.quizzes.impl.ActionCommands.COMMANDS;
		var _g = 0;
		while(_g < actions.length) {
			var action = actions[_g];
			++_g;
			var bracketMathMLActionString = "<mi>" + action + "</mi><mo>(</mo>";
			var mfencedMathMLActioNString = "<mi>" + action + "</mi><mfenced>";
			var paragraphActionString = action + "(";
			while(html.indexOf(bracketMathMLActionString) != -1 || html.indexOf(mfencedMathMLActioNString) != -1 || html.indexOf(paragraphActionString) != -1) {
				var numberOfOpenBrackets = 0;
				var indexOfLastClosingBracket = 0;
				if(html.indexOf(bracketMathMLActionString) != -1) {
					var numberOfClosedBrackets = 0;
					var _g2 = html.indexOf(bracketMathMLActionString), _g1 = html.lastIndexOf("<mo>)</mo>") + "<mo>)</mo>".length;
					while(_g2 < _g1) {
						var i = _g2++;
						if(html.charAt(i) == "(") numberOfOpenBrackets++; else if(html.charAt(i) == ")") numberOfClosedBrackets++;
						if(numberOfOpenBrackets == numberOfClosedBrackets && numberOfOpenBrackets != 0) {
							indexOfLastClosingBracket = i + "</mo>".length;
							break;
						}
					}
					if(numberOfOpenBrackets != numberOfClosedBrackets && numberOfOpenBrackets != 0 && numberOfClosedBrackets != 0) return originalHtml;
					if(html.indexOf(bracketMathMLActionString,html.indexOf(bracketMathMLActionString) + 1) < indexOfLastClosingBracket && html.indexOf(bracketMathMLActionString,html.indexOf(bracketMathMLActionString) + 1) != -1) return originalHtml;
					var evaluateFullString = HxOverrides.substr(html,html.indexOf(bracketMathMLActionString),indexOfLastClosingBracket - html.indexOf(bracketMathMLActionString) + 1);
					var valueInsideEvaluate = HxOverrides.substr(evaluateFullString,bracketMathMLActionString.length,evaluateFullString.lastIndexOf("<mo>)</mo>") - bracketMathMLActionString.length);
					html = StringTools.replace(html,evaluateFullString,"<mi>#_computed_variable_" + haxe.Md5.encode(evaluateFullString) + "</mi>");
					var key = "_computed_variable_" + haxe.Md5.encode(evaluateFullString);
					if(variables != null) variables.set(key,valueInsideEvaluate);
				} else if(html.indexOf(mfencedMathMLActioNString) != -1) {
					var auxiliarIndexOpenBracket = html.indexOf(mfencedMathMLActioNString);
					var auxiliarIndexClosedBracket = html.indexOf("</mfenced>",html.indexOf(mfencedMathMLActioNString));
					while(numberOfOpenBrackets != indexOfLastClosingBracket || numberOfOpenBrackets == 0) {
						if(html.indexOf("<mfenced>",auxiliarIndexOpenBracket) < html.indexOf("</mfenced>",auxiliarIndexClosedBracket) && html.indexOf("<mfenced>",auxiliarIndexOpenBracket) != -1) {
							numberOfOpenBrackets++;
							auxiliarIndexOpenBracket = html.indexOf("<mfenced>",auxiliarIndexOpenBracket) + 1;
						}
						if(html.indexOf("<mfenced>",auxiliarIndexOpenBracket) > html.indexOf("</mfenced>",auxiliarIndexClosedBracket) || html.indexOf("<mfenced>",auxiliarIndexOpenBracket) == -1) {
							indexOfLastClosingBracket++;
							auxiliarIndexClosedBracket = html.indexOf("</mfenced>",auxiliarIndexClosedBracket) + 1;
						}
					}
					if(html.indexOf(mfencedMathMLActioNString,html.indexOf(mfencedMathMLActioNString) + 1) < auxiliarIndexClosedBracket + 9 && html.indexOf(mfencedMathMLActioNString,html.indexOf(mfencedMathMLActioNString) + 1) != -1) return originalHtml;
					var evaluateFullString = HxOverrides.substr(html,html.indexOf(mfencedMathMLActioNString),auxiliarIndexClosedBracket + "</mfenced>".length - 1 - html.indexOf(mfencedMathMLActioNString));
					var valueInsideEvaluate = HxOverrides.substr(evaluateFullString,mfencedMathMLActioNString.length,evaluateFullString.lastIndexOf("</mfenced>") - mfencedMathMLActioNString.length);
					html = StringTools.replace(html,evaluateFullString,"<mi>#_computed_variable_" + haxe.Md5.encode(evaluateFullString) + "</mi>");
					var key = "_computed_variable_" + haxe.Md5.encode(evaluateFullString);
					if(variables != null) variables.set(key,valueInsideEvaluate);
				} else if(html.indexOf(paragraphActionString) != -1) {
					var numberOfClosedBrackets = 0;
					var _g2 = html.indexOf(paragraphActionString), _g1 = html.lastIndexOf(")") + 1;
					while(_g2 < _g1) {
						var i = _g2++;
						if(html.charAt(i) == "(") numberOfOpenBrackets++; else if(html.charAt(i) == ")") numberOfClosedBrackets++;
						if(numberOfOpenBrackets == numberOfClosedBrackets && numberOfOpenBrackets != 0) {
							indexOfLastClosingBracket = i;
							break;
						}
					}
					if(numberOfOpenBrackets != numberOfClosedBrackets && numberOfOpenBrackets != 0 && numberOfClosedBrackets != 0) return originalHtml;
					if(html.indexOf(paragraphActionString,html.indexOf(paragraphActionString) + 1) < indexOfLastClosingBracket && html.indexOf(paragraphActionString,html.indexOf(paragraphActionString) + 1) != -1) return originalHtml;
					var evaluateFullString = HxOverrides.substr(html,html.indexOf(paragraphActionString),indexOfLastClosingBracket + 1 - html.indexOf(paragraphActionString));
					var valueInsideEvaluate = HxOverrides.substr(evaluateFullString,paragraphActionString.length,evaluateFullString.lastIndexOf(")") - paragraphActionString.length);
					html = StringTools.replace(html,evaluateFullString,"#_computed_variable_" + haxe.Md5.encode(evaluateFullString));
					var key = "_computed_variable_" + haxe.Md5.encode(evaluateFullString);
					if(variables != null) variables.set(key,valueInsideEvaluate);
				}
			}
		}
		return html;
	}
	,plotterLoadingSrc: null
	,proxyUrl: null
	,answerKeyword: null
	,separator: null
	,__class__: com.wiris.quizzes.impl.HTMLTools
}
com.wiris.quizzes.impl.HandwritingConstraints = $hxClasses["com.wiris.quizzes.impl.HandwritingConstraints"] = function() {
	if(com.wiris.quizzes.impl.HandwritingConstraints.symbol_conflicts == null) com.wiris.quizzes.impl.HandwritingConstraints.symbol_conflicts = [[com.wiris.system.Utf8.uchr(120),com.wiris.system.Utf8.uchr(88),com.wiris.system.Utf8.uchr(215),com.wiris.system.Utf8.uchr(967)],[com.wiris.system.Utf8.uchr(46),com.wiris.system.Utf8.uchr(44),com.wiris.system.Utf8.uchr(183)],[com.wiris.system.Utf8.uchr(50),com.wiris.system.Utf8.uchr(122),com.wiris.system.Utf8.uchr(90)],[com.wiris.system.Utf8.uchr(53),com.wiris.system.Utf8.uchr(115),com.wiris.system.Utf8.uchr(83),com.wiris.system.Utf8.uchr(36)],[com.wiris.system.Utf8.uchr(49),com.wiris.system.Utf8.uchr(44),com.wiris.system.Utf8.uchr(124),com.wiris.system.Utf8.uchr(39)],[com.wiris.system.Utf8.uchr(105),com.wiris.system.Utf8.uchr(106),com.wiris.system.Utf8.uchr(58),com.wiris.system.Utf8.uchr(59)],[com.wiris.system.Utf8.uchr(121),com.wiris.system.Utf8.uchr(52),com.wiris.system.Utf8.uchr(89)],[com.wiris.system.Utf8.uchr(112),com.wiris.system.Utf8.uchr(80),com.wiris.system.Utf8.uchr(961)],[com.wiris.system.Utf8.uchr(99),com.wiris.system.Utf8.uchr(67),com.wiris.system.Utf8.uchr(40),com.wiris.system.Utf8.uchr(8834)],[com.wiris.system.Utf8.uchr(48),com.wiris.system.Utf8.uchr(111),com.wiris.system.Utf8.uchr(79),com.wiris.system.Utf8.uchr(176)],[com.wiris.system.Utf8.uchr(916),com.wiris.system.Utf8.uchr(65)],[com.wiris.system.Utf8.uchr(66),com.wiris.system.Utf8.uchr(946)],[com.wiris.system.Utf8.uchr(8707),com.wiris.system.Utf8.uchr(51)],[com.wiris.system.Utf8.uchr(57),com.wiris.system.Utf8.uchr(113),com.wiris.system.Utf8.uchr(103)],[com.wiris.system.Utf8.uchr(57),com.wiris.system.Utf8.uchr(97)],[com.wiris.system.Utf8.uchr(118),com.wiris.system.Utf8.uchr(86),com.wiris.system.Utf8.uchr(8744),com.wiris.system.Utf8.uchr(957)],[com.wiris.system.Utf8.uchr(114),com.wiris.system.Utf8.uchr(963)],[com.wiris.system.Utf8.uchr(116),com.wiris.system.Utf8.uchr(43)],[com.wiris.system.Utf8.uchr(8712),com.wiris.system.Utf8.uchr(69),com.wiris.system.Utf8.uchr(949)],[com.wiris.system.Utf8.uchr(110),com.wiris.system.Utf8.uchr(104)],[com.wiris.system.Utf8.uchr(107),com.wiris.system.Utf8.uchr(75),com.wiris.system.Utf8.uchr(954)],[com.wiris.system.Utf8.uchr(117),com.wiris.system.Utf8.uchr(85),com.wiris.system.Utf8.uchr(8746)],[com.wiris.system.Utf8.uchr(119),com.wiris.system.Utf8.uchr(87),com.wiris.system.Utf8.uchr(969)],[com.wiris.system.Utf8.uchr(100),com.wiris.system.Utf8.uchr(8706),com.wiris.system.Utf8.uchr(948)],[com.wiris.system.Utf8.uchr(8706),com.wiris.system.Utf8.uchr(97)],[com.wiris.system.Utf8.uchr(8709),com.wiris.system.Utf8.uchr(952),com.wiris.system.Utf8.uchr(920)],[com.wiris.system.Utf8.uchr(8745),com.wiris.system.Utf8.uchr(110),com.wiris.system.Utf8.uchr(951)],[com.wiris.system.Utf8.uchr(923),com.wiris.system.Utf8.uchr(8743),com.wiris.system.Utf8.uchr(94)],[com.wiris.system.Utf8.uchr(968),com.wiris.system.Utf8.uchr(936)],[com.wiris.system.Utf8.uchr(8709),com.wiris.system.Utf8.uchr(966),com.wiris.system.Utf8.uchr(934)],[com.wiris.system.Utf8.uchr(928),com.wiris.system.Utf8.uchr(960),com.wiris.system.Utf8.uchr(8719)],[com.wiris.system.Utf8.uchr(950),com.wiris.system.Utf8.uchr(958)],[com.wiris.system.Utf8.uchr(950),com.wiris.system.Utf8.uchr(51),com.wiris.system.Utf8.uchr(122)],[com.wiris.system.Utf8.uchr(9180),com.wiris.system.Utf8.uchr(94),com.wiris.system.Utf8.uchr(126),com.wiris.system.Utf8.uchr(45)]];
	if(com.wiris.quizzes.impl.HandwritingConstraints.symbol_default_excluded == null) com.wiris.quizzes.impl.HandwritingConstraints.symbol_default_excluded = [["sin","cos","tan","log"]];
};
com.wiris.quizzes.impl.HandwritingConstraints.__name__ = ["com","wiris","quizzes","impl","HandwritingConstraints"];
com.wiris.quizzes.impl.HandwritingConstraints.symbol_conflicts = null;
com.wiris.quizzes.impl.HandwritingConstraints.symbol_default_excluded = null;
com.wiris.quizzes.impl.HandwritingConstraints.readHandwritingConstraints = function(json) {
	var hc = new com.wiris.quizzes.impl.HandwritingConstraints();
	var obj = com.wiris.util.json.JSon.decode(json);
	hc.symbols = obj.exists("symbols")?obj.get("symbols"):new Array();
	hc.structure = obj.exists("structure")?obj.get("structure"):new Array();
	return hc;
}
com.wiris.quizzes.impl.HandwritingConstraints.newHandwritingConstraints = function() {
	var hc = new com.wiris.quizzes.impl.HandwritingConstraints();
	hc.symbols = new Array();
	hc.structure = new Array();
	hc.structure.push(com.wiris.quizzes.impl.HandwritingConstraints.GENERAL);
	hc.structure.push(com.wiris.quizzes.impl.HandwritingConstraints.FRACTIONS);
	return hc;
}
com.wiris.quizzes.impl.HandwritingConstraints.prototype = {
	getNegativeConstraints: function() {
		var h = new com.wiris.quizzes.impl.HandwritingConstraints();
		h.symbols = new Array();
		h.structure = this.structure;
		var blocked = new Array();
		var i;
		var _g1 = 0, _g = com.wiris.quizzes.impl.HandwritingConstraints.symbol_conflicts.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			var conflictSet = com.wiris.quizzes.impl.HandwritingConstraints.symbol_conflicts[i1];
			var exclude = new Array();
			var j;
			var _g3 = 0, _g2 = conflictSet.length;
			while(_g3 < _g2) {
				var j1 = _g3++;
				if(!com.wiris.system.ArrayEx.contains(this.symbols,conflictSet[j1])) exclude.push(conflictSet[j1]);
			}
			if(exclude.length < conflictSet.length) {
				var _g3 = 0, _g2 = exclude.length;
				while(_g3 < _g2) {
					var j1 = _g3++;
					blocked.push(exclude[j1]);
				}
			}
		}
		var _g1 = 0, _g = com.wiris.quizzes.impl.HandwritingConstraints.symbol_default_excluded.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			var defaultExcluded = com.wiris.quizzes.impl.HandwritingConstraints.symbol_default_excluded[i1];
			var exclude = true;
			var j;
			var _g3 = 0, _g2 = defaultExcluded.length;
			while(_g3 < _g2) {
				var j1 = _g3++;
				if(com.wiris.system.ArrayEx.contains(this.symbols,defaultExcluded[j1])) exclude = false;
			}
			if(exclude) {
				var _g3 = 0, _g2 = defaultExcluded.length;
				while(_g3 < _g2) {
					var j1 = _g3++;
					blocked.push(defaultExcluded[j1]);
				}
			}
		}
		var _g1 = 0, _g = com.wiris.quizzes.impl.HandwritingConstraints.ALL_SYMBOLS.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(!com.wiris.system.ArrayEx.contains(blocked,com.wiris.quizzes.impl.HandwritingConstraints.ALL_SYMBOLS[i1])) h.symbols.push(com.wiris.quizzes.impl.HandwritingConstraints.ALL_SYMBOLS[i1]);
		}
		return h;
	}
	,toJSON: function() {
		var h = new Hash();
		h.set("symbols",this.symbols);
		h.set("structure",this.structure);
		return com.wiris.util.json.JSon.encode(h);
	}
	,addStructureFromText: function(t) {
		if(t.indexOf("/") != -1) com.wiris.util.type.Arrays.insertSortedSet(this.structure,com.wiris.quizzes.impl.HandwritingConstraints.FRACTIONS);
		if(t.indexOf("sqrt") != -1 || t.indexOf("root") != -1) com.wiris.util.type.Arrays.insertSortedSet(this.structure,com.wiris.quizzes.impl.HandwritingConstraints.RADICALS);
		if(t.indexOf("\n") != -1) com.wiris.util.type.Arrays.insertSortedSet(this.structure,com.wiris.quizzes.impl.HandwritingConstraints.MULTILINE);
	}
	,addStructureFromMathML: function(m) {
		if(m.indexOf("<mfrac") != -1) com.wiris.util.type.Arrays.insertSortedSet(this.structure,com.wiris.quizzes.impl.HandwritingConstraints.FRACTIONS);
		if(m.indexOf("<mroot") != -1 || m.indexOf("<msqrt") != -1) com.wiris.util.type.Arrays.insertSortedSet(this.structure,com.wiris.quizzes.impl.HandwritingConstraints.RADICALS);
		if(m.indexOf("<munderover") != -1 || m.indexOf("<munder") != -1) com.wiris.util.type.Arrays.insertSortedSet(this.structure,com.wiris.quizzes.impl.HandwritingConstraints.BIGOPERATORS);
		if(m.indexOf("<mtable") != -1) {
			com.wiris.util.type.Arrays.insertSortedSet(this.structure,com.wiris.quizzes.impl.HandwritingConstraints.PIECEWISE);
			com.wiris.util.type.Arrays.insertSortedSet(this.structure,com.wiris.quizzes.impl.HandwritingConstraints.MATRICES);
		}
		if(m.indexOf("<mspace") != -1) com.wiris.util.type.Arrays.insertSortedSet(this.structure,com.wiris.quizzes.impl.HandwritingConstraints.MULTILINE);
	}
	,addToken: function(t) {
		if(!StringTools.startsWith(t,"#")) {
			t = com.wiris.util.xml.WXmlUtils.htmlUnescape(t);
			com.wiris.util.type.Arrays.insertSortedSet(this.symbols,t);
		}
	}
	,addTagContent: function(s,tag,split) {
		var start;
		var end = 0;
		while((start = s.indexOf("<" + tag,end)) != -1) {
			end = start + 1 + tag.length;
			var charAfterTag = HxOverrides.cca(s,end);
			if(charAfterTag == 32 || charAfterTag == 62) {
				var endBeginTag = s.indexOf(">",end);
				if(endBeginTag == -1) return;
				if(HxOverrides.cca(s,endBeginTag - 1) != 47) {
					var beginContent = endBeginTag + 1;
					var endContent = s.indexOf("<",beginContent);
					if(endContent == -1) return;
					var content = HxOverrides.substr(s,beginContent,endContent - beginContent);
					if(split) {
						var i = 0;
						while(i < content.length) {
							var c = com.wiris.system.Utf8.uchr(com.wiris.system.Utf8.charCodeAt(HxOverrides.substr(content,i,null),0));
							this.addToken(c);
							i += c.length;
						}
					} else this.addToken(content);
					end = endContent + 1;
				}
			}
		}
	}
	,addSymbolsFromMathML: function(s) {
		var tokenTags = ["mi","mn","mo"];
		var i;
		var _g1 = 0, _g = tokenTags.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			this.addTagContent(s,tokenTags[i1],tokenTags[i1] == "mn");
		}
	}
	,addSymbolsFromText: function(text) {
		this.addSymbolsFromMathML(new com.wiris.quizzes.impl.HTMLTools().textToMathML(text));
	}
	,addQuestionInstanceConstraints: function(qi) {
		if(qi.hasVariables()) {
			var mvars = qi.getMathMLVariables();
			if(mvars != null) {
				var keys = mvars.keys();
				while(keys.hasNext()) {
					var content = mvars.get(keys.next());
					this.addSymbolsFromMathML(content);
					this.addStructureFromMathML(content);
				}
			}
			var tvars = qi.getTextVariables();
			if(tvars != null) {
				var keys = tvars.keys();
				while(keys.hasNext()) {
					var content = tvars.get(keys.next());
					this.addSymbolsFromText(content);
					this.addStructureFromText(content);
				}
			}
		}
	}
	,addQuestionConstraints: function(q) {
		var h = new com.wiris.quizzes.impl.HTMLTools();
		var i;
		var _g1 = 0, _g = q.getCorrectAnswersLength();
		while(_g1 < _g) {
			var i1 = _g1++;
			var answer = q.getCorrectAnswer(i1);
			answer = h.prepareFormulas(answer);
			if(com.wiris.quizzes.impl.MathContent.getMathType(answer) == com.wiris.quizzes.impl.MathContent.TYPE_MATHML) {
				this.addSymbolsFromMathML(answer);
				this.addStructureFromMathML(answer);
			} else {
				this.addSymbolsFromText(answer);
				this.addStructureFromText(answer);
			}
		}
	}
	,structure: null
	,symbols: null
	,__class__: com.wiris.quizzes.impl.HandwritingConstraints
}
com.wiris.quizzes.impl.HtmlUiConfig = $hxClasses["com.wiris.quizzes.impl.HtmlUiConfig"] = function(classes) {
	this.openAnswerConfig();
	if(classes == null) return;
	var classArray = classes.split(" ");
	var _g = 0;
	while(_g < classArray.length) {
		var className = classArray[_g];
		++_g;
		if(className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISMULTICHOICE) this.multichoiceConfig(); else if(className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISOPENANSWER) this.openAnswerConfig(); else if(className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISESSAY) this.essayConfig(); else if(className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISANSWERFEEDBACK) {
			this.showCorrectAnswerFeedback = false;
			this.showAssertionsFeedback = true;
			this.showFieldDecorationFeedback = false;
		} else if(className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISEMBEDDEDFEEDBACK) {
			this.showCorrectAnswerFeedback = false;
			this.showAssertionsFeedback = false;
			this.showFieldDecorationFeedback = true;
		}
	}
	var _g = 0;
	while(_g < classArray.length) {
		var className = classArray[_g];
		++_g;
		if(className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISVARIABLES) this.variablesDefinition = true; else if(className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISVALIDATION) this.gradingCriteria = true; else if(className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISPREVIEW) this.testQuestion = true; else if(className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISAUXILIARYCAS || className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISAUXILIARCAS) this.optAuxiliaryCas = true; else if(className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISAUXILIARYTEXTINPUT || className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISAUXILIARTEXTINPUT) this.optAuxiliaryTextInput = true; else if(className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISAUXILIARYCASREPLACEEDITOR || className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISAUXILIARCASREPLACEEDITOR) this.optAuxiliaryCasReplaceEditor = true; else if(className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISTEACHERANSWER) this.optOpenAnswer = true; else if(className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISGRADINGFUNCTION) this.optGradingFunction = true; else if(className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISASSERTIONSFEEDBACK) this.showAssertionsFeedback = true; else if(className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISCORRECTFEEDBACK) this.showCorrectAnswerFeedback = true; else if(className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISANSWERFIELDINLINEEDITOR) this.optAnswerFieldInlineEditor = true; else if(className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISANSWERFIELDPOPUPEDITOR) this.optAnswerFieldPopupEditor = true; else if(className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISANSWERFIELDPLAINTEXT) this.optAnswerFieldPlainText = true; else if(className == com.wiris.quizzes.impl.HtmlUiConfig.WIRISGRAPHICSYNTAX) this.optGraphicSyntax = true;
	}
};
com.wiris.quizzes.impl.HtmlUiConfig.__name__ = ["com","wiris","quizzes","impl","HtmlUiConfig"];
com.wiris.quizzes.impl.HtmlUiConfig.prototype = {
	essayConfig: function() {
		this.multichoiceConfig();
		this.optAuxiliaryCasReplaceEditor = true;
	}
	,multichoiceConfig: function() {
		this.gradingCriteria = false;
		this.variablesDefinition = true;
		this.testQuestion = false;
		this.optOpenAnswer = false;
		this.optAuxiliaryCas = false;
		this.optAuxiliaryTextInput = false;
		this.optAuxiliaryCasReplaceEditor = false;
		this.optGradingFunction = false;
		this.optGraphicSyntax = false;
		this.optAnswerFieldInlineEditor = false;
		this.optAnswerFieldInlineHand = false;
		this.optAnswerFieldPlainText = false;
		this.optAnswerFieldPopupEditor = false;
		this.optCompoundAnswer = false;
		this.showCorrectAnswerFeedback = false;
		this.showAssertionsFeedback = false;
		this.showFieldDecorationFeedback = false;
	}
	,openAnswerConfig: function() {
		this.gradingCriteria = true;
		this.variablesDefinition = false;
		this.testQuestion = true;
		this.optOpenAnswer = true;
		this.optAuxiliaryCas = false;
		this.optAuxiliaryTextInput = false;
		this.optAuxiliaryCasReplaceEditor = false;
		this.optGradingFunction = false;
		this.optGraphicSyntax = false;
		this.optAnswerFieldInlineEditor = true;
		this.optAnswerFieldInlineHand = false;
		this.optAnswerFieldPlainText = true;
		this.optAnswerFieldPopupEditor = true;
		this.optCompoundAnswer = true;
		this.showCorrectAnswerFeedback = false;
		this.showAssertionsFeedback = true;
		this.showFieldDecorationFeedback = true;
	}
	,showFieldDecorationFeedback: null
	,showAssertionsFeedback: null
	,showCorrectAnswerFeedback: null
	,optAnswerFieldInlineHand: null
	,optAnswerFieldPlainText: null
	,optAnswerFieldPopupEditor: null
	,optAnswerFieldInlineEditor: null
	,optCompoundAnswer: null
	,optGraphicSyntax: null
	,optAuxiliaryTextInput: null
	,optGradingFunction: null
	,optAuxiliaryCasReplaceEditor: null
	,optAuxiliaryCas: null
	,optOpenAnswer: null
	,testQuestion: null
	,variablesDefinition: null
	,gradingCriteria: null
	,__class__: com.wiris.quizzes.impl.HtmlUiConfig
}
haxe.Http = $hxClasses["haxe.Http"] = function(url) {
	this.url = url;
	this.headers = new Hash();
	this.params = new Hash();
	this.async = true;
};
haxe.Http.__name__ = ["haxe","Http"];
haxe.Http.requestUrl = function(url) {
	var h = new haxe.Http(url);
	h.async = false;
	var r = null;
	h.onData = function(d) {
		r = d;
	};
	h.onError = function(e) {
		throw e;
	};
	h.request(false);
	return r;
}
haxe.Http.prototype = {
	onStatus: function(status) {
	}
	,onError: function(msg) {
	}
	,onData: function(data) {
	}
	,request: function(post) {
		var me = this;
		var r = new js.XMLHttpRequest();
		var onreadystatechange = function() {
			if(r.readyState != 4) return;
			var s = (function($this) {
				var $r;
				try {
					$r = r.status;
				} catch( e ) {
					$r = null;
				}
				return $r;
			}(this));
			if(s == undefined) s = null;
			if(s != null) me.onStatus(s);
			if(s != null && s >= 200 && s < 400) me.onData(r.responseText); else switch(s) {
			case null: case undefined:
				me.onError("Failed to connect or resolve host");
				break;
			case 12029:
				me.onError("Failed to connect to host");
				break;
			case 12007:
				me.onError("Unknown host");
				break;
			default:
				me.onError("Http Error #" + r.status);
			}
		};
		if(this.async) r.onreadystatechange = onreadystatechange;
		var uri = this.postData;
		if(uri != null) post = true; else {
			var $it0 = this.params.keys();
			while( $it0.hasNext() ) {
				var p = $it0.next();
				if(uri == null) uri = ""; else uri += "&";
				uri += StringTools.urlEncode(p) + "=" + StringTools.urlEncode(this.params.get(p));
			}
		}
		try {
			if(post) r.open("POST",this.url,this.async); else if(uri != null) {
				var question = this.url.split("?").length <= 1;
				r.open("GET",this.url + (question?"?":"&") + uri,this.async);
				uri = null;
			} else r.open("GET",this.url,this.async);
		} catch( e ) {
			this.onError(e.toString());
			return;
		}
		if(this.headers.get("Content-Type") == null && post && this.postData == null) r.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
		var $it1 = this.headers.keys();
		while( $it1.hasNext() ) {
			var h = $it1.next();
			r.setRequestHeader(h,this.headers.get(h));
		}
		r.send(uri);
		if(!this.async) onreadystatechange();
	}
	,setPostData: function(data) {
		this.postData = data;
	}
	,setParameter: function(param,value) {
		this.params.set(param,value);
	}
	,setHeader: function(header,value) {
		this.headers.set(header,value);
	}
	,params: null
	,headers: null
	,postData: null
	,async: null
	,url: null
	,__class__: haxe.Http
}
com.wiris.quizzes.impl.HttpImpl = $hxClasses["com.wiris.quizzes.impl.HttpImpl"] = function(url,listener) {
	haxe.Http.call(this,url);
	this.listener = listener;
	this.async = false;
};
com.wiris.quizzes.impl.HttpImpl.__name__ = ["com","wiris","quizzes","impl","HttpImpl"];
com.wiris.quizzes.impl.HttpImpl.__super__ = haxe.Http;
com.wiris.quizzes.impl.HttpImpl.prototype = $extend(haxe.Http.prototype,{
	setAsync: function(async) {
		this.async = async;
	}
	,onError: function(msg) {
		this.listener.onError(msg);
	}
	,onData: function(data) {
		this.listener.onData(data);
	}
	,listener: null
	,__class__: com.wiris.quizzes.impl.HttpImpl
});
com.wiris.quizzes.impl.HttpListener = $hxClasses["com.wiris.quizzes.impl.HttpListener"] = function() { }
com.wiris.quizzes.impl.HttpListener.__name__ = ["com","wiris","quizzes","impl","HttpListener"];
com.wiris.quizzes.impl.HttpListener.prototype = {
	onError: null
	,onData: null
	,__class__: com.wiris.quizzes.impl.HttpListener
}
com.wiris.quizzes.impl.HttpSyncListener = $hxClasses["com.wiris.quizzes.impl.HttpSyncListener"] = function() {
};
com.wiris.quizzes.impl.HttpSyncListener.__name__ = ["com","wiris","quizzes","impl","HttpSyncListener"];
com.wiris.quizzes.impl.HttpSyncListener.__interfaces__ = [com.wiris.quizzes.impl.HttpListener];
com.wiris.quizzes.impl.HttpSyncListener.prototype = {
	getData: function() {
		return this.data;
	}
	,onError: function(error) {
		throw error;
	}
	,onData: function(data) {
		this.data = data;
	}
	,data: null
	,__class__: com.wiris.quizzes.impl.HttpSyncListener
}
com.wiris.quizzes.impl.HttpToQuizzesListener = $hxClasses["com.wiris.quizzes.impl.HttpToQuizzesListener"] = function(listener,mqr,service,async) {
	this.protocol = com.wiris.quizzes.impl.QuizzesServiceImpl.PROTOCOL_REST;
	this.listener = listener;
	this.service = service;
	this.mqr = mqr;
	this.async = async;
};
com.wiris.quizzes.impl.HttpToQuizzesListener.__name__ = ["com","wiris","quizzes","impl","HttpToQuizzesListener"];
com.wiris.quizzes.impl.HttpToQuizzesListener.__interfaces__ = [com.wiris.quizzes.impl.HttpListener];
com.wiris.quizzes.impl.HttpToQuizzesListener.prototype = {
	isCacheMiss: function(response) {
		return this.isFault(response) && StringTools.startsWith(this.getFaultMessage(response),"CACHEMISS");
	}
	,getFaultMessage: function(response) {
		if(this.protocol == com.wiris.quizzes.impl.QuizzesServiceImpl.PROTOCOL_REST) {
			var start = response.indexOf("<fault>") + 7;
			var end = response.indexOf("</fault>");
			var msg = HxOverrides.substr(response,start,end - start);
			return com.wiris.util.xml.WXmlUtils.htmlUnescape(msg);
		}
		return response;
	}
	,isFault: function(response) {
		if(this.protocol == com.wiris.quizzes.impl.QuizzesServiceImpl.PROTOCOL_REST) return response.indexOf("<fault>") != -1;
		return false;
	}
	,stripWebServiceEnvelope: function(data) {
		if(this.protocol == com.wiris.quizzes.impl.QuizzesServiceImpl.PROTOCOL_REST) {
			var startTagName = "doProcessQuestionsResponse";
			var start = data.indexOf("<" + startTagName + ">") + startTagName.length + 2;
			var end = data.indexOf("</" + startTagName + ">");
			data = HxOverrides.substr(data,start,end - start);
		}
		return data;
	}
	,onError: function(msg) {
		throw msg;
	}
	,onData: function(response) {
		if(this.isCacheMiss(response)) {
			this.service.callService(this.mqr,false,this.listener,this.async);
			return;
		}
		if(this.isFault(response)) throw "Remote exception: " + this.getFaultMessage(response);
		response = this.stripWebServiceEnvelope(response);
		var res = com.wiris.quizzes.impl.QuizzesImpl.getInstance().newMultipleResponseFromXml(response);
		var k;
		var _g1 = 0, _g = res.questionResponses.length;
		while(_g1 < _g) {
			var k1 = _g1++;
			var results = res.questionResponses[k1].results;
			if(results != null && results.length > 0) {
				var last = results[results.length - 1];
				if(js.Boot.__instanceof(last,com.wiris.quizzes.impl.ResultStoreQuestion)) {
					var rsq = last;
					this.mqr.questionRequests[k1].question.setId(rsq.id);
					results.pop();
				}
			}
		}
		this.listener.onResponse(res);
	}
	,async: null
	,protocol: null
	,mqr: null
	,service: null
	,listener: null
	,__class__: com.wiris.quizzes.impl.HttpToQuizzesListener
}
com.wiris.quizzes.impl.InitialContent = $hxClasses["com.wiris.quizzes.impl.InitialContent"] = function() {
	com.wiris.quizzes.impl.MathContent.call(this);
};
com.wiris.quizzes.impl.InitialContent.__name__ = ["com","wiris","quizzes","impl","InitialContent"];
com.wiris.quizzes.impl.InitialContent.__super__ = com.wiris.quizzes.impl.MathContent;
com.wiris.quizzes.impl.InitialContent.prototype = $extend(com.wiris.quizzes.impl.MathContent.prototype,{
	onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.InitialContent.TAGNAME);
		this.onSerializeInner(s);
		s.endTag();
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.InitialContent();
	}
	,__class__: com.wiris.quizzes.impl.InitialContent
});
com.wiris.quizzes.impl.LocalData = $hxClasses["com.wiris.quizzes.impl.LocalData"] = function() {
	com.wiris.util.xml.SerializableImpl.call(this);
};
com.wiris.quizzes.impl.LocalData.__name__ = ["com","wiris","quizzes","impl","LocalData"];
com.wiris.quizzes.impl.LocalData.__super__ = com.wiris.util.xml.SerializableImpl;
com.wiris.quizzes.impl.LocalData.prototype = $extend(com.wiris.util.xml.SerializableImpl.prototype,{
	replaceDeprecatedNames: function(name) {
		if(name != null && name == "auxiliarTextInput") return com.wiris.quizzes.api.QuizzesConstants.PROPERTY_SHOW_AUXILIARY_TEXT_INPUT;
		return name;
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.LocalData();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.LocalData.TAGNAME);
		this.name = this.replaceDeprecatedNames(s.attributeString("name",this.name,null));
		this.value = s.textContent(this.value);
		s.endTag();
	}
	,value: null
	,name: null
	,__class__: com.wiris.quizzes.impl.LocalData
});
com.wiris.quizzes.impl.MathMLFilter = $hxClasses["com.wiris.quizzes.impl.MathMLFilter"] = function() {
	if(com.wiris.settings.PlatformSettings.IS_FLASH || com.wiris.settings.PlatformSettings.IS_JAVASCRIPT) throw "MathFilter is only available in server technologies.";
};
com.wiris.quizzes.impl.MathMLFilter.__name__ = ["com","wiris","quizzes","impl","MathMLFilter"];
com.wiris.quizzes.impl.MathMLFilter.__interfaces__ = [com.wiris.quizzes.api.MathFilter];
com.wiris.quizzes.impl.MathMLFilter.prototype = {
	removeWirisPluginImages: function(html) {
		var start = 0;
		var end = 0;
		var sb = new StringBuf();
		while((start = html.indexOf("<img",end)) != -1) {
			sb.b += Std.string(HxOverrides.substr(html,end,start - end));
			end = html.indexOf("/>",start) + 2;
			var img = HxOverrides.substr(html,start,end - start);
			if(img.indexOf("class=\"Wirisformula\"") != -1) {
				var pos = img.indexOf("data-mathml");
				pos = img.indexOf("\"",pos) + 1;
				var endpos = img.indexOf("\"",pos);
				img = HxOverrides.substr(img,pos,endpos - pos);
			}
			sb.b += Std.string(img);
		}
		sb.b += Std.string(HxOverrides.substr(html,end,null));
		return sb.b;
	}
	,cacheImage: function(mathml,filename) {
		var listener = new com.wiris.quizzes.impl.HttpSyncListener();
		var h = new com.wiris.quizzes.impl.HttpImpl(com.wiris.quizzes.impl.QuizzesImpl.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.EDITOR_URL) + "/render",listener);
		h.setParameter("mml",mathml);
		h.request(true);
		var response = listener.getData();
		var b = haxe.io.Bytes.ofString(response);
		com.wiris.quizzes.impl.QuizzesImpl.getInstance().getImagesCache().set(filename,b);
	}
	,mathml2img: function(mathml) {
		var md5 = haxe.Md5.encode(mathml);
		var filename = md5 + ".png";
		this.cacheImage(mathml,filename);
		var url = com.wiris.quizzes.impl.QuizzesImpl.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.PROXY_URL) + "?service=cache&amp;name=" + filename;
		return "<img src=\"" + url + "\" align=\"middle\" />";
	}
	,filter: function(html) {
		var h = new com.wiris.quizzes.impl.HTMLTools();
		html = this.removeWirisPluginImages(html);
		if(h.isMathMLEncoded(html)) html = h.decodeMathML(html);
		var sb = new StringBuf();
		var start = 0;
		var end = 0;
		while((start = html.indexOf("<math",end)) > -1) {
			sb.b += Std.string(HxOverrides.substr(html,end,start - end));
			end = html.indexOf("</math>",start);
			if(end == -1) end = html.indexOf("/>",start) + "/>".length; else end += "</math>".length;
			var mathml = HxOverrides.substr(html,start,end - start);
			var img = this.mathml2img(mathml);
			sb.b += Std.string(img);
		}
		sb.b += Std.string(HxOverrides.substr(html,end,null));
		return sb.b;
	}
	,__class__: com.wiris.quizzes.impl.MathMLFilter
}
com.wiris.quizzes.impl.MaxConnectionsHttpImpl = $hxClasses["com.wiris.quizzes.impl.MaxConnectionsHttpImpl"] = function(url,listener) {
	com.wiris.quizzes.impl.HttpImpl.call(this,url,listener);
	try {
		this.max_connections = Std.parseInt(com.wiris.quizzes.impl.QuizzesImpl.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.MAXCONNECTIONS));
	} catch( t ) {
		this.max_connections = 10;
	}
};
com.wiris.quizzes.impl.MaxConnectionsHttpImpl.__name__ = ["com","wiris","quizzes","impl","MaxConnectionsHttpImpl"];
com.wiris.quizzes.impl.MaxConnectionsHttpImpl.__super__ = com.wiris.quizzes.impl.HttpImpl;
com.wiris.quizzes.impl.MaxConnectionsHttpImpl.prototype = $extend(com.wiris.quizzes.impl.HttpImpl.prototype,{
	getConnectionSlot: function() {
		var p = new com.wiris.quizzes.impl.SharedVariables();
		p.lockVariable(com.wiris.quizzes.impl.MaxConnectionsHttpImpl.DATA_KEY_MAX_CONNECTIONS);
		var data = p.getVariable(com.wiris.quizzes.impl.MaxConnectionsHttpImpl.DATA_KEY_MAX_CONNECTIONS);
		var connections = null;
		if(data != null) try {
			connections = haxe.Unserializer.run(data);
		} catch( t ) {
			connections = null;
		}
		if(connections == null) connections = new Array();
		while(connections.length > this.max_connections) HxOverrides.remove(connections,connections[connections.length - 1]);
		var n = Math.floor(haxe.Timer.stamp());
		this.current = n;
		this.slot = -1;
		var i;
		var _g1 = 0, _g = connections.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			var con = connections[i1];
			if(this.current - con > com.wiris.quizzes.impl.MaxConnectionsHttpImpl.CONNECTION_TIMEOUT || con > this.current + 1) {
				this.slot = i1;
				connections[i1] = this.current;
				break;
			}
		}
		if(this.slot == -1 && connections.length < this.max_connections) {
			this.slot = connections.length;
			connections.push(this.current);
		}
		if(this.slot != -1) {
			data = haxe.Serializer.run(connections);
			p.setVariable(com.wiris.quizzes.impl.MaxConnectionsHttpImpl.DATA_KEY_MAX_CONNECTIONS,data);
		}
		p.unlockVariable(com.wiris.quizzes.impl.MaxConnectionsHttpImpl.DATA_KEY_MAX_CONNECTIONS);
		return this.slot != -1;
	}
	,releaseConnectionSlot: function() {
		var p = new com.wiris.quizzes.impl.SharedVariables();
		p.lockVariable(com.wiris.quizzes.impl.MaxConnectionsHttpImpl.DATA_KEY_MAX_CONNECTIONS);
		var data = p.getVariable(com.wiris.quizzes.impl.MaxConnectionsHttpImpl.DATA_KEY_MAX_CONNECTIONS);
		var connections = haxe.Unserializer.run(data);
		if(connections[this.slot] == this.current) {
			var n = 0;
			connections[this.slot] = n;
			data = haxe.Serializer.run(connections);
			p.setVariable(com.wiris.quizzes.impl.MaxConnectionsHttpImpl.DATA_KEY_MAX_CONNECTIONS,data);
		}
		p.unlockVariable(com.wiris.quizzes.impl.MaxConnectionsHttpImpl.DATA_KEY_MAX_CONNECTIONS);
	}
	,request: function(post) {
		if(this.max_connections == -1) com.wiris.quizzes.impl.HttpImpl.prototype.request.call(this,post); else if(this.getConnectionSlot()) {
			com.wiris.quizzes.impl.HttpImpl.prototype.request.call(this,post);
			this.releaseConnectionSlot();
		} else throw "Too many concurrent connections.";
	}
	,current: null
	,slot: null
	,max_connections: null
	,__class__: com.wiris.quizzes.impl.MaxConnectionsHttpImpl
});
com.wiris.quizzes.impl.MultipleQuestionRequest = $hxClasses["com.wiris.quizzes.impl.MultipleQuestionRequest"] = function() {
	com.wiris.util.xml.SerializableImpl.call(this);
};
com.wiris.quizzes.impl.MultipleQuestionRequest.__name__ = ["com","wiris","quizzes","impl","MultipleQuestionRequest"];
com.wiris.quizzes.impl.MultipleQuestionRequest.__super__ = com.wiris.util.xml.SerializableImpl;
com.wiris.quizzes.impl.MultipleQuestionRequest.prototype = $extend(com.wiris.util.xml.SerializableImpl.prototype,{
	newInstance: function() {
		return new com.wiris.quizzes.impl.MultipleQuestionRequest();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.MultipleQuestionRequest.tagName);
		this.questionRequests = s.serializeArray(this.questionRequests,com.wiris.quizzes.impl.QuestionRequestImpl.tagName);
		s.endTag();
	}
	,questionRequests: null
	,__class__: com.wiris.quizzes.impl.MultipleQuestionRequest
});
com.wiris.quizzes.impl.MultipleQuestionResponse = $hxClasses["com.wiris.quizzes.impl.MultipleQuestionResponse"] = function() {
	com.wiris.util.xml.SerializableImpl.call(this);
};
com.wiris.quizzes.impl.MultipleQuestionResponse.__name__ = ["com","wiris","quizzes","impl","MultipleQuestionResponse"];
com.wiris.quizzes.impl.MultipleQuestionResponse.__super__ = com.wiris.util.xml.SerializableImpl;
com.wiris.quizzes.impl.MultipleQuestionResponse.prototype = $extend(com.wiris.util.xml.SerializableImpl.prototype,{
	newInstance: function() {
		return new com.wiris.quizzes.impl.MultipleQuestionResponse();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.MultipleQuestionResponse.tagName);
		this.questionResponses = s.serializeArray(this.questionResponses,com.wiris.quizzes.impl.QuestionResponseImpl.tagName);
		s.endTag();
	}
	,questionResponses: null
	,__class__: com.wiris.quizzes.impl.MultipleQuestionResponse
});
com.wiris.quizzes.impl.QuizzesServiceImpl = $hxClasses["com.wiris.quizzes.impl.QuizzesServiceImpl"] = function() {
	this.protocol = com.wiris.quizzes.impl.QuizzesServiceImpl.PROTOCOL_REST;
	this.url = com.wiris.quizzes.impl.QuizzesImpl.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.SERVICE_URL);
	com.wiris.quizzes.impl.QuizzesServiceImpl.deploymentId = com.wiris.quizzes.impl.QuizzesImpl.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.DEPLOYMENT_ID);
	com.wiris.quizzes.impl.QuizzesServiceImpl.licenseId = com.wiris.quizzes.impl.QuizzesImpl.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.LICENSE_ID);
};
com.wiris.quizzes.impl.QuizzesServiceImpl.__name__ = ["com","wiris","quizzes","impl","QuizzesServiceImpl"];
com.wiris.quizzes.impl.QuizzesServiceImpl.__interfaces__ = [com.wiris.quizzes.api.QuizzesService];
com.wiris.quizzes.impl.QuizzesServiceImpl.getDeploymentId = function() {
	return com.wiris.quizzes.impl.QuizzesServiceImpl.deploymentId == null?"null":com.wiris.quizzes.impl.QuizzesServiceImpl.deploymentId;
}
com.wiris.quizzes.impl.QuizzesServiceImpl.getLicenseId = function() {
	return com.wiris.quizzes.impl.QuizzesServiceImpl.licenseId == null?"null":com.wiris.quizzes.impl.QuizzesServiceImpl.licenseId;
}
com.wiris.quizzes.impl.QuizzesServiceImpl.prototype = {
	getServiceUrl: function() {
		var url = this.url;
		if(this.protocol == com.wiris.quizzes.impl.QuizzesServiceImpl.PROTOCOL_REST) url += "/rest";
		return url;
	}
	,webServiceEnvelope: function(data) {
		if(this.protocol == com.wiris.quizzes.impl.QuizzesServiceImpl.PROTOCOL_REST) data = "<doProcessQuestions>" + data + "</doProcessQuestions>";
		return data;
	}
	,callService: function(mqr,cache,listener,async) {
		var aqr = mqr.questionRequests;
		var s = new com.wiris.util.xml.XmlSerializer();
		s.setCached(cache);
		var _g = 0;
		while(_g < aqr.length) {
			var qr = aqr[_g];
			++_g;
			if(!cache && com.wiris.quizzes.impl.QuizzesServiceImpl.USE_CACHE) qr.addProcess(new com.wiris.quizzes.impl.ProcessStoreQuestion());
		}
		var postData = this.webServiceEnvelope(s.write(mqr));
		var httpl = new com.wiris.quizzes.impl.HttpToQuizzesListener(listener,mqr,this,async);
		var http = com.wiris.quizzes.impl.QuizzesImpl.getInstance().getHttpObject(httpl,this.getServiceUrl(),"quizzes",postData);
		http.setAsync(async);
		http.request(true);
	}
	,executeMultipleImpl: function(mqr,listener,async) {
		var cache = com.wiris.quizzes.impl.QuizzesServiceImpl.USE_CACHE;
		var i = 0;
		while(cache && i < mqr.questionRequests.length) {
			var q = mqr.questionRequests[i].question;
			cache = cache && q.hasId();
			i++;
		}
		this.callService(mqr,cache,listener,async);
	}
	,executeMultiple: function(mqr) {
		var listener = new com.wiris.quizzes.impl.QuizzesServiceSyncListener();
		this.executeMultipleImpl(mqr,listener,false);
		return listener.mqs;
	}
	,executeMultipleAsync: function(req,listener) {
		this.executeMultipleImpl(req,listener,true);
	}
	,singleResponse: function(mqs) {
		if(mqs.questionResponses.length == 0) return new com.wiris.quizzes.impl.QuestionResponseImpl(); else return mqs.questionResponses[0];
	}
	,multipleRequest: function(req) {
		var reqi = req;
		var mqr = new com.wiris.quizzes.impl.MultipleQuestionRequest();
		mqr.questionRequests = new Array();
		mqr.questionRequests.push(reqi);
		return mqr;
	}
	,executeAsync: function(req,listener) {
		var mqr = this.multipleRequest(req);
		this.executeMultipleAsync(mqr,new com.wiris.quizzes.impl.QuizzesServiceSingleListener(listener));
	}
	,execute: function(req) {
		var mqr = this.multipleRequest(req);
		var mqs = this.executeMultiple(mqr);
		return this.singleResponse(mqs);
	}
	,protocol: null
	,url: null
	,__class__: com.wiris.quizzes.impl.QuizzesServiceImpl
}
com.wiris.quizzes.impl.OfflineQuizzesServiceImpl = $hxClasses["com.wiris.quizzes.impl.OfflineQuizzesServiceImpl"] = function() {
	com.wiris.quizzes.impl.QuizzesServiceImpl.call(this);
};
com.wiris.quizzes.impl.OfflineQuizzesServiceImpl.__name__ = ["com","wiris","quizzes","impl","OfflineQuizzesServiceImpl"];
com.wiris.quizzes.impl.OfflineQuizzesServiceImpl.__super__ = com.wiris.quizzes.impl.QuizzesServiceImpl;
com.wiris.quizzes.impl.OfflineQuizzesServiceImpl.prototype = $extend(com.wiris.quizzes.impl.QuizzesServiceImpl.prototype,{
	isTrialLimitExceeded: function(data) {
		return this.isFaultMessage(data) && StringTools.startsWith(this.getFaultMessage(data),"TRIALVERSIONLIMITEXCEEDED");
	}
	,getFaultMessage: function(data) {
		var start = data.indexOf("<fault>") + "<fault>".length;
		var end = data.indexOf("</fault>");
		var msg = HxOverrides.substr(data,start,end - start);
		return com.wiris.util.xml.WXmlUtils.htmlUnescape(msg);
	}
	,isFaultMessage: function(data) {
		return data.indexOf("<fault>") != -1;
	}
	,stripDoProcessQuestion: function(data) {
		var startTagName = "doProcessQuestionsResponse";
		var start = data.indexOf("<" + startTagName + ">") + startTagName.length + 2;
		var end = data.indexOf("</" + startTagName + ">");
		data = HxOverrides.substr(data,start,end - start);
		return data;
	}
	,callOfflineService: function(postData) {
		return androidQuizzesPublicServices.doProcessQuestions(postData);
	}
	,callService: function(mqr,cache,listener,async) {
		var s = new com.wiris.util.xml.XmlSerializer();
		s.setCached(cache);
		var postData = s.write(mqr);
		var response = this.callOfflineService(postData);
		if(this.isTrialLimitExceeded(response)) throw "The number of allowed executions of this trial version is over. If you want a license for unlimited use of Wiris Quizzes, please find us at www.wiris.com.";
		if(this.isFaultMessage(response)) throw "Wiris Quizzes service error: " + this.getFaultMessage(response);
		response = this.stripDoProcessQuestion(response);
		var res = com.wiris.quizzes.impl.QuizzesImpl.getInstance().newMultipleResponseFromXml(response);
		listener.onResponse(res);
	}
	,__class__: com.wiris.quizzes.impl.OfflineQuizzesServiceImpl
});
com.wiris.quizzes.impl.Option = $hxClasses["com.wiris.quizzes.impl.Option"] = function() {
	com.wiris.quizzes.impl.MathContent.call(this);
};
com.wiris.quizzes.impl.Option.__name__ = ["com","wiris","quizzes","impl","Option"];
com.wiris.quizzes.impl.Option.__super__ = com.wiris.quizzes.impl.MathContent;
com.wiris.quizzes.impl.Option.prototype = $extend(com.wiris.quizzes.impl.MathContent.prototype,{
	onSerialize: function(s) {
		s.beginTag("option");
		this.name = s.attributeString("name",this.name,null);
		com.wiris.quizzes.impl.MathContent.prototype.onSerializeInner.call(this,s);
		s.endTag();
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.Option();
	}
	,name: null
	,__class__: com.wiris.quizzes.impl.Option
});
com.wiris.quizzes.impl.Parameter = $hxClasses["com.wiris.quizzes.impl.Parameter"] = function() {
	com.wiris.quizzes.impl.MathContent.call(this);
};
com.wiris.quizzes.impl.Parameter.__name__ = ["com","wiris","quizzes","impl","Parameter"];
com.wiris.quizzes.impl.Parameter.__super__ = com.wiris.quizzes.impl.MathContent;
com.wiris.quizzes.impl.Parameter.prototype = $extend(com.wiris.quizzes.impl.MathContent.prototype,{
	onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.Parameter.tagName);
		this.name = s.attributeString("name",this.name,null);
		com.wiris.quizzes.impl.MathContent.prototype.onSerializeInner.call(this,s);
		s.endTag();
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.Parameter();
	}
	,name: null
	,__class__: com.wiris.quizzes.impl.Parameter
});
com.wiris.quizzes.impl.Process = $hxClasses["com.wiris.quizzes.impl.Process"] = function() {
	com.wiris.util.xml.SerializableImpl.call(this);
};
com.wiris.quizzes.impl.Process.__name__ = ["com","wiris","quizzes","impl","Process"];
com.wiris.quizzes.impl.Process.__super__ = com.wiris.util.xml.SerializableImpl;
com.wiris.quizzes.impl.Process.prototype = $extend(com.wiris.util.xml.SerializableImpl.prototype,{
	newInstance: function() {
		return new com.wiris.quizzes.impl.Process();
	}
	,onSerialize: function(s) {
	}
	,__class__: com.wiris.quizzes.impl.Process
});
com.wiris.quizzes.impl.ProcessGetCheckAssertions = $hxClasses["com.wiris.quizzes.impl.ProcessGetCheckAssertions"] = function() {
	com.wiris.quizzes.impl.Process.call(this);
};
com.wiris.quizzes.impl.ProcessGetCheckAssertions.__name__ = ["com","wiris","quizzes","impl","ProcessGetCheckAssertions"];
com.wiris.quizzes.impl.ProcessGetCheckAssertions.__super__ = com.wiris.quizzes.impl.Process;
com.wiris.quizzes.impl.ProcessGetCheckAssertions.prototype = $extend(com.wiris.quizzes.impl.Process.prototype,{
	newInstance: function() {
		return new com.wiris.quizzes.impl.ProcessGetCheckAssertions();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.ProcessGetCheckAssertions.tagName);
		s.endTag();
	}
	,__class__: com.wiris.quizzes.impl.ProcessGetCheckAssertions
});
com.wiris.quizzes.impl.ProcessGetFeaturedAssertions = $hxClasses["com.wiris.quizzes.impl.ProcessGetFeaturedAssertions"] = function() {
	com.wiris.quizzes.impl.Process.call(this);
};
com.wiris.quizzes.impl.ProcessGetFeaturedAssertions.__name__ = ["com","wiris","quizzes","impl","ProcessGetFeaturedAssertions"];
com.wiris.quizzes.impl.ProcessGetFeaturedAssertions.__super__ = com.wiris.quizzes.impl.Process;
com.wiris.quizzes.impl.ProcessGetFeaturedAssertions.prototype = $extend(com.wiris.quizzes.impl.Process.prototype,{
	newInstance: function() {
		return new com.wiris.quizzes.impl.ProcessGetFeaturedAssertions();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.ProcessGetFeaturedAssertions.TAGNAME);
		s.endTag();
	}
	,__class__: com.wiris.quizzes.impl.ProcessGetFeaturedAssertions
});
com.wiris.quizzes.impl.ProcessGetFeaturedSyntaxAssertions = $hxClasses["com.wiris.quizzes.impl.ProcessGetFeaturedSyntaxAssertions"] = function() {
	com.wiris.quizzes.impl.Process.call(this);
};
com.wiris.quizzes.impl.ProcessGetFeaturedSyntaxAssertions.__name__ = ["com","wiris","quizzes","impl","ProcessGetFeaturedSyntaxAssertions"];
com.wiris.quizzes.impl.ProcessGetFeaturedSyntaxAssertions.__super__ = com.wiris.quizzes.impl.Process;
com.wiris.quizzes.impl.ProcessGetFeaturedSyntaxAssertions.prototype = $extend(com.wiris.quizzes.impl.Process.prototype,{
	newInstance: function() {
		return new com.wiris.quizzes.impl.ProcessGetFeaturedSyntaxAssertions();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.ProcessGetFeaturedSyntaxAssertions.TAGNAME);
		s.endTag();
	}
	,__class__: com.wiris.quizzes.impl.ProcessGetFeaturedSyntaxAssertions
});
com.wiris.quizzes.impl.ProcessGetTranslation = $hxClasses["com.wiris.quizzes.impl.ProcessGetTranslation"] = function() {
	com.wiris.quizzes.impl.Process.call(this);
};
com.wiris.quizzes.impl.ProcessGetTranslation.__name__ = ["com","wiris","quizzes","impl","ProcessGetTranslation"];
com.wiris.quizzes.impl.ProcessGetTranslation.__super__ = com.wiris.quizzes.impl.Process;
com.wiris.quizzes.impl.ProcessGetTranslation.prototype = $extend(com.wiris.quizzes.impl.Process.prototype,{
	newInstance: function() {
		return new com.wiris.quizzes.impl.ProcessGetTranslation();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.ProcessGetTranslation.tagName);
		this.lang = s.attributeString("lang",this.lang,null);
		s.endTag();
	}
	,lang: null
	,__class__: com.wiris.quizzes.impl.ProcessGetTranslation
});
com.wiris.quizzes.impl.ProcessGetVariables = $hxClasses["com.wiris.quizzes.impl.ProcessGetVariables"] = function() {
	com.wiris.quizzes.impl.Process.call(this);
};
com.wiris.quizzes.impl.ProcessGetVariables.__name__ = ["com","wiris","quizzes","impl","ProcessGetVariables"];
com.wiris.quizzes.impl.ProcessGetVariables.__super__ = com.wiris.quizzes.impl.Process;
com.wiris.quizzes.impl.ProcessGetVariables.prototype = $extend(com.wiris.quizzes.impl.Process.prototype,{
	newInstance: function() {
		return new com.wiris.quizzes.impl.ProcessGetVariables();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.ProcessGetVariables.TAGNAME);
		this.names = s.attributeString("names",this.names,null);
		this.type = s.attributeString("type",this.type,"mathml");
		s.endTag();
	}
	,type: null
	,names: null
	,__class__: com.wiris.quizzes.impl.ProcessGetVariables
});
com.wiris.quizzes.impl.ProcessStoreQuestion = $hxClasses["com.wiris.quizzes.impl.ProcessStoreQuestion"] = function() {
	com.wiris.quizzes.impl.Process.call(this);
};
com.wiris.quizzes.impl.ProcessStoreQuestion.__name__ = ["com","wiris","quizzes","impl","ProcessStoreQuestion"];
com.wiris.quizzes.impl.ProcessStoreQuestion.__super__ = com.wiris.quizzes.impl.Process;
com.wiris.quizzes.impl.ProcessStoreQuestion.prototype = $extend(com.wiris.quizzes.impl.Process.prototype,{
	newInstance: function() {
		return new com.wiris.quizzes.impl.ProcessStoreQuestion();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.ProcessStoreQuestion.TAGNAME);
		s.endTag();
	}
	,__class__: com.wiris.quizzes.impl.ProcessStoreQuestion
});
com.wiris.quizzes.impl.Property = $hxClasses["com.wiris.quizzes.impl.Property"] = function() {
	com.wiris.util.xml.SerializableImpl.call(this);
};
com.wiris.quizzes.impl.Property.__name__ = ["com","wiris","quizzes","impl","Property"];
com.wiris.quizzes.impl.Property.__super__ = com.wiris.util.xml.SerializableImpl;
com.wiris.quizzes.impl.Property.prototype = $extend(com.wiris.util.xml.SerializableImpl.prototype,{
	newInstance: function() {
		return new com.wiris.quizzes.impl.Property();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.Property.tagName);
		this.name = s.attributeString("name",this.name,null);
		this.value = s.textContent(this.value);
		s.endTag();
	}
	,value: null
	,name: null
	,__class__: com.wiris.quizzes.impl.Property
});
com.wiris.quizzes.impl.QuestionInternal = $hxClasses["com.wiris.quizzes.impl.QuestionInternal"] = function() {
	com.wiris.util.xml.SerializableImpl.call(this);
};
com.wiris.quizzes.impl.QuestionInternal.__name__ = ["com","wiris","quizzes","impl","QuestionInternal"];
com.wiris.quizzes.impl.QuestionInternal.__interfaces__ = [com.wiris.quizzes.api.Question];
com.wiris.quizzes.impl.QuestionInternal.__super__ = com.wiris.util.xml.SerializableImpl;
com.wiris.quizzes.impl.QuestionInternal.prototype = $extend(com.wiris.util.xml.SerializableImpl.prototype,{
	getDeprecationWarnings: function() {
		return null;
	}
	,getProperty: function(name) {
		return null;
	}
	,setProperty: function(name,value) {
	}
	,getAlgorithm: function() {
		return null;
	}
	,setAlgorithm: function(session) {
	}
	,getCorrectAnswersLength: function() {
		return 0;
	}
	,getCorrectAnswer: function(index) {
		return null;
	}
	,setCorrectAnswer: function(index,answer) {
	}
	,getAnswerFieldType: function() {
		return com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_MATH_EDITOR;
	}
	,setAnswerFieldType: function(type) {
	}
	,removeSlot: function(slot) {
	}
	,addNewSlotFromModel: function(slot) {
		return null;
	}
	,addNewSlot: function() {
		return null;
	}
	,getSlots: function() {
		return null;
	}
	,setOption: function(name,value) {
	}
	,addAssertion: function(name,correctAnswer,studentAnswer,parameters) {
	}
	,getStudentQuestion: function() {
		return null;
	}
	,hasId: function() {
		return false;
	}
	,setId: function(id) {
	}
	,getImpl: function() {
		return null;
	}
	,__class__: com.wiris.quizzes.impl.QuestionInternal
});
com.wiris.quizzes.impl.QuestionImpl = $hxClasses["com.wiris.quizzes.impl.QuestionImpl"] = function() {
	com.wiris.quizzes.impl.QuestionInternal.call(this);
	this.deprecationWarnings = new Array();
	if(com.wiris.quizzes.impl.QuestionImpl.defaultOptions == null) com.wiris.quizzes.impl.QuestionImpl.defaultOptions = com.wiris.quizzes.impl.QuestionImpl.getDefaultOptions();
};
com.wiris.quizzes.impl.QuestionImpl.__name__ = ["com","wiris","quizzes","impl","QuestionImpl"];
com.wiris.quizzes.impl.QuestionImpl.removeLocalDataFromArray = function(name,localData) {
	if(localData != null) {
		var i = localData.length - 1;
		while(i >= 0) {
			if(localData[i].name == name) HxOverrides.remove(localData,localData[i]);
			i--;
		}
	}
}
com.wiris.quizzes.impl.QuestionImpl.getDefaultOptions = function() {
	var dopt = new Hash();
	dopt.set(com.wiris.quizzes.api.QuizzesConstants.OPTION_EXPONENTIAL_E,"e");
	dopt.set(com.wiris.quizzes.api.QuizzesConstants.OPTION_IMAGINARY_UNIT,"i");
	dopt.set(com.wiris.quizzes.api.QuizzesConstants.OPTION_IMPLICIT_TIMES_OPERATOR,"false");
	dopt.set(com.wiris.quizzes.api.QuizzesConstants.OPTION_NUMBER_PI,com.wiris.system.Utf8.uchr(960));
	dopt.set(com.wiris.quizzes.api.QuizzesConstants.OPTION_PRECISION,"4");
	dopt.set(com.wiris.quizzes.api.QuizzesConstants.OPTION_RELATIVE_TOLERANCE,"true");
	dopt.set(com.wiris.quizzes.api.QuizzesConstants.OPTION_TIMES_OPERATOR,com.wiris.system.Utf8.uchr(183));
	dopt.set(com.wiris.quizzes.api.QuizzesConstants.OPTION_TOLERANCE,"0.001");
	dopt.set(com.wiris.quizzes.api.QuizzesConstants.OPTION_TOLERANCE_DIGITS,"false");
	dopt.set(com.wiris.quizzes.api.QuizzesConstants.OPTION_FLOAT_FORMAT,"mg");
	dopt.set(com.wiris.quizzes.api.QuizzesConstants.OPTION_DECIMAL_SEPARATOR,".");
	dopt.set(com.wiris.quizzes.api.QuizzesConstants.OPTION_DIGIT_GROUP_SEPARATOR,"");
	dopt.set(com.wiris.quizzes.api.QuizzesConstants.OPTION_STUDENT_ANSWER_PARAMETER,"false");
	dopt.set(com.wiris.quizzes.api.QuizzesConstants.OPTION_STUDENT_ANSWER_PARAMETER_NAME,"answer");
	return dopt;
}
com.wiris.quizzes.impl.QuestionImpl.setLocalDataToArray = function(name,value,ld) {
	var data = new com.wiris.quizzes.impl.LocalData();
	data.name = name;
	data.value = value;
	var i;
	var found = false;
	var _g1 = 0, _g = ld.length;
	while(_g1 < _g) {
		var i1 = _g1++;
		if(ld[i1].name == name) {
			ld[i1] = data;
			found = true;
		}
	}
	if(!found) ld.push(data);
}
com.wiris.quizzes.impl.QuestionImpl.getLocalDataFromArray = function(name,ld) {
	if(ld != null) {
		var i;
		var _g1 = 0, _g = ld.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(ld[i1].name == name) return ld[i1].value;
		}
	}
	return null;
}
com.wiris.quizzes.impl.QuestionImpl.__super__ = com.wiris.quizzes.impl.QuestionInternal;
com.wiris.quizzes.impl.QuestionImpl.prototype = $extend(com.wiris.quizzes.impl.QuestionInternal.prototype,{
	getDeprecationWarnings: function() {
		return this.deprecationWarnings;
	}
	,clearDeprecationWarnings: function() {
		this.deprecationWarnings = new Array();
	}
	,removeCorrectAnswer: function(index) {
		var _g = 0, _g1 = this.slots;
		while(_g < _g1.length) {
			var s = _g1[_g];
			++_g;
			var aaa = s.authorAnswers;
			var _g2 = 0;
			while(_g2 < aaa.length) {
				var aa = aaa[_g2];
				++_g2;
				var aaIndex = Std.parseInt(aa.id);
				if(aaIndex == index) {
					s.removeAuthorAnswer(aa);
					return;
				}
			}
		}
	}
	,prepareForSlots: function() {
		var correctAnswersToSlots = new Hash();
		var assertionCorrectAnswerIndexes = new Array();
		var assertionAnswerIndexes = new Array();
		var _g = 0, _g1 = this.assertions;
		while(_g < _g1.length) {
			var a = _g1[_g];
			++_g;
			if(a.answer != null && a.answer.length >= 2) return false;
			var slotIndex = a.getAnswer();
			var slotIndexI = Std.parseInt(slotIndex);
			if(!com.wiris.system.ArrayEx.contains(assertionAnswerIndexes,slotIndexI)) assertionAnswerIndexes.push(slotIndexI);
			var correctAnswers = a.getCorrectAnswers();
			var _g2 = 0;
			while(_g2 < correctAnswers.length) {
				var caIndex = correctAnswers[_g2];
				++_g2;
				if(correctAnswersToSlots.exists(caIndex) && !(correctAnswersToSlots.get(caIndex) == slotIndex)) return false;
				var caIndexI = Std.parseInt(caIndex);
				if(!com.wiris.system.ArrayEx.contains(assertionCorrectAnswerIndexes,caIndexI)) assertionCorrectAnswerIndexes.push(caIndexI);
				correctAnswersToSlots.set(caIndex,slotIndex);
			}
		}
		var questionCorrectAnswerIndexes = new Array();
		if(this.correctAnswers != null) {
			var _g = 0, _g1 = this.correctAnswers;
			while(_g < _g1.length) {
				var ca = _g1[_g];
				++_g;
				var id = Std.parseInt(ca.id);
				if(!com.wiris.system.ArrayEx.contains(questionCorrectAnswerIndexes,id)) questionCorrectAnswerIndexes.push(id);
			}
		} else this.correctAnswers = new Array();
		var _g = 0;
		while(_g < questionCorrectAnswerIndexes.length) {
			var index = questionCorrectAnswerIndexes[_g];
			++_g;
			if(!com.wiris.system.ArrayEx.contains(assertionCorrectAnswerIndexes,index)) {
				var bound = false;
				var answerIndex = assertionAnswerIndexes[assertionAnswerIndexes.length - 1];
				while(answerIndex >= 0 && !bound) {
					var _g1 = 0, _g2 = this.assertions;
					while(_g1 < _g2.length) {
						var assertion = _g2[_g1];
						++_g1;
						if(assertion.isSyntactic() && assertion.hasAnswer(answerIndex + "")) {
							assertion.addCorrectAnswer(index + "");
							bound = true;
						}
					}
					answerIndex--;
				}
				if(!bound) {
					var a = com.wiris.quizzes.impl.SyntaxAssertion.getDefaultSyntax();
					a.setCorrectAnswer(index + "");
					a.setAnswer(index + "");
					this.assertions.push(a);
				}
			}
		}
		var _g = 0;
		while(_g < assertionCorrectAnswerIndexes.length) {
			var index = assertionCorrectAnswerIndexes[_g];
			++_g;
			if(!com.wiris.system.ArrayEx.contains(questionCorrectAnswerIndexes,index)) {
				var ca = new com.wiris.quizzes.impl.CorrectAnswer();
				ca.id = index + "";
				ca.set("");
				this.correctAnswers.splice(index,0,ca);
			}
		}
		return true;
	}
	,ensureSlotsAndAuthorAnswersHaveReferences: function() {
		if(this.slots == null) return;
		var _g = 0, _g1 = this.slots;
		while(_g < _g1.length) {
			var s = _g1[_g];
			++_g;
			s.question = this;
			if(s.authorAnswers != null) {
				var authorAnswers = s.authorAnswers;
				var _g2 = 0;
				while(_g2 < authorAnswers.length) {
					var aa = authorAnswers[_g2];
					++_g2;
					aa.question = this;
					aa.slot = s;
				}
			}
		}
	}
	,getSlotCorrectAnswersIds: function(slot) {
		var aa = slot.authorAnswers;
		var correctAnswers = new Array();
		var _g1 = 0, _g = aa.length;
		while(_g1 < _g) {
			var i = _g1++;
			correctAnswers[i] = aa[i].id;
		}
		return correctAnswers;
	}
	,assertionIndex: function(a) {
		var _g1 = 0, _g = this.assertions.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(this.assertions[i] == a) return i;
		}
		return -1;
	}
	,updateSlotsImpl: function(overrideDeprecated) {
		if(this.slots == null) this.slots = new Array();
		if(this.assertions == null || this.assertions.length == 0) {
			if(this.correctAnswers == null || this.correctAnswers.length == 0) return;
			var _g = 0, _g1 = this.correctAnswers;
			while(_g < _g1.length) {
				var ca = _g1[_g];
				++_g;
				var s = this.addNewSlot();
				var aa = com.wiris.quizzes.impl.AuthorAnswerImpl.newWithQuestionCallback(this,s);
				aa.value = ca;
				aa.id = ca.id;
				s.syntax.setCorrectAnswer(aa.id);
				s.authorAnswers.push(aa);
				this.assertionAdded(aa.comparison,aa.id,s.id);
			}
			return;
		}
		if(!this.prepareForSlots() || this.isDeprecated() == com.wiris.quizzes.impl.QuestionImpl.DEPRECATED_NEEDS_CHECK && !overrideDeprecated) {
			this.slots = null;
			return;
		}
		this.importDeprecated();
		var assertionsCopy = new Array();
		var _g = 0, _g1 = this.assertions;
		while(_g < _g1.length) {
			var a = _g1[_g];
			++_g;
			assertionsCopy.push(a);
		}
		var _g1 = 0, _g = assertionsCopy.length;
		while(_g1 < _g) {
			var i = _g1++;
			var a = assertionsCopy[i];
			var slotId = Std.parseInt(a.getAnswer());
			var correctAnswers = a.getCorrectAnswers();
			while(slotId >= this.slots.length) {
				var localData = this.slots.length > 0?this.slots[this.slots.length - 1].localData:null;
				var slot = this.addNewSlot();
				slot.syntax.setCorrectAnswers(correctAnswers);
				if(localData != null) {
					slot.localData = new Array();
					var _g2 = 0;
					while(_g2 < localData.length) {
						var datum = localData[_g2];
						++_g2;
						var newDatum = new com.wiris.quizzes.impl.LocalData();
						newDatum.name = datum.name;
						newDatum.value = datum.value;
						slot.localData.push(newDatum);
					}
				}
			}
			var slot = this.slots[slotId];
			var _g2 = 0;
			while(_g2 < correctAnswers.length) {
				var caIndex = correctAnswers[_g2];
				++_g2;
				var authorAnswers = slot.authorAnswers;
				var correctAnswer = null;
				var _g3 = 0;
				while(_g3 < authorAnswers.length) {
					var authorAnswer = authorAnswers[_g3];
					++_g3;
					if(caIndex == authorAnswer.id) {
						correctAnswer = authorAnswer;
						break;
					}
				}
				if(correctAnswer == null) {
					correctAnswer = com.wiris.quizzes.impl.AuthorAnswerImpl.newWithQuestionCallback(this,slot);
					correctAnswer.id = caIndex;
					correctAnswer.comparison.setAnswer(slotId + "");
					correctAnswer.comparison.setCorrectAnswer(caIndex);
					correctAnswer.value = this.correctAnswers[Std.parseInt(caIndex)];
					this.assertions.push(correctAnswer.comparison);
					slot.authorAnswers.push(correctAnswer);
				}
				if(js.Boot.__instanceof(a,com.wiris.quizzes.impl.ComparisonAssertion)) {
					if(correctAnswer.comparison != a) {
						this.assertionRemoved(correctAnswer.comparison);
						correctAnswer.comparison = a;
					}
				} else if(js.Boot.__instanceof(a,com.wiris.quizzes.impl.ValidationAssertion)) {
					if(correctAnswer.getValidation(a.getName()) == null) correctAnswer.validations.push(a); else if(correctAnswer.getValidation(a.getName()) != a) {
						var _g4 = 0, _g3 = correctAnswer.validations.length;
						while(_g4 < _g3) {
							var j = _g4++;
							var v = correctAnswer.validations[j];
							if(v.name == a.name) {
								this.assertionRemoved(correctAnswer.validations[j]);
								correctAnswer.validations[j] = a;
							}
						}
					}
				} else if(a.isEquivalence()) {
					var comparisonAssertion = com.wiris.quizzes.impl.ComparisonAssertion.fromAssertion(a);
					this.assertionRemoved(correctAnswer.comparison);
					correctAnswer.comparison = comparisonAssertion;
					var index = this.assertionIndex(a);
					if(index != -1) this.assertions[index] = comparisonAssertion; else this.assertions.push(comparisonAssertion);
					a = comparisonAssertion;
				} else if(a.isCheck() || a.isStructure()) {
					var validationAssertion = com.wiris.quizzes.impl.ValidationAssertion.fromAssertion(a);
					if(correctAnswer.getValidation(validationAssertion.getName()) == null) correctAnswer.validations.push(validationAssertion); else {
						var _g4 = 0, _g3 = correctAnswer.validations.length;
						while(_g4 < _g3) {
							var j = _g4++;
							var v = correctAnswer.validations[j];
							if(v.name == validationAssertion.name) {
								this.assertionRemoved(correctAnswer.validations[j]);
								correctAnswer.validations[j] = validationAssertion;
							}
						}
					}
					var index = this.assertionIndex(a);
					if(index != -1) this.assertions[index] = validationAssertion; else this.assertions.push(validationAssertion);
					a = validationAssertion;
				}
			}
			if(js.Boot.__instanceof(a,com.wiris.quizzes.impl.SyntaxAssertion)) {
				if(slot.syntax != a) {
					this.assertionRemoved(slot.syntax);
					slot.syntax = a;
				}
				slot.syntax.setCorrectAnswers(this.getSlotCorrectAnswersIds(slot));
			} else if(a.isSyntactic()) {
				var syntaxAssertion = com.wiris.quizzes.impl.SyntaxAssertion.fromAssertion(a);
				this.assertionRemoved(slot.syntax);
				slot.syntax = syntaxAssertion;
				slot.syntax.setCorrectAnswers(this.getSlotCorrectAnswersIds(slot));
				var index = this.assertionIndex(a);
				if(index != -1) this.assertions[index] = syntaxAssertion; else this.assertions.push(syntaxAssertion);
				a = syntaxAssertion;
			}
		}
		this.ensureSlotsAndAuthorAnswersHaveReferences();
	}
	,forceSlotStructure: function() {
		this.updateSlotsImpl(true);
	}
	,updateSlots: function() {
		this.updateSlotsImpl(false);
	}
	,assertionRemoved: function(assertion) {
		if(assertion == null) return;
		this.id = null;
		HxOverrides.remove(this.assertions,assertion);
	}
	,assertionAdded: function(assertion,correctAnswerId,userAnswerId) {
		if(assertion == null) return; else if(this.assertions == null) this.assertions = new Array();
		this.id = null;
		if(correctAnswerId != null) assertion.setCorrectAnswer(correctAnswerId);
		if(userAnswerId != null) assertion.setAnswer(userAnswerId);
		var name = assertion.name;
		var correctAnswer = assertion.getCorrectAnswer();
		var userAnswer = assertion.getAnswer();
		var index = this.getAssertionIndex(name,correctAnswer,userAnswer);
		if(index == -1) this.assertions.push(assertion); else this.assertions[index] = assertion;
	}
	,authorAnswerRemoved: function(authorAnswer) {
		this.id = null;
		this.assertionRemoved(authorAnswer.comparison);
		var validations = authorAnswer.validations;
		var _g = 0;
		while(_g < validations.length) {
			var a = validations[_g];
			++_g;
			this.assertionRemoved(a);
		}
		var index = Std.parseInt(authorAnswer.id);
		HxOverrides.remove(this.correctAnswers,this.correctAnswers[index]);
		var _g = 0, _g1 = this.slots;
		while(_g < _g1.length) {
			var s = _g1[_g];
			++_g;
			var aaa = s.authorAnswers;
			var ids = new Array();
			var i = 0;
			var _g2 = 0;
			while(_g2 < aaa.length) {
				var aa = aaa[_g2];
				++_g2;
				var aaIndex = Std.parseInt(aa.id);
				if(aaIndex > index) {
					aaIndex--;
					aa.id = aaIndex + "";
					aa.value.id = aa.id;
					aa.comparison.setCorrectAnswer(aa.id);
					var vaa = aa.validations;
					var _g3 = 0;
					while(_g3 < vaa.length) {
						var va = vaa[_g3];
						++_g3;
						va.setCorrectAnswer(aa.id);
					}
				}
				ids[i++] = aa.id;
			}
			s.syntax.setCorrectAnswers(ids);
		}
	}
	,authorAnswerAdded: function(authorAnswer,slot) {
		this.id = null;
		if(this.correctAnswers == null) this.correctAnswers = new Array();
		var index = this.correctAnswers.length;
		authorAnswer.id = index + "";
		authorAnswer.value.id = index + "";
		this.correctAnswers.push(authorAnswer.value);
		this.assertionAdded(authorAnswer.comparison,authorAnswer.id,slot.id);
		slot.syntax.addCorrectAnswer(index + "");
		if(authorAnswer.validations != null && authorAnswer.validations.length > 0) {
			var validationAssertions = authorAnswer.validations;
			var _g = 0;
			while(_g < validationAssertions.length) {
				var validation = validationAssertions[_g];
				++_g;
				this.assertionAdded(validation,authorAnswer.id,slot.id);
			}
		}
	}
	,removeSlot: function(slot) {
		this.id = null;
		if(this.slots == null) return;
		var impl = slot;
		HxOverrides.remove(this.slots,impl);
		this.assertionRemoved(impl.syntax);
		var aaa = impl.authorAnswers;
		var _g = 0;
		while(_g < aaa.length) {
			var aa = aaa[_g];
			++_g;
			this.authorAnswerRemoved(aa);
		}
	}
	,addSlotImpl: function(slot) {
		this.id = null;
		if(this.slots == null) this.slots = new Array();
		slot.id = this.slots.length + "";
		this.slots.push(slot);
		this.assertionAdded(slot.syntax,null,slot.id);
	}
	,addNewSlotFromModel: function(slot) {
		var newSlot = this.addNewSlot();
		if(slot != null) newSlot.copyData(slot,true);
		return newSlot;
	}
	,addNewSlot: function() {
		var slot = com.wiris.quizzes.impl.SlotImpl.newWithQuestionCallback(this);
		this.addSlotImpl(slot);
		return slot;
	}
	,getSlots: function() {
		if(this.slots == null) return [];
		var slotsArray = new Array();
		slotsArray = this.slots.slice();
		return slotsArray;
	}
	,importQuestion: function(question) {
		this.id = question.id;
		this.wirisCasSession = question.wirisCasSession;
		this.options = question.options;
		this.correctAnswers = question.correctAnswers;
		this.assertions = question.assertions;
		this.localData = question.localData;
		this.slots = question.slots;
	}
	,getAssertion: function(i) {
		return this.assertions[i];
	}
	,getAssertionsLength: function() {
		return this.assertions == null?0:this.assertions.length;
	}
	,getProperty: function(name) {
		var key = com.wiris.quizzes.impl.QuizzesEnumUtils.propertyName2String(name);
		if(com.wiris.util.type.Arrays.containsArray(com.wiris.quizzes.impl.LocalData.keys,key)) return this.getLocalData(key); else return this.getOption(key);
	}
	,setProperty: function(name,value) {
		var key = com.wiris.quizzes.impl.QuizzesEnumUtils.propertyName2String(name);
		if(com.wiris.util.type.Arrays.containsArray(com.wiris.quizzes.impl.LocalData.keys,key)) this.setLocalData(key,value); else this.setOption(key,value);
	}
	,moveAnswers: function(correct,user) {
		this.id = null;
		var i;
		var answers = new Array();
		var _g1 = 0, _g = correct.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(i1 != correct[i1]) {
				answers[i1] = this.getCorrectAnswer(correct[i1]);
				if(answers[i1] == null) answers[i1] = "";
			}
		}
		var _g1 = 0, _g = correct.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(correct[i1] != i1) this.setCorrectAnswer(i1,answers[i1]);
		}
		if(this.correctAnswers != null) {
			i = this.correctAnswers.length - 1;
			while(i >= correct.length) {
				HxOverrides.remove(this.correctAnswers,this.correctAnswers[i]);
				i--;
			}
		}
		if(this.assertions != null) {
			var newAssertions = new Array();
			var _g1 = 0, _g = this.assertions.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var a = this.assertions[i1];
				var correctAnswers = a.getCorrectAnswers();
				var newCorrectAnswersArray = new Array();
				var j;
				var _g3 = 0, _g2 = correctAnswers.length;
				while(_g3 < _g2) {
					var j1 = _g3++;
					var k;
					var _g5 = 0, _g4 = correct.length;
					while(_g5 < _g4) {
						var k1 = _g5++;
						if(correct[k1] == Std.parseInt(correctAnswers[j1])) newCorrectAnswersArray.push(k1);
					}
				}
				if(newCorrectAnswersArray.length > 0) {
					var newCorrectAnswers = new Array();
					var _g3 = 0, _g2 = newCorrectAnswersArray.length;
					while(_g3 < _g2) {
						var j1 = _g3++;
						newCorrectAnswers[j1] = "" + newCorrectAnswersArray[j1];
					}
					if(correctAnswers.length > 1 || newCorrectAnswers.length == 1) {
						a.setCorrectAnswers(newCorrectAnswers);
						a.setAnswers(newCorrectAnswers);
						newAssertions.push(a);
					} else {
						var k;
						var _g3 = 0, _g2 = newCorrectAnswers.length;
						while(_g3 < _g2) {
							var k1 = _g3++;
							var b = a.copy();
							b.setCorrectAnswer(newCorrectAnswers[k1]);
							b.setAnswer(newCorrectAnswers[k1]);
							newAssertions.push(b);
						}
					}
				}
			}
			this.assertions = newAssertions;
		}
		this.slots = new Array();
		this.updateSlots();
	}
	,isImplicitOption: function(name,value) {
		var i = 0;
		while(i < com.wiris.quizzes.impl.Option.options.length) {
			if(com.wiris.quizzes.impl.Option.options[i] == name) break;
			i++;
		}
		return i >= 8 && this.defaultOption(name) == value;
	}
	,getAlgorithm: function() {
		if(com.wiris.quizzes.impl.HTMLTools.emptyCasSession(this.wirisCasSession)) return null; else return this.wirisCasSession;
	}
	,removeCalcOptions: function() {
		var _g1 = 0, _g = com.wiris.quizzes.impl.CalcDocumentTools.options.length;
		while(_g1 < _g) {
			var i = _g1++;
			var opt = com.wiris.quizzes.impl.CalcDocumentTools.options[i];
			this.removeOption(opt);
		}
	}
	,setAlgorithm: function(session) {
		if(com.wiris.quizzes.impl.HTMLTools.emptyCasSession(session)) session = null;
		if(session != this.wirisCasSession || session != null && !(session == this.wirisCasSession)) {
			this.id = null;
			if(com.wiris.quizzes.impl.CalcDocumentTools.isCalc(session)) {
				var sessionDocument = new com.wiris.quizzes.impl.CalcDocumentTools(session);
				if((this.wirisCasSession == null || !com.wiris.quizzes.impl.CalcDocumentTools.isCalc(this.wirisCasSession) || !this.getCalcDocument().hasQuizzesQuestionOptions()) && sessionDocument.hasQuizzesQuestionOptions()) this.removeCalcOptions();
				this.calcDocument = sessionDocument;
			} else this.calcDocument = null;
			this.wirisCasSession = session;
		}
	}
	,getAnswerFieldType: function() {
		var stringType = this.getProperty(com.wiris.quizzes.api.PropertyName.ANSWER_FIELD_TYPE);
		return com.wiris.quizzes.impl.QuizzesEnumUtils.string2answerFieldType(stringType);
	}
	,setAnswerFieldType: function(type) {
		if(type != null) this.setLocalData(com.wiris.quizzes.impl.LocalData.KEY_OPENANSWER_INPUT_FIELD,com.wiris.quizzes.impl.QuizzesEnumUtils.answerFieldType2String(type)); else throw "Invalid type parameter.";
	}
	,changeAssertionParamName: function(a,oldname,newname) {
		if(a.parameters != null) {
			var j;
			var _g1 = 0, _g = a.parameters.length;
			while(_g1 < _g) {
				var j1 = _g1++;
				if(a.parameters[j1].name == oldname) a.parameters[j1].name = newname;
			}
		}
	}
	,importTolerance: function(tolerance) {
		if(this.isDeprecatedTolerance(tolerance)) {
			var pattern10 = new EReg("^10\\^\\(-(.*)\\)$","");
			if(pattern10.match(tolerance)) {
				var exponent = StringTools.trim(pattern10.matched(1));
				if(StringTools.startsWith(exponent,"(") && StringTools.endsWith(exponent,")")) exponent = StringTools.trim(HxOverrides.substr(exponent,1,exponent.length - 2));
				if(com.wiris.system.TypeTools.isFloating(exponent)) {
					var expd = -Std.parseFloat(exponent);
					tolerance = Math.pow(10.0,expd) + "";
				} else {
					var patternlog = new EReg("-?log\\((.*)\\)","");
					if(patternlog.match(exponent)) {
						var arg = patternlog.matched(1);
						if(StringTools.startsWith(exponent,"-")) tolerance = arg; else if(com.wiris.system.TypeTools.isFloating(arg)) tolerance = 1.0 / Std.parseFloat(arg) + "";
					}
				}
			}
		}
		return tolerance;
	}
	,isDeprecatedTolerance: function(tol) {
		return tol.indexOf("10^") != -1;
	}
	,addDeprecationWarning: function(warning) {
		if(!com.wiris.system.ArrayEx.contains(this.deprecationWarnings,warning)) this.deprecationWarnings.push(warning);
	}
	,importDeprecated: function() {
		if(this.assertions != null) {
			var i;
			var _g1 = 0, _g = this.assertions.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var a = this.assertions[i1];
				if(a.name == com.wiris.quizzes.impl.Assertion.EQUIVALENT_SET) {
					a.name = com.wiris.quizzes.impl.Assertion.EQUIVALENT_SYMBOLIC;
					a.setParam(com.wiris.quizzes.impl.Assertion.PARAM_ORDER_MATTERS,"false");
					a.setParam(com.wiris.quizzes.impl.Assertion.PARAM_REPETITION_MATTERS,"false");
					this.addDeprecationWarning(com.wiris.quizzes.impl.QuestionImpl.EQUIVALENT_SET_ASSERTION);
				}
				if(a.name == com.wiris.quizzes.impl.Assertion.SYNTAX_LIST) {
					a.name = com.wiris.quizzes.impl.Assertion.EQUIVALENT_SYMBOLIC;
					a.setParam(com.wiris.quizzes.impl.Assertion.PARAM_NO_BRACKETS_LIST,"true");
					this.addDeprecationWarning(com.wiris.quizzes.impl.QuestionImpl.SYNTAX_LIST_ASSERTION);
				}
				if(a.name == com.wiris.quizzes.impl.Assertion.SYNTAX_EXPRESSION) {
					a.name = com.wiris.quizzes.impl.Assertion.SYNTAX_MATH;
					if(a.hasParam(com.wiris.quizzes.impl.Assertion.PARAM_TEXT_LOGIC_OPERATORS)) {
						a.removeParam(com.wiris.quizzes.impl.Assertion.PARAM_TEXT_LOGIC_OPERATORS);
						this.addDeprecationWarning(com.wiris.quizzes.impl.QuestionImpl.TEXT_LOGIC_OPERATORS);
					}
				}
				if(a.name == com.wiris.quizzes.impl.Assertion.SYNTAX_QUANTITY) {
					var constants = a.getParam("constants");
					var units = a.getParam("units");
					var unitPrefixes = a.getParam("unitprefixes");
					var itemseparators = a.getParam("itemseparators");
					var decimalseparators = a.getParam("decimalseparators");
					a.name = com.wiris.quizzes.impl.Assertion.SYNTAX_MATH;
					a.setParam("constants",constants);
					a.setParam("functions","");
					a.setParam("units",units);
					a.setParam("unitprefixes",unitPrefixes);
					a.setParam("itemseparators",itemseparators);
					a.setParam("decimalseparators",decimalseparators);
					a.setParam("ratio","true");
					a.setParam("scientificnotation","true");
				}
				if(a.name == com.wiris.quizzes.impl.Assertion.CHECK_NO_MORE_DECIMALS) {
					a.name = com.wiris.quizzes.impl.Assertion.CHECK_PRECISION;
					this.changeAssertionParamName(a,"digits","max");
					a.setParam("relative","false");
				}
				if(a.name == com.wiris.quizzes.impl.Assertion.CHECK_NO_MORE_DIGITS) {
					a.name = com.wiris.quizzes.impl.Assertion.CHECK_PRECISION;
					this.changeAssertionParamName(a,"digits","max");
					a.setParam("relative","true");
				}
				if(a.name == com.wiris.quizzes.impl.Assertion.CHECK_UNIT) {
					a.name = com.wiris.quizzes.impl.Assertion.CHECK_EQUIVALENT_UNITS;
					a.setParam(com.wiris.quizzes.impl.Assertion.PARAM_ALLOW_PREFIXES,"false");
					a.removeParam(com.wiris.quizzes.impl.Assertion.PARAM_UNIT);
				}
				if(a.name == com.wiris.quizzes.impl.Assertion.CHECK_UNIT_LITERAL) {
					a.name = com.wiris.quizzes.impl.Assertion.CHECK_EQUIVALENT_UNITS;
					a.setParam(com.wiris.quizzes.impl.Assertion.PARAM_ALLOW_PREFIXES,"false");
					a.removeParam(com.wiris.quizzes.impl.Assertion.PARAM_UNIT);
					this.addDeprecationWarning(com.wiris.quizzes.impl.QuestionImpl.EQUIVALENT_UNIT_LITERAL);
				}
				if(a.name == com.wiris.quizzes.impl.Assertion.EQUIVALENT_FUNCTION && a.hasParam(com.wiris.quizzes.impl.Assertion.PARAM_NOT_EVALUATE)) {
					var value = a.getParam(com.wiris.quizzes.impl.Assertion.PARAM_NOT_EVALUATE);
					a.removeParam(com.wiris.quizzes.impl.Assertion.PARAM_NOT_EVALUATE);
					a.setParam(com.wiris.quizzes.impl.Assertion.PARAM_FUNCTION_ARGUMENT_MODE,"true" == value?com.wiris.quizzes.impl.Assertion.PARAM_VALUE_FUNCTION_ARGUMENT_UNEVALUATED:com.wiris.quizzes.impl.Assertion.PARAM_VALUE_FUNCTION_ARGUMENT_EVALUATED);
				}
				if(a.isEquivalence()) {
					var tol = a.getParam(com.wiris.quizzes.api.QuizzesConstants.OPTION_TOLERANCE);
					if(tol != null && this.isDeprecatedTolerance(tol)) a.setParam(com.wiris.quizzes.api.QuizzesConstants.OPTION_TOLERANCE,this.importTolerance(tol));
				}
			}
		}
		var tolerance = this.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_TOLERANCE);
		if(this.isDeprecatedTolerance(tolerance)) this.setOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_TOLERANCE,this.importTolerance(tolerance));
	}
	,isAssertionDeprecatedCompatible: function(a) {
		return a.name == com.wiris.quizzes.impl.Assertion.CHECK_NO_MORE_DIGITS || a.name == com.wiris.quizzes.impl.Assertion.CHECK_NO_MORE_DECIMALS || a.name == com.wiris.quizzes.impl.Assertion.SYNTAX_EXPRESSION || a.name == com.wiris.quizzes.impl.Assertion.SYNTAX_QUANTITY || a.name == com.wiris.quizzes.impl.Assertion.CHECK_UNIT || a.name == com.wiris.quizzes.impl.Assertion.EQUIVALENT_FUNCTION && a.hasParam(com.wiris.quizzes.impl.Assertion.PARAM_NOT_EVALUATE);
	}
	,isAssertionDeprecatedNeedsCheck: function(a) {
		return a.name == com.wiris.quizzes.impl.Assertion.EQUIVALENT_SET || a.name == com.wiris.quizzes.impl.Assertion.SYNTAX_LIST || a.name == com.wiris.quizzes.impl.Assertion.CHECK_UNIT_LITERAL || a.name == com.wiris.quizzes.impl.Assertion.SYNTAX_EXPRESSION && a.hasParam(com.wiris.quizzes.impl.Assertion.PARAM_TEXT_LOGIC_OPERATORS);
	}
	,isDeprecated: function() {
		if(this.assertions != null) {
			var i;
			var _g1 = 0, _g = this.assertions.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var a = this.assertions[i1];
				if(this.isAssertionDeprecatedNeedsCheck(a)) return com.wiris.quizzes.impl.QuestionImpl.DEPRECATED_NEEDS_CHECK; else if(this.isAssertionDeprecatedCompatible(a)) return com.wiris.quizzes.impl.QuestionImpl.DEPRECATED_COMPATIBLE;
				if(a.isEquivalence()) {
					var tol = a.getParam(com.wiris.quizzes.api.QuizzesConstants.OPTION_TOLERANCE);
					if(tol != null && this.isDeprecatedTolerance(tol)) return com.wiris.quizzes.impl.QuestionImpl.DEPRECATED_COMPATIBLE;
				}
			}
		}
		if(this.isDeprecatedTolerance(this.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_TOLERANCE))) return com.wiris.quizzes.impl.QuestionImpl.DEPRECATED_COMPATIBLE;
		return com.wiris.quizzes.impl.QuestionImpl.NO_DEPRECATED;
	}
	,getImpl: function() {
		return this;
	}
	,hasId: function() {
		return this.id != null && this.id.length > 0;
	}
	,addAssertion: function(name,correctAnswer,studentAnswer,parameters) {
		this.setParametrizedAssertion(name,"" + correctAnswer,"" + studentAnswer,parameters);
	}
	,isEquivalent: function(q) {
		var te = com.wiris.quizzes.impl.HTMLTools.emptyCasSession(this.wirisCasSession);
		var qe = com.wiris.quizzes.impl.HTMLTools.emptyCasSession(q.wirisCasSession);
		if(te && !qe || !te && qe) return false; else if(!te && !qe && !(this.wirisCasSession == q.wirisCasSession)) return false;
		if(this.correctAnswers != null && q.correctAnswers != null) {
			if(this.correctAnswers.length != q.correctAnswers.length) return false;
			var i;
			var _g1 = 0, _g = this.correctAnswers.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var tca = this.correctAnswers[i1];
				var qca = q.correctAnswers[i1];
				if(!(tca.id == qca.id)) return false;
				if(!(tca.content == qca.content)) return false;
			}
		}
		if(this.assertions != null && q.assertions != null) {
			if(this.assertions.length != q.assertions.length) return false;
			var i;
			var _g1 = 0, _g = this.assertions.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var ta = this.assertions[i1];
				var qa = q.assertions[i1];
				if(ta.getCorrectAnswer() != qa.getCorrectAnswer() || ta.getAnswer() != qa.getAnswer() || !(ta.name == qa.name)) return false;
				if(ta.parameters == null && qa.parameters != null || ta.parameters != null && qa.parameters == null) return false;
				if(ta.parameters != null && qa.parameters != null) {
					if(ta.parameters.length != qa.parameters.length) return false;
					var j;
					var _g3 = 0, _g2 = ta.parameters.length;
					while(_g3 < _g2) {
						var j1 = _g3++;
						var tp = ta.parameters[j1];
						var qp = qa.parameters[j1];
						if(tp.name != qp.name || tp.content != qp.content) return false;
					}
				}
			}
		}
		var k;
		var _g1 = 0, _g = com.wiris.quizzes.impl.Option.options.length;
		while(_g1 < _g) {
			var k1 = _g1++;
			var to = this.getOption(com.wiris.quizzes.impl.Option.options[k1]);
			var qo = q.getOption(com.wiris.quizzes.impl.Option.options[k1]);
			if(to == null && qo != null || to != null && qo == null || !(to == qo)) return false;
		}
		var _g1 = 0, _g = com.wiris.quizzes.impl.LocalData.keys.length;
		while(_g1 < _g) {
			var k1 = _g1++;
			var td = this.getLocalData(com.wiris.quizzes.impl.LocalData.keys[k1]);
			var qd = q.getLocalData(com.wiris.quizzes.impl.LocalData.keys[k1]);
			if(td == null && qd != null || td != null && qd == null || !(td == qd)) return false;
		}
		return true;
	}
	,update: function(response) {
		this.id = null;
		var qs = response;
		if(qs != null && qs.results != null) {
			var i;
			var _g1 = 0, _g = qs.results.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var r = qs.results[i1];
				var s = com.wiris.quizzes.impl.QuizzesImpl.getInstance().getSerializer();
				var tag = s.getTagName(r);
				if(tag == com.wiris.quizzes.impl.ResultGetTranslation.tagName) {
					var rgt = r;
					this.wirisCasSession = StringTools.trim(rgt.wirisCasSession);
				}
			}
		}
	}
	,hideCompoundAnswerAnswers: function(m) {
		if(com.wiris.quizzes.impl.MathContent.getMathType(m) == com.wiris.quizzes.impl.MathContent.TYPE_GEOMETRY_FILE) {
			var geometryFile = com.wiris.util.geometry.GeometryFile.readJSON(m);
			geometryFile.data.remove(com.wiris.util.geometry.GeometryFile.CONSTRAINTS);
			geometryFile.data.remove(com.wiris.util.geometry.GeometryFile.HANDWRITING_TRACES);
			var elements = com.wiris.util.json.JSon.getArray(geometryFile.data.get(com.wiris.util.geometry.GeometryFile.ELEMENTS));
			var elements2 = new Array();
			var _g = 0;
			while(_g < elements.length) {
				var o = elements[_g];
				++_g;
				var element = com.wiris.util.json.JSon.getHash(o);
				var element2 = new Hash();
				element2.set(com.wiris.util.geometry.GeometryElement.ID,element.get(com.wiris.util.geometry.GeometryElement.ID));
				element2.set(com.wiris.util.geometry.GeometryElement.TYPE,element.get(com.wiris.util.geometry.GeometryElement.TYPE));
				elements2.push(element2);
			}
			geometryFile.data.set(com.wiris.util.geometry.GeometryElement.ELEMENTS,elements2);
			return geometryFile.toJSON();
		} else {
			var a = new com.wiris.quizzes.impl.MathContent();
			a.set(m);
			var c = com.wiris.quizzes.impl.CompoundAnswerParser.parseCompoundAnswer(a);
			var i;
			var _g1 = 0, _g = c.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				c[i1][1] = "<math></math>";
			}
			a = com.wiris.quizzes.impl.CompoundAnswerParser.joinCompoundAnswer(c);
			return a.content;
		}
	}
	,isQuestionCompoundAnswer: function() {
		return this.getProperty(com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER) == com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_COMPOUND_ANSWER_TRUE;
	}
	,isCompoundAnswer: function() {
		if(this.isQuestionCompoundAnswer()) return true;
		if(this.slots != null) {
			var _g = 0, _g1 = this.slots;
			while(_g < _g1.length) {
				var s = _g1[_g];
				++_g;
				if(s.isSlotCompoundAnswer()) return true;
			}
		}
		return false;
	}
	,getStudentQuestion: function() {
		var q = new com.wiris.quizzes.impl.QuestionImpl();
		q.id = this.id;
		var i;
		q.assertions = this.assertions;
		q.localData = this.localData;
		if(this.slots != null) {
			q.slots = new Array();
			var _g = 0, _g1 = this.slots;
			while(_g < _g1.length) {
				var s = _g1[_g];
				++_g;
				var sq = new com.wiris.quizzes.impl.SlotImpl();
				sq.question = q;
				sq.syntax = s.syntax;
				sq.localData = s.localData;
				sq.initialContent = s.initialContent;
				sq.id = s.id;
				q.slots.push(sq);
			}
		}
		if(this.isCompoundAnswer() && this.correctAnswers != null) {
			q.correctAnswers = new Array();
			if(this.isQuestionCompoundAnswer()) {
				var _g1 = 0, _g = this.correctAnswers.length;
				while(_g1 < _g) {
					var i1 = _g1++;
					var ca = this.correctAnswers[i1];
					var content = ca.content;
					if(ca.content != null && ca.content.length > 0) content = this.hideCompoundAnswerAnswers(ca.content);
					q.setCorrectAnswer(i1,content);
				}
			} else if(this.slots != null) {
				var _g = 0, _g1 = this.slots;
				while(_g < _g1.length) {
					var s = _g1[_g];
					++_g;
					if(s.isSlotCompoundAnswer()) {
						var aaa = s.authorAnswers;
						var _g2 = 0;
						while(_g2 < aaa.length) {
							var aa = aaa[_g2];
							++_g2;
							var ca = aa.value;
							var content = ca.content;
							if(ca.content != null && ca.content.length > 0) content = this.hideCompoundAnswerAnswers(ca.content);
							q.setCorrectAnswer(Std.parseInt(ca.id),content);
						}
					}
				}
			}
		}
		return q;
	}
	,defaultLocalData: function(name) {
		if(name == com.wiris.quizzes.impl.LocalData.KEY_OPENANSWER_COMPOUND_ANSWER) return com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_COMPOUND_ANSWER_FALSE; else if(name == com.wiris.quizzes.impl.LocalData.KEY_OPENANSWER_INPUT_FIELD) return com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_INPUT_FIELD_INLINE_EDITOR; else if(name == com.wiris.quizzes.impl.LocalData.KEY_SHOW_CAS || name == com.wiris.quizzes.impl.LocalData.KEY_SHOW_AUXILIARY_TEXT_INPUT) return com.wiris.quizzes.impl.LocalData.VALUE_SHOW_CAS_FALSE; else if(name == com.wiris.quizzes.impl.LocalData.KEY_CAS_INITIAL_SESSION) return null; else if(name == com.wiris.quizzes.impl.LocalData.KEY_OPENANSWER_COMPOUND_ANSWER_GRADE) return com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_COMPOUND_ANSWER_GRADE_AND; else if(name == com.wiris.quizzes.impl.LocalData.KEY_OPENANSWER_COMPOUND_ANSWER_GRADE_DISTRIBUTION) return null; else if(name == com.wiris.quizzes.impl.LocalData.KEY_AUXILIARY_CAS_HIDE_FILE_MENU) return com.wiris.quizzes.impl.LocalData.VALUE_AUXILIARY_CAS_HIDE_FILE_MENU_FALSE; else if(name == com.wiris.quizzes.impl.LocalData.KEY_GRAPH_LOCK_INITIAL_CONTENT) return "false"; else if(name == com.wiris.quizzes.impl.LocalData.KEY_GRAPH_SHOW_NAME_IN_LABEL) return com.wiris.quizzes.impl.LocalData.VALUE_ALWAYS; else if(name == com.wiris.quizzes.impl.LocalData.KEY_GRAPH_SHOW_VALUE_IN_LABEL) return com.wiris.quizzes.impl.LocalData.VALUE_FOCUS; else if(name == com.wiris.quizzes.impl.LocalData.KEY_GRAPH_MAGNETIC_GRID) return com.wiris.quizzes.impl.LocalData.VALUE_SNAP; else return null;
	}
	,getLocalData: function(name) {
		var ld = com.wiris.quizzes.impl.QuestionImpl.getLocalDataFromArray(name,this.localData);
		return ld != null?ld:this.defaultLocalData(name);
	}
	,setLocalData: function(name,value) {
		this.id = null;
		if(this.localData == null) this.localData = new Array();
		com.wiris.quizzes.impl.QuestionImpl.setLocalDataToArray(name,value,this.localData);
	}
	,getAssertionIndex: function(name,correctAnswer,userAnswer) {
		if(this.assertions == null) return -1;
		var i;
		var _g1 = 0, _g = this.assertions.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			var assertion = this.assertions[i1];
			if(assertion.getCorrectAnswer() == correctAnswer && assertion.getAnswer() == userAnswer && assertion.name == name) return i1;
		}
		return -1;
	}
	,getCorrectAnswersLength: function() {
		return this.correctAnswers == null?0:this.correctAnswers.length;
	}
	,getCorrectAnswer: function(index) {
		if(this.correctAnswers != null && this.correctAnswers.length > index) {
			var a = this.correctAnswers[index];
			if(a != null) return a.content;
		}
		return null;
	}
	,setCorrectAnswer: function(index,content) {
		this.id = null;
		if(index < 0) throw "Invalid index: " + index;
		if(this.correctAnswers == null) this.correctAnswers = new Array();
		while(index >= this.correctAnswers.length) this.correctAnswers.push(new com.wiris.quizzes.impl.CorrectAnswer());
		var ca = this.correctAnswers[index];
		ca.id = "" + index;
		ca.weight = 1.0;
		content = com.wiris.util.xml.MathMLUtils.convertEditor2Newlines(content);
		ca.set(content);
		this.updateSlots();
	}
	,defaultOption: function(name) {
		return com.wiris.quizzes.impl.QuestionImpl.defaultOptions.get(name);
	}
	,removeLocalData: function(name) {
		this.id = null;
		com.wiris.quizzes.impl.QuestionImpl.removeLocalDataFromArray(name,this.localData);
	}
	,removeOption: function(name) {
		if(this.hasCalcmeSessionWithOptions() && this.isCalcmeOption(name)) {
			this.wirisCasSession = this.calcDocument.removeOption(name);
			return;
		}
		this.id = null;
		if(this.options != null) {
			var i = this.options.length - 1;
			while(i >= 0) {
				if(this.options[i].name == name) HxOverrides.remove(this.options,this.options[i]);
				i--;
			}
		}
	}
	,getOption: function(name) {
		if(this.hasCalcmeSessionWithOptions() && this.isCalcmeOption(name)) {
			var calcOption = this.getCalcDocument().getOption(name);
			if(calcOption != null) return calcOption;
		} else if(this.options != null) {
			var i;
			var _g1 = 0, _g = this.options.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				if(this.options[i1].name == name) return this.options[i1].content;
			}
		}
		return this.defaultOption(name);
	}
	,isCalcmeOption: function(name) {
		var _g1 = 0, _g = com.wiris.quizzes.impl.CalcDocumentTools.options.length;
		while(_g1 < _g) {
			var i = _g1++;
			var opt = com.wiris.quizzes.impl.CalcDocumentTools.options[i];
			if(opt == name) return true;
		}
		return false;
	}
	,getItemSeparator: function() {
		if(this.hasCalcmeSessionWithOptions()) return this.getCalcDocument().getOption("item_separator");
		if("," == this.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_DECIMAL_SEPARATOR) || "," == this.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_DIGIT_GROUP_SEPARATOR) && StringTools.startsWith(this.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_FLOAT_FORMAT),",")) return ";";
		return ",";
	}
	,getCalcDocument: function() {
		if(this.calcDocument == null) this.calcDocument = new com.wiris.quizzes.impl.CalcDocumentTools(this.wirisCasSession);
		return this.calcDocument;
	}
	,setOption: function(name,value) {
		this.id = null;
		if(value == null) this.removeOption(name); else if(this.hasCalcmeSessionWithOptions() && this.isCalcmeOption(name)) this.wirisCasSession = this.getCalcDocument().setOption(name,value); else if(this.isImplicitOption(name,value)) this.removeOption(name); else {
			if(this.options == null) this.options = new Array();
			var opt = new com.wiris.quizzes.impl.Option();
			opt.name = name;
			opt.content = value;
			opt.type = com.wiris.quizzes.impl.MathContent.TYPE_TEXT;
			var i;
			var found = false;
			var _g1 = 0, _g = this.options.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				if(this.options[i1].name == name) {
					this.options[i1] = opt;
					found = true;
				}
			}
			if(!found) this.options.push(opt);
		}
	}
	,getAssertionParameter: function(assertionName,correctAnswer,studentAnswer,name) {
		var ind = this.getAssertionIndex(assertionName,"" + correctAnswer,"" + studentAnswer);
		if(ind > -1) return this.getAssertion(ind).getParam(name);
		return null;
	}
	,setAssertionParameter: function(assertionName,correctAnswer,studentAnswer,name,value) {
		var ind = this.getAssertionIndex(assertionName,"" + correctAnswer,"" + studentAnswer);
		if(ind == -1) {
			this.addAssertion(assertionName,correctAnswer,studentAnswer,null);
			ind = this.getAssertionIndex(assertionName,"" + correctAnswer,"" + studentAnswer);
		}
		if(value == null) this.getAssertion(ind).removeParam(name); else this.getAssertion(ind).setParam(name,value);
	}
	,setParametrizedAssertion: function(name,correctAnswer,userAnswer,parameters) {
		this.id = null;
		if(this.assertions == null) this.assertions = new Array();
		var a = new com.wiris.quizzes.impl.Assertion();
		a.name = name;
		a.setCorrectAnswer(correctAnswer);
		a.setAnswer(userAnswer);
		var names = com.wiris.quizzes.impl.Assertion.getParameterNames(name);
		if(parameters != null && names != null) {
			a.parameters = new Array();
			var n = parameters.length < names.length?parameters.length:names.length;
			var i;
			var _g = 0;
			while(_g < n) {
				var i1 = _g++;
				if(parameters[i1] != null) {
					var ap = new com.wiris.quizzes.impl.AssertionParam();
					ap.name = names[i1];
					ap.content = parameters[i1];
					ap.type = com.wiris.quizzes.impl.MathContent.TYPE_TEXT;
					a.parameters.push(ap);
				}
			}
		}
		var index = this.getAssertionIndex(name,correctAnswer,userAnswer);
		if(index == -1) this.assertions.push(a); else this.assertions[index] = a;
		this.updateSlots();
	}
	,removeAssertion: function(name,correctAnswer,userAnswer) {
		this.id = null;
		if(this.assertions != null) {
			var i = this.assertions.length - 1;
			while(i >= 0) {
				var a = this.assertions[i];
				if(a.name == name && a.getCorrectAnswer() == correctAnswer && a.getAnswer() == userAnswer) HxOverrides.remove(this.assertions,a);
				i--;
			}
		}
	}
	,hasCalcmeSessionWithOptions: function() {
		return com.wiris.quizzes.impl.CalcDocumentTools.isCalc(this.wirisCasSession) && this.getCalcDocument().hasQuizzesQuestionOptions();
	}
	,setAssertion: function(name,correctAnswer,userAnswer) {
		this.setParametrizedAssertion(name,"" + correctAnswer,"" + userAnswer,null);
	}
	,setId: function(id) {
		this.id = id;
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.QuestionImpl();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.QuestionImpl.TAGNAME);
		this.id = s.cacheAttribute("id",this.id,null);
		this.wirisCasSession = s.childString("wirisCasSession",this.wirisCasSession,null);
		this.correctAnswers = s.serializeArrayName(this.correctAnswers,"correctAnswers");
		this.assertions = s.serializeArrayName(this.assertions,"assertions");
		this.slots = s.serializeArrayName(this.slots,"slots");
		this.options = s.serializeArrayName(this.options,"options");
		this.localData = s.serializeArrayName(this.localData,"localData");
		s.endTag();
	}
	,deprecationWarnings: null
	,calcDocument: null
	,localData: null
	,options: null
	,wirisCasSession: null
	,id: null
	,assertions: null
	,correctAnswers: null
	,slots: null
	,__class__: com.wiris.quizzes.impl.QuestionImpl
});
if(!com.wiris.util.type) com.wiris.util.type = {}
com.wiris.util.type.Comparator = $hxClasses["com.wiris.util.type.Comparator"] = function() { }
com.wiris.util.type.Comparator.__name__ = ["com","wiris","util","type","Comparator"];
com.wiris.util.type.Comparator.prototype = {
	compare: null
	,__class__: com.wiris.util.type.Comparator
}
com.wiris.quizzes.impl.QuestionInstanceImpl = $hxClasses["com.wiris.quizzes.impl.QuestionInstanceImpl"] = function() {
	com.wiris.util.xml.SerializableImpl.call(this);
	this.userData = new com.wiris.quizzes.impl.UserData();
	this.userData.randomSeed = Std.random(65536);
	this.variables = null;
	this.checks = null;
	this.compoundChecks = null;
};
com.wiris.quizzes.impl.QuestionInstanceImpl.__name__ = ["com","wiris","quizzes","impl","QuestionInstanceImpl"];
com.wiris.quizzes.impl.QuestionInstanceImpl.__interfaces__ = [com.wiris.util.type.Comparator,com.wiris.quizzes.api.QuestionInstance];
com.wiris.quizzes.impl.QuestionInstanceImpl.base64 = null;
com.wiris.quizzes.impl.QuestionInstanceImpl.__super__ = com.wiris.util.xml.SerializableImpl;
com.wiris.quizzes.impl.QuestionInstanceImpl.prototype = $extend(com.wiris.util.xml.SerializableImpl.prototype,{
	cloneCheckStructureIntoQuestion: function(question) {
		if(!this.hasEvaluation()) return;
		var q = question.getImpl();
		if(q.correctAnswers == null) q.correctAnswers = new Array();
		if(q.assertions == null) q.assertions = new Array();
		var studentAnswers = this.checks.keys();
		while(studentAnswers.hasNext()) {
			var studentAnswer = studentAnswers.next();
			var assertionChecks = this.checks.get(studentAnswer);
			var _g = 0;
			while(_g < assertionChecks.length) {
				var check = assertionChecks[_g];
				++_g;
				var name = check.getAssertionName();
				if(!com.wiris.quizzes.impl.Assertion.isSyntacticName(name)) {
					var ca = check.getCorrectAnswer();
					var cai = Std.parseInt(ca);
					while(cai >= q.correctAnswers.length) {
						var newCA = new com.wiris.quizzes.impl.CorrectAnswer();
						newCA.id = q.correctAnswers.length + "";
						newCA.set("");
						q.correctAnswers.push(newCA);
					}
					if(q.getAssertionIndex(check.getAssertionName(),check.getCorrectAnswer(),check.getAnswer()) == -1) {
						var a = new com.wiris.quizzes.impl.Assertion();
						a.name = check.getAssertionName();
						a.answer = check.getAnswers();
						a.correctAnswer = check.getCorrectAnswers();
						q.assertions.push(a);
					}
				}
			}
		}
		q.updateSlots();
	}
	,getChecks: function(slot,authorAnswer) {
		var slotIndex = Std.parseInt(slot.id);
		var authorAnswerIndex = Std.parseInt(authorAnswer.id);
		return this.getAssertionChecks(authorAnswerIndex,slotIndex);
	}
	,getCompoundGrade: function(slot,authorAnswer,index) {
		var slotIndex = Std.parseInt(slot.id);
		var authorAnswerIndex = Std.parseInt(authorAnswer.id);
		return this.getCompoundAnswerGrade(authorAnswerIndex,slotIndex,index,this.question);
	}
	,getGrade: function(slot,authorAnswer) {
		var slotIndex = Std.parseInt(slot.id);
		var authorAnswerIndex = Std.parseInt(authorAnswer.id);
		return this.getAnswerGrade(authorAnswerIndex,slotIndex,this.question);
	}
	,isSlotAnswerCorrect: function(slot) {
		var index = Std.parseInt(slot.id);
		return this.isAnswerCorrect(index);
	}
	,setSlotAnswer: function(slot,answer) {
		var index = Std.parseInt(slot.id);
		this.setStudentAnswer(index,answer);
	}
	,getSlotAnswer: function(slot) {
		var index = Std.parseInt(slot.id);
		return this.getStudentAnswer(index);
	}
	,concatenate: function(a,e) {
		var b = new Array();
		var i;
		var _g1 = 0, _g = a.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			b[i1] = a[i1];
		}
		b[a.length] = e;
		return b;
	}
	,equalsArrays: function(a1,a2) {
		if(a1.length != a2.length) return false;
		var _g1 = 0, _g = a1.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(!(a1[i] == a2[i])) return false;
		}
		return true;
	}
	,hasCompoundAssociatedCheck: function(a) {
		var answers = this.compoundChecks.keys();
		while(answers.hasNext()) {
			var answer = answers.next();
			var correctAnswers = this.compoundChecks.get(answer).keys();
			while(correctAnswers.hasNext()) {
				var correctAnswer = correctAnswers.next();
				var checks = this.compoundChecks.get(answer).get(correctAnswer);
				var _g = 0;
				while(_g < checks.length) {
					var aa = checks[_g];
					++_g;
					if(aa.getAssertionName() == a.getAssertionName() && this.equalsArrays(a.getAnswers(),aa.getAnswers()) && this.equalsArrays(a.getCorrectAnswers(),aa.getCorrectAnswers())) return true;
				}
			}
		}
		return false;
	}
	,setChecksCompoundAnswers: function() {
		if(this.compoundChecks == null) return;
		var answers = this.checks.keys();
		while(answers.hasNext()) {
			var aa = this.checks.get(answers.next());
			var _g = 0;
			while(_g < aa.length) {
				var a = aa[_g];
				++_g;
				if(this.hasCompoundAssociatedCheck(a)) {
					a.setAnswers(new Array());
					a.setCorrectAnswers(new Array());
				}
			}
		}
		answers = this.compoundChecks.keys();
		while(answers.hasNext()) {
			var answer = answers.next();
			var correctAnswers = this.compoundChecks.get(answer).keys();
			while(correctAnswers.hasNext()) {
				var correctAnswer = correctAnswers.next();
				var checks = this.compoundChecks.get(answer).get(correctAnswer);
				var _g = 0;
				while(_g < checks.length) {
					var a = checks[_g];
					++_g;
					a.setCorrectAnswers(this.concatenate(a.getCorrectAnswers(),correctAnswer));
					a.setAnswers(this.concatenate(a.getAnswers(),answer));
				}
			}
		}
	}
	,setParameter: function(name,value) {
		this.userData.setParameter(name,value);
	}
	,getTextVariables: function() {
		return this.getTypeVariables(com.wiris.quizzes.impl.MathContent.TYPE_TEXT);
	}
	,getMathMLVariables: function() {
		return this.getTypeVariables(com.wiris.quizzes.impl.MathContent.TYPE_MATHML);
	}
	,getTypeVariables: function(type) {
		if(this.hasVariables() && this.variables.exists(type)) return this.variables.get(type); else return null;
	}
	,getHandwritingConstraints: function() {
		if(this.handConstraints == null) {
			var json = this.getLocalDataImpl(com.wiris.quizzes.impl.LocalData.KEY_OPENANSWER_HANDWRITING_CONSTRAINTS);
			if(json != null) this.handConstraints = com.wiris.quizzes.impl.HandwritingConstraints.readHandwritingConstraints(json); else if(this.question != null) {
				this.handConstraints = com.wiris.quizzes.impl.HandwritingConstraints.newHandwritingConstraints();
				this.handConstraints.addQuestionConstraints(this.question.getImpl());
				this.handConstraints.addQuestionInstanceConstraints(this);
			}
		}
		return this.handConstraints;
	}
	,serializeHandConstraints: function() {
		if(this.handConstraints != null) this.setLocalDataImpl(com.wiris.quizzes.impl.LocalData.KEY_OPENANSWER_HANDWRITING_CONSTRAINTS,this.handConstraints.toJSON(),false);
	}
	,areVariablesReady: function() {
		if(this.variables != null) {
			if(this.variables.exists(com.wiris.quizzes.impl.MathContent.TYPE_IMAGE_REF)) {
				var cache = com.wiris.quizzes.impl.QuizzesImpl.getInstance().getImagesCache();
				var images = this.variables.get(com.wiris.quizzes.impl.MathContent.TYPE_IMAGE_REF);
				var names = images.keys();
				while(names.hasNext()) {
					var filename = images.get(names.next());
					if(com.wiris.settings.PlatformSettings.IS_JAVASCRIPT) {
						var s = com.wiris.system.Storage.newStorage(filename);
						if(!s.exists()) return false;
					} else if(cache.get(filename) == null) return false;
				}
			}
		}
		return true;
	}
	,getAssertionChecks: function(correctAnswer,studentAnswer) {
		if(this.checks != null) {
			var answerChecks = this.checks.get("" + studentAnswer);
			if(answerChecks != null) {
				var res = new Array();
				var i;
				var _g1 = 0, _g = answerChecks.length;
				while(_g1 < _g) {
					var i1 = _g1++;
					var ca = answerChecks[i1].getCorrectAnswers();
					var j;
					var _g3 = 0, _g2 = ca.length;
					while(_g3 < _g2) {
						var j1 = _g3++;
						if(ca[j1] == "" + correctAnswer) res.push(answerChecks[i1]);
					}
				}
				var resarray = new Array();
				resarray = res.slice();
				return resarray;
			}
		}
		return new Array();
	}
	,getStudentAnswersLength: function() {
		return this.userData.answers != null?this.userData.answers.length:0;
	}
	,getStudentAnswer: function(index) {
		if(this.userData.answers != null && index < this.userData.answers.length) {
			var a = this.userData.answers[index];
			if(a != null) return a.content;
		}
		return null;
	}
	,setStudentAnswer: function(index,answer) {
		this.userData.setUserAnswer(index,answer);
	}
	,setAuxiliaryText: function(text) {
		if(text != null && StringTools.trim(text).length > 0) this.setLocalData(com.wiris.quizzes.impl.LocalData.KEY_AUXILIARY_TEXT,text); else if(this.localData != null) {
			var i;
			var _g1 = 0, _g = this.localData.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				if(this.localData[i1].name == com.wiris.quizzes.impl.LocalData.KEY_AUXILIARY_TEXT) HxOverrides.remove(this.localData,this.localData[i1]);
			}
		}
	}
	,setAuxiliarText: function(text) {
		this.setAuxiliaryText(text);
	}
	,setCasSession: function(session) {
		if(session != null && StringTools.trim(session).length > 0) this.setLocalData(com.wiris.quizzes.impl.LocalData.KEY_CAS_SESSION,session); else if(this.localData != null) {
			var i;
			var _g1 = 0, _g = this.localData.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				if(this.localData[i1].name == com.wiris.quizzes.impl.LocalData.KEY_CAS_SESSION) HxOverrides.remove(this.localData,this.localData[i1]);
			}
		}
	}
	,setRandomSeed: function(seed) {
		this.userData.randomSeed = seed;
	}
	,parseTextBoolean: function(text) {
		var trues = ["true","cierto","cert","t" + com.wiris.system.Utf8.uchr(245) + "ene","ziur","vrai","wahr","vero","waar","verdadeiro","certo"];
		var i;
		var _g1 = 0, _g = trues.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(trues[i1] == text) return true;
		}
		return false;
	}
	,updateAnswer: function(qi) {
		var i;
		if(qi.userData.answers != null) {
			if(this.userData.answers == null) this.userData.answers = new Array();
			var _g1 = 0, _g = qi.userData.answers.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var a = qi.userData.answers[i1];
				if(this.userData.answers.length > i1) this.userData.answers[i1] = a; else this.userData.answers.push(a);
			}
		}
		this.setLocalData(com.wiris.quizzes.impl.LocalData.KEY_CAS_SESSION,qi.getLocalData(com.wiris.quizzes.impl.LocalData.KEY_CAS_SESSION));
		this.setLocalData(com.wiris.quizzes.impl.LocalData.KEY_AUXILIARY_TEXT,qi.getLocalData(com.wiris.quizzes.impl.LocalData.KEY_AUXILIARY_TEXT));
	}
	,updateFromStudentQuestionInstance: function(qi) {
		var ii = qi;
		this.userData.answers = ii.userData.answers;
		this.localData = ii.localData;
	}
	,copyVariableToStudentHash: function(variable,studentVariables) {
		var variableKeys = this.variables.keys();
		while(variableKeys.hasNext()) {
			var type = variableKeys.next();
			var typeVariables = this.variables.get(type);
			if(typeVariables.exists(variable)) {
				if(!studentVariables.exists(type)) studentVariables.set(type,new Hash());
				studentVariables.get(type).set(variable,typeVariables.get(variable));
			}
		}
	}
	,getStudentQuestionInstanceVariables: function(variables,question) {
		if(question == null || variables == null) return null;
		var studentVariables = new Hash();
		var tools = new com.wiris.quizzes.impl.HTMLTools();
		var slots = question.getSlots();
		var _g = 0;
		while(_g < slots.length) {
			var slot = slots[_g];
			++_g;
			if(slot.getProperty(com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER) == com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_COMPOUND_ANSWER_TRUE && slot.getSyntax().getName() == com.wiris.quizzes.api.assertion.SyntaxName.MATH) {
				var authorAnswers = slot.getAuthorAnswers();
				var authorAnswerValue = authorAnswers[0].getValue();
				var mathContent = new com.wiris.quizzes.impl.MathContent();
				mathContent.set(authorAnswerValue);
				var compoundAnswer = com.wiris.quizzes.impl.CompoundAnswerParser.parseCompoundAnswer(mathContent);
				var _g2 = 0, _g1 = compoundAnswer.length;
				while(_g2 < _g1) {
					var i = _g2++;
					var answer = compoundAnswer[i];
					var compoundAnswerVariables = tools.extractVariableNames(answer[0]);
					var _g3 = 0;
					while(_g3 < compoundAnswerVariables.length) {
						var compoundAnswerVariable = compoundAnswerVariables[_g3];
						++_g3;
						this.copyVariableToStudentHash(compoundAnswerVariable,studentVariables);
					}
				}
			}
			if(slot.getSyntax().getName() != com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC && slot.getInitialContent() != null) {
				var variableNames = tools.extractVariableNames(slot.getInitialContent());
				var _g1 = 0;
				while(_g1 < variableNames.length) {
					var variable = variableNames[_g1];
					++_g1;
					this.copyVariableToStudentHash(variable,studentVariables);
				}
			}
		}
		return studentVariables;
	}
	,getStudentQuestionInstance: function() {
		var qi = new com.wiris.quizzes.impl.QuestionInstanceImpl();
		qi.userData.randomSeed = 0;
		qi.userData.answers = this.userData.answers;
		qi.handConstraints = this.handConstraints;
		qi.localData = this.localData;
		qi.checks = this.checks;
		qi.compoundChecks = this.compoundChecks;
		qi.variables = this.getStudentQuestionInstanceVariables(this.variables,this.question);
		return qi;
	}
	,getBooleanVariableValue: function(name) {
		if(!this.hasVariables()) return false;
		name = StringTools.trim(name);
		if(StringTools.startsWith(name,"#")) name = HxOverrides.substr(name,1,null);
		if(this.variables.exists(com.wiris.quizzes.impl.MathContent.TYPE_TEXT)) {
			var textvars = this.variables.get(com.wiris.quizzes.impl.MathContent.TYPE_TEXT);
			if(textvars.exists(name)) {
				var textValue = textvars.get(name);
				return this.parseTextBoolean(textValue);
			}
		}
		if(this.variables.exists(com.wiris.quizzes.impl.MathContent.TYPE_MATHML)) {
			var mmlvars = this.variables.get(com.wiris.quizzes.impl.MathContent.TYPE_MATHML);
			if(mmlvars.exists(name)) {
				var mmlValue = mmlvars.get(name);
				var striptags = new EReg("<[^>]*>","");
				var textValue = striptags.replace(mmlValue,"");
				textValue = StringTools.trim(textValue);
				return this.parseTextBoolean(textValue);
			}
		}
		return false;
	}
	,hashToVariables: function(h,a) {
		if(h == null) return null;
		if(a == null) a = new Array();
		var t = h.keys();
		while(t.hasNext()) {
			var type = t.next();
			var vars = h.get(type);
			var names = vars.keys();
			while(names.hasNext()) {
				var name = names.next();
				var v = new com.wiris.quizzes.impl.Variable();
				v.type = type;
				v.name = name;
				v.content = vars.get(name);
				a.push(v);
			}
		}
		return a;
	}
	,variablesToHash: function(a,h) {
		if(a == null) return null;
		if(h == null) h = new Hash();
		var i;
		var _g1 = 0, _g = a.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			var v = a[i1];
			if(!h.exists(v.type)) h.set(v.type,new Hash());
			h.get(v.type).set(v.name,v.content);
		}
		return h;
	}
	,hashToChecks: function(h) {
		if(h == null) return null;
		var a = new Array();
		var answers = h.keys();
		while(answers.hasNext()) {
			var answer = answers.next();
			a = a.concat(h.get(answer));
		}
		return a;
	}
	,checksToHash: function(a,h) {
		if(a == null) return null;
		if(h == null) h = new Hash();
		var i;
		var _g1 = 0, _g = a.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			var c = a[i1];
			if(!h.exists(c.getAnswer())) h.set(c.getAnswer(),new Array());
			var answerChecks = h.get(c.getAnswer());
			answerChecks.push(c);
		}
		return h;
	}
	,processMatchingChecks: function(correctAnswer,checks) {
		var result = new Array();
		var i;
		var eval = 0;
		var check = 0;
		var _g1 = 0, _g = checks.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(checks[i1].getCorrectAnswer() == "" + correctAnswer) {
				var c = checks[i1];
				if(StringTools.startsWith(c.assertion,"syntax_")) {
					result.splice(eval,0,checks[i1]);
					eval++;
					check++;
				} else if(StringTools.startsWith(c.assertion,"equivalent_")) {
					result.splice(check,0,checks[i1]);
					check++;
				} else result.push(checks[i1]);
			}
		}
		return result;
	}
	,getMatchingCompoundChecks: function(slot,authorAnswer,index) {
		var correctAnswer = Std.parseInt(authorAnswer.id);
		var userAnswer = Std.parseInt(slot.id);
		var isGraphical = slot.getSyntax().getName() == com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC;
		var checks = null;
		if(isGraphical) {
			var elements = com.wiris.quizzes.impl.QuizzesImpl.getInstance().getElementsToGradeFromAuthorAnswer(authorAnswer);
			if(index >= 0 && index < elements.length) checks = this.getCompoundAnswerChecks(correctAnswer,userAnswer,elements[index],true);
		} else checks = this.getCompoundAnswerChecks(correctAnswer,userAnswer,index + "",false);
		if(checks == null) return new Array(); else return this.processMatchingChecks(correctAnswer,checks);
	}
	,getMatchingChecks: function(slot,authorAnswer) {
		var correctAnswer = Std.parseInt(authorAnswer.id);
		var userAnswer = Std.parseInt(slot.id);
		var result = new Array();
		if(this.checks == null || !this.checks.exists(userAnswer + "")) return result;
		return this.processMatchingChecks(correctAnswer,this.checks.get(userAnswer + ""));
	}
	,isAnswerSyntaxCorrect: function(answer) {
		var correct = true;
		if(this.checks != null && this.checks.exists(answer + "")) {
			var checks = this.checks.get(answer + "");
			var i;
			var _g1 = 0, _g = checks.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var ac = checks[i1];
				var j;
				var _g3 = 0, _g2 = com.wiris.quizzes.impl.Assertion.syntactic.length;
				while(_g3 < _g2) {
					var j1 = _g3++;
					if(ac.assertion == com.wiris.quizzes.impl.Assertion.syntactic[j1]) correct = correct && ac.value == 1.0;
				}
				if(ac.assertion == com.wiris.quizzes.impl.Assertion.SYNTAX_MATH) correct = correct && ac.value == 1.0;
			}
		}
		return correct;
	}
	,getCompoundComponents: function() {
		if(this.compoundChecks != null) {
			var n = -1;
			var it = this.compoundChecks.keys();
			var compoundGraphicalComponents = new Hash();
			while(it.hasNext()) {
				var key = it.next();
				if(key.indexOf("_cg") == -1) try {
					var m = Std.parseInt(HxOverrides.substr(key,key.indexOf("_c") + 2,null));
					if(m > n) n = m;
				} catch( e ) {
				} else {
					var answer = HxOverrides.substr(key,0,key.indexOf("_cg"));
					if(!compoundGraphicalComponents.exists(answer)) compoundGraphicalComponents.set(answer,"0"); else compoundGraphicalComponents.set(answer,"" + (Std.parseInt(compoundGraphicalComponents.get(answer)) + 1));
				}
			}
			var itG = compoundGraphicalComponents.keys();
			while(itG.hasNext()) {
				var m = Std.parseInt(compoundGraphicalComponents.get(itG.next()));
				if(m > n) n = m;
			}
			return n + 1;
		} else return 0;
	}
	,isNumberPart: function(c) {
		var parts = [".","-","0","1","2","3","4","5","6","7","8","9"];
		var i;
		var _g1 = 0, _g = parts.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(parts[i1] == c) return true;
		}
		return false;
	}
	,getCompoundGradeDistribution: function(s) {
		var n = this.getCompoundComponents();
		var d = new Array();
		if(s == null || StringTools.trim(s) == "") {
			var i;
			var _g = 0;
			while(_g < n) {
				var i1 = _g++;
				d[i1] = 1.0;
			}
			d[n] = n;
		} else {
			var content = false;
			var j = 0;
			var l = com.wiris.system.Utf8.getLength(s);
			var i = 0;
			var sb = new StringBuf();
			while(i < l && j < n) {
				var c = com.wiris.system.Utf8.uchr(com.wiris.system.Utf8.charCodeAt(s,i));
				var digit = this.isNumberPart(c);
				if(digit) {
					sb.b += Std.string(c);
					content = true;
				}
				if(content && (!digit || i + 1 == l)) {
					var t = 0.0;
					try {
						t = Std.parseFloat(sb.b);
					} catch( e ) {
					}
					d[j] = t;
					j++;
					sb = new StringBuf();
					content = false;
				}
				i++;
			}
			while(j < n) {
				d[j] = 0.0;
				j++;
			}
			var sum = 0.0;
			var _g = 0;
			while(_g < n) {
				var j1 = _g++;
				sum += d[j1];
			}
			d[n] = sum;
		}
		return d;
	}
	,getCompoundAnswerGrade: function(correctAnswer,studentAnswer,index,q) {
		var n = this.getCompoundComponents();
		if(index < 0 || index >= n) throw "Compound answer index out of bounds.";
		var qimpl = q.getImpl();
		var graphicalAssertionIndex = qimpl.getAssertionIndex(com.wiris.quizzes.impl.Assertion.EQUIVALENT_GRAPHIC,correctAnswer + "",studentAnswer + "");
		var checks = null;
		if(graphicalAssertionIndex != -1) {
			var ca = qimpl.getCorrectAnswer(correctAnswer);
			var ass = qimpl.getAssertion(graphicalAssertionIndex);
			var elements = com.wiris.quizzes.impl.QuizzesImpl.getInstance().getElementsToGrade(ca,ass);
			if(elements != null && index < elements.length) checks = this.getCompoundAnswerChecks(correctAnswer,studentAnswer,elements[index] + "",true);
			var noSuperfluousElementsIndex = qimpl.getAssertionIndex(com.wiris.quizzes.impl.Assertion.CHECK_NO_SUPERFLUOUS,correctAnswer + "",studentAnswer + "");
			if(checks != null && noSuperfluousElementsIndex != -1) {
				var slotChecks = this.checks.get(studentAnswer + "");
				var _g = 0;
				while(_g < slotChecks.length) {
					var c = slotChecks[_g];
					++_g;
					if(c.getAnswer() != null && c.getAnswer() == correctAnswer + "" && com.wiris.quizzes.impl.Assertion.CHECK_NO_SUPERFLUOUS == c.getAssertionName()) {
						checks.push(c);
						break;
					}
				}
			}
		} else checks = this.getCompoundAnswerChecks(correctAnswer,studentAnswer,index + "",false);
		var grade = 0.0;
		if(checks != null) grade = this.prodChecks(checks,-1,-1);
		return grade;
	}
	,prodChecks: function(checks,correctAnswer,studentAnswer) {
		var grade = 1.0;
		var i;
		var _g1 = 0, _g = checks.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if((correctAnswer == -1 || com.wiris.util.type.Arrays.containsArray(checks[i1].getCorrectAnswers(),"" + correctAnswer)) && (studentAnswer == -1 || com.wiris.util.type.Arrays.containsArray(checks[i1].getAnswers(),"" + studentAnswer))) grade = grade * checks[i1].value;
		}
		return grade;
	}
	,andChecks: function(checks) {
		var j;
		var correct = true;
		var _g = 0;
		while(_g < checks.length) {
			var check = checks[_g];
			++_g;
			correct = correct && check.value > 0.999999;
		}
		return correct;
	}
	,getCompoundAnswerChecks: function(correctAnswer,studentAnswer,index,isGraphical) {
		var infix = isGraphical?"_cg":"_c";
		if(this.compoundChecks != null) return this.compoundChecks.get(studentAnswer + infix + index).get(correctAnswer + infix + index); else return null;
	}
	,getAnswerGrade: function(correctAnswer,studentAnswer,q) {
		var grade = 0.0;
		var question = q != null?q.getImpl():null;
		if(question != null && question.isCompoundAnswer()) {
			var distributionProperty = null;
			var distribute = false;
			if(question.isQuestionCompoundAnswer() && question.getProperty(com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER_GRADE) == com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_COMPOUND_ANSWER_GRADE_DISTRIBUTE) {
				distributionProperty = question.getProperty(com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER_GRADE_DISTRIBUTION);
				distribute = true;
			} else {
				var slots = question.slots;
				var _g = 0;
				while(_g < slots.length) {
					var s = slots[_g];
					++_g;
					if(studentAnswer == Std.parseInt(s.id) && s.isSlotCompoundAnswer() && s.getProperty(com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER_GRADE) == com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_COMPOUND_ANSWER_GRADE_DISTRIBUTE) {
						distributionProperty = s.getProperty(com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER_GRADE_DISTRIBUTION);
						distribute = true;
						break;
					}
				}
			}
			if(distribute) {
				var distribution = this.getCompoundGradeDistribution(distributionProperty);
				var _g1 = 0, _g = distribution.length - 1;
				while(_g1 < _g) {
					var i = _g1++;
					grade += distribution[i] * this.getCompoundAnswerGrade(correctAnswer,studentAnswer,i,q);
				}
				return grade / distribution[distribution.length - 1];
			}
		} else if(question != null && question.getAssertionIndex(com.wiris.quizzes.impl.Assertion.EQUIVALENT_FUNCTION,"" + correctAnswer,"" + studentAnswer) != -1) {
			var checks = this.checks.get(studentAnswer + "");
			return this.prodChecks(checks,correctAnswer,studentAnswer);
		}
		return this.isAnswerMatching(correctAnswer,studentAnswer)?1.0:0.0;
	}
	,areAllAnswersCorrect: function() {
		if(this.checks != null) {
			var it = this.checks.keys();
			while(it.hasNext()) {
				var key = it.next();
				var checks = this.checks.get(key);
				if(!this.andChecks(checks)) return false;
			}
		}
		return true;
	}
	,isAnswerCorrect: function(answer) {
		var correct = true;
		if(this.checks != null && this.checks.exists(answer + "")) {
			var checks = this.checks.get(answer + "");
			correct = this.andChecks(checks);
		}
		return correct;
	}
	,getMatchingCorrectAnswer: function(studentAnswer,q) {
		var correctAnswer = -1;
		if(this.checks != null && this.checks.exists(studentAnswer + "")) {
			var checks = this.checks.get(studentAnswer + "");
			var correctAnswers = new Array();
			var i;
			var _g1 = 0, _g = checks.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var ca = checks[i1].getCorrectAnswers();
				var j;
				var _g3 = 0, _g2 = ca.length;
				while(_g3 < _g2) {
					var j1 = _g3++;
					com.wiris.util.type.Arrays.insertSortedSet(correctAnswers,ca[j1]);
				}
			}
			if(correctAnswers.length > 0) {
				correctAnswer = Std.parseInt(correctAnswers[0]);
				var maxgrade = this.getAnswerGrade(correctAnswer,studentAnswer,q);
				var j;
				var _g1 = 1, _g = correctAnswers.length;
				while(_g1 < _g) {
					var j1 = _g1++;
					var thisCorrectAnswer = Std.parseInt(correctAnswers[j1]);
					var grade = this.getAnswerGrade(thisCorrectAnswer,studentAnswer,q);
					if(grade > maxgrade) {
						maxgrade = grade;
						correctAnswer = thisCorrectAnswer;
					}
				}
			}
		}
		return correctAnswer;
	}
	,areAllChecksCorrect: function(slot,authorAnswer) {
		var slotIndex = Std.parseInt(slot.id);
		var authorAnswerIndex = Std.parseInt(authorAnswer.id);
		return this.isAnswerMatching(authorAnswerIndex,slotIndex);
	}
	,isAnswerMatching: function(correctAnswer,answer) {
		var correct = true;
		if(this.checks != null && this.checks.exists(answer + "")) {
			var checks = this.checks.get(answer + "");
			var i;
			var _g1 = 0, _g = checks.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var c = checks[i1];
				if(!(StringTools.startsWith(c.getAssertionName(),"syntax") && (c.getAnswers().length > 1 || c.getCorrectAnswers().length > 1))) {
					if(Std.parseInt(c.getCorrectAnswer()) == correctAnswer) correct = correct && c.value > 0.999;
				}
			}
		}
		return correct;
	}
	,isCacheReady: function() {
		return this.areVariablesReady();
	}
	,hasEvaluation: function() {
		return this.checks != null && this.checks.keys().hasNext();
	}
	,hasVariables: function() {
		return this.variables != null && this.variables.keys().hasNext();
	}
	,clearChecks: function() {
		this.checks = null;
		this.compoundChecks = null;
	}
	,clearVariables: function() {
		this.variables = null;
	}
	,getBase64Code: function() {
		if(com.wiris.quizzes.impl.QuestionInstanceImpl.base64 == null) com.wiris.quizzes.impl.QuestionInstanceImpl.base64 = new com.wiris.quizzes.impl.Base64();
		return com.wiris.quizzes.impl.QuestionInstanceImpl.base64;
	}
	,storeImageVariable: function(v) {
		var filename;
		if(com.wiris.settings.PlatformSettings.IS_JAVASCRIPT) {
			filename = haxe.Md5.encode(v.content) + ".b64";
			var s = com.wiris.system.Storage.newStorage(filename);
			if(!s.exists()) s.write(v.content);
			if(!s.exists()) return v;
		} else {
			var base64 = this.getBase64Code();
			var value = StringTools.replace(v.content,"=","");
			var b = base64.decodeBytes(haxe.io.Bytes.ofString(value));
			filename = haxe.Md5.encode(value) + ".png";
			var cache = com.wiris.quizzes.impl.QuizzesImpl.getInstance().getImagesCache();
			cache.set(filename,b);
		}
		var w = new com.wiris.quizzes.impl.Variable();
		w.type = com.wiris.quizzes.impl.MathContent.TYPE_IMAGE_REF;
		w.content = filename;
		w.name = v.name;
		return w;
	}
	,isCompoundAnswer: function() {
		return this.compoundChecks != null;
	}
	,isCompoundAnswerSingleCheck: function(check) {
		var id = check.getCorrectAnswer();
		if(id == null) return false;
		if(id.indexOf("c") > -1) return true;
		var index = Std.parseInt(id);
		return index >= 1000;
	}
	,isCompoundAnswerChecks: function(checks) {
		if(checks != null && checks.length > 0) {
			var _g = 0;
			while(_g < checks.length) {
				var check = checks[_g];
				++_g;
				if(this.isCompoundAnswerSingleCheck(check)) return true;
			}
		}
		return false;
	}
	,collapseCompoundAnswerChecks: function(checks) {
		this.compoundChecks = new Hash();
		var _g = 0;
		while(_g < checks.length) {
			var c = checks[_g];
			++_g;
			if(!this.isCompoundAnswerSingleCheck(c)) continue;
			var correctAnswers = c.getCorrectAnswers();
			var answers = c.getAnswers();
			var pairs = com.wiris.quizzes.impl.QuizzesImpl.getInstance().getPairings(c.getCorrectAnswers().length,c.getAnswers().length);
			var j;
			var _g2 = 0, _g1 = pairs.length;
			while(_g2 < _g1) {
				var j1 = _g2++;
				var pair = pairs[j1];
				var correctAnswer = this.updateCompoundId(correctAnswers[pair[0]]);
				var userAnswer = this.updateCompoundId(answers[pair[1]]);
				if(!this.compoundChecks.exists(userAnswer)) this.compoundChecks.set(userAnswer,new Hash());
				var answerChecks = this.compoundChecks.get(userAnswer);
				if(!answerChecks.exists(correctAnswer)) answerChecks.set(correctAnswer,new Array());
				var pairchecks = answerChecks.get(correctAnswer);
				pairchecks.push(c);
			}
			var idAnswer = c.getAnswer();
			if(idAnswer.indexOf("_c") > 0) c.setAnswer(HxOverrides.substr(idAnswer,0,idAnswer.indexOf("_c"))); else {
				var numAnswer = Std.parseInt(idAnswer);
				if(numAnswer < 1000) c.setAnswer(idAnswer); else {
					numAnswer = Math.floor((numAnswer - 1000) / 1000.0);
					c.setAnswer("" + numAnswer);
				}
			}
			var correctAnswerId = c.getCorrectAnswer();
			if(correctAnswerId.indexOf("_c") > 0) c.setCorrectAnswer(HxOverrides.substr(correctAnswerId,0,correctAnswerId.indexOf("_c"))); else {
				var numCA = Std.parseInt(correctAnswerId);
				if(numCA < 1000) c.setCorrectAnswer(correctAnswerId); else {
					numCA = Math.floor((numCA - 1000) / 1000.0);
					c.setCorrectAnswer("" + numCA);
				}
			}
		}
	}
	,compare: function(a,b) {
		return Std.parseInt(a.get("ordinal")) > Std.parseInt(b.get("ordinal"))?1:-1;
	}
	,parseCompoundGraphicalAssertionChecks: function(checks) {
		var parsedChecks = new Array();
		var assertionsInfo = new Hash();
		var _g = 0;
		while(_g < checks.length) {
			var c = checks[_g];
			++_g;
			if(c.getCorrectAnswer().indexOf("cg") == -1) {
				parsedChecks.push(c);
				continue;
			}
			var strs = c.getCorrectAnswer().split("_");
			var correctAnswer = strs[0];
			var elemCount = HxOverrides.substr(strs[1],2,null);
			var elemIdParts = new Array();
			var _g2 = 2, _g1 = strs.length;
			while(_g2 < _g1) {
				var i = _g2++;
				elemIdParts.push(strs[i]);
			}
			var elemId = elemIdParts.join("_");
			var answer = c.getAnswer();
			if(!assertionsInfo.exists(c.assertion + "_" + correctAnswer + "_" + answer)) assertionsInfo.set(c.assertion + "_" + correctAnswer + "_" + answer,new Array());
			var piece = new Hash();
			piece.set("elemId",elemId);
			piece.set("ordinal",elemCount);
			piece.set("grade",c.value + "");
			piece.set("correctAnswer",correctAnswer);
			piece.set("answer",answer);
			assertionsInfo.get(c.assertion + "_" + correctAnswer + "_" + answer).push(piece);
		}
		var it = assertionsInfo.keys();
		while(it.hasNext()) {
			var assertion = it.next();
			var pieces = assertionsInfo.get(assertion);
			var correctAnswer = pieces[0].get("correctAnswer");
			var answer = pieces[0].get("answer");
			com.wiris.util.type.Arrays.sort(pieces,this);
			var grade_prev = 0.0;
			var _g1 = 0, _g = pieces.length;
			while(_g1 < _g) {
				var i = _g1++;
				var piece = pieces[i];
				var grade = Std.parseFloat(piece.get("grade"));
				var elemId = piece.get("elemId");
				var c = new com.wiris.quizzes.impl.AssertionCheckImpl();
				c.assertion = assertion;
				c.value = grade > 0.99 || grade > grade_prev?1:0;
				c.setAnswer(answer + "_cg" + elemId);
				c.setCorrectAnswer(correctAnswer + "_cg" + elemId);
				grade_prev = grade;
				parsedChecks.push(c);
			}
			var cc = new com.wiris.quizzes.impl.AssertionCheckImpl();
			cc.assertion = assertion;
			cc.value = grade_prev > 0.99?1:0;
			cc.setAnswer(answer);
			cc.setCorrectAnswer(correctAnswer);
			parsedChecks.push(cc);
		}
		return parsedChecks;
	}
	,isCompoundGraphicalAnswerChecks: function(checks) {
		if(checks != null) {
			var _g = 0;
			while(_g < checks.length) {
				var check = checks[_g];
				++_g;
				if(check.getCorrectAnswer().indexOf("cg") == -1) return true;
			}
		}
		return false;
	}
	,updateCompoundId: function(id) {
		if(id.indexOf("_c") > -1) return id;
		var num = Std.parseInt(id);
		if(num < 1000) return id;
		var index = Math.floor((num - 1000) / 1000.0);
		var compoundIndex = num % 1000;
		return index + "_c" + compoundIndex;
	}
	,hasHandwritingConstraints: function() {
		return this.handConstraints != null || this.getLocalDataImpl(com.wiris.quizzes.impl.LocalData.KEY_OPENANSWER_HANDWRITING_CONSTRAINTS) != null || this.question != null;
	}
	,update: function(response) {
		var questionResponseImpl = response;
		if(questionResponseImpl != null && questionResponseImpl.results != null) {
			var variables = false;
			var checks = false;
			var i;
			var _g1 = 0, _g = questionResponseImpl.results.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var result = questionResponseImpl.results[i1];
				var s = com.wiris.quizzes.impl.QuizzesImpl.getInstance().getSerializer();
				var tag = s.getTagName(result);
				var j;
				if(tag == com.wiris.quizzes.impl.ResultGetVariables.tagName) {
					variables = true;
					var variablesResult = result;
					var resultVars = variablesResult.variables;
					var _g3 = 0, _g2 = resultVars.length;
					while(_g3 < _g2) {
						var j1 = _g3++;
						var variable = resultVars[j1];
						if(variable.type == com.wiris.quizzes.impl.MathContent.TYPE_IMAGE) resultVars[j1] = this.storeImageVariable(variable);
					}
					this.variables = this.variablesToHash(variablesResult.variables,this.variables);
				} else if(tag == com.wiris.quizzes.impl.ResultGetCheckAssertions.tagName) {
					if(!checks) {
						checks = true;
						this.checks = null;
					}
					var assertionsResult = result;
					var resultChecks = assertionsResult.checks;
					if(this.isCompoundGraphicalAnswerChecks(resultChecks)) resultChecks = this.parseCompoundGraphicalAssertionChecks(resultChecks);
					if(this.isCompoundAnswerChecks(resultChecks)) this.collapseCompoundAnswerChecks(resultChecks);
					this.checks = this.checksToHash(resultChecks,this.checks);
				}
			}
			if(variables && this.hasHandwritingConstraints()) this.getHandwritingConstraints().addQuestionInstanceConstraints(this);
		}
	}
	,expandVariablesTextEval: function(text) {
		var h = new com.wiris.quizzes.impl.HTMLTools();
		h.setPlotterLoadingSrc(com.wiris.quizzes.impl.QuizzesImpl.getInstance().getResourceUrl("plotter_loading.png"));
		h.setProxyUrl(com.wiris.quizzes.impl.QuizzesImpl.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.PROXY_URL));
		if(this.variables == null || this.variables.get(com.wiris.quizzes.impl.MathContent.TYPE_TEXT_EVAL) == null) return this.expandVariablesText(text); else {
			var newvars = new Hash();
			this.addAllHashElements(this.variables.get(com.wiris.quizzes.impl.MathContent.TYPE_TEXT),newvars);
			this.addAllHashElements(this.variables.get(com.wiris.quizzes.impl.MathContent.TYPE_TEXT_EVAL),newvars);
			return h.expandVariablesText(text,newvars);
		}
	}
	,expandVariablesText: function(text) {
		if(text == null) return null;
		var h = new com.wiris.quizzes.impl.HTMLTools();
		h.setAnswerKeyword(this.getAnswerParameterName());
		h.setPlotterLoadingSrc(com.wiris.quizzes.impl.QuizzesImpl.getInstance().getResourceUrl("plotter_loading.png"));
		h.setProxyUrl(com.wiris.quizzes.impl.QuizzesImpl.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.PROXY_URL));
		text = h.extractActionExpressions(text,null);
		if(com.wiris.quizzes.impl.MathContent.getMathType(text) == com.wiris.quizzes.impl.MathContent.TYPE_MATHML) text = h.mathMLToText(text);
		if(this.variables != null && this.variables.get(com.wiris.quizzes.impl.MathContent.TYPE_TEXT) != null) {
			var textvars = this.variables.get(com.wiris.quizzes.impl.MathContent.TYPE_TEXT);
			text = h.expandVariablesText(text,textvars);
		}
		if(this.userData.answers != null) text = h.expandAnswersText(text,this.userData.answers,this.isCompoundAnswer());
		return text;
	}
	,addAllHashElements: function(src,dest) {
		if(src != null) {
			var it = src.keys();
			while(it.hasNext()) {
				var name = it.next();
				dest.set(name,src.get(name));
			}
		}
	}
	,expandVariablesMathMLEval: function(equation) {
		var h = new com.wiris.quizzes.impl.HTMLTools();
		h.setPlotterLoadingSrc(com.wiris.quizzes.impl.QuizzesImpl.getInstance().getResourceUrl("plotter_loading.png"));
		h.setProxyUrl(com.wiris.quizzes.impl.QuizzesImpl.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.PROXY_URL));
		if(this.variables == null || this.variables.get(com.wiris.quizzes.impl.MathContent.TYPE_MATHML_EVAL) == null) return this.expandVariablesMathML(equation); else {
			var vars = new Hash();
			var newvars = new Hash();
			vars.set(com.wiris.quizzes.impl.MathContent.TYPE_MATHML,newvars);
			this.addAllHashElements(this.variables.get(com.wiris.quizzes.impl.MathContent.TYPE_MATHML),newvars);
			this.addAllHashElements(this.variables.get(com.wiris.quizzes.impl.MathContent.TYPE_MATHML_EVAL),newvars);
			if(com.wiris.quizzes.impl.MathContent.getMathType(equation) == com.wiris.quizzes.impl.MathContent.TYPE_TEXT) equation = h.textToMathML(equation);
			return h.expandVariables(equation,vars);
		}
	}
	,getAnswerParameterName: function() {
		if(this.question == null || !("true" == this.question.getProperty(com.wiris.quizzes.api.PropertyName.STUDENT_ANSWER_PARAMETER))) return null;
		var keyword = this.question.getProperty(com.wiris.quizzes.api.PropertyName.STUDENT_ANSWER_PARAMETER_NAME);
		if(keyword == this.question.getImpl().defaultOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_STUDENT_ANSWER_PARAMETER_NAME)) {
			var lang = com.wiris.quizzes.impl.CalcDocumentTools.casSessionLang(this.question.getAlgorithm());
			if(lang != null && !(lang == com.wiris.quizzes.impl.QuestionInstanceImpl.DEF_ALGORITHM_LANGUAGE)) keyword = com.wiris.quizzes.impl.QuizzesTranslator.getInstance(lang).t(keyword);
		}
		return keyword;
	}
	,expandVariablesMathML: function(equation) {
		var h = new com.wiris.quizzes.impl.HTMLTools();
		h.setPlotterLoadingSrc(com.wiris.quizzes.impl.QuizzesImpl.getInstance().getResourceUrl("plotter_loading.png"));
		h.setProxyUrl(com.wiris.quizzes.impl.QuizzesImpl.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.PROXY_URL));
		equation = h.extractActionExpressions(equation,null);
		if(com.wiris.quizzes.impl.MathContent.getMathType(equation) == com.wiris.quizzes.impl.MathContent.TYPE_TEXT) equation = h.textToMathML(equation);
		h.setAnswerKeyword(this.getAnswerParameterName());
		equation = h.expandVariables(equation,this.variables);
		equation = h.expandAnswers(equation,this.userData.answers,this.isCompoundAnswer());
		return equation;
	}
	,expandVariables: function(text) {
		if(text == null) return null;
		var h = new com.wiris.quizzes.impl.HTMLTools();
		h.setItemSeparator(this.getItemSeparator());
		h.setAnswerKeyword(this.getAnswerParameterName());
		h.setPlotterLoadingSrc(com.wiris.quizzes.impl.QuizzesImpl.getInstance().getResourceUrl("plotter_loading.png"));
		h.setProxyUrl(com.wiris.quizzes.impl.QuizzesImpl.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.PROXY_URL));
		text = h.expandVariables(text,this.variables);
		h.setAnswerKeyword(this.getAnswerParameterName());
		text = h.expandAnswers(text,this.userData.answers,this.isCompoundAnswer());
		return text;
	}
	,getItemSeparator: function() {
		if(this.question != null) {
			var itemSeparator = this.question.getImpl().getItemSeparator();
			if(itemSeparator != null) return itemSeparator;
		}
		return ",";
	}
	,defaultLocalData: function(name) {
		return null;
	}
	,getLocalDataImpl: function(name) {
		if(this.localData != null) {
			var i;
			var _g1 = 0, _g = this.localData.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				if(this.localData[i1].name == name) return this.localData[i1].value;
			}
		}
		return this.defaultLocalData(name);
	}
	,getProperty: function(name) {
		var pname = com.wiris.quizzes.impl.QuizzesEnumUtils.propertyName2String(name);
		return pname != null?this.getLocalData(pname):null;
	}
	,setProperty: function(name,value) {
		var pname = com.wiris.quizzes.impl.QuizzesEnumUtils.propertyName2String(name);
		if(name != null) this.setLocalData(pname,value);
	}
	,getLocalData: function(name) {
		if(name == com.wiris.quizzes.impl.LocalData.KEY_OPENANSWER_HANDWRITING_CONSTRAINTS) {
			if(this.hasHandwritingConstraints()) return this.getHandwritingConstraints().getNegativeConstraints().toJSON(); else return null;
		}
		return this.getLocalDataImpl(name);
	}
	,setLocalDataImpl: function(name,value,parseHandwritingConstraints) {
		if(this.localData == null) this.localData = new Array();
		var data = new com.wiris.quizzes.impl.LocalData();
		data.name = name;
		data.value = value;
		var i;
		var found = false;
		var _g1 = 0, _g = this.localData.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(this.localData[i1].name == name) {
				this.localData[i1] = data;
				found = true;
			}
		}
		if(!found) this.localData.push(data);
		if(parseHandwritingConstraints && name == com.wiris.quizzes.impl.LocalData.KEY_OPENANSWER_HANDWRITING_CONSTRAINTS) this.handConstraints = com.wiris.quizzes.impl.HandwritingConstraints.readHandwritingConstraints(value);
	}
	,setLocalData: function(name,value) {
		this.setLocalDataImpl(name,value,true);
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.QuestionInstanceImpl();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.QuestionInstanceImpl.tagName);
		this.userData = s.serializeChildName(this.userData,com.wiris.quizzes.impl.UserData.TAGNAME);
		this.setChecksCompoundAnswers();
		var a = s.serializeArrayName(this.hashToChecks(this.checks),"checks");
		if(this.isCompoundAnswerChecks(a)) this.collapseCompoundAnswerChecks(a);
		this.checks = this.checksToHash(a,null);
		this.variables = this.variablesToHash(s.serializeArrayName(this.hashToVariables(this.variables,null),"variables"),null);
		this.serializeHandConstraints();
		this.localData = s.serializeArrayName(this.localData,"localData");
		s.endTag();
	}
	,handConstraints: null
	,question: null
	,compoundChecks: null
	,localData: null
	,checks: null
	,variables: null
	,userData: null
	,__class__: com.wiris.quizzes.impl.QuestionInstanceImpl
});
com.wiris.quizzes.impl.QuestionLazy = $hxClasses["com.wiris.quizzes.impl.QuestionLazy"] = function(xml) {
	com.wiris.quizzes.impl.QuestionInternal.call(this);
	var s = xml.indexOf("<question");
	if(s > 0) xml = HxOverrides.substr(xml,s,null);
	s = xml.lastIndexOf(">");
	if(s < xml.length - 1) xml = HxOverrides.substr(xml,0,s);
	s = xml.indexOf(">") + 1;
	var tag = HxOverrides.substr(xml,0,s);
	xml = HxOverrides.substr(xml,s,null);
	s = xml.lastIndexOf("<");
	if(s != -1) xml = HxOverrides.substr(xml,0,s);
	this.xml = xml;
	if(StringTools.startsWith(tag,"<question id")) {
		s = tag.indexOf("\"") + 1;
		var e = tag.indexOf("\"",s);
		this.id = HxOverrides.substr(tag,s,e - s);
	}
};
com.wiris.quizzes.impl.QuestionLazy.__name__ = ["com","wiris","quizzes","impl","QuestionLazy"];
com.wiris.quizzes.impl.QuestionLazy.__super__ = com.wiris.quizzes.impl.QuestionInternal;
com.wiris.quizzes.impl.QuestionLazy.prototype = $extend(com.wiris.quizzes.impl.QuestionInternal.prototype,{
	getDeprecationWarnings: function() {
		return this.getImpl().getDeprecationWarnings();
	}
	,addNewSlotFromModel: function(slot) {
		return this.getImpl().addNewSlotFromModel(slot);
	}
	,removeSlot: function(slot) {
		this.getImpl().removeSlot(slot);
	}
	,addNewSlot: function() {
		return this.getImpl().addNewSlot();
	}
	,getSlots: function() {
		return this.getImpl().getSlots();
	}
	,getImpl: function() {
		if(this.question == null) {
			var s = com.wiris.quizzes.impl.QuizzesImpl.getInstance().getSerializer();
			var elem = s.read("<question>" + this.xml + "</question>");
			var tag = s.getTagName(elem);
			if(!(tag == "question")) throw "Unexpected root tag " + tag + ". Expected question.";
			this.question = elem;
			this.question.id = this.id;
			this.question.updateSlots();
		}
		return this.question;
	}
	,onSerialize: function(s) {
		if(this.question != null) this.question.onSerialize(s); else {
			s.beginTag("question");
			s.cacheAttribute("id",this.id,null);
			this.xml = s.rawXml(this.xml);
			s.endTag();
		}
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.QuestionImpl();
	}
	,setId: function(id) {
		if(this.question != null) this.question.setId(id); else this.id = id;
	}
	,hasId: function() {
		if(this.question != null) return this.question.hasId(); else return this.id != null;
	}
	,getProperty: function(name) {
		return this.getImpl().getProperty(name);
	}
	,setProperty: function(name,value) {
		this.getImpl().setProperty(name,value);
	}
	,getAlgorithm: function() {
		return this.getImpl().getAlgorithm();
	}
	,setAlgorithm: function(session) {
		this.getImpl().setAlgorithm(session);
	}
	,getCorrectAnswer: function(index) {
		return this.getImpl().getCorrectAnswer(index);
	}
	,getCorrectAnswersLength: function() {
		return this.getImpl().getCorrectAnswersLength();
	}
	,setCorrectAnswer: function(index,answer) {
		this.getImpl().setCorrectAnswer(index,answer);
	}
	,getAnswerFieldType: function() {
		return this.getImpl().getAnswerFieldType();
	}
	,setAnswerFieldType: function(type) {
		this.getImpl().setAnswerFieldType(type);
	}
	,setOption: function(name,value) {
		this.getImpl().setOption(name,value);
	}
	,addAssertion: function(name,correctAnswer,studentAnswer,parameters) {
		this.getImpl().addAssertion(name,correctAnswer,studentAnswer,parameters);
	}
	,getStudentQuestion: function() {
		return this.getImpl().getStudentQuestion();
	}
	,question: null
	,id: null
	,xml: null
	,__class__: com.wiris.quizzes.impl.QuestionLazy
});
com.wiris.quizzes.impl.QuestionRequestImpl = $hxClasses["com.wiris.quizzes.impl.QuestionRequestImpl"] = function() {
	com.wiris.util.xml.SerializableImpl.call(this);
};
com.wiris.quizzes.impl.QuestionRequestImpl.__name__ = ["com","wiris","quizzes","impl","QuestionRequestImpl"];
com.wiris.quizzes.impl.QuestionRequestImpl.__interfaces__ = [com.wiris.quizzes.api.QuestionRequest];
com.wiris.quizzes.impl.QuestionRequestImpl.__super__ = com.wiris.util.xml.SerializableImpl;
com.wiris.quizzes.impl.QuestionRequestImpl.prototype = $extend(com.wiris.util.xml.SerializableImpl.prototype,{
	isEmpty: function() {
		return this.processes == null || this.processes.length == 0;
	}
	,addMetaProperty: function(name,value) {
		if(this.meta == null) this.meta = new Array();
		var p = new com.wiris.quizzes.impl.Property();
		p.name = name;
		p.value = value;
		this.meta.push(p);
	}
	,addProcess: function(p) {
		if(this.processes == null) this.processes = new Array();
		if(js.Boot.__instanceof(p,com.wiris.quizzes.impl.ProcessGetVariables)) this.processes.splice(0,0,p); else this.processes.push(p);
	}
	,variables: function(names,type) {
		var p = new com.wiris.quizzes.impl.ProcessGetVariables();
		var sb = new StringBuf();
		var i;
		var _g1 = 0, _g = names.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(i1 != 0) sb.b += Std.string(",");
			sb.b += Std.string(names[i1]);
		}
		p.names = sb.b;
		p.type = type;
		this.addProcess(p);
	}
	,checkAssertions: function() {
		var p = new com.wiris.quizzes.impl.ProcessGetCheckAssertions();
		this.addProcess(p);
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.QuestionRequestImpl();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.QuestionRequestImpl.tagName);
		this.question = s.serializeChildName(this.question,com.wiris.quizzes.impl.QuestionImpl.TAGNAME);
		this.userData = s.serializeChildName(this.userData,com.wiris.quizzes.impl.UserData.TAGNAME);
		this.processes = s.serializeArrayName(this.processes,"processes");
		this.meta = s.serializeArrayName(this.meta,"meta");
		s.endTag();
	}
	,meta: null
	,processes: null
	,userData: null
	,question: null
	,__class__: com.wiris.quizzes.impl.QuestionRequestImpl
});
com.wiris.quizzes.impl.QuestionResponseImpl = $hxClasses["com.wiris.quizzes.impl.QuestionResponseImpl"] = function() {
	com.wiris.util.xml.SerializableImpl.call(this);
};
com.wiris.quizzes.impl.QuestionResponseImpl.__name__ = ["com","wiris","quizzes","impl","QuestionResponseImpl"];
com.wiris.quizzes.impl.QuestionResponseImpl.__interfaces__ = [com.wiris.quizzes.api.QuestionResponse];
com.wiris.quizzes.impl.QuestionResponseImpl.__super__ = com.wiris.util.xml.SerializableImpl;
com.wiris.quizzes.impl.QuestionResponseImpl.prototype = $extend(com.wiris.util.xml.SerializableImpl.prototype,{
	newInstance: function() {
		return new com.wiris.quizzes.impl.QuestionResponseImpl();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.QuestionResponseImpl.tagName);
		this.results = s.serializeArray(this.results,null);
		s.endTag();
	}
	,results: null
	,__class__: com.wiris.quizzes.impl.QuestionResponseImpl
});
com.wiris.quizzes.impl.QuizzesEnumUtils = $hxClasses["com.wiris.quizzes.impl.QuizzesEnumUtils"] = function() {
};
com.wiris.quizzes.impl.QuizzesEnumUtils.__name__ = ["com","wiris","quizzes","impl","QuizzesEnumUtils"];
com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxNames = null;
com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterNames = null;
com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxName2String = function(name) {
	return com.wiris.util.type.HashUtils.getKey(name,com.wiris.quizzes.impl.QuizzesEnumUtils.getSyntaxNamesHash());
}
com.wiris.quizzes.impl.QuizzesEnumUtils.string2SyntaxName = function(name) {
	return com.wiris.quizzes.impl.QuizzesEnumUtils.getSyntaxNamesHash().get(name);
}
com.wiris.quizzes.impl.QuizzesEnumUtils.getSyntaxNamesHash = function() {
	if(com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxNames == null) {
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxNames = new Hash();
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxNames.set(com.wiris.quizzes.impl.Assertion.SYNTAX_MATH,com.wiris.quizzes.api.assertion.SyntaxName.MATH);
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxNames.set(com.wiris.quizzes.impl.Assertion.SYNTAX_GRAPHIC,com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC);
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxNames.set(com.wiris.quizzes.impl.Assertion.SYNTAX_STRING,com.wiris.quizzes.api.assertion.SyntaxName.STRING);
	}
	return com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxNames;
}
com.wiris.quizzes.impl.QuizzesEnumUtils.getSyntaxParameterNamesHash = function() {
	if(com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterNames == null) {
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterNames = new Hash();
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_CONSTANTS,com.wiris.quizzes.api.assertion.SyntaxParameterName.CONSTANTS);
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_FUNCTIONS,com.wiris.quizzes.api.assertion.SyntaxParameterName.FUNCTIONS);
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_GROUP_OPERATORS,com.wiris.quizzes.api.assertion.SyntaxParameterName.GROUP_OPERATORS);
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_LIST_OPERATORS,com.wiris.quizzes.api.assertion.SyntaxParameterName.LIST_OPERATORS);
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_UNITS,com.wiris.quizzes.api.assertion.SyntaxParameterName.UNITS);
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_UNIT_PREFIXES,com.wiris.quizzes.api.assertion.SyntaxParameterName.UNIT_PREFIXES);
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_MIXED_FRACTIONS,com.wiris.quizzes.api.assertion.SyntaxParameterName.MIXED_FRACTIONS);
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_ITEM_SEPARATORS,com.wiris.quizzes.api.assertion.SyntaxParameterName.ITEM_SEPARATORS);
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_DECIMAL_SEPARATORS,com.wiris.quizzes.api.assertion.SyntaxParameterName.DECIMAL_SEPARATORS);
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_DIGIT_GROUP_SEPARATORS,com.wiris.quizzes.api.assertion.SyntaxParameterName.DIGIT_GROUP_SEPARATORS);
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_NO_BRACKETS_LIST,com.wiris.quizzes.api.assertion.SyntaxParameterName.NO_BRACKETS_LIST);
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_INTERVALS,com.wiris.quizzes.api.assertion.SyntaxParameterName.INTERVALS);
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_RATIO,com.wiris.quizzes.api.assertion.SyntaxParameterName.RATIO);
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_SCIENTIFIC_NOTATION,com.wiris.quizzes.api.assertion.SyntaxParameterName.SCIENTIFIC_NOTATION);
		com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_GRAPH_MODE,com.wiris.quizzes.api.assertion.SyntaxParameterName.GRAPH_MODE);
	}
	return com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterNames;
}
com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterName2String = function(name) {
	var h = com.wiris.quizzes.impl.QuizzesEnumUtils.getSyntaxParameterNamesHash();
	return com.wiris.util.type.HashUtils.getKey(name,h);
}
com.wiris.quizzes.impl.QuizzesEnumUtils.string2SyntaxParameterName = function(name) {
	return com.wiris.quizzes.impl.QuizzesEnumUtils.getSyntaxParameterNamesHash().get(name);
}
com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonNames = null;
com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonParameterNames = null;
com.wiris.quizzes.impl.QuizzesEnumUtils.getComparisonNamesHash = function() {
	if(com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonNames == null) {
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonNames = new Hash();
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonNames.set(com.wiris.quizzes.impl.Assertion.EQUIVALENT_SYMBOLIC,com.wiris.quizzes.api.assertion.ComparisonName.MATHEMATICALLY_EQUAL);
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonNames.set(com.wiris.quizzes.impl.Assertion.EQUIVALENT_LITERAL,com.wiris.quizzes.api.assertion.ComparisonName.LITERALLY_EQUAL);
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonNames.set(com.wiris.quizzes.impl.Assertion.EQUIVALENT_EQUATIONS,com.wiris.quizzes.api.assertion.ComparisonName.EQUIVALENT_EQUATIONS);
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonNames.set(com.wiris.quizzes.impl.Assertion.EQUIVALENT_ALL,com.wiris.quizzes.api.assertion.ComparisonName.ANY_ANSWER);
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonNames.set(com.wiris.quizzes.impl.Assertion.EQUIVALENT_FUNCTION,com.wiris.quizzes.api.assertion.ComparisonName.GRADING_FUNCTION);
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonNames.set(com.wiris.quizzes.impl.Assertion.EQUIVALENT_GRAPHIC,com.wiris.quizzes.api.assertion.ComparisonName.GRAPHICALLY_EQUAL);
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonNames.set(com.wiris.quizzes.impl.Assertion.EQUIVALENT_SKETCH,com.wiris.quizzes.api.assertion.ComparisonName.SKETCH_EQUAL);
	}
	return com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonNames;
}
com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonName2String = function(name) {
	return com.wiris.util.type.HashUtils.getKey(name,com.wiris.quizzes.impl.QuizzesEnumUtils.getComparisonNamesHash());
}
com.wiris.quizzes.impl.QuizzesEnumUtils.string2ComparisonName = function(name) {
	return com.wiris.quizzes.impl.QuizzesEnumUtils.getComparisonNamesHash().get(name);
}
com.wiris.quizzes.impl.QuizzesEnumUtils.getComparisonParameterNamesHash = function() {
	if(com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonParameterNames == null) {
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonParameterNames = new Hash();
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_ORDER_MATTERS,com.wiris.quizzes.api.assertion.ComparisonParameterName.ORDER_MATTERS);
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_REPETITION_MATTERS,com.wiris.quizzes.api.assertion.ComparisonParameterName.REPETITION_MATTERS);
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE,com.wiris.quizzes.api.assertion.ComparisonParameterName.TOLERANCE);
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_TOLERANCE_DIGITS,com.wiris.quizzes.api.assertion.ComparisonParameterName.TOLERANCE_DIGITS);
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_RELATIVE_TOLERANCE,com.wiris.quizzes.api.assertion.ComparisonParameterName.RELATIVE_TOLERANCE);
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_NAME,com.wiris.quizzes.api.assertion.ComparisonParameterName.FUNCTION_NAME);
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_USE_CASE,com.wiris.quizzes.api.assertion.ComparisonParameterName.MATCH_CASES);
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_USE_SPACES,com.wiris.quizzes.api.assertion.ComparisonParameterName.MATCH_SPACES);
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_ELEMENTS_TO_GRADE,com.wiris.quizzes.api.assertion.ComparisonParameterName.ELEMENTS_TO_GRADE);
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_NOT_EVALUATE,com.wiris.quizzes.api.assertion.ComparisonParameterName.NOT_EVALUATE);
		com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_FUNCTION_ARGUMENT_MODE,com.wiris.quizzes.api.assertion.ComparisonParameterName.FUNCTION_ARGUMENT_MODE);
	}
	return com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonParameterNames;
}
com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonParameterName2String = function(name) {
	return com.wiris.util.type.HashUtils.getKey(name,com.wiris.quizzes.impl.QuizzesEnumUtils.getComparisonParameterNamesHash());
}
com.wiris.quizzes.impl.QuizzesEnumUtils.string2ComparisonParameterName = function(name) {
	return com.wiris.quizzes.impl.QuizzesEnumUtils.getComparisonParameterNamesHash().get(name);
}
com.wiris.quizzes.impl.QuizzesEnumUtils.validationNames = null;
com.wiris.quizzes.impl.QuizzesEnumUtils.validationParameterNames = null;
com.wiris.quizzes.impl.QuizzesEnumUtils.getValidationNamesHash = function() {
	if(com.wiris.quizzes.impl.QuizzesEnumUtils.validationNames == null) {
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationNames = new Hash();
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationNames.set(com.wiris.quizzes.impl.Assertion.CHECK_SYMBOLIC,com.wiris.quizzes.api.assertion.ValidationName.CHECK_SYMBOLIC);
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationNames.set(com.wiris.quizzes.impl.Assertion.CHECK_SCIENTIFIC_NOTATION,com.wiris.quizzes.api.assertion.ValidationName.CHECK_SCIENTIFIC_NOTATION);
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationNames.set(com.wiris.quizzes.impl.Assertion.CHECK_DECIMAL_NOTATION,com.wiris.quizzes.api.assertion.ValidationName.CHECK_DECIMAL_NOTATION);
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationNames.set(com.wiris.quizzes.impl.Assertion.CHECK_SIMPLIFIED,com.wiris.quizzes.api.assertion.ValidationName.CHECK_SIMPLIFIED);
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationNames.set(com.wiris.quizzes.impl.Assertion.CHECK_EXPANDED,com.wiris.quizzes.api.assertion.ValidationName.CHECK_EXPANDED);
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationNames.set(com.wiris.quizzes.impl.Assertion.CHECK_FACTORIZED,com.wiris.quizzes.api.assertion.ValidationName.CHECK_FACTORIZED);
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationNames.set(com.wiris.quizzes.impl.Assertion.CHECK_NO_COMMON_FACTOR,com.wiris.quizzes.api.assertion.ValidationName.CHECK_NO_COMMON_FACTOR);
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationNames.set(com.wiris.quizzes.impl.Assertion.CHECK_COMMON_DENOMINATOR,com.wiris.quizzes.api.assertion.ValidationName.CHECK_COMMON_DENOMINATOR);
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationNames.set(com.wiris.quizzes.impl.Assertion.CHECK_RATIONALIZED,com.wiris.quizzes.api.assertion.ValidationName.CHECK_RATIONALIZED);
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationNames.set(com.wiris.quizzes.impl.Assertion.CHECK_MINIMAL_RADICANDS,com.wiris.quizzes.api.assertion.ValidationName.CHECK_MINIMAL_RADICANDS);
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationNames.set(com.wiris.quizzes.impl.Assertion.CHECK_EQUIVALENT_UNITS,com.wiris.quizzes.api.assertion.ValidationName.CHECK_EQUIVALENT_UNITS);
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationNames.set(com.wiris.quizzes.impl.Assertion.CHECK_PRECISION,com.wiris.quizzes.api.assertion.ValidationName.CHECK_PRECISION);
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationNames.set(com.wiris.quizzes.impl.Assertion.CHECK_COLOR,com.wiris.quizzes.api.assertion.ValidationName.CHECK_COLOR);
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationNames.set(com.wiris.quizzes.impl.Assertion.CHECK_LINESTYLE,com.wiris.quizzes.api.assertion.ValidationName.CHECK_LINE_STYLE);
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationNames.set(com.wiris.quizzes.impl.Assertion.CHECK_NO_SUPERFLUOUS,com.wiris.quizzes.api.assertion.ValidationName.CHECK_NO_SUPERFLUOUS);
	}
	return com.wiris.quizzes.impl.QuizzesEnumUtils.validationNames;
}
com.wiris.quizzes.impl.QuizzesEnumUtils.validationName2String = function(name) {
	return com.wiris.util.type.HashUtils.getKey(name,com.wiris.quizzes.impl.QuizzesEnumUtils.getValidationNamesHash());
}
com.wiris.quizzes.impl.QuizzesEnumUtils.string2ValidationName = function(name) {
	return com.wiris.quizzes.impl.QuizzesEnumUtils.getValidationNamesHash().get(name);
}
com.wiris.quizzes.impl.QuizzesEnumUtils.getValidationParameterNamesHash = function() {
	if(com.wiris.quizzes.impl.QuizzesEnumUtils.validationParameterNames == null) {
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationParameterNames = new Hash();
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_MAX,com.wiris.quizzes.api.assertion.ValidationParameterName.MAX);
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_MIN,com.wiris.quizzes.api.assertion.ValidationParameterName.MIN);
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_RELATIVE,com.wiris.quizzes.api.assertion.ValidationParameterName.RELATIVE);
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_ALLOW_PREFIXES,com.wiris.quizzes.api.assertion.ValidationParameterName.ALLOW_PREFIXES);
		com.wiris.quizzes.impl.QuizzesEnumUtils.validationParameterNames.set(com.wiris.quizzes.impl.Assertion.PARAM_ELEMENTS_TO_GRADE,com.wiris.quizzes.api.assertion.ValidationParameterName.ELEMENTS_TO_GRADE);
	}
	return com.wiris.quizzes.impl.QuizzesEnumUtils.validationParameterNames;
}
com.wiris.quizzes.impl.QuizzesEnumUtils.validationParameterName2String = function(name) {
	return com.wiris.util.type.HashUtils.getKey(name,com.wiris.quizzes.impl.QuizzesEnumUtils.getValidationParameterNamesHash());
}
com.wiris.quizzes.impl.QuizzesEnumUtils.string2ValidationParameterName = function(name) {
	return com.wiris.quizzes.impl.QuizzesEnumUtils.getValidationParameterNamesHash().get(name);
}
com.wiris.quizzes.impl.QuizzesEnumUtils.answerFieldTypes = null;
com.wiris.quizzes.impl.QuizzesEnumUtils.getAnswerFieldTypes = function() {
	if(com.wiris.quizzes.impl.QuizzesEnumUtils.answerFieldTypes == null) {
		com.wiris.quizzes.impl.QuizzesEnumUtils.answerFieldTypes = new Hash();
		com.wiris.quizzes.impl.QuizzesEnumUtils.answerFieldTypes.set(com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_INPUT_FIELD_INLINE_EDITOR,com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_MATH_EDITOR);
		com.wiris.quizzes.impl.QuizzesEnumUtils.answerFieldTypes.set(com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_INPUT_FIELD_INLINE_HAND,com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_MATH_EDITOR);
		com.wiris.quizzes.impl.QuizzesEnumUtils.answerFieldTypes.set(com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_INPUT_FIELD_POPUP_EDITOR,com.wiris.quizzes.api.ui.AnswerFieldType.POPUP_MATH_EDITOR);
		com.wiris.quizzes.impl.QuizzesEnumUtils.answerFieldTypes.set(com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_INPUT_FIELD_PLAIN_TEXT,com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD);
		com.wiris.quizzes.impl.QuizzesEnumUtils.answerFieldTypes.set(com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_INPUT_FIELD_INLINE_GRAPH,com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR);
	}
	return com.wiris.quizzes.impl.QuizzesEnumUtils.answerFieldTypes;
}
com.wiris.quizzes.impl.QuizzesEnumUtils.string2answerFieldType = function(a) {
	return com.wiris.quizzes.impl.QuizzesEnumUtils.getAnswerFieldTypes().get(a);
}
com.wiris.quizzes.impl.QuizzesEnumUtils.answerFieldType2String = function(a) {
	return com.wiris.util.type.HashUtils.getKey(a,com.wiris.quizzes.impl.QuizzesEnumUtils.getAnswerFieldTypes());
}
com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames = null;
com.wiris.quizzes.impl.QuizzesEnumUtils.getPropertyNames = function() {
	if(com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames == null) {
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames = new Hash();
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames.set(com.wiris.quizzes.api.QuizzesConstants.OPTION_STUDENT_ANSWER_PARAMETER,com.wiris.quizzes.api.PropertyName.STUDENT_ANSWER_PARAMETER);
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames.set(com.wiris.quizzes.api.QuizzesConstants.OPTION_STUDENT_ANSWER_PARAMETER_NAME,com.wiris.quizzes.api.PropertyName.STUDENT_ANSWER_PARAMETER_NAME);
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames.set(com.wiris.quizzes.api.QuizzesConstants.PROPERTY_ANSWER_FIELD_TYPE,com.wiris.quizzes.api.PropertyName.ANSWER_FIELD_TYPE);
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames.set(com.wiris.quizzes.api.QuizzesConstants.PROPERTY_COMPOUND_ANSWER,com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER);
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames.set(com.wiris.quizzes.api.QuizzesConstants.PROPERTY_COMPOUND_ANSWER_GRADE,com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER_GRADE);
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames.set(com.wiris.quizzes.api.QuizzesConstants.PROPERTY_COMPOUND_ANSWER_GRADE_DISTRIBUTION,com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER_GRADE_DISTRIBUTION);
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames.set(com.wiris.quizzes.api.QuizzesConstants.PROPERTY_SHOW_CAS,com.wiris.quizzes.api.PropertyName.SHOW_CAS);
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames.set(com.wiris.quizzes.api.QuizzesConstants.PROPERTY_CAS_SESSION,com.wiris.quizzes.api.PropertyName.CAS_SESSION);
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames.set(com.wiris.quizzes.api.QuizzesConstants.PROPERTY_SHOW_AUXILIARY_TEXT_INPUT,com.wiris.quizzes.api.PropertyName.SHOW_AUXILIARY_TEXT_INPUT);
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames.set(com.wiris.quizzes.api.QuizzesConstants.PROPERTY_AUXILIARY_TEXT,com.wiris.quizzes.api.PropertyName.AUXILIARY_TEXT);
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames.set(com.wiris.quizzes.api.QuizzesConstants.PARAMETER_USER_ID,com.wiris.quizzes.api.PropertyName.USER_ID);
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames.set(com.wiris.quizzes.impl.LocalData.KEY_OPENANSWER_HANDWRITING_CONSTRAINTS,com.wiris.quizzes.api.PropertyName.HANDWRITING_CONSTRAINTS);
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames.set(com.wiris.quizzes.impl.LocalData.KEY_OPENANSWER_GRAPH_TOOLBAR,com.wiris.quizzes.api.PropertyName.GRAPH_TOOLBAR);
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames.set(com.wiris.quizzes.impl.LocalData.KEY_AUXILIARY_CAS_HIDE_FILE_MENU,com.wiris.quizzes.api.PropertyName.AUXILIARY_CAS_HIDE_FILE_MENU);
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames.set(com.wiris.quizzes.impl.LocalData.KEY_ELEMENTS_TO_HANDWRITE,com.wiris.quizzes.api.PropertyName.ELEMENTS_TO_HANDWRITE);
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames.set(com.wiris.quizzes.impl.LocalData.KEY_GRAPH_LOCK_INITIAL_CONTENT,com.wiris.quizzes.api.PropertyName.GRAPH_LOCK_INITIAL_CONTENT);
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames.set(com.wiris.quizzes.impl.LocalData.KEY_GRAPH_SHOW_NAME_IN_LABEL,com.wiris.quizzes.api.PropertyName.GRAPH_SHOW_NAME_IN_LABEL);
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames.set(com.wiris.quizzes.impl.LocalData.KEY_GRAPH_SHOW_VALUE_IN_LABEL,com.wiris.quizzes.api.PropertyName.GRAPH_SHOW_VALUE_IN_LABEL);
		com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames.set(com.wiris.quizzes.impl.LocalData.KEY_GRAPH_MAGNETIC_GRID,com.wiris.quizzes.api.PropertyName.GRAPH_MAGNETIC_GRID);
	}
	return com.wiris.quizzes.impl.QuizzesEnumUtils.propertyNames;
}
com.wiris.quizzes.impl.QuizzesEnumUtils.string2PropertyName = function(name) {
	return com.wiris.quizzes.impl.QuizzesEnumUtils.getPropertyNames().get(name);
}
com.wiris.quizzes.impl.QuizzesEnumUtils.propertyName2String = function(name) {
	return com.wiris.util.type.HashUtils.getKey(name,com.wiris.quizzes.impl.QuizzesEnumUtils.getPropertyNames());
}
com.wiris.quizzes.impl.QuizzesEnumUtils.graphModes = null;
com.wiris.quizzes.impl.QuizzesEnumUtils.getGraphModes = function() {
	if(com.wiris.quizzes.impl.QuizzesEnumUtils.graphModes == null) {
		com.wiris.quizzes.impl.QuizzesEnumUtils.graphModes = new Hash();
		com.wiris.quizzes.impl.QuizzesEnumUtils.graphModes.set(com.wiris.quizzes.impl.Assertion.GRAPH_MODE_STANDARD,com.wiris.util.geometry.GraphMode.STANDARD);
		com.wiris.quizzes.impl.QuizzesEnumUtils.graphModes.set(com.wiris.quizzes.impl.Assertion.GRAPH_MODE_SKETCH,com.wiris.util.geometry.GraphMode.SKETCH);
		com.wiris.quizzes.impl.QuizzesEnumUtils.graphModes.set(com.wiris.quizzes.impl.Assertion.GRAPH_MODE_PIE_CHART,com.wiris.util.geometry.GraphMode.PIE_CHART);
		com.wiris.quizzes.impl.QuizzesEnumUtils.graphModes.set(com.wiris.quizzes.impl.Assertion.GRAPH_MODE_BAR_CHART,com.wiris.util.geometry.GraphMode.BAR_CHART);
		com.wiris.quizzes.impl.QuizzesEnumUtils.graphModes.set(com.wiris.quizzes.impl.Assertion.GRAPH_MODE_LINE_CHART,com.wiris.util.geometry.GraphMode.LINE_CHART);
	}
	return com.wiris.quizzes.impl.QuizzesEnumUtils.graphModes;
}
com.wiris.quizzes.impl.QuizzesEnumUtils.string2GraphMode = function(mode) {
	return com.wiris.quizzes.impl.QuizzesEnumUtils.getGraphModes().get(mode);
}
com.wiris.quizzes.impl.QuizzesEnumUtils.prototype = {
	__class__: com.wiris.quizzes.impl.QuizzesEnumUtils
}
com.wiris.quizzes.impl.QuizzesServiceMultipleListener = $hxClasses["com.wiris.quizzes.impl.QuizzesServiceMultipleListener"] = function() { }
com.wiris.quizzes.impl.QuizzesServiceMultipleListener.__name__ = ["com","wiris","quizzes","impl","QuizzesServiceMultipleListener"];
com.wiris.quizzes.impl.QuizzesServiceMultipleListener.prototype = {
	onResponse: null
	,__class__: com.wiris.quizzes.impl.QuizzesServiceMultipleListener
}
com.wiris.quizzes.impl.QuizzesServiceSingleListener = $hxClasses["com.wiris.quizzes.impl.QuizzesServiceSingleListener"] = function(listener) {
	this.listener = listener;
};
com.wiris.quizzes.impl.QuizzesServiceSingleListener.__name__ = ["com","wiris","quizzes","impl","QuizzesServiceSingleListener"];
com.wiris.quizzes.impl.QuizzesServiceSingleListener.__interfaces__ = [com.wiris.quizzes.impl.QuizzesServiceMultipleListener];
com.wiris.quizzes.impl.QuizzesServiceSingleListener.prototype = {
	onResponse: function(mqs) {
		var qs;
		if(mqs.questionResponses.length == 0) qs = new com.wiris.quizzes.impl.QuestionResponseImpl(); else qs = mqs.questionResponses[0];
		this.listener.onResponse(qs);
	}
	,listener: null
	,__class__: com.wiris.quizzes.impl.QuizzesServiceSingleListener
}
com.wiris.quizzes.impl.QuizzesServiceSyncListener = $hxClasses["com.wiris.quizzes.impl.QuizzesServiceSyncListener"] = function() {
};
com.wiris.quizzes.impl.QuizzesServiceSyncListener.__name__ = ["com","wiris","quizzes","impl","QuizzesServiceSyncListener"];
com.wiris.quizzes.impl.QuizzesServiceSyncListener.__interfaces__ = [com.wiris.quizzes.impl.QuizzesServiceMultipleListener];
com.wiris.quizzes.impl.QuizzesServiceSyncListener.prototype = {
	onResponse: function(mqs) {
		this.mqs = mqs;
	}
	,mqs: null
	,__class__: com.wiris.quizzes.impl.QuizzesServiceSyncListener
}
com.wiris.quizzes.impl.QuizzesTranslator = $hxClasses["com.wiris.quizzes.impl.QuizzesTranslator"] = function(lang,source) {
	this.lang = lang;
	this.strings = new Hash();
	var i = 0;
	while(i < source.length && !(source[i][0] == "lang" && source[i][1] == lang)) i++;
	while(i < source.length && !(source[i][0] == "lang" && !(source[i][1] == lang))) {
		this.strings.set(source[i][0],source[i][1]);
		i++;
	}
};
com.wiris.quizzes.impl.QuizzesTranslator.__name__ = ["com","wiris","quizzes","impl","QuizzesTranslator"];
com.wiris.quizzes.impl.QuizzesTranslator.getInstance = function(lang) {
	if(com.wiris.quizzes.impl.QuizzesTranslator.languages == null) com.wiris.quizzes.impl.QuizzesTranslator.languages = new Hash();
	lang = com.wiris.quizzes.impl.QuizzesTranslator.getBestMatch(lang);
	if(lang == null) throw "No languages defined.";
	if(!com.wiris.quizzes.impl.QuizzesTranslator.languages.exists(lang)) {
		var translator = new com.wiris.quizzes.impl.QuizzesTranslator(lang,com.wiris.quizzes.impl.Strings.lang);
		com.wiris.quizzes.impl.QuizzesTranslator.languages.set(lang,translator);
	}
	return com.wiris.quizzes.impl.QuizzesTranslator.languages.get(lang);
}
com.wiris.quizzes.impl.QuizzesTranslator.getBestMatch = function(lang) {
	var a = com.wiris.quizzes.impl.QuizzesTranslator.getAvailableLanguages();
	if(com.wiris.util.type.Arrays.contains(a,lang)) return lang;
	var i;
	if((i = lang.indexOf("_")) != -1) {
		lang = HxOverrides.substr(lang,0,i);
		if(com.wiris.util.type.Arrays.contains(a,lang)) return lang;
	}
	var _g1 = 0, _g = a.length;
	while(_g1 < _g) {
		var i1 = _g1++;
		if(StringTools.startsWith(a[i1],lang + "_")) return a[i1];
	}
	if(com.wiris.util.type.Arrays.contains(a,"en")) return "en";
	if(a.length > 0) return a[0];
	return null;
}
com.wiris.quizzes.impl.QuizzesTranslator.getAvailableLanguages = function() {
	if(com.wiris.quizzes.impl.QuizzesTranslator.available == null) {
		com.wiris.quizzes.impl.QuizzesTranslator.available = new Array();
		var i;
		var _g1 = 0, _g = com.wiris.quizzes.impl.Strings.lang.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(com.wiris.quizzes.impl.Strings.lang[i1][0] == "lang") com.wiris.quizzes.impl.QuizzesTranslator.available.push(com.wiris.quizzes.impl.Strings.lang[i1][1]);
		}
	}
	return com.wiris.quizzes.impl.QuizzesTranslator.available;
}
com.wiris.quizzes.impl.QuizzesTranslator.prototype = {
	t: function(code) {
		if(this.strings.exists(code)) code = this.strings.get(code); else if(!(this.lang == "en")) code = com.wiris.quizzes.impl.QuizzesTranslator.getInstance("en").t(code);
		return code;
	}
	,lang: null
	,strings: null
	,__class__: com.wiris.quizzes.impl.QuizzesTranslator
}
com.wiris.quizzes.impl.QuizzesUIBuilderImpl = $hxClasses["com.wiris.quizzes.impl.QuizzesUIBuilderImpl"] = function() {
};
com.wiris.quizzes.impl.QuizzesUIBuilderImpl.__name__ = ["com","wiris","quizzes","impl","QuizzesUIBuilderImpl"];
com.wiris.quizzes.impl.QuizzesUIBuilderImpl.__interfaces__ = [com.wiris.quizzes.api.ui.QuizzesUIBuilder];
com.wiris.quizzes.impl.QuizzesUIBuilderImpl.prototype = {
	getAuthorAnswerFromCorrectAnswerIndex: function(slot,correctAnswer) {
		if(correctAnswer < 0) throw "Invalid correct answer!";
		var authorAnswers = slot.getAuthorAnswers();
		var _g = 0;
		while(_g < authorAnswers.length) {
			var aa = authorAnswers[_g];
			++_g;
			var aai = aa;
			if(aai.id != null && Std.parseInt(aai.id) == correctAnswer) return aai;
		}
		while(true) {
			var aa = slot.addNewAuthorAnswer("");
			var id = Std.parseInt(aa.id);
			if(id == correctAnswer) return aa; else if(id > correctAnswer) throw "Invalid correct answer!";
		}
	}
	,getSlotFromStudentAnswerIndex: function(question,studentAnswer) {
		if(studentAnswer < 0) throw "Invalid student answer!";
		var slots = question.getSlots();
		var _g = 0;
		while(_g < slots.length) {
			var s = slots[_g];
			++_g;
			var si = s;
			if(si.id != null && Std.parseInt(si.id) == studentAnswer) return si;
		}
		while(true) {
			var s = question.addNewSlot();
			var id = Std.parseInt(s.id);
			if(id == studentAnswer) return s; else if(id > studentAnswer) throw "Invalid student answer!";
		}
	}
	,replaceFields: function(question,instance,element) {
		var instanceImpl = instance;
		instanceImpl.question = question;
		com.wiris.quizzes.api.Quizzes.getInstance().getQuizzesComponentBuilder().replaceFields(question,instance,element);
	}
	,getMathViewer: function() {
		return com.wiris.quizzes.api.Quizzes.getInstance().getQuizzesComponentBuilder().getMathViewer();
	}
	,newAuxiliarCasField: function(question,instance,index) {
		var instanceImpl = instance;
		instanceImpl.question = question;
		var slot = this.getSlotFromStudentAnswerIndex(question,index);
		return com.wiris.quizzes.api.Quizzes.getInstance().getQuizzesComponentBuilder().newAuxiliaryCasField(instance,slot);
	}
	,newEmbeddedAnswersEditor: function(question,instance) {
		return com.wiris.quizzes.api.Quizzes.getInstance().getQuizzesComponentBuilder().newEmbeddedAnswersEditor(question,instance);
	}
	,newAuthoringField: function(question,instance,correctAnswer,userAnswer) {
		var slot = this.getSlotFromStudentAnswerIndex(question,userAnswer);
		var authorAnswer = this.getAuthorAnswerFromCorrectAnswerIndex(slot,correctAnswer);
		return com.wiris.quizzes.api.Quizzes.getInstance().getQuizzesComponentBuilder().newAuthoringField(question,slot,authorAnswer);
	}
	,newAnswerField: function(question,instance,index) {
		var instanceImpl = instance;
		instanceImpl.question = question;
		var slot = this.getSlotFromStudentAnswerIndex(question,index);
		return com.wiris.quizzes.api.Quizzes.getInstance().getQuizzesComponentBuilder().newAnswerField(instance,slot);
	}
	,newAnswerFeedback: function(question,instance,correctAnswer,studentAnswer) {
		var instanceImpl = instance;
		instanceImpl.question = question;
		var slot = this.getSlotFromStudentAnswerIndex(question,studentAnswer);
		var authorAnswer = this.getAuthorAnswerFromCorrectAnswerIndex(slot,correctAnswer);
		return com.wiris.quizzes.api.Quizzes.getInstance().getQuizzesComponentBuilder().newAnswerFeedback(instance,slot,authorAnswer);
	}
	,setLanguage: function(lang) {
		com.wiris.quizzes.api.Quizzes.getInstance().getQuizzesComponentBuilder().setLanguage(lang);
	}
	,__class__: com.wiris.quizzes.impl.QuizzesUIBuilderImpl
}
com.wiris.quizzes.impl.Result = $hxClasses["com.wiris.quizzes.impl.Result"] = function() {
	com.wiris.util.xml.SerializableImpl.call(this);
};
com.wiris.quizzes.impl.Result.__name__ = ["com","wiris","quizzes","impl","Result"];
com.wiris.quizzes.impl.Result.__super__ = com.wiris.util.xml.SerializableImpl;
com.wiris.quizzes.impl.Result.prototype = $extend(com.wiris.util.xml.SerializableImpl.prototype,{
	onSerializeInner: function(s) {
		this.errors = s.serializeArray(this.errors,com.wiris.quizzes.impl.ResultError.tagName);
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.Result();
	}
	,onSerialize: function(s) {
	}
	,errors: null
	,__class__: com.wiris.quizzes.impl.Result
});
com.wiris.quizzes.impl.ResultError = $hxClasses["com.wiris.quizzes.impl.ResultError"] = function() {
	com.wiris.util.xml.SerializableImpl.call(this);
};
com.wiris.quizzes.impl.ResultError.__name__ = ["com","wiris","quizzes","impl","ResultError"];
com.wiris.quizzes.impl.ResultError.__super__ = com.wiris.util.xml.SerializableImpl;
com.wiris.quizzes.impl.ResultError.prototype = $extend(com.wiris.util.xml.SerializableImpl.prototype,{
	onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.ResultError.tagName);
		this.type = s.attributeString("type",this.type,null);
		this.id = s.attributeString("id",this.id,null);
		this.location = s.serializeChild(this.location);
		this.detail = s.childString("detail",this.detail,null);
		s.endTag();
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.ResultError();
	}
	,id: null
	,type: null
	,detail: null
	,location: null
	,__class__: com.wiris.quizzes.impl.ResultError
});
com.wiris.quizzes.impl.ResultErrorLocation = $hxClasses["com.wiris.quizzes.impl.ResultErrorLocation"] = function() {
	com.wiris.util.xml.SerializableImpl.call(this);
	this.fromline = -1;
	this.toline = -1;
	this.fromcolumn = -1;
	this.tocolumn = -1;
};
com.wiris.quizzes.impl.ResultErrorLocation.__name__ = ["com","wiris","quizzes","impl","ResultErrorLocation"];
com.wiris.quizzes.impl.ResultErrorLocation.__super__ = com.wiris.util.xml.SerializableImpl;
com.wiris.quizzes.impl.ResultErrorLocation.prototype = $extend(com.wiris.util.xml.SerializableImpl.prototype,{
	onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.ResultErrorLocation.tagName);
		this.element = s.attributeString("element",this.element,null);
		this.elementid = s.attributeString("ref",this.elementid,null);
		this.fromline = s.attributeInt("fromline",this.fromline,-1);
		this.toline = s.attributeInt("toline",this.toline,-1);
		this.fromcolumn = s.attributeInt("fromcolumn",this.fromcolumn,-1);
		this.tocolumn = s.attributeInt("tocolumn",this.tocolumn,-1);
		s.endTag();
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.ResultErrorLocation();
	}
	,tocolumn: null
	,fromcolumn: null
	,toline: null
	,fromline: null
	,elementid: null
	,element: null
	,__class__: com.wiris.quizzes.impl.ResultErrorLocation
});
com.wiris.quizzes.impl.ResultGetCheckAssertions = $hxClasses["com.wiris.quizzes.impl.ResultGetCheckAssertions"] = function() {
	com.wiris.quizzes.impl.Result.call(this);
};
com.wiris.quizzes.impl.ResultGetCheckAssertions.__name__ = ["com","wiris","quizzes","impl","ResultGetCheckAssertions"];
com.wiris.quizzes.impl.ResultGetCheckAssertions.__super__ = com.wiris.quizzes.impl.Result;
com.wiris.quizzes.impl.ResultGetCheckAssertions.prototype = $extend(com.wiris.quizzes.impl.Result.prototype,{
	newInstance: function() {
		return new com.wiris.quizzes.impl.ResultGetCheckAssertions();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.ResultGetCheckAssertions.tagName);
		this.onSerializeInner(s);
		this.checks = s.serializeArray(this.checks,com.wiris.quizzes.impl.AssertionCheckImpl.tagName);
		s.endTag();
	}
	,checks: null
	,__class__: com.wiris.quizzes.impl.ResultGetCheckAssertions
});
com.wiris.quizzes.impl.ResultGetFeaturedAssertions = $hxClasses["com.wiris.quizzes.impl.ResultGetFeaturedAssertions"] = function() {
	com.wiris.quizzes.impl.Result.call(this);
};
com.wiris.quizzes.impl.ResultGetFeaturedAssertions.__name__ = ["com","wiris","quizzes","impl","ResultGetFeaturedAssertions"];
com.wiris.quizzes.impl.ResultGetFeaturedAssertions.__super__ = com.wiris.quizzes.impl.Result;
com.wiris.quizzes.impl.ResultGetFeaturedAssertions.prototype = $extend(com.wiris.quizzes.impl.Result.prototype,{
	newInstance: function() {
		return new com.wiris.quizzes.impl.ResultGetFeaturedAssertions();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.ResultGetFeaturedAssertions.tagName);
		this.onSerializeInner(s);
		this.assertions = s.serializeArray(this.assertions,com.wiris.quizzes.impl.Assertion.tagName);
		s.endTag();
	}
	,assertions: null
	,__class__: com.wiris.quizzes.impl.ResultGetFeaturedAssertions
});
com.wiris.quizzes.impl.ResultGetFeaturedSyntaxAssertions = $hxClasses["com.wiris.quizzes.impl.ResultGetFeaturedSyntaxAssertions"] = function() {
	com.wiris.quizzes.impl.Result.call(this);
};
com.wiris.quizzes.impl.ResultGetFeaturedSyntaxAssertions.__name__ = ["com","wiris","quizzes","impl","ResultGetFeaturedSyntaxAssertions"];
com.wiris.quizzes.impl.ResultGetFeaturedSyntaxAssertions.__super__ = com.wiris.quizzes.impl.Result;
com.wiris.quizzes.impl.ResultGetFeaturedSyntaxAssertions.prototype = $extend(com.wiris.quizzes.impl.Result.prototype,{
	newInstance: function() {
		return new com.wiris.quizzes.impl.ResultGetFeaturedSyntaxAssertions();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.ResultGetFeaturedSyntaxAssertions.tagName);
		this.onSerializeInner(s);
		this.assertions = s.serializeArray(this.assertions,com.wiris.quizzes.impl.Assertion.tagName);
		s.endTag();
	}
	,assertions: null
	,__class__: com.wiris.quizzes.impl.ResultGetFeaturedSyntaxAssertions
});
com.wiris.quizzes.impl.ResultGetTranslation = $hxClasses["com.wiris.quizzes.impl.ResultGetTranslation"] = function() {
	com.wiris.quizzes.impl.Result.call(this);
};
com.wiris.quizzes.impl.ResultGetTranslation.__name__ = ["com","wiris","quizzes","impl","ResultGetTranslation"];
com.wiris.quizzes.impl.ResultGetTranslation.__super__ = com.wiris.quizzes.impl.Result;
com.wiris.quizzes.impl.ResultGetTranslation.prototype = $extend(com.wiris.quizzes.impl.Result.prototype,{
	newInstance: function() {
		return new com.wiris.quizzes.impl.ResultGetTranslation();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.ResultGetTranslation.tagName);
		this.onSerializeInner(s);
		this.wirisCasSession = s.childString("wirisCasSession",this.wirisCasSession,null);
		this.namechanges = s.serializeArray(this.namechanges,com.wiris.quizzes.impl.TranslationNameChange.tagName);
		s.endTag();
	}
	,namechanges: null
	,wirisCasSession: null
	,__class__: com.wiris.quizzes.impl.ResultGetTranslation
});
com.wiris.quizzes.impl.ResultGetVariables = $hxClasses["com.wiris.quizzes.impl.ResultGetVariables"] = function() {
	com.wiris.quizzes.impl.Result.call(this);
};
com.wiris.quizzes.impl.ResultGetVariables.__name__ = ["com","wiris","quizzes","impl","ResultGetVariables"];
com.wiris.quizzes.impl.ResultGetVariables.__super__ = com.wiris.quizzes.impl.Result;
com.wiris.quizzes.impl.ResultGetVariables.prototype = $extend(com.wiris.quizzes.impl.Result.prototype,{
	newInstance: function() {
		return new com.wiris.quizzes.impl.ResultGetVariables();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.ResultGetVariables.tagName);
		this.onSerializeInner(s);
		this.variables = s.serializeArray(this.variables,com.wiris.quizzes.impl.Variable.tagName);
		s.endTag();
	}
	,variables: null
	,__class__: com.wiris.quizzes.impl.ResultGetVariables
});
com.wiris.quizzes.impl.ResultStoreQuestion = $hxClasses["com.wiris.quizzes.impl.ResultStoreQuestion"] = function() {
	com.wiris.quizzes.impl.Result.call(this);
};
com.wiris.quizzes.impl.ResultStoreQuestion.__name__ = ["com","wiris","quizzes","impl","ResultStoreQuestion"];
com.wiris.quizzes.impl.ResultStoreQuestion.__super__ = com.wiris.quizzes.impl.Result;
com.wiris.quizzes.impl.ResultStoreQuestion.prototype = $extend(com.wiris.quizzes.impl.Result.prototype,{
	newInstance: function() {
		return new com.wiris.quizzes.impl.ResultStoreQuestion();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.ResultStoreQuestion.tagName);
		this.onSerializeInner(s);
		this.id = s.childString("id",this.id,null);
		s.endTag();
	}
	,id: null
	,__class__: com.wiris.quizzes.impl.ResultStoreQuestion
});
com.wiris.quizzes.impl.SharedVariables = $hxClasses["com.wiris.quizzes.impl.SharedVariables"] = function() {
	this.cache = com.wiris.quizzes.impl.QuizzesImpl.getInstance().getVariablesCache();
	this.locker = com.wiris.quizzes.impl.QuizzesImpl.getInstance().getLockProvider();
};
com.wiris.quizzes.impl.SharedVariables.__name__ = ["com","wiris","quizzes","impl","SharedVariables"];
com.wiris.quizzes.impl.SharedVariables.prototype = {
	getCacheKey: function(name) {
		return name + ".var";
	}
	,unlockVariable: function(name) {
		if(com.wiris.quizzes.impl.SharedVariables.h != null) {
			var l = com.wiris.quizzes.impl.SharedVariables.h.get(name);
			if(l != null) {
				com.wiris.quizzes.impl.SharedVariables.h.remove(name);
				l.release();
			}
		}
	}
	,lockVariable: function(name) {
		var l = this.locker.getLock(this.getCacheKey(name));
		if(com.wiris.quizzes.impl.SharedVariables.h == null) com.wiris.quizzes.impl.SharedVariables.h = new Hash();
		com.wiris.quizzes.impl.SharedVariables.h.set(name,l);
	}
	,setVariable: function(name,value) {
		var b = haxe.io.Bytes.ofData(com.wiris.system.Utf8.toBytes(value));
		this.cache.set(this.getCacheKey(name),b);
	}
	,getVariable: function(name) {
		var b = this.cache.get(this.getCacheKey(name));
		return b != null?com.wiris.system.Utf8.fromBytes(b.b):null;
	}
	,locker: null
	,cache: null
	,__class__: com.wiris.quizzes.impl.SharedVariables
}
com.wiris.quizzes.impl.SlotImpl = $hxClasses["com.wiris.quizzes.impl.SlotImpl"] = function() {
	com.wiris.util.xml.SerializableImpl.call(this);
	this.syntax = com.wiris.quizzes.impl.SyntaxAssertion.getDefaultSyntax();
	this.initialContent = new com.wiris.quizzes.impl.InitialContent();
	this.initialContent.set("");
	this.authorAnswers = new Array();
	this.localData = new Array();
};
com.wiris.quizzes.impl.SlotImpl.__name__ = ["com","wiris","quizzes","impl","SlotImpl"];
com.wiris.quizzes.impl.SlotImpl.__interfaces__ = [com.wiris.quizzes.api.Slot];
com.wiris.quizzes.impl.SlotImpl.newWithQuestionCallback = function(question) {
	var slot = new com.wiris.quizzes.impl.SlotImpl();
	slot.question = question;
	return slot;
}
com.wiris.quizzes.impl.SlotImpl.__super__ = com.wiris.util.xml.SerializableImpl;
com.wiris.quizzes.impl.SlotImpl.prototype = $extend(com.wiris.util.xml.SerializableImpl.prototype,{
	syntacticAssertionToURL: function(a) {
		var sb = new StringBuf();
		if(a.getName() == com.wiris.quizzes.api.assertion.SyntaxName.MATH) sb.b += Std.string("Math"); else if(a.getName() == com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC) sb.b += Std.string("Graphic"); else if(a.getName() == com.wiris.quizzes.api.assertion.SyntaxName.STRING) sb.b += Std.string("String");
		if(a.parameters != null && a.parameters.length > 0) {
			sb.b += Std.string("?");
			var i;
			var _g1 = 0, _g = a.parameters.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var p = a.parameters[i1];
				if(i1 > 0) sb.b += Std.string("&");
				sb.b += Std.string(StringTools.urlEncode(p.name));
				sb.b += Std.string("=");
				sb.b += Std.string(StringTools.urlEncode(p.content));
			}
		}
		return sb.b;
	}
	,getGrammarUrl: function() {
		var prefix = com.wiris.quizzes.api.Quizzes.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.SERVICE_URL);
		prefix += "/grammar/";
		var url = null;
		if(this.syntax != null) url = prefix + this.syntacticAssertionToURL(this.syntax);
		if(url == null) url = prefix + "Math";
		return url;
	}
	,isSlotCompoundAnswer: function() {
		return this.getProperty(com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER) == com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_COMPOUND_ANSWER_TRUE;
	}
	,removeProperty: function(name) {
		this.question.id = null;
		com.wiris.quizzes.impl.QuestionImpl.removeLocalDataFromArray(com.wiris.quizzes.impl.QuizzesEnumUtils.propertyName2String(name),this.localData);
	}
	,getAnswerFieldType: function() {
		var stringType = this.getProperty(com.wiris.quizzes.api.PropertyName.ANSWER_FIELD_TYPE);
		return com.wiris.quizzes.impl.QuizzesEnumUtils.string2answerFieldType(stringType);
	}
	,importSlot: function(slot) {
		this.id = slot.id;
		this.syntax = slot.syntax;
		this.authorAnswers = slot.authorAnswers;
		this.initialContent = slot.initialContent;
		this.localData = slot.localData;
		this.question = slot.question;
	}
	,setInitialContent: function(content) {
		this.initialContent.set(content);
	}
	,getInitialContent: function() {
		return this.initialContent.content;
	}
	,setSyntax: function(type) {
		if(type == null || type == this.syntax.getName()) return this.syntax;
		this.question.id = null;
		this.syntax.setName(type);
		if(type == com.wiris.quizzes.api.assertion.SyntaxName.STRING && this.getAnswerFieldType() != com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD) this.setAnswerFieldType(com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD); else if(type == com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC && this.getAnswerFieldType() != com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR) this.setAnswerFieldType(com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR); else if(this.getAnswerFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR) this.setAnswerFieldType(com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_MATH_EDITOR);
		this.syntax.parameters = new Array();
		return this.syntax;
	}
	,getSyntax: function() {
		return this.syntax;
	}
	,getProperty: function(name) {
		var key = com.wiris.quizzes.impl.QuizzesEnumUtils.propertyName2String(name);
		if(!com.wiris.util.type.Arrays.containsArray(com.wiris.quizzes.impl.LocalData.keys,key)) throw "Property " + key + " is not supported in Slot. Please get it from the Question object instead.";
		var ld = com.wiris.quizzes.impl.QuestionImpl.getLocalDataFromArray(key,this.localData);
		return ld != null?ld:this.question.getProperty(name);
	}
	,setAnswerFieldType: function(type) {
		if(type != null) this.setProperty(com.wiris.quizzes.api.PropertyName.ANSWER_FIELD_TYPE,com.wiris.quizzes.impl.QuizzesEnumUtils.answerFieldType2String(type)); else throw "Null answer field type!";
	}
	,setLocalData: function(key,value) {
		if(this.localData == null) this.localData = new Array();
		com.wiris.quizzes.impl.QuestionImpl.setLocalDataToArray(key,value,this.localData);
	}
	,setProperty: function(name,value) {
		var key = com.wiris.quizzes.impl.QuizzesEnumUtils.propertyName2String(name);
		if(!com.wiris.util.type.Arrays.containsArray(com.wiris.quizzes.impl.LocalData.keys,key)) throw "Property " + key + " is not supported in Slot. Please set it to the Question object instead.";
		this.setLocalData(key,value);
	}
	,removeAuthorAnswer: function(answer) {
		if(HxOverrides.remove(this.authorAnswers,answer)) this.question.authorAnswerRemoved(answer);
	}
	,addAuthorAnswerImpl: function(aa) {
		this.authorAnswers.push(aa);
		this.question.authorAnswerAdded(aa,this);
		return aa;
	}
	,addNewAuthorAnswer: function(value) {
		var aa = com.wiris.quizzes.impl.AuthorAnswerImpl.newWithQuestionCallback(this.question,this);
		value = com.wiris.util.xml.MathMLUtils.convertEditor2Newlines(value);
		aa.value.set(value);
		return this.addAuthorAnswerImpl(aa);
	}
	,getAuthorAnswers: function() {
		var aa = new Array();
		aa = this.authorAnswers.slice();
		return aa;
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.SlotImpl();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.SlotImpl.TAGNAME);
		this.id = s.attributeString(com.wiris.quizzes.impl.SlotImpl.ATTRIBUTE_ID,this.id,"0");
		this.localData = s.serializeArrayName(this.localData,com.wiris.quizzes.impl.SlotImpl.LOCALDATA_TAGNAME);
		this.initialContent = s.serializeChildName(this.initialContent,com.wiris.quizzes.impl.InitialContent.TAGNAME);
		s.endTag();
	}
	,copyData: function(slotModel,copyAuthorAnswers) {
		var slot = slotModel;
		this.setInitialContent(slot.getInitialContent());
		this.syntax.importAssertionNameAndParams(slot.syntax.copy());
		if(slot.localData != null) {
			this.localData = new Array();
			var ldArray = slot.localData;
			var _g = 0;
			while(_g < ldArray.length) {
				var ld = ldArray[_g];
				++_g;
				this.setLocalData(ld.name,ld.value);
			}
		}
		var authorAnswers = slot.authorAnswers;
		if(copyAuthorAnswers && authorAnswers != null) {
			var _g = 0;
			while(_g < authorAnswers.length) {
				var aa = authorAnswers[_g];
				++_g;
				var aaClone = com.wiris.quizzes.impl.AuthorAnswerImpl.newWithQuestionCallback(this.question,this);
				aaClone.copy(aa);
				this.addAuthorAnswerImpl(aaClone);
			}
		}
	}
	,copy: function(slotModel) {
		this.copyData(slotModel,false);
		return this;
	}
	,question: null
	,localData: null
	,initialContent: null
	,authorAnswers: null
	,syntax: null
	,id: null
	,__class__: com.wiris.quizzes.impl.SlotImpl
});
com.wiris.quizzes.impl.Strings = $hxClasses["com.wiris.quizzes.impl.Strings"] = function() { }
com.wiris.quizzes.impl.Strings.__name__ = ["com","wiris","quizzes","impl","Strings"];
com.wiris.quizzes.impl.SyntaxAssertion = $hxClasses["com.wiris.quizzes.impl.SyntaxAssertion"] = function() {
	com.wiris.quizzes.impl.Assertion.call(this);
};
com.wiris.quizzes.impl.SyntaxAssertion.__name__ = ["com","wiris","quizzes","impl","SyntaxAssertion"];
com.wiris.quizzes.impl.SyntaxAssertion.__interfaces__ = [com.wiris.quizzes.api.assertion.Syntax];
com.wiris.quizzes.impl.SyntaxAssertion.fromAssertion = function(a) {
	var s = new com.wiris.quizzes.impl.SyntaxAssertion();
	s.correctAnswer = a.correctAnswer;
	s.answer = a.answer;
	s.parameters = a.parameters;
	s.name = com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxName2String(com.wiris.quizzes.impl.QuizzesEnumUtils.string2SyntaxName(a.name));
	return s;
}
com.wiris.quizzes.impl.SyntaxAssertion.getDefaultAnswerFieldType = function(name) {
	if(name == com.wiris.quizzes.api.assertion.SyntaxName.MATH) return com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_MATH_EDITOR;
	return com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD;
}
com.wiris.quizzes.impl.SyntaxAssertion.getDefaultSyntax = function() {
	var s = new com.wiris.quizzes.impl.SyntaxAssertion();
	s.setName(com.wiris.quizzes.api.assertion.SyntaxName.MATH);
	s.setParameter(com.wiris.quizzes.api.assertion.SyntaxParameterName.DECIMAL_SEPARATORS,".,'");
	return s;
}
com.wiris.quizzes.impl.SyntaxAssertion.__super__ = com.wiris.quizzes.impl.Assertion;
com.wiris.quizzes.impl.SyntaxAssertion.prototype = $extend(com.wiris.quizzes.impl.Assertion.prototype,{
	removeParameter: function(name) {
		var value = this.getParameter(name);
		this.removeParam(com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterName2String(name));
		return value;
	}
	,getParameter: function(name) {
		return this.getParam(com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterName2String(name));
	}
	,setParameter: function(name,value) {
		this.setParam(com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxParameterName2String(name),value);
	}
	,setName: function(name) {
		this.name = com.wiris.quizzes.impl.QuizzesEnumUtils.syntaxName2String(name);
	}
	,getName: function() {
		return com.wiris.quizzes.impl.QuizzesEnumUtils.string2SyntaxName(this.name);
	}
	,__class__: com.wiris.quizzes.impl.SyntaxAssertion
});
com.wiris.quizzes.impl.TranslationNameChange = $hxClasses["com.wiris.quizzes.impl.TranslationNameChange"] = function() {
	com.wiris.util.xml.SerializableImpl.call(this);
};
com.wiris.quizzes.impl.TranslationNameChange.__name__ = ["com","wiris","quizzes","impl","TranslationNameChange"];
com.wiris.quizzes.impl.TranslationNameChange.__super__ = com.wiris.util.xml.SerializableImpl;
com.wiris.quizzes.impl.TranslationNameChange.prototype = $extend(com.wiris.util.xml.SerializableImpl.prototype,{
	newInstance: function() {
		return new com.wiris.quizzes.impl.TranslationNameChange();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.TranslationNameChange.tagName);
		this.newname = s.attributeString("new",this.newname,null);
		this.oldname = s.attributeString("old",this.oldname,null);
		s.endTag();
	}
	,newname: null
	,oldname: null
	,__class__: com.wiris.quizzes.impl.TranslationNameChange
});
com.wiris.quizzes.impl.UserData = $hxClasses["com.wiris.quizzes.impl.UserData"] = function() {
	com.wiris.util.xml.SerializableImpl.call(this);
	this.randomSeed = -1;
};
com.wiris.quizzes.impl.UserData.__name__ = ["com","wiris","quizzes","impl","UserData"];
com.wiris.quizzes.impl.UserData.__super__ = com.wiris.util.xml.SerializableImpl;
com.wiris.quizzes.impl.UserData.prototype = $extend(com.wiris.util.xml.SerializableImpl.prototype,{
	setParameter: function(name,value) {
		if(!new com.wiris.quizzes.impl.HTMLTools().isQuizzesIdentifier(name)) throw "Invalid parameter \"name\".";
		if(this.parameters == null) this.parameters = new Array();
		var i;
		var _g1 = 0, _g = this.parameters.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(this.parameters[i1].name == name) HxOverrides.remove(this.parameters,this.parameters[i1]);
		}
		if(value != null && !(value == "")) {
			var p = new com.wiris.quizzes.impl.Parameter();
			p.name = name;
			p.set(value);
			this.parameters.push(p);
		}
	}
	,ensureAnswerPlace: function(index) {
		if(index < 0) throw "Invalid index: " + index;
		if(this.answers == null) this.answers = new Array();
		while(this.answers.length <= index) this.answers.push(new com.wiris.quizzes.impl.Answer());
	}
	,getUserCompoundAnswer: function(index,compoundindex) {
		var a = this.answers[index];
		var compound = com.wiris.quizzes.impl.CompoundAnswerParser.parseCompoundAnswer(a);
		return compound[compoundindex][1];
	}
	,setUserCompoundAnswer: function(index,compoundindex,content) {
		this.ensureAnswerPlace(index);
		if(compoundindex < 0) throw "Invalid compound index: " + compoundindex;
		var a = this.answers[index];
		a.id = "" + index;
		var compound;
		if(a.content == null || a.content.length == 0) compound = new Array(); else compound = com.wiris.quizzes.impl.CompoundAnswerParser.parseCompoundAnswer(a);
		var i = compound.length;
		while(i <= compoundindex) {
			compound[i] = ["<math><mo>=</mo></math>","<math></math>"];
			i++;
		}
		if(com.wiris.quizzes.impl.MathContent.getMathType(content) == com.wiris.quizzes.impl.MathContent.TYPE_TEXT) content = new com.wiris.quizzes.impl.HTMLTools().textToMathML(content);
		compound[compoundindex][1] = content;
		var m = com.wiris.quizzes.impl.CompoundAnswerParser.joinCompoundAnswer(compound);
		a.type = m.type;
		a.content = m.content;
	}
	,setUserAnswer: function(index,content) {
		this.ensureAnswerPlace(index);
		var a = this.answers[index];
		a.id = "" + index;
		a.set(content);
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.UserData();
	}
	,onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.UserData.TAGNAME);
		this.randomSeed = s.childInt("randomSeed",this.randomSeed,-1);
		this.answers = s.serializeArrayName(this.answers,"answers");
		this.parameters = s.serializeArrayName(this.parameters,"parameters");
		s.endTag();
	}
	,parameters: null
	,answers: null
	,randomSeed: null
	,__class__: com.wiris.quizzes.impl.UserData
});
com.wiris.quizzes.impl.ValidationAssertion = $hxClasses["com.wiris.quizzes.impl.ValidationAssertion"] = function() {
	com.wiris.quizzes.impl.Assertion.call(this);
};
com.wiris.quizzes.impl.ValidationAssertion.__name__ = ["com","wiris","quizzes","impl","ValidationAssertion"];
com.wiris.quizzes.impl.ValidationAssertion.__interfaces__ = [com.wiris.quizzes.api.assertion.Validation];
com.wiris.quizzes.impl.ValidationAssertion.fromAssertion = function(a) {
	var v = new com.wiris.quizzes.impl.ValidationAssertion();
	v.correctAnswer = a.correctAnswer;
	v.answer = a.answer;
	v.parameters = a.parameters;
	v.name = com.wiris.quizzes.impl.QuizzesEnumUtils.validationName2String(com.wiris.quizzes.impl.QuizzesEnumUtils.string2ValidationName(a.name));
	return v;
}
com.wiris.quizzes.impl.ValidationAssertion.__super__ = com.wiris.quizzes.impl.Assertion;
com.wiris.quizzes.impl.ValidationAssertion.prototype = $extend(com.wiris.quizzes.impl.Assertion.prototype,{
	removeParameter: function(name) {
		var value = this.getParameter(name);
		this.removeParam(com.wiris.quizzes.impl.QuizzesEnumUtils.validationParameterName2String(name));
		return value;
	}
	,getParameter: function(name) {
		return this.getParam(com.wiris.quizzes.impl.QuizzesEnumUtils.validationParameterName2String(name));
	}
	,setParameter: function(name,value) {
		this.setParam(com.wiris.quizzes.impl.QuizzesEnumUtils.validationParameterName2String(name),value);
	}
	,setName: function(name) {
		this.name = com.wiris.quizzes.impl.QuizzesEnumUtils.validationName2String(name);
	}
	,getName: function() {
		return com.wiris.quizzes.impl.QuizzesEnumUtils.string2ValidationName(this.name);
	}
	,__class__: com.wiris.quizzes.impl.ValidationAssertion
});
com.wiris.quizzes.impl.Variable = $hxClasses["com.wiris.quizzes.impl.Variable"] = function() {
	com.wiris.quizzes.impl.MathContent.call(this);
};
com.wiris.quizzes.impl.Variable.__name__ = ["com","wiris","quizzes","impl","Variable"];
com.wiris.quizzes.impl.Variable.__super__ = com.wiris.quizzes.impl.MathContent;
com.wiris.quizzes.impl.Variable.prototype = $extend(com.wiris.quizzes.impl.MathContent.prototype,{
	onSerialize: function(s) {
		s.beginTag(com.wiris.quizzes.impl.Variable.tagName);
		this.name = s.attributeString("name",this.name,null);
		this.onSerializeInner(s);
		s.endTag();
	}
	,newInstance: function() {
		return new com.wiris.quizzes.impl.Variable();
	}
	,name: null
	,__class__: com.wiris.quizzes.impl.Variable
});
com.wiris.util.ui.component.Component = $hxClasses["com.wiris.util.ui.component.Component"] = function() {
	this.element = null;
	this.id = "";
	this.applicationClass = null;
	this.componentBuilder = null;
	this.visible = true;
	this.enabled = true;
	this.draggable = false;
	this.parent = null;
	this.childIndex = -1;
	this.classes = new Array();
	this.classes.push(com.wiris.util.ui.component.Component.CLASS_COMPONENT);
	this.style = new com.wiris.util.ui.Style(this);
	this.componentStateManager = new com.wiris.util.ui.component.ComponentStateManager(this);
	this.resetListeners();
	this.addFocusListener(this.componentStateManager);
	this.addKeyListener(this.componentStateManager);
	this.addMouseListener(this.componentStateManager);
	this.addTouchListener(this.componentStateManager);
};
com.wiris.util.ui.component.Component.__name__ = ["com","wiris","util","ui","component","Component"];
com.wiris.util.ui.component.Component.prototype = {
	fireTouchEvent: function(listener,e,touchEventType) {
		if(listener == null) return;
		if(com.wiris.util.ui.interaction.EventType.TOUCH_EVENT_MOVE == touchEventType) listener.touchMove(e); else if(com.wiris.util.ui.interaction.EventType.TOUCH_EVENT_PRESS == touchEventType) listener.touchPress(e); else if(com.wiris.util.ui.interaction.EventType.TOUCH_EVENT_RELEASE == touchEventType) listener.touchRelease(e);
	}
	,fireMouseMotionEvent: function(listener,e) {
		if(listener == null) return;
		listener.mouseMove(e);
	}
	,fireMouseEvent: function(listener,e,mouseEventType) {
		if(listener == null) return;
		if(com.wiris.util.ui.interaction.EventType.MOUSE_EVENT_CLICK == mouseEventType) listener.mouseClick(e); else if(com.wiris.util.ui.interaction.EventType.MOUSE_EVENT_DOUBLE_CLICK == mouseEventType) listener.mouseDoubleClick(e); else if(com.wiris.util.ui.interaction.EventType.MOUSE_EVENT_ENTER == mouseEventType) listener.mouseEnter(e); else if(com.wiris.util.ui.interaction.EventType.MOUSE_EVENT_EXIT == mouseEventType) listener.mouseExit(e); else if(com.wiris.util.ui.interaction.EventType.MOUSE_EVENT_PRESS == mouseEventType) listener.mousePress(e); else if(com.wiris.util.ui.interaction.EventType.MOUSE_EVENT_RELEASE == mouseEventType) listener.mouseRelease(e);
	}
	,fireKeyEvent: function(listener,e,keyEventType) {
		if(listener == null) return;
		if(com.wiris.util.ui.interaction.EventType.KEY_EVENT_KEY_PRESS == keyEventType) listener.keyPress(e); else if(com.wiris.util.ui.interaction.EventType.KEY_EVENT_KEY_RELEASE == keyEventType) listener.keyRelease(e); else if(com.wiris.util.ui.interaction.EventType.KEY_EVENT_KEY_TYPE == keyEventType) listener.keyType(e);
	}
	,fireFocusEvent: function(listener,e,focusEventType) {
		if(listener == null) return;
		if(com.wiris.util.ui.interaction.EventType.FOCUS_EVENT_FOCUS_GAINED == focusEventType) listener.focusGained(e); else if(com.wiris.util.ui.interaction.EventType.FOCUS_EVENT_FOCUS_LOST == focusEventType) listener.focusLost(e);
	}
	,fireDragAndDropEvent: function(listener,e,dragAndDropEventType) {
		if(listener == null) return;
		if(com.wiris.util.ui.interaction.EventType.DRAG_AND_DROP_EVENT_DRAG == dragAndDropEventType) listener.drag(e); else if(com.wiris.util.ui.interaction.EventType.DRAG_AND_DROP_EVENT_ENTER == dragAndDropEventType) listener.dragEnter(e); else if(com.wiris.util.ui.interaction.EventType.DRAG_AND_DROP_EVENT_START == dragAndDropEventType) listener.dragStart(e); else if(com.wiris.util.ui.interaction.EventType.DRAG_AND_DROP_EVENT_DROP == dragAndDropEventType) listener.drop(e); else if(com.wiris.util.ui.interaction.EventType.DRAG_AND_DROP_EVENT_OVER == dragAndDropEventType) listener.dragOver(e); else if(com.wiris.util.ui.interaction.EventType.DRAG_AND_DROP_EVENT_END == dragAndDropEventType) listener.dragEnd(e);
	}
	,fireComponentEvent: function(listener,e,componentEventType) {
		if(listener == null) return;
		if(com.wiris.util.ui.interaction.EventType.COMPONENT_EVENT_DRAGGABLE_CHANGED == componentEventType) listener.draggableChanged(e); else if(com.wiris.util.ui.interaction.EventType.COMPONENT_EVENT_ENABLED_CHANGED == componentEventType) listener.enabledChanged(e); else if(com.wiris.util.ui.interaction.EventType.COMPONENT_EVENT_BLUR_REQUESTED == componentEventType) listener.blurRequested(e); else if(com.wiris.util.ui.interaction.EventType.COMPONENT_EVENT_FOCUS_REQUESTED == componentEventType) listener.focusRequested(e); else if(com.wiris.util.ui.interaction.EventType.COMPONENT_EVENT_STYLE_CHANGED == componentEventType) listener.styleChanged(e); else if(com.wiris.util.ui.interaction.EventType.COMPONENT_EVENT_VISIBILITY_CHANGED == componentEventType) listener.visibilityChanged(e);
	}
	,fireChangeEvent: function(listener,e) {
		if(listener == null) return;
		listener.stateChanged(e);
	}
	,fireActionEvent: function(listener,e) {
		if(listener == null) return;
		listener.actionPerformed(e);
	}
	,fireEvent: function(e) {
		var eventType = e.getEventType();
		if(com.wiris.util.ui.interaction.EventType.ACTION_EVENT == eventType) {
			var actionEvent = e;
			var i = HxOverrides.iter(this.actionListeners);
			this.actionListenersLocked = true;
			while(i.hasNext() && e.isPropagating()) this.fireActionEvent(i.next(),actionEvent);
			var _g = 0, _g1 = this.actionListenersToRemove;
			while(_g < _g1.length) {
				var l = _g1[_g];
				++_g;
				HxOverrides.remove(this.actionListeners,l);
			}
			var _g = 0, _g1 = this.actionListenersToAdd;
			while(_g < _g1.length) {
				var l = _g1[_g];
				++_g;
				this.actionListeners.push(l);
			}
			this.actionListenersToRemove = new Array();
			this.actionListenersToAdd = new Array();
			this.actionListenersLocked = false;
			i = HxOverrides.iter(this.defaultActionListeners);
			while(i.hasNext() && !e.defaultIsPrevented()) this.fireActionEvent(i.next(),actionEvent);
		} else if(com.wiris.util.ui.interaction.EventType.CHANGE_EVENT == eventType) {
			var changeEvent = e;
			var i = HxOverrides.iter(this.changeListeners);
			while(i.hasNext() && e.isPropagating()) this.fireChangeEvent(i.next(),changeEvent);
			i = HxOverrides.iter(this.defaultChangeListeners);
			while(i.hasNext() && !e.defaultIsPrevented()) this.fireChangeEvent(i.next(),changeEvent);
		} else if(com.wiris.util.ui.interaction.EventType.COMPONENT_EVENT == eventType) {
			var componentEvent = e;
			var componentEventType = componentEvent.getComponentEventType();
			var i = HxOverrides.iter(this.componentListeners);
			while(i.hasNext() && e.isPropagating()) this.fireComponentEvent(i.next(),componentEvent,componentEventType);
			i = HxOverrides.iter(this.defaultComponentListeners);
			while(i.hasNext() && !e.defaultIsPrevented()) this.fireComponentEvent(i.next(),componentEvent,componentEventType);
		} else if(com.wiris.util.ui.interaction.EventType.DRAG_AND_DROP_EVENT == eventType) {
			var dragAndDropEvent = e;
			var dragAndDropEventType = dragAndDropEvent.getDragAndDropEventType();
			var i = HxOverrides.iter(this.dragAndDropListeners);
			while(i.hasNext() && e.isPropagating()) this.fireDragAndDropEvent(i.next(),dragAndDropEvent,dragAndDropEventType);
			i = HxOverrides.iter(this.defaultDragAndDropListeners);
			while(i.hasNext() && !e.defaultIsPrevented()) this.fireDragAndDropEvent(i.next(),dragAndDropEvent,dragAndDropEventType);
		} else if(com.wiris.util.ui.interaction.EventType.FOCUS_EVENT == eventType) {
			var focusEvent = e;
			var focusEventType = focusEvent.getFocusEventType();
			var i = HxOverrides.iter(this.focusListeners);
			while(i.hasNext() && e.isPropagating()) this.fireFocusEvent(i.next(),focusEvent,focusEventType);
			i = HxOverrides.iter(this.defaultFocusListeners);
			while(i.hasNext() && !e.defaultIsPrevented()) this.fireFocusEvent(i.next(),focusEvent,focusEventType);
		} else if(com.wiris.util.ui.interaction.EventType.KEY_EVENT == eventType) {
			var keyEvent = e;
			var keyEventType = keyEvent.getKeyEventType();
			var i = HxOverrides.iter(this.keyListeners);
			while(i.hasNext() && e.isPropagating()) this.fireKeyEvent(i.next(),keyEvent,keyEventType);
			i = HxOverrides.iter(this.defaultKeyListeners);
			while(i.hasNext() && !e.defaultIsPrevented()) this.fireKeyEvent(i.next(),keyEvent,keyEventType);
		} else if(com.wiris.util.ui.interaction.EventType.MOUSE_EVENT == eventType) {
			var mouseEvent = e;
			var mouseEventType = mouseEvent.getMouseEventType();
			var i = HxOverrides.iter(this.mouseListeners);
			while(i.hasNext() && e.isPropagating()) this.fireMouseEvent(i.next(),mouseEvent,mouseEventType);
			i = HxOverrides.iter(this.defaultMouseListeners);
			while(i.hasNext() && !e.defaultIsPrevented()) this.fireMouseEvent(i.next(),mouseEvent,mouseEventType);
		} else if(com.wiris.util.ui.interaction.EventType.MOUSE_MOTION_EVENT == eventType) {
			var mouseMotionEvent = e;
			var i = HxOverrides.iter(this.mouseMotionListeners);
			while(i.hasNext() && e.isPropagating()) this.fireMouseMotionEvent(i.next(),mouseMotionEvent);
			i = HxOverrides.iter(this.defaultMouseMotionListeners);
			while(i.hasNext() && !e.defaultIsPrevented()) this.fireMouseMotionEvent(i.next(),mouseMotionEvent);
		} else if(com.wiris.util.ui.interaction.EventType.TOUCH_EVENT == eventType) {
			var touchEvent = e;
			var touchEventType = touchEvent.getTouchEventType();
			var i = HxOverrides.iter(this.touchListeners);
			while(i.hasNext() && e.isPropagating()) this.fireTouchEvent(i.next(),touchEvent,touchEventType);
			i = HxOverrides.iter(this.defaultTouchListeners);
			while(i.hasNext() && !e.defaultIsPrevented()) this.fireTouchEvent(i.next(),touchEvent,touchEventType);
		}
	}
	,changeStyle: function() {
		this.fireEvent(com.wiris.util.ui.interaction.GenericEvent.createComponentEvent(this,com.wiris.util.ui.interaction.EventType.COMPONENT_EVENT_STYLE_CHANGED));
	}
	,changeState: function() {
		this.fireEvent(com.wiris.util.ui.interaction.GenericEvent.createChangeEvent(this));
	}
	,performAction: function(action) {
		this.fireEvent(com.wiris.util.ui.interaction.GenericEvent.createActionEvent(this,action));
	}
	,addDefaultDragAndDropListener: function(listener) {
		this.defaultDragAndDropListeners.push(listener);
		return this;
	}
	,removeDefaultKeyListener: function(listener) {
		HxOverrides.remove(this.defaultKeyListeners,listener);
		return this;
	}
	,addDefaultKeyListener: function(listener) {
		this.defaultKeyListeners.push(listener);
		return this;
	}
	,addDefaultFocusListener: function(listener) {
		this.defaultFocusListeners.push(listener);
		return this;
	}
	,addDefaultTouchListener: function(listener) {
		this.defaultTouchListeners.push(listener);
		return this;
	}
	,addDefaultMouseMotionListener: function(listener) {
		this.defaultMouseMotionListeners.push(listener);
		return this;
	}
	,removeDefaultMouseListener: function(listener) {
		HxOverrides.remove(this.defaultMouseListeners,listener);
		return this;
	}
	,addDefaultMouseListener: function(listener) {
		this.defaultMouseListeners.push(listener);
		return this;
	}
	,addDefaultChangeListener: function(listener) {
		this.defaultChangeListeners.push(listener);
		return this;
	}
	,addDefaultActionListener: function(listener) {
		this.defaultActionListeners.push(listener);
		return this;
	}
	,removeDefaultComponentListener: function(listener) {
		HxOverrides.remove(this.defaultComponentListeners,listener);
		return this;
	}
	,isDefaultComponentListener: function(listener) {
		return com.wiris.system.ArrayEx.contains(this.defaultComponentListeners,listener);
	}
	,addDefaultComponentListener: function(listener) {
		this.defaultComponentListeners.push(listener);
		return this;
	}
	,removeDragAndDropListener: function(listener) {
		HxOverrides.remove(this.dragAndDropListeners,listener);
		return this;
	}
	,addDragAndDropListener: function(listener) {
		this.dragAndDropListeners.push(listener);
		return this;
	}
	,removeKeyListener: function(listener) {
		HxOverrides.remove(this.keyListeners,listener);
		return this;
	}
	,addKeyListener: function(listener) {
		this.keyListeners.push(listener);
		return this;
	}
	,removeFocusListener: function(listener) {
		HxOverrides.remove(this.focusListeners,listener);
		return this;
	}
	,addFocusListener: function(listener) {
		this.focusListeners.push(listener);
		return this;
	}
	,removeTouchListener: function(listener) {
		HxOverrides.remove(this.touchListeners,listener);
		return this;
	}
	,addTouchListener: function(listener) {
		this.touchListeners.push(listener);
		return this;
	}
	,removeMouseMotionListener: function(listener) {
		HxOverrides.remove(this.mouseMotionListeners,listener);
		return this;
	}
	,addMouseMotionListener: function(listener) {
		this.mouseMotionListeners.push(listener);
		return this;
	}
	,removeMouseListener: function(listener) {
		HxOverrides.remove(this.mouseListeners,listener);
		return this;
	}
	,addMouseListener: function(listener) {
		this.mouseListeners.push(listener);
		return this;
	}
	,removeChangeListener: function(listener) {
		HxOverrides.remove(this.changeListeners,listener);
		return this;
	}
	,addChangeListener: function(listener) {
		this.changeListeners.push(listener);
		return this;
	}
	,removeActionListener: function(listener) {
		if(this.actionListenersLocked) this.actionListenersToRemove.push(listener); else HxOverrides.remove(this.actionListeners,listener);
		return this;
	}
	,isActionListener: function(listener) {
		if(this.actionListenersLocked) return com.wiris.system.ArrayEx.contains(this.actionListeners,listener) && !com.wiris.system.ArrayEx.contains(this.actionListenersToRemove,listener) || com.wiris.system.ArrayEx.contains(this.actionListenersToAdd,listener); else return com.wiris.system.ArrayEx.contains(this.actionListeners,listener);
	}
	,addActionListener: function(listener) {
		if(this.actionListenersLocked) this.actionListenersToAdd.push(listener); else this.actionListeners.push(listener);
		return this;
	}
	,removeComponentListener: function(listener) {
		HxOverrides.remove(this.componentListeners,listener);
		return this;
	}
	,isComponentListener: function(listener) {
		return com.wiris.system.ArrayEx.contains(this.componentListeners,listener);
	}
	,addComponentListener: function(listener) {
		this.componentListeners.push(listener);
		return this;
	}
	,setKeyScrollingEnabled: function(keyScrollingEnabled) {
		this.keyScrollingEnabled = keyScrollingEnabled;
	}
	,isKeyScrollingEnabled: function() {
		return this.keyScrollingEnabled;
	}
	,getTabIndex: function() {
		return this.tabindex;
	}
	,setTabIndex: function(index) {
		this.tabindex = index;
	}
	,getComputedStyle: function() {
		return this.computedStyle;
	}
	,setComputedStyle: function(computedStyle) {
		this.computedStyle = computedStyle;
		return this;
	}
	,getStyle: function() {
		return this.style;
	}
	,setStyle: function(style) {
		this.style = style;
		this.changeStyle();
		return this;
	}
	,setApplicationClass: function(className) {
		if(this.applicationClass != null) this.removeClass(this.applicationClass);
		this.applicationClass = className;
		this.addClass(com.wiris.util.ui.component.Component.CLASS_APP);
		return this.addClass(className);
	}
	,removeClass: function(className) {
		if(this.hasClass(className)) {
			HxOverrides.remove(this.classes,className);
			this.changeStyle();
		}
		return this;
	}
	,addClass: function(className) {
		if(!this.hasClass(className)) {
			this.classes.push(className);
			this.changeStyle();
		}
		return this;
	}
	,hasClass: function(className) {
		return com.wiris.system.ArrayEx.contains(this.classes,className);
	}
	,getApplicationClass: function() {
		if(this.applicationClass == null) {
			if(this.getParent() != null) return this.getParent().getApplicationClass();
		}
		return this.applicationClass;
	}
	,getApplication: function() {
		if(this.applicationClass == null) {
			if(this.getParent() != null) return this.getParent().getApplication();
		}
		return this;
	}
	,getClasses: function() {
		return this.classes;
	}
	,activate: function() {
	}
	,requestBlur: function() {
		this.fireEvent(com.wiris.util.ui.interaction.GenericEvent.createComponentEvent(this,com.wiris.util.ui.interaction.EventType.COMPONENT_EVENT_BLUR_REQUESTED));
		return this;
	}
	,requestFocus: function() {
		this.fireEvent(com.wiris.util.ui.interaction.GenericEvent.createComponentEvent(this,com.wiris.util.ui.interaction.EventType.COMPONENT_EVENT_FOCUS_REQUESTED));
		return this;
	}
	,setDraggable: function(draggable) {
		if(this.draggable == draggable) return this;
		this.draggable = draggable;
		this.fireEvent(com.wiris.util.ui.interaction.GenericEvent.createComponentEvent(this,com.wiris.util.ui.interaction.EventType.COMPONENT_EVENT_DRAGGABLE_CHANGED));
		return this;
	}
	,setEnabled: function(enabled) {
		if(this.enabled == enabled) return this;
		this.enabled = enabled;
		this.fireEvent(com.wiris.util.ui.interaction.GenericEvent.createComponentEvent(this,com.wiris.util.ui.interaction.EventType.COMPONENT_EVENT_ENABLED_CHANGED));
		return this;
	}
	,setVisible: function(visible) {
		if(this.visible == visible) return this;
		this.visible = visible;
		if(visible) this.removeClass(com.wiris.util.ui.component.Component.CLASS_HIDDEN); else this.addClass(com.wiris.util.ui.component.Component.CLASS_HIDDEN);
		this.fireEvent(com.wiris.util.ui.interaction.GenericEvent.createComponentEvent(this,com.wiris.util.ui.interaction.EventType.COMPONENT_EVENT_VISIBILITY_CHANGED));
		return this;
	}
	,hasFocus: function() {
		return this.componentStateManager.hasFocus();
	}
	,hasHover: function() {
		return this.componentStateManager.hasHover();
	}
	,isDraggable: function() {
		return this.draggable;
	}
	,isEnabled: function() {
		return this.enabled;
	}
	,isVisible: function() {
		return this.visible;
	}
	,setComponentBuilder: function(builder) {
		this.componentBuilder = builder;
	}
	,getComponentBuilder: function() {
		return this.componentBuilder;
	}
	,setElement: function(element) {
		this.element = element;
	}
	,getElement: function() {
		return this.element;
	}
	,setChildIndex: function(index) {
		this.childIndex = index;
	}
	,getChildIndex: function() {
		return this.childIndex;
	}
	,removeFromParent: function() {
		if(this.getParent() != null && js.Boot.__instanceof(this.getParent(),com.wiris.util.ui.component.Panel)) {
			var parent = this.getParent();
			parent.removeComponent(this.getChildIndex());
		}
		return this;
	}
	,setParent: function(parent) {
		this.parent = parent;
	}
	,getParent: function() {
		return this.parent;
	}
	,isChild: function(component) {
		return false;
	}
	,getComponentsByClassName: function(className) {
		var result = new Array();
		if(this.hasClass(className)) result.push(this);
		return result;
	}
	,getComponentById: function(id) {
		if(this.id == id) return this;
		return null;
	}
	,getHoveredComponent: function() {
		if(this.hasHover()) return this;
		return null;
	}
	,getChildren: function() {
		return null;
	}
	,setId: function(id) {
		this.id = id;
		this.changeStyle();
		return this;
	}
	,getId: function() {
		return this.id;
	}
	,resetListeners: function() {
		this.componentListeners = new Array();
		this.actionListeners = new Array();
		this.changeListeners = new Array();
		this.mouseListeners = new Array();
		this.mouseMotionListeners = new Array();
		this.touchListeners = new Array();
		this.focusListeners = new Array();
		this.keyListeners = new Array();
		this.dragAndDropListeners = new Array();
		this.defaultComponentListeners = new Array();
		this.defaultActionListeners = new Array();
		this.defaultChangeListeners = new Array();
		this.defaultMouseListeners = new Array();
		this.defaultMouseMotionListeners = new Array();
		this.defaultTouchListeners = new Array();
		this.defaultFocusListeners = new Array();
		this.defaultKeyListeners = new Array();
		this.defaultDragAndDropListeners = new Array();
		this.actionListenersLocked = false;
		this.actionListenersToRemove = new Array();
		this.actionListenersToAdd = new Array();
	}
	,actionListenersToAdd: null
	,actionListenersToRemove: null
	,actionListenersLocked: null
	,defaultDragAndDropListeners: null
	,defaultKeyListeners: null
	,defaultFocusListeners: null
	,defaultTouchListeners: null
	,defaultMouseMotionListeners: null
	,defaultMouseListeners: null
	,defaultChangeListeners: null
	,defaultActionListeners: null
	,defaultComponentListeners: null
	,dragAndDropListeners: null
	,keyListeners: null
	,focusListeners: null
	,touchListeners: null
	,mouseMotionListeners: null
	,mouseListeners: null
	,changeListeners: null
	,actionListeners: null
	,componentListeners: null
	,componentStateManager: null
	,keyScrollingEnabled: null
	,computedStyle: null
	,style: null
	,classes: null
	,childIndex: null
	,parent: null
	,tabindex: null
	,draggable: null
	,enabled: null
	,visible: null
	,componentBuilder: null
	,applicationClass: null
	,id: null
	,element: null
	,__class__: com.wiris.util.ui.component.Component
}
com.wiris.util.ui.component.Panel = $hxClasses["com.wiris.util.ui.component.Panel"] = function() {
	com.wiris.util.ui.component.Component.call(this);
	this.getStyle().setCSSVariable("--indentation-level","0");
	this.components = new Array();
	this.componentTreeListeners = new Array();
	this.defaultComponentTreeListeners = new Array();
	this.addClass(com.wiris.util.ui.component.Panel.CLASS_PANEL);
};
com.wiris.util.ui.component.Panel.__name__ = ["com","wiris","util","ui","component","Panel"];
com.wiris.util.ui.component.Panel.__super__ = com.wiris.util.ui.component.Component;
com.wiris.util.ui.component.Panel.prototype = $extend(com.wiris.util.ui.component.Component.prototype,{
	setChildrenEnabled: function(enabled) {
		var i = HxOverrides.iter(this.getComponents());
		while(i.hasNext()) {
			var child = i.next();
			child.setEnabled(enabled);
			if(js.Boot.__instanceof(child,com.wiris.util.ui.component.Panel)) child.setChildrenEnabled(enabled);
		}
	}
	,getIndentationLevel: function() {
		return Std.parseInt(this.getStyle().getCSSVariable("--indentation-level"));
	}
	,setIndentationLevel: function(level) {
		this.getStyle().setCSSVariable("--indentation-level",level + "");
	}
	,removeAllComponents: function() {
		var n = this.components.length;
		while(n > 0) {
			this.removeComponent(0);
			--n;
		}
	}
	,removeComponent: function(index) {
		var component = this.components.splice(index,1)[0];
		component.setParent(null);
		component.setChildIndex(-1);
		this.fireEvent(com.wiris.util.ui.interaction.GenericEvent.createComponentTreeEvent(this,com.wiris.util.ui.interaction.EventType.COMPONENT_TREE_EVENT_CHILD_REMOVED,component,index,-1));
	}
	,moveComponent: function(index,destination) {
		if(index != destination) {
			var component = this.components.splice(index,1)[0];
			var newDestination = index < destination?destination - 1:destination;
			this.components.splice(newDestination,0,component);
			var i = Math.min(index,destination);
			var n = Math.max(index,destination);
			while(i <= n && i < this.components.length) {
				this.components[i].setChildIndex(i);
				++i;
			}
			this.fireEvent(com.wiris.util.ui.interaction.GenericEvent.createComponentTreeEvent(this,com.wiris.util.ui.interaction.EventType.COMPONENT_TREE_EVENT_CHILD_MOVED,component,index,destination));
		}
	}
	,insertComponentAtImpl: function(component,index) {
		var i = this.components.length - 1;
		while(i >= index) {
			this.components[i].setChildIndex(i + 1);
			--i;
		}
		this.components.splice(index,0,component);
		component.setParent(this);
		component.setChildIndex(index);
		this.fireEvent(com.wiris.util.ui.interaction.GenericEvent.createComponentTreeEvent(this,com.wiris.util.ui.interaction.EventType.COMPONENT_TREE_EVENT_CHILD_ADDED,component,index,-1));
	}
	,addComponentImpl: function(component) {
		this.components.push(component);
		component.setParent(this);
		component.setChildIndex(this.components.length - 1);
		this.fireEvent(com.wiris.util.ui.interaction.GenericEvent.createComponentTreeEvent(this,com.wiris.util.ui.interaction.EventType.COMPONENT_TREE_EVENT_CHILD_ADDED,component,this.components.length - 1,-1));
	}
	,fireComponentTreeEvent: function(listener,e,componentTreeEventType) {
		if(listener == null) return;
		if(com.wiris.util.ui.interaction.EventType.COMPONENT_TREE_EVENT_CHILD_ADDED == componentTreeEventType) listener.childAdded(e); else if(com.wiris.util.ui.interaction.EventType.COMPONENT_TREE_EVENT_CHILD_MOVED == componentTreeEventType) listener.childMoved(e); else if(com.wiris.util.ui.interaction.EventType.COMPONENT_TREE_EVENT_CHILD_REMOVED == componentTreeEventType) listener.childRemoved(e);
	}
	,fireEvent: function(e) {
		var eventType = e.getEventType();
		if(com.wiris.util.ui.interaction.EventType.COMPONENT_TREE_EVENT == eventType) {
			var componentTreeEvent = e;
			var componentTreeEventType = componentTreeEvent.getComponentTreeEventType();
			var i = HxOverrides.iter(this.componentTreeListeners);
			while(i.hasNext() && e.isPropagating()) this.fireComponentTreeEvent(i.next(),componentTreeEvent,componentTreeEventType);
			i = HxOverrides.iter(this.defaultComponentTreeListeners);
			while(i.hasNext() && !e.defaultIsPrevented()) this.fireComponentTreeEvent(i.next(),componentTreeEvent,componentTreeEventType);
		} else com.wiris.util.ui.component.Component.prototype.fireEvent.call(this,e);
	}
	,addDefaultComponentTreeListener: function(listener) {
		this.defaultComponentTreeListeners.push(listener);
		return this;
	}
	,removeComponentTreeListener: function(listener) {
		HxOverrides.remove(this.componentTreeListeners,listener);
		return this;
	}
	,addComponentTreeListener: function(listener) {
		this.componentTreeListeners.push(listener);
		return this;
	}
	,getComponentsByClassName: function(className) {
		var result = com.wiris.util.ui.component.Component.prototype.getComponentsByClassName.call(this,className);
		var i = HxOverrides.iter(this.components);
		while(i.hasNext()) {
			var component = i.next();
			var partialResult = component.getComponentsByClassName(className);
			var j = HxOverrides.iter(partialResult);
			while(j.hasNext()) result.push(j.next());
		}
		return result;
	}
	,isChild: function(component) {
		if(com.wiris.system.ArrayEx.contains(this.components,component)) return true;
		var i = HxOverrides.iter(this.components);
		while(i.hasNext()) {
			var candidate = i.next();
			if(candidate.isChild(component)) return true;
		}
		return false;
	}
	,getComponentById: function(id) {
		var i = HxOverrides.iter(this.components);
		while(i.hasNext()) {
			var component = i.next().getComponentById(id);
			if(component != null) return component;
		}
		return com.wiris.util.ui.component.Component.prototype.getComponentById.call(this,id);
	}
	,getHoveredComponent: function() {
		var i = HxOverrides.iter(this.components);
		while(i.hasNext()) {
			var component = i.next().getHoveredComponent();
			if(component != null) return component;
		}
		return com.wiris.util.ui.component.Component.prototype.getHoveredComponent.call(this);
	}
	,getChildren: function() {
		return this.getComponents();
	}
	,getComponents: function() {
		return this.components;
	}
	,defaultComponentTreeListeners: null
	,componentTreeListeners: null
	,components: null
	,__class__: com.wiris.util.ui.component.Panel
});
com.wiris.util.ui.component.FlowPanel = $hxClasses["com.wiris.util.ui.component.FlowPanel"] = function(direction) {
	com.wiris.util.ui.component.Panel.call(this);
	this.addClass(com.wiris.util.ui.component.FlowPanel.CLASS_FLOW_PANEL).addClass(com.wiris.util.ui.component.FlowPanel.DIRECTION_CLASSES[direction]);
	this.direction = direction;
};
com.wiris.util.ui.component.FlowPanel.__name__ = ["com","wiris","util","ui","component","FlowPanel"];
com.wiris.util.ui.component.FlowPanel.newWithChild = function(direction,child) {
	var panel = new com.wiris.util.ui.component.FlowPanel(direction);
	panel.addComponent(child);
	return panel;
}
com.wiris.util.ui.component.FlowPanel.surroundWithBorder = function(child,borderSizeTop,borderSizeRight,borderSizeBottom,borderSizeLeft) {
	var panel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	panel.addComponent(child);
	panel.getStyle().setBorderSize(borderSizeTop,borderSizeRight,borderSizeBottom,borderSizeLeft);
	return panel;
}
com.wiris.util.ui.component.FlowPanel.__super__ = com.wiris.util.ui.component.Panel;
com.wiris.util.ui.component.FlowPanel.prototype = $extend(com.wiris.util.ui.component.Panel.prototype,{
	setDirection: function(direction) {
		this.removeClass(com.wiris.util.ui.component.FlowPanel.DIRECTION_CLASSES[this.direction]).addClass(com.wiris.util.ui.component.FlowPanel.DIRECTION_CLASSES[direction]);
		this.direction = direction;
	}
	,getDirection: function() {
		return this.direction;
	}
	,insertComponentAt: function(component,index) {
		this.insertComponentAtImpl(component,index);
	}
	,addComponent: function(component) {
		this.addComponentImpl(component);
	}
	,direction: null
	,__class__: com.wiris.util.ui.component.FlowPanel
});
com.wiris.quizzes.impl.ui.AnswerFeedbackImpl = $hxClasses["com.wiris.quizzes.impl.ui.AnswerFeedbackImpl"] = function(questionInstance,slot,authorAnswer,componentBuilder) {
	this.decorateAnswerField = true;
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.setApplicationClass(com.wiris.quizzes.impl.ui.AnswerFeedbackImpl.CLASS_QUIZZES_ANSWER_FEEDBACK).addClass(com.wiris.util.ui.component.Panel.CLASS_PANEL_SOLID);
	this.getStyle().setBackgroundColor(com.wiris.util.graphics.Color.fromARGB([0,0,0,0]));
	this.slot = slot;
	this.questionInstance = questionInstance;
	this.authorAnswer = authorAnswer;
	this.setComponentBuilder(componentBuilder);
	this.answerWeight = 1.0;
	this.embeddedComponent = null;
	this.answerFeedback = new com.wiris.quizzes.impl.ui.component.AnswerFeedbackComponent();
	this.answerFeedback.getStyle().setMargin(0,0,0,0);
	if(this.areQuestionObjectsNotNull()) this.answerFeedback.setPreviewAnswerFeedback(this.questionInstance,this.slot,this.authorAnswer);
	this.addComponent(this.answerFeedback);
};
com.wiris.quizzes.impl.ui.AnswerFeedbackImpl.__name__ = ["com","wiris","quizzes","impl","ui","AnswerFeedbackImpl"];
com.wiris.quizzes.impl.ui.AnswerFeedbackImpl.__interfaces__ = [com.wiris.quizzes.api.ui.AnswerFeedback];
com.wiris.quizzes.impl.ui.AnswerFeedbackImpl.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.quizzes.impl.ui.AnswerFeedbackImpl.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	getElement: function() {
		if(com.wiris.util.ui.component.FlowPanel.prototype.getElement.call(this) == null) this.getComponentBuilder().buildComponent(this,null);
		return com.wiris.util.ui.component.FlowPanel.prototype.getElement.call(this);
	}
	,getCompoundAnswerFeedback: function(answer) {
		return this.answerFeedback.getCompoundAnswerFeedback(answer);
	}
	,getCompoundGrade: function(index) {
		var grade = this.areQuestionObjectsNotNull()?this.questionInstance.getCompoundGrade(this.slot,this.authorAnswer,index):-1.0;
		return grade * this.answerWeight;
	}
	,getGrade: function() {
		var grade = this.areQuestionObjectsNotNull()?this.questionInstance.getGrade(this.slot,this.authorAnswer):-1.0;
		return grade * this.answerWeight;
	}
	,getFeedbackText: function() {
		return this.answerFeedback.getFeedbackText();
	}
	,setAnswerWeight: function(fraction) {
		this.answerWeight = fraction;
	}
	,isShowEmbeddedFeedback: function() {
		return this.answerFeedback.isShowFeedback();
	}
	,isShowFieldDecorationFeedback: function() {
		return this.decorateAnswerField;
	}
	,showFieldDecorationFeedback: function(visible) {
		this.decorateAnswerField = visible;
	}
	,showAssertionsFeedback: function(visible) {
		this.answerFeedback.showAssertionsFeedback(visible);
	}
	,showCorrectAnswerFeedback: function(visible) {
		this.answerFeedback.showCorrectAnswerFeedback(visible);
	}
	,removeEmbedded: function(component) {
		if(this.embeddedComponent != null && component == this.embeddedComponent) {
			this.embeddedComponent.setEmbeddedFeedback(null);
			this.embeddedComponent = null;
		}
	}
	,setEmbedded: function(component) {
		this.embeddedComponent = component;
		this.embeddedComponent.setEmbeddedFeedback(this);
	}
	,areQuestionObjectsNotNull: function() {
		return this.slot != null && this.authorAnswer != null && this.questionInstance != null;
	}
	,answerWeight: null
	,decorateAnswerField: null
	,answerFeedback: null
	,embeddedComponent: null
	,authorAnswer: null
	,slot: null
	,questionInstance: null
	,__class__: com.wiris.quizzes.impl.ui.AnswerFeedbackImpl
});
if(!com.wiris.quizzes.impl.ui.controller) com.wiris.quizzes.impl.ui.controller = {}
com.wiris.quizzes.impl.ui.controller.ReservedWordsConsumer = $hxClasses["com.wiris.quizzes.impl.ui.controller.ReservedWordsConsumer"] = function() { }
com.wiris.quizzes.impl.ui.controller.ReservedWordsConsumer.__name__ = ["com","wiris","quizzes","impl","ui","controller","ReservedWordsConsumer"];
com.wiris.quizzes.impl.ui.controller.ReservedWordsConsumer.prototype = {
	getGrammarUrl: null
	,setMathtypeParameters: null
	,__class__: com.wiris.quizzes.impl.ui.controller.ReservedWordsConsumer
}
if(!com.wiris.util.ui.interaction) com.wiris.util.ui.interaction = {}
com.wiris.util.ui.interaction.MouseListener = $hxClasses["com.wiris.util.ui.interaction.MouseListener"] = function() { }
com.wiris.util.ui.interaction.MouseListener.__name__ = ["com","wiris","util","ui","interaction","MouseListener"];
com.wiris.util.ui.interaction.MouseListener.prototype = {
	mouseExit: null
	,mouseEnter: null
	,mouseRelease: null
	,mousePress: null
	,mouseDoubleClick: null
	,mouseClick: null
	,__class__: com.wiris.util.ui.interaction.MouseListener
}
com.wiris.util.ui.interaction.ChangeListener = $hxClasses["com.wiris.util.ui.interaction.ChangeListener"] = function() { }
com.wiris.util.ui.interaction.ChangeListener.__name__ = ["com","wiris","util","ui","interaction","ChangeListener"];
com.wiris.util.ui.interaction.ChangeListener.prototype = {
	stateChanged: null
	,__class__: com.wiris.util.ui.interaction.ChangeListener
}
com.wiris.util.ui.interaction.ActionListener = $hxClasses["com.wiris.util.ui.interaction.ActionListener"] = function() { }
com.wiris.util.ui.interaction.ActionListener.__name__ = ["com","wiris","util","ui","interaction","ActionListener"];
com.wiris.util.ui.interaction.ActionListener.prototype = {
	actionPerformed: null
	,__class__: com.wiris.util.ui.interaction.ActionListener
}
com.wiris.quizzes.impl.ui.AnswerFieldImpl = $hxClasses["com.wiris.quizzes.impl.ui.AnswerFieldImpl"] = function(questionInstance,slot,componentBuilder) {
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.setApplicationClass(com.wiris.quizzes.impl.ui.AnswerFieldImpl.CLASS_QUIZZES_ANSWER_FIELD);
	this.getStyle().setBackgroundColor(com.wiris.util.graphics.Color.fromText("#00000000"));
	this.readOnly = false;
	this.component = null;
	this.questionInstance = questionInstance;
	this.slot = slot;
	this.setComponentBuilder(componentBuilder);
	this.fieldType = com.wiris.quizzes.impl.QuizzesEnumUtils.string2answerFieldType(slot.getProperty(com.wiris.quizzes.api.PropertyName.ANSWER_FIELD_TYPE));
	this.compoundAnswer = slot.getProperty(com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER);
	this.contextPanel = new com.wiris.util.ui.component.ContextPanel();
	this.contextPanel.addClass(com.wiris.quizzes.impl.ui.AnswerFieldImpl.CLASS_QUIZZES_ANSWER_FIELD_DIALOG);
	this.contextPanel.getStyle().setPadding(8,4,8,4);
	this.contextPanel.setParent(this);
	this.contextPanel.setVisible(false);
	this.contextPanel.setOpenAnimationMode(com.wiris.util.ui.component.ContextPanel.ANIMATION_MODE_NONE);
	this.quizzesFieldListeners = new Array();
};
com.wiris.quizzes.impl.ui.AnswerFieldImpl.__name__ = ["com","wiris","quizzes","impl","ui","AnswerFieldImpl"];
com.wiris.quizzes.impl.ui.AnswerFieldImpl.__interfaces__ = [com.wiris.quizzes.impl.ui.controller.ReservedWordsConsumer,com.wiris.util.ui.interaction.MouseListener,com.wiris.util.ui.interaction.ChangeListener,com.wiris.quizzes.api.ui.AnswerField,com.wiris.util.ui.interaction.ActionListener];
com.wiris.quizzes.impl.ui.AnswerFieldImpl.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.quizzes.impl.ui.AnswerFieldImpl.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	setTextInputSize: function(inputSize) {
		if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD || this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.POPUP_MATH_EDITOR) this.getComponent().setSize(inputSize);
	}
	,setEmbeddedAnswerFieldStyle: function(embedded) {
		if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD || this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.POPUP_MATH_EDITOR) {
			if(embedded) {
				this.addClass(com.wiris.quizzes.impl.ui.AnswerFieldImpl.CLASS_QUIZZES_EMBEDDED_ANSWER_FIELD).getStyle().setWidth(com.wiris.util.ui.Style.SIZE_AUTO).setMinWidth(com.wiris.util.ui.Style.SIZE_AUTO);
				var component = this.getComponent();
				component.addClass(com.wiris.util.ui.component.TextComponent.CLASS_TEXT_COMPONENT_OUTLINED).getStyle().setMinWidth(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD?50:75).setMinHeight(20).setWidth(com.wiris.util.ui.Style.SIZE_AUTO);
				if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.POPUP_MATH_EDITOR) {
					var popupTextField = component;
					popupTextField.getButton().getStyle().setWidth(23).setHeight(23);
				}
			}
		}
	}
	,mouseExit: function(e) {
		this.contextPanel.setVisible(false);
	}
	,mouseEnter: function(e) {
		if(this.embeddedFeedback != null && this.embeddedFeedback.isShowEmbeddedFeedback()) {
			if(this.getFieldType() != com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR && this.isCompoundAnswer() == com.wiris.quizzes.api.QuizzesConstants.PROPERTY_VALUE_COMPOUND_ANSWER_TRUE) {
				this.contextPanel.removeAllComponents();
				this.contextPanel.addComponent(this.embeddedFeedback.getCompoundAnswerFeedback(com.wiris.util.type.Arrays.indexOfElement(this.component.getComponents(),e.getSource())));
			}
			this.contextPanel.setVisible(true);
		}
	}
	,mouseRelease: function(e) {
	}
	,mousePress: function(e) {
	}
	,mouseDoubleClick: function(e) {
	}
	,mouseClick: function(e) {
	}
	,stateChanged: function(e) {
		this.setValue(e.getSource().getValue());
	}
	,answerChanged: function() {
		this.questionInstance.setSlotAnswer(this.slot,this.getValue());
		var _g = 0, _g1 = this.quizzesFieldListeners;
		while(_g < _g1.length) {
			var quizzesFieldListener = _g1[_g];
			++_g;
			quizzesFieldListener.contentChanged(this);
		}
	}
	,actionPerformed: function(e) {
		var action = e.getAction();
		var actionId = action.getId();
		if(actionId == com.wiris.quizzes.impl.ui.AnswerFieldImpl.STUDENT_ANSWER_CHANGED_ACTION_ID) {
			this.answerChanged();
			this.performAction(action);
		} else if(actionId == "contentChangeStarted") {
			var _g = 0, _g1 = this.quizzesFieldListeners;
			while(_g < _g1.length) {
				var quizzesFieldListener = _g1[_g];
				++_g;
				quizzesFieldListener.contentChangeStarted(this);
			}
		}
	}
	,getElement: function() {
		if(com.wiris.util.ui.component.FlowPanel.prototype.getElement.call(this) == null) {
			this.addComponent(this.getComponent());
			this.getComponentBuilder().buildComponent(this,this.getParent());
		}
		return com.wiris.util.ui.component.FlowPanel.prototype.getElement.call(this);
	}
	,setParent: function(parent) {
		com.wiris.util.ui.component.FlowPanel.prototype.setParent.call(this,parent);
		if(com.wiris.util.ui.component.FlowPanel.prototype.getElement.call(this) == null) this.addComponent(this.getComponent());
	}
	,setInitialContent: function(attempts) {
		if(this.slot.getInitialContent() != null) {
			var initialContent = this.slot.getInitialContent();
			var h = new com.wiris.quizzes.impl.HTMLTools();
			if(h.extractVariableNames(initialContent).length > 0) {
				initialContent = this.questionInstance.expandVariables(initialContent);
				if(h.extractVariableNames(initialContent).length > 0 && attempts < com.wiris.quizzes.impl.ui.AnswerFieldImpl.MAX_ATTEMPTS_TO_EXPAND_INITIAL_CONTENT_VARIABLES) {
					new com.wiris.quizzes.impl.ui.async.SetInitialContentTask(this,attempts);
					return;
				}
			}
			if(this.fieldType == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR) this.component.setInitialContent(initialContent,this.slot.getProperty(com.wiris.quizzes.api.PropertyName.GRAPH_LOCK_INITIAL_CONTENT) == "true"); else this.setValue(initialContent);
			this.answerChanged();
		}
	}
	,getMathtypeParameters: function(slot) {
		var p = new Hash();
		if(slot.getInitialContent() != null && slot.getInitialContent().indexOf(com.wiris.quizzes.impl.ui.controller.QuizzesStudioController.WRS_POSITIONABLE + "=\"false\"") != -1) p.set("detectHand","false");
		return p;
	}
	,setUpComponent: function() {
		this.component.addActionListener(this);
		this.component.addChangeListener(this);
		this.component.addMouseListener(this);
		if(this.questionInstance.getSlotAnswer(this.slot) != null && !(this.questionInstance.getSlotAnswer(this.slot) == "")) this.setValue(this.questionInstance.getSlotAnswer(this.slot)); else this.setInitialContent(0);
	}
	,reuseComponent: function(component) {
		var isAppropriateAnswerType = this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR && js.Boot.__instanceof(component,com.wiris.quizzes.impl.ui.component.GraphInputComponent) || this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_MATH_EDITOR && js.Boot.__instanceof(component,com.wiris.quizzes.impl.ui.component.MathTypeInputComponent) || this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.POPUP_MATH_EDITOR && js.Boot.__instanceof(component,com.wiris.quizzes.impl.ui.component.MathTypePopupTextField) || this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD && js.Boot.__instanceof(component,com.wiris.util.ui.component.TextField);
		if(!isAppropriateAnswerType) throw "The provided component does not fit the answer field type of the slot represented by this answer field";
		if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR) {
			this.component = component;
			this.component.resetListeners();
			var graphInputComponent = this.component;
			var graphMode = this.slot.getSyntax().getParameter(com.wiris.quizzes.api.assertion.SyntaxParameterName.GRAPH_MODE);
			graphInputComponent.setGraphMode(graphMode);
			var toolbarDef = this.slot.getProperty(com.wiris.quizzes.api.PropertyName.GRAPH_TOOLBAR);
			if(toolbarDef != null) graphInputComponent.updateGraphToolbar(com.wiris.util.ui.controller.ToolbarDefinition.deserialize(toolbarDef));
			graphInputComponent.setDisplaySetting(com.wiris.util.graphics.DisplaySettings.DISPLAY_ELEMENT_NAMES,this.slot.getProperty(com.wiris.quizzes.api.PropertyName.GRAPH_SHOW_NAME_IN_LABEL));
			graphInputComponent.setDisplaySetting(com.wiris.util.graphics.DisplaySettings.DISPLAY_ELEMENT_VALUES,this.slot.getProperty(com.wiris.quizzes.api.PropertyName.GRAPH_SHOW_VALUE_IN_LABEL));
			graphInputComponent.setReadOnly(this.readOnly);
			graphInputComponent.activateMainAction();
		} else throw "Component reusing is only implemented for Graph answer type in this version";
		this.setUpComponent();
	}
	,getComponent: function() {
		if(this.component == null) {
			if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR) {
				var stringDef = this.slot.getProperty(com.wiris.quizzes.api.PropertyName.GRAPH_TOOLBAR);
				var parameters = new Hash();
				if(this.slot.getSyntax().getParameter(com.wiris.quizzes.api.assertion.SyntaxParameterName.GRAPH_MODE) == "sketch") parameters.set(com.wiris.quizzes.impl.ui.component.GraphInputComponent.PARAM_GRAPH_MODE,"sketch"); else {
					parameters.set(com.wiris.quizzes.impl.ui.component.GraphInputComponent.PARAM_ALLOW_ANIMATIONS,"true");
					if(stringDef != null) parameters.set(com.wiris.quizzes.impl.ui.component.GraphInputComponent.PARAM_TOOLBAR_DEFINITION,stringDef);
				}
				var displaySettings = new Hash();
				displaySettings.set(com.wiris.util.graphics.DisplaySettings.DISPLAY_ELEMENT_NAMES,this.slot.getProperty(com.wiris.quizzes.api.PropertyName.GRAPH_SHOW_NAME_IN_LABEL));
				displaySettings.set(com.wiris.util.graphics.DisplaySettings.DISPLAY_ELEMENT_VALUES,this.slot.getProperty(com.wiris.quizzes.api.PropertyName.GRAPH_SHOW_VALUE_IN_LABEL));
				displaySettings.set(com.wiris.util.graphics.DisplaySettings.MAGNETIC_GRID,this.slot.getProperty(com.wiris.quizzes.api.PropertyName.GRAPH_MAGNETIC_GRID));
				parameters.set(com.wiris.quizzes.impl.ui.component.GraphInputComponent.PARAM_DEFAULT_DISPLAY_SETTINGS,com.wiris.util.json.JSon.encode(displaySettings));
				this.component = new com.wiris.quizzes.impl.ui.component.GraphInputComponent(parameters);
				this.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setMaxWidth(800).setHeight(494);
				this.component.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setMaxWidth(800).setHeight(494).setMargin(20,0,20,0);
				this.component.setChangeAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.AnswerFieldImpl.STUDENT_ANSWER_CHANGED_ACTION_ID,null));
				this.component.setReadOnly(this.readOnly);
			} else if(this.isCompoundAnswer() == com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_COMPOUND_ANSWER_TRUE) {
				if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD) this.component = new com.wiris.quizzes.impl.ui.component.QuizzesCompoundTextField(this.slot,this.questionInstance,this); else {
					this.component = new com.wiris.quizzes.impl.ui.component.QuizzesCompoundMathTypePopupTextField(this.slot,this.questionInstance,this,this.getMathtypeParameters(this.slot));
					this.component.setGrammarUrl(this.getGrammarUrl(),true);
					new com.wiris.quizzes.impl.ui.controller.ReservedWordsRequestController(this).update();
				}
				this.component.setReadOnly(this.readOnly);
			} else if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD) {
				this.component = new com.wiris.util.ui.component.TextField();
				this.component.getStyle().setWidth(280);
				this.component.setChangeAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.AnswerFieldImpl.STUDENT_ANSWER_CHANGED_ACTION_ID,null));
				this.component.setReadOnly(this.readOnly);
				if(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().isForceLTR()) this.component.addClass(com.wiris.util.ui.component.TextField.CLASS_FORCE_LTR);
			} else if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.POPUP_MATH_EDITOR) {
				this.component = new com.wiris.quizzes.impl.ui.component.MathTypePopupTextField(this.getMathtypeParameters(this.slot));
				this.component.setReadOnly(this.readOnly);
				this.component.setGrammarUrl(this.getGrammarUrl(),true);
				new com.wiris.quizzes.impl.ui.controller.ReservedWordsRequestController(this).update();
				this.component.setChangeAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.AnswerFieldImpl.STUDENT_ANSWER_CHANGED_ACTION_ID,null));
			} else if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_MATH_EDITOR) {
				this.component = new com.wiris.quizzes.impl.ui.component.MathTypeInputComponent(this.getMathtypeParameters(this.slot),true);
				this.component.getStyle().setMargin(0,0,5,0);
				this.component.setGrammarUrl(this.getGrammarUrl(),true);
				this.component.setReadOnly(this.readOnly);
				new com.wiris.quizzes.impl.ui.controller.ReservedWordsRequestController(this).update();
				this.component.setChangeAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.AnswerFieldImpl.STUDENT_ANSWER_CHANGED_ACTION_ID,null));
			}
			this.setUpComponent();
		}
		return this.component;
	}
	,isEmpty: function() {
		if(this.component == null) return true;
		if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR) return this.component.isEmpty(); else if(this.isCompoundAnswer() == com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_COMPOUND_ANSWER_TRUE) {
			if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD) return this.component.isEmpty(); else return this.component.isEmpty();
		} else if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD) return this.component.isEmpty(); else if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.POPUP_MATH_EDITOR) return this.component.isEmpty(); else if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_MATH_EDITOR) return this.component.isEmpty();
		return true;
	}
	,setGrammarUrl: function(grammarUrl,check) {
		if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_MATH_EDITOR) this.getComponent().setGrammarUrl(grammarUrl,check); else if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.POPUP_MATH_EDITOR) {
			if(this.isCompoundAnswer() == com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_COMPOUND_ANSWER_TRUE) this.getComponent().setGrammarUrl(grammarUrl,check); else this.getComponent().setGrammarUrl(grammarUrl,check);
		}
	}
	,getGrammarUrl: function() {
		var grammarUrl = this.slot.getGrammarUrl();
		grammarUrl += grammarUrl.indexOf("?") != -1?"&":"?";
		grammarUrl += "reservedWords=true&measureUnits=true&json=true";
		return grammarUrl;
	}
	,setMathtypeParameters: function(parameters) {
		if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_MATH_EDITOR) this.getComponent().setParameters(parameters); else if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.POPUP_MATH_EDITOR) {
			if(this.isCompoundAnswer() == com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_COMPOUND_ANSWER_TRUE) this.getComponent().setParameters(parameters); else this.getComponent().setParameters(parameters);
		}
	}
	,setReadOnly: function(readOnly) {
		this.readOnly = readOnly;
		if(this.component != null) {
			if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR) this.component.setReadOnly(readOnly); else if(this.isCompoundAnswer() == com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_COMPOUND_ANSWER_TRUE) {
				if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD) this.component.setReadOnly(readOnly); else this.component.setReadOnly(readOnly);
			} else if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD) this.component.setReadOnly(readOnly); else if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.POPUP_MATH_EDITOR) this.component.setReadOnly(readOnly); else if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_MATH_EDITOR) this.component.setReadOnly(readOnly);
		}
		if(this.readOnly) this.addClass(com.wiris.quizzes.impl.ui.AnswerFieldImpl.CLASS_READ_ONLY); else this.removeClass(com.wiris.quizzes.impl.ui.AnswerFieldImpl.CLASS_READ_ONLY);
	}
	,setGraphCustomToolbar: function(toolbar) {
		if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR) this.component.updateGraphToolbar(com.wiris.util.ui.controller.ToolbarDefinition.deserialize(toolbar));
	}
	,addQuizzesFieldListener: function(listener) {
		this.quizzesFieldListeners.push(listener);
	}
	,getContextPanel: function() {
		return this.contextPanel;
	}
	,setQuestionInstance: function(slot,questionInstance) {
		this.slot = slot;
		this.questionInstance = questionInstance;
		if(js.Boot.__instanceof(this.getComponent(),com.wiris.quizzes.impl.ui.component.QuizzesCompoundTextField)) this.getComponent().updateFields(slot,questionInstance);
		this.setInitialContent(0);
	}
	,getQuestionInstance: function() {
		return this.questionInstance;
	}
	,setValue: function(value) {
		if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD && !(this.isCompoundAnswer() == com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_COMPOUND_ANSWER_TRUE) && com.wiris.quizzes.impl.MathContent.getMathType(value) == com.wiris.quizzes.impl.MathContent.TYPE_MATHML) {
			var tools = new com.wiris.quizzes.impl.HTMLTools();
			value = tools.mathMLToText(value);
		}
		if(!(this.getComponent().getValue() == value)) this.getComponent().setValue(value);
		if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR && this.slot.getSyntax().getParameter(com.wiris.quizzes.api.assertion.SyntaxParameterName.GRAPH_MODE) == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_SKETCH) {
			var elementsToHandwriteInSlotParameter = new Array();
			var elementsToHandwrite = new Array();
			var parsedValue = com.wiris.util.geometry.GeometryFile.readJSON(value);
			var parsedValueElementsIds = new Array();
			var _g1 = 0, _g = parsedValue.getElementsLength();
			while(_g1 < _g) {
				var i = _g1++;
				parsedValueElementsIds.push(parsedValue.getElement(i).getId());
			}
			if(this.slot.getProperty(com.wiris.quizzes.api.PropertyName.ELEMENTS_TO_HANDWRITE) != null) {
				var o = com.wiris.util.json.JSon.decode(this.slot.getProperty(com.wiris.quizzes.api.PropertyName.ELEMENTS_TO_HANDWRITE));
				var a = com.wiris.util.json.JSon.getArray(o);
				var _g1 = 0, _g = a.length;
				while(_g1 < _g) {
					var i = _g1++;
					elementsToHandwriteInSlotParameter.push(a[i].toString());
				}
			}
			if(parsedValueElementsIds.length != 0 && elementsToHandwriteInSlotParameter.length != 0) {
				var _g1 = 0, _g = elementsToHandwriteInSlotParameter.length;
				while(_g1 < _g) {
					var i = _g1++;
					var _g3 = 0, _g2 = parsedValueElementsIds.length;
					while(_g3 < _g2) {
						var j = _g3++;
						var auxiliar = parsedValueElementsIds[j];
						if(elementsToHandwriteInSlotParameter[i] == auxiliar) elementsToHandwrite.push(elementsToHandwriteInSlotParameter[i]);
					}
				}
			}
			var initialContent = this.slot.getInitialContent();
			var parsedInitialContent = com.wiris.util.geometry.GeometryFile.readJSON(initialContent);
			var parsedInitialContentElementsIds = new Array();
			var _g1 = 0, _g = parsedInitialContent.getElementsLength();
			while(_g1 < _g) {
				var i = _g1++;
				parsedInitialContentElementsIds.push(parsedInitialContent.getElement(i).getId());
			}
			var diff = com.wiris.util.type.Arrays.difference(parsedValueElementsIds,parsedInitialContentElementsIds);
			var elementsToBeRemoved = com.wiris.util.type.Arrays.difference(diff,elementsToHandwrite);
			if(elementsToHandwrite.length > 0 || elementsToBeRemoved.length > 0) {
				var params = new Hash();
				params.set("elements",elementsToHandwrite);
				params.set("elementsToBeRemoved",elementsToBeRemoved);
				this.getComponent().actionWithParams("elementsToHandwriting",params);
				value = this.getComponent().getValue();
				this.answerChanged();
				this.performAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.AnswerFieldImpl.STUDENT_ANSWER_CHANGED_ACTION_ID,com.wiris.quizzes.impl.ui.AnswerFieldImpl.STUDENT_ANSWER_CHANGED_ACTION_ID));
				this.getComponent().activateMainAction();
			}
		}
		this.questionInstance.setSlotAnswer(this.slot,value);
		this.changeState();
	}
	,getValue: function() {
		return this.component != null?this.component.getValue():null;
	}
	,getAnswerFieldComponent: function(listener) {
		if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_MATH_EDITOR) this.getComponent().addInputComponentListener(new com.wiris.quizzes.impl.ui.async.InputComponentListenerWrapper(listener)); else if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR) this.getComponent().addInputComponentListener(new com.wiris.quizzes.impl.ui.async.InputComponentListenerWrapper(listener));
	}
	,setEditorInitialParams: function(parameters) {
		var parsedParameters = com.wiris.system.PropertiesTools.fromProperties(parameters);
		if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_MATH_EDITOR) this.getComponent().setParameters(parsedParameters); else if(this.getFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.POPUP_MATH_EDITOR) {
			if(this.isCompoundAnswer() == com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_COMPOUND_ANSWER_TRUE) this.getComponent().setParameters(parsedParameters); else this.getComponent().setParameters(parsedParameters);
		}
	}
	,isCompoundAnswer: function() {
		return this.compoundAnswer;
	}
	,getFieldType: function() {
		return this.fieldType;
	}
	,setEmbeddedFeedbackImpl: function() {
		if(!(this.isCompoundAnswer() == com.wiris.quizzes.api.QuizzesConstants.PROPERTY_VALUE_COMPOUND_ANSWER_TRUE)) this.contextPanel.addComponent(this.embeddedFeedback);
	}
	,decorateInputComponent: function(grade,component) {
		if(grade == 1.0) component.setStatus(com.wiris.util.ui.component.InputComponent.STATUS_CORRECT); else if(grade == 0.0) component.setStatus(com.wiris.util.ui.component.InputComponent.STATUS_ERROR); else if(grade == -1.0) component.setStatus(com.wiris.util.ui.component.InputComponent.STATUS_INDETERMINATE); else component.setStatus(com.wiris.util.ui.component.InputComponent.STATUS_WARNING);
	}
	,decorateField: function(feedback) {
		if(this.getFieldType() != com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR && this.isCompoundAnswer() == com.wiris.quizzes.api.QuizzesConstants.PROPERTY_VALUE_COMPOUND_ANSWER_TRUE) {
			var textFields = this.getComponent().getTextFields();
			var _g = 0;
			while(_g < textFields.length) {
				var textField = textFields[_g];
				++_g;
				var grade = feedback != null?feedback.getCompoundGrade(com.wiris.util.type.Arrays.indexOfElement(textFields,textField)):-1.0;
				this.decorateInputComponent(grade,textField);
			}
		} else {
			var grade = feedback != null?feedback.getGrade():-1.0;
			this.decorateInputComponent(grade,this.getComponent());
		}
	}
	,setEmbeddedFeedback: function(feedback) {
		this.contextPanel.removeAllComponents();
		this.decorateField(null);
		this.embeddedFeedback = feedback;
		if(feedback != null) {
			if(feedback.isShowFieldDecorationFeedback()) this.decorateField(this.embeddedFeedback);
			if(feedback.isShowEmbeddedFeedback()) this.setEmbeddedFeedbackImpl();
		}
		this.changeState();
	}
	,quizzesFieldListeners: null
	,compoundAnswer: null
	,fieldType: null
	,questionInstance: null
	,slot: null
	,embeddedFeedback: null
	,contextPanel: null
	,component: null
	,readOnly: null
	,__class__: com.wiris.quizzes.impl.ui.AnswerFieldImpl
});
com.wiris.quizzes.impl.ui.AuthoringFieldImpl = $hxClasses["com.wiris.quizzes.impl.ui.AuthoringFieldImpl"] = function(context,componentBuilder) {
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.setApplicationClass(com.wiris.quizzes.impl.ui.AuthoringFieldImpl.CLASS_QUIZZES_AUTHORING_FIELD);
	this.readOnly = false;
	this.component = null;
	this.context = context;
	this.setComponentBuilder(componentBuilder);
	this.quizzesFieldListeners = new Array();
	var deprecationWarnings = context.getQuestion().getDeprecationWarnings();
	if(deprecationWarnings.length > 0 && !com.wiris.quizzes.impl.ui.AuthoringFieldImpl.hasShownDeprecatedWarning) {
		var warnDeprecatedDialog = com.wiris.util.ui.component.Dialog.newAcknowledgementDialog(context.t(com.wiris.quizzes.impl.ui.AuthoringFieldImpl.DEPRECATED_MESSAGE_TITLE),context.t(com.wiris.quizzes.impl.ui.AuthoringFieldImpl.DEPRECATED_MESSAGE_TEXT),context.t(com.wiris.quizzes.impl.ui.AuthoringFieldImpl.DEPRECATED_MESSAGE_BUTTON),null);
		this.addComponent(warnDeprecatedDialog);
		warnDeprecatedDialog.setRelative(false);
		var deprecatedFeaturesFlowPanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
		var _g = 0;
		while(_g < deprecationWarnings.length) {
			var warning = deprecationWarnings[_g];
			++_g;
			var deprecatedFeatureExplanation = com.wiris.util.ui.component.Label.newWithText(context.t(warning));
			deprecatedFeatureExplanation.getStyle().setForegroundColor(com.wiris.util.graphics.Color.fromARGB([0,0,0,153]));
			deprecatedFeaturesFlowPanel.addComponent(deprecatedFeatureExplanation);
		}
		warnDeprecatedDialog.addControlComponent("extraInformation",deprecatedFeaturesFlowPanel);
		warnDeprecatedDialog.open();
		com.wiris.quizzes.impl.ui.AuthoringFieldImpl.hasShownDeprecatedWarning = true;
	}
};
com.wiris.quizzes.impl.ui.AuthoringFieldImpl.__name__ = ["com","wiris","quizzes","impl","ui","AuthoringFieldImpl"];
com.wiris.quizzes.impl.ui.AuthoringFieldImpl.__interfaces__ = [com.wiris.util.ui.interaction.ActionListener,com.wiris.quizzes.api.ui.AuthoringField];
com.wiris.quizzes.impl.ui.AuthoringFieldImpl.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.quizzes.impl.ui.AuthoringFieldImpl.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	actionPerformed: function(e) {
		var action = e.getAction();
		var actionId = action.getId();
		if(com.wiris.quizzes.impl.ui.AuthoringFieldImpl.AUTHORING_FIELD_CONTENT_CHANGED == actionId) this.fireContentChanged(); else if(com.wiris.quizzes.impl.ui.AuthoringFieldImpl.AUTHORING_FIELD_CONTENT_CHANGE_STARTED == actionId) this.fireContentChangeStarted();
	}
	,fireContentChangeStarted: function() {
		var _g = 0, _g1 = this.quizzesFieldListeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			l.contentChangeStarted(this);
		}
	}
	,fireContentChanged: function() {
		var _g = 0, _g1 = this.quizzesFieldListeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			l.contentChanged(this);
		}
	}
	,getElement: function() {
		if(com.wiris.util.ui.component.FlowPanel.prototype.getElement.call(this) == null) {
			this.addComponent(this.getComponent());
			if(this.context.isQuizzesStudio()) {
				if(!(this.getComponent().getApplicationClass() == com.wiris.quizzes.impl.ui.EmbeddedAuthoringField.CLASS_QUIZZES_EMBEDDED_AUTHORING_FIELD)) new com.wiris.quizzes.impl.ui.async.LoadSummaryTask(this,this.component.getSummary());
			}
			this.getComponentBuilder().buildComponent(this,null);
		}
		return com.wiris.util.ui.component.FlowPanel.prototype.getElement.call(this);
	}
	,getComponent: function() {
		if(this.component == null) {
			if(this.context.isQuizzesStudio()) this.component = new com.wiris.quizzes.impl.ui.component.QuizzesStudioPopupTextField(this.context); else if(this.context.isInlineQuizzesStudio()) {
				this.component = new com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent();
				this.component.setContext(this.context);
			} else if(this.context.isInlineMathEditor()) {
				this.component = new com.wiris.quizzes.impl.ui.component.AuthoringFieldMathTypeComponent(this.context,null);
				this.component.getComponent().getStyle().setWidth(450).setHeight(200).setMargin(0,0,5,0);
			} else return null;
			this.context.setAuthoringField(this.component);
			this.component.getComponent().addActionListener(this);
		}
		return this.component.getComponent();
	}
	,getQuestion: function() {
		return this.context.getInputQuestion();
	}
	,setReadOnly: function(readOnly) {
		this.readOnly = readOnly;
	}
	,addQuizzesFieldListener: function(listener) {
		this.quizzesFieldListeners.push(listener);
	}
	,setValue: function(value) {
		if(this.context.isQuizzesStudio()) this.getComponent().setValue(value); else if(this.context.isInlineQuizzesStudio()) this.getComponent().setValue(value); else if(this.context.isInlineMathEditor()) this.getComponent().setValue(value);
	}
	,getValue: function() {
		if(this.context.isQuizzesStudio()) return this.getComponent().getValue(); else if(this.context.isInlineQuizzesStudio()) return this.getComponent().getValue(); else if(this.context.isInlineMathEditor()) return this.getComponent().getValue();
		return null;
	}
	,showAnswerFieldPlainText: function(visible) {
		this.context.setOptAnswerFieldPlainText(visible);
	}
	,showAnswerFieldPopupEditor: function(visible) {
		this.context.setOptAnswerFieldPopupEditor(visible);
	}
	,showAnswerFieldInlineEditor: function(visible) {
		this.context.setOptAnswerFieldInlineEditor(visible);
	}
	,showGradingFunction: function(visible) {
		this.context.setOptGradingFunction(visible);
	}
	,showAuxiliaryTextInput: function(visible) {
		this.context.setOptAuxiliaryTextInput(visible);
	}
	,showAuxiliarTextInput: function(visible) {
		this.showAuxiliaryTextInput(visible);
	}
	,showAuxiliaryCasReplaceEditor: function(visible) {
		this.context.setOptAuxiliaryCasReplaceEditor(visible);
	}
	,showAuxiliarCasReplaceEditor: function(visible) {
		this.showAuxiliaryCasReplaceEditor(visible);
	}
	,showAuxiliaryCas: function(visible) {
		this.context.setOptAuxiliaryCas(visible);
	}
	,showAuxiliarCas: function(visible) {
		this.showAuxiliaryCas(visible);
	}
	,showGraphicSyntax: function(visible) {
		this.context.setOptGraphicSyntax(visible);
	}
	,showCorrectAnswer: function(visible) {
		this.context.setOptOpenAnswer(visible);
		this.context.setShowTestQuestion(visible);
		if(this.component != null) this.component.getComponent().changeState();
	}
	,showGradingCriteria: function(visible) {
		this.context.setShowGradingCriteria(visible);
	}
	,showVariablesDefinition: function(visible) {
		this.context.setShowVariablesDefinition(visible);
	}
	,showPreviewTab: function(visible) {
		this.context.setShowTestQuestion(visible);
	}
	,showVariablesTab: function(visible) {
		this.showVariablesDefinition(visible);
	}
	,showValidationTab: function(visible) {
		this.showGradingCriteria(visible);
	}
	,showCorrectAnswerTab: function(visible) {
		this.showCorrectAnswer(visible);
	}
	,setConfiguration: function(configuration) {
		var configJson;
		if(js.Boot.__instanceof(configuration,String)) configJson = com.wiris.util.json.JSon.decode(configuration); else configJson = com.wiris.system.JSONUtils.serialize(configuration);
		if(com.wiris.system.TypeTools.isHash(configJson)) this.context.setConfiguration(configJson); else throw "Invalid configuration.";
	}
	,getFieldType: function() {
		return this.context.getFieldType();
	}
	,setFieldType: function(type) {
		if(type != null) this.context.setFieldType(type); else throw "Invalid parameter type.";
	}
	,quizzesFieldListeners: null
	,context: null
	,component: null
	,readOnly: null
	,__class__: com.wiris.quizzes.impl.ui.AuthoringFieldImpl
});
com.wiris.quizzes.impl.ui.AuxiliaryCalcInputImpl = $hxClasses["com.wiris.quizzes.impl.ui.AuxiliaryCalcInputImpl"] = function(questionInstance,slot,componentBuilder) {
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	this.setApplicationClass(com.wiris.quizzes.impl.ui.AuxiliaryCalcInputImpl.CLASS_QUIZZES_AUXILIARY_CALCME_INPUT);
	this.questionInstance = questionInstance;
	this.context = com.wiris.quizzes.impl.ui.QuizzesContext.getInstance();
	this.value = questionInstance.getProperty(com.wiris.quizzes.api.PropertyName.CAS_SESSION);
	if(this.value == null) this.value = slot.getProperty(com.wiris.quizzes.api.PropertyName.CAS_SESSION);
	this.hideFileMenu = slot.getProperty(com.wiris.quizzes.api.PropertyName.AUXILIARY_CAS_HIDE_FILE_MENU);
	this.readOnly = false;
	this.setComponentBuilder(componentBuilder);
	this.listeners = new Array();
};
com.wiris.quizzes.impl.ui.AuxiliaryCalcInputImpl.__name__ = ["com","wiris","quizzes","impl","ui","AuxiliaryCalcInputImpl"];
com.wiris.quizzes.impl.ui.AuxiliaryCalcInputImpl.__interfaces__ = [com.wiris.util.ui.interaction.ActionListener,com.wiris.quizzes.api.ui.AuxiliaryCasField];
com.wiris.quizzes.impl.ui.AuxiliaryCalcInputImpl.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.quizzes.impl.ui.AuxiliaryCalcInputImpl.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	getElement: function() {
		if(com.wiris.util.ui.component.FlowPanel.prototype.getElement.call(this) == null) {
			this.addComponent(this.getComponent());
			this.getComponentBuilder().buildComponent(this,null);
		}
		return com.wiris.util.ui.component.FlowPanel.prototype.getElement.call(this);
	}
	,getComponent: function() {
		if(this.component == null) {
			var parameters = new Hash();
			parameters.set("lang",this.context.getLanguage());
			parameters.set("environment","quizzes-answer-field");
			parameters.set("hidefilemenu",this.hideFileMenu);
			this.component = new com.wiris.quizzes.impl.ui.component.CalcMeInputComponent(parameters);
			this.component.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setMinHeight(620);
			if(this.value != null && !(this.value == "")) this.component.setAlgorithm(this.value);
			this.component.addActionListener(this);
			this.component.setChangeAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.AuxiliaryCalcInputImpl.ACTION_ID_AUXILIARY_CALC_ME_CONTENT_CHANGED,null));
		}
		return this.component;
	}
	,fireContentChanged: function() {
		var _g = 0, _g1 = this.listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			l.contentChanged(this);
		}
	}
	,actionPerformed: function(e) {
		var action = e.getAction();
		var actionId = action.getId();
		if(actionId == com.wiris.quizzes.impl.ui.AuxiliaryCalcInputImpl.ACTION_ID_AUXILIARY_CALC_ME_CONTENT_CHANGED) {
			this.questionInstance.setLocalData(com.wiris.quizzes.impl.LocalData.KEY_CAS_SESSION,this.getComponent().getValue());
			this.fireContentChanged();
		}
	}
	,setReadOnly: function(readOnly) {
		this.readOnly = readOnly;
	}
	,addQuizzesFieldListener: function(listener) {
		this.listeners.push(listener);
	}
	,setValue: function(value) {
		this.value = value;
		if(this.component != null) this.component.setAlgorithm(value);
	}
	,getValue: function() {
		return this.getComponent().getValue();
	}
	,listeners: null
	,component: null
	,readOnly: null
	,context: null
	,questionInstance: null
	,hideFileMenu: null
	,value: null
	,__class__: com.wiris.quizzes.impl.ui.AuxiliaryCalcInputImpl
});
com.wiris.quizzes.impl.ui.EditorInterfaceImpl = $hxClasses["com.wiris.quizzes.impl.ui.EditorInterfaceImpl"] = function() { }
com.wiris.quizzes.impl.ui.EditorInterfaceImpl.__name__ = ["com","wiris","quizzes","impl","ui","EditorInterfaceImpl"];
com.wiris.quizzes.impl.ui.EditorInterfaceImpl.__interfaces__ = [com.wiris.editor.EditorInterface];
com.wiris.quizzes.impl.ui.EditorInterfaceImpl.prototype = {
	isHandOpen: function() {
		return false;
	}
	,closeHand: function() {
	}
	,openHand: function() {
	}
	,getHand: function() {
		return null;
	}
	,insertInto: function(parent) {
	}
	,getElement: function() {
		return null;
	}
	,getMathMLWithAnnotations: function() {
		return null;
	}
	,getMathMLWithSemantics: function() {
		return null;
	}
	,setToolbarHidden: function(hidden) {
	}
	,setParams: function(parameters) {
	}
	,setMathML: function(mathml) {
	}
	,setAutosize: function(enabled) {
	}
	,isReady: function() {
		return false;
	}
	,isFormulaEmpty: function() {
		return false;
	}
	,getVersion: function() {
		return null;
	}
	,getMathML: function() {
		return null;
	}
	,getEditorModel: function() {
		return null;
	}
	,focus: function() {
	}
	,blur: function() {
	}
	,actionWithParam: function(action,paramValue) {
	}
	,action: function(action) {
	}
	,__class__: com.wiris.quizzes.impl.ui.EditorInterfaceImpl
}
com.wiris.util.ui.component.ShadowComponent = $hxClasses["com.wiris.util.ui.component.ShadowComponent"] = function(innerComponent) {
	com.wiris.util.ui.component.Component.call(this);
	this.addClass(com.wiris.util.ui.component.ShadowComponent.CLASS_SHADOW_COMPONENT);
	this.innerComponent = innerComponent;
};
com.wiris.util.ui.component.ShadowComponent.__name__ = ["com","wiris","util","ui","component","ShadowComponent"];
com.wiris.util.ui.component.ShadowComponent.__super__ = com.wiris.util.ui.component.Component;
com.wiris.util.ui.component.ShadowComponent.prototype = $extend(com.wiris.util.ui.component.Component.prototype,{
	isChild: function(component) {
		return this.innerComponent == component || this.innerComponent.isChild(component);
	}
	,setInnerComponent: function(innerComponent) {
		this.innerComponent = innerComponent;
		this.changeState();
	}
	,getInnerComponent: function() {
		return this.innerComponent;
	}
	,innerComponent: null
	,__class__: com.wiris.util.ui.component.ShadowComponent
});
com.wiris.quizzes.impl.ui.EmbeddedAuthoringField = $hxClasses["com.wiris.quizzes.impl.ui.EmbeddedAuthoringField"] = function(context,componentBuilder) {
	com.wiris.util.ui.component.ShadowComponent.call(this,null);
	this.getStyle().setWidth(280).setMinHeight(51).setBackgroundColor(com.wiris.util.graphics.Color.fromText("#00000008")).setMargin(0,2,0,2);
	this.setApplicationClass(com.wiris.quizzes.impl.ui.EmbeddedAuthoringField.CLASS_QUIZZES_EMBEDDED_AUTHORING_FIELD);
	this.readOnly = false;
	this.component = null;
	this.context = context;
	this.setComponentBuilder(componentBuilder);
	this.listeners = new Array();
};
com.wiris.quizzes.impl.ui.EmbeddedAuthoringField.__name__ = ["com","wiris","quizzes","impl","ui","EmbeddedAuthoringField"];
com.wiris.quizzes.impl.ui.EmbeddedAuthoringField.__interfaces__ = [com.wiris.quizzes.api.ui.AuthoringField];
com.wiris.quizzes.impl.ui.EmbeddedAuthoringField.__super__ = com.wiris.util.ui.component.ShadowComponent;
com.wiris.quizzes.impl.ui.EmbeddedAuthoringField.prototype = $extend(com.wiris.util.ui.component.ShadowComponent.prototype,{
	getElement: function() {
		if(com.wiris.util.ui.component.ShadowComponent.prototype.getElement.call(this) == null) {
			this.getComponent();
			this.getComponentBuilder().buildComponent(this,null);
		}
		return com.wiris.util.ui.component.ShadowComponent.prototype.getElement.call(this);
	}
	,getComponent: function() {
		if(this.getInnerComponent() == null) {
			var studio = new com.wiris.quizzes.impl.ui.component.QuizzesStudioPopupTextField(this.context);
			this.context.setAuthoringField(studio);
			var appWrapper = com.wiris.util.ui.component.FlowPanel.newWithChild(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT,studio);
			appWrapper.setApplicationClass(com.wiris.quizzes.impl.ui.EmbeddedAuthoringField.CLASS_QUIZZES_EMBEDDED_AUTHORING_FIELD);
			appWrapper.getStyle().setWidth(280);
			this.setInnerComponent(appWrapper);
		}
		return this.getInnerComponent();
	}
	,destroy: function() {
		this.embeddedAnswersEditor.destroyAuthoringField(this);
	}
	,analyzeHTML: function() {
		this.embeddedAnswersEditor.analyzeHTML();
	}
	,getQuestion: function() {
		return this.context.getInputQuestion();
	}
	,setReadOnly: function(readOnly) {
		this.readOnly = readOnly;
	}
	,addQuizzesFieldListener: function(listener) {
		this.listeners.push(listener);
	}
	,setValue: function(value) {
		this.getComponent().setValue(value);
	}
	,getValue: function() {
		return this.getComponent().getValue();
	}
	,showAnswerFieldPlainText: function(visible) {
		this.context.setOptAnswerFieldPlainText(visible);
	}
	,showAnswerFieldPopupEditor: function(visible) {
		this.context.setOptAnswerFieldPopupEditor(visible);
	}
	,showAnswerFieldInlineEditor: function(visible) {
		this.context.setOptAnswerFieldInlineEditor(visible);
	}
	,showGradingFunction: function(visible) {
		this.context.setOptGradingFunction(visible);
	}
	,showAuxiliaryTextInput: function(visible) {
		this.context.setOptAuxiliaryTextInput(visible);
	}
	,showAuxiliarTextInput: function(visible) {
		this.showAuxiliaryTextInput(visible);
	}
	,showAuxiliaryCasReplaceEditor: function(visible) {
		this.context.setOptAuxiliaryCasReplaceEditor(visible);
	}
	,showAuxiliarCasReplaceEditor: function(visible) {
		this.showAuxiliaryCasReplaceEditor(visible);
	}
	,showAuxiliaryCas: function(visible) {
		this.context.setOptAuxiliaryCas(visible);
	}
	,showAuxiliarCas: function(visible) {
		this.showAuxiliaryCas(visible);
	}
	,showGraphicSyntax: function(visible) {
		this.context.setOptGraphicSyntax(visible);
	}
	,showCorrectAnswer: function(visible) {
		this.context.setOptOpenAnswer(visible);
		this.context.setShowTestQuestion(visible);
	}
	,showGradingCriteria: function(visible) {
		this.context.setShowGradingCriteria(visible);
	}
	,showVariablesDefinition: function(visible) {
		this.context.setShowVariablesDefinition(visible);
	}
	,showPreviewTab: function(visible) {
		this.context.setShowTestQuestion(visible);
	}
	,showVariablesTab: function(visible) {
		this.showVariablesDefinition(visible);
	}
	,showValidationTab: function(visible) {
		this.showGradingCriteria(visible);
	}
	,showCorrectAnswerTab: function(visible) {
		this.showCorrectAnswer(visible);
	}
	,setConfiguration: function(configuration) {
		var configJson = com.wiris.system.JSONUtils.serialize(configuration);
		if(com.wiris.system.TypeTools.isHash(configJson)) this.context.setConfiguration(configJson); else throw "Invalid configuration.";
	}
	,getEmbeddedAnswersEditor: function() {
		return this.embeddedAnswersEditor;
	}
	,setEmbeddedAnswersEditor: function(embeddedAnswersEditor) {
		this.embeddedAnswersEditor = embeddedAnswersEditor;
	}
	,getEditableElement: function() {
		return this.editableElement;
	}
	,setEditableElement: function(editableElement) {
		if(this.editableElement != editableElement) {
			this.editableElement = editableElement;
			this.changeState();
		}
	}
	,getSlot: function() {
		return this.context.getInputSlot();
	}
	,setSlot: function(slot) {
		this.context.setInputSlot(slot);
	}
	,getFieldType: function() {
		return com.wiris.quizzes.api.ui.AuthoringFieldType.EMBEDDED_ANSWERS_EDITOR;
	}
	,setFieldType: function(type) {
		if(type != com.wiris.quizzes.api.ui.AuthoringFieldType.EMBEDDED_ANSWERS_EDITOR) throw "Invalid parameter type.";
	}
	,embeddedAnswersEditor: null
	,listeners: null
	,editableElement: null
	,context: null
	,component: null
	,readOnly: null
	,__class__: com.wiris.quizzes.impl.ui.EmbeddedAuthoringField
});
com.wiris.quizzes.impl.ui.QuizzesContext = $hxClasses["com.wiris.quizzes.impl.ui.QuizzesContext"] = function() {
	this.forceLTR = false;
	this.language = com.wiris.quizzes.impl.ui.QuizzesContext.DEFAULT_LANG;
	this.graphLanguage = com.wiris.quizzes.impl.ui.QuizzesContext.DEFAULT_LANG;
	this.translatorContainer = com.wiris.util.lang.WordsTranslatorContainer.newTranslatorContainerFromWords(new com.wiris.util.lang.Words("strings_quizzes",this.getAvailableLanguagesFromList(com.wiris.quizzes.impl.ui.QuizzesContext.AVAILABLE_LANGS)),com.wiris.quizzes.impl.ui.QuizzesContext.DEFAULT_LANG);
	this.graphTranslatorContainer = com.wiris.util.lang.WordsTranslatorContainer.newTranslatorContainerFromWords(new com.wiris.util.lang.Words("strings_graph",this.getAvailableLanguagesFromList(com.wiris.quizzes.impl.ui.QuizzesContext.GRAPH_AVAILABLE_LANGS)),com.wiris.quizzes.impl.ui.QuizzesContext.DEFAULT_LANG);
};
com.wiris.quizzes.impl.ui.QuizzesContext.__name__ = ["com","wiris","quizzes","impl","ui","QuizzesContext"];
com.wiris.quizzes.impl.ui.QuizzesContext.instance = null;
com.wiris.quizzes.impl.ui.QuizzesContext.getInstance = function() {
	if(com.wiris.quizzes.impl.ui.QuizzesContext.instance == null) com.wiris.quizzes.impl.ui.QuizzesContext.instance = new com.wiris.quizzes.impl.ui.QuizzesContext();
	return com.wiris.quizzes.impl.ui.QuizzesContext.instance;
}
com.wiris.quizzes.impl.ui.QuizzesContext.prototype = {
	isForceLTR: function() {
		return this.forceLTR;
	}
	,isLanguageForceLTR: function(lang) {
		return StringTools.startsWith(lang,"he");
	}
	,buildUrl: function(url) {
		var hashPosition = url.indexOf("#");
		var postHash = "";
		if(hashPosition != -1) {
			postHash = HxOverrides.substr(url,hashPosition,null);
			url = HxOverrides.substr(url,0,hashPosition);
		}
		return StringTools.replace(url,"${lang}","en") + (url.indexOf("?") > -1?"&":"?") + com.wiris.quizzes.impl.ui.QuizzesContext.UTM_SUFFIX + postHash;
	}
	,getTranslatorFromLang: function(lang) {
		if(com.wiris.system.ArrayEx.contains(this.translatorContainer.getAvailableLanguages(),com.wiris.util.lang.WordsTranslatorContainer.normalizeLangString(lang))) return this.translatorContainer.getTranslator(com.wiris.util.lang.WordsTranslatorContainer.normalizeLangString(lang));
		return this.translatorContainer.getTranslator(com.wiris.util.lang.WordsTranslatorContainer.normalizeLangString(com.wiris.quizzes.impl.ui.QuizzesContext.DEFAULT_LANG));
	}
	,getGraphTranslator: function() {
		return this.graphTranslatorContainer.getTranslator(this.graphLanguage);
	}
	,getTranslator: function() {
		return this.translatorContainer.getTranslator(this.language);
	}
	,setLanguage: function(language) {
		this.language = this.translatorContainer.getAvailableLang(language);
		this.graphLanguage = this.graphTranslatorContainer.getAvailableLang(language);
		this.forceLTR = this.isLanguageForceLTR(language);
	}
	,getLanguage: function() {
		return this.language;
	}
	,getAvailableLanguages: function() {
		return this.translatorContainer.getAvailableLanguages();
	}
	,graphT: function(code) {
		return this.getGraphTranslator().t(code);
	}
	,t: function(code) {
		return this.getTranslator().t(code);
	}
	,getAvailableLanguagesFromList: function(list) {
		var available = list.split(",").slice();
		var i = 0;
		while(i < available.length) available[i] = com.wiris.util.lang.WordsTranslatorContainer.normalizeLangString(available[i++]);
		return available;
	}
	,forceLTR: null
	,graphTranslatorContainer: null
	,translatorContainer: null
	,graphLanguage: null
	,language: null
	,__class__: com.wiris.quizzes.impl.ui.QuizzesContext
}
com.wiris.quizzes.impl.ui.QuizzesStudioConfig = $hxClasses["com.wiris.quizzes.impl.ui.QuizzesStudioConfig"] = function(configJson) {
	this.setConfiguration(configJson);
};
com.wiris.quizzes.impl.ui.QuizzesStudioConfig.__name__ = ["com","wiris","quizzes","impl","ui","QuizzesStudioConfig"];
com.wiris.quizzes.impl.ui.QuizzesStudioConfig.prototype = {
	isOptInputSyntax: function() {
		return this.getKey("inputOptions/inputSyntax");
	}
	,isOptInputType: function() {
		return this.getKey("inputOptions/answerInputMethod/answerInputField");
	}
	,isOptValidationOptions: function() {
		return this.getKey("validationOptions");
	}
	,isOptAnswerType: function() {
		return this.getKey("answerType");
	}
	,isOptShowVariablesDefinition: function() {
		return this.getKey("variablesFunctions");
	}
	,isOptGraphicSyntax: function() {
		return this.getKey("answerType/graphicSyntax");
	}
	,isOptAnswerFieldPlainText: function() {
		return this.getKey("inputOptions/answerInputMethod/answerInputField/answerInputFieldPlainText");
	}
	,isOptAnswerFieldPopupEditor: function() {
		return this.getKey("inputOptions/answerInputMethod/answerInputField/answerInputFieldPopupEditor");
	}
	,isOptAnswerFieldInlineEditor: function() {
		return this.getKey("inputOptions/answerInputMethod/answerInputField/answerInputFieldInlineEditor");
	}
	,isOptCompoundAnswer: function() {
		return this.getKey("inputOptions/compoundAnswer");
	}
	,isOptGradingFunction: function() {
		return this.getKey("validationOptions/studentAnswerComparison/customGradingFunction");
	}
	,isOptAuxiliaryTextInput: function() {
		return this.getKey("inputOptions/answerInputMethod/auxiliaryInput/auxiliaryTextInput");
	}
	,isOptAuxiliaryCasReplaceEditor: function() {
		return this.getKey("inputOptions/answerInputMethod/auxiliaryInput/auxiliaryInputReplace");
	}
	,isOptAuxiliaryCas: function() {
		return this.getKey("inputOptions/answerInputMethod/auxiliaryInput/auxiliaryInputDisplay");
	}
	,isOptOpenAnswer: function() {
		return this.getKey("questionAnswer");
	}
	,setOptGraphicSyntax: function(visible) {
		this.setKey("answerType/graphicSyntax",visible);
	}
	,setOptAnswerFieldPlainText: function(visible) {
		this.setKey("inputOptions/answerInputMethod/answerInputField/answerInputFieldPlainText",visible);
	}
	,setOptAnswerFieldPopupEditor: function(visible) {
		this.setKey("inputOptions/answerInputMethod/answerInputField/answerInputFieldPopupEditor",visible);
	}
	,setOptAnswerFieldInlineEditor: function(visible) {
		this.setKey("inputOptions/answerInputMethod/answerInputField/answerInputFieldInlineEditor",visible);
	}
	,setOptGradingFunction: function(visible) {
		this.setKey("validationOptions/studentAnswerComparison/customGradingFunction",visible);
	}
	,setOptAuxiliaryTextInput: function(visible) {
		this.setKey("inputOptions/answerInputMethod/auxiliaryInput/auxiliaryTextInput",visible);
	}
	,setOptAuxiliaryCasReplaceEditor: function(visible) {
		this.setKey("inputOptions/answerInputMethod/auxiliaryInput/auxiliaryInputReplace",visible);
	}
	,setOptAuxiliaryCas: function(visible) {
		this.setKey("inputOptions/answerInputMethod/auxiliaryInput/auxiliaryInputDisplay",visible);
	}
	,setOptOpenAnswer: function(visible) {
		this.setKey("questionAnswer",visible);
	}
	,setShowTestQuestion: function(visible) {
		this.setKey("testQuestion",visible);
	}
	,setShowVariablesDefinition: function(visible) {
		this.setKey("variablesFunctions",visible);
	}
	,setShowGradingCriteria: function(visible) {
		this.setKey("answerType",visible);
		this.setKey("inputOptions/answerInputMethod/answerInputField",visible);
		this.setKey("inputOptions/inputSyntax",visible);
		this.setKey("validationOptions",visible);
	}
	,setConfiguration: function(configJson) {
		this.configJson = configJson;
	}
	,setKeyImpl: function(key,value,config) {
		if(config.exists(key)) config.set(key,value); else {
			var pieces = key.split("/").slice();
			if(pieces.length > 1) {
				var configValue = config.get(pieces[0]);
				if(configValue == null || com.wiris.system.TypeTools.isHash(configValue) == false) {
					if(configValue != null) {
						var parentValue = com.wiris.util.json.JSon.getBoolean(configValue);
						if(!parentValue) return;
					}
					configValue = new Hash();
					config.set(pieces[0],configValue);
				}
				HxOverrides.remove(pieces,pieces[0]);
				this.setKeyImpl(pieces.join("/"),value,com.wiris.util.json.JSon.getHash(configValue));
			} else config.set(key,value);
		}
	}
	,setKey: function(key,value) {
		if(this.configJson == null) this.configJson = new Hash();
		this.setKeyImpl(key,value,this.configJson);
	}
	,getKeyImpl: function(key,config,defaultValue) {
		if(config.exists(key)) {
			var configValue = config.get(key);
			if(com.wiris.system.TypeTools.isHash(configValue)) return true; else return com.wiris.util.json.JSon.getBoolean(configValue);
		} else {
			var pieces = key.split("/").slice();
			if(pieces.length > 1) {
				if(config.exists(pieces[0])) {
					var configValue = config.get(pieces[0]);
					if(com.wiris.system.TypeTools.isHash(configValue)) {
						HxOverrides.remove(pieces,pieces[0]);
						return this.getKeyImpl(pieces.join("/"),com.wiris.util.json.JSon.getHash(configValue),defaultValue);
					} else return com.wiris.util.json.JSon.getBoolean(configValue);
				}
			}
		}
		return defaultValue;
	}
	,getKeyWithDefaultValue: function(key,defaultValue) {
		if(this.configJson != null) return this.getKeyImpl(key,this.configJson,defaultValue);
		return defaultValue;
	}
	,getKey: function(key) {
		return this.getKeyWithDefaultValue(key,true);
	}
	,configJson: null
	,__class__: com.wiris.quizzes.impl.ui.QuizzesStudioConfig
}
com.wiris.quizzes.impl.ui.QuizzesStudioContext = $hxClasses["com.wiris.quizzes.impl.ui.QuizzesStudioContext"] = function(question,slot,authorAnswer) {
	this.initialContentLocked = false;
	this.question = question;
	this.slot = slot;
	this.authorAnswer = authorAnswer;
	this.inputQuestion = question;
	this.inputSlot = slot;
	this.inputAuthorAnswer = authorAnswer;
	this.fieldType = com.wiris.quizzes.api.ui.AuthoringFieldType.INLINE_MATH_EDITOR;
	this.showAllOptions = false;
	this.featuredParams = new Array();
	this.featuredAssertions = new Array();
	this.featuredAssertions.push(com.wiris.quizzes.impl.Assertion.EQUIVALENT_SYMBOLIC);
	this.featuredAssertions.push(com.wiris.quizzes.impl.Assertion.EQUIVALENT_ALL);
	this.featuredAssertions.push(com.wiris.quizzes.impl.Assertion.EQUIVALENT_FUNCTION);
	this.globalContext = com.wiris.quizzes.impl.ui.QuizzesContext.getInstance();
	this.configuration = new com.wiris.quizzes.impl.ui.QuizzesStudioConfig(null);
	this.graphicalElements = new Hash();
	this.homePageStatusCorrectAnswerInitialContent = com.wiris.quizzes.impl.ui.QuizzesStudioContext.HOME_PAGE_STATUS_CORRECT_ANSWER;
	this.homePageStatusGettingStarted = com.wiris.quizzes.impl.ui.QuizzesStudioContext.HOME_PAGE_STATUS_SHOW_MAIN_CONTENT;
};
com.wiris.quizzes.impl.ui.QuizzesStudioContext.__name__ = ["com","wiris","quizzes","impl","ui","QuizzesStudioContext"];
com.wiris.quizzes.impl.ui.QuizzesStudioContext.prototype = {
	isInitialContentLocked: function() {
		try {
			if(this.slot.getSyntax().getName() == com.wiris.quizzes.api.assertion.SyntaxName.MATH) {
				var initialContent = this.slot.getInitialContent();
				if(initialContent == null || initialContent == "") return false;
				var mathml = com.wiris.util.xml.WXmlUtils.parseXML(initialContent);
				var math = mathml.nodeType == Xml.Document?mathml.firstElement():mathml;
				return math.get(com.wiris.quizzes.impl.ui.controller.QuizzesStudioController.WRS_POSITIONABLE) == "false";
			} else if(this.slot.getSyntax().getName() == com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC) return this.slot.getProperty(com.wiris.quizzes.api.PropertyName.GRAPH_LOCK_INITIAL_CONTENT) == "true";
			return false;
		} catch( t ) {
			return false;
		}
	}
	,getHomePageStatusGettingStarted: function() {
		return this.homePageStatusGettingStarted;
	}
	,setHomePageStatusGettingStarted: function(homePageStatusGettingStarted) {
		this.homePageStatusGettingStarted = homePageStatusGettingStarted;
	}
	,getHomePageStatusCorrectAnswerInitialContent: function() {
		return this.homePageStatusCorrectAnswerInitialContent;
	}
	,setHomePageStatusCorrectAnswerInitialContent: function(homePageStatusCorrectAnswerInitialContent) {
		this.homePageStatusCorrectAnswerInitialContent = homePageStatusCorrectAnswerInitialContent;
	}
	,importToInputQuestion: function() {
		var studioQimpl = this.getQuestionImpl();
		var inputQimpl = this.getInputQuestionImpl();
		inputQimpl.importQuestion(studioQimpl);
		var studioSimpl = this.getSlot();
		var inputSimpl = this.getInputSlot();
		inputSimpl.importSlot(studioSimpl);
		var studioAAimpl = this.getAuthorAnswer();
		var inputAAimpl = this.getInputAuthorAnswer();
		inputAAimpl.importAuthorAnswer(studioAAimpl);
	}
	,generateQuestionInstance: function() {
		this.questionInstance = com.wiris.quizzes.api.Quizzes.getInstance().newQuestionInstance(this.question);
		return this.questionInstance;
	}
	,getGraphicalRatios: function() {
		var active = this.getGraphicalElementsActive();
		var ret = new Array();
		var _g = 0;
		while(_g < active.length) {
			var elem = active[_g];
			++_g;
			ret.push(this.graphicalElements.get(elem) + "");
		}
		return ret;
	}
	,setGraphicalElements: function(graphicalElements) {
		this.graphicalElements = graphicalElements;
	}
	,getGraphicalElementsActive: function() {
		var ret = new Array();
		var i = this.graphicalElements.keys();
		while(i.hasNext()) {
			var elem = i.next();
			if(this.isGraphicalElementActive(elem)) ret.push(elem);
		}
		return ret;
	}
	,isGraphicalElementActive: function(elem) {
		return this.graphicalElements.exists(elem) && !(com.wiris.quizzes.impl.ui.QuizzesStudioContext.GRAPHICAL_ELEMENT_NOT_ACTIVE == this.graphicalElements.get(elem));
	}
	,getGraphicalElements: function() {
		return this.graphicalElements;
	}
	,isInlineMathEditor: function() {
		return this.fieldType == com.wiris.quizzes.api.ui.AuthoringFieldType.INLINE_MATH_EDITOR;
	}
	,isInlineQuizzesStudio: function() {
		return this.fieldType == com.wiris.quizzes.api.ui.AuthoringFieldType.INLINE_STUDIO;
	}
	,isQuizzesStudio: function() {
		return this.fieldType == com.wiris.quizzes.api.ui.AuthoringFieldType.STUDIO;
	}
	,isOptAuxiliaryTextInput: function() {
		return this.configuration.isOptAuxiliaryTextInput();
	}
	,isOptShowVariablesDefinition: function() {
		return this.configuration.isOptShowVariablesDefinition();
	}
	,isOptGraphicSyntax: function() {
		return this.configuration.isOptGraphicSyntax();
	}
	,isOptAnswerFieldPlainText: function() {
		return this.configuration.isOptAnswerFieldPlainText();
	}
	,isOptAnswerFieldPopupEditor: function() {
		return this.configuration.isOptAnswerFieldPopupEditor();
	}
	,isOptAnswerFieldInlineEditor: function() {
		return this.configuration.isOptAnswerFieldInlineEditor();
	}
	,isOptCompoundAnswer: function() {
		return this.configuration.isOptCompoundAnswer();
	}
	,isOptGradingFunction: function() {
		return this.configuration.isOptGradingFunction();
	}
	,isOptAuxiliaryCasReplaceEditor: function() {
		return this.configuration.isOptAuxiliaryCasReplaceEditor();
	}
	,isOptAuxiliaryCas: function() {
		return this.configuration.isOptAuxiliaryCas();
	}
	,isOptInputSyntax: function() {
		return this.configuration.isOptInputSyntax();
	}
	,isOptInputType: function() {
		return this.configuration.isOptInputType();
	}
	,isOptValidationOptions: function() {
		return this.configuration.isOptValidationOptions();
	}
	,isOptAnswerType: function() {
		return this.configuration.isOptAnswerType();
	}
	,isOptOpenAnswer: function() {
		return this.configuration.isOptOpenAnswer();
	}
	,getConfigurationKey: function(key) {
		return this.configuration.getKey(key);
	}
	,setOptGraphicSyntax: function(visible) {
		this.configuration.setOptGraphicSyntax(visible);
	}
	,setOptAnswerFieldPlainText: function(visible) {
		this.configuration.setOptAnswerFieldPlainText(visible);
	}
	,setOptAnswerFieldPopupEditor: function(visible) {
		this.configuration.setOptAnswerFieldPopupEditor(visible);
	}
	,setOptAnswerFieldInlineEditor: function(visible) {
		this.configuration.setOptAnswerFieldInlineEditor(visible);
		var qimpl = this.question.getImpl();
		if(!this.configuration.isOptAnswerFieldInlineEditor() && qimpl.getLocalData(com.wiris.quizzes.impl.LocalData.KEY_OPENANSWER_INPUT_FIELD) == com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_INPUT_FIELD_INLINE_EDITOR) {
			if(this.configuration.isOptAnswerFieldPlainText()) qimpl.setLocalData(com.wiris.quizzes.impl.LocalData.KEY_OPENANSWER_INPUT_FIELD,com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_INPUT_FIELD_PLAIN_TEXT);
		}
	}
	,setOptGradingFunction: function(visible) {
		this.configuration.setOptGradingFunction(visible);
	}
	,setOptAuxiliaryTextInput: function(visible) {
		this.configuration.setOptAuxiliaryTextInput(visible);
	}
	,setOptAuxiliaryCasReplaceEditor: function(visible) {
		this.configuration.setOptAuxiliaryCasReplaceEditor(visible);
	}
	,setOptAuxiliaryCas: function(visible) {
		this.configuration.setOptAuxiliaryCas(visible);
	}
	,setOptOpenAnswer: function(visible) {
		this.configuration.setOptOpenAnswer(visible);
	}
	,setShowTestQuestion: function(visible) {
		this.configuration.setShowTestQuestion(visible);
	}
	,setShowVariablesDefinition: function(visible) {
		this.configuration.setShowVariablesDefinition(visible);
	}
	,setShowGradingCriteria: function(visible) {
		this.configuration.setShowGradingCriteria(visible);
	}
	,setConfiguration: function(configuration) {
		this.configuration.setConfiguration(configuration);
	}
	,setPreviewCorrectAnswerUpdated: function(correctAnswerUpdated) {
		this.correctAnswerUpdated = correctAnswerUpdated;
	}
	,setShowAllOptions: function(showAllOptions) {
		this.showAllOptions = showAllOptions;
	}
	,setAuthoringField: function(authoringField) {
		this.authoringField = authoringField;
	}
	,setFieldType: function(fieldType) {
		this.fieldType = fieldType;
	}
	,setFeaturedAssertions: function(featuredAssertions) {
		this.featuredAssertions = featuredAssertions;
	}
	,setFeaturedParams: function(featuredParams) {
		this.featuredParams = featuredParams;
	}
	,setMathTypeParameters: function(mathTypeParameters) {
		this.mathTypeParameters = mathTypeParameters;
	}
	,setInputAuthorAnswer: function(authorAnswer) {
		this.inputAuthorAnswer = authorAnswer;
	}
	,setInputSlot: function(slot) {
		this.inputSlot = slot;
	}
	,setInputQuestion: function(question) {
		this.inputQuestion = question;
	}
	,setAuthorAnswer: function(authorAnswer) {
		this.authorAnswer = authorAnswer;
	}
	,setSlot: function(slot) {
		this.slot = slot;
	}
	,setQuestionInstance: function(questionInstance) {
		this.questionInstance = questionInstance;
	}
	,setQuestion: function(question) {
		this.question = question;
	}
	,isPreviewCorrectAnswerUpdated: function() {
		return this.correctAnswerUpdated;
	}
	,isShowAllOptions: function() {
		return this.showAllOptions || !this.isOptOpenAnswer();
	}
	,getGlobalContext: function() {
		return this.globalContext;
	}
	,getAuthoringField: function() {
		return this.authoringField;
	}
	,getFieldType: function() {
		return this.fieldType;
	}
	,getFeaturedAssertions: function() {
		return this.featuredAssertions;
	}
	,getFeaturedParams: function() {
		return this.featuredParams;
	}
	,getReservedWords: function() {
		return this.mathTypeParameters != null?this.mathTypeParameters.get("reservedWords"):null;
	}
	,getMathTypeParameters: function() {
		return this.mathTypeParameters;
	}
	,getGrammarUrl: function() {
		var grammarUrl = this.slot.getGrammarUrl();
		grammarUrl += grammarUrl.indexOf("?") != -1?"&":"?";
		grammarUrl += "reservedWords=true&measureUnits=true&json=true";
		return grammarUrl;
	}
	,getInputAuthorAnswer: function() {
		return this.inputAuthorAnswer;
	}
	,getInputSlot: function() {
		return this.inputSlot;
	}
	,getInputQuestionImpl: function() {
		return this.inputQuestion.getImpl();
	}
	,getInputQuestion: function() {
		return this.inputQuestion;
	}
	,getAuthorAnswer: function() {
		return this.authorAnswer;
	}
	,getSlot: function() {
		return this.slot;
	}
	,getQuestionInstanceImpl: function() {
		return this.questionInstance;
	}
	,getQuestionInstance: function() {
		return this.questionInstance;
	}
	,getQuestionImpl: function() {
		return this.question.getImpl();
	}
	,getQuestion: function() {
		return this.question;
	}
	,getTranslator: function() {
		return this.globalContext.getTranslator();
	}
	,getLanguage: function() {
		return this.globalContext.getLanguage();
	}
	,graphT: function(code) {
		return this.globalContext.graphT(code);
	}
	,t: function(code) {
		return this.globalContext.t(code);
	}
	,initialContentLocked: null
	,homePageStatusGettingStarted: null
	,homePageStatusCorrectAnswerInitialContent: null
	,configuration: null
	,globalContext: null
	,fieldType: null
	,authoringField: null
	,graphicalElements: null
	,correctAnswerUpdated: null
	,showAllOptions: null
	,featuredAssertions: null
	,featuredParams: null
	,mathTypeParameters: null
	,inputAuthorAnswer: null
	,inputSlot: null
	,inputQuestion: null
	,authorAnswer: null
	,slot: null
	,questionInstance: null
	,question: null
	,__class__: com.wiris.quizzes.impl.ui.QuizzesStudioContext
}
com.wiris.util.ui.interaction.InputComponentListener = $hxClasses["com.wiris.util.ui.interaction.InputComponentListener"] = function() { }
com.wiris.util.ui.interaction.InputComponentListener.__name__ = ["com","wiris","util","ui","interaction","InputComponentListener"];
com.wiris.util.ui.interaction.InputComponentListener.prototype = {
	onSetComponent: null
	,__class__: com.wiris.util.ui.interaction.InputComponentListener
}
if(!com.wiris.quizzes.impl.ui.async) com.wiris.quizzes.impl.ui.async = {}
com.wiris.quizzes.impl.ui.async.InputComponentListenerWrapper = $hxClasses["com.wiris.quizzes.impl.ui.async.InputComponentListenerWrapper"] = function(apiListener) {
	this.apiListener = apiListener;
};
com.wiris.quizzes.impl.ui.async.InputComponentListenerWrapper.__name__ = ["com","wiris","quizzes","impl","ui","async","InputComponentListenerWrapper"];
com.wiris.quizzes.impl.ui.async.InputComponentListenerWrapper.__interfaces__ = [com.wiris.util.ui.interaction.InputComponentListener];
com.wiris.quizzes.impl.ui.async.InputComponentListenerWrapper.prototype = {
	onSetComponent: function(component) {
		if(js.Boot.__instanceof(component,com.wiris.quizzes.impl.ui.component.MathTypeInputComponent)) this.apiListener.onGetAnswerFieldComponent(component.getEditor()); else if(js.Boot.__instanceof(component,com.wiris.quizzes.impl.ui.component.GraphInputComponent)) this.apiListener.onGetAnswerFieldComponent(component.getGraph());
	}
	,apiListener: null
	,__class__: com.wiris.quizzes.impl.ui.async.InputComponentListenerWrapper
}
com.wiris.util.sys.TimerTask = $hxClasses["com.wiris.util.sys.TimerTask"] = function() { }
com.wiris.util.sys.TimerTask.__name__ = ["com","wiris","util","sys","TimerTask"];
com.wiris.util.sys.TimerTask.prototype = {
	run: null
	,__class__: com.wiris.util.sys.TimerTask
}
com.wiris.quizzes.impl.ui.async.LoadAnswerTask = $hxClasses["com.wiris.quizzes.impl.ui.async.LoadAnswerTask"] = function(studentAnswerComponent,questionInstanceImpl,slot) {
	this.studentAnswerComponent = studentAnswerComponent;
	this.questionInstanceImpl = questionInstanceImpl;
	this.slot = slot;
	new com.wiris.util.sys.TimerProxy(10,true,this);
};
com.wiris.quizzes.impl.ui.async.LoadAnswerTask.__name__ = ["com","wiris","quizzes","impl","ui","async","LoadAnswerTask"];
com.wiris.quizzes.impl.ui.async.LoadAnswerTask.__interfaces__ = [com.wiris.util.sys.TimerTask];
com.wiris.quizzes.impl.ui.async.LoadAnswerTask.prototype = {
	run: function(timer) {
		this.studentAnswerComponent.emptyStudentAnswerImpl(this.questionInstanceImpl,this.slot);
	}
	,slot: null
	,questionInstanceImpl: null
	,studentAnswerComponent: null
	,__class__: com.wiris.quizzes.impl.ui.async.LoadAnswerTask
}
com.wiris.quizzes.impl.ui.async.LoadSummaryTask = $hxClasses["com.wiris.quizzes.impl.ui.async.LoadSummaryTask"] = function(authoringField,summary) {
	this.authoringField = authoringField;
	this.summary = summary;
	new com.wiris.util.sys.TimerProxy(500,true,this);
};
com.wiris.quizzes.impl.ui.async.LoadSummaryTask.__name__ = ["com","wiris","quizzes","impl","ui","async","LoadSummaryTask"];
com.wiris.quizzes.impl.ui.async.LoadSummaryTask.__interfaces__ = [com.wiris.util.sys.TimerTask];
com.wiris.quizzes.impl.ui.async.LoadSummaryTask.prototype = {
	run: function(timer) {
		this.authoringField.addComponent(this.summary);
	}
	,summary: null
	,authoringField: null
	,__class__: com.wiris.quizzes.impl.ui.async.LoadSummaryTask
}
com.wiris.quizzes.impl.ui.async.SetInitialContentTask = $hxClasses["com.wiris.quizzes.impl.ui.async.SetInitialContentTask"] = function(answerField,attempts) {
	this.answerField = answerField;
	this.attempts = attempts;
	new com.wiris.util.sys.TimerProxy(500,true,this);
};
com.wiris.quizzes.impl.ui.async.SetInitialContentTask.__name__ = ["com","wiris","quizzes","impl","ui","async","SetInitialContentTask"];
com.wiris.quizzes.impl.ui.async.SetInitialContentTask.__interfaces__ = [com.wiris.util.sys.TimerTask];
com.wiris.quizzes.impl.ui.async.SetInitialContentTask.prototype = {
	run: function(timer) {
		this.answerField.setInitialContent(this.attempts + 1);
	}
	,attempts: null
	,answerField: null
	,__class__: com.wiris.quizzes.impl.ui.async.SetInitialContentTask
}
com.wiris.quizzes.impl.ui.async.UpdateCalcMeImaginaryUnitTask = $hxClasses["com.wiris.quizzes.impl.ui.async.UpdateCalcMeImaginaryUnitTask"] = function(controller,calcmeParams) {
	this.controller = controller;
	this.calcmeParams = calcmeParams;
	new com.wiris.util.sys.TimerProxy(750,true,this);
};
com.wiris.quizzes.impl.ui.async.UpdateCalcMeImaginaryUnitTask.__name__ = ["com","wiris","quizzes","impl","ui","async","UpdateCalcMeImaginaryUnitTask"];
com.wiris.quizzes.impl.ui.async.UpdateCalcMeImaginaryUnitTask.__interfaces__ = [com.wiris.util.sys.TimerTask];
com.wiris.quizzes.impl.ui.async.UpdateCalcMeImaginaryUnitTask.prototype = {
	run: function(timer) {
		this.controller.algorithmEditorActionWithParams("setImaginaryUnitRestrictions",this.calcmeParams);
	}
	,controller: null
	,calcmeParams: null
	,__class__: com.wiris.quizzes.impl.ui.async.UpdateCalcMeImaginaryUnitTask
}
com.wiris.quizzes.impl.ui.async.UpdateCalcMeSeparatorTask = $hxClasses["com.wiris.quizzes.impl.ui.async.UpdateCalcMeSeparatorTask"] = function(controller,calcmeParams) {
	this.controller = controller;
	this.calcmeParams = calcmeParams;
	new com.wiris.util.sys.TimerProxy(750,true,this);
};
com.wiris.quizzes.impl.ui.async.UpdateCalcMeSeparatorTask.__name__ = ["com","wiris","quizzes","impl","ui","async","UpdateCalcMeSeparatorTask"];
com.wiris.quizzes.impl.ui.async.UpdateCalcMeSeparatorTask.__interfaces__ = [com.wiris.util.sys.TimerTask];
com.wiris.quizzes.impl.ui.async.UpdateCalcMeSeparatorTask.prototype = {
	run: function(timer) {
		this.controller.algorithmEditorActionWithParams("setSeparatorRestrictions",this.calcmeParams);
	}
	,controller: null
	,calcmeParams: null
	,__class__: com.wiris.quizzes.impl.ui.async.UpdateCalcMeSeparatorTask
}
if(!com.wiris.quizzes.impl.ui.component) com.wiris.quizzes.impl.ui.component = {}
com.wiris.quizzes.impl.ui.component.AnswerFeedbackComponent = $hxClasses["com.wiris.quizzes.impl.ui.component.AnswerFeedbackComponent"] = function() {
	this.assertionsFeedback = true;
	this.correctAnswerFeedback = true;
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.addClass(com.wiris.quizzes.impl.ui.component.AnswerFeedbackComponent.CLASS_STUDENT_ANSWER_FEEDBACK);
	this.getStyle().setMargin(0,0,24,0).setBackgroundColor(com.wiris.util.graphics.Color.fromARGB([0,0,0,0]));
	this.context = com.wiris.quizzes.impl.ui.QuizzesContext.getInstance();
	this.answerFeedbackLabels = new Array();
	this.assertionFeedbackLists = new Array();
};
com.wiris.quizzes.impl.ui.component.AnswerFeedbackComponent.__name__ = ["com","wiris","quizzes","impl","ui","component","AnswerFeedbackComponent"];
com.wiris.quizzes.impl.ui.component.AnswerFeedbackComponent.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.quizzes.impl.ui.component.AnswerFeedbackComponent.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	getFeedbackText: function() {
		return "";
	}
	,getAssertion: function(name,slot,authorAnswer) {
		if(com.wiris.quizzes.impl.Assertion.isSyntacticName(name) && slot.getSyntax().getName() == com.wiris.quizzes.impl.QuizzesEnumUtils.string2SyntaxName(name)) return slot.getSyntax(); else if(com.wiris.quizzes.impl.Assertion.isEquivalenceName(name) && authorAnswer.getComparison().getName() == com.wiris.quizzes.impl.QuizzesEnumUtils.string2ComparisonName(name)) return authorAnswer.getComparison(); else if(!com.wiris.quizzes.impl.Assertion.isEquivalenceName(name) && !com.wiris.quizzes.impl.Assertion.isSyntacticName(name)) return authorAnswer.getValidation(com.wiris.quizzes.impl.QuizzesEnumUtils.string2ValidationName(name));
		return null;
	}
	,showAssertionsFeedback: function(visible) {
		this.assertionsFeedback = visible;
	}
	,showCorrectAnswerFeedback: function(visible) {
		this.correctAnswerFeedback = visible;
	}
	,isAssertionDisplayed: function(assertion) {
		return !(assertion == com.wiris.quizzes.impl.Assertion.EQUIVALENT_ALL) && !com.wiris.quizzes.impl.Assertion.isSyntacticName(assertion);
	}
	,getCompoundAnswerFeedback: function(answer) {
		var feedback = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
		feedback.addClass(com.wiris.quizzes.impl.ui.component.AnswerFeedbackComponent.CLASS_STUDENT_ANSWER_FEEDBACK);
		feedback.addComponent(this.answerFeedbackLabels[answer + 1]);
		feedback.addComponent(this.assertionFeedbackLists[answer]);
		return feedback;
	}
	,getAssertionFeedback: function(assertionName,slot,authorAnswer) {
		var assertion = this.getAssertion(assertionName,slot,authorAnswer);
		var feedback = this.context.t("quizzes_studio_test_question_student_answer_feedback_assertion_" + assertionName + "_label");
		if(assertion != null && assertion.parameters != null) {
			if(assertion.name == com.wiris.quizzes.impl.Assertion.CHECK_PRECISION) {
				var min = assertion.getParam("min");
				var max = assertion.getParam("max");
				if("" == min && "" == max) return null; else if("" == min && !("" == max)) feedback = this.context.t("quizzes_studio_test_question_student_answer_feedback_assertion_check_precision_max_label"); else if(!("" == min) && "" == max) feedback = this.context.t("quizzes_studio_test_question_student_answer_feedback_assertion_check_precision_min_label"); else if(min == max) feedback = this.context.t("quizzes_studio_test_question_student_answer_feedback_assertion_check_precision_equal_label"); else feedback = this.context.t("quizzes_studio_test_question_student_answer_feedback_assertion_check_precision_label");
				feedback = StringTools.replace(feedback,"${min}",min);
				feedback = StringTools.replace(feedback,"${max}",max);
				feedback = StringTools.replace(feedback,"${relative}",this.context.t(assertion.getParam("relative") == "true"?"quizzes_studio_test_question_student_answer_feedback_assertion_check_precision_significant_figures_label":"quizzes_studio_test_question_student_answer_feedback_assertion_check_precision_decimal_places_label"));
			} else {
				var j = HxOverrides.iter(assertion.parameters);
				while(j.hasNext()) {
					var param = j.next();
					feedback = StringTools.replace(feedback,"${" + param.name + "}",param.content);
				}
			}
		}
		return feedback;
	}
	,getCompoundAnswers: function(correctAnswer) {
		var mathContent = new com.wiris.quizzes.impl.MathContent();
		mathContent.set(correctAnswer);
		var compoundAnswers = com.wiris.quizzes.impl.CompoundAnswerParser.parseCompoundAnswer(mathContent);
		var i = HxOverrides.iter(compoundAnswers);
		while(i.hasNext()) {
			var answer = i.next();
			answer[0] = StringTools.replace(answer[0],"<mo>=</mo>","");
		}
		return compoundAnswers;
	}
	,resetPreviewAnswerFeedback: function(instance,slot,authorAnswer) {
		instance.clearChecks();
		this.setPreviewAnswerFeedback(instance,slot,authorAnswer);
	}
	,getAssertionCheckByName: function(assertionChecks,name) {
		var i = HxOverrides.iter(assertionChecks);
		while(i.hasNext()) {
			var assertionCheck = i.next();
			if(assertionCheck.getAssertionName() == name) return assertionCheck;
		}
		return null;
	}
	,createListItem: function(name,value,slot,authorAnswer,feedbackList) {
		var primary;
		var feedback = this.getAssertionFeedback(name,slot,authorAnswer);
		if(value == 1.0) {
			primary = com.wiris.util.ui.component.IconBox.newWithMaterialIcon("check");
			primary.getStyle().setForegroundColor(com.wiris.util.graphics.Color.fromText("#318849"));
		} else if(value == 0.0) {
			primary = com.wiris.util.ui.component.IconBox.newWithMaterialIcon("clear");
			primary.getStyle().setForegroundColor(com.wiris.util.graphics.Color.fromText("#FF0000"));
		} else if(value < 0) {
			primary = com.wiris.util.ui.component.IconBox.newWithMaterialIcon("check");
			primary.setVisible(false);
		} else {
			primary = new com.wiris.util.ui.component.ProgressCircle();
			primary.setProgress(value * 100);
		}
		return feedbackList.addItem(primary,feedback,null);
	}
	,createLabel: function(feedback,compoundName,color) {
		var label;
		if(compoundName != null) {
			var labels = new Array();
			labels.push(com.wiris.quizzes.impl.ui.component.MathLabel.newWithText(compoundName));
			labels.push(com.wiris.util.ui.component.Label.newWithText(" — "));
			labels.push(com.wiris.util.ui.component.Label.newWithText(feedback));
			label = com.wiris.util.ui.component.CompositeLabel.newImportantFromLabelArray(labels);
		} else label = com.wiris.util.ui.component.Label.newImportantWithText(feedback);
		label.getStyle().setMargin(8,0,0,0).setForegroundColor(color);
		return label;
	}
	,createAssertionFeedbackListImpl: function(assertionChecks,comparison,validations,slot,authorAnswer,fromCompoundPart) {
		var feedbackList = new com.wiris.util.ui.component.List();
		feedbackList.getStyle().setWidth(450);
		if(comparison != null) {
			var comparisonName = com.wiris.quizzes.impl.QuizzesEnumUtils.comparisonName2String(comparison.getName());
			if(this.isAssertionDisplayed(comparisonName)) {
				var check = this.getAssertionCheckByName(assertionChecks,comparisonName);
				if(check != null) this.createListItem(comparisonName,check.getValue(),slot,authorAnswer,feedbackList); else this.createListItem(comparisonName,-1,slot,authorAnswer,feedbackList);
			}
		}
		if(validations != null) {
			if(slot.getSyntax().getName() == com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC && fromCompoundPart) validations = this.removeAssertion(validations,com.wiris.quizzes.api.assertion.ValidationName.CHECK_NO_SUPERFLUOUS);
			var _g = 0;
			while(_g < validations.length) {
				var v = validations[_g];
				++_g;
				var validationName = com.wiris.quizzes.impl.QuizzesEnumUtils.validationName2String(v.getName());
				if(this.isAssertionDisplayed(validationName)) {
					var check = this.getAssertionCheckByName(assertionChecks,validationName);
					if(check != null) this.createListItem(validationName,check.getValue(),slot,authorAnswer,feedbackList); else this.createListItem(validationName,-1,slot,authorAnswer,feedbackList);
				}
			}
		}
		return feedbackList;
	}
	,createAssertionFeedbackList: function(assertionChecks,slot,authorAnswer,fromCompoundPart) {
		return this.createAssertionFeedbackListImpl(assertionChecks,authorAnswer.getComparison(),authorAnswer.getValidations(),slot,authorAnswer,fromCompoundPart);
	}
	,createAnswerFeedbackLabel: function(grade,compoundName) {
		if(compoundName == null) {
			if(grade == 1) return this.createLabel(this.context.t(com.wiris.quizzes.impl.ui.component.AnswerFeedbackComponent.STUDENT_ANSWER_FEEDBACK_LABEL_CORRECT),null,com.wiris.util.graphics.Color.fromText("#318849")); else if(grade == 0) return this.createLabel(this.context.t(com.wiris.quizzes.impl.ui.component.AnswerFeedbackComponent.STUDENT_ANSWER_FEEDBACK_LABEL_ERROR),null,com.wiris.util.graphics.Color.fromText("#FF0000")); else if(grade < 0) return this.createLabel(this.context.t(com.wiris.quizzes.impl.ui.component.AnswerFeedbackComponent.STUDENT_ANSWER_FEEDBACK_LABEL_INDETERMINATE),null,null); else return this.createLabel(Math.round(grade * 100) + "% " + this.context.t(com.wiris.quizzes.impl.ui.component.AnswerFeedbackComponent.STUDENT_ANSWER_FEEDBACK_LABEL_PARTIALLY_CORRECT),null,com.wiris.util.graphics.Color.fromText("#C99A08"));
		} else if(grade == 1) return this.createLabel(this.context.t(com.wiris.quizzes.impl.ui.component.AnswerFeedbackComponent.STUDENT_ANSWER_FEEDBACK_LABEL_CORRECT),compoundName,com.wiris.util.graphics.Color.fromText("#318849")); else if(grade == 0) return this.createLabel(this.context.t(com.wiris.quizzes.impl.ui.component.AnswerFeedbackComponent.STUDENT_ANSWER_FEEDBACK_LABEL_ERROR),compoundName,com.wiris.util.graphics.Color.fromText("#FF0000")); else if(grade < 0) return this.createLabel(this.context.t(com.wiris.quizzes.impl.ui.component.AnswerFeedbackComponent.STUDENT_ANSWER_FEEDBACK_LABEL_INDETERMINATE),compoundName,null); else return this.createLabel(Math.round(grade * 100) + "% " + this.context.t(com.wiris.quizzes.impl.ui.component.AnswerFeedbackComponent.STUDENT_ANSWER_FEEDBACK_LABEL_PARTIALLY_CORRECT),compoundName,com.wiris.util.graphics.Color.fromText("#C99A08"));
	}
	,createFeedback: function(questionInstance,slot,authorAnswer,compoundName,index,showAssertionsFeedback) {
		if(this.correctAnswerFeedback) {
			var label;
			if(questionInstance != null && questionInstance.hasEvaluation()) {
				var grade = compoundName != null?questionInstance.getCompoundGrade(slot,authorAnswer,index):questionInstance.getGrade(slot,authorAnswer);
				label = this.createAnswerFeedbackLabel(grade,compoundName);
			} else label = this.createAnswerFeedbackLabel(-1,compoundName);
			this.answerFeedbackLabels.push(label);
			this.addComponent(label);
		}
		if(showAssertionsFeedback && this.assertionsFeedback) {
			var feedbackList;
			if(questionInstance != null) {
				if(compoundName != null) feedbackList = this.createAssertionFeedbackList(questionInstance.getMatchingCompoundChecks(slot,authorAnswer,index),slot,authorAnswer,true); else feedbackList = this.createAssertionFeedbackList(questionInstance.getMatchingChecks(slot,authorAnswer),slot,authorAnswer,false);
			} else feedbackList = this.createAssertionFeedbackList(new Array(),slot,authorAnswer,compoundName != null);
			this.assertionFeedbackLists.push(feedbackList);
			this.addComponent(feedbackList);
		}
	}
	,removeAssertion: function(assertions,toRemove) {
		if(assertions == null || toRemove == null) return assertions;
		var found = false;
		var _g = 0;
		while(_g < assertions.length) {
			var validation = assertions[_g];
			++_g;
			if(validation.getName() == toRemove) {
				found = true;
				break;
			}
		}
		if(!found) return assertions;
		var validations = new Array();
		var counter = 0;
		var _g = 0;
		while(_g < assertions.length) {
			var validation = assertions[_g];
			++_g;
			if(validation.getName() != toRemove) validations[counter++] = validation;
		}
		return validations;
	}
	,beautyPrintId: function(id) {
		if(!com.wiris.util.type.StringUtils.contains(id,"$")) return id;
		var parts = id.split("$");
		return parts[0] + ", part " + (Std.parseInt(parts[1]) + 1);
	}
	,setPreviewAnswerFeedback: function(questionInstance,slot,authorAnswer) {
		this.removeAllComponents();
		var compound = slot.getProperty(com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER) == com.wiris.quizzes.api.QuizzesConstants.PROPERTY_VALUE_COMPOUND_ANSWER_TRUE;
		this.createFeedback(questionInstance,slot,authorAnswer,null,0,!compound);
		if(compound) {
			if(slot.getSyntax().getName() == com.wiris.quizzes.api.assertion.SyntaxName.MATH) {
				var correctAnswers = slot.getAuthorAnswers();
				var correctAnswer = correctAnswers.length == 0?"":correctAnswers[0].getValue();
				var i = HxOverrides.iter(com.wiris.quizzes.impl.ui.component.QuizzesCompoundTextField.expandCompoundAnswerLabelVariables(this.getCompoundAnswers(correctAnswer),questionInstance));
				var index = 0;
				while(i.hasNext()) {
					var answer = i.next();
					this.createFeedback(questionInstance,slot,authorAnswer,answer[0],index++,true);
				}
			} else if(slot.getSyntax().getName() == com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC) {
				var ids = com.wiris.quizzes.impl.QuizzesImpl.getInstance().getElementsToGradeFromAuthorAnswer(authorAnswer);
				var index = 0;
				var _g = 0;
				while(_g < ids.length) {
					var s = ids[_g];
					++_g;
					var label = "<math><mtext>" + this.beautyPrintId(s) + "</mtext></math>";
					this.createFeedback(questionInstance,slot,authorAnswer,label,index++,true);
				}
				if(authorAnswer.getValidation(com.wiris.quizzes.api.assertion.ValidationName.CHECK_NO_SUPERFLUOUS) != null) {
					var assertionChecks = questionInstance != null?questionInstance.getMatchingChecks(slot,authorAnswer):new Array();
					var feedbackList = this.createAssertionFeedbackListImpl(assertionChecks,null,[authorAnswer.getValidation(com.wiris.quizzes.api.assertion.ValidationName.CHECK_NO_SUPERFLUOUS)],slot,authorAnswer,false);
					feedbackList.getStyle().setMargin(28,0,0,0);
					this.assertionFeedbackLists.push(feedbackList);
					this.addComponent(feedbackList);
				}
			}
		}
	}
	,isShowFeedback: function() {
		return this.correctAnswerFeedback || this.assertionsFeedback;
	}
	,context: null
	,assertionsFeedback: null
	,correctAnswerFeedback: null
	,assertionFeedbackLists: null
	,answerFeedbackLabels: null
	,__class__: com.wiris.quizzes.impl.ui.component.AnswerFeedbackComponent
});
com.wiris.quizzes.impl.ui.component.AuthoringFieldComponent = $hxClasses["com.wiris.quizzes.impl.ui.component.AuthoringFieldComponent"] = function() { }
com.wiris.quizzes.impl.ui.component.AuthoringFieldComponent.__name__ = ["com","wiris","quizzes","impl","ui","component","AuthoringFieldComponent"];
com.wiris.quizzes.impl.ui.component.AuthoringFieldComponent.prototype = {
	innerContentChanged: null
	,saveQuestion: null
	,getComponent: null
	,__class__: com.wiris.quizzes.impl.ui.component.AuthoringFieldComponent
}
com.wiris.util.ui.component.InputComponent = $hxClasses["com.wiris.util.ui.component.InputComponent"] = function() {
	com.wiris.util.ui.component.Component.call(this);
	this.status = com.wiris.util.ui.component.InputComponent.STATUS_INDETERMINATE;
	this.addClass(com.wiris.util.ui.component.InputComponent.CLASS_INPUT_COMPONENT);
	this.inputComponentListeners = new Array();
};
com.wiris.util.ui.component.InputComponent.__name__ = ["com","wiris","util","ui","component","InputComponent"];
com.wiris.util.ui.component.InputComponent.__super__ = com.wiris.util.ui.component.Component;
com.wiris.util.ui.component.InputComponent.prototype = $extend(com.wiris.util.ui.component.Component.prototype,{
	getStatus: function() {
		return this.status;
	}
	,setStatus: function(status) {
		this.status = status;
		if(status == com.wiris.util.ui.component.InputComponent.STATUS_INDETERMINATE) {
			this.removeClass(com.wiris.util.ui.component.InputComponent.CLASS_INPUT_COMPONENT_CORRECT);
			this.removeClass(com.wiris.util.ui.component.InputComponent.CLASS_INPUT_COMPONENT_WARNING);
			this.removeClass(com.wiris.util.ui.component.InputComponent.CLASS_INPUT_COMPONENT_ERROR);
		} else if(status == com.wiris.util.ui.component.InputComponent.STATUS_CORRECT) {
			this.addClass(com.wiris.util.ui.component.InputComponent.CLASS_INPUT_COMPONENT_CORRECT);
			this.removeClass(com.wiris.util.ui.component.InputComponent.CLASS_INPUT_COMPONENT_WARNING);
			this.removeClass(com.wiris.util.ui.component.InputComponent.CLASS_INPUT_COMPONENT_ERROR);
		} else if(status == com.wiris.util.ui.component.InputComponent.STATUS_WARNING) {
			this.removeClass(com.wiris.util.ui.component.InputComponent.CLASS_INPUT_COMPONENT_CORRECT);
			this.addClass(com.wiris.util.ui.component.InputComponent.CLASS_INPUT_COMPONENT_WARNING);
			this.removeClass(com.wiris.util.ui.component.InputComponent.CLASS_INPUT_COMPONENT_ERROR);
		} else if(status == com.wiris.util.ui.component.InputComponent.STATUS_ERROR) {
			this.removeClass(com.wiris.util.ui.component.InputComponent.CLASS_INPUT_COMPONENT_CORRECT);
			this.removeClass(com.wiris.util.ui.component.InputComponent.CLASS_INPUT_COMPONENT_WARNING);
			this.addClass(com.wiris.util.ui.component.InputComponent.CLASS_INPUT_COMPONENT_ERROR);
		} else this.status = com.wiris.util.ui.component.InputComponent.STATUS_INDETERMINATE;
	}
	,componentSet: function() {
		var _g = 0, _g1 = this.inputComponentListeners;
		while(_g < _g1.length) {
			var listener = _g1[_g];
			++_g;
			listener.onSetComponent(this);
		}
	}
	,addInputComponentListener: function(listener) {
		this.inputComponentListeners.push(listener);
	}
	,status: null
	,inputComponentListeners: null
	,__class__: com.wiris.util.ui.component.InputComponent
});
com.wiris.util.ui.component.Field = $hxClasses["com.wiris.util.ui.component.Field"] = function() { }
com.wiris.util.ui.component.Field.__name__ = ["com","wiris","util","ui","component","Field"];
com.wiris.util.ui.component.Field.prototype = {
	getComponent: null
	,setValue: null
	,getValue: null
	,__class__: com.wiris.util.ui.component.Field
}
com.wiris.quizzes.impl.ui.component.MathTypeInputComponent = $hxClasses["com.wiris.quizzes.impl.ui.component.MathTypeInputComponent"] = function(parameters,autoHandleSize) {
	com.wiris.util.ui.component.InputComponent.call(this);
	this.addClass(com.wiris.quizzes.impl.ui.component.MathTypeInputComponent.CLASS_MATH_TYPE_COMPONENT);
	this.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT);
	this.autoHandleSize = autoHandleSize;
	if(this.autoHandleSize) this.getStyle().setMaxWidth(450).setHeight(200);
	this.handOpen = false;
	this.readOnly = false;
	this.focusRequested = false;
	this.parameters = parameters == null?new Hash():parameters;
	if(this.autoHandleSize) this.placeholder = com.wiris.util.ui.ImageIcon.newFromFile("mathtype-placeholder.png");
	if(this.parameters.get("language") == null) this.parameters.set("language",com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().getLanguage());
	if(this.parameters.get("toolbar") == null) this.parameters.set("toolbar","quizzes");
	if(this.parameters.get("forceReservedWords") == null) this.parameters.set("forceReservedWords","true");
	if(this.parameters.get("autoformat") == null) this.parameters.set("autoformat","true");
	if(this.parameters.get("nudging") == null) this.parameters.set("nudging","false");
	if(this.parameters.get("notifyContainer") == null) this.parameters.set("notifyContainer","true");
	if(this.parameters.get("hand") == null) {
		var hand = com.wiris.quizzes.api.Quizzes.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.HAND_ENABLED);
		this.parameters.set("hand",hand.toLowerCase() == "true"?"true":"false");
	}
	if(this.parameters.get("basePath") == null && this.isOffline()) this.parameters.set("basePath",com.wiris.quizzes.api.Quizzes.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.EDITOR_URL));
	this.parameters.set("deploymentId",com.wiris.quizzes.api.Quizzes.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.DEPLOYMENT_ID));
	this.parameters.set("licenseId",com.wiris.quizzes.api.Quizzes.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.LICENSE_ID));
};
com.wiris.quizzes.impl.ui.component.MathTypeInputComponent.__name__ = ["com","wiris","quizzes","impl","ui","component","MathTypeInputComponent"];
com.wiris.quizzes.impl.ui.component.MathTypeInputComponent.__interfaces__ = [com.wiris.editor.EditorListener,com.wiris.util.ui.component.Field];
com.wiris.quizzes.impl.ui.component.MathTypeInputComponent.newWithValue = function(value,parameters) {
	var mathType = new com.wiris.quizzes.impl.ui.component.MathTypeInputComponent(parameters,true);
	mathType.setValue(value);
	return mathType;
}
com.wiris.quizzes.impl.ui.component.MathTypeInputComponent.__super__ = com.wiris.util.ui.component.InputComponent;
com.wiris.quizzes.impl.ui.component.MathTypeInputComponent.prototype = $extend(com.wiris.util.ui.component.InputComponent.prototype,{
	transformationReceived: function(source,transformation) {
	}
	,styleChanged: function(source) {
	}
	,contentChanged: function(source) {
		if(this.value == null || !(this.value == this.editor.getMathMLWithAnnotations())) this.setValue(this.editor.getMathMLWithAnnotations());
		var handOpen = this.editor.isHandOpen();
		if(handOpen != this.handOpen && this.autoHandleSize) {
			this.handOpen = handOpen;
			if(this.handOpen) {
				this.getStyle().setMaxWidth(800);
				this.performAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.MathTypeInputComponent.ACTION_HAND_OPENED_ID,null));
			} else {
				this.getStyle().setMaxWidth(450);
				this.performAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.MathTypeInputComponent.ACTION_HAND_CLOSED_ID,null));
			}
		}
	}
	,clipboardChanged: function(source) {
	}
	,caretPositionChanged: function(source) {
	}
	,getChangeAction: function() {
		return this.changeAction;
	}
	,setChangeAction: function(changeAction) {
		this.changeAction = changeAction;
	}
	,isOffline: function() {
		var offline = com.wiris.quizzes.api.Quizzes.getInstance().getConfiguration().get(com.wiris.quizzes.api.ConfigurationKeys.SERVICE_OFFLINE);
		return offline.toLowerCase() == "true";
	}
	,getComponent: function() {
		return this;
	}
	,requestFocus: function() {
		if(this.editor != null) {
			com.wiris.util.ui.component.InputComponent.prototype.requestFocus.call(this);
			this.editor.focus();
		} else this.focusRequested = true;
		return this;
	}
	,areCurrentAndNewEmptyMathML: function(value) {
		try {
			return (this.value == null || com.wiris.quizzes.impl.MathContent.isEmpty(this.value)) && (value == null || com.wiris.quizzes.impl.MathContent.isEmpty(value));
		} catch( e ) {
			return false;
		}
	}
	,setValue: function(value) {
		if(value == null || value == "") value = com.wiris.quizzes.impl.ui.component.MathTypeInputComponent.EMPTY_MATHML;
		if(!(com.wiris.quizzes.impl.MathContent.getMathType(value) == com.wiris.quizzes.impl.MathContent.TYPE_MATHML)) value = new com.wiris.quizzes.impl.HTMLTools().textToMathML(value);
		if(this.value == null || !(this.value == value) && !this.areCurrentAndNewEmptyMathML(value)) {
			this.value = value;
			if(this.editor != null && !(value == this.editor.getMathMLWithAnnotations())) this.editor.setMathML(value);
			if(this.changeAction != null) this.performAction(this.changeAction);
		}
	}
	,getValue: function() {
		return this.value != null?this.value:com.wiris.quizzes.impl.ui.component.MathTypeInputComponent.EMPTY_MATHML;
	}
	,setGrammarUrl: function(grammarUrl,check) {
		var parameters = new Hash();
		parameters.set("grammarURL",grammarUrl);
		parameters.set("checkSyntax",check?"true":"false");
		this.setParameters(parameters);
	}
	,setParameters: function(parameters) {
		if(parameters != null) {
			var i = parameters.keys();
			var parametersChanged = false;
			while(i.hasNext()) {
				var key = i.next();
				if(!(parameters.get(key) == this.parameters.get(key))) {
					this.parameters.set(key,parameters.get(key));
					parametersChanged = true;
				}
			}
			if(this.editor != null) {
				if(parametersChanged) {
					this.editor.setParams(this.parameters);
					if(!(this.editor.getMathMLWithAnnotations() == this.getValue())) {
						this.value = this.editor.getMathMLWithAnnotations();
						this.performAction(this.changeAction);
					}
				}
			}
		}
	}
	,setEditor: function(editor) {
		this.editor = editor;
		this.editor.getEditorModel().addEditorListener(this);
		if(this.value != null) this.editor.setMathML(this.value); else this.setValue(this.editor.getMathMLWithAnnotations());
		if(this.focusRequested) {
			this.requestFocus();
			this.focusRequested = false;
		}
		this.componentSet();
	}
	,setReadOnly: function(readOnly) {
		this.readOnly = readOnly;
		var p = new Hash();
		var value = this.readOnly?"true":"false";
		p.set("readOnly",value);
		this.setParameters(p);
	}
	,getParameters: function() {
		return this.parameters;
	}
	,getPlaceholder: function() {
		return this.placeholder;
	}
	,getEditor: function() {
		return this.editor;
	}
	,isEmpty: function() {
		return this.value == null || this.value == "" || com.wiris.quizzes.impl.MathContent.isEmpty(this.value);
	}
	,isReadOnly: function() {
		return this.readOnly;
	}
	,autoHandleSize: null
	,changeAction: null
	,focusRequested: null
	,readOnly: null
	,handOpen: null
	,lang: null
	,value: null
	,reservedWords: null
	,parameters: null
	,editor: null
	,placeholder: null
	,__class__: com.wiris.quizzes.impl.ui.component.MathTypeInputComponent
});
com.wiris.quizzes.impl.ui.component.AuthoringFieldMathTypeComponent = $hxClasses["com.wiris.quizzes.impl.ui.component.AuthoringFieldMathTypeComponent"] = function(context,parameters) {
	com.wiris.quizzes.impl.ui.component.MathTypeInputComponent.call(this,parameters,true);
	this.slot = context.getSlot();
	this.authorAnswer = context.getAuthorAnswer();
	this.setValue(this.authorAnswer.getValue());
	this.setGrammarUrl(this.getGrammarUrl(),true);
	new com.wiris.quizzes.impl.ui.controller.ReservedWordsRequestController(this).update();
	this.setChangeAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.AuthoringFieldMathTypeComponent.CONTENT_CHANGED,null));
	this.addActionListener(this);
};
com.wiris.quizzes.impl.ui.component.AuthoringFieldMathTypeComponent.__name__ = ["com","wiris","quizzes","impl","ui","component","AuthoringFieldMathTypeComponent"];
com.wiris.quizzes.impl.ui.component.AuthoringFieldMathTypeComponent.__interfaces__ = [com.wiris.util.ui.interaction.ActionListener,com.wiris.quizzes.impl.ui.component.AuthoringFieldComponent,com.wiris.quizzes.impl.ui.controller.ReservedWordsConsumer];
com.wiris.quizzes.impl.ui.component.AuthoringFieldMathTypeComponent.__super__ = com.wiris.quizzes.impl.ui.component.MathTypeInputComponent;
com.wiris.quizzes.impl.ui.component.AuthoringFieldMathTypeComponent.prototype = $extend(com.wiris.quizzes.impl.ui.component.MathTypeInputComponent.prototype,{
	innerContentChanged: function() {
		this.saveQuestion();
	}
	,saveQuestion: function() {
		this.authorAnswer.setValue(this.getValue());
		this.performAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.AuthoringFieldImpl.AUTHORING_FIELD_CONTENT_CHANGED,com.wiris.quizzes.impl.ui.AuthoringFieldImpl.AUTHORING_FIELD_CONTENT_CHANGED));
	}
	,actionPerformed: function(e) {
		if(e.getAction().getId() == com.wiris.quizzes.impl.ui.component.AuthoringFieldMathTypeComponent.CONTENT_CHANGED) this.innerContentChanged();
	}
	,getType: function() {
		return com.wiris.quizzes.api.ui.AuthoringFieldType.INLINE_MATH_EDITOR;
	}
	,getComponent: function() {
		return this;
	}
	,setMathtypeParameters: function(parameters) {
		this.setParameters(parameters);
	}
	,getGrammarUrl: function() {
		var grammarUrl = this.slot.getGrammarUrl();
		grammarUrl += grammarUrl.indexOf("?") != -1?"&":"?";
		grammarUrl += "reservedWords=true&measureUnits=true&json=true";
		return grammarUrl;
	}
	,slot: null
	,authorAnswer: null
	,__class__: com.wiris.quizzes.impl.ui.component.AuthoringFieldMathTypeComponent
});
com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent = $hxClasses["com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent"] = function() {
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.addClass(com.wiris.util.ui.component.Panel.CLASS_PANEL_CARD).addClass(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.CLASS_AUTHORING_FIELD_SUMMARY);
	this.getStyle().setWidth(com.wiris.util.ui.Style.SIZE_FULL).setMargin(24,0,0,0);
	this.label = com.wiris.util.ui.component.Label.newHeaderWithText(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_TITLE));
	this.summaryFields = new com.wiris.util.ui.component.List();
	this.addComponent(this.label);
	this.addComponent(this.summaryFields);
};
com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.__name__ = ["com","wiris","quizzes","impl","ui","component","AuthoringFieldSummaryComponent"];
com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	buildProperties: function(properties) {
		var stringBuffer = new StringBuf();
		var i;
		var _g1 = 0, _g = properties.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(i1 > 0) stringBuffer.b += Std.string(", ");
			stringBuffer.b += Std.string(properties[i1]);
		}
		return stringBuffer.b;
	}
	,getToleranceText: function(qimpl,tolerance,digits,relative) {
		if(tolerance == null) tolerance = qimpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_TOLERANCE);
		if(relative == null) relative = qimpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_RELATIVE_TOLERANCE);
		if(digits == null) digits = qimpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_TOLERANCE_DIGITS);
		var options = "";
		if(!(digits == qimpl.defaultOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_TOLERANCE_DIGITS))) {
			if(relative == "true") options = digits + " " + com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_SIGNIFICANT_FIGURES_LABEL); else options = digits + " " + com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_DECIMAL_PLACES_LABEL);
		} else if(!(relative == qimpl.defaultOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_RELATIVE_TOLERANCE)) || !(tolerance == qimpl.defaultOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_TOLERANCE))) {
			if(relative == "true") options = com.wiris.system.TypeTools.floatToString(Std.parseFloat(tolerance) * 100) + com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_PERCENT_ERROR_LABEL); else options = tolerance + " " + com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_ABSOLUTE_ERROR_LABEL);
		}
		return options;
	}
	,shortenText: function(text,chars) {
		if(text.length > chars) {
			text = HxOverrides.substr(text,0,chars - 3);
			var n = text.length - 1;
			var c = HxOverrides.cca(text,n);
			while(c == 32 || c == 44 || c == 46) {
				text = HxOverrides.substr(text,0,n--);
				c = HxOverrides.cca(text,n);
			}
			text += "...";
		}
		return text;
	}
	,getAssertionString: function(assertion,qimpl,chars) {
		var text = com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(assertion.name);
		var tolerance = null;
		var toleranceDigits = null;
		var relativeTolerance = null;
		var stringBuffer = new StringBuf();
		var count = 0;
		if(assertion.parameters != null) {
			var i;
			var _g1 = 0, _g = assertion.parameters.length;
			while(_g1 < _g) {
				var i1 = _g1++;
				var assertionParam = assertion.parameters[i1];
				if(assertionParam.name == com.wiris.quizzes.impl.Assertion.PARAM_ORDER_MATTERS && !(assertionParam.content == "true")) {
					if(count++ > 0) stringBuffer.b += Std.string(", ");
					stringBuffer.b += Std.string(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t("comparesets"));
				} else if(assertionParam.name == com.wiris.quizzes.impl.Assertion.PARAM_REPETITION_MATTERS) {
				} else if(assertionParam.name == com.wiris.quizzes.api.QuizzesConstants.OPTION_TOLERANCE) tolerance = assertionParam.content; else if(assertionParam.name == com.wiris.quizzes.api.QuizzesConstants.OPTION_TOLERANCE_DIGITS) toleranceDigits = assertionParam.content; else if(assertionParam.name == com.wiris.quizzes.api.QuizzesConstants.OPTION_RELATIVE_TOLERANCE) relativeTolerance = assertionParam.content; else if(assertionParam.content == "true") {
					if(count++ > 0) stringBuffer.b += Std.string(", ");
					stringBuffer.b += Std.string(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(assertionParam.name));
				} else if(assertionParam.content == "false") {
				} else if(assertionParam.content == com.wiris.quizzes.impl.Assertion.getParameterDefaultValue(assertion.name,assertionParam.name)) {
				} else if(assertionParam.name == com.wiris.quizzes.impl.Assertion.PARAM_MIN) stringBuffer.b += Std.string(" " + com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_FROM_PRECISION_LABEL) + " " + assertionParam.content); else if(assertionParam.name == com.wiris.quizzes.impl.Assertion.PARAM_MAX) stringBuffer.b += Std.string(" " + com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_UP_TO_PRECISION_LABEL) + " " + assertionParam.content); else {
					if(count++ > 0) stringBuffer.b += Std.string(", ");
					stringBuffer.b += Std.string(this.shortenText(assertionParam.content,Math.round(chars / 3.0) | 0));
				}
			}
		}
		var parameters = stringBuffer.b;
		if(assertion.isEquivalence()) {
			var toleranceText = this.getToleranceText(qimpl,tolerance,toleranceDigits,relativeTolerance);
			if(!(toleranceText == "")) {
				if(count++ > 0) toleranceText += ", ";
				parameters = toleranceText + parameters;
			}
		}
		if(assertion.name == com.wiris.quizzes.impl.Assertion.CHECK_PRECISION) {
			if(assertion.getParam(com.wiris.quizzes.impl.Assertion.PARAM_RELATIVE) == "true") text += parameters + " " + com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_SIGNIFICANT_FIGURES_LABEL); else text += parameters + " " + com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_DECIMAL_PLACES_LABEL);
		} else if(count > 0) {
			parameters = this.shortenText(parameters,chars - text.length - 3);
			text += " (" + parameters + ")";
		}
		return text;
	}
	,updateSummary: function(context) {
		this.clearSummaryFields();
		this.setVisible(false);
		var syntax = null;
		var equivalent = null;
		var variables = null;
		var properties = new Array();
		var showSyntax = false;
		var showComparison = false;
		var showProperties = false;
		var showAlgorithm = false;
		var qimpl = context.getQuestion().getImpl();
		var slot = context.getSlot();
		var authorAnswer = context.getAuthorAnswer();
		if(slot.getSyntax().getName() != com.wiris.quizzes.api.assertion.SyntaxName.MATH) {
			showSyntax = true;
			syntax = this.getAssertionString(slot.getSyntax(),qimpl,80);
		}
		if(authorAnswer.getComparison().getName() != com.wiris.quizzes.api.assertion.ComparisonName.MATHEMATICALLY_EQUAL) {
			showComparison = true;
			equivalent = this.getAssertionString(authorAnswer.getComparison(),qimpl,80);
		}
		if(authorAnswer.getValidations().length > 0) {
			showProperties = true;
			var validations = authorAnswer.getValidations();
			var _g = 0;
			while(_g < validations.length) {
				var v = validations[_g];
				++_g;
				properties.push(this.getAssertionString(v,qimpl,80));
			}
		}
		if(qimpl.wirisCasSession != null && qimpl.wirisCasSession.length > 0) {
			showAlgorithm = true;
			variables = com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_HAS_ALGORITHM_LABEL);
			if(!(qimpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_PRECISION) == qimpl.defaultOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_PRECISION))) variables += ", " + com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_PRECISION_LABEL) + ": " + qimpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_PRECISION);
		}
		if(showSyntax || showComparison || showProperties || showAlgorithm) {
			this.setVisible(true);
			if(showSyntax) this.addSyntaxSummaryField(syntax);
			if(showComparison) this.addComparisonSummaryField(equivalent);
			if(showProperties) this.addPropertiesSummaryField(this.buildProperties(properties));
			if(showAlgorithm) this.addAlgorithmSummaryField(variables);
		}
	}
	,clearSummaryFields: function() {
		this.summaryFields.removeAllComponents();
	}
	,addSummaryField: function(id,title,description) {
		var titleLabel = com.wiris.util.ui.component.Label.newImportantWithText(title + ":");
		titleLabel.getStyle().setWidth(120);
		var descriptionLabel = com.wiris.util.ui.component.Label.newWithText(description);
		var summaryField = this.summaryFields.addCustomItem(titleLabel,descriptionLabel,null,0);
		summaryField.getStyle().setVerticalAlignment(com.wiris.util.ui.Style.VERTICAL_ALIGNMENT_TOP);
		summaryField.getComponents()[0].getStyle().setHorizontalAlignment(com.wiris.util.ui.Style.HORIZONTAL_ALIGNMENT_RIGHT);
		summaryField.changeStyle();
	}
	,addAlgorithmSummaryField: function(value) {
		this.addSummaryField(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_VARIABLES_ID,com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_VARIABLES_TITLE),value);
	}
	,addPropertiesSummaryField: function(value) {
		this.addSummaryField(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_PROPERTIES_ID,com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_PROPERTIES_TITLE),value);
	}
	,addComparisonSummaryField: function(value) {
		this.addSummaryField(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_COMPARISON_ID,com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_COMPARISON_TITLE),value);
	}
	,addSyntaxSummaryField: function(value) {
		this.addSummaryField(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_ALLOWED_INPUT_ID,com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_ALLOWED_INPUT_TITLE),value);
	}
	,addInputMethodSummaryField: function(value) {
		this.addSummaryField(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_INPUT_METHOD_ID,com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent.QUIZZES_STUDIO_SUMMARY_INPUT_METHOD_TITLE),value);
	}
	,summaryFields: null
	,label: null
	,__class__: com.wiris.quizzes.impl.ui.component.AuthoringFieldSummaryComponent
});
com.wiris.util.ui.component.ActivityPanel = $hxClasses["com.wiris.util.ui.component.ActivityPanel"] = function() {
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.activityContainer = null;
	this.addClass(com.wiris.util.ui.component.ActivityPanel.CLASS_ACTIVITY_PANEL);
};
com.wiris.util.ui.component.ActivityPanel.__name__ = ["com","wiris","util","ui","component","ActivityPanel"];
com.wiris.util.ui.component.ActivityPanel.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.util.ui.component.ActivityPanel.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	returnToPreviousActivity: function() {
		if(this.activityContainer != null) return this.activityContainer.returnToPreviousActivity();
		return false;
	}
	,showActivity: function(activityId) {
		if(this.activityContainer != null) return this.activityContainer.showActivity(activityId);
		return false;
	}
	,setActivityContainer: function(activityContainer) {
		this.activityContainer = activityContainer;
	}
	,getActivityContainer: function() {
		return this.activityContainer;
	}
	,activityContainer: null
	,__class__: com.wiris.util.ui.component.ActivityPanel
});
com.wiris.quizzes.impl.ui.component.AuxiliaryInitialContentActivity = $hxClasses["com.wiris.quizzes.impl.ui.component.AuxiliaryInitialContentActivity"] = function(controller) {
	com.wiris.util.ui.component.ActivityPanel.call(this);
	this.addClass(com.wiris.util.ui.component.Panel.CLASS_PANEL_SOLID);
	this.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setHeightWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT);
	this.controller = controller;
	this.headerLabel = com.wiris.util.ui.component.Label.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.AuxiliaryInitialContentActivity.AUXILIAR_INITIAL_CONTENT_LABEL));
	this.headerLabel.addClass(com.wiris.quizzes.impl.ui.component.AuxiliaryInitialContentActivity.CLASS_CALC_ME_LABEL);
	var parameters = new Hash();
	parameters.set("lang",controller.getLanguage());
	parameters.set("environment","quizzes-studio");
	this.calcMe = new com.wiris.quizzes.impl.ui.component.CalcMeInputComponent(parameters);
	this.calcMe.setId("auxiliaryInitialContentCalcMe");
	this.calcMe.setChangeAction(new com.wiris.util.ui.Action("auxiliaryInitialContentChanged",null));
	this.calcMe.addActionListener(controller);
	this.calcMe.getStyle().setHeightWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT);
	this.addComponent(this.headerLabel);
	this.addComponent(this.calcMe);
};
com.wiris.quizzes.impl.ui.component.AuxiliaryInitialContentActivity.__name__ = ["com","wiris","quizzes","impl","ui","component","AuxiliaryInitialContentActivity"];
com.wiris.quizzes.impl.ui.component.AuxiliaryInitialContentActivity.__super__ = com.wiris.util.ui.component.ActivityPanel;
com.wiris.quizzes.impl.ui.component.AuxiliaryInitialContentActivity.prototype = $extend(com.wiris.util.ui.component.ActivityPanel.prototype,{
	getFunctionNames: function() {
		return this.calcMe.getFunctionNames();
	}
	,getVariableNames: function() {
		return this.calcMe.getVariableNames();
	}
	,setAlgorithm: function(algorithm) {
		this.calcMe.setAlgorithm(algorithm);
	}
	,calcMe: null
	,headerLabel: null
	,controller: null
	,__class__: com.wiris.quizzes.impl.ui.component.AuxiliaryInitialContentActivity
});
com.wiris.quizzes.impl.ui.component.CalcMeInputComponent = $hxClasses["com.wiris.quizzes.impl.ui.component.CalcMeInputComponent"] = function(parameters) {
	com.wiris.util.ui.component.InputComponent.call(this);
	this.addClass(com.wiris.quizzes.impl.ui.component.CalcMeInputComponent.CLASS_CALC_ME_COMPONENT);
	this.lang = null;
	this.parameters = parameters == null?new Hash():parameters;
	if(this.parameters.get("lang") == null) this.parameters.set("lang",this.getLang()); else this.setLang(this.parameters.get("lang"));
	this.parameters.set("warnOnClose","false");
	this.algorithm = null;
	this.updating = false;
	this.pendingActions = new Array();
	this.actionWithParams("hideSideMenu",new Hash());
};
com.wiris.quizzes.impl.ui.component.CalcMeInputComponent.__name__ = ["com","wiris","quizzes","impl","ui","component","CalcMeInputComponent"];
com.wiris.quizzes.impl.ui.component.CalcMeInputComponent.__interfaces__ = [com.wiris.calc.CalcModelListener];
com.wiris.quizzes.impl.ui.component.CalcMeInputComponent.__super__ = com.wiris.util.ui.component.InputComponent;
com.wiris.quizzes.impl.ui.component.CalcMeInputComponent.prototype = $extend(com.wiris.util.ui.component.InputComponent.prototype,{
	removeCookie: function(key) {
	}
	,saveCookie: function(key,value) {
	}
	,interfaceLanguageChanged: function(calc,newLanguage) {
	}
	,authorizationRequested: function(calc) {
	}
	,plotterDownloadRequested: function(content,format,size) {
	}
	,downloadRequested: function(calc,content,title,format,compression) {
	}
	,closeDialogRequested: function(calc,dialog) {
	}
	,openToolkitDialogRequested: function(calc,dialog) {
	}
	,openDialogRequested: function(calc,dialog) {
	}
	,openLinkRequested: function(calc,url) {
	}
	,uploadFileRequested: function(calc) {
	}
	,removeFileRequested: function(calc) {
	}
	,openFileRequested: function(calc) {
	}
	,saveFileRequested: function(calc,content,suggestedPath,saveas) {
	}
	,newFileRequested: function(calc) {
	}
	,isUpdating: function() {
		return this.updating;
	}
	,getFunctionNames: function() {
		return this.calcMe != null?this.calcMe.getFunctionNames(0):new Array();
	}
	,getVariableNames: function() {
		return this.calcMe != null?this.calcMe.getVariableNames(0):new Array();
	}
	,getChangeAction: function() {
		return this.changeAction;
	}
	,setChangeAction: function(changeAction) {
		this.changeAction = changeAction;
	}
	,getCalcMe: function() {
		return this.calcMe;
	}
	,actionWithParams: function(name,parameters) {
		if(this.calcMe != null) this.calcMe.actionWithParams(name,parameters); else {
			var a = new com.wiris.util.ui.Action(name,name);
			var keys = parameters.keys();
			while(keys.hasNext()) {
				var key = keys.next();
				a.setParameter(key,parameters.get(key));
			}
			this.pendingActions.push(a);
		}
	}
	,setAlgorithm: function(algorithm) {
		if(algorithm == null) {
			if(this.calcMe != null) {
				this.updating = true;
				this.calcMe.reset();
				this.updating = false;
				this.algorithm = this.calcMe.getXml();
				if(this.changeAction != null) this.performAction(this.changeAction);
			}
		} else if(!(this.algorithm == algorithm)) {
			this.algorithm = algorithm;
			if(this.calcMe != null && !(algorithm == this.calcMe.getXml())) {
				this.updating = true;
				this.calcMe.setXml(algorithm);
				this.updating = false;
			}
			if(this.changeAction != null) this.performAction(this.changeAction);
		}
	}
	,contentChanged: function(calc) {
		if(this.isUpdating()) return;
		this.setAlgorithm(calc.getXml());
	}
	,executePendingActions: function() {
		while(this.pendingActions.length > 0) {
			var a = this.pendingActions.pop();
			this.actionWithParams(a.getCommand(),a.getParameters());
		}
		if(this.algorithm == null) this.algorithm = this.calcMe.getXml();
	}
	,setCalcModel: function(calc,overrideAlgorithm) {
		this.calcMe = calc;
		if(this.calcMe != null) {
			this.calcMe.addCalcModelListener(this);
			if(this.algorithm != null && overrideAlgorithm) this.calcMe.setXml(this.algorithm);
			this.executePendingActions();
		}
		this.componentSet();
	}
	,calcModelRebuilt: function(newModel) {
		this.setCalcModel(newModel,false);
	}
	,setCalcMe: function(calcMe) {
		this.setCalcModel(calcMe,true);
	}
	,getComponent: function() {
		return this;
	}
	,getValue: function() {
		if(this.calcMe != null) return this.calcMe.getXml(); else return "<wiriscalc/>";
	}
	,setLang: function(lang) {
		this.lang = lang;
		var parameters = new Hash();
		parameters.set("lang",lang);
		this.setParameters(parameters);
	}
	,getLang: function() {
		this.lang = this.lang == null?"en":this.lang;
		return this.lang;
	}
	,setParameters: function(parameters) {
		var i = parameters.keys();
		while(i.hasNext()) {
			var key = i.next();
			this.parameters.set(key,parameters.get(key));
		}
		if(this.calcMe != null) this.changeState();
	}
	,getParameters: function() {
		return this.parameters;
	}
	,pendingActions: null
	,updating: null
	,changeAction: null
	,calcMe: null
	,parameters: null
	,algorithm: null
	,lang: null
	,__class__: com.wiris.quizzes.impl.ui.component.CalcMeInputComponent
});
com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent = $hxClasses["com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent"] = function(controller) {
	this.initialized = false;
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.setId("inputOptionsCompoundAnswerPanel").addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_FULL_SIZE_PANEL);
	this.controller = controller;
	this.label = com.wiris.util.ui.component.Label.newImportantWithText(controller.t(com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent.COMPOUND_ANSWER_FIELD_LABEL));
	var settingsContainer = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	settingsContainer.addClass(com.wiris.util.ui.component.Panel.CLASS_PANEL_CARD);
	this.compoundAnswerTextFields = new Array();
	this.gradeAnswersSeparatelyCheckBox = com.wiris.util.ui.component.CheckBox.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent.COMPOUND_ANSWER_LABEL_GRADE_ANSWER_BOXES_SEPARATELY),controller.t(com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent.COMPOUND_ANSWER_HELPER_TEXT_GRADE_ANSWER_BOXES_SEPARATELY),com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent.COMPOUND_ANSWER_ID_GRADE_ANSWER_BOXES_SEPARATELY,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent.COMPOUND_ANSWER_ID_GRADE_ANSWER_BOXES_SEPARATELY,null),this);
	this.gradeAnswersSeparatelyCheckBox.setId("inputOptionsGradeAnswersSeparately");
	this.gradeAnswersSeparatelyCheckBox.addActionListener(controller);
	this.allAnswersCorrectCheckBox = com.wiris.util.ui.component.CheckBox.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent.COMPOUND_ANSWER_LABEL_ALL_ANSWERS_CORRECT),controller.t(com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent.COMPOUND_ANSWER_HELPER_TEXT_ALL_ANSWERS_CORRECT),com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent.COMPOUND_ANSWER_ID_ALL_ANSWERS_CORRECT,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent.COMPOUND_ANSWER_ID_ALL_ANSWERS_CORRECT,null),this);
	this.allAnswersCorrectCheckBox.setSelected(true);
	this.allAnswersCorrectCheckBox.setId("inputOptionsAllAnswersCorrect");
	this.allAnswersCorrectCheckBox.addActionListener(controller);
	var dataTableLabels = new Array();
	dataTableLabels.push(controller.t(com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent.COMPOUND_ANSWER_LABEL_ANSWER_COLUMN));
	dataTableLabels.push(controller.t(com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent.COMPOUND_ANSWER_LABEL_GRADE_WEIGHT_COLUMN));
	this.compoundAnswerDataTable = new com.wiris.util.ui.component.DataTable(dataTableLabels);
	this.compoundAnswerDataTable.setIndentationLevel(2);
	this.allAnswersCorrectPanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.allAnswersCorrectPanel.addComponent(this.allAnswersCorrectCheckBox);
	this.allAnswersCorrectPanel.addComponent(this.compoundAnswerDataTable);
	this.allAnswersCorrectPanel.setIndentationLevel(2);
	this.mainExpansionController = new com.wiris.util.ui.controller.ExpansionController(this,this.allAnswersCorrectPanel,false);
	this.allAnswersCorrectExpansionController = new com.wiris.util.ui.controller.ExpansionController(this,this.compoundAnswerDataTable,false);
	settingsContainer.addComponent(this.gradeAnswersSeparatelyCheckBox);
	settingsContainer.addComponent(this.allAnswersCorrectPanel);
	this.addActionListener(this.controller);
	this.addComponent(this.label);
	this.addComponent(settingsContainer);
	this.initialized = true;
};
com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent.__name__ = ["com","wiris","quizzes","impl","ui","component","CompoundAnswerComponent"];
com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent.__interfaces__ = [com.wiris.util.ui.interaction.ActionListener];
com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	actionPerformed: function(e) {
		if(!this.initialized) return;
		var action = e.getAction();
		var actionId = action.getId();
		if(actionId == com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent.COMPOUND_ANSWER_ID_GRADE_ANSWER_BOXES_SEPARATELY) this.mainExpansionController.toggle(); else if(actionId == com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent.COMPOUND_ANSWER_ID_ALL_ANSWERS_CORRECT) this.allAnswersCorrectExpansionController.toggle(); else {
			var compoundAnswers = this.getCompoundAnswers();
			compoundAnswers.pop();
			var remainingValue = 100.0;
			var i = HxOverrides.iter(compoundAnswers);
			while(i.hasNext()) {
				var nextValue = i.next();
				if(nextValue == "") nextValue = "0";
				if(Std.parseFloat(nextValue) > 100.0) {
					this.compoundAnswerTextFields[com.wiris.util.type.Arrays.indexOfElement(compoundAnswers,nextValue)].setValue("100");
					return;
				}
				remainingValue -= Std.parseFloat(nextValue);
			}
			if(remainingValue < 0) {
				remainingValue = 0;
				var j = HxOverrides.iter(this.compoundAnswerTextFields);
				while(j.hasNext()) {
					var textField = j.next();
					textField.setStatus(com.wiris.util.ui.component.InputComponent.STATUS_ERROR);
				}
			} else {
				var j = HxOverrides.iter(this.compoundAnswerTextFields);
				while(j.hasNext()) {
					var textField = j.next();
					textField.setStatus(com.wiris.util.ui.component.InputComponent.STATUS_INDETERMINATE);
				}
			}
			this.compoundAnswerTextFields[this.compoundAnswerTextFields.length - 1].setValue((remainingValue + "").substring(0,remainingValue > 10.0?4:3));
			this.performAction(action);
		}
	}
	,setCompoundAnswers: function(compoundAnswers,compoundDistribution) {
		this.compoundAnswerDataTable.removeAllRows();
		this.compoundAnswerTextFields = new Array();
		if(compoundAnswers != null) {
			var visible = this.allAnswersCorrectPanel.isVisible();
			this.allAnswersCorrectPanel.setVisible(true);
			if(compoundAnswers.length > 1) {
				var invalidRatios = false;
				var compoundRatios = new Array();
				if(compoundDistribution != null) {
					var tempDistribution = compoundDistribution.split(" ");
					if(tempDistribution.length == compoundAnswers.length) compoundRatios = tempDistribution;
				}
				if(compoundRatios.length > 0) {
					var totalRatios = 0;
					var j = HxOverrides.iter(compoundRatios);
					while(j.hasNext()) totalRatios += Std.parseFloat(j.next());
					if(Math.abs(totalRatios - 100.0) > 1e-3) invalidRatios = true;
				}
				var defaultAnswerWeight = 1.0 / compoundAnswers.length * 100.0;
				var totalAnswerWeight = 100.0 - (compoundAnswers.length - 1.0) * defaultAnswerWeight;
				var defaultAnswerLabel = (defaultAnswerWeight + "").substring(0,defaultAnswerWeight > 10.0?4:3);
				var totalAnswerLabel = (totalAnswerWeight + "").substring(0,totalAnswerWeight > 10.0?4:3);
				var _g1 = 0, _g = compoundAnswers.length;
				while(_g1 < _g) {
					var i = _g1++;
					var answer = compoundAnswers[i];
					var components = new Array();
					var answerLabel = com.wiris.quizzes.impl.ui.component.MathLabel.newWithText(answer);
					components.push(answerLabel);
					if(i + 1 == compoundAnswers.length) {
						var valueTextField = new com.wiris.util.ui.component.TextField();
						valueTextField.setSuffix("%");
						valueTextField.getStyle().setWidth(100);
						valueTextField.setReadOnly(true);
						if(invalidRatios) valueTextField.setStatus(com.wiris.util.ui.component.InputComponent.STATUS_ERROR);
						if(compoundRatios.length > 0) valueTextField.setValue(compoundRatios[i]); else valueTextField.setValue(totalAnswerLabel);
						this.compoundAnswerTextFields.push(valueTextField);
						components.push(valueTextField);
					} else {
						var valueTextField = new com.wiris.util.ui.component.NumberDropdownTextField();
						valueTextField.setPlaceholder("0");
						valueTextField.setSuffix("%");
						valueTextField.setChangeAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent.COMPOUND_ANSWER_ID_RATIOS_CHANGED,null));
						valueTextField.getStyle().setWidth(100);
						if(invalidRatios) valueTextField.setStatus(com.wiris.util.ui.component.InputComponent.STATUS_ERROR);
						if(compoundRatios.length > 0) valueTextField.setValue(compoundRatios[i]); else valueTextField.setValue(defaultAnswerLabel);
						if(compoundAnswers.length > 10) valueTextField.addOption(defaultAnswerLabel,defaultAnswerLabel + "%");
						valueTextField.addActionListener(this);
						valueTextField.addOption("10","10%");
						if(compoundAnswers.length > 5 && compoundAnswers.length < 10) valueTextField.addOption(defaultAnswerLabel,defaultAnswerLabel + "%");
						valueTextField.addOption("25","25%");
						valueTextField.addOption("33.3","33.3%");
						valueTextField.addOption("50","50%");
						valueTextField.addOption("100","100%");
						this.compoundAnswerTextFields.push(valueTextField);
						components.push(valueTextField);
					}
					this.compoundAnswerDataTable.addRow(components);
				}
			}
			this.performAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent.COMPOUND_ANSWER_ID_RATIOS_CHANGED,null));
			this.allAnswersCorrectPanel.setVisible(visible);
		}
	}
	,getCompoundAnswers: function() {
		var compoundAnswers = new Array();
		var i = HxOverrides.iter(this.compoundAnswerTextFields);
		while(i.hasNext()) compoundAnswers.push(i.next().getValue());
		return compoundAnswers;
	}
	,setAllAnswersCorrect: function(selected) {
		this.allAnswersCorrectCheckBox.setSelected(selected);
	}
	,setCompoundAnswer: function(selected) {
		this.gradeAnswersSeparatelyCheckBox.setSelected(selected);
		if(!selected) this.setAllAnswersCorrect(true);
	}
	,initialized: null
	,controller: null
	,allAnswersCorrectExpansionController: null
	,mainExpansionController: null
	,compoundAnswerTextFields: null
	,allAnswersCorrectPanel: null
	,gradeAnswersSeparatelyCheckBox: null
	,allAnswersCorrectCheckBox: null
	,compoundAnswerDataTable: null
	,label: null
	,__class__: com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent
});
com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent = $hxClasses["com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent"] = function(controller) {
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_FULL_SIZE_PANEL).addClass(com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.CLASS_CUSTOMIZE_TOOLBAR_COMPONENT);
	this.customizeToolbarHeader = com.wiris.util.ui.component.Label.newImportantWithText(controller.t(com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.CUSTOMIZE_TOOLBAR_HEADER));
	this.customizeToolbarHeader.getStyle().setMargin(0,0,8,0);
	this.customizeToolbarLabel = com.wiris.util.ui.component.Label.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.CUSTOMIZE_TOOLBAR_LABEL));
	this.customizeToolbarLabel.getStyle().setMargin(0,0,16,0);
	var content = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	content.getStyle().setMargin(0,0,24,0).setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT);
	this.graphMode = com.wiris.quizzes.impl.Assertion.GRAPH_MODE_STANDARD;
	this.toolbarDefinition = com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.getDefaultToolbarDefinition(this.graphMode);
	this.treeSelector = new com.wiris.quizzes.impl.ui.component.ToolbarTreeSelector(controller);
	this.treeSelector.setDefinition(this.toolbarDefinition);
	this.treeSelector.getStyle().setHeight(com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.CUSTOMIZE_TOOLBAR_HEIGHT).setMargin(0,16,0,0);
	this.treeSelector.addActionListener(controller);
	var graphParameters = new Hash();
	graphParameters.set(com.wiris.quizzes.impl.ui.component.GraphInputComponent.PARAM_AWAKE_MODE,"true");
	graphParameters.set(com.wiris.quizzes.impl.ui.component.GraphInputComponent.PARAM_FROZEN_MODE,"true");
	graphParameters.set(com.wiris.quizzes.impl.ui.component.GraphInputComponent.PARAM_ALLOW_ANIMATIONS,"true");
	this.graphView = new com.wiris.quizzes.impl.ui.component.GraphInputComponent(graphParameters);
	this.graphView.setId(com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.GRAPH_VIEW_ID);
	this.graphView.getStyle().setHeight(com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.CUSTOMIZE_TOOLBAR_HEIGHT);
	this.addComponent(this.customizeToolbarHeader);
	this.addComponent(this.customizeToolbarLabel);
	content.addComponent(this.treeSelector);
	content.addComponent(this.graphView);
	this.addComponent(content);
};
com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.__name__ = ["com","wiris","quizzes","impl","ui","component","CustomizeToolbarComponent"];
com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.getDefaultToolbarDefinition = function(graphMode) {
	return com.wiris.util.ui.controller.ToolbarDefinition.newToolbarDefinitionFromJson(com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.getGraphActions(),com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.getDefaultConfig(graphMode));
}
com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.getGraphActions = function() {
	var graphActionsResource = com.wiris.system.Storage.newResourceStorage(com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.QUIZZES_GRAPH_ACTIONS);
	return com.wiris.util.json.JSon.getHashArray(com.wiris.util.json.JSon.decode(graphActionsResource.read()));
}
com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.getDefaultConfig = function(graphMode) {
	var configFile = graphMode == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_STANDARD?com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.QUIZZES_STANDARD_CONFIG:graphMode == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_BAR_CHART?com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.QUIZZES_BAR_CHART_CONFIG:graphMode == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_LINE_CHART?com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.QUIZZES_LINE_CHART_CONFIG:graphMode == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_PIE_CHART?com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.QUIZZES_PIE_CHART_CONFIG:graphMode == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_SKETCH?com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.QUIZZES_SKETCH_CONFIG:com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.QUIZZES_STANDARD_CONFIG;
	var graphConfigResource = com.wiris.system.Storage.newResourceStorage(configFile);
	return com.wiris.util.json.JSon.decode(graphConfigResource.read());
}
com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	updateVisibility: function(context) {
		if(context.getSlot().getSyntax().getName() != com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC) return;
		var graphMode = context.getSlot().getSyntax().getParameter(com.wiris.quizzes.api.assertion.SyntaxParameterName.GRAPH_MODE);
		if(graphMode == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_SKETCH) {
			this.setVisible(false);
			return;
		}
		this.setVisible(true);
		if(!(graphMode == this.graphMode)) {
			this.graphMode = graphMode;
			this.treeSelector.setDefinition(com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.getDefaultToolbarDefinition(graphMode));
			this.graphView.setEmptyValueFromGraphMode(graphMode);
		}
		var definition = com.wiris.util.ui.controller.ToolbarDefinition.deserialize(context.getSlot().getProperty(com.wiris.quizzes.api.PropertyName.GRAPH_TOOLBAR));
		if(definition == null) this.graphView.updateGraphToolbar(this.treeSelector.computeGraphToolbarDefinition()); else {
			this.treeSelector.updateComponent(definition);
			this.graphView.updateGraphToolbar(definition);
		}
	}
	,graphMode: null
	,treeSelector: null
	,graphView: null
	,customizeToolbarLabel: null
	,customizeToolbarHeader: null
	,toolbarDefinition: null
	,__class__: com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent
});
com.wiris.util.graphics.DisplayListener = $hxClasses["com.wiris.util.graphics.DisplayListener"] = function() { }
com.wiris.util.graphics.DisplayListener.__name__ = ["com","wiris","util","graphics","DisplayListener"];
com.wiris.util.graphics.DisplayListener.prototype = {
	actionCanceled: null
	,actionFinished: null
	,showHelperText: null
	,elementVisibilityChanged: null
	,initialContentChanged: null
	,changeMode: null
	,repaint: null
	,animationEnded: null
	,animationStarted: null
	,cursorRequested: null
	,contentChanged: null
	,disposed: null
	,undoredoQueueChanged: null
	,updatePaths: null
	,elementUnselected: null
	,displayResized: null
	,elementSelected: null
	,__class__: com.wiris.util.graphics.DisplayListener
}
com.wiris.quizzes.impl.ui.component.GraphInputComponent = $hxClasses["com.wiris.quizzes.impl.ui.component.GraphInputComponent"] = function(parameters) {
	this.readOnly = false;
	this.isHidingActionsEnabled = false;
	this.isLockInitialContent = false;
	com.wiris.util.ui.component.InputComponent.call(this);
	this.addClass(com.wiris.quizzes.impl.ui.component.GraphInputComponent.CLASS_GRAPH_COMPONENT);
	this.parameters = parameters;
	if(!parameters.exists(com.wiris.quizzes.impl.Assertion.PARAM_GRAPH_MODE)) {
		this.graphMode = com.wiris.quizzes.impl.Assertion.GRAPH_MODE_STANDARD;
		this.value = com.wiris.quizzes.impl.ui.component.GraphInputComponent.EMPTY_GEOMETRY_FILE_GRAPH;
	} else {
		this.graphMode = parameters.get(com.wiris.quizzes.impl.Assertion.PARAM_GRAPH_MODE);
		this.value = this.graphMode == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_STANDARD?com.wiris.quizzes.impl.ui.component.GraphInputComponent.EMPTY_GEOMETRY_FILE_GRAPH:this.graphMode == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_BAR_CHART?com.wiris.quizzes.impl.ui.component.GraphInputComponent.EMPTY_GEOMETRY_FILE_BAR_CHART:this.graphMode == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_LINE_CHART?com.wiris.quizzes.impl.ui.component.GraphInputComponent.EMPTY_GEOMETRY_FILE_LINE_CHART:this.graphMode == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_PIE_CHART?com.wiris.quizzes.impl.ui.component.GraphInputComponent.EMPTY_GEOMETRY_FILE_PIE_CHART:com.wiris.quizzes.impl.ui.component.GraphInputComponent.EMPTY_GEOMETRY_FILE_GRAPH;
	}
	this.value = com.wiris.util.geometry.GeometryFile.readJSON(this.value).toJSON();
	if(this.parameters == null) this.parameters = new Hash();
	if(!this.parameters.exists(com.wiris.quizzes.impl.ui.component.GraphInputComponent.PARAM_DEFAULT_DISPLAY_SETTINGS)) {
		var defaultConfig = new Hash();
		defaultConfig.set(com.wiris.util.graphics.DisplaySettings.DISPLAY_ELEMENT_NAMES,com.wiris.util.graphics.DisplaySettings.ALWAYS);
		defaultConfig.set(com.wiris.util.graphics.DisplaySettings.DISPLAY_ELEMENT_VALUES,com.wiris.util.graphics.DisplaySettings.FOCUS);
		defaultConfig.set(com.wiris.util.graphics.DisplaySettings.MAGNETIC_GRID,com.wiris.util.graphics.DisplaySettings.SNAP);
		this.parameters.set(com.wiris.quizzes.impl.ui.component.GraphInputComponent.PARAM_DEFAULT_DISPLAY_SETTINGS,com.wiris.util.json.JSon.encode(defaultConfig));
	}
	if(this.parameters.exists(com.wiris.quizzes.impl.ui.component.GraphInputComponent.PARAM_TOOLBAR_DEFINITION)) this.toolbarDefinition = com.wiris.util.ui.controller.ToolbarDefinition.deserialize(this.parameters.get(com.wiris.quizzes.impl.ui.component.GraphInputComponent.PARAM_TOOLBAR_DEFINITION));
	if(this.parameters.get(com.wiris.quizzes.impl.ui.component.GraphInputComponent.PARAM_LANGUAGE) == null) this.parameters.set(com.wiris.quizzes.impl.ui.component.GraphInputComponent.PARAM_LANGUAGE,com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().getLanguage());
	this.pendingActions = new Hash();
};
com.wiris.quizzes.impl.ui.component.GraphInputComponent.__name__ = ["com","wiris","quizzes","impl","ui","component","GraphInputComponent"];
com.wiris.quizzes.impl.ui.component.GraphInputComponent.__interfaces__ = [com.wiris.util.graphics.DisplayListener,com.wiris.util.ui.component.Field];
com.wiris.quizzes.impl.ui.component.GraphInputComponent.__super__ = com.wiris.util.ui.component.InputComponent;
com.wiris.quizzes.impl.ui.component.GraphInputComponent.prototype = $extend(com.wiris.util.ui.component.InputComponent.prototype,{
	actionCanceled: function() {
	}
	,actionFinished: function() {
	}
	,showHelperText: function(text,name) {
	}
	,elementVisibilityChanged: function() {
	}
	,initialContentChanged: function() {
	}
	,changeMode: function(mode) {
	}
	,repaint: function() {
	}
	,animationEnded: function() {
	}
	,animationStarted: function() {
	}
	,cursorRequested: function(cursor) {
	}
	,disposed: function() {
	}
	,undoredoQueueChanged: function(canUndo,canRedo) {
	}
	,updatePaths: function() {
	}
	,elementUnselected: function() {
	}
	,displayResized: function() {
	}
	,elementSelected: function() {
	}
	,setDisplaySetting: function(name,value) {
		if(this.graph != null) this.graph.getGraphModel().setDisplaySetting(name,value);
	}
	,setHidingActionsEnabled: function(enabled) {
		this.isHidingActionsEnabled = enabled;
		if(this.graph != null) this.graph.getGraphModel().setHidingActionsEnabled(enabled);
	}
	,setInitialContent: function(initialContent,locked) {
		this.initialContent = initialContent;
		this.isLockInitialContent = locked;
		if(this.graph != null) try {
			this.graph.getGraphModel().getDisplay().setInitialContent(initialContent,locked);
		} catch( e ) {
			if( js.Boot.__instanceof(e,com.wiris.system.Exception) ) {
			} else throw(e);
		}
	}
	,actionWithParams: function(action,params) {
		if(this.graph != null) try {
			var d = this.graph.getGraphModel().getDisplay();
			d.startAction(action);
			d.setActionParameters(params);
			d.useCurrentActionParameters();
		} catch( e ) {
			if( js.Boot.__instanceof(e,com.wiris.system.Exception) ) {
			} else throw(e);
		} else this.pendingActions.set(action,params);
	}
	,activateMainAction: function() {
		if(this.graph != null) this.graph.getGraphModel().activateMainAction();
	}
	,cancelAction: function() {
		if(this.graph == null) return;
		try {
			this.graph.getGraphModel().getDisplay().cancelAction();
		} catch( e ) {
			if( js.Boot.__instanceof(e,com.wiris.system.Exception) ) {
			} else throw(e);
		}
	}
	,setReadOnly: function(readOnly) {
		if(this.readOnly == readOnly) return;
		this.readOnly = readOnly;
		if(this.graph != null) {
			if(readOnly) this.graph.getGraphModel().enterViewOnly(true); else this.graph.getGraphModel().exitViewOnly();
		}
	}
	,setGraphValue: function(value) {
		try {
			this.graph.getGraphModel().getDisplay().loadGeometryFile(value);
		} catch( e ) {
			throw "Error loading the geometry file " + value + ". \n Error description: " + Std.string(e.toString());
		}
		if(this.toolbarDefinition != null) this.graph.getGraphModel().updateGraphToolbar(this.toolbarDefinition);
	}
	,contentChanged: function() {
		var changed = true;
		try {
			var newValue = this.graph.getGraphModel().getDisplay().getGeometryFile();
			if(this.value == newValue) changed = false; else this.value = newValue;
		} catch( e ) {
			changed = false;
		}
		if(changed && this.changeAction != null) this.performAction(this.changeAction);
	}
	,requestFocus: function() {
		if(this.graph != null) this.graph.getGraphModel().getGraphComponent().requestFocus();
		return this;
	}
	,setChangeAction: function(changeAction) {
		this.changeAction = changeAction;
	}
	,getComponent: function() {
		return this;
	}
	,isEmpty: function() {
		return this.value == com.wiris.quizzes.impl.ui.component.GraphInputComponent.EMPTY_GEOMETRY_FILE_GRAPH;
	}
	,setGraphMode: function(graphMode) {
		if(this.graphMode != null && this.graphMode == graphMode) return;
		this.graphMode = graphMode;
		this.toolbarDefinition = null;
		if(this.graph == null) return;
		this.graph.getGraphModel().changeMode(com.wiris.quizzes.impl.QuizzesEnumUtils.string2GraphMode(graphMode));
	}
	,setValue: function(newValue) {
		if(newValue == null || newValue == "" || !(com.wiris.quizzes.impl.MathContent.getMathType(newValue) == com.wiris.quizzes.impl.MathContent.TYPE_GEOMETRY_FILE)) newValue = this.graphMode == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_STANDARD?com.wiris.quizzes.impl.ui.component.GraphInputComponent.EMPTY_GEOMETRY_FILE_GRAPH:this.graphMode == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_BAR_CHART?com.wiris.quizzes.impl.ui.component.GraphInputComponent.EMPTY_GEOMETRY_FILE_BAR_CHART:this.graphMode == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_LINE_CHART?com.wiris.quizzes.impl.ui.component.GraphInputComponent.EMPTY_GEOMETRY_FILE_LINE_CHART:this.graphMode == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_PIE_CHART?com.wiris.quizzes.impl.ui.component.GraphInputComponent.EMPTY_GEOMETRY_FILE_PIE_CHART:com.wiris.quizzes.impl.ui.component.GraphInputComponent.EMPTY_GEOMETRY_FILE_GRAPH;
		if(!(this.value == newValue)) {
			this.value = newValue;
			if(this.graph != null) this.setGraphValue(newValue);
			if(this.changeAction != null) this.performAction(this.changeAction);
		}
	}
	,getValue: function() {
		return this.value;
	}
	,setGraph: function(graph) {
		this.graph = graph;
		this.graph.getGraphModel().getDisplay().addDisplayListener(this);
		if(this.initialContent != null) try {
			this.graph.getGraphModel().getDisplay().setInitialContent(this.initialContent,this.isLockInitialContent);
		} catch( e ) {
			if( js.Boot.__instanceof(e,com.wiris.system.Exception) ) {
			} else throw(e);
		}
		if(this.value != null && !(this.value == this.initialContent)) this.setGraphValue(this.value);
		if(this.toolbarDefinition != null) this.graph.getGraphModel().updateGraphToolbar(this.toolbarDefinition);
		var pendingAct = this.pendingActions.keys();
		while(pendingAct.hasNext()) {
			var name = pendingAct.next();
			this.actionWithParams(name,this.pendingActions.get(name));
		}
		this.pendingActions = new Hash();
		if(this.isHidingActionsEnabled) this.setHidingActionsEnabled(true);
		if(this.readOnly) this.setReadOnly(true);
		this.componentSet();
	}
	,updateGraphToolbar: function(definition) {
		this.toolbarDefinition = definition;
		if(this.graph != null) this.graph.getGraphModel().updateGraphToolbar(definition);
	}
	,getGraph: function() {
		return this.graph;
	}
	,getParameters: function() {
		return this.parameters;
	}
	,setEmptyValueFromGraphMode: function(graphMode) {
		this.graphMode = graphMode;
		this.value = graphMode == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_STANDARD?com.wiris.quizzes.impl.ui.component.GraphInputComponent.EMPTY_GEOMETRY_FILE_GRAPH:graphMode == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_BAR_CHART?com.wiris.quizzes.impl.ui.component.GraphInputComponent.EMPTY_GEOMETRY_FILE_BAR_CHART:graphMode == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_LINE_CHART?com.wiris.quizzes.impl.ui.component.GraphInputComponent.EMPTY_GEOMETRY_FILE_LINE_CHART:graphMode == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_PIE_CHART?com.wiris.quizzes.impl.ui.component.GraphInputComponent.EMPTY_GEOMETRY_FILE_PIE_CHART:com.wiris.quizzes.impl.ui.component.GraphInputComponent.EMPTY_GEOMETRY_FILE_GRAPH;
		this.setGraphValue(this.value);
	}
	,pendingActions: null
	,graphMode: null
	,readOnly: null
	,isHidingActionsEnabled: null
	,isLockInitialContent: null
	,toolbarDefinition: null
	,initialContent: null
	,value: null
	,parameters: null
	,changeAction: null
	,graph: null
	,__class__: com.wiris.quizzes.impl.ui.component.GraphInputComponent
});
com.wiris.quizzes.impl.ui.component.GraphInputOptionsActivity = $hxClasses["com.wiris.quizzes.impl.ui.component.GraphInputOptionsActivity"] = function(controller) {
	com.wiris.util.ui.component.ActivityPanel.call(this);
	this.setId(com.wiris.quizzes.impl.ui.component.GraphInputOptionsActivity.GRAPH_OPTIONS_ID);
	this.addClass(com.wiris.util.ui.component.Panel.CLASS_PANEL_SOLID).addClass(com.wiris.quizzes.impl.ui.component.GraphInputOptionsActivity.CLASS_QUIZZES_STUDIO_GRAPH_INPUT_OPTIONS);
	this.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setHeightWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setHorizontalAlignment(com.wiris.util.ui.Style.HORIZONTAL_ALIGNMENT_STRETCH);
	var wrapper = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	wrapper.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setHeightWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setVerticalAlignment(com.wiris.util.ui.Style.VERTICAL_ALIGNMENT_TOP);
	this.customizeToolbar = new com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent(controller);
	this.auxiliaryFields = new com.wiris.quizzes.impl.ui.component.InputMethodComponent(controller);
	wrapper.addComponent(this.customizeToolbar);
	wrapper.addComponent(this.auxiliaryFields);
	this.addComponent(wrapper);
};
com.wiris.quizzes.impl.ui.component.GraphInputOptionsActivity.__name__ = ["com","wiris","quizzes","impl","ui","component","GraphInputOptionsActivity"];
com.wiris.quizzes.impl.ui.component.GraphInputOptionsActivity.__super__ = com.wiris.util.ui.component.ActivityPanel;
com.wiris.quizzes.impl.ui.component.GraphInputOptionsActivity.prototype = $extend(com.wiris.util.ui.component.ActivityPanel.prototype,{
	updateVisibility: function(context) {
		this.customizeToolbar.updateVisibility(context);
		this.auxiliaryFields.updateVisibility(context);
	}
	,auxiliaryFields: null
	,customizeToolbar: null
	,__class__: com.wiris.quizzes.impl.ui.component.GraphInputOptionsActivity
});
com.wiris.quizzes.impl.ui.component.GraphValidationElement = $hxClasses["com.wiris.quizzes.impl.ui.component.GraphValidationElement"] = function(text,formula,options) {
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.addClass(com.wiris.quizzes.impl.ui.component.GraphValidationElement.CLASS_GRAPH_VALIDATION_ELEMENT);
	var content = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	content.addClass(com.wiris.quizzes.impl.ui.component.GraphValidationElement.CLASS_COMPONENT_CONTENT);
	content.getStyle().setMargin(0,10,0,10);
	this.textField = com.wiris.util.ui.component.NumberDropdownTextField.newWithPlaceholder("0");
	this.textField.getStyle().setWidth(100);
	this.textField.setSuffix(com.wiris.quizzes.impl.ui.component.GraphValidationElement.TEXT_FIELD_SUFFIX);
	this.textField.setVisible(false);
	this.textField.setChangeAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.GraphValidationSelector.ACTION_EDIT_VALUE,null));
	this.textField.addActionListener(this);
	var _g = 0;
	while(_g < options.length) {
		var value = options[_g];
		++_g;
		this.textField.addOption(value,value + "%");
	}
	var mathLabel = com.wiris.quizzes.impl.ui.component.MathLabel.newWithText(formula);
	mathLabel.getStyle().setBorderSize(0,0,0,0);
	this.checkBox = com.wiris.util.ui.component.CheckBox.newWithHelperText(text,"",com.wiris.quizzes.impl.ui.component.GraphValidationElement.ID_CHECKBOX,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.GraphValidationSelector.ACTION_CHECKBOX,null),this);
	this.checkBox.getHelperTextPanel().addComponent(mathLabel);
	this.checkBox.setSelected(true);
	var divider = new com.wiris.util.ui.component.Divider(false);
	content.addComponent(this.checkBox);
	content.addComponent(this.textField);
	this.addComponent(content);
	this.addComponent(divider);
};
com.wiris.quizzes.impl.ui.component.GraphValidationElement.__name__ = ["com","wiris","quizzes","impl","ui","component","GraphValidationElement"];
com.wiris.quizzes.impl.ui.component.GraphValidationElement.__interfaces__ = [com.wiris.util.ui.interaction.ActionListener];
com.wiris.quizzes.impl.ui.component.GraphValidationElement.newWithValue = function(text,formula,options,value) {
	var graphValidationElement = new com.wiris.quizzes.impl.ui.component.GraphValidationElement(text,formula,options);
	graphValidationElement.setValue(value);
	return graphValidationElement;
}
com.wiris.quizzes.impl.ui.component.GraphValidationElement.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.quizzes.impl.ui.component.GraphValidationElement.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	actionPerformed: function(e) {
		var action = e.getAction();
		var id = action.getId();
		if(id == com.wiris.quizzes.impl.ui.component.GraphValidationSelector.ACTION_CHECKBOX) this.setFieldVisible(this.isEnabled() && this.isActive());
		this.performAction(action);
	}
	,setValue: function(value) {
		this.textField.setValue(value);
	}
	,getValue: function() {
		return this.textField.getValue();
	}
	,setInvalid: function(invalid) {
		this.textField.setStatus(invalid?com.wiris.util.ui.component.InputComponent.STATUS_ERROR:com.wiris.util.ui.component.InputComponent.STATUS_INDETERMINATE);
	}
	,setFieldVisible: function(visible) {
		this.textField.setVisible(visible);
	}
	,isActive: function() {
		return this.checkBox.isSelected();
	}
	,setActive: function(active) {
		this.checkBox.setSelected(active);
	}
	,getCheckbox: function() {
		return this.checkBox;
	}
	,textField: null
	,checkBox: null
	,__class__: com.wiris.quizzes.impl.ui.component.GraphValidationElement
});
com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity = $hxClasses["com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity"] = function(controller) {
	this.graphSize = 0;
	com.wiris.util.ui.component.ActivityPanel.call(this);
	this.addClass(com.wiris.util.ui.component.Panel.CLASS_PANEL_SOLID).addClass(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.CLASS_GRAPH_VALIDATION_OPTIONS);
	this.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setHeightWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT);
	var wrapper = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	wrapper.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setHeightWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setVerticalAlignment(com.wiris.util.ui.Style.VERTICAL_ALIGNMENT_TOP);
	wrapper.addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_FULL_SIZE_PANEL);
	var elementsTitle = com.wiris.util.ui.component.Label.newImportantWithText(controller.t(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.ELEMENTS_TITLE));
	var subtitle = com.wiris.util.ui.component.Label.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.ELEMENTS_SUBTITLE));
	subtitle.getStyle().setMargin(0,0,8,24);
	var elements = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	elements.addClass(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.CLASS_ELEMENTS_CONTAINER);
	elements.getStyle().setVerticalAlignment(com.wiris.util.ui.Style.VERTICAL_ALIGNMENT_TOP);
	this.elementSelector = new com.wiris.quizzes.impl.ui.component.GraphValidationSelector(controller);
	this.elementSelector.addActionListener(controller);
	this.elementSelector.getStyle().setVerticalAlignment(com.wiris.util.ui.Style.VERTICAL_ALIGNMENT_TOP);
	this.elementSelector.addClass(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.CLASS_ELEMENT_SELECTOR);
	var graphParameters = new Hash();
	graphParameters.set(com.wiris.quizzes.impl.ui.component.GraphInputComponent.PARAM_VIEW_ONLY,"true");
	this.graphView = new com.wiris.quizzes.impl.ui.component.GraphInputComponent(graphParameters);
	this.graphView.addClass(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.CLASS_GRAPH_VIEW);
	this.graphView.getStyle().setWidth(450).setHeight(450);
	this.graphView.setChangeAction(new com.wiris.util.ui.Action("graphValidationChanged",null));
	this.graphView.addActionListener(controller);
	this.graphView.addInputComponentListener(this);
	var criteriaTitle = com.wiris.util.ui.component.Label.newImportantWithText(controller.t(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.CRITERIA_TITLE));
	var criteria = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	criteria.getStyle().setVerticalAlignment(com.wiris.util.ui.Style.VERTICAL_ALIGNMENT_TOP);
	criteria.addClass(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.CLASS_CRITERIA_CONTAINER).addClass(com.wiris.util.ui.component.Panel.CLASS_PANEL_CARD);
	this.toleranceSlider = com.wiris.util.ui.component.Slider.newWithValueAndRange(controller.t(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.TOLERANCE_TITLE),false,Std.parseFloat(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.TOLERANCE_DEFAULT_VALUE),0,1,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.ACTION_TOLERANCE,com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.ACTION_TOLERANCE),controller);
	this.toleranceSlider.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT);
	var toleranceHelper = com.wiris.util.ui.component.Label.newTinyWithText(controller.t(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.TOLERANCE_HELPER));
	toleranceHelper.getStyle().setMargin(10,0,0,0);
	this.superfluousCheckBox = com.wiris.util.ui.component.CheckBox.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.SUPERFLUOUS_TEXT),controller.t(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.SUPERFLUOUS_HELPER),com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.GRAPH_VALIDATION_ID_CHECK_NO_SUPERFLUOUS,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.ACTION_SUPERFLUOUS,com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.ACTION_SUPERFLUOUS),controller);
	this.superfluousCheckBox.getStyle().setMargin(16,0,8,0);
	this.superfluousCheckBox.setId(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.GRAPH_VALIDATION_ID_CHECK_NO_SUPERFLUOUS);
	this.matchColorCheckBox = com.wiris.util.ui.component.CheckBox.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.MATCH_COLOR_TEXT),controller.t(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.MATCH_COLOR_HELPER),com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.GRAPH_VALIDATION_ID_MATCH_COLOR,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.ACTION_MATCH_COLOR,com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.ACTION_MATCH_COLOR),controller);
	this.matchColorCheckBox.setId(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.GRAPH_VALIDATION_ID_MATCH_COLOR);
	this.matchLineStyleCheckBox = com.wiris.util.ui.component.CheckBox.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.MATCH_LINE_TYPE_TEXT),controller.t(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.MATCH_LINE_TYPE_HELPER),com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.GRAPH_VALIDATION_ID_MATCH_LINE_TYPE,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.ACTION_MATCH_LINETYPE,com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.ACTION_MATCH_LINETYPE),controller);
	this.matchLineStyleCheckBox.setId(com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.GRAPH_VALIDATION_ID_MATCH_LINE_TYPE);
	criteria.addComponent(this.toleranceSlider);
	criteria.addComponent(toleranceHelper);
	criteria.addComponent(this.superfluousCheckBox);
	criteria.addComponent(this.matchColorCheckBox);
	criteria.addComponent(this.matchLineStyleCheckBox);
	var criteriaWrapper = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	criteriaWrapper.addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_FULL_SIZE_PANEL);
	elements.addComponent(this.graphView);
	elements.addComponent(this.elementSelector);
	criteriaWrapper.addComponent(criteriaTitle);
	criteriaWrapper.addComponent(criteria);
	wrapper.addComponent(elementsTitle);
	wrapper.addComponent(subtitle);
	wrapper.addComponent(elements);
	wrapper.addComponent(criteriaWrapper);
	this.addComponent(wrapper);
};
com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.__name__ = ["com","wiris","quizzes","impl","ui","component","GraphValidationOptionsActivity"];
com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.__interfaces__ = [com.wiris.util.ui.interaction.InputComponentListener];
com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.__super__ = com.wiris.util.ui.component.ActivityPanel;
com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity.prototype = $extend(com.wiris.util.ui.component.ActivityPanel.prototype,{
	onSetComponent: function(component) {
		if(js.Boot.__instanceof(component,com.wiris.quizzes.impl.ui.component.GraphInputComponent)) {
			var inputComponent = component;
			var options = inputComponent.getGraph().getGraphModel().getDisplay().getOptionDictionary();
			var width = Std.parseFloat(Std.string(options.get("width")) + "");
			var height = Std.parseFloat(Std.string(options.get("height")) + "");
			this.graphSize = Math.max(width,height);
			this.toleranceSlider.setMax(this.graphSize / 4.0);
		}
	}
	,getPlotter: function() {
		return this.graphView.getGraph().getGraphModel().getDisplay();
	}
	,unfocusGraphElement: function(element) {
		this.getPlotter().unfocusElement(element);
	}
	,focusGraphElement: function(element) {
		this.getPlotter().focusElement(element);
	}
	,updateGraphElementTolerances: function(context) {
		var toleranceStr = context.getAuthorAnswer().getComparison().getParameter(com.wiris.quizzes.api.assertion.ComparisonParameterName.TOLERANCE);
		var tolerance = 0;
		try {
			tolerance = Std.parseFloat(toleranceStr);
		} catch( ignored ) {
		}
		this.getPlotter().setElementTolerances(0);
		var i = context.getGraphicalElements().keys();
		while(i.hasNext()) {
			var elem = i.next();
			if(context.isGraphicalElementActive(elem)) this.getPlotter().setElementTolerance(elem,tolerance);
		}
	}
	,updateGraphicalMaxTolerance: function(newGraphSize) {
		var tolerance = Std.parseFloat(this.toleranceSlider.getValue()), newTolerance;
		var max = this.toleranceSlider.getMax(), newMax;
		var ratio;
		if(this.graphSize == 0) ratio = 1; else ratio = newGraphSize / this.graphSize;
		newMax = max * ratio;
		newTolerance = tolerance * ratio;
		this.graphSize = newGraphSize;
		this.toleranceSlider.setRange(0,newMax).setValue(newTolerance + "");
		return tolerance;
	}
	,updateContent: function(context) {
		var authorAnswer = context.getAuthorAnswer();
		this.graphView.setValue(authorAnswer.getValue());
		var syntax = context.getSlot().getSyntax();
		if(syntax.getName() == com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC) {
			this.elementSelector.updateVisibility(context);
			var showValidationOption = syntax.getParameter(com.wiris.quizzes.api.assertion.SyntaxParameterName.GRAPH_MODE) == null || syntax.getParameter(com.wiris.quizzes.api.assertion.SyntaxParameterName.GRAPH_MODE) == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_STANDARD;
			this.matchLineStyleCheckBox.setVisible(showValidationOption);
			this.matchColorCheckBox.setVisible(showValidationOption);
			this.superfluousCheckBox.setVisible(showValidationOption);
			var superfluous = false;
			var matchColor = false;
			var matchLineStyle = false;
			var validations = authorAnswer.getValidations();
			var _g = 0;
			while(_g < validations.length) {
				var v = validations[_g];
				++_g;
				if(v.getName() == com.wiris.quizzes.api.assertion.ValidationName.CHECK_NO_SUPERFLUOUS) superfluous = true; else if(v.getName() == com.wiris.quizzes.api.assertion.ValidationName.CHECK_LINE_STYLE) matchLineStyle = true; else if(v.getName() == com.wiris.quizzes.api.assertion.ValidationName.CHECK_COLOR) matchColor = true;
			}
			this.superfluousCheckBox.setSelected(superfluous);
			this.matchLineStyleCheckBox.setSelected(matchLineStyle);
			this.matchColorCheckBox.setSelected(matchColor);
			this.toleranceSlider.setValue(authorAnswer.getComparison().getParameter(com.wiris.quizzes.api.assertion.ComparisonParameterName.TOLERANCE));
		}
		this.elementSelector.clean();
		var elements = new Array();
		var i = context.getGraphicalElements().keys();
		while(i.hasNext()) {
			var elem = i.next();
			var elemSummary = this.getPlotter().getElementSummary(elem);
			elements.push(elemSummary);
		}
		var distribute = context.getSlot().getProperty(com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER_GRADE) == com.wiris.quizzes.impl.LocalData.VALUE_OPENANSWER_COMPOUND_ANSWER_GRADE_DISTRIBUTE && !(context.getSlot().getSyntax().getParameter(com.wiris.quizzes.api.assertion.SyntaxParameterName.GRAPH_MODE) == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_SKETCH);
		this.elementSelector.setGraphAnswers(elements,context.getGraphicalRatios(),context.getGraphicalElementsActive(),distribute);
		this.updateGraphElementTolerances(context);
	}
	,graphSize: null
	,toleranceSlider: null
	,matchLineStyleCheckBox: null
	,matchColorCheckBox: null
	,superfluousCheckBox: null
	,elementSelector: null
	,graphView: null
	,__class__: com.wiris.quizzes.impl.ui.component.GraphValidationOptionsActivity
});
com.wiris.quizzes.impl.ui.component.GraphValidationSelector = $hxClasses["com.wiris.quizzes.impl.ui.component.GraphValidationSelector"] = function(controller) {
	this.lockCheckbox = false;
	this.ROUND_VALUE = 99.89;
	this.MAX_VALUE = 100.00;
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.addClass(com.wiris.util.ui.component.Panel.CLASS_PANEL_CARD);
	this.controller = controller;
	this.elements = new Array();
	var activateAll = new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.GraphValidationSelector.ACTION_ACTIVATE_ALL_CHECKBOX,null);
	var distributeGrade = new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.GraphValidationSelector.ACTION_DISTRIBUTE_GRADE,null);
	var header = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	header.addClass(com.wiris.quizzes.impl.ui.component.GraphValidationSelector.CLASS_SELECTOR_HEADER);
	this.checkBoxHeader = com.wiris.util.ui.component.CheckBox.newCheckBox(controller.t(com.wiris.quizzes.impl.ui.component.GraphValidationSelector.SELECT_ALL),com.wiris.quizzes.impl.ui.component.GraphValidationSelector.ID_CHECKBOX_HEADER,activateAll,this);
	this.checkBoxHeader.setSelected(true);
	this.checkBoxHeader.getStyle().setWidthWithUnit(50,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT);
	this.gradeDistribution = com.wiris.util.ui.component.CheckBox.newCheckBox(controller.t(com.wiris.quizzes.impl.ui.component.GraphValidationSelector.DISTRIBUTE_GRADES),com.wiris.quizzes.impl.ui.component.GraphValidationSelector.ID_GRADE_DISTRIBUTION,distributeGrade,this);
	this.gradeDistribution.setSelected(false);
	this.gradeDistribution.getStyle().setWidthWithUnit(50,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT);
	this.elementsPanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.elementsPanel.getStyle().setVerticalAlignment(com.wiris.util.ui.Style.VERTICAL_ALIGNMENT_TOP);
	this.elementsPanel.addClass(com.wiris.quizzes.impl.ui.component.GraphValidationSelector.CLASS_ELEMENTS_PANEL);
	header.addComponent(this.checkBoxHeader);
	header.addComponent(this.gradeDistribution);
	this.addComponent(header);
	this.addComponent(new com.wiris.util.ui.component.Divider(false));
	this.addComponent(this.elementsPanel);
};
com.wiris.quizzes.impl.ui.component.GraphValidationSelector.__name__ = ["com","wiris","quizzes","impl","ui","component","GraphValidationSelector"];
com.wiris.quizzes.impl.ui.component.GraphValidationSelector.__interfaces__ = [com.wiris.util.ui.interaction.MouseListener,com.wiris.util.ui.interaction.ActionListener];
com.wiris.quizzes.impl.ui.component.GraphValidationSelector.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.quizzes.impl.ui.component.GraphValidationSelector.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	updateVisibility: function(context) {
		var syntax = context.getSlot().getSyntax();
		if(syntax.getParameter(com.wiris.quizzes.api.assertion.SyntaxParameterName.GRAPH_MODE) == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_SKETCH) {
			this.gradeDistribution.setVisible(false);
			this.elementsPanel.setVisible(true);
		} else {
			this.elementsPanel.setVisible(true);
			this.gradeDistribution.setVisible(true);
		}
	}
	,mouseRelease: function(e) {
	}
	,mousePress: function(e) {
	}
	,mouseDoubleClick: function(e) {
	}
	,mouseClick: function(e) {
	}
	,mouseExit: function(e) {
		if(js.Boot.__instanceof(e.getSource(),com.wiris.quizzes.impl.ui.component.GraphValidationElement)) {
			var elemId = e.getSource().getId();
			this.performAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.GraphValidationSelector.ACTION_UNFOCUS_GRAPH_ELEMENT,elemId));
		}
	}
	,mouseEnter: function(e) {
		if(js.Boot.__instanceof(e.getSource(),com.wiris.quizzes.impl.ui.component.GraphValidationElement)) {
			var elemId = e.getSource().getId();
			this.performAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.GraphValidationSelector.ACTION_FOCUS_GRAPH_ELEMENT,elemId));
		}
	}
	,actionPerformed: function(e) {
		var action = e.getAction();
		var id = action.getId();
		if(id == com.wiris.quizzes.impl.ui.component.GraphValidationSelector.ACTION_CHECKBOX) {
			this.updateHeaderCheckboxState();
			this.setInvalid(this.getTotalValue() != this.MAX_VALUE);
		} else if(id == com.wiris.quizzes.impl.ui.component.GraphValidationSelector.ACTION_EDIT_VALUE) {
			var _g = 0, _g1 = this.elements;
			while(_g < _g1.length) {
				var element = _g1[_g];
				++_g;
				var value = element.getValue();
				if(value == "") value = "";
				if(Std.parseFloat(value) > 100.0) {
					element.setValue("100");
					return;
				}
			}
			this.setInvalid(this.getTotalValue() != this.MAX_VALUE);
		} else if(id == com.wiris.quizzes.impl.ui.component.GraphValidationSelector.ACTION_DISTRIBUTE_GRADE) {
			this.setFieldEnabled(this.gradeDistribution.isSelected());
			this.setFieldVisible(this.gradeDistribution.isSelected());
		} else if(id == com.wiris.quizzes.impl.ui.component.GraphValidationSelector.ACTION_ACTIVATE_ALL_CHECKBOX && !this.lockCheckbox) this.setActive(this.checkBoxHeader.isSelected());
		this.performAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.GraphValidationSelector.ACTION_GRAPH_VALIDATION_CHANGED,e.getSource().getId()));
	}
	,updateHeaderCheckboxState: function() {
		this.lockCheckbox = true;
		var activeElements = this.activeElements();
		if(activeElements == 0) {
			this.checkBoxHeader.removeClass(com.wiris.quizzes.impl.ui.component.GraphValidationSelector.CLASS_UNDETERMINED);
			this.checkBoxHeader.setSelected(false);
		} else if(activeElements == this.elements.length) {
			this.checkBoxHeader.removeClass(com.wiris.quizzes.impl.ui.component.GraphValidationSelector.CLASS_UNDETERMINED);
			this.checkBoxHeader.setSelected(true);
		} else {
			this.checkBoxHeader.addClass(com.wiris.quizzes.impl.ui.component.GraphValidationSelector.CLASS_UNDETERMINED);
			this.checkBoxHeader.setSelected(true);
		}
		this.lockCheckbox = false;
	}
	,activeElements: function() {
		var active = 0;
		var _g = 0, _g1 = this.elements;
		while(_g < _g1.length) {
			var element = _g1[_g];
			++_g;
			if(element.isActive()) active++;
		}
		return active;
	}
	,setInvalid: function(valid) {
		var _g = 0, _g1 = this.elements;
		while(_g < _g1.length) {
			var element = _g1[_g];
			++_g;
			element.setInvalid(valid);
		}
	}
	,setFieldVisible: function(visible) {
		var _g = 0, _g1 = this.elements;
		while(_g < _g1.length) {
			var element = _g1[_g];
			++_g;
			element.setFieldVisible(visible && element.isActive());
		}
	}
	,setFieldEnabled: function(enabled) {
		var _g = 0, _g1 = this.elements;
		while(_g < _g1.length) {
			var element = _g1[_g];
			++_g;
			element.setEnabled(enabled);
		}
	}
	,setActive: function(active) {
		var _g = 0, _g1 = this.elements;
		while(_g < _g1.length) {
			var element = _g1[_g];
			++_g;
			element.setActive(active);
		}
	}
	,getValues: function() {
		var values = new Array();
		var _g = 0, _g1 = this.elements;
		while(_g < _g1.length) {
			var element = _g1[_g];
			++_g;
			if(element.isActive()) values.push(element.getValue());
		}
		return values;
	}
	,getTotalValue: function() {
		var value = 0.00;
		var _g = 0, _g1 = this.elements;
		while(_g < _g1.length) {
			var element = _g1[_g];
			++_g;
			if(element.isActive()) value += Std.parseFloat(element.getValue());
		}
		if(value < this.MAX_VALUE && value >= this.ROUND_VALUE) return this.MAX_VALUE;
		return value;
	}
	,areValuesDistributed: function() {
		return this.gradeDistribution.isSelected();
	}
	,getGraphicalElements: function() {
		var ret = new Hash();
		var _g = 0, _g1 = this.elements;
		while(_g < _g1.length) {
			var element = _g1[_g];
			++_g;
			var ratio = element.isActive()?Std.parseFloat(element.getValue()):com.wiris.quizzes.impl.ui.QuizzesStudioContext.GRAPHICAL_ELEMENT_NOT_ACTIVE;
			ret.set(element.getId(),ratio);
		}
		return ret;
	}
	,setMessage: function(message) {
		var label = com.wiris.util.ui.component.Label.newImportantWithText(message);
		label.getStyle().setMargin(30,30,30,30);
		this.elementsPanel.addComponent(label);
	}
	,setGraphAnswers: function(elements,ratios,activeElements,distribute) {
		var surpassMaxRatio = false;
		if(ratios.length > 0) {
			var totalRatios = 0;
			var _g = 0;
			while(_g < ratios.length) {
				var ratio = ratios[_g];
				++_g;
				totalRatios += Std.parseFloat(ratio);
			}
			if(totalRatios < this.ROUND_VALUE || totalRatios > this.MAX_VALUE) surpassMaxRatio = true;
		}
		if(elements.length > 0) {
			var defaultAnswerWeight = 1.0 / elements.length * 100.0;
			var defaultAnswerLabel = (defaultAnswerWeight + "").substring(0,defaultAnswerWeight > 10.0?4:3);
			var lastAnswerWeight = 100.0 - (elements.length - 1.0) * Std.parseFloat(defaultAnswerLabel);
			var lastAnswerLabel = (lastAnswerWeight + "").substring(0,lastAnswerWeight > 10.0?4:3);
			var _g = 0;
			while(_g < elements.length) {
				var element = elements[_g];
				++_g;
				var options = new Array();
				if(elements.length > 10) options.push(defaultAnswerLabel);
				options.push("10");
				if(elements.length > 5 && elements.length < 10) options.push(defaultAnswerLabel);
				options.push("25");
				options.push("33.3");
				options.push("50");
				options.push("100");
				var active;
				var value;
				if(activeElements.length > 0) {
					var elementIndex = com.wiris.util.type.Arrays.indexOfElement(activeElements,element.getId());
					active = elementIndex >= 0;
					if(active) value = ratios[elementIndex]; else if(com.wiris.util.type.Arrays.indexOfElement(elements,element) == elements.length - 1) value = lastAnswerLabel; else value = defaultAnswerLabel;
				} else {
					active = false;
					if(com.wiris.util.type.Arrays.indexOfElement(elements,element) == elements.length - 1) value = lastAnswerLabel; else value = defaultAnswerLabel;
				}
				var validationElement = this.addElement(element,value,options);
				validationElement.setActive(active);
				validationElement.setEnabled(distribute);
				validationElement.setFieldVisible(active && distribute);
				validationElement.setInvalid(surpassMaxRatio);
				validationElement.addActionListener(this);
				validationElement.addMouseListener(this);
			}
		}
		this.updateHeaderCheckboxState();
		this.gradeDistribution.setSelected(distribute);
	}
	,clean: function() {
		this.elementsPanel.removeAllComponents();
		this.elements = new Array();
	}
	,addElement: function(elementSummary,value,options) {
		var element;
		if(elementSummary.isStatsPart()) element = com.wiris.quizzes.impl.ui.component.GraphValidationElement.newWithValue(elementSummary.getLabel(),elementSummary.getValue(),options,value); else element = com.wiris.quizzes.impl.ui.component.GraphValidationElement.newWithValue(this.controller.graphT("type_" + elementSummary.getType()) + " " + elementSummary.getId(),elementSummary.getDefinition(),options,value);
		element.setId(elementSummary.getId());
		element.getCheckbox().setId(elementSummary.getId() + "_cb");
		this.elements.push(element);
		this.elementsPanel.addComponent(element);
		return element;
	}
	,elements: null
	,lockCheckbox: null
	,controller: null
	,elementsPanel: null
	,gradeDistribution: null
	,checkBoxHeader: null
	,ROUND_VALUE: null
	,MAX_VALUE: null
	,__class__: com.wiris.quizzes.impl.ui.component.GraphValidationSelector
});
com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel = $hxClasses["com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel"] = function(controller) {
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	com.wiris.util.ui.component.FlowPanel.prototype.getStyle.call(this).setPadding(0,24,24,12);
	this.welcomeCard = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.welcomeCard.addClass(com.wiris.util.ui.component.Panel.CLASS_PANEL_CARD).addClass(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.CLASS_HOME_PAGE_WELCOME_PANEL);
	var welcomeHeader = com.wiris.util.ui.component.Label.newHeaderWithText(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_WELCOME_HEADER_TEXT));
	welcomeHeader.getStyle().setFontSize(17);
	var welcomeDescription = com.wiris.util.ui.component.Label.newWithText(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_WELCOME_DESCRIPTION_TEXT));
	welcomeDescription.getStyle().setMargin(12,0,12,0);
	var welcomeButtons = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	var releaseNotes = com.wiris.util.ui.component.HyperlinkButton.newWithText(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_RELEASE_NOTES_BUTTON_TEXT),com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().buildUrl(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_PAGE_RELEASE_NOTES_BUTTON_URL),null,controller);
	releaseNotes.getStyle().setMargin(8,0,8,0);
	var documentation = com.wiris.util.ui.component.HyperlinkButton.newWithText(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_DOCUMENTATION_BUTTON_TEXT),com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().buildUrl(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_DOCUMENTATION_BUTTON_URL),null,controller);
	documentation.getStyle().setMargin(8,0,8,0);
	var feedback = com.wiris.util.ui.component.HyperlinkButton.newWithText(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_GIVE_US_FEEDBACK_BUTTON_TEXT),com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_GIVE_US_YOUR_FEEDBACK_BUTTON_URL,null,controller);
	feedback.getStyle().setMargin(8,0,8,0);
	welcomeButtons.addComponent(releaseNotes.addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON));
	welcomeButtons.addComponent(documentation.addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON));
	welcomeButtons.addComponent(feedback.addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON));
	this.welcomeCard.addComponent(welcomeHeader);
	this.welcomeCard.addComponent(welcomeDescription);
	this.welcomeCard.addComponent(welcomeButtons);
	this.featurePanels = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	this.featurePanels.addClass(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.CLASS_GETTING_STARTED_FLOW_PANEL);
	var featurePanel1 = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	featurePanel1.addClass(com.wiris.util.ui.component.Panel.CLASS_PANEL_CARD).addClass(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.CLASS_GETTING_STARTED_PANEL);
	featurePanel1.getStyle().setMargin(0,12,24,0);
	var wrapperFeaturePanel1 = new com.wiris.util.ui.component.BorderPanel(false);
	wrapperFeaturePanel1.getStyle().setHeightWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT);
	var titleAndDescriptionFeaturePanel1 = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	var featureHeader1 = com.wiris.util.ui.component.Label.newHeaderWithText(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_CREATE_QUESTION_HEADER_TEXT));
	var featureDescription1 = com.wiris.util.ui.component.Label.newWithText(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_CREATE_QUESTION_TEXT));
	featureDescription1.getStyle().setMargin(12,0,12,0);
	titleAndDescriptionFeaturePanel1.addComponent(featureHeader1);
	titleAndDescriptionFeaturePanel1.addComponent(featureDescription1);
	var featureLearnMore1 = com.wiris.util.ui.component.HyperlinkButton.newWithText(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_LEARN_MORE_BUTTON_TEXT),com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().buildUrl(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_LEARN_MORE_BUTTON_URL),null,controller);
	featureLearnMore1.addClass(com.wiris.util.ui.component.Button.CLASS_BUTTON_CONTAINED).addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON);
	featureLearnMore1.getStyle().setMargin(8,0,8,0);
	wrapperFeaturePanel1.addComponent(titleAndDescriptionFeaturePanel1,com.wiris.util.ui.component.BorderPanel.POSITION_NORTH);
	wrapperFeaturePanel1.addComponent(featureLearnMore1,com.wiris.util.ui.component.BorderPanel.POSITION_SOUTH_WEST);
	featurePanel1.addComponent(wrapperFeaturePanel1);
	this.featurePanels.addComponent(featurePanel1);
	var featurePanel2 = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	featurePanel2.addClass(com.wiris.util.ui.component.Panel.CLASS_PANEL_CARD).addClass(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.CLASS_GETTING_STARTED_PANEL);
	featurePanel2.getStyle().setMargin(0,0,24,12);
	var wrapperFeaturePanel2 = new com.wiris.util.ui.component.BorderPanel(false);
	wrapperFeaturePanel2.getStyle().setHeightWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT);
	var titleAndDescriptionFeaturePanel2 = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	var featureHeader2 = com.wiris.util.ui.component.Label.newHeaderWithText(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_CREATE_RANDOM_QUESTION_HEADER_TEXT));
	var featureDescription2 = com.wiris.util.ui.component.Label.newWithText(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_CREATE_RANDOM_QUESTION_TEXT));
	featureDescription2.getStyle().setMargin(12,0,12,0);
	titleAndDescriptionFeaturePanel2.addComponent(featureHeader2);
	titleAndDescriptionFeaturePanel2.addComponent(featureDescription2);
	var bottomButtons = new com.wiris.util.ui.component.BorderPanel(false);
	var basicMode = com.wiris.util.ui.component.HyperlinkButton.newWithText(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_BASIC_MODE_BUTTON_TEXT),com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().buildUrl(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_BASIC_MODE_BUTTON_URL),null,controller);
	var advancedMode = com.wiris.util.ui.component.HyperlinkButton.newWithText(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_ADVANCED_MODE_BUTTON_TEXT),com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().buildUrl(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_ADVANCED_MODE_BUTTON_URL),null,controller);
	basicMode.addClass(com.wiris.util.ui.component.Button.CLASS_BUTTON_CONTAINED).addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON);
	basicMode.getStyle().setMargin(8,0,8,0);
	advancedMode.addClass(com.wiris.util.ui.component.Button.CLASS_BUTTON_CONTAINED).addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON);
	advancedMode.getStyle().setMargin(8,0,8,0);
	bottomButtons.addComponent(basicMode,com.wiris.util.ui.component.BorderPanel.POSITION_WEST);
	bottomButtons.addComponent(advancedMode,com.wiris.util.ui.component.BorderPanel.POSITION_EAST);
	wrapperFeaturePanel2.addComponent(titleAndDescriptionFeaturePanel2,com.wiris.util.ui.component.BorderPanel.POSITION_NORTH);
	wrapperFeaturePanel2.addComponent(bottomButtons,com.wiris.util.ui.component.BorderPanel.POSITION_SOUTH);
	featurePanel2.addComponent(wrapperFeaturePanel2);
	this.featurePanels.addComponent(featurePanel2);
	this.trainingPanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.trainingPanel.addClass(com.wiris.util.ui.component.Panel.CLASS_PANEL_CARD).addClass(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.CLASS_TRAINING_PANEL);
	var trainingHeader = com.wiris.util.ui.component.Label.newHeaderWithText(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_TRAINING_PANEL_HEADER_TEXT));
	var trainingDescription = com.wiris.util.ui.component.Label.newWithText(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_TRAINING_PANEL_TEXT));
	trainingDescription.getStyle().setMargin(12,0,12,0);
	var trainingButton = com.wiris.util.ui.component.HyperlinkButton.newWithText(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_ENROLL_ME_BUTTON_TEXT),com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().buildUrl(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_ENROLL_ME_BUTTON_URL),null,controller);
	trainingButton.addClass(com.wiris.util.ui.component.Button.CLASS_BUTTON_CONTAINED).addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON);
	trainingButton.getStyle().setMargin(8,0,8,0);
	this.trainingPanel.addComponent(trainingHeader);
	this.trainingPanel.addComponent(trainingDescription);
	this.trainingPanel.addComponent(trainingButton);
	this.actionsPanel = new com.wiris.util.ui.component.BorderPanel(false);
	var contactUs = com.wiris.util.ui.component.HyperlinkButton.newWithTextAndIcon(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_CONTACT_US_BUTTON_TEXT),new com.wiris.util.ui.MaterialIcon("alternate_email"),com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().buildUrl(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_CONTACT_US_BUTTON_URL),null,controller);
	contactUs.addClass(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.CLASS_GETTING_STARTED_ABOUT_US_BUTTON).addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON);
	contactUs.getStyle().setMargin(0,0,0,12);
	var visitOurWebpage = com.wiris.util.ui.component.HyperlinkButton.newWithTextAndIcon(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_VISIT_OUR_WEBPAGE_BUTTON_TEXT),new com.wiris.util.ui.MaterialIcon("language"),com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().buildUrl(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_VISIT_OUR_WEBPAGE_BUTTON_URL),null,controller);
	visitOurWebpage.addClass(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.CLASS_GETTING_STARTED_ABOUT_US_BUTTON).addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON);
	var reportAnIssue = com.wiris.util.ui.component.HyperlinkButton.newWithTextAndIcon(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_REPORT_AN_ISSUE_BUTTON_TEXT),new com.wiris.util.ui.MaterialIcon("bug_report"),com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().buildUrl(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.HOME_GETTING_STARTED_REPORT_AN_ISSUE_BUTTON_URL),null,controller);
	reportAnIssue.addClass(com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.CLASS_GETTING_STARTED_ABOUT_US_BUTTON).addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON);
	reportAnIssue.getStyle().setMargin(0,21,0,0);
	this.actionsPanel.addComponent(contactUs,com.wiris.util.ui.component.BorderPanel.POSITION_WEST);
	this.actionsPanel.addComponent(visitOurWebpage,com.wiris.util.ui.component.BorderPanel.POSITION_CENTER);
	this.actionsPanel.addComponent(reportAnIssue,com.wiris.util.ui.component.BorderPanel.POSITION_EAST);
	this.addComponent(this.welcomeCard);
	this.addComponent(this.featurePanels);
	this.addComponent(this.trainingPanel);
	this.addComponent(this.actionsPanel);
};
com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.__name__ = ["com","wiris","quizzes","impl","ui","component","HomeGettingStartedPanel"];
com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	actionsPanel: null
	,trainingPanel: null
	,featurePanels: null
	,welcomeCard: null
	,__class__: com.wiris.quizzes.impl.ui.component.HomeGettingStartedPanel
});
com.wiris.quizzes.impl.ui.component.HomeMainContentContainer = $hxClasses["com.wiris.quizzes.impl.ui.component.HomeMainContentContainer"] = function(controller) {
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.addClass(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_MAIN_CONTENT_CONTAINER_CLASS);
	this.correctAnswerInitialContent = new com.wiris.util.ui.component.ToggleButtonsPanel();
	var initialContent = com.wiris.util.ui.component.ToggleButton.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_INITIAL_CONTENT_BUTTON_TEXT),com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.INITIAL_CONTENT_SELECTABLE_ID,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.ACTION_INITIAL_CONTENT_SELECTED,com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.ACTION_INITIAL_CONTENT_SELECTED),controller);
	initialContent.setId("initialContent");
	this.correctAnswerInitialContent.addToggleButton(initialContent,false,true);
	var correctAnswer = com.wiris.util.ui.component.ToggleButton.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_CORRECT_ANSWER_BUTTON_TEXT),com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.CORRECT_ANSWER_SELECTABLE_ID,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.ACTION_CORRECT_ANSWER_SELECTED,com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.ACTION_CORRECT_ANSWER_SELECTED),controller);
	correctAnswer.setId("correctAnswer");
	this.correctAnswerInitialContent.addToggleButton(correctAnswer,true,true);
	this.addComponent(this.correctAnswerInitialContent);
	this.getStyle().setPadding(0,24,24,12);
	this.description = com.wiris.util.ui.component.Label.newWithText(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_CORRECT_ANSWER_DESCRIPTION_MATH);
	this.description.getStyle().setMargin(12,0,12,0).setLineHeight(18);
	this.addComponent(this.description);
	this.auxiliarDescription = com.wiris.util.ui.component.Label.newWithText(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_CORRECT_ANSWER_DESCRIPTION_SKETCH_PARAGRAPH_2);
	this.auxiliarDescription.getStyle().setMargin(0,0,12,0).setLineHeight(18);
	this.addComponent(this.auxiliarDescription);
	this.compoundMathtype = new com.wiris.quizzes.impl.ui.component.QuizzesCompoundMathTypePopupTextField(null,null,this,null);
	this.compoundMathtype.setId("mainCompoundMathField");
	this.compoundMathtype.setChangeActionId(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.ACTION_MAIN_CONTENT_CHANGED);
	this.compoundMathtype.addActionListener(controller);
	this.compoundMathtype.setVisible(false);
	this.compoundMathtype.setEasyModalClose(true);
	this.compoundTextField = new com.wiris.quizzes.impl.ui.component.QuizzesCompoundTextField(null,null,this);
	this.compoundTextField.setId("mainCompoundTextField");
	this.compoundTextField.setChangeActionId(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.ACTION_MAIN_CONTENT_CHANGED);
	this.compoundTextField.addActionListener(controller);
	this.compoundTextField.setVisible(false);
	var mtParams = new Hash();
	mtParams.set("flexEditor","true");
	this.mathtype = new com.wiris.quizzes.impl.ui.component.MathTypeInputComponent(mtParams,false);
	this.mathtype.addClass(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.CLASS_MAIN_COMPONENT_MATHTYPE).setId("mainMathField").getStyle().setMaxWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT);
	this.mathtype.setChangeAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.ACTION_MAIN_CONTENT_CHANGED,null));
	this.mathtype.addActionListener(controller);
	this.textField = com.wiris.util.ui.component.TextField.newWithLabel(controller.t(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_CORRECT_ANSWER_BUTTON_TEXT));
	this.textField.setId("mainTextField");
	this.textField.setChangeAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.ACTION_MAIN_CONTENT_CHANGED,null));
	this.textField.addActionListener(controller);
	this.textField.setVisible(false);
	var parameters = new Hash();
	parameters.set(com.wiris.quizzes.impl.ui.component.GraphInputComponent.PARAM_ALLOW_ANIMATIONS,"true");
	parameters.set(com.wiris.quizzes.impl.Assertion.PARAM_GRAPH_MODE,com.wiris.quizzes.impl.Assertion.GRAPH_MODE_STANDARD);
	this.graph = new com.wiris.quizzes.impl.ui.component.GraphInputComponent(parameters);
	this.graph.setId("mainGraph");
	this.graph.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setHeight(470);
	this.graph.setChangeAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.ACTION_MAIN_CONTENT_CHANGED,null));
	this.graph.addActionListener(controller);
	this.copyCorrectAnswerButton = com.wiris.util.ui.component.Button.newWithTextAndIcon(controller.t(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_COPY_CORRECT_ANSWER_BUTTON_TEXT),new com.wiris.util.ui.MaterialIcon("undo"),new com.wiris.util.ui.Action("copyCorrectAnswer",null),controller);
	this.copyCorrectAnswerButton.addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON);
	this.copyCorrectAnswerButton.setId("copyCorrectAnswerButton");
	this.copyInitialContentButton = com.wiris.util.ui.component.Button.newWithTextAndIcon(controller.t(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_COPY_INITIAL_CONTENT_BUTTON_TEXT),new com.wiris.util.ui.MaterialIcon("redo"),new com.wiris.util.ui.Action("copyInitialContent",null),controller);
	this.copyInitialContentButton.addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON);
	this.copyInitialContentButton.setId("copyInitialContentButton");
	this.mainfieldAndCopyButton = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.mainfieldAndCopyButton.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setHorizontalAlignment(com.wiris.util.ui.Style.HORIZONTAL_ALIGNMENT_RIGHT);
	this.mainfieldAndCopyButton.addComponent(this.copyCorrectAnswerButton);
	this.mainfieldAndCopyButton.addComponent(this.copyInitialContentButton);
	this.mainfieldAndCopyButton.addComponent(this.compoundMathtype);
	this.mainfieldAndCopyButton.addComponent(this.compoundTextField);
	this.mainfieldAndCopyButton.addComponent(this.mathtype);
	this.mainfieldAndCopyButton.addComponent(this.graph);
	this.mainfieldAndCopyButton.addComponent(this.textField);
	this.addComponent(this.mainfieldAndCopyButton);
	this.randomVariables = new com.wiris.quizzes.impl.ui.component.RandomVariablesComponent(controller);
	this.randomVariables.addActionListener(this);
	this.addComponent(this.randomVariables);
};
com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.__name__ = ["com","wiris","quizzes","impl","ui","component","HomeMainContentContainer"];
com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.__interfaces__ = [com.wiris.util.ui.interaction.ActionListener,com.wiris.util.ui.interaction.MouseListener];
com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	mouseExit: function(e) {
	}
	,mouseEnter: function(e) {
	}
	,mouseRelease: function(e) {
	}
	,mousePress: function(e) {
	}
	,mouseDoubleClick: function(e) {
	}
	,mouseClick: function(e) {
	}
	,actionPerformed: function(e) {
	}
	,getGraphComponent: function() {
		return this.graph;
	}
	,getMainFocus: function() {
		if(this.textField.isVisible()) return this.textField; else if(this.graph.isVisible()) return this.graph; else if(this.mathtype.isVisible()) return this.mathtype; else return null;
	}
	,updateCompoundMathType: function(value,params) {
		this.compoundMathtype.setValue(value);
		if(params != null) this.compoundMathtype.setParameters(params);
	}
	,updateCompoundText: function(value) {
		this.compoundTextField.setValue(value);
	}
	,updateText: function(value,initialContent) {
		this.textField.setValue(value);
		this.textField.setLabel(initialContent?com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_INITIAL_CONTENT_BUTTON_TEXT):com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_CORRECT_ANSWER_BUTTON_TEXT));
	}
	,updateGraph: function(value,toolbar,enableHidingActions) {
		this.graph.setValue(value);
		this.graph.updateGraphToolbar(toolbar);
		this.graph.setHidingActionsEnabled(enableHidingActions);
	}
	,updateMathType: function(value,params) {
		this.mathtype.setValue(value);
		if(params != null) this.mathtype.setParameters(params);
	}
	,isAnswerFieldTypeMathEditor: function(type) {
		return type == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_MATH_EDITOR || type == com.wiris.quizzes.api.ui.AnswerFieldType.POPUP_MATH_EDITOR;
	}
	,updateVisibility: function(context) {
		var show = context.isOptOpenAnswer();
		this.correctAnswerInitialContent.setVisible(show);
		this.description.setVisible(show);
		this.mainfieldAndCopyButton.setVisible(show);
		this.auxiliarDescription.setVisible(false);
		var slot = context.getSlot();
		var syntaxName = slot.getSyntax().getName();
		var homePageStatus = context.getHomePageStatusCorrectAnswerInitialContent();
		this.correctAnswerInitialContent.pickTogglebuttonWithId(homePageStatus == com.wiris.quizzes.impl.ui.QuizzesStudioContext.HOME_PAGE_STATUS_CORRECT_ANSWER?com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.CORRECT_ANSWER_SELECTABLE_ID:com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.INITIAL_CONTENT_SELECTABLE_ID);
		if(homePageStatus == com.wiris.quizzes.impl.ui.QuizzesStudioContext.HOME_PAGE_STATUS_CORRECT_ANSWER) {
			this.mathtype.setVisible(syntaxName == com.wiris.quizzes.api.assertion.SyntaxName.MATH);
			this.textField.setVisible(syntaxName == com.wiris.quizzes.api.assertion.SyntaxName.STRING);
			this.graph.setVisible(syntaxName == com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC);
			this.compoundMathtype.setVisible(false);
			this.compoundTextField.setVisible(false);
			var value = context.getAuthorAnswer().getValue();
			if(syntaxName == com.wiris.quizzes.api.assertion.SyntaxName.MATH) {
				this.description.setText(context.t(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_CORRECT_ANSWER_DESCRIPTION_MATH));
				this.updateMathType(value,context.getMathTypeParameters());
			} else if(syntaxName == com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC) {
				if(context.getAuthorAnswer().getComparison().getName() == com.wiris.quizzes.api.assertion.ComparisonName.GRAPHICALLY_EQUAL) {
					this.description.setText(context.t(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_CORRECT_ANSWER_DESCRIPTION_GRAPHIC));
					var graphToolbar = slot.getProperty(com.wiris.quizzes.api.PropertyName.GRAPH_TOOLBAR);
					var mode = slot.getSyntax().getParameter(com.wiris.quizzes.api.assertion.SyntaxParameterName.GRAPH_MODE);
					this.updateGraph(value,graphToolbar != null?com.wiris.util.ui.controller.ToolbarDefinition.deserialize(graphToolbar):com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.getDefaultToolbarDefinition(mode),false);
				} else if(context.getAuthorAnswer().getComparison().getName() == com.wiris.quizzes.api.assertion.ComparisonName.SKETCH_EQUAL) {
					this.description.setText(context.t(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_CORRECT_ANSWER_DESCRIPTION_SKETCH_PARAGRAPH_1));
					this.auxiliarDescription.setText(context.t(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_CORRECT_ANSWER_DESCRIPTION_SKETCH_PARAGRAPH_2));
					this.auxiliarDescription.setVisible(true);
					var mode = slot.getSyntax().getParameter(com.wiris.quizzes.api.assertion.SyntaxParameterName.GRAPH_MODE);
					this.updateGraph(value,com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.getDefaultToolbarDefinition(mode),false);
				}
			} else {
				this.description.setText(context.t(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_CORRECT_ANSWER_DESCRIPTION_TEXT));
				this.updateText(value,false);
			}
		} else {
			var answerFieldType = slot.getAnswerFieldType();
			var isCompoundAnswer = "true" == slot.getProperty(com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER);
			var isSimpleMathType = this.isAnswerFieldTypeMathEditor(answerFieldType) && !isCompoundAnswer;
			this.mathtype.setVisible(isSimpleMathType);
			var isSimpleTextField = answerFieldType == com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD && !isCompoundAnswer;
			this.textField.setVisible(isSimpleTextField);
			this.graph.setVisible(answerFieldType == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR);
			var isCompoundMathType = this.isAnswerFieldTypeMathEditor(answerFieldType) && isCompoundAnswer;
			this.compoundMathtype.setVisible(isCompoundMathType);
			var isCompoundTextField = answerFieldType == com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD && isCompoundAnswer;
			this.compoundTextField.setVisible(isCompoundTextField);
			var value = slot.getInitialContent();
			if(isSimpleMathType) {
				this.description.setText(context.t(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_INITIAL_CONTENT_DESCRIPTION_MATH));
				value = StringTools.replace(value,"wrs:positionable=\"false\"","");
				this.updateMathType(value,context.getMathTypeParameters());
			} else if(isSimpleTextField) {
				this.description.setText(context.t(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_INITIAL_CONTENT_DESCRIPTION_TEXT));
				this.updateText(value,true);
			} else if(isCompoundMathType) {
				this.description.setText(context.t(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_INITIAL_CONTENT_DESCRIPTION_MATH));
				this.updateCompoundMathType(slot.getInitialContent(),context.getMathTypeParameters());
			} else if(isCompoundTextField) {
				this.description.setText(context.t(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_INITIAL_CONTENT_DESCRIPTION_TEXT));
				this.updateCompoundText(slot.getInitialContent());
			} else if(context.getAuthorAnswer().getComparison().getName() == com.wiris.quizzes.api.assertion.ComparisonName.SKETCH_EQUAL) {
				this.description.setText(context.t(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_INITIAL_CONTENT_DESCRIPTION_SKETCH));
				this.updateGraph(value,com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.getDefaultToolbarDefinition(com.wiris.quizzes.impl.Assertion.GRAPH_MODE_STANDARD),true);
			} else {
				this.description.setText(context.t(com.wiris.quizzes.impl.ui.component.HomeMainContentContainer.HOME_INITIAL_CONTENT_DESCRIPTION_GRAPHIC));
				var mode = slot.getSyntax().getParameter(com.wiris.quizzes.api.assertion.SyntaxParameterName.GRAPH_MODE);
				this.updateGraph(value,com.wiris.quizzes.impl.ui.component.CustomizeToolbarComponent.getDefaultToolbarDefinition(mode),true);
			}
		}
		this.copyCorrectAnswerButton.setVisible(homePageStatus == com.wiris.quizzes.impl.ui.QuizzesStudioContext.HOME_PAGE_STATUS_INITIAL_CONTENT);
		this.copyInitialContentButton.setVisible(homePageStatus == com.wiris.quizzes.impl.ui.QuizzesStudioContext.HOME_PAGE_STATUS_CORRECT_ANSWER);
		this.randomVariables.updateVisibility(context);
	}
	,randomVariables: null
	,correctAnswerInitialContent: null
	,mainfieldAndCopyButton: null
	,copyCorrectAnswerButton: null
	,copyInitialContentButton: null
	,auxiliarDescription: null
	,description: null
	,textField: null
	,graph: null
	,mathtype: null
	,compoundTextField: null
	,compoundMathtype: null
	,__class__: com.wiris.quizzes.impl.ui.component.HomeMainContentContainer
});
com.wiris.quizzes.impl.ui.component.InputMethodComponent = $hxClasses["com.wiris.quizzes.impl.ui.component.InputMethodComponent"] = function(controller) {
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_FULL_SIZE_PANEL);
	this.controller = controller;
	this.label = com.wiris.util.ui.component.Label.newImportantWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_FIELD_LABEL));
	var content = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	content.addClass(com.wiris.util.ui.component.Panel.CLASS_PANEL_CARD);
	this.inputFieldContainer = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	var inputFieldLabel = com.wiris.util.ui.component.Label.newImportantWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ANSWER_INPUT_FIELD_LABEL));
	this.inputFieldSelectionController = com.wiris.util.ui.controller.SelectionController.newMutuallyExclusive(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_FIELD_ID);
	this.mathEditorEmbeddedRadioButton = com.wiris.util.ui.component.RadioButton.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_LABEL_MATHEDITOR_EMBEDDED),controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_HELPER_TEXT_MATHEDITOR_EMBEDDED),com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_MATHEDITOR_EMBEDDED,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_MATHEDITOR_EMBEDDED,null),controller);
	this.mathEditorEmbeddedRadioButton.setId("inputOptionsEmbeddedMathtype");
	this.inputFieldSelectionController.addSelectable(this.mathEditorEmbeddedRadioButton,true);
	this.mathEditorPopupRadioButton = com.wiris.util.ui.component.RadioButton.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_LABEL_MATHEDITOR_POPUP),controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_HELPER_TEXT_MATHEDITOR_POPUP),com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_MATHEDITOR_POPUP,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_MATHEDITOR_POPUP,null),controller);
	this.mathEditorPopupRadioButton.setId("inputOptionsPopupMathtype");
	this.inputFieldSelectionController.addSelectable(this.mathEditorPopupRadioButton,false);
	this.plainTextRadioButton = com.wiris.util.ui.component.RadioButton.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_LABEL_PLAINTEXT),controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_HELPER_TEXT_PLAINTEXT),com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_PLAINTEXT,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_PLAINTEXT,null),controller);
	this.plainTextRadioButton.setId("inputOptionsPlainText");
	this.inputFieldSelectionController.addSelectable(this.plainTextRadioButton,false);
	this.inputFieldContainer.addComponent(inputFieldLabel);
	this.inputFieldContainer.addComponent(this.mathEditorEmbeddedRadioButton);
	this.inputFieldContainer.addComponent(this.mathEditorPopupRadioButton);
	this.inputFieldContainer.addComponent(this.plainTextRadioButton);
	this.auxiliaryInputContainer = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.auxiliaryInputContainer.getStyle().setWidth(com.wiris.util.ui.Style.SIZE_FULL);
	var auxiliaryInputLabel = com.wiris.util.ui.component.Label.newImportantWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_AUXILIARY_INPUT_LABEL));
	this.auxiliaryInputFieldSelectionController = com.wiris.util.ui.controller.SelectionController.newMutuallyExclusive(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_FIELD_ID);
	var displayAuxiliaryPanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	displayAuxiliaryPanel.setIndentationLevel(2);
	displayAuxiliaryPanel.setId("inputOptionsDisplayAuxiliaryInputHideFileMenuPanel");
	this.displayAuxiliaryContainer = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.displayAuxiliaryExpansionController = new com.wiris.util.ui.controller.ExpansionController(this,displayAuxiliaryPanel,false);
	this.displayAuxiliaryInputRadioButton = com.wiris.util.ui.component.RadioButton.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_LABEL_DISPLAY_AUXILIARY_INPUT),controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_HELPER_TEXT_DISPLAY_AUXILIARY_INPUT),com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_DISPLAY_AUXILIARY_INPUT,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_DISPLAY_AUXILIARY_INPUT,null),controller);
	this.displayAuxiliaryInputRadioButton.setId("inputOptionsDisplayAuxiliaryInput");
	this.auxiliaryInputFieldSelectionController.addSelectable(this.displayAuxiliaryInputRadioButton,false);
	this.displayAuxiliaryInputRadioButton.addActionListener(this);
	this.displayAuxiliaryInputHideFileMenuCheckBox = com.wiris.util.ui.component.CheckBox.newWithHelperText(this.controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_LABEL_HIDE_FILE_MENU_AUXILIARY_INPUT),this.controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_HELPER_TEXT_HIDE_FILE_MENU_AUXILIARY_INPUT),com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_DISPLAY_AUXILIARY_INPUT,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_AUXILIARY_CAS_HIDE_FILE_MENU,null),controller);
	this.displayAuxiliaryInputHideFileMenuCheckBox.setId("inputOptionsDisplayAuxiliaryInputHideFileMenu");
	displayAuxiliaryPanel.addComponent(this.displayAuxiliaryInputHideFileMenuCheckBox);
	this.displayAuxiliaryContainer.addComponent(this.displayAuxiliaryInputRadioButton);
	this.displayAuxiliaryContainer.addComponent(displayAuxiliaryPanel);
	this.textAuxiliaryInputRadioButton = com.wiris.util.ui.component.RadioButton.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_LABEL_TEXT_AUXILIARY_INPUT),controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_HELPER_TEXT_TEXT_AUXILIARY_INPUT),com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_TEXT_AUXILIARY_INPUT,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_TEXT_AUXILIARY_INPUT,null),controller);
	this.textAuxiliaryInputRadioButton.setId("inputOptionsTextAuxiliaryInput");
	this.auxiliaryInputFieldSelectionController.addSelectable(this.textAuxiliaryInputRadioButton,false);
	this.textAuxiliaryInputRadioButton.addActionListener(this);
	var replaceAuxiliaryPanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	replaceAuxiliaryPanel.setIndentationLevel(2);
	replaceAuxiliaryPanel.setId("inputOptionsReplaceAuxiliaryInputHideFileMenuPanel");
	this.replaceAuxiliaryContainer = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.replaceAuxiliaryExpansionController = new com.wiris.util.ui.controller.ExpansionController(this,replaceAuxiliaryPanel,false);
	this.replaceAuxiliaryInputRadioButton = com.wiris.util.ui.component.RadioButton.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_LABEL_REPLACE_AUXILIARY_INPUT),controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_HELPER_TEXT_REPLACE_AUXILIARY_INPUT),com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_REPLACE_AUXILIARY_INPUT,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_REPLACE_AUXILIARY_INPUT,null),controller);
	this.replaceAuxiliaryInputRadioButton.setId("inputOptionsReplaceAuxiliaryInput");
	this.auxiliaryInputFieldSelectionController.addSelectable(this.replaceAuxiliaryInputRadioButton,false);
	this.replaceAuxiliaryInputRadioButton.addActionListener(this);
	this.replaceAuxiliaryInputHideFileMenuCheckBox = com.wiris.util.ui.component.CheckBox.newWithHelperText(this.controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_LABEL_HIDE_FILE_MENU_AUXILIARY_INPUT),this.controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_HELPER_TEXT_HIDE_FILE_MENU_AUXILIARY_INPUT),com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_REPLACE_AUXILIARY_INPUT,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_AUXILIARY_CAS_HIDE_FILE_MENU,null),controller);
	this.replaceAuxiliaryInputHideFileMenuCheckBox.setId("inputOptionsReplaceAuxiliaryInputHideFileMenu");
	replaceAuxiliaryPanel.addComponent(this.replaceAuxiliaryInputHideFileMenuCheckBox);
	this.replaceAuxiliaryContainer.addComponent(this.replaceAuxiliaryInputRadioButton);
	this.replaceAuxiliaryContainer.addComponent(replaceAuxiliaryPanel);
	this.noAuxiliaryInputRadioButton = com.wiris.util.ui.component.RadioButton.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_LABEL_NO_AUXILIARY_INPUT),controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_HELPER_TEXT_NO_AUXILIARY_INPUT),com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_NO_AUXILIARY_INPUT,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_NO_AUXILIARY_INPUT,null),controller);
	this.noAuxiliaryInputRadioButton.setId("inputOptionsNoAuxiliaryInput");
	this.auxiliaryInputFieldSelectionController.addSelectable(this.noAuxiliaryInputRadioButton,true);
	this.noAuxiliaryInputRadioButton.addActionListener(this);
	this.displayDefineInitialContentButton = com.wiris.util.ui.component.Button.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_DEFINE_INITIAL_CONTENT_BUTTON_LABEL),new com.wiris.util.ui.Action("showActivity",com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.QUIZZES_STUDIO_AUXILIARY_INITIAL_CONTENT_ID),controller);
	this.displayDefineInitialContentButton.addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON).setId("inputOptionsDefineInitialContent");
	this.displayDefineInitialContentButton.setVisible(false);
	this.replaceDefineInitialContentButton = com.wiris.util.ui.component.Button.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_DEFINE_INITIAL_CONTENT_BUTTON_LABEL),new com.wiris.util.ui.Action("showActivity",com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.QUIZZES_STUDIO_AUXILIARY_INITIAL_CONTENT_ID),controller);
	this.replaceDefineInitialContentButton.addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON).setId("inputOptionsDefineInitialContent");
	this.replaceDefineInitialContentButton.setVisible(false);
	this.displayAuxiliaryInputPanel = new com.wiris.util.ui.component.BorderPanel(false);
	this.displayAuxiliaryInputPanel.setId("inputOptionsDisplayAuxiliaryInput");
	this.displayAuxiliaryInputPanel.addComponent(this.displayAuxiliaryContainer,com.wiris.util.ui.component.BorderPanel.POSITION_WEST);
	this.displayAuxiliaryInputPanel.addComponent(this.displayDefineInitialContentButton,com.wiris.util.ui.component.BorderPanel.POSITION_EAST);
	this.replaceAuxiliaryInputPanel = new com.wiris.util.ui.component.BorderPanel(false);
	this.replaceAuxiliaryInputPanel.setId("inputOptionsReplaceAuxiliaryInput");
	this.replaceAuxiliaryInputPanel.addComponent(this.replaceAuxiliaryContainer,com.wiris.util.ui.component.BorderPanel.POSITION_WEST);
	this.replaceAuxiliaryInputPanel.addComponent(this.replaceDefineInitialContentButton,com.wiris.util.ui.component.BorderPanel.POSITION_EAST);
	this.auxiliaryInputContainer.addComponent(auxiliaryInputLabel);
	this.auxiliaryInputContainer.addComponent(this.displayAuxiliaryInputPanel);
	this.auxiliaryInputContainer.addComponent(this.replaceAuxiliaryInputPanel);
	this.auxiliaryInputContainer.addComponent(this.textAuxiliaryInputRadioButton);
	this.auxiliaryInputContainer.addComponent(this.noAuxiliaryInputRadioButton);
	this.lockContainer = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	var lockInitialContentLabel = com.wiris.util.ui.component.Label.newImportantWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_LABEL_INITIAL_CONTENT));
	this.lockCheckbox = com.wiris.util.ui.component.CheckBox.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_LABEL_LOCK_INITIAL_CONTENT),controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_HELPER_TEXT_LOCK_INITIAL_CONTENT),"lockInitialContent",new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputMethodComponent.ACTION_LOCK_INITIAL_CONTENT,com.wiris.quizzes.impl.ui.component.InputMethodComponent.ACTION_LOCK_INITIAL_CONTENT),controller);
	this.lockContainer.addComponent(lockInitialContentLabel);
	this.lockContainer.addComponent(this.lockCheckbox);
	this.displaySettingsContainer = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	var displaySettingsLabel = com.wiris.util.ui.component.Label.newImportantWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_LABEL_DISPLAY_SETTINGS));
	var displaySettingsText = com.wiris.util.ui.component.Label.newTinyWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_HELPER_TEXT_DISPLAY_SETTINGS));
	var displaySettingsLabelName = com.wiris.util.ui.component.Label.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_LABEL_DISPLAY_SETTINGS_NAME));
	this.displayNameDropdown = new com.wiris.util.ui.component.Dropdown();
	this.displayNameDropdown.addValue(com.wiris.util.graphics.DisplaySettings.ALWAYS,controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.ALWAYS));
	this.displayNameDropdown.addValue(com.wiris.util.graphics.DisplaySettings.FOCUS,controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.FOCUS));
	this.displayNameDropdown.addValue(com.wiris.util.graphics.DisplaySettings.NEVER,controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.NEVER));
	this.displayNameDropdown.pickValue(com.wiris.util.graphics.DisplaySettings.ALWAYS);
	this.displayNameDropdown.setChangeValueAction(new com.wiris.util.ui.Action("graphDisplayNameInLabels",null));
	this.displayNameDropdown.addActionListener(this.controller);
	this.displaySettingsContainerName = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	this.displaySettingsContainerName.addClass(com.wiris.quizzes.impl.ui.component.InputMethodComponent.CLASS_SEPARATOR_ROW_DISPLAY);
	this.displaySettingsContainerName.addComponent(displaySettingsLabelName);
	this.displaySettingsContainerName.addComponent(this.displayNameDropdown);
	var displaySettingsLabelValue = com.wiris.util.ui.component.Label.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_LABEL_DISPLAY_SETTINGS_VALUE));
	this.displayValueDropdown = new com.wiris.util.ui.component.Dropdown();
	this.displayValueDropdown.addValue(com.wiris.util.graphics.DisplaySettings.ALWAYS,controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.ALWAYS));
	this.displayValueDropdown.addValue(com.wiris.util.graphics.DisplaySettings.FOCUS,controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.FOCUS));
	this.displayValueDropdown.addValue(com.wiris.util.graphics.DisplaySettings.NEVER,controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.NEVER));
	this.displayValueDropdown.pickValue(com.wiris.util.graphics.DisplaySettings.FOCUS);
	this.displayValueDropdown.setChangeValueAction(new com.wiris.util.ui.Action("graphDisplayValueInLabels",null));
	this.displayValueDropdown.addActionListener(this.controller);
	this.displaySettingsContainerValue = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	this.displaySettingsContainerValue.addClass(com.wiris.quizzes.impl.ui.component.InputMethodComponent.CLASS_SEPARATOR_ROW_DISPLAY);
	this.displaySettingsContainerValue.addComponent(displaySettingsLabelValue);
	this.displaySettingsContainerValue.addComponent(this.displayValueDropdown);
	this.displaySettingsContainer.addComponent(displaySettingsLabel);
	this.displaySettingsContainer.addComponent(this.displaySettingsContainerName);
	this.displaySettingsContainer.addComponent(this.displaySettingsContainerValue);
	this.displaySettingsContainer.addComponent(displaySettingsText);
	this.magneticGridContainer = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	var magneticGridLabel = com.wiris.util.ui.component.Label.newImportantWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_MAGNETIC_GRID));
	var magneticGridText = com.wiris.util.ui.component.Label.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_MAGNETIC_GRID_TEXT));
	this.magneticGridSmallContainer = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	this.magneticGridSmallContainer.addClass(com.wiris.quizzes.impl.ui.component.InputMethodComponent.CLASS_SEPARATOR_ROW_DISPLAY);
	this.magneticGridDropdown = new com.wiris.util.ui.component.Dropdown();
	this.magneticGridDropdown.addValue(com.wiris.util.graphics.DisplaySettings.FORCE,controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.FORCE));
	this.magneticGridDropdown.addValue(com.wiris.util.graphics.DisplaySettings.SNAP,controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.SNAP));
	this.magneticGridDropdown.addValue(com.wiris.util.graphics.DisplaySettings.DISABLED,controller.t(com.wiris.quizzes.impl.ui.component.InputMethodComponent.DISABLED));
	this.magneticGridDropdown.pickValue(com.wiris.util.graphics.DisplaySettings.SNAP);
	this.magneticGridDropdown.setChangeValueAction(new com.wiris.util.ui.Action("graphDisplayMagneticGrid",null));
	this.magneticGridDropdown.addActionListener(this.controller);
	this.magneticGridSmallContainer.addComponent(magneticGridText);
	this.magneticGridSmallContainer.addComponent(this.magneticGridDropdown);
	this.magneticGridContainer.addComponent(magneticGridLabel);
	this.magneticGridContainer.addComponent(this.magneticGridSmallContainer);
	content.addComponent(this.inputFieldContainer);
	content.addComponent(this.auxiliaryInputContainer);
	content.addComponent(this.lockContainer);
	content.addComponent(this.displaySettingsContainer);
	content.addComponent(this.magneticGridContainer);
	this.addComponent(this.label);
	this.addComponent(content);
};
com.wiris.quizzes.impl.ui.component.InputMethodComponent.__name__ = ["com","wiris","quizzes","impl","ui","component","InputMethodComponent"];
com.wiris.quizzes.impl.ui.component.InputMethodComponent.__interfaces__ = [com.wiris.util.ui.interaction.ActionListener];
com.wiris.quizzes.impl.ui.component.InputMethodComponent.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.quizzes.impl.ui.component.InputMethodComponent.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	actionPerformed: function(e) {
		var action = e.getAction();
		var actionId = action.getId();
		var source = e.getSource();
		if(actionId == com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_NO_AUXILIARY_INPUT || actionId == com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_TEXT_AUXILIARY_INPUT) {
			if(source.isSelected()) {
				this.displayDefineInitialContentButton.setVisible(false);
				this.replaceDefineInitialContentButton.setVisible(false);
				this.displayAuxiliaryExpansionController.collapse();
				this.replaceAuxiliaryExpansionController.collapse();
			}
		} else if(actionId == com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_REPLACE_AUXILIARY_INPUT) {
			if(source.isSelected()) {
				this.displayDefineInitialContentButton.setVisible(false);
				this.displayAuxiliaryExpansionController.collapse();
				this.replaceDefineInitialContentButton.setVisible(true);
				this.replaceAuxiliaryExpansionController.expand();
			}
		} else if(actionId == com.wiris.quizzes.impl.ui.component.InputMethodComponent.INPUT_METHOD_ID_DISPLAY_AUXILIARY_INPUT) {
			if(source.isSelected()) {
				this.displayDefineInitialContentButton.setVisible(true);
				this.displayAuxiliaryExpansionController.expand();
				this.replaceDefineInitialContentButton.setVisible(false);
				this.replaceAuxiliaryExpansionController.collapse();
			}
		}
	}
	,setAuxiliaryInput: function(auxiliaryInput,auxiliaryTextInput,hideCasFileMenu) {
		if(auxiliaryInput == com.wiris.quizzes.api.QuizzesConstants.PROPERTY_VALUE_SHOW_CAS_FALSE) {
			if(auxiliaryTextInput != null && auxiliaryTextInput == "true") this.textAuxiliaryInputRadioButton.setSelected(true); else this.noAuxiliaryInputRadioButton.setSelected(true);
		} else if(auxiliaryInput == com.wiris.quizzes.api.QuizzesConstants.PROPERTY_VALUE_SHOW_CAS_REPLACE) {
			this.replaceAuxiliaryInputRadioButton.setSelected(true);
			if(hideCasFileMenu != null && hideCasFileMenu == "true") this.replaceAuxiliaryInputHideFileMenuCheckBox.setSelected(true); else this.replaceAuxiliaryInputHideFileMenuCheckBox.setSelected(false);
		} else if(auxiliaryInput == com.wiris.quizzes.api.QuizzesConstants.PROPERTY_VALUE_SHOW_CAS_ADD) {
			this.displayAuxiliaryInputRadioButton.setSelected(true);
			if(hideCasFileMenu != null && hideCasFileMenu == "true") this.displayAuxiliaryInputHideFileMenuCheckBox.setSelected(true); else this.displayAuxiliaryInputHideFileMenuCheckBox.setSelected(false);
		}
	}
	,setInputMethod: function(inputMethod) {
		if(inputMethod == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_MATH_EDITOR) this.mathEditorEmbeddedRadioButton.setSelected(true); else if(inputMethod == com.wiris.quizzes.api.ui.AnswerFieldType.POPUP_MATH_EDITOR) this.mathEditorPopupRadioButton.setSelected(true); else if(inputMethod == com.wiris.quizzes.api.ui.AnswerFieldType.TEXT_FIELD) this.plainTextRadioButton.setSelected(true);
	}
	,updateVisibility: function(context) {
		this.setVisible(this.controller.getConfigurationKey("inputOptions/answerInputMethod"));
		var slot = context.getSlot();
		var compoundAnswer = "true" == slot.getProperty(com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER);
		var syntax = slot.getSyntax();
		var isGraphicSyntax = syntax.getName() == com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC;
		var answerInputFieldVisible = this.controller.getConfigurationKey("inputOptions/answerInputMethod/answerInputField");
		this.inputFieldContainer.setVisible(answerInputFieldVisible && !isGraphicSyntax);
		this.mathEditorEmbeddedRadioButton.setVisible(!compoundAnswer && this.controller.getContext().isOptAnswerFieldInlineEditor());
		this.mathEditorPopupRadioButton.setVisible(this.controller.getContext().isOptAnswerFieldPopupEditor());
		this.plainTextRadioButton.setVisible(this.controller.getContext().isOptAnswerFieldPlainText());
		var displayVisible = this.controller.getConfigurationKey("inputOptions/answerInputMethod/auxiliaryInput/auxiliaryInputDisplay");
		var replaceVisible = this.controller.getConfigurationKey("inputOptions/answerInputMethod/auxiliaryInput/auxiliaryInputReplace");
		replaceVisible = replaceVisible && context.getSlot().getSyntax().getName() != com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC;
		var textVisible = this.controller.getConfigurationKey("inputOptions/answerInputMethod/auxiliaryInput/auxiliaryTextInput");
		this.displayAuxiliaryInputPanel.setVisible(displayVisible);
		this.replaceAuxiliaryInputPanel.setVisible(replaceVisible);
		this.textAuxiliaryInputRadioButton.setVisible(textVisible);
		var auxiliaryVisible = this.controller.getConfigurationKey("inputOptions/answerInputMethod/auxiliaryInput") && (displayVisible || replaceVisible || textVisible);
		this.auxiliaryInputContainer.setVisible(auxiliaryVisible);
		this.lockContainer.setVisible(answerInputFieldVisible && context.isOptOpenAnswer() && (slot.getAnswerFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_MATH_EDITOR || slot.getAnswerFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.POPUP_MATH_EDITOR || slot.getAnswerFieldType() == com.wiris.quizzes.api.ui.AnswerFieldType.INLINE_GRAPH_EDITOR));
		this.lockCheckbox.setSelected(context.isInitialContentLocked());
		this.setInputMethod(com.wiris.quizzes.impl.QuizzesEnumUtils.string2answerFieldType(slot.getProperty(com.wiris.quizzes.api.PropertyName.ANSWER_FIELD_TYPE)));
		this.setAuxiliaryInput(slot.getProperty(com.wiris.quizzes.api.PropertyName.SHOW_CAS),slot.getProperty(com.wiris.quizzes.api.PropertyName.SHOW_AUXILIARY_TEXT_INPUT),slot.getProperty(com.wiris.quizzes.api.PropertyName.AUXILIARY_CAS_HIDE_FILE_MENU));
		if(context.getSlot().getSyntax().getParameter(com.wiris.quizzes.api.assertion.SyntaxParameterName.GRAPH_MODE) != null && context.getSlot().getSyntax().getParameter(com.wiris.quizzes.api.assertion.SyntaxParameterName.GRAPH_MODE) == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_SKETCH) {
			this.lockContainer.setVisible(false);
			if(this.displayValueDropdown.getValue() == com.wiris.util.graphics.DisplaySettings.FOCUS) context.getSlot().setProperty(com.wiris.quizzes.api.PropertyName.GRAPH_SHOW_VALUE_IN_LABEL,com.wiris.util.graphics.DisplaySettings.NEVER);
			if(this.displayNameDropdown.getValue() == com.wiris.util.graphics.DisplaySettings.FOCUS) context.getSlot().setProperty(com.wiris.quizzes.api.PropertyName.GRAPH_SHOW_NAME_IN_LABEL,com.wiris.util.graphics.DisplaySettings.ALWAYS);
			this.displayValueDropdown.disableValue(com.wiris.util.graphics.DisplaySettings.FOCUS);
			this.displayNameDropdown.disableValue(com.wiris.util.graphics.DisplaySettings.FOCUS);
		} else {
			this.displayValueDropdown.enableValue(com.wiris.util.graphics.DisplaySettings.FOCUS);
			this.displayNameDropdown.enableValue(com.wiris.util.graphics.DisplaySettings.FOCUS);
		}
		this.displayNameDropdown.setValue(slot.getProperty(com.wiris.quizzes.api.PropertyName.GRAPH_SHOW_NAME_IN_LABEL));
		this.displayValueDropdown.setValue(slot.getProperty(com.wiris.quizzes.api.PropertyName.GRAPH_SHOW_VALUE_IN_LABEL));
		this.displaySettingsContainer.setVisible(isGraphicSyntax);
		this.magneticGridContainer.setVisible(context.getSlot().getSyntax().getParameter(com.wiris.quizzes.api.assertion.SyntaxParameterName.GRAPH_MODE) != null && context.getSlot().getSyntax().getParameter(com.wiris.quizzes.api.assertion.SyntaxParameterName.GRAPH_MODE) == com.wiris.quizzes.impl.Assertion.GRAPH_MODE_STANDARD && context.getSlot().getSyntax().getName() == com.wiris.quizzes.api.assertion.SyntaxName.GRAPHIC);
		this.magneticGridDropdown.setValue(slot.getProperty(com.wiris.quizzes.api.PropertyName.GRAPH_MAGNETIC_GRID));
	}
	,controller: null
	,replaceAuxiliaryExpansionController: null
	,displayAuxiliaryExpansionController: null
	,magneticGridDropdown: null
	,magneticGridSmallContainer: null
	,magneticGridContainer: null
	,displayNameDropdown: null
	,displayValueDropdown: null
	,displaySettingsContainerValue: null
	,displaySettingsContainerName: null
	,displaySettingsContainer: null
	,lockCheckbox: null
	,lockContainer: null
	,replaceAuxiliaryContainer: null
	,displayAuxiliaryContainer: null
	,auxiliaryInputContainer: null
	,inputFieldContainer: null
	,auxiliaryInputFieldSelectionController: null
	,inputFieldSelectionController: null
	,replaceAuxiliaryInputPanel: null
	,displayAuxiliaryInputPanel: null
	,replaceDefineInitialContentButton: null
	,displayDefineInitialContentButton: null
	,noAuxiliaryInputRadioButton: null
	,textAuxiliaryInputRadioButton: null
	,replaceAuxiliaryInputHideFileMenuCheckBox: null
	,replaceAuxiliaryInputRadioButton: null
	,displayAuxiliaryInputHideFileMenuCheckBox: null
	,displayAuxiliaryInputRadioButton: null
	,plainTextRadioButton: null
	,mathEditorPopupRadioButton: null
	,mathEditorEmbeddedRadioButton: null
	,label: null
	,__class__: com.wiris.quizzes.impl.ui.component.InputMethodComponent
});
com.wiris.quizzes.impl.ui.component.InputOptionsActivity = $hxClasses["com.wiris.quizzes.impl.ui.component.InputOptionsActivity"] = function(controller) {
	com.wiris.util.ui.component.ActivityPanel.call(this);
	this.setId("inputOptions").addClass(com.wiris.util.ui.component.Panel.CLASS_PANEL_SOLID).addClass(com.wiris.quizzes.impl.ui.component.InputOptionsActivity.CLASS_QUIZZES_STUDIO_INPUT_OPTIONS);
	this.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setHeightWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT);
	this.controller = controller;
	this.optionsFilter = new com.wiris.quizzes.impl.ui.component.QuizzesOptionsFilterComponent(controller,"inputOptions");
	this.compoundAnswer = new com.wiris.quizzes.impl.ui.component.CompoundAnswerComponent(controller);
	this.inputMethod = new com.wiris.quizzes.impl.ui.component.InputMethodComponent(controller);
	this.inputSyntax = new com.wiris.quizzes.impl.ui.component.InputSyntaxComponent(controller);
	var content = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	content.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setHeightWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setVerticalAlignment(com.wiris.util.ui.Style.VERTICAL_ALIGNMENT_TOP);
	content.addComponent(this.optionsFilter);
	content.addComponent(this.compoundAnswer);
	content.addComponent(this.inputMethod);
	content.addComponent(this.inputSyntax);
	this.addComponent(content);
};
com.wiris.quizzes.impl.ui.component.InputOptionsActivity.__name__ = ["com","wiris","quizzes","impl","ui","component","InputOptionsActivity"];
com.wiris.quizzes.impl.ui.component.InputOptionsActivity.__super__ = com.wiris.util.ui.component.ActivityPanel;
com.wiris.quizzes.impl.ui.component.InputOptionsActivity.prototype = $extend(com.wiris.util.ui.component.ActivityPanel.prototype,{
	showAllSyntaxAssertions: function() {
		if(this.optionsFilter.isOptionsFiltered()) this.optionsFilter.setOptionsFilter(false);
		this.inputSyntax.showAllSyntaxAssertions();
	}
	,showFeaturedSyntaxAssertions: function(featuredParams) {
		this.inputSyntax.showFeaturedSyntaxAssertions(featuredParams);
	}
	,setUnitPrefixes: function(unitPrefixes) {
		this.inputSyntax.setUnitPrefixes(unitPrefixes);
	}
	,setUnits: function(units) {
		this.inputSyntax.setUnits(units);
	}
	,setFunctions: function(functions,userFunctions) {
		this.inputSyntax.setFunctions(functions,userFunctions);
	}
	,setConstants: function(constants,userConstants) {
		this.inputSyntax.setConstants(constants,userConstants);
	}
	,showAllUnitPrefixes: function() {
		this.inputSyntax.showAllUnitPrefixes();
	}
	,showAllUnits: function() {
		this.inputSyntax.showAllUnits();
	}
	,showAllFunctions: function() {
		this.inputSyntax.showAllFunctions();
	}
	,showAllConstants: function() {
		this.inputSyntax.showAllConstants();
	}
	,setCompoundAnswers: function(compoundAnswers,compoundDistribution) {
		this.compoundAnswer.setCompoundAnswers(compoundAnswers,compoundDistribution);
	}
	,setSpaceSeparator: function(separator) {
		this.inputSyntax.setSpaceSeparator(separator);
	}
	,setCommaSeparator: function(separator) {
		this.inputSyntax.setCommaSeparator(separator);
	}
	,setPointSeparator: function(separator) {
		this.inputSyntax.setPointSeparator(separator);
	}
	,setScientificNotation: function(selected) {
		this.inputSyntax.setScientificNotation(selected);
	}
	,setRatios: function(selected) {
		this.inputSyntax.setRatios(selected);
	}
	,setIntervals: function(selected) {
		this.inputSyntax.setIntervals(selected);
	}
	,setNoBracketsLists: function(selected) {
		this.inputSyntax.setNoBracketsLists(selected);
	}
	,setLists: function(selected) {
		this.inputSyntax.setLists(selected);
	}
	,setMixedFractions: function(selected) {
		this.inputSyntax.setMixedFractions(selected);
	}
	,setAllAnswersCorrect: function(selected) {
		this.compoundAnswer.setAllAnswersCorrect(selected);
	}
	,setCompoundAnswer: function(selected) {
		this.compoundAnswer.setCompoundAnswer(selected);
	}
	,updateVisibility: function(context) {
		this.optionsFilter.setVisible(this.controller.getContext().isOptOpenAnswer() && this.controller.getContext().isOptInputSyntax());
		var isQuestionCompoundAnswer = "true" == context.getSlot().getProperty(com.wiris.quizzes.api.PropertyName.COMPOUND_ANSWER);
		this.inputMethod.updateVisibility(context);
		this.inputSyntax.updateVisibility();
		if(!context.isShowAllOptions()) {
			var correctAnswer = new com.wiris.quizzes.impl.MathContent();
			correctAnswer.set(context.getAuthorAnswer().getValue());
			var isCorrectAnswerCompoundSyntax = com.wiris.quizzes.impl.CompoundAnswerParser.parseCompoundAnswer(correctAnswer).length > 0;
			this.compoundAnswer.setVisible(this.controller.getContext().isOptOpenAnswer() && this.controller.getContext().isOptCompoundAnswer() && (isQuestionCompoundAnswer || isCorrectAnswerCompoundSyntax));
			this.showFeaturedSyntaxAssertions(context.getFeaturedParams());
			this.optionsFilter.setOptionsFilter(true);
		} else {
			this.compoundAnswer.setVisible(this.controller.getContext().isOptOpenAnswer() && this.controller.getContext().isOptCompoundAnswer());
			if(this.controller.getContext().isOptInputSyntax()) {
				this.showAllSyntaxAssertions();
				this.optionsFilter.setOptionsFilter(false);
			}
		}
	}
	,inputSyntax: null
	,inputMethod: null
	,compoundAnswer: null
	,optionsFilter: null
	,controller: null
	,__class__: com.wiris.quizzes.impl.ui.component.InputOptionsActivity
});
com.wiris.quizzes.impl.ui.component.InputSyntaxComponent = $hxClasses["com.wiris.quizzes.impl.ui.component.InputSyntaxComponent"] = function(controller) {
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.setId(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_FIELD_ID).addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_FULL_SIZE_PANEL);
	this.controller = controller;
	this.label = com.wiris.util.ui.component.Label.newImportantWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_FIELD_LABEL));
	var content = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	content.addClass(com.wiris.util.ui.component.Panel.CLASS_PANEL_CARD);
	this.constantsContainer = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.constantsContainer.setId("inputOptionsConstants").addClass(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.CLASS_INPUT_SYNTAX_ROW);
	var constantsLabel = com.wiris.util.ui.component.Label.newImportantWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_CONSTANTS_LABEL));
	var constantsHelperText = com.wiris.util.ui.component.Label.newTinyWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_CONSTANTS_HELPER_TEXT));
	var constantsSelectAll = com.wiris.util.ui.component.ActionLabel.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_SELECT_ALL),new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SELECT_ALL_CONSTANTS,null),this);
	constantsSelectAll.setId("inputOptionsConstantsAll");
	var constantsClearAll = com.wiris.util.ui.component.ActionLabel.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_CLEAR_ALL),new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_CLEAR_ALL_CONSTANTS,null),this);
	constantsClearAll.setId("inputOptionsConstantsClear");
	var constantsTopLabels = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	constantsTopLabels.addComponent(constantsLabel);
	constantsTopLabels.addComponent(constantsSelectAll);
	constantsTopLabels.addComponent(constantsClearAll);
	var constantsGroup = new com.wiris.util.ui.component.BorderPanel(false);
	this.constantsChipGroup = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT_WITH_WRAP);
	this.constantsSelectionController = new com.wiris.util.ui.controller.SelectionController(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_CONSTANTS_ID);
	this.constantPiChip = com.wiris.util.ui.component.FilterChip.newFilterChip(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_CONSTANT_PI),com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_CONSTANT_PI,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_CONSTANT_PI,null),controller);
	this.constantPiChip.setId("inputOptionsConstantPi");
	this.constantsSelectionController.addSelectable(this.constantPiChip,true);
	this.constantEChip = com.wiris.util.ui.component.FilterChip.newFilterChip(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_CONSTANT_E),com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_CONSTANT_E,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_CONSTANT_E,null),controller);
	this.constantEChip.setId("inputOptionsConstantE");
	this.constantsSelectionController.addSelectable(this.constantEChip,true);
	this.constantIChip = com.wiris.util.ui.component.FilterChip.newFilterChip(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_CONSTANT_I),com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_CONSTANT_I,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_CONSTANT_I,null),controller);
	this.constantIChip.setId("inputOptionsConstantI");
	this.constantsSelectionController.addSelectable(this.constantIChip,true);
	this.constantJChip = com.wiris.util.ui.component.FilterChip.newFilterChip(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_CONSTANT_J),com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_CONSTANT_J,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_CONSTANT_J,null),controller);
	this.constantJChip.setId("inputOptionsConstantJ");
	this.constantsSelectionController.addSelectable(this.constantJChip,true);
	this.moreConstantsChip = com.wiris.util.ui.component.ActionChip.newActionChip(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_CONSTANT_MORE_CONSTANTS),new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_CONSTANT_MORE_CONSTANTS,null),controller);
	this.moreConstantsChip.setId("inputOptionsConstantMore");
	this.constantsChipGroup.addComponent(this.constantPiChip);
	this.constantsChipGroup.addComponent(this.constantEChip);
	this.constantsChipGroup.addComponent(this.constantIChip);
	this.constantsChipGroup.addComponent(this.constantJChip);
	this.constantChips = new Array();
	var defineNewConstantButton = com.wiris.util.ui.component.Button.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_BUTTON_DEFINE_NEW_CONSTANT),new com.wiris.util.ui.Action("showActivity",com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.QUIZZES_STUDIO_VARIABLES_FUNCTIONS_ID),controller);
	defineNewConstantButton.addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON);
	constantsGroup.addComponent(this.constantsChipGroup,com.wiris.util.ui.component.BorderPanel.POSITION_WEST);
	constantsGroup.addComponent(defineNewConstantButton,com.wiris.util.ui.component.BorderPanel.POSITION_EAST);
	this.constantsContainer.addComponent(constantsTopLabels);
	this.constantsContainer.addComponent(constantsGroup);
	this.constantsContainer.addComponent(constantsHelperText);
	this.functionsContainer = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.functionsContainer.setId("inputOptionsFunctions").addClass(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.CLASS_INPUT_SYNTAX_ROW);
	var functionsLabel = com.wiris.util.ui.component.Label.newImportantWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_FUNCTIONS_LABEL));
	var functionsHelperText = com.wiris.util.ui.component.Label.newTinyWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_FUNCTIONS_HELPER_TEXT));
	var functionsSelectAll = com.wiris.util.ui.component.ActionLabel.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_SELECT_ALL),new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SELECT_ALL_FUNCTIONS,null),this);
	functionsSelectAll.setId("inputOptionsFunctionsAll");
	var functionsClearAll = com.wiris.util.ui.component.ActionLabel.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_CLEAR_ALL),new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_CLEAR_ALL_FUNCTIONS,null),this);
	functionsClearAll.setId("inputOptionsFunctionsClear");
	var functionsTopLabels = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	functionsTopLabels.addComponent(functionsLabel);
	functionsTopLabels.addComponent(functionsSelectAll);
	functionsTopLabels.addComponent(functionsClearAll);
	var functionsGroup = new com.wiris.util.ui.component.BorderPanel(false);
	this.functionsChipGroup = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT_WITH_WRAP);
	this.functionsSelectionController = new com.wiris.util.ui.controller.SelectionController(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_FUNCTIONS_ID);
	this.functionExpLogChip = com.wiris.util.ui.component.FilterChip.newFilterChip(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_FUNCTION_EXP_LOG),com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_FUNCTION_EXP_LOG,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_FUNCTION_EXP_LOG,null),controller);
	this.functionExpLogChip.setId("inputOptionsFunctionExpLog");
	this.functionsSelectionController.addSelectable(this.functionExpLogChip,true);
	this.functionTrigonometricChip = com.wiris.util.ui.component.FilterChip.newFilterChip(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_FUNCTION_TRIGONOMETRIC),com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_FUNCTION_TRIGONOMETRIC,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_FUNCTION_TRIGONOMETRIC,null),controller);
	this.functionTrigonometricChip.setId("inputOptionsFunctionTrigonometric");
	this.functionsSelectionController.addSelectable(this.functionTrigonometricChip,true);
	this.functionHyperbolicChip = com.wiris.util.ui.component.FilterChip.newFilterChip(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_FUNCTION_HYPERBOLIC),com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_FUNCTION_HYPERBOLIC,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_FUNCTION_HYPERBOLIC,null),controller);
	this.functionHyperbolicChip.setId("inputOptionsFunctionHyperbolic");
	this.functionsSelectionController.addSelectable(this.functionHyperbolicChip,true);
	this.functionArithmeticChip = com.wiris.util.ui.component.FilterChip.newFilterChip(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_FUNCTION_ARITHMETIC),com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_FUNCTION_ARITHMETIC,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_FUNCTION_ARITHMETIC,null),controller);
	this.functionArithmeticChip.setId("inputOptionsFunctionArithmetic");
	this.functionsSelectionController.addSelectable(this.functionArithmeticChip,true);
	this.moreFunctionsChip = com.wiris.util.ui.component.ActionChip.newActionChip(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_FUNCTION_MORE_FUNCTIONS),new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_FUNCTION_MORE_FUNCTIONS,null),controller);
	this.moreFunctionsChip.setId("inputOptionsFunctionMore");
	this.functionsChipGroup.addComponent(this.functionExpLogChip);
	this.functionsChipGroup.addComponent(this.functionTrigonometricChip);
	this.functionsChipGroup.addComponent(this.functionHyperbolicChip);
	this.functionsChipGroup.addComponent(this.functionArithmeticChip);
	this.functionChips = new Array();
	var defineNewFunctionButton = com.wiris.util.ui.component.Button.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_BUTTON_DEFINE_NEW_FUNCTION),new com.wiris.util.ui.Action("showActivity",com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.QUIZZES_STUDIO_VARIABLES_FUNCTIONS_ID),controller);
	defineNewFunctionButton.addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON);
	functionsGroup.addComponent(this.functionsChipGroup,com.wiris.util.ui.component.BorderPanel.POSITION_WEST);
	functionsGroup.addComponent(defineNewFunctionButton,com.wiris.util.ui.component.BorderPanel.POSITION_EAST);
	this.functionsContainer.addComponent(functionsTopLabels);
	this.functionsContainer.addComponent(functionsGroup);
	this.functionsContainer.addComponent(functionsHelperText);
	this.measureUnitsContainer = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.measureUnitsContainer.setId("inputOptionsMeasureUnits").addClass(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.CLASS_INPUT_SYNTAX_ROW);
	var measureUnitsLabel = com.wiris.util.ui.component.Label.newImportantWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_MEASURE_UNITS_LABEL));
	var measureUnitsHelperText = com.wiris.util.ui.component.Label.newTinyWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_MEASURE_UNITS_HELPER_TEXT));
	var measureUnitsSelectAll = com.wiris.util.ui.component.ActionLabel.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_SELECT_ALL),new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SELECT_ALL_UNITS,null),this);
	measureUnitsSelectAll.setId("inputOptionsUnitsAll");
	var measureUnitsClearAll = com.wiris.util.ui.component.ActionLabel.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_CLEAR_ALL),new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_CLEAR_ALL_UNITS,null),this);
	measureUnitsClearAll.setId("inputOptionsUnitsClear");
	var measureUnitsTopLabels = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	measureUnitsTopLabels.addComponent(measureUnitsLabel);
	measureUnitsTopLabels.addComponent(measureUnitsSelectAll);
	measureUnitsTopLabels.addComponent(measureUnitsClearAll);
	var measureUnitsChipGroup = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT_WITH_WRAP);
	this.measureUnitsSelectionController = new com.wiris.util.ui.controller.SelectionController(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_MEASURE_UNITS_ID);
	this.measureUnits = new Hash();
	var _g = 0, _g1 = com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.MEASURE_UNITS_MAIN;
	while(_g < _g1.length) {
		var unit = _g1[_g];
		++_g;
		this.createFilterChip(unit,"measure_units","measureUnits",this.measureUnits,this.measureUnitsSelectionController,measureUnitsChipGroup);
	}
	var _g = 0, _g1 = com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.MEASURE_UNITS_SECONDARY;
	while(_g < _g1.length) {
		var unit = _g1[_g];
		++_g;
		this.createFilterChip(unit,"measure_units","measureUnits",this.measureUnits,this.measureUnitsSelectionController,measureUnitsChipGroup).setVisible(false);
	}
	this.measureUnitsMoreUnitsChip = com.wiris.util.ui.component.ActionChip.newActionChip(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_MEASURE_UNITS_MORE_UNITS),new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_MEASURE_UNITS_MORE_UNITS,null),controller);
	this.measureUnitsMoreUnitsChip.setId("inputOptionsMeasureUnitsMore");
	measureUnitsChipGroup.addComponent(this.measureUnitsMoreUnitsChip);
	this.measureUnitsContainer.addComponent(measureUnitsTopLabels);
	this.measureUnitsContainer.addComponent(measureUnitsChipGroup);
	this.measureUnitsContainer.addComponent(measureUnitsHelperText);
	this.unitPrefixesContainer = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.unitPrefixesContainer.setId("inputOptionsUnitPrefixes").addClass(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.CLASS_INPUT_SYNTAX_ROW);
	var unitPrefixesLabel = com.wiris.util.ui.component.Label.newImportantWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_UNIT_PREFIXES_LABEL));
	var unitPrefixesHelperText = com.wiris.util.ui.component.Label.newTinyWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_UNIT_PREFIXES_HELPER_TEXT));
	var unitPrefixesSelectAll = com.wiris.util.ui.component.ActionLabel.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_SELECT_ALL),new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SELECT_ALL_PREFIXES,null),this);
	measureUnitsSelectAll.setId("inputOptionsPrefixesAll");
	var unitPrefixesClearAll = com.wiris.util.ui.component.ActionLabel.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_CLEAR_ALL),new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_CLEAR_ALL_PREFIXES,null),this);
	measureUnitsClearAll.setId("inputOptionsPrefixesClear");
	var unitPrefixesTopLabels = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	unitPrefixesTopLabels.addComponent(unitPrefixesLabel);
	unitPrefixesTopLabels.addComponent(unitPrefixesSelectAll);
	unitPrefixesTopLabels.addComponent(unitPrefixesClearAll);
	var unitPrefixesChipGroup = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT_WITH_WRAP);
	this.unitPrefixesSelectionController = new com.wiris.util.ui.controller.SelectionController(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_UNIT_PREFIXES_ID);
	this.unitPrefixes = new Hash();
	var _g = 0, _g1 = com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.UNIT_PREFIXES_MAIN;
	while(_g < _g1.length) {
		var prefix = _g1[_g];
		++_g;
		this.createFilterChip(prefix,"unit_prefixes","unitPrefixes",this.unitPrefixes,this.unitPrefixesSelectionController,unitPrefixesChipGroup);
	}
	var _g = 0, _g1 = com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.UNIT_PREFIXES_SECONDARY;
	while(_g < _g1.length) {
		var prefix = _g1[_g];
		++_g;
		this.createFilterChip(prefix,"unit_prefixes","unitPrefixes",this.unitPrefixes,this.unitPrefixesSelectionController,unitPrefixesChipGroup).setVisible(false);
	}
	this.unitPrefixesMorePrefixesChip = com.wiris.util.ui.component.ActionChip.newActionChip(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_UNIT_PREFIXES_MORE_PREFIXES),new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_UNIT_PREFIXES_MORE_PREFIXES,null),controller);
	this.unitPrefixesMorePrefixesChip.setId("inputOptionsUnitPrefixesMore");
	unitPrefixesChipGroup.addComponent(this.unitPrefixesMorePrefixesChip);
	this.unitPrefixesContainer.addComponent(unitPrefixesTopLabels);
	this.unitPrefixesContainer.addComponent(unitPrefixesChipGroup);
	this.unitPrefixesContainer.addComponent(unitPrefixesHelperText);
	this.allowedConstructionsContainer = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.allowedConstructionsContainer.setId("inputSyntaxAllowedConstructions");
	var allowedConstructionsLabel = com.wiris.util.ui.component.Label.newImportantWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ALLOWED_CONSTRUCTIONS_LABEL));
	this.allowedConstructionsSelectionController = new com.wiris.util.ui.controller.SelectionController(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ALLOWED_CONSTRUCTIONS_ID);
	this.mixedFractionsCheckBox = com.wiris.util.ui.component.CheckBox.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_MIXED_FRACTIONS),controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_HELPER_TEXT_MIXED_FRACTIONS),com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_MIXED_FRACTIONS,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_MIXED_FRACTIONS,null),controller);
	this.mixedFractionsCheckBox.getHelperTextPanel().addComponent(com.wiris.quizzes.impl.ui.component.MathLabel.newWithText("<math xmlns=\"http://www.w3.org/1998/Math/MathML\"><mn>1</mn><mfrac><mn>1</mn><mn>2</mn></mfrac></math>"));
	this.mixedFractionsCheckBox.getHelperTextPanel().addComponent(com.wiris.util.ui.component.Label.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_HELPER_TEXT_MIXED_FRACTIONS_2)));
	this.mixedFractionsCheckBox.getHelperTextPanel().addComponent(com.wiris.quizzes.impl.ui.component.MathLabel.newWithText("<math xmlns=\"http://www.w3.org/1998/Math/MathML\"><mn>1</mn><mo>+</mo><mfrac><mn>1</mn><mn>2</mn></mfrac></math>"));
	this.mixedFractionsCheckBox.getHelperTextPanel().addComponent(com.wiris.util.ui.component.Label.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_HELPER_TEXT_MIXED_FRACTIONS_3)));
	this.mixedFractionsCheckBox.getHelperTextPanel().addComponent(com.wiris.quizzes.impl.ui.component.MathLabel.newWithText("<math xmlns=\"http://www.w3.org/1998/Math/MathML\"><mn>1</mn><mo>&#xB7;</mo><mfrac><mn>1</mn><mn>2</mn></mfrac></math>"));
	this.mixedFractionsCheckBox.getHelperTextPanel().addComponent(com.wiris.util.ui.component.Label.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_HELPER_TEXT_MIXED_FRACTIONS_4)));
	this.allowedConstructionsSelectionController.addSelectable(this.mixedFractionsCheckBox,false);
	this.listsCheckBox = com.wiris.util.ui.component.CheckBox.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_LISTS),controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_HELPER_TEXT_LISTS),com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_LISTS,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_LISTS,null),controller);
	this.allowedConstructionsSelectionController.addSelectable(this.listsCheckBox,true);
	this.listsCheckBox.addActionListener(this);
	this.intervalsCheckBox = com.wiris.util.ui.component.CheckBox.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_INTERVALS),controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_HELPER_TEXT_INTERVALS),com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_INTERVALS,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_INTERVALS,null),controller);
	this.allowedConstructionsSelectionController.addSelectable(this.intervalsCheckBox,false);
	this.ratiosCheckBox = com.wiris.util.ui.component.CheckBox.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_RATIOS),controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_HELPER_TEXT_RATIOS),com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_RATIOS,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_RATIOS,null),controller);
	this.allowedConstructionsSelectionController.addSelectable(this.ratiosCheckBox,false);
	this.computerScientificNotationCheckBox = com.wiris.util.ui.component.CheckBox.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_COMPUTER_SCIENTIFIC_NOTATION),controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_HELPER_TEXT_COMPUTER_SCIENTIFIC_NOTATION),com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_COMPUTER_SCIENTIFIC_NOTATION,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_COMPUTER_SCIENTIFIC_NOTATION,null),controller);
	this.allowedConstructionsSelectionController.addSelectable(this.computerScientificNotationCheckBox,false);
	this.listsWithoutEnclosersCheckBox = com.wiris.util.ui.component.CheckBox.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_LISTS_WITHOUT_ENCLOSERS),controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_HELPER_TEXT_LISTS_WITHOUT_ENCLOSERS),com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_LISTS_WITHOUT_ENCLOSERS,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_LISTS_WITHOUT_ENCLOSERS,null),controller);
	this.allowedConstructionsSelectionController.addSelectable(this.listsWithoutEnclosersCheckBox,false);
	var listsWithoutEnclosersPanel = com.wiris.util.ui.component.FlowPanel.newWithChild(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM,this.listsWithoutEnclosersCheckBox);
	listsWithoutEnclosersPanel.setIndentationLevel(2);
	this.listsCheckBoxContainer = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.listsCheckBoxContainer.addComponent(this.listsCheckBox);
	this.listsCheckBoxContainer.addComponent(listsWithoutEnclosersPanel);
	this.expansionController = new com.wiris.util.ui.controller.ExpansionController(this,listsWithoutEnclosersPanel,true);
	this.allowedConstructionsContainer.addComponent(allowedConstructionsLabel);
	this.allowedConstructionsContainer.addComponent(this.mixedFractionsCheckBox);
	this.allowedConstructionsContainer.addComponent(this.listsCheckBoxContainer);
	this.allowedConstructionsContainer.addComponent(this.intervalsCheckBox);
	this.allowedConstructionsContainer.addComponent(this.ratiosCheckBox);
	this.allowedConstructionsContainer.addComponent(this.computerScientificNotationCheckBox);
	this.separatorsContainer = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	var separatorSymbolsLabel = com.wiris.util.ui.component.Label.newImportantWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_SEPARATOR_SYMBOLS_LABEL));
	var separatorSymbolsHelperText = com.wiris.util.ui.component.Label.newTinyWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_SEPARATOR_SYMBOLS_HELPER_TEXT));
	var pointSeparatorLabel = com.wiris.util.ui.component.Label.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_SEPARATOR_POINT_LABEL));
	this.pointSeparatorDropdown = new com.wiris.util.ui.component.Dropdown();
	this.pointSeparatorDropdown.setId("inputOptionsPointSeparator");
	this.pointSeparatorDropdown.addValue(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_NOTHING,controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_SEPARATOR_NOTHING)).setId("inputOptionsPointSeparatorNothing");
	this.pointSeparatorDropdown.addValue(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_DECIMAL_PLACES,controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_SEPARATOR_DECIMAL_PLACES)).setId("inputOptionsPointSeparatorDecimal");
	this.pointSeparatorDropdown.addValue(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_DIGIT_GROUPS,controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_SEPARATOR_DIGIT_GROUPS)).setId("inputOptionsPointSeparatorDigitGroup");
	this.pointSeparatorDropdown.pickValue(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_DECIMAL_PLACES);
	this.pointSeparatorDropdown.setChangeValueAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_SEPARATOR_POINT_ID,null));
	this.pointSeparatorDropdown.addActionListener(controller);
	var pointSeparatorPanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	pointSeparatorPanel.addClass(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.CLASS_SEPARATOR_ROW);
	pointSeparatorPanel.addComponent(pointSeparatorLabel);
	pointSeparatorPanel.addComponent(this.pointSeparatorDropdown);
	var commaSeparatorLabel = com.wiris.util.ui.component.Label.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_SEPARATOR_COMMA_LABEL));
	this.commaSeparatorDropdown = new com.wiris.util.ui.component.Dropdown();
	this.commaSeparatorDropdown.setId("inputOptionsCommaSeparator");
	this.commaSeparatorDropdown.addValue(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_DECIMAL_PLACES,controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_SEPARATOR_DECIMAL_PLACES)).setId("inputOptionsCommaSeparatorDecimal");
	this.commaSeparatorDropdown.addValue(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_DIGIT_GROUPS,controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_SEPARATOR_DIGIT_GROUPS)).setId("inputOptionsCommaSeparatorDigitGroup");
	this.commaSeparatorDropdown.addValue(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_LIST_ITEMS,controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_SEPARATOR_LIST_ITEMS)).setId("inputOptionsCommaSeparatorListItem");
	this.commaSeparatorDropdown.pickValue(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_LIST_ITEMS);
	this.commaSeparatorDropdown.setChangeValueAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_SEPARATOR_COMMA_ID,null));
	this.commaSeparatorDropdown.addActionListener(controller);
	var commaSeparatorPanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	commaSeparatorPanel.addClass(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.CLASS_SEPARATOR_ROW);
	commaSeparatorPanel.addComponent(commaSeparatorLabel);
	commaSeparatorPanel.addComponent(this.commaSeparatorDropdown);
	var spaceSeparatorLabel = com.wiris.util.ui.component.Label.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_SEPARATOR_SPACE_LABEL));
	this.spaceSeparatorDropdown = new com.wiris.util.ui.component.Dropdown();
	this.spaceSeparatorDropdown.setId("inputOptionsSpaceSeparator");
	this.spaceSeparatorDropdown.addValue(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_NOTHING,controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_SEPARATOR_NOTHING)).setId("inputOptionsSpaceSeparatorNothing");
	this.spaceSeparatorDropdown.addValue(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_DIGIT_GROUPS,controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_SEPARATOR_DIGIT_GROUPS)).setId("inputOptionsSpaceSeparatorDigitGroup");
	this.spaceSeparatorDropdown.addValue(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_LIST_ITEMS,controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_LABEL_SEPARATOR_LIST_ITEMS)).setId("inputOptionsSpaceSeparatorListItem");
	this.spaceSeparatorDropdown.pickValue(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_NOTHING);
	this.spaceSeparatorDropdown.setChangeValueAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_SEPARATOR_SPACE_ID,null));
	this.spaceSeparatorDropdown.addActionListener(controller);
	var spaceSeparatorPanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	spaceSeparatorPanel.addClass(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.CLASS_SEPARATOR_ROW);
	spaceSeparatorPanel.addComponent(spaceSeparatorLabel);
	spaceSeparatorPanel.addComponent(this.spaceSeparatorDropdown);
	this.separatorsContainer.addComponent(separatorSymbolsLabel);
	this.separatorsContainer.addComponent(pointSeparatorPanel);
	this.separatorsContainer.addComponent(commaSeparatorPanel);
	this.separatorsContainer.addComponent(spaceSeparatorPanel);
	this.separatorsContainer.addComponent(separatorSymbolsHelperText);
	content.addComponent(this.constantsContainer);
	content.addComponent(this.functionsContainer);
	content.addComponent(this.measureUnitsContainer);
	content.addComponent(this.unitPrefixesContainer);
	content.addComponent(this.allowedConstructionsContainer);
	content.addComponent(this.separatorsContainer);
	this.addComponent(this.label);
	this.addComponent(content);
};
com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.__name__ = ["com","wiris","quizzes","impl","ui","component","InputSyntaxComponent"];
com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.__interfaces__ = [com.wiris.util.ui.interaction.ActionListener];
com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.getLabel = function(type,name) {
	return "quizzes_studio_input_options_input_syntax_" + type + "_" + name + "_label";
}
com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.getActionId = function(type,name) {
	return type + name.substring(0,1).toUpperCase() + name.substring(1);
}
com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.getChipId = function(type,name) {
	return "inputOptions" + type.substring(0,1).toUpperCase() + type.substring(1) + name.substring(0,1).toUpperCase() + name.substring(1);
}
com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	showAllSyntaxAssertions: function() {
		this.setVisible(true);
		this.constantsContainer.setVisible(true);
		this.functionsContainer.setVisible(true);
		this.measureUnitsContainer.setVisible(true);
		this.unitPrefixesContainer.setVisible(true);
		this.allowedConstructionsContainer.setVisible(true);
		this.mixedFractionsCheckBox.setVisible(true);
		this.listsCheckBox.setVisible(true);
		this.listsWithoutEnclosersCheckBox.setVisible(true);
		this.intervalsCheckBox.setVisible(true);
		this.ratiosCheckBox.setVisible(true);
		this.computerScientificNotationCheckBox.setVisible(true);
		this.separatorsContainer.setVisible(true);
	}
	,showFeaturedSyntaxAssertions: function(featuredParams) {
		var showConstants = com.wiris.system.ArrayEx.contains(featuredParams,"constants");
		var showFunctions = com.wiris.system.ArrayEx.contains(featuredParams,"functions");
		var showMeasureUnits = com.wiris.system.ArrayEx.contains(featuredParams,"units");
		var showUnitPrefixes = com.wiris.system.ArrayEx.contains(featuredParams,"unitprefixes");
		var mixedFractions = com.wiris.system.ArrayEx.contains(featuredParams,"mixedfractions");
		var listOperators = com.wiris.system.ArrayEx.contains(featuredParams,"listoperators");
		var groupOperators = com.wiris.system.ArrayEx.contains(featuredParams,"groupoperators");
		var noBracketsList = com.wiris.system.ArrayEx.contains(featuredParams,"nobracketslist");
		var intervals = com.wiris.system.ArrayEx.contains(featuredParams,"intervals");
		var ratios = com.wiris.system.ArrayEx.contains(featuredParams,"ratios");
		var scientificNotation = com.wiris.system.ArrayEx.contains(featuredParams,"scientificnotation");
		var decimalSeparators = com.wiris.system.ArrayEx.contains(featuredParams,"decimalseparators");
		var digitGroupSeparators = com.wiris.system.ArrayEx.contains(featuredParams,"digitgroupseparators");
		var itemSeparators = com.wiris.system.ArrayEx.contains(featuredParams,"itemseparators");
		var showAllowedConstructions = mixedFractions || listOperators || groupOperators || noBracketsList || intervals || ratios || scientificNotation;
		var showSeparators = decimalSeparators || digitGroupSeparators || itemSeparators;
		if(showConstants || showFunctions || showMeasureUnits || showUnitPrefixes || showAllowedConstructions || showSeparators) {
			this.constantsContainer.setVisible(showConstants);
			this.functionsContainer.setVisible(showFunctions);
			this.measureUnitsContainer.setVisible(showMeasureUnits);
			this.unitPrefixesContainer.setVisible(showUnitPrefixes);
			this.allowedConstructionsContainer.setVisible(showAllowedConstructions);
			if(showAllowedConstructions) {
				this.mixedFractionsCheckBox.setVisible(mixedFractions);
				this.listsCheckBox.setVisible(listOperators || groupOperators);
				this.listsWithoutEnclosersCheckBox.setVisible(noBracketsList);
				this.intervalsCheckBox.setVisible(intervals);
				this.ratiosCheckBox.setVisible(ratios);
				this.computerScientificNotationCheckBox.setVisible(scientificNotation);
			}
			this.separatorsContainer.setVisible(showSeparators);
		} else this.setVisible(false);
	}
	,compareStrings: function(s1,s2) {
		if(s1.length > s2.length) return 1; else if(s2.length > s1.length) return -1; else return com.wiris.system.StringEx.compareTo(s1,s2);
	}
	,sortArrayByLengthAndName: function(array) {
		var result = new Array();
		var i;
		var _g1 = 0, _g = array.length;
		while(_g1 < _g) {
			var i1 = _g1++;
			if(result.length == 0 || this.compareStrings(array[i1],result[result.length - 1]) >= 0) result.push(array[i1]); else {
				var j;
				var _g3 = 0, _g2 = result.length;
				while(_g3 < _g2) {
					var j1 = _g3++;
					if(this.compareStrings(array[i1],result[j1]) <= 0) {
						result.splice(j1,0,array[i1]);
						break;
					}
				}
			}
		}
		return result;
	}
	,setAllValues: function(h,state) {
		var it = h.keys();
		while(it.hasNext()) h.get(it.next()).setSelected(state);
	}
	,actionPerformed: function(e) {
		var action = e.getAction();
		var actionId = action.getId();
		if(actionId == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_LISTS) this.expansionController.toggle(); else if(actionId == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SELECT_ALL_CONSTANTS || actionId == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_CLEAR_ALL_CONSTANTS) {
			var state = actionId == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SELECT_ALL_CONSTANTS;
			this.constantPiChip.setSelected(state);
			this.constantEChip.setSelected(state);
			this.constantIChip.setSelected(state);
			this.constantJChip.setSelected(state);
			var i = HxOverrides.iter(this.constantChips);
			while(i.hasNext()) {
				var chip = i.next();
				chip.setSelected(state);
			}
		} else if(actionId == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SELECT_ALL_FUNCTIONS || actionId == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_CLEAR_ALL_FUNCTIONS) {
			var state = actionId == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SELECT_ALL_FUNCTIONS;
			this.functionExpLogChip.setSelected(state);
			this.functionTrigonometricChip.setSelected(state);
			this.functionHyperbolicChip.setSelected(state);
			this.functionArithmeticChip.setSelected(state);
			var i = HxOverrides.iter(this.functionChips);
			while(i.hasNext()) {
				var chip = i.next();
				chip.setSelected(state);
			}
		} else if(actionId == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SELECT_ALL_UNITS) this.setAllValues(this.measureUnits,true); else if(actionId == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_CLEAR_ALL_UNITS) this.setAllValues(this.measureUnits,false); else if(actionId == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SELECT_ALL_PREFIXES) this.setAllValues(this.unitPrefixes,true); else if(actionId == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_CLEAR_ALL_PREFIXES) this.setAllValues(this.unitPrefixes,false);
	}
	,setSpaceSeparator: function(separator) {
		if(separator == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_DIGIT_GROUPS || separator == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_LIST_ITEMS || separator == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_NOTHING) this.spaceSeparatorDropdown.pickValue(separator);
	}
	,setCommaSeparator: function(separator) {
		if(separator == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_DECIMAL_PLACES || separator == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_DIGIT_GROUPS || separator == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_LIST_ITEMS) this.commaSeparatorDropdown.pickValue(separator);
	}
	,setPointSeparator: function(separator) {
		if(separator == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_DECIMAL_PLACES || separator == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_DIGIT_GROUPS || separator == com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.INPUT_SYNTAX_ID_SEPARATOR_NOTHING) this.pointSeparatorDropdown.pickValue(separator);
	}
	,setScientificNotation: function(selected) {
		this.computerScientificNotationCheckBox.setSelected(selected);
	}
	,setRatios: function(selected) {
		this.ratiosCheckBox.setSelected(selected);
	}
	,setIntervals: function(selected) {
		this.intervalsCheckBox.setSelected(selected);
	}
	,setNoBracketsLists: function(selected) {
		this.listsWithoutEnclosersCheckBox.setSelected(selected);
	}
	,setLists: function(selected) {
		this.listsCheckBox.setSelected(selected);
	}
	,setMixedFractions: function(selected) {
		this.mixedFractionsCheckBox.setSelected(selected);
	}
	,hideUnitPrefixes: function() {
		this.unitPrefixesMorePrefixesChip.setVisible(true);
		var _g = 0, _g1 = com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.UNIT_PREFIXES_SECONDARY;
		while(_g < _g1.length) {
			var unit = _g1[_g];
			++_g;
			this.unitPrefixes.get(unit).setVisible(false);
		}
	}
	,showAllUnitPrefixes: function() {
		this.unitPrefixesMorePrefixesChip.setVisible(false);
		var _g = 0, _g1 = com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.UNIT_PREFIXES_SECONDARY;
		while(_g < _g1.length) {
			var unit = _g1[_g];
			++_g;
			this.unitPrefixes.get(unit).setVisible(true);
		}
	}
	,hideUnits: function() {
		this.measureUnitsMoreUnitsChip.setVisible(true);
		var _g = 0, _g1 = com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.MEASURE_UNITS_SECONDARY;
		while(_g < _g1.length) {
			var unit = _g1[_g];
			++_g;
			this.measureUnits.get(unit).setVisible(false);
		}
	}
	,showAllUnits: function() {
		this.measureUnitsMoreUnitsChip.setVisible(false);
		var _g = 0, _g1 = com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.MEASURE_UNITS_SECONDARY;
		while(_g < _g1.length) {
			var unit = _g1[_g];
			++_g;
			this.measureUnits.get(unit).setVisible(true);
		}
	}
	,showAllFunctions: function() {
		var i = HxOverrides.iter(this.functionChips);
		while(i.hasNext()) {
			var chip = i.next();
			chip.setVisible(true);
		}
		this.moreFunctionsChip.setVisible(false);
	}
	,showAllConstants: function() {
		var i = HxOverrides.iter(this.constantChips);
		while(i.hasNext()) {
			var chip = i.next();
			chip.setVisible(true);
		}
		this.moreConstantsChip.setVisible(false);
	}
	,createFilterChip: function(unit,typeLabel,typeId,chipHash,selectionController,chipGroup) {
		var chip = com.wiris.util.ui.component.FilterChip.newFilterChip(this.controller.t(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.getLabel(typeLabel,unit)),com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.getActionId(typeId,unit),new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.getActionId(typeId,unit),null),this.controller);
		chip.setId(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.getChipId(typeId,unit));
		selectionController.addSelectable(chip,false);
		chipHash.set(unit,chip);
		chipGroup.addComponent(chip);
		return chip;
	}
	,setUnitPrefixes: function(unitPrefixes) {
		var _g1 = 0, _g = com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.UNIT_PREFIXES_MAIN.length;
		while(_g1 < _g) {
			var i = _g1++;
			this.unitPrefixes.get(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.UNIT_PREFIXES_MAIN[i]).setSelected(com.wiris.system.ArrayEx.contains(unitPrefixes,com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.UNIT_PREFIXES_MAIN_SYMBOLS[i]));
		}
		var secondaryPrefixesSelected = false;
		var _g1 = 0, _g = com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.UNIT_PREFIXES_SECONDARY.length;
		while(_g1 < _g) {
			var i = _g1++;
			var b = com.wiris.system.ArrayEx.contains(unitPrefixes,com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.UNIT_PREFIXES_SECONDARY_SYMBOLS[i]);
			this.unitPrefixes.get(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.UNIT_PREFIXES_SECONDARY[i]).setSelected(b);
			secondaryPrefixesSelected = secondaryPrefixesSelected || b;
		}
		if(!secondaryPrefixesSelected) this.hideUnitPrefixes();
	}
	,setUnits: function(units) {
		var _g1 = 0, _g = com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.MEASURE_UNITS_MAIN.length;
		while(_g1 < _g) {
			var i = _g1++;
			this.measureUnits.get(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.MEASURE_UNITS_MAIN[i]).setSelected(com.wiris.system.ArrayEx.contains(units,com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.MEASURE_UNITS_MAIN_SYMBOLS[i]));
		}
		var secondaryUnitsSelected = false;
		var _g1 = 0, _g = com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.MEASURE_UNITS_SECONDARY.length;
		while(_g1 < _g) {
			var i = _g1++;
			var b = com.wiris.system.ArrayEx.contains(units,com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.MEASURE_UNITS_SECONDARY_SYMBOLS[i]);
			this.measureUnits.get(com.wiris.quizzes.impl.ui.component.InputSyntaxComponent.MEASURE_UNITS_SECONDARY[i]).setSelected(b);
			secondaryUnitsSelected = secondaryUnitsSelected || b;
		}
		if(!secondaryUnitsSelected) this.hideUnits();
	}
	,setFunctions: function(functions,userFunctions) {
		this.functionExpLogChip.setSelected(com.wiris.system.ArrayEx.contains(functions,"exp"));
		this.functionTrigonometricChip.setSelected(com.wiris.system.ArrayEx.contains(functions,"sin"));
		this.functionHyperbolicChip.setSelected(com.wiris.system.ArrayEx.contains(functions,"sinh"));
		this.functionArithmeticChip.setSelected(com.wiris.system.ArrayEx.contains(functions,"min"));
		var i = HxOverrides.iter(this.functionChips);
		while(i.hasNext()) {
			var chip = i.next();
			chip.setSelected(false);
			this.functionsSelectionController.removeSelectable(chip.getSelectableId());
			this.functionsChipGroup.removeComponent(com.wiris.util.type.Arrays.indexOfElement(this.functionsChipGroup.getComponents(),chip));
		}
		var moreFunctionsIndex = com.wiris.util.type.Arrays.indexOfElement(this.functionsChipGroup.getComponents(),this.moreFunctionsChip);
		if(moreFunctionsIndex > 0) this.functionsChipGroup.removeComponent(moreFunctionsIndex);
		this.functionChips = new Array();
		userFunctions = this.sortArrayByLengthAndName(userFunctions);
		var j;
		var hiddenFunctions = true;
		var _g1 = 0, _g = functions.length;
		while(_g1 < _g) {
			var j1 = _g1++;
			if(com.wiris.util.type.Arrays.indexOfElement(userFunctions,functions[j1]) >= 3) hiddenFunctions = false;
		}
		var _g1 = 0, _g = userFunctions.length;
		while(_g1 < _g) {
			var j1 = _g1++;
			var chip = com.wiris.util.ui.component.FilterChip.newFilterChip(userFunctions[j1],userFunctions[j1],new com.wiris.util.ui.Action("function" + userFunctions[j1],null),this.controller);
			if(j1 >= 3 && hiddenFunctions) chip.setVisible(false);
			this.functionsSelectionController.addSelectable(chip,com.wiris.system.ArrayEx.contains(functions,userFunctions[j1]));
			this.functionChips.push(chip);
			this.functionsChipGroup.addComponent(chip);
		}
		if(userFunctions.length > 3) {
			this.functionsChipGroup.addComponent(this.moreFunctionsChip);
			this.moreFunctionsChip.setVisible(hiddenFunctions);
		}
	}
	,setConstants: function(constants,userConstants) {
		this.constantPiChip.setSelected(com.wiris.system.ArrayEx.contains(constants,com.wiris.system.Utf8.uchr(960)));
		this.constantEChip.setSelected(com.wiris.system.ArrayEx.contains(constants,"e"));
		this.constantIChip.setSelected(com.wiris.system.ArrayEx.contains(constants,"i"));
		this.constantJChip.setSelected(com.wiris.system.ArrayEx.contains(constants,"j"));
		var i = HxOverrides.iter(this.constantChips);
		while(i.hasNext()) {
			var chip = i.next();
			chip.setSelected(false);
			this.constantsSelectionController.removeSelectable(chip.getSelectableId());
			this.constantsChipGroup.removeComponent(com.wiris.util.type.Arrays.indexOfElement(this.constantsChipGroup.getComponents(),chip));
		}
		var moreConstantsIndex = com.wiris.util.type.Arrays.indexOfElement(this.constantsChipGroup.getComponents(),this.moreConstantsChip);
		if(moreConstantsIndex > 0) this.constantsChipGroup.removeComponent(moreConstantsIndex);
		this.constantChips = new Array();
		userConstants = this.sortArrayByLengthAndName(userConstants);
		var j;
		var hiddenConstants = true;
		var _g1 = 0, _g = constants.length;
		while(_g1 < _g) {
			var j1 = _g1++;
			if(com.wiris.util.type.Arrays.indexOfElement(userConstants,constants[j1]) >= 3) hiddenConstants = false;
		}
		var _g1 = 0, _g = userConstants.length;
		while(_g1 < _g) {
			var j1 = _g1++;
			var chip = com.wiris.util.ui.component.FilterChip.newFilterChip(userConstants[j1],userConstants[j1],new com.wiris.util.ui.Action("constant" + userConstants[j1],null),this.controller);
			if(j1 >= 3 && hiddenConstants) chip.setVisible(false);
			this.constantsSelectionController.addSelectable(chip,com.wiris.system.ArrayEx.contains(constants,userConstants[j1]));
			this.constantChips.push(chip);
			this.constantsChipGroup.addComponent(chip);
		}
		if(userConstants.length > 3) {
			this.constantsChipGroup.addComponent(this.moreConstantsChip);
			this.moreConstantsChip.setVisible(hiddenConstants);
		}
	}
	,updateVisibility: function() {
		this.setVisible(this.controller.getContext().isOptInputSyntax());
		this.constantsContainer.setVisible(this.controller.getConfigurationKey("inputOptions/inputSyntax/constants"));
		this.functionsContainer.setVisible(this.controller.getConfigurationKey("inputOptions/inputSyntax/functions"));
		this.measureUnitsContainer.setVisible(this.controller.getConfigurationKey("inputOptions/inputSyntax/measureUnits"));
		this.unitPrefixesContainer.setVisible(this.controller.getConfigurationKey("inputOptions/inputSyntax/unitPrefixes"));
		var allowedConstructions = this.controller.getConfigurationKey("inputOptions/inputSyntax/allowedConstructions");
		this.allowedConstructionsContainer.setVisible(allowedConstructions);
		if(allowedConstructions) {
			this.mixedFractionsCheckBox.setVisible(this.controller.getConfigurationKey("inputOptions/inputSyntax/allowedConstructions/mixedFractions"));
			this.listsCheckBoxContainer.setVisible(this.controller.getConfigurationKey("inputOptions/inputSyntax/allowedConstructions/lists"));
			this.intervalsCheckBox.setVisible(this.controller.getConfigurationKey("inputOptions/inputSyntax/allowedConstructions/intervals"));
			this.ratiosCheckBox.setVisible(this.controller.getConfigurationKey("inputOptions/inputSyntax/allowedConstructions/ratios"));
			this.computerScientificNotationCheckBox.setVisible(this.controller.getConfigurationKey("inputOptions/inputSyntax/allowedConstructions/computerScientificNotation"));
		}
		this.separatorsContainer.setVisible(this.controller.getConfigurationKey("inputOptions/inputSyntax/separatorSymbols"));
	}
	,allowedConstructionsContainer: null
	,allowedConstructionsSelectionController: null
	,unitPrefixesSelectionController: null
	,measureUnitsSelectionController: null
	,functionsSelectionController: null
	,constantsSelectionController: null
	,expansionController: null
	,controller: null
	,separatorsContainer: null
	,spaceSeparatorDropdown: null
	,commaSeparatorDropdown: null
	,pointSeparatorDropdown: null
	,listsCheckBoxContainer: null
	,listsWithoutEnclosersCheckBox: null
	,computerScientificNotationCheckBox: null
	,ratiosCheckBox: null
	,intervalsCheckBox: null
	,listsCheckBox: null
	,mixedFractionsCheckBox: null
	,unitPrefixesContainer: null
	,unitPrefixesMorePrefixesChip: null
	,unitPrefixes: null
	,measureUnitsMoreUnitsChip: null
	,measureUnits: null
	,measureUnitsContainer: null
	,functionsContainer: null
	,functionsChipGroup: null
	,moreFunctionsChip: null
	,functionChips: null
	,functionArithmeticChip: null
	,functionHyperbolicChip: null
	,functionTrigonometricChip: null
	,functionExpLogChip: null
	,constantsContainer: null
	,constantsChipGroup: null
	,moreConstantsChip: null
	,constantChips: null
	,constantJChip: null
	,constantIChip: null
	,constantEChip: null
	,constantPiChip: null
	,label: null
	,__class__: com.wiris.quizzes.impl.ui.component.InputSyntaxComponent
});
com.wiris.util.ui.component.Label = $hxClasses["com.wiris.util.ui.component.Label"] = function() {
	com.wiris.util.ui.component.Component.call(this);
	this.addClass(com.wiris.util.ui.component.Label.CLASS_LABEL);
	this.text = null;
};
com.wiris.util.ui.component.Label.__name__ = ["com","wiris","util","ui","component","Label"];
com.wiris.util.ui.component.Label.newWithText = function(text) {
	var label = new com.wiris.util.ui.component.Label();
	label.setText(text);
	return label;
}
com.wiris.util.ui.component.Label.newImportantWithText = function(text) {
	var label = com.wiris.util.ui.component.Label.newWithText(text);
	label.addClass(com.wiris.util.ui.component.Label.CLASS_LABEL_IMPORTANT);
	return label;
}
com.wiris.util.ui.component.Label.newHeaderWithText = function(text) {
	var label = com.wiris.util.ui.component.Label.newWithText(text);
	label.addClass(com.wiris.util.ui.component.Label.CLASS_LABEL_HEADER);
	return label;
}
com.wiris.util.ui.component.Label.newTinyWithText = function(text) {
	var label = com.wiris.util.ui.component.Label.newWithText(text);
	label.addClass(com.wiris.util.ui.component.Label.CLASS_LABEL_TINY);
	return label;
}
com.wiris.util.ui.component.Label.__super__ = com.wiris.util.ui.component.Component;
com.wiris.util.ui.component.Label.prototype = $extend(com.wiris.util.ui.component.Component.prototype,{
	setText: function(text) {
		this.text = text;
		this.changeState();
	}
	,getText: function() {
		return this.text;
	}
	,text: null
	,__class__: com.wiris.util.ui.component.Label
});
com.wiris.quizzes.impl.ui.component.MathLabel = $hxClasses["com.wiris.quizzes.impl.ui.component.MathLabel"] = function() {
	com.wiris.util.ui.component.Label.call(this);
	this.addClass(com.wiris.quizzes.impl.ui.component.MathLabel.CLASS_MATH_LABEL);
	this.mathML = false;
	this.graphic = false;
};
com.wiris.quizzes.impl.ui.component.MathLabel.__name__ = ["com","wiris","quizzes","impl","ui","component","MathLabel"];
com.wiris.quizzes.impl.ui.component.MathLabel.newWithText = function(text) {
	var label = new com.wiris.quizzes.impl.ui.component.MathLabel();
	label.setText(text);
	return label;
}
com.wiris.quizzes.impl.ui.component.MathLabel.newImportantWithText = function(text) {
	var label = com.wiris.quizzes.impl.ui.component.MathLabel.newWithText(text);
	label.addClass(com.wiris.util.ui.component.Label.CLASS_LABEL_IMPORTANT);
	return label;
}
com.wiris.quizzes.impl.ui.component.MathLabel.newHeaderWithText = function(text) {
	var label = com.wiris.quizzes.impl.ui.component.MathLabel.newWithText(text);
	label.addClass(com.wiris.util.ui.component.Label.CLASS_LABEL_HEADER);
	return label;
}
com.wiris.quizzes.impl.ui.component.MathLabel.newTinyWithText = function(text) {
	var label = com.wiris.quizzes.impl.ui.component.MathLabel.newWithText(text);
	label.addClass(com.wiris.util.ui.component.Label.CLASS_LABEL_TINY);
	return label;
}
com.wiris.quizzes.impl.ui.component.MathLabel.__super__ = com.wiris.util.ui.component.Label;
com.wiris.quizzes.impl.ui.component.MathLabel.prototype = $extend(com.wiris.util.ui.component.Label.prototype,{
	isGraphic: function() {
		return this.graphic;
	}
	,isMathML: function() {
		return this.mathML;
	}
	,setText: function(text) {
		if(text == null) text = "";
		var type = com.wiris.quizzes.impl.MathContent.getMathType(text);
		this.mathML = !(text == "") && type == com.wiris.quizzes.impl.MathContent.TYPE_MATHML;
		this.graphic = !(text == "") && type == com.wiris.quizzes.impl.MathContent.TYPE_GEOMETRY_FILE;
		com.wiris.util.ui.component.Label.prototype.setText.call(this,text);
	}
	,graphic: null
	,mathML: null
	,__class__: com.wiris.quizzes.impl.ui.component.MathLabel
});
com.wiris.util.ui.component.TextComponent = $hxClasses["com.wiris.util.ui.component.TextComponent"] = function() {
	com.wiris.util.ui.component.InputComponent.call(this);
	this.addClass(com.wiris.util.ui.component.TextComponent.CLASS_TEXT_COMPONENT).addClass(com.wiris.util.ui.component.TextComponent.CLASS_TEXT_COMPONENT_EMPTY);
	this.getStyle().setWidth(com.wiris.util.ui.Style.SIZE_FULL);
	this.text = "";
	this.placeholder = "";
	this.label = "";
	this.readOnly = false;
	this.changeAction = null;
};
com.wiris.util.ui.component.TextComponent.__name__ = ["com","wiris","util","ui","component","TextComponent"];
com.wiris.util.ui.component.TextComponent.__interfaces__ = [com.wiris.util.ui.component.Field];
com.wiris.util.ui.component.TextComponent.__super__ = com.wiris.util.ui.component.InputComponent;
com.wiris.util.ui.component.TextComponent.prototype = $extend(com.wiris.util.ui.component.InputComponent.prototype,{
	getComponent: function() {
		return this;
	}
	,setValue: function(value) {
		if(value == null) value = "";
		if(value == this.text) return;
		this.text = value;
		this.changeState();
		if(this.text.length == 0) this.addClass(com.wiris.util.ui.component.TextComponent.CLASS_TEXT_COMPONENT_EMPTY); else this.removeClass(com.wiris.util.ui.component.TextComponent.CLASS_TEXT_COMPONENT_EMPTY);
		if(this.changeAction != null) this.performAction(this.changeAction);
	}
	,getValue: function() {
		return this.text;
	}
	,setChangeAction: function(action) {
		this.changeAction = action;
	}
	,getSuffix: function() {
		return this.suffix;
	}
	,setSuffix: function(suffix) {
		this.suffix = suffix;
		if(this.suffix.length > 0) this.addClass(com.wiris.util.ui.component.TextComponent.CLASS_TEXT_COMPONENT_WITH_SUFFIX); else this.removeClass(com.wiris.util.ui.component.TextComponent.CLASS_TEXT_COMPONENT_WITH_SUFFIX);
	}
	,getPrefix: function() {
		return this.prefix;
	}
	,setPrefix: function(prefix) {
		this.prefix = prefix;
		if(this.prefix.length > 0) this.addClass(com.wiris.util.ui.component.TextComponent.CLASS_TEXT_COMPONENT_WITH_PREFIX); else this.removeClass(com.wiris.util.ui.component.TextComponent.CLASS_TEXT_COMPONENT_WITH_PREFIX);
		this.changeState();
	}
	,setLabel: function(label) {
		this.label = label;
		if(this.label.length > 0) this.addClass(com.wiris.util.ui.component.TextComponent.CLASS_TEXT_COMPONENT_WITH_LABEL); else this.removeClass(com.wiris.util.ui.component.TextComponent.CLASS_TEXT_COMPONENT_WITH_LABEL);
		this.changeState();
	}
	,getLabel: function() {
		return this.label;
	}
	,setPlaceholder: function(placeholder) {
		this.placeholder = placeholder;
	}
	,getPlaceholder: function() {
		return this.placeholder;
	}
	,isReadOnly: function() {
		return this.readOnly;
	}
	,setReadOnly: function(readOnly) {
		this.readOnly = readOnly;
		this.changeState();
	}
	,isEmpty: function() {
		return this.text.length == 0;
	}
	,getChangeAction: function() {
		return this.changeAction;
	}
	,setEnabled: function(enabled) {
		if(enabled) this.removeClass(com.wiris.util.ui.component.TextComponent.CLASS_TEXT_COMPONENT_DISABLED); else this.addClass(com.wiris.util.ui.component.TextComponent.CLASS_TEXT_COMPONENT_DISABLED);
		return com.wiris.util.ui.component.InputComponent.prototype.setEnabled.call(this,enabled);
	}
	,changeAction: null
	,readOnly: null
	,placeholder: null
	,suffix: null
	,prefix: null
	,label: null
	,text: null
	,__class__: com.wiris.util.ui.component.TextComponent
});
com.wiris.util.ui.component.TextField = $hxClasses["com.wiris.util.ui.component.TextField"] = function() {
	com.wiris.util.ui.component.TextComponent.call(this);
	this.addClass(com.wiris.util.ui.component.TextField.CLASS_TEXT_FIELD);
	this.valid = true;
	this.required = false;
	this.errorText = "";
	this.helperText = "";
	this.size = com.wiris.util.ui.component.TextField.NO_SIZE;
};
com.wiris.util.ui.component.TextField.__name__ = ["com","wiris","util","ui","component","TextField"];
com.wiris.util.ui.component.TextField.newWithLabel = function(label) {
	var textField = new com.wiris.util.ui.component.TextField();
	textField.setLabel(label);
	return textField;
}
com.wiris.util.ui.component.TextField.newWithPlaceholder = function(placeholder) {
	var textField = new com.wiris.util.ui.component.TextField();
	textField.setPlaceholder(placeholder);
	return textField;
}
com.wiris.util.ui.component.TextField.newWithLabelAndPlaceholder = function(label,placeholder) {
	var textField = new com.wiris.util.ui.component.TextField();
	textField.setPlaceholder(placeholder);
	textField.setLabel(label);
	return textField;
}
com.wiris.util.ui.component.TextField.__super__ = com.wiris.util.ui.component.TextComponent;
com.wiris.util.ui.component.TextField.prototype = $extend(com.wiris.util.ui.component.TextComponent.prototype,{
	getSize: function() {
		return this.size;
	}
	,setSize: function(size) {
		this.size = size;
		this.changeState();
	}
	,usesSize: function() {
		return this.size == com.wiris.util.ui.component.TextField.NO_SIZE;
	}
	,getErrorText: function() {
		return this.errorText;
	}
	,setHelperText: function(helperText) {
		this.helperText = helperText;
	}
	,getHelperText: function() {
		return this.helperText;
	}
	,clearError: function() {
		this.setError(null);
	}
	,setError: function(error) {
		if(error != null) {
			if(this.getStatus() != com.wiris.util.ui.component.InputComponent.STATUS_ERROR) {
				this.setStatus(com.wiris.util.ui.component.InputComponent.STATUS_ERROR);
				this.errorText = error;
				this.changeState();
			}
		} else if(this.getStatus() == com.wiris.util.ui.component.InputComponent.STATUS_ERROR) {
			this.setStatus(com.wiris.util.ui.component.InputComponent.STATUS_INDETERMINATE);
			this.errorText = "";
			this.changeState();
		}
	}
	,setRequired: function(required) {
		this.required = required;
	}
	,isRequired: function() {
		return this.required;
	}
	,isValid: function() {
		return this.valid;
	}
	,setValid: function(valid) {
		this.valid = valid;
	}
	,size: null
	,helperText: null
	,errorText: null
	,required: null
	,valid: null
	,__class__: com.wiris.util.ui.component.TextField
});
com.wiris.quizzes.impl.ui.component.MathTextField = $hxClasses["com.wiris.quizzes.impl.ui.component.MathTextField"] = function() {
	com.wiris.util.ui.component.TextField.call(this);
	this.addClass(com.wiris.quizzes.impl.ui.component.MathTextField.CLASS_MATH_TEXT_FIELD);
	this.getStyle().setMinHeight(50);
	this.mathML = false;
	this.graphic = false;
};
com.wiris.quizzes.impl.ui.component.MathTextField.__name__ = ["com","wiris","quizzes","impl","ui","component","MathTextField"];
com.wiris.quizzes.impl.ui.component.MathTextField.__super__ = com.wiris.util.ui.component.TextField;
com.wiris.quizzes.impl.ui.component.MathTextField.prototype = $extend(com.wiris.util.ui.component.TextField.prototype,{
	isEmpty: function() {
		if(com.wiris.quizzes.impl.MathContent.getMathType(this.getValue()) == com.wiris.quizzes.impl.MathContent.TYPE_MATHML) return com.wiris.quizzes.impl.MathContent.isEmpty(this.getValue()); else return com.wiris.util.ui.component.TextField.prototype.isEmpty.call(this);
	}
	,setGraphicValue: function(value) {
		this.mathML = false;
		this.graphic = true;
		com.wiris.util.ui.component.TextField.prototype.setValue.call(this,value);
	}
	,setMathMLValue: function(value) {
		this.mathML = true;
		this.graphic = false;
		com.wiris.util.ui.component.TextField.prototype.setValue.call(this,value);
	}
	,setTextValue: function(value) {
		this.graphic = false;
		this.mathML = false;
		com.wiris.util.ui.component.TextField.prototype.setValue.call(this,value);
	}
	,setValue: function(value) {
		var tools = new com.wiris.quizzes.impl.HTMLTools();
		if(value == null) value = "";
		var type = com.wiris.quizzes.impl.MathContent.getMathType(value);
		if(type == com.wiris.quizzes.impl.MathContent.TYPE_MATHML) {
			if(com.wiris.quizzes.impl.MathContent.isEmpty(value)) this.setTextValue(""); else if(tools.isTokensMathML(value)) this.setTextValue(tools.mathMLToText(value)); else this.setMathMLValue(value);
		} else if(type == com.wiris.quizzes.impl.MathContent.TYPE_GEOMETRY_FILE) this.setGraphicValue(value); else this.setTextValue(value);
	}
	,isGraphic: function() {
		return this.graphic;
	}
	,isMathML: function() {
		return this.mathML;
	}
	,graphic: null
	,mathML: null
	,__class__: com.wiris.quizzes.impl.ui.component.MathTextField
});
com.wiris.util.ui.interaction.KeyListener = $hxClasses["com.wiris.util.ui.interaction.KeyListener"] = function() { }
com.wiris.util.ui.interaction.KeyListener.__name__ = ["com","wiris","util","ui","interaction","KeyListener"];
com.wiris.util.ui.interaction.KeyListener.prototype = {
	keyType: null
	,keyRelease: null
	,keyPress: null
	,__class__: com.wiris.util.ui.interaction.KeyListener
}
com.wiris.util.ui.interaction.ComponentListener = $hxClasses["com.wiris.util.ui.interaction.ComponentListener"] = function() { }
com.wiris.util.ui.interaction.ComponentListener.__name__ = ["com","wiris","util","ui","interaction","ComponentListener"];
com.wiris.util.ui.interaction.ComponentListener.prototype = {
	styleChanged: null
	,blurRequested: null
	,focusRequested: null
	,draggableChanged: null
	,enabledChanged: null
	,visibilityChanged: null
	,__class__: com.wiris.util.ui.interaction.ComponentListener
}
com.wiris.quizzes.impl.ui.component.PopupTextField = $hxClasses["com.wiris.quizzes.impl.ui.component.PopupTextField"] = function(tooltip,icon) {
	com.wiris.quizzes.impl.ui.component.MathTextField.call(this);
	this.addClass(com.wiris.quizzes.impl.ui.component.PopupTextField.CLASS_POPUP_TEXT_FIELD);
	this.openPopupAction = new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.PopupTextField.OPENED_POPUP_ACTION_ID,null);
	this.windowLoadedAction = new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.PopupTextField.POPUP_TEXT_FIELD_WINDOW_LOADED_ACTION_ID,null);
	this.button = com.wiris.util.ui.component.Button.newWithIcon(tooltip,icon,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.PopupTextField.POPUP_TEXT_FIELD_BUTTON_ACTION_ID,null),this);
	this.button.addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON);
	this.button.getStyle().setWidth(34).setHeight(34);
	this.button.setParent(this);
	this.windowComponent = this.createWindowComponent();
	this.windowLoaded = false;
	this.setModalWindow(this.createModalWindow());
	this.addKeyListener(this);
	this.addMouseListener(this);
	if(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().isForceLTR()) this.addClass(com.wiris.util.ui.component.TextField.CLASS_FORCE_LTR);
};
com.wiris.quizzes.impl.ui.component.PopupTextField.__name__ = ["com","wiris","quizzes","impl","ui","component","PopupTextField"];
com.wiris.quizzes.impl.ui.component.PopupTextField.__interfaces__ = [com.wiris.util.ui.interaction.MouseListener,com.wiris.util.ui.interaction.KeyListener,com.wiris.util.ui.interaction.ComponentListener,com.wiris.util.ui.interaction.ActionListener];
com.wiris.quizzes.impl.ui.component.PopupTextField.newWithComponent = function(tooltip,icon,content) {
	var textField = new com.wiris.quizzes.impl.ui.component.PopupTextField(tooltip,icon);
	textField.getModalWindow().addComponent(content);
	return textField;
}
com.wiris.quizzes.impl.ui.component.PopupTextField.__super__ = com.wiris.quizzes.impl.ui.component.MathTextField;
com.wiris.quizzes.impl.ui.component.PopupTextField.prototype = $extend(com.wiris.quizzes.impl.ui.component.MathTextField.prototype,{
	styleChanged: function(e) {
	}
	,blurRequested: function(e) {
	}
	,focusRequested: function(e) {
	}
	,draggableChanged: function(e) {
	}
	,enabledChanged: function(e) {
	}
	,visibilityChanged: function(e) {
		if(e.getSource().isVisible()) {
			if(this.getMainFocus() != null) new com.wiris.util.ui.async.FocusTask(this.getMainFocus());
		} else new com.wiris.util.ui.async.FocusTask(this);
	}
	,actionPerformed: function(e) {
		var action = e.getAction();
		var actionId = action.getId();
		if(actionId == com.wiris.quizzes.impl.ui.component.PopupTextField.POPUP_TEXT_FIELD_BUTTON_ACTION_ID) this.open();
	}
	,mouseExit: function(e) {
	}
	,mouseEnter: function(e) {
	}
	,mouseRelease: function(e) {
	}
	,mousePress: function(e) {
	}
	,mouseDoubleClick: function(e) {
	}
	,mouseClick: function(e) {
		if(e.getTarget() == this) {
			if(this.isMathML() || this.isGraphic()) this.open();
		}
	}
	,keyType: function(e) {
	}
	,keyRelease: function(e) {
		var keyCode = e.getKeyCode();
		if(com.wiris.util.ui.interaction.KeyCode.ENTER == keyCode) {
			if(e.getTarget() == this) this.open();
		}
	}
	,keyPress: function(e) {
	}
	,onWindowLoaded: function() {
		if(!this.windowLoaded) {
			this.windowLoaded = true;
			this.performAction(this.windowLoadedAction);
		}
		this.getMainFocus().requestFocus();
	}
	,setGraphicValue: function(value) {
		com.wiris.quizzes.impl.ui.component.MathTextField.prototype.setGraphicValue.call(this,value);
		this.addClass(com.wiris.quizzes.impl.ui.component.PopupTextField.CLASS_POPUP_TEXT_FIELD_CLICKABLE);
	}
	,setMathMLValue: function(value) {
		com.wiris.quizzes.impl.ui.component.MathTextField.prototype.setMathMLValue.call(this,value);
		this.addClass(com.wiris.quizzes.impl.ui.component.PopupTextField.CLASS_POPUP_TEXT_FIELD_CLICKABLE);
	}
	,setTextValue: function(value) {
		com.wiris.quizzes.impl.ui.component.MathTextField.prototype.setTextValue.call(this,value);
		this.removeClass(com.wiris.quizzes.impl.ui.component.PopupTextField.CLASS_POPUP_TEXT_FIELD_CLICKABLE);
	}
	,open: function() {
		this.performAction(this.openPopupAction);
		this.modalWindow.open();
		if(!this.isWindowLoaded()) this.onWindowLoaded();
	}
	,setOpenPopupAction: function(openPopupAction) {
		this.openPopupAction = openPopupAction;
	}
	,getOpenPopupAction: function() {
		return this.openPopupAction;
	}
	,isWindowLoaded: function() {
		return this.windowLoaded;
	}
	,getMainFocus: function() {
		return null;
	}
	,getWindowComponent: function() {
		return this.windowComponent;
	}
	,setModalWindow: function(window) {
		if(window != null) {
			if(this.modalWindow != null) {
				this.modalWindow.removeComponentListener(this);
				this.windowComponent.removeAllComponents();
			}
			this.modalWindow = window;
			this.modalWindow.addComponentListener(this);
			if(!this.windowComponent.isChild(this.modalWindow)) this.windowComponent.addComponent(this.modalWindow);
		}
	}
	,getModalWindow: function() {
		return this.modalWindow;
	}
	,getButton: function() {
		return this.button;
	}
	,getComponentsByClassName: function(className) {
		var result = new Array();
		if(this.hasClass(className)) result.push(this);
		if(this.button.hasClass(className)) result.push(this.button);
		return result;
	}
	,getComponentById: function(id) {
		if(this.button.getComponentById(id) != null) return this.button.getComponentById(id);
		if(this.isWindowLoaded()) {
			if(this.modalWindow.getComponentById(id) != null) return this.modalWindow.getComponentById(id);
		}
		return com.wiris.quizzes.impl.ui.component.MathTextField.prototype.getComponentById.call(this,id);
	}
	,getChildren: function() {
		var children = new Array();
		children.push(this.button);
		if(this.isWindowLoaded()) children.push(this.modalWindow);
		return children;
	}
	,createWindowComponent: function() {
		var windowComponent = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
		windowComponent.getStyle().setWidth(0).setHeight(0);
		windowComponent.setApplicationClass(com.wiris.quizzes.impl.ui.component.PopupTextField.CLASS_POPUP_TEXT_FIELD_WINDOW);
		windowComponent.setParent(this);
		return windowComponent;
	}
	,createModalWindow: function() {
		return new com.wiris.quizzes.impl.ui.component.PopupWindow(this);
	}
	,windowLoadedAction: null
	,openPopupAction: null
	,windowComponent: null
	,modalWindow: null
	,button: null
	,windowLoaded: null
	,__class__: com.wiris.quizzes.impl.ui.component.PopupTextField
});
com.wiris.quizzes.impl.ui.component.MathTypePopupTextField = $hxClasses["com.wiris.quizzes.impl.ui.component.MathTypePopupTextField"] = function(mathtypeParameters) {
	this.easyModalClose = false;
	com.wiris.quizzes.impl.ui.component.PopupTextField.call(this,com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.MathTypePopupTextField.POPUP_MATHTYPE_TEXT_FIELD_BUTTON_TOOLTIP),com.wiris.util.ui.ImageIcon.newFromFile(com.wiris.quizzes.impl.ui.component.MathTypePopupTextField.POPUP_MATHTYPE_TEXT_FIELD_BUTTON_ICON));
	this.getButton().addClass(com.wiris.util.ui.component.Button.CLASS_BUTTON_CONTAINED);
	this.getButton().getStyle().setBackgroundColor(com.wiris.util.graphics.Color.fromText("#f26a54"));
	this.editor = com.wiris.quizzes.impl.ui.component.MathTypeInputComponent.newWithValue(this.getValue(),mathtypeParameters);
	this.getModalWindow().setMovable(true);
	this.getModalWindow().setTitle("MathType");
	this.getModalWindow().setResizable(true);
	var closeButton = com.wiris.util.ui.component.Button.newWithIcon(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.MathTypePopupTextField.TOOLTIP_CLOSE_MATHTYPE_POPUP),new com.wiris.util.ui.MaterialIcon("close"),new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.MathTypePopupTextField.POPUP_MATHTYPE_TEXT_FIELD_CANCEL_ACTION_ID,com.wiris.quizzes.impl.ui.component.MathTypePopupTextField.POPUP_MATHTYPE_TEXT_FIELD_CANCEL_ACTION_ID),this);
	this.getModalWindow().addTitleBarButton(closeButton);
};
com.wiris.quizzes.impl.ui.component.MathTypePopupTextField.__name__ = ["com","wiris","quizzes","impl","ui","component","MathTypePopupTextField"];
com.wiris.quizzes.impl.ui.component.MathTypePopupTextField.__interfaces__ = [com.wiris.util.ui.interaction.ActionListener];
com.wiris.quizzes.impl.ui.component.MathTypePopupTextField.__super__ = com.wiris.quizzes.impl.ui.component.PopupTextField;
com.wiris.quizzes.impl.ui.component.MathTypePopupTextField.prototype = $extend(com.wiris.quizzes.impl.ui.component.PopupTextField.prototype,{
	setReadOnly: function(readOnly) {
		com.wiris.quizzes.impl.ui.component.PopupTextField.prototype.setReadOnly.call(this,readOnly);
		this.editor.setReadOnly(readOnly);
	}
	,open: function() {
		com.wiris.quizzes.impl.ui.component.PopupTextField.prototype.open.call(this);
		this.editor.setValue(this.getValue());
		this.editor.requestFocus();
	}
	,setGrammarUrl: function(grammarUrl,check) {
		this.editor.setGrammarUrl(grammarUrl,check);
	}
	,setParameters: function(parameters) {
		this.editor.setParameters(parameters);
	}
	,actionPerformed: function(e) {
		var action = e.getAction();
		var actionId = action.getId();
		if(actionId == com.wiris.quizzes.impl.ui.component.MathTypePopupTextField.POPUP_MATHTYPE_TEXT_FIELD_ACCEPT_VALUE_ACTION_ID) {
			this.setValue(this.editor.getValue());
			this.getModalWindow().close();
		} else if(actionId == com.wiris.quizzes.impl.ui.component.MathTypePopupTextField.POPUP_MATHTYPE_TEXT_FIELD_CANCEL_ACTION_ID) this.getModalWindow().close(); else com.wiris.quizzes.impl.ui.component.PopupTextField.prototype.actionPerformed.call(this,e);
	}
	,onWindowLoaded: function() {
		com.wiris.quizzes.impl.ui.component.PopupTextField.prototype.onWindowLoaded.call(this);
		this.getModalWindow().setEasyModalCloseEnabled(this.easyModalClose);
		this.getModalWindow().getStyle().setMargin(24,8,8,8);
		var buttonsWrapper = new com.wiris.util.ui.component.BorderPanel(false);
		buttonsWrapper.getStyle().setMargin(16,0,0,0);
		var buttonsContainer = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_RIGHT_TO_LEFT);
		var acceptButton = com.wiris.util.ui.component.Button.newWithText(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.MathTypePopupTextField.POPUP_MATHTYPE_TEXT_FIELD_ACCEPT_DIALOG),new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.MathTypePopupTextField.POPUP_MATHTYPE_TEXT_FIELD_ACCEPT_VALUE_ACTION_ID,null),this);
		acceptButton.addClass(com.wiris.util.ui.component.Button.CLASS_BUTTON_CONTAINED).addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON);
		acceptButton.getStyle().setMargin(0,0,0,16);
		acceptButton.addActionListener(this);
		var cancelButton = com.wiris.util.ui.component.Button.newWithText(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().t(com.wiris.quizzes.impl.ui.component.MathTypePopupTextField.POPUP_MATHTYPE_TEXT_FIELD_CANCEL_DIALOG),new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.MathTypePopupTextField.POPUP_MATHTYPE_TEXT_FIELD_CANCEL_ACTION_ID,null),this);
		cancelButton.addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON);
		cancelButton.addActionListener(this);
		buttonsContainer.addComponent(acceptButton);
		buttonsContainer.addComponent(cancelButton);
		buttonsWrapper.addComponent(buttonsContainer,com.wiris.util.ui.component.BorderPanel.POSITION_SOUTH_EAST);
		this.getModalWindow().addComponent(this.editor);
		this.getModalWindow().addComponent(buttonsWrapper);
	}
	,getMainFocus: function() {
		return this.editor;
	}
	,setEasyModalClose: function(easyModalClose) {
		this.easyModalClose = easyModalClose;
	}
	,easyModalClose: null
	,editor: null
	,__class__: com.wiris.quizzes.impl.ui.component.MathTypePopupTextField
});
com.wiris.quizzes.impl.ui.component.MeasureUnitsValidationComponent = $hxClasses["com.wiris.quizzes.impl.ui.component.MeasureUnitsValidationComponent"] = function(controller) {
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_FULL_SIZE_PANEL);
	this.label = com.wiris.util.ui.component.Label.newImportantWithText(controller.t(com.wiris.quizzes.impl.ui.component.MeasureUnitsValidationComponent.MEASURE_UNITS_VALIDATION_LABEL));
	this.allowPrefixesCheckBox = com.wiris.util.ui.component.CheckBox.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.MeasureUnitsValidationComponent.MEASURE_UNITS_VALIDATION_LABEL_ALLOW_PREFIXES),controller.t(com.wiris.quizzes.impl.ui.component.MeasureUnitsValidationComponent.MEASURE_UNITS_VALIDATION_HELPER_TEXT_ALLOW_PREFIXES),com.wiris.quizzes.impl.ui.component.MeasureUnitsValidationComponent.MEASURE_UNITS_VALIDATION_ID_ALLOW_PREFIXES,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.MeasureUnitsValidationComponent.MEASURE_UNITS_VALIDATION_ID_ALLOW_PREFIXES,null),controller);
	this.allowPrefixesCheckBox.setId("validationOptionsAllowPrefixes");
	var allowPrefixesPanel = com.wiris.util.ui.component.FlowPanel.newWithChild(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM,this.allowPrefixesCheckBox);
	allowPrefixesPanel.setIndentationLevel(2);
	this.matchUnitsCheckBox = com.wiris.util.ui.component.CheckBox.newWithHelperText(controller.t(com.wiris.quizzes.impl.ui.component.MeasureUnitsValidationComponent.MEASURE_UNITS_VALIDATION_LABEL_MATCH_UNITS),controller.t(com.wiris.quizzes.impl.ui.component.MeasureUnitsValidationComponent.MEASURE_UNITS_VALIDATION_HELPER_TEXT_MATCH_UNITS),com.wiris.quizzes.impl.ui.component.MeasureUnitsValidationComponent.MEASURE_UNITS_VALIDATION_ID_MATCH_UNITS,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.MeasureUnitsValidationComponent.MEASURE_UNITS_VALIDATION_ID_MATCH_UNITS,null),controller);
	this.matchUnitsCheckBox.setId("validationOptionsMatchMeasureUnit");
	this.matchUnitsCheckBox.addActionListener(this);
	this.expansionController = new com.wiris.util.ui.controller.ExpansionController(this,allowPrefixesPanel,false);
	var content = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	content.addClass(com.wiris.util.ui.component.Panel.CLASS_PANEL_CARD);
	content.addComponent(this.matchUnitsCheckBox);
	content.addComponent(allowPrefixesPanel);
	this.addComponent(this.label);
	this.addComponent(content);
};
com.wiris.quizzes.impl.ui.component.MeasureUnitsValidationComponent.__name__ = ["com","wiris","quizzes","impl","ui","component","MeasureUnitsValidationComponent"];
com.wiris.quizzes.impl.ui.component.MeasureUnitsValidationComponent.__interfaces__ = [com.wiris.util.ui.interaction.ActionListener];
com.wiris.quizzes.impl.ui.component.MeasureUnitsValidationComponent.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.quizzes.impl.ui.component.MeasureUnitsValidationComponent.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	showAllValidationAssertions: function() {
		this.setVisible(true);
	}
	,showFeaturedValidationAssertions: function(featuredAssertions) {
		var isVisible = com.wiris.system.ArrayEx.contains(featuredAssertions,com.wiris.quizzes.impl.Assertion.CHECK_UNIT) || com.wiris.system.ArrayEx.contains(featuredAssertions,com.wiris.quizzes.impl.Assertion.CHECK_UNIT_LITERAL) || com.wiris.system.ArrayEx.contains(featuredAssertions,com.wiris.quizzes.impl.Assertion.CHECK_EQUIVALENT_UNITS);
		this.setVisible(isVisible);
	}
	,setAllowAllPrefixes: function(selected) {
		this.allowPrefixesCheckBox.setSelected(selected);
	}
	,setMatchingUnit: function(selected) {
		this.matchUnitsCheckBox.setSelected(selected);
	}
	,actionPerformed: function(e) {
		var action = e.getAction();
		var actionId = action.getId();
		if(actionId == com.wiris.quizzes.impl.ui.component.MeasureUnitsValidationComponent.MEASURE_UNITS_VALIDATION_ID_MATCH_UNITS) this.expansionController.toggle();
	}
	,expansionController: null
	,allowPrefixesCheckBox: null
	,matchUnitsCheckBox: null
	,label: null
	,__class__: com.wiris.quizzes.impl.ui.component.MeasureUnitsValidationComponent
});
com.wiris.quizzes.impl.ui.component.NumberValidationComponent = $hxClasses["com.wiris.quizzes.impl.ui.component.NumberValidationComponent"] = function(controller) {
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_FULL_SIZE_PANEL);
	this.symbolicAnswer = false;
	this.controller = controller;
	this.label = com.wiris.util.ui.component.Label.newImportantWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL));
	this.symbolicAnswerCheckBox = com.wiris.util.ui.component.CheckBox.newWithHelperText(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_SYMBOLIC_ANSWER),this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_HELPER_TEXT_SYMBOLIC_ANSWER),com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_ID_SYMBOLIC_ANSWER,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_ID_SYMBOLIC_ANSWER,null),this);
	this.symbolicAnswerCheckBox.setId("validationOptionsSymbolic");
	this.symbolicAnswerCheckBox.addActionListener(this.controller);
	this.divider = new com.wiris.util.ui.component.Divider(false);
	this.toleranceLabel = com.wiris.util.ui.component.Label.newImportantWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_TOLERANCE));
	this.formatLabel = com.wiris.util.ui.component.Label.newImportantWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_FORMAT));
	this.precisionLabel = com.wiris.util.ui.component.Label.newImportantWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_PRECISION));
	this.toleranceSelectionController = com.wiris.util.ui.controller.SelectionController.newMutuallyExclusive(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_ID_TOLERANCE);
	this.exactAnswerRadioButton = com.wiris.util.ui.component.RadioButton.newWithHelperText(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_EXACT_ANSWER),this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_HELPER_TEXT_EXACT_ANSWER),com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_ID_EXACT_ANSWER,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_ID_EXACT_ANSWER,null),this.controller);
	this.exactAnswerRadioButton.setId("validationOptionsExactAnswer");
	this.toleranceSelectionController.addSelectable(this.exactAnswerRadioButton,false);
	this.errorMarginQtyTextField = com.wiris.util.ui.component.NumberTextField.newWithLabel(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_PERCENT_ERROR));
	this.errorMarginQtyTextField.addClass(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.CLASS_QUIZZES_INLINE_TEXT_FIELD);
	this.errorMarginQtyTextField.setValue("0.1");
	this.errorMarginQtyTextField.setChangeAction(new com.wiris.util.ui.Action("errorMarginQty",null));
	this.errorMarginQtyTextField.addActionListener(this.controller);
	this.errorMarginTypeDropdown = new com.wiris.util.ui.component.Dropdown();
	this.errorMarginTypeDropdown.addClass(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.CLASS_QUIZZES_INLINE_DROPDOWN);
	this.errorMarginTypeDropdown.addValue("errorMarginPercentError",this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_PERCENT_ERROR));
	this.errorMarginTypeDropdown.addValue("errorMarginAbsoluteError",this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_ABSOLUTE_ERROR));
	this.errorMarginTypeDropdown.pickValue("errorMarginPercentError");
	this.errorMarginTypeDropdown.setChangeValueAction(new com.wiris.util.ui.Action("errorMarginType",null));
	this.errorMarginTypeDropdown.addActionListener(this.controller);
	this.errorMarginTypeDropdown.addActionListener(this);
	this.errorMarginRadioButton = com.wiris.util.ui.component.RadioButton.newWithHelperText(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_ERROR_MARGIN),this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_HELPER_TEXT_ERROR_MARGIN),com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_ID_ERROR_MARGIN,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_ID_ERROR_MARGIN,null),this.controller);
	this.toleranceSelectionController.addSelectable(this.errorMarginRadioButton,true);
	this.errorMarginPanel = this.errorMarginRadioButton.getTextPanel();
	this.errorMarginPanel.setId("validationOptionsErrorMargin");
	this.errorMarginPanel.addComponent(this.errorMarginQtyTextField);
	this.errorMarginPanel.addComponent(this.errorMarginTypeDropdown);
	this.matchingDigitsQtyTextField = com.wiris.util.ui.component.NumberTextField.newWithLabel(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_PRECISION_SIGNIFICANT_FIGURES));
	this.matchingDigitsQtyTextField.addClass(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.CLASS_QUIZZES_INLINE_TEXT_FIELD);
	this.matchingDigitsQtyTextField.setValue("3");
	this.matchingDigitsQtyTextField.setChangeAction(new com.wiris.util.ui.Action("matchingDigitsQty",null));
	this.matchingDigitsQtyTextField.addActionListener(this.controller);
	this.matchingDigitsTypeDropdown = new com.wiris.util.ui.component.Dropdown();
	this.matchingDigitsTypeDropdown.addClass(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.CLASS_QUIZZES_INLINE_DROPDOWN);
	this.matchingDigitsTypeDropdown.addValue("matchingDigitsSignificantFigures",this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_PRECISION_SIGNIFICANT_FIGURES));
	this.matchingDigitsTypeDropdown.addValue("matchingDigitsDecimalPlaces",this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_PRECISION_DECIMAL_PLACES));
	this.matchingDigitsTypeDropdown.pickValue("matchingDigitsSignificantFigures");
	this.matchingDigitsTypeDropdown.setChangeValueAction(new com.wiris.util.ui.Action("matchingDigitsType",null));
	this.matchingDigitsTypeDropdown.addActionListener(this.controller);
	this.matchingDigitsTypeDropdown.addActionListener(this);
	this.matchingDigitsRadioButton = com.wiris.util.ui.component.RadioButton.newWithHelperText(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_MATCHING_DIGITS),this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_HELPER_TEXT_MATCHING_DIGITS),com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_ID_MATCHING_DIGITS,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_ID_MATCHING_DIGITS,null),this.controller);
	this.toleranceSelectionController.addSelectable(this.matchingDigitsRadioButton,false);
	this.matchingDigitsPanel = this.matchingDigitsRadioButton.getTextPanel();
	this.matchingDigitsPanel.setId("validationOptionsMatchingDigits");
	this.matchingDigitsPanel.addComponent(this.matchingDigitsQtyTextField);
	this.matchingDigitsPanel.addComponent(this.matchingDigitsTypeDropdown);
	this.formatSelectionController = com.wiris.util.ui.controller.SelectionController.newMutuallyExclusive(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_ID_FORMAT);
	this.scientificNotationRadioButton = com.wiris.util.ui.component.RadioButton.newWithHelperText(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_SCIENTIFIC_NOTATION),this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_HELPER_TEXT_SCIENTIFIC_NOTATION),com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_ID_SCIENTIFIC_NOTATION,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_ID_SCIENTIFIC_NOTATION,null),this.controller);
	this.scientificNotationRadioButton.setId("validationOptionsScientificNotation");
	var formula = com.wiris.quizzes.impl.ui.component.MathLabel.newWithText("<math xmlns=\"http://www.w3.org/1998/Math/MathML\"><mn>6</mn><mo>.</mo><mn>02</mn><mo>&#xB7;</mo><msup><mn>10</mn><mn>23</mn></msup></math>");
	formula.getStyle().setBorderSize(0,0,2,0);
	this.scientificNotationRadioButton.getHelperTextPanel().addComponent(formula);
	this.formatSelectionController.addSelectable(this.scientificNotationRadioButton,false);
	this.decimalNotationRadioButton = com.wiris.util.ui.component.RadioButton.newWithHelperText(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_DECIMAL_NOTATION),this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_HELPER_TEXT_DECIMAL_NOTATION),com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_ID_DECIMAL_NOTATION,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_ID_DECIMAL_NOTATION,null),this.controller);
	this.decimalNotationRadioButton.setId("validationOptionsDecimalNotation");
	this.formatSelectionController.addSelectable(this.decimalNotationRadioButton,false);
	this.anyNotationRadioButton = com.wiris.util.ui.component.RadioButton.newWithHelperText(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_ANY_NOTATION),this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_HELPER_TEXT_ANY_NOTATION),com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_ID_ANY_NOTATION,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_ID_ANY_NOTATION,null),this.controller);
	this.anyNotationRadioButton.setId("validationOptionsAnyNotation");
	this.formatSelectionController.addSelectable(this.anyNotationRadioButton,true);
	this.precisionMinimumTextField = com.wiris.util.ui.component.NumberTextField.newWithLabel(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_PRECISION_SIGNIFICANT_FIGURES));
	this.precisionMinimumTextField.addClass(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.CLASS_QUIZZES_INLINE_TEXT_FIELD);
	this.precisionMinimumTextField.setChangeAction(new com.wiris.util.ui.Action("precisionMinimum",null));
	this.precisionMinimumTextField.addActionListener(this.controller);
	var precisionLabel2 = com.wiris.util.ui.component.Label.newWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_PRECISION_ENABLED_2));
	this.precisionMaximumTextField = com.wiris.util.ui.component.NumberTextField.newWithLabel(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_PRECISION_SIGNIFICANT_FIGURES));
	this.precisionMaximumTextField.addClass(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.CLASS_QUIZZES_INLINE_TEXT_FIELD);
	this.precisionMaximumTextField.setChangeAction(new com.wiris.util.ui.Action("precisionMaximum",null));
	this.precisionMaximumTextField.addActionListener(this.controller);
	this.precisionTypeDropdown = new com.wiris.util.ui.component.Dropdown();
	this.precisionTypeDropdown.addClass(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.CLASS_QUIZZES_INLINE_DROPDOWN);
	this.precisionTypeDropdown.addValue("precisionSignificantFigures",this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_PRECISION_SIGNIFICANT_FIGURES));
	this.precisionTypeDropdown.addValue("precisionDecimalPlaces",this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_PRECISION_DECIMAL_PLACES));
	this.precisionTypeDropdown.pickValue("precisionSignificantFigures");
	this.precisionTypeDropdown.setChangeValueAction(new com.wiris.util.ui.Action("precisionType",null));
	this.precisionTypeDropdown.addActionListener(this.controller);
	this.precisionTypeDropdown.addActionListener(this);
	this.precisionEnabledCheckBox = com.wiris.util.ui.component.CheckBox.newWithHelperText(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_PRECISION_ENABLED),this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_HELPER_TEXT_PRECISION_ENABLED),com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_ID_PRECISION_ENABLED,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_ID_PRECISION_ENABLED,null),this.controller);
	this.precisionPanel = this.precisionEnabledCheckBox.getTextPanel();
	this.precisionPanel.setId("validationOptionsPrecision");
	this.precisionPanel.addComponent(this.precisionMinimumTextField);
	this.precisionPanel.addComponent(precisionLabel2);
	this.precisionPanel.addComponent(this.precisionMaximumTextField);
	this.precisionPanel.addComponent(this.precisionTypeDropdown);
	var content = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	content.addClass(com.wiris.util.ui.component.Panel.CLASS_PANEL_CARD);
	content.addComponent(this.symbolicAnswerCheckBox);
	content.addComponent(this.divider);
	content.addComponent(this.toleranceLabel);
	content.addComponent(this.exactAnswerRadioButton);
	content.addComponent(this.errorMarginRadioButton);
	content.addComponent(this.matchingDigitsRadioButton);
	content.addComponent(this.formatLabel);
	content.addComponent(this.scientificNotationRadioButton);
	content.addComponent(this.decimalNotationRadioButton);
	content.addComponent(this.anyNotationRadioButton);
	content.addComponent(this.precisionLabel);
	content.addComponent(this.precisionEnabledCheckBox);
	this.addComponent(this.label);
	this.addComponent(content);
};
com.wiris.quizzes.impl.ui.component.NumberValidationComponent.__name__ = ["com","wiris","quizzes","impl","ui","component","NumberValidationComponent"];
com.wiris.quizzes.impl.ui.component.NumberValidationComponent.__interfaces__ = [com.wiris.util.ui.interaction.ActionListener];
com.wiris.quizzes.impl.ui.component.NumberValidationComponent.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.quizzes.impl.ui.component.NumberValidationComponent.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	showAllValidationAssertions: function() {
		this.setVisible(true);
		this.symbolicAnswerCheckBox.setVisible(true);
		if(!this.symbolicAnswer) {
			this.divider.setVisible(true);
			this.toleranceLabel.setVisible(true);
			this.exactAnswerRadioButton.setVisible(true);
			this.errorMarginPanel.setVisible(true);
			this.matchingDigitsPanel.setVisible(true);
			this.formatLabel.setVisible(true);
			this.scientificNotationRadioButton.setVisible(true);
			this.decimalNotationRadioButton.setVisible(true);
			this.anyNotationRadioButton.setVisible(true);
			this.precisionLabel.setVisible(true);
			this.precisionEnabledCheckBox.setVisible(true);
			this.precisionPanel.setVisible(true);
		}
	}
	,showFeaturedValidationAssertions: function(featuredAssertions) {
		var symbolic = com.wiris.system.ArrayEx.contains(featuredAssertions,com.wiris.quizzes.impl.Assertion.CHECK_SYMBOLIC);
		var decimalNotation = com.wiris.system.ArrayEx.contains(featuredAssertions,com.wiris.quizzes.impl.Assertion.CHECK_DECIMAL_NOTATION);
		var scientificNotation = com.wiris.system.ArrayEx.contains(featuredAssertions,com.wiris.quizzes.impl.Assertion.CHECK_SCIENTIFIC_NOTATION);
		var precision = com.wiris.system.ArrayEx.contains(featuredAssertions,com.wiris.quizzes.impl.Assertion.CHECK_PRECISION);
		this.symbolicAnswerCheckBox.setVisible(symbolic);
		if(!symbolic || !this.symbolicAnswer) {
			this.setVisible(true);
			this.divider.setVisible(symbolic);
			this.toleranceLabel.setVisible(true);
			this.exactAnswerRadioButton.setVisible(true);
			this.errorMarginPanel.setVisible(true);
			this.matchingDigitsPanel.setVisible(true);
			this.formatLabel.setVisible(decimalNotation || scientificNotation);
			this.scientificNotationRadioButton.setVisible(scientificNotation);
			this.decimalNotationRadioButton.setVisible(decimalNotation);
			this.anyNotationRadioButton.setVisible(decimalNotation || scientificNotation);
			this.precisionLabel.setVisible(precision);
			this.precisionEnabledCheckBox.setVisible(precision);
			this.precisionPanel.setVisible(precision);
		} else {
			this.setVisible(symbolic);
			this.divider.setVisible(false);
			this.toleranceLabel.setVisible(false);
			this.exactAnswerRadioButton.setVisible(false);
			this.errorMarginPanel.setVisible(false);
			this.matchingDigitsPanel.setVisible(false);
			this.formatLabel.setVisible(false);
			this.scientificNotationRadioButton.setVisible(false);
			this.decimalNotationRadioButton.setVisible(false);
			this.anyNotationRadioButton.setVisible(false);
			this.precisionLabel.setVisible(false);
			this.precisionEnabledCheckBox.setVisible(false);
			this.precisionPanel.setVisible(false);
		}
	}
	,setSymbolicAnswer: function(selected) {
		this.symbolicAnswerCheckBox.setSelected(selected);
	}
	,setPrecisionEnabled: function(enabled) {
		if(!this.symbolicAnswer) this.precisionEnabledCheckBox.setSelected(enabled);
	}
	,setPrecisionType: function(type) {
		if(!this.symbolicAnswer) {
			if(type == "significant_figures") this.precisionTypeDropdown.pickValue("precisionSignificantFigures"); else if(type == "decimal_places") this.precisionTypeDropdown.pickValue("precisionDecimalPlaces");
		}
	}
	,setPrecisionMaximum: function(maximum) {
		if(!this.symbolicAnswer) this.precisionMaximumTextField.setValue(maximum);
	}
	,setPrecisionMinimum: function(minimum) {
		if(!this.symbolicAnswer) this.precisionMinimumTextField.setValue(minimum);
	}
	,setMatchingDigitsValue: function(toleranceDigits) {
		if(!this.symbolicAnswer) this.matchingDigitsQtyTextField.setValue(toleranceDigits);
	}
	,setMatchingDigitsType: function(type) {
		if(!this.symbolicAnswer) {
			if(type == "significant_figures") this.matchingDigitsTypeDropdown.pickValue("matchingDigitsSignificantFigures"); else if(type == "decimal_places") this.matchingDigitsTypeDropdown.pickValue("matchingDigitsDecimalPlaces");
		}
	}
	,setErrorMarginValue: function(tolerance) {
		if(!this.symbolicAnswer) this.errorMarginQtyTextField.setValue(tolerance);
	}
	,setErrorMarginType: function(type) {
		if(!this.symbolicAnswer) {
			if(type == "percent_error") this.errorMarginTypeDropdown.pickValue("errorMarginPercentError"); else if(type == "absolute_error") this.errorMarginTypeDropdown.pickValue("errorMarginAbsoluteError");
		}
	}
	,setExactAnswer: function() {
		if(!this.symbolicAnswer) this.exactAnswerRadioButton.setSelected(true);
	}
	,setErrorMargin: function() {
		if(!this.symbolicAnswer) this.errorMarginRadioButton.setSelected(true);
	}
	,setMatchingDigits: function() {
		if(!this.symbolicAnswer) this.matchingDigitsRadioButton.setSelected(true);
	}
	,setAnyNotation: function() {
		if(!this.symbolicAnswer) this.anyNotationRadioButton.setSelected(true);
	}
	,setDecimalNotation: function() {
		if(!this.symbolicAnswer) this.decimalNotationRadioButton.setSelected(true);
	}
	,setScientificNotation: function() {
		if(!this.symbolicAnswer) this.scientificNotationRadioButton.setSelected(true);
	}
	,actionPerformed: function(e) {
		var source = e.getSource();
		var action = e.getAction();
		var actionId = action.getId();
		var command = action.getCommand();
		if("symbolicAnswer" == actionId) {
			if(source.isSelected()) this.symbolicAnswer = true; else this.symbolicAnswer = false;
		} else if("errorMarginType" == actionId) {
			var value = source.getValue();
			if(value == "errorMarginPercentError") this.errorMarginQtyTextField.setLabel(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_PERCENT_ERROR)); else if(value == "errorMarginAbsoluteError") this.errorMarginQtyTextField.setLabel(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_ABSOLUTE_ERROR));
			this.errorMarginQtyTextField.changeState();
		} else if("matchingDigitsType" == actionId) {
			var value = source.getValue();
			if(value == "matchingDigitsSignificantFigures") this.matchingDigitsQtyTextField.setLabel(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_PRECISION_SIGNIFICANT_FIGURES)); else if(value == "matchingDigitsDecimalPlaces") this.matchingDigitsQtyTextField.setLabel(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_PRECISION_DECIMAL_PLACES));
			this.matchingDigitsQtyTextField.changeState();
		} else if("precisionType" == actionId) {
			var value = source.getValue();
			if(value == "precisionSignificantFigures") {
				this.precisionMinimumTextField.setLabel(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_PRECISION_SIGNIFICANT_FIGURES));
				this.precisionMaximumTextField.setLabel(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_PRECISION_SIGNIFICANT_FIGURES));
			} else if(value == "precisionDecimalPlaces") {
				this.precisionMinimumTextField.setLabel(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_PRECISION_DECIMAL_PLACES));
				this.precisionMaximumTextField.setLabel(this.controller.t(com.wiris.quizzes.impl.ui.component.NumberValidationComponent.NUMBER_VALIDATION_LABEL_PRECISION_DECIMAL_PLACES));
			}
			this.precisionMinimumTextField.changeState();
			this.precisionMaximumTextField.changeState();
		}
	}
	,updateVisibility: function() {
		this.setVisible(this.controller.getConfigurationKey("validationOptions/numbers"));
		this.symbolicAnswerCheckBox.setVisible(this.controller.getConfigurationKey("validationOptions/numbers/symbolicAnswer"));
		if(!this.symbolicAnswer) {
			this.divider.setVisible(this.controller.getConfigurationKey("validationOptions/numbers/symbolicAnswer"));
			this.toleranceLabel.setVisible(this.controller.getConfigurationKey("validationOptions/numbers/tolerance"));
			this.exactAnswerRadioButton.setVisible(this.controller.getConfigurationKey("validationOptions/numbers/tolerance"));
			this.errorMarginRadioButton.setVisible(this.controller.getConfigurationKey("validationOptions/numbers/tolerance"));
			this.errorMarginPanel.setVisible(this.controller.getConfigurationKey("validationOptions/numbers/tolerance"));
			this.matchingDigitsRadioButton.setVisible(this.controller.getConfigurationKey("validationOptions/numbers/tolerance"));
			this.matchingDigitsPanel.setVisible(this.controller.getConfigurationKey("validationOptions/numbers/tolerance"));
			this.formatLabel.setVisible(this.controller.getConfigurationKey("validationOptions/numbers/format"));
			this.scientificNotationRadioButton.setVisible(this.controller.getConfigurationKey("validationOptions/numbers/format"));
			this.decimalNotationRadioButton.setVisible(this.controller.getConfigurationKey("validationOptions/numbers/format"));
			this.anyNotationRadioButton.setVisible(this.controller.getConfigurationKey("validationOptions/numbers/format"));
			this.precisionLabel.setVisible(this.controller.getConfigurationKey("validationOptions/numbers/precision"));
			this.precisionEnabledCheckBox.setVisible(this.controller.getConfigurationKey("validationOptions/numbers/precision"));
			this.precisionPanel.setVisible(this.controller.getConfigurationKey("validationOptions/numbers/precision"));
		} else {
			this.divider.setVisible(false);
			this.toleranceLabel.setVisible(false);
			this.exactAnswerRadioButton.setVisible(false);
			this.errorMarginRadioButton.setVisible(false);
			this.errorMarginPanel.setVisible(false);
			this.matchingDigitsRadioButton.setVisible(false);
			this.matchingDigitsPanel.setVisible(false);
			this.formatLabel.setVisible(false);
			this.scientificNotationRadioButton.setVisible(false);
			this.decimalNotationRadioButton.setVisible(false);
			this.anyNotationRadioButton.setVisible(false);
			this.precisionLabel.setVisible(false);
			this.precisionEnabledCheckBox.setVisible(false);
			this.precisionPanel.setVisible(false);
		}
	}
	,symbolicAnswer: null
	,formatSelectionController: null
	,toleranceSelectionController: null
	,controller: null
	,precisionPanel: null
	,precisionTypeDropdown: null
	,precisionMaximumTextField: null
	,precisionMinimumTextField: null
	,precisionEnabledCheckBox: null
	,precisionLabel: null
	,anyNotationRadioButton: null
	,decimalNotationRadioButton: null
	,scientificNotationRadioButton: null
	,formatLabel: null
	,matchingDigitsPanel: null
	,matchingDigitsQtyTextField: null
	,matchingDigitsTypeDropdown: null
	,matchingDigitsRadioButton: null
	,errorMarginPanel: null
	,errorMarginQtyTextField: null
	,errorMarginTypeDropdown: null
	,errorMarginRadioButton: null
	,exactAnswerRadioButton: null
	,toleranceLabel: null
	,divider: null
	,symbolicAnswerCheckBox: null
	,label: null
	,__class__: com.wiris.quizzes.impl.ui.component.NumberValidationComponent
});
com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent = $hxClasses["com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent"] = function(controller) {
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.setId(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_FIELD_ID).addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_FULL_SIZE_PANEL);
	this.controller = controller;
	this.label = com.wiris.util.ui.component.Label.newImportantWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_FIELD_LABEL));
	var content = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	content.addClass(com.wiris.util.ui.component.Panel.CLASS_PANEL_CARD);
	this.numberFormatLabel = com.wiris.util.ui.component.Label.newImportantWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_NUMBER_FORMAT));
	this.precisionDropdown = new com.wiris.util.ui.component.Dropdown();
	var _g = 1;
	while(_g < 16) {
		var i = _g++;
		this.precisionDropdown.addValue("" + i,"" + i);
	}
	this.precisionDropdown.pickValue("4");
	this.precisionDropdown.setTitle(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_PRECISION_TYPE_SIGNIFICANT_FIGURES));
	this.precisionDropdown.setChangeValueAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_PRECISION,null));
	this.precisionDropdown.addActionListener(this.controller);
	this.precisionDropdown.addActionListener(this);
	this.precisionTypeDropdown = new com.wiris.util.ui.component.Dropdown();
	this.precisionTypeDropdown.setTitle(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_PRECISION));
	this.precisionTypeDropdown.addValue(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_PRECISION_TYPE_SIGNIFICANT_FIGURES,this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_PRECISION_TYPE_SIGNIFICANT_FIGURES));
	this.precisionTypeDropdown.addValue(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_PRECISION_TYPE_DECIMAL_PLACES,this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_PRECISION_TYPE_DECIMAL_PLACES));
	this.precisionTypeDropdown.pickValue(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_PRECISION_TYPE_SIGNIFICANT_FIGURES);
	this.precisionTypeDropdown.setChangeValueAction(new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_PRECISION_TYPE,null));
	this.precisionTypeDropdown.addActionListener(this.controller);
	this.precisionTypeDropdown.addActionListener(this);
	var precisionPanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	precisionPanel.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setHorizontalAlignment(com.wiris.util.ui.Style.HORIZONTAL_ALIGNMENT_SPACED);
	precisionPanel.addComponent(this.precisionDropdown);
	precisionPanel.addComponent(this.precisionTypeDropdown);
	this.notationLabel = com.wiris.util.ui.component.Label.newWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_NOTATION));
	this.notationHelperText = com.wiris.util.ui.component.Label.newTinyWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_HELPER_TEXT));
	this.notationToggleButtonsPanel = new com.wiris.util.ui.component.ToggleButtonsPanel();
	this.notationToggleButtonsPanel.newToggleButtonWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_NOTATION_DECIMAL),com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_NOTATION_DECIMAL,false,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_NOTATION_DECIMAL,null),this.controller,true);
	this.notationToggleButtonsPanel.newToggleButtonWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_NOTATION_SCIENTIFIC),com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_NOTATION_SCIENTIFIC,false,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_NOTATION_SCIENTIFIC,null),this.controller,true);
	this.notationToggleButtonsPanel.newToggleButtonWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_NOTATION_AUTO),com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_NOTATION_AUTO,true,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_NOTATION_AUTO,null),this.controller,true);
	this.notationToggleButtonsPanel.addActionListener(this.controller);
	var notationTitlePanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	notationTitlePanel.addComponent(this.notationLabel);
	notationTitlePanel.addComponent(this.notationHelperText);
	var notationPanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	notationPanel.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setHorizontalAlignment(com.wiris.util.ui.Style.HORIZONTAL_ALIGNMENT_SPACED);
	notationPanel.addComponent(notationTitlePanel);
	notationPanel.addComponent(this.notationToggleButtonsPanel);
	this.decimalLabel = com.wiris.util.ui.component.Label.newWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_DECIMAL));
	this.decimalHelperText = com.wiris.util.ui.component.Label.newTinyWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_HELPER_TEXT));
	this.decimalToggleButtonsPanel = new com.wiris.util.ui.component.ToggleButtonsPanel();
	this.decimalToggleButtonsPanel.newToggleButtonWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_DECIMAL_COMMA),com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_DECIMAL_COMMA,false,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_DECIMAL_COMMA,null),this.controller,false);
	this.decimalToggleButtonsPanel.newToggleButtonWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_DECIMAL_POINT),com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_DECIMAL_POINT,true,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_DECIMAL_POINT,null),this.controller,true);
	this.decimalToggleButtonsPanel.addActionListener(this.controller);
	var decimalTitlePanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	decimalTitlePanel.addComponent(this.decimalLabel);
	decimalTitlePanel.addComponent(this.decimalHelperText);
	var decimalPanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	decimalPanel.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setHorizontalAlignment(com.wiris.util.ui.Style.HORIZONTAL_ALIGNMENT_SPACED);
	decimalPanel.addComponent(decimalTitlePanel);
	decimalPanel.addComponent(this.decimalToggleButtonsPanel);
	this.thousandsLabel = com.wiris.util.ui.component.Label.newWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_THOUSANDS));
	this.thousandsHelperText = com.wiris.util.ui.component.Label.newTinyWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_HELPER_TEXT));
	this.thousandsToggleButtonsPanel = new com.wiris.util.ui.component.ToggleButtonsPanel();
	this.thousandsToggleButtonsPanel.newToggleButtonWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_THOUSANDS_NONE),com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_THOUSANDS_NONE,true,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_THOUSANDS_NONE,null),this.controller,true);
	this.thousandsToggleButtonsPanel.newToggleButtonWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_THOUSANDS_SPACE),com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_THOUSANDS_SPACE,false,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_THOUSANDS_SPACE,null),this.controller,false);
	this.thousandsToggleButtonsPanel.newToggleButtonWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_THOUSANDS_COMMA),com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_THOUSANDS_COMMA,false,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_THOUSANDS_COMMA,null),this.controller,false);
	this.thousandsToggleButtonsPanel.newToggleButtonWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_THOUSANDS_POINT),com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_THOUSANDS_POINT,false,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_THOUSANDS_POINT,null),this.controller,false);
	this.thousandsToggleButtonsPanel.addActionListener(this.controller);
	var thousandsTitlePanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	thousandsTitlePanel.addComponent(this.thousandsLabel);
	thousandsTitlePanel.addComponent(this.thousandsHelperText);
	var thousandsPanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	thousandsPanel.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setHorizontalAlignment(com.wiris.util.ui.Style.HORIZONTAL_ALIGNMENT_SPACED);
	thousandsPanel.addComponent(thousandsTitlePanel);
	thousandsPanel.addComponent(this.thousandsToggleButtonsPanel);
	this.expressionFormatLabel = com.wiris.util.ui.component.Label.newImportantWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_EXPRESSION_FORMAT));
	this.imaginaryUnitLabel = com.wiris.util.ui.component.Label.newWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_IMAGINARY_UNIT));
	this.imaginaryUnitHelperText = com.wiris.util.ui.component.Label.newTinyWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_HELPER_TEXT));
	this.imaginaryUnitToggleButtonsPanel = new com.wiris.util.ui.component.ToggleButtonsPanel();
	this.imaginaryUnitToggleButtonsPanel.newToggleButtonWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_IMAGINARY_UNIT_I),com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_IMAGINARY_UNIT_I,true,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_IMAGINARY_UNIT_I,null),this.controller,true);
	this.imaginaryUnitToggleButtonsPanel.newToggleButtonWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_IMAGINARY_UNIT_J),com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_IMAGINARY_UNIT_J,false,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_IMAGINARY_UNIT_J,null),this.controller,true);
	this.imaginaryUnitToggleButtonsPanel.addActionListener(this.controller);
	var imaginaryUnitTitlePanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	imaginaryUnitTitlePanel.addComponent(this.imaginaryUnitLabel);
	imaginaryUnitTitlePanel.addComponent(this.imaginaryUnitHelperText);
	var imaginaryUnitPanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	imaginaryUnitPanel.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setHorizontalAlignment(com.wiris.util.ui.Style.HORIZONTAL_ALIGNMENT_SPACED);
	imaginaryUnitPanel.addComponent(imaginaryUnitTitlePanel);
	imaginaryUnitPanel.addComponent(this.imaginaryUnitToggleButtonsPanel);
	this.timesOperatorLabel = com.wiris.util.ui.component.Label.newWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_TIMES_OPERATOR));
	this.timesOperatorHelperText = com.wiris.util.ui.component.Label.newTinyWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_HELPER_TEXT));
	this.timesOperatorToggleButtonsPanel = new com.wiris.util.ui.component.ToggleButtonsPanel();
	this.timesOperatorToggleButtonsPanel.newToggleButtonWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_TIMES_OPERATOR_DOT),com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_TIMES_OPERATOR_DOT,true,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_TIMES_OPERATOR_DOT,null),this.controller,true);
	this.timesOperatorToggleButtonsPanel.newToggleButtonWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_TIMES_OPERATOR_CROSS),com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_TIMES_OPERATOR_CROSS,false,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_TIMES_OPERATOR_CROSS,null),this.controller,true);
	this.timesOperatorToggleButtonsPanel.newToggleButtonWithText(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_INVISIBLE_TIMES_OPERATOR),com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_INVISIBLE_TIMES_OPERATOR,false,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_INVISIBLE_TIMES_OPERATOR,null),this.controller,true);
	this.timesOperatorToggleButtonsPanel.addActionListener(this.controller);
	var timesOperatorTitlePanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	timesOperatorTitlePanel.addComponent(this.timesOperatorLabel);
	timesOperatorTitlePanel.addComponent(this.timesOperatorHelperText);
	var timesOperatorPanel = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	timesOperatorPanel.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT).setHorizontalAlignment(com.wiris.util.ui.Style.HORIZONTAL_ALIGNMENT_SPACED);
	timesOperatorPanel.addComponent(timesOperatorTitlePanel);
	timesOperatorPanel.addComponent(this.timesOperatorToggleButtonsPanel);
	content.addComponent(this.numberFormatLabel);
	content.addComponent(precisionPanel);
	content.addComponent(notationPanel);
	content.addComponent(decimalPanel);
	content.addComponent(thousandsPanel);
	content.addComponent(new com.wiris.util.ui.component.Divider(false));
	content.addComponent(this.expressionFormatLabel);
	content.addComponent(imaginaryUnitPanel);
	content.addComponent(timesOperatorPanel);
	this.addComponent(this.label);
	this.addComponent(content);
};
com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.__name__ = ["com","wiris","quizzes","impl","ui","component","OutputVariableOptionsComponent"];
com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.__interfaces__ = [com.wiris.util.ui.interaction.ActionListener];
com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	getTimesOperatorHelperText: function(questionImpl) {
		var times = questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_IMPLICIT_TIMES_OPERATOR) == "true"?"":questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_TIMES_OPERATOR);
		return this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_HELPER_TEXT) + "(a + b)² = a² + 2" + times + "a" + times + "b + b²";
	}
	,getImaginaryUnitHelperText: function(questionImpl) {
		var times = questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_IMPLICIT_TIMES_OPERATOR) == "true"?"":questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_TIMES_OPERATOR);
		var imaginary = questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_IMAGINARY_UNIT);
		return this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_HELPER_TEXT) + "(x² + 4) = (x - 2" + times + imaginary + ")" + times + "(x + 2" + times + imaginary + ")";
	}
	,getThousandsHelperText: function(questionImpl) {
		var times = questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_IMPLICIT_TIMES_OPERATOR) == "true"?"·":questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_TIMES_OPERATOR);
		var thousands = questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_DIGIT_GROUP_SEPARATOR);
		return this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_HELPER_TEXT) + "100" + times + "100 = 10" + thousands + "000";
	}
	,getDecimalHelperText: function(questionImpl) {
		var precision = questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_FLOAT_FORMAT) == "f"?Std.parseInt(questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_PRECISION)):Std.parseInt(questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_PRECISION)) - 1;
		var pi = Math.round(Math.PI * Math.pow(10,precision)) / Math.pow(10,precision);
		var decimals = ("" + pi).substring(2);
		var decimalSeparator = questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_DECIMAL_SEPARATOR);
		return this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_HELPER_TEXT) + "π = 3" + (decimals.length == 0?"":decimalSeparator + decimals);
	}
	,getNotationHelperText: function(questionImpl) {
		var decimalSeparator = questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_DECIMAL_SEPARATOR);
		var thousands = questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_DIGIT_GROUP_SEPARATOR);
		var times = questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_IMPLICIT_TIMES_OPERATOR) == "true"?"·":questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_TIMES_OPERATOR);
		if(questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_FLOAT_FORMAT) == "me") return this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_HELPER_TEXT) + "c = 2" + decimalSeparator + "98" + times + "10⁸"; else return this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_HELPER_TEXT) + "c = 298" + thousands + "000" + thousands + "000";
	}
	,setCasOutputOptions: function(questionImpl,slot) {
		if(questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_FLOAT_FORMAT) == "f") {
			this.notationToggleButtonsPanel.pickTogglebuttonWithId(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_NOTATION_DECIMAL);
			this.notationToggleButtonsPanel.getToggleButtonById(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_NOTATION_AUTO).setEnabled(false);
			this.notationToggleButtonsPanel.getToggleButtonById(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_NOTATION_SCIENTIFIC).setEnabled(false);
		} else if(questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_FLOAT_FORMAT) == "mr") this.notationToggleButtonsPanel.pickTogglebuttonWithId(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_NOTATION_DECIMAL); else if(questionImpl.getOption(com.wiris.quizzes.api.QuizzesConstants.OPTION_FLOAT_FORMAT) == "me") this.notationToggleButtonsPanel.pickTogglebuttonWithId(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_NOTATION_SCIENTIFIC); else {
			this.notationToggleButtonsPanel.getToggleButtonById(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_NOTATION_AUTO).setEnabled(true);
			this.notationToggleButtonsPanel.getToggleButtonById(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_NOTATION_SCIENTIFIC).setEnabled(true);
			this.notationToggleButtonsPanel.pickTogglebuttonWithId(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_NOTATION_AUTO);
		}
		var decimalSeparators = slot.getSyntax().getParameter(com.wiris.quizzes.api.assertion.SyntaxParameterName.DECIMAL_SEPARATORS);
		var digitGroupSeparators = slot.getSyntax().getParameter(com.wiris.quizzes.api.assertion.SyntaxParameterName.DIGIT_GROUP_SEPARATORS);
		this.decimalToggleButtonsPanel.getToggleButtonById(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_DECIMAL_POINT).setEnabled(decimalSeparators.indexOf(".") > -1);
		this.decimalToggleButtonsPanel.getToggleButtonById(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_DECIMAL_COMMA).setEnabled(decimalSeparators.indexOf("\\,") > -1);
		this.thousandsToggleButtonsPanel.getToggleButtonById(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_THOUSANDS_SPACE).setEnabled(digitGroupSeparators.indexOf(" ") > -1);
		this.thousandsToggleButtonsPanel.getToggleButtonById(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_THOUSANDS_COMMA).setEnabled(digitGroupSeparators.indexOf("\\,") > -1);
		this.thousandsToggleButtonsPanel.getToggleButtonById(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_THOUSANDS_POINT).setEnabled(digitGroupSeparators.indexOf(".") > -1);
		this.notationHelperText.setText(this.getNotationHelperText(questionImpl));
		this.decimalHelperText.setText(this.getDecimalHelperText(questionImpl));
		this.thousandsHelperText.setText(this.getThousandsHelperText(questionImpl));
		this.imaginaryUnitHelperText.setText(this.getImaginaryUnitHelperText(questionImpl));
		this.timesOperatorHelperText.setText(this.getTimesOperatorHelperText(questionImpl));
	}
	,actionPerformed: function(e) {
		var source = e.getSource();
		var action = e.getAction();
		var actionId = action.getId();
		if(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_PRECISION_TYPE == actionId) {
			var value = source.getValue();
			if(value == com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_PRECISION_TYPE_DECIMAL_PLACES) this.precisionDropdown.setTitle(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_PRECISION_TYPE_DECIMAL_PLACES)); else if(value == com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_ID_PRECISION_TYPE_SIGNIFICANT_FIGURES) this.precisionDropdown.setTitle(this.controller.t(com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent.OUTPUT_VARIABLE_OPTIONS_LABEL_PRECISION_TYPE_SIGNIFICANT_FIGURES));
		}
	}
	,timesOperatorToggleButtonsPanel: null
	,timesOperatorHelperText: null
	,timesOperatorLabel: null
	,imaginaryUnitToggleButtonsPanel: null
	,imaginaryUnitHelperText: null
	,imaginaryUnitLabel: null
	,thousandsToggleButtonsPanel: null
	,thousandsHelperText: null
	,thousandsLabel: null
	,decimalToggleButtonsPanel: null
	,decimalHelperText: null
	,decimalLabel: null
	,notationToggleButtonsPanel: null
	,notationHelperText: null
	,notationLabel: null
	,precisionTypeDropdown: null
	,precisionDropdown: null
	,expressionFormatLabel: null
	,numberFormatLabel: null
	,label: null
	,controller: null
	,__class__: com.wiris.quizzes.impl.ui.component.OutputVariableOptionsComponent
});
com.wiris.util.ui.component.Window = $hxClasses["com.wiris.util.ui.component.Window"] = function() {
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.setVisible(false);
	this.getStyle().setHorizontalAlignment(com.wiris.util.ui.Style.HORIZONTAL_ALIGNMENT_CENTER);
	this.title = null;
	this.titleBarButtons = new Array();
	this.setEasyModalCloseEnabled(false);
	this.setModal(false);
	this.setRelative(true);
	this.addClass(com.wiris.util.ui.component.Window.CLASS_WINDOW);
	this.addKeyListener(this);
};
com.wiris.util.ui.component.Window.__name__ = ["com","wiris","util","ui","component","Window"];
com.wiris.util.ui.component.Window.__interfaces__ = [com.wiris.util.ui.interaction.KeyListener];
com.wiris.util.ui.component.Window.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.util.ui.component.Window.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	keyType: function(e) {
	}
	,keyRelease: function(e) {
	}
	,keyPress: function(e) {
		if(!this.isVisible()) return;
		if(e.getKeyCode() == com.wiris.util.ui.interaction.KeyCode.ESCAPE) {
			this.easyModalClose();
			e.stopPropagation();
		}
	}
	,setResizable: function(resizable) {
		this.resizable = resizable;
		this.changeState();
	}
	,isResizable: function() {
		return this.resizable;
	}
	,setMovable: function(movable) {
		this.movable = movable;
		this.changeState();
	}
	,isMovable: function() {
		return this.movable;
	}
	,isRelative: function() {
		return this.relative;
	}
	,setRelative: function(relative) {
		this.relative = relative;
		if(relative) this.addClass(com.wiris.util.ui.component.Window.CLASS_WINDOW_RELATIVE); else this.removeClass(com.wiris.util.ui.component.Window.CLASS_WINDOW_RELATIVE);
	}
	,isEasyModalCloseEnabled: function() {
		return this.easyModalCloseEnabled;
	}
	,setEasyModalCloseEnabled: function(easyModalCloseEnabled) {
		this.easyModalCloseEnabled = easyModalCloseEnabled;
	}
	,isModal: function() {
		return this.modal;
	}
	,setModal: function(modal) {
		this.modal = modal;
		if(modal) this.addClass(com.wiris.util.ui.component.Window.CLASS_WINDOW_MODAL); else this.removeClass(com.wiris.util.ui.component.Window.CLASS_WINDOW_MODAL);
	}
	,getTitleBarButtons: function() {
		return this.titleBarButtons;
	}
	,addTitleBarButton: function(button) {
		this.titleBarButtons.push(button);
	}
	,setTitle: function(title) {
		this.title = title;
		this.changeState();
	}
	,getTitle: function() {
		return this.title;
	}
	,easyModalClose: function() {
		if(this.isEasyModalCloseEnabled()) this.close();
	}
	,close: function() {
		this.setVisible(false);
	}
	,open: function() {
		this.setVisible(true);
	}
	,resizable: null
	,movable: null
	,relative: null
	,easyModalCloseEnabled: null
	,modal: null
	,title: null
	,titleBarButtons: null
	,__class__: com.wiris.util.ui.component.Window
});
com.wiris.quizzes.impl.ui.component.PopupWindow = $hxClasses["com.wiris.quizzes.impl.ui.component.PopupWindow"] = function(parent) {
	com.wiris.util.ui.component.Window.call(this);
	this.setModal(true);
	this.setParent(parent);
	this.setRelative(false);
	this.setEasyModalCloseEnabled(false);
	this.quizzesContext = com.wiris.quizzes.impl.ui.QuizzesContext.getInstance();
	this.setConfirmDialog(this.createConfirmDialog());
};
com.wiris.quizzes.impl.ui.component.PopupWindow.__name__ = ["com","wiris","quizzes","impl","ui","component","PopupWindow"];
com.wiris.quizzes.impl.ui.component.PopupWindow.__interfaces__ = [com.wiris.util.ui.interaction.ActionListener];
com.wiris.quizzes.impl.ui.component.PopupWindow.newWithConfirmDialog = function(parent,dialog) {
	var window = new com.wiris.quizzes.impl.ui.component.PopupWindow(parent);
	window.setConfirmDialog(dialog);
	return window;
}
com.wiris.quizzes.impl.ui.component.PopupWindow.newWithCustomConfirmDialog = function(parent,title,message,labels,actions) {
	var dialog = new com.wiris.util.ui.component.Dialog();
	dialog.setTitle(title);
	dialog.setMessageText(message);
	var i = HxOverrides.iter(labels);
	var j = HxOverrides.iter(actions);
	var first = true;
	while(i.hasNext() && j.hasNext()) {
		dialog.addPrimaryAction(i.next(),j.next(),first);
		first = false;
	}
	return com.wiris.quizzes.impl.ui.component.PopupWindow.newWithConfirmDialog(parent,dialog);
}
com.wiris.quizzes.impl.ui.component.PopupWindow.__super__ = com.wiris.util.ui.component.Window;
com.wiris.quizzes.impl.ui.component.PopupWindow.prototype = $extend(com.wiris.util.ui.component.Window.prototype,{
	actionPerformed: function(e) {
		var action = e.getAction();
		var actionId = action.getId();
		if(actionId == com.wiris.quizzes.impl.ui.component.PopupWindow.ACCEPT_EASY_MODAL_CLOSE_ACTION_ID) {
			this.confirmDialog.close();
			this.close();
		} else if(actionId == com.wiris.quizzes.impl.ui.component.PopupWindow.CANCEL_EASY_MODAL_CLOSE_ACTION_ID) this.confirmDialog.close();
	}
	,easyModalClose: function() {
		if(this.isEasyModalCloseEnabled()) this.close(); else this.confirmDialog.open();
	}
	,setConfirmDialog: function(dialog) {
		if(this.confirmDialog != null) this.confirmDialog.removeActionListener(this);
		this.confirmDialog = dialog;
		this.addComponent(this.confirmDialog);
		this.confirmDialog.addActionListener(this);
	}
	,createConfirmDialog: function() {
		var dialog = new com.wiris.util.ui.component.Dialog();
		dialog.setTitle(this.quizzesContext.t(com.wiris.quizzes.impl.ui.component.PopupWindow.POPUP_TEXT_FIELD_WARNING_TITLE));
		dialog.setMessageText(this.quizzesContext.t(com.wiris.quizzes.impl.ui.component.PopupWindow.POPUP_TEXT_FIELD_WARNING_MESSAGE));
		dialog.addPrimaryAction(this.quizzesContext.t(com.wiris.quizzes.impl.ui.component.PopupWindow.POPUP_TEXT_FIELD_WARNING_ACCEPT_BUTTON_LABEL),new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.PopupWindow.ACCEPT_EASY_MODAL_CLOSE_ACTION_ID,null),true).addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON);
		dialog.addPrimaryAction(this.quizzesContext.t(com.wiris.quizzes.impl.ui.component.PopupWindow.POPUP_TEXT_FIELD_WARNING_CANCEL_BUTTON_LABEL),new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.PopupWindow.CANCEL_EASY_MODAL_CLOSE_ACTION_ID,null),false).addClass(com.wiris.quizzes.impl.ui.component.QuizzesStudioComponent.CLASS_QUIZZES_BUTTON);
		return dialog;
	}
	,quizzesContext: null
	,confirmDialog: null
	,__class__: com.wiris.quizzes.impl.ui.component.PopupWindow
});
com.wiris.quizzes.impl.ui.component.QuizzesCompoundTextField = $hxClasses["com.wiris.quizzes.impl.ui.component.QuizzesCompoundTextField"] = function(slot,instance,answerField) {
	this.changeActionId = "studentAnswerChanged";
	this.updating = false;
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.addClass(com.wiris.quizzes.impl.ui.component.QuizzesCompoundTextField.CLASS_QUIZZES_COMPOUND_FIELD);
	this.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT);
	this.labels = new Array();
	this.textFields = new Array();
	this.answerField = answerField;
	if(slot != null) {
		this.updateFields(slot,instance);
		this.setValue(slot.getInitialContent());
	}
};
com.wiris.quizzes.impl.ui.component.QuizzesCompoundTextField.__name__ = ["com","wiris","quizzes","impl","ui","component","QuizzesCompoundTextField"];
com.wiris.quizzes.impl.ui.component.QuizzesCompoundTextField.__interfaces__ = [com.wiris.util.ui.component.Field,com.wiris.util.ui.interaction.ActionListener];
com.wiris.quizzes.impl.ui.component.QuizzesCompoundTextField.expandCompoundAnswerLabelVariables = function(compoundAnswers,instance) {
	if(instance == null || !instance.hasVariables()) return compoundAnswers;
	var r = new Array();
	var _g1 = 0, _g = compoundAnswers.length;
	while(_g1 < _g) {
		var i = _g1++;
		var answer = compoundAnswers[i];
		var expanded = new Array();
		expanded[0] = instance.expandVariablesMathML(answer[0]);
		expanded[1] = answer[1];
		r.push(expanded);
	}
	return r;
}
com.wiris.quizzes.impl.ui.component.QuizzesCompoundTextField.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.quizzes.impl.ui.component.QuizzesCompoundTextField.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	setChangeActionId: function(changeActionId) {
		this.changeActionId = changeActionId;
	}
	,isEmpty: function() {
		var _g = 0, _g1 = this.textFields;
		while(_g < _g1.length) {
			var textField = _g1[_g];
			++_g;
			if(!textField.isEmpty()) return false;
		}
		return true;
	}
	,getComponent: function() {
		return this;
	}
	,getAnswerValue: function(answer) {
		if(com.wiris.quizzes.impl.MathContent.getMathType(answer) == com.wiris.quizzes.impl.MathContent.TYPE_MATHML) {
			var tools = new com.wiris.quizzes.impl.HTMLTools();
			return tools.mathMLToText(answer);
		}
		return answer;
	}
	,setValue: function(value) {
		var answers = com.wiris.quizzes.impl.ui.component.QuizzesCompoundTextField.expandCompoundAnswerLabelVariables(this.getCompoundAnswers(value),this.instance);
		if(answers.length == 0) {
			var _g = 0, _g1 = this.textFields;
			while(_g < _g1.length) {
				var tf = _g1[_g];
				++_g;
				tf.setValue("");
			}
			return;
		}
		var ok = answers.length == this.labels.length;
		var i = 0;
		while(i < answers.length && ok) {
			var answer = answers[i];
			var label = this.labels[i];
			ok = answer[0] == label.getText();
			if(ok) {
				var textField = this.textFields[i];
				textField.setValue(this.getAnswerValue(answer[1]));
			}
			i++;
		}
		if(!ok) {
			this.updateFieldsImpl(this.slot,this.instance,value);
			this.setValue(value);
		}
		this.changeState();
	}
	,getValue: function() {
		var value = new Array();
		var tools = new com.wiris.quizzes.impl.HTMLTools();
		var _g1 = 0, _g = this.compoundAnswers.length;
		while(_g1 < _g) {
			var i = _g1++;
			value.push([this.compoundAnswers[i][0],tools.textToMathMLWithSemantics(this.textFields[i].getValue())]);
		}
		return com.wiris.quizzes.impl.CompoundAnswerParser.joinCompoundAnswer(value).content;
	}
	,actionPerformed: function(e) {
		if(this.updating) return;
		var action = e.getAction();
		var actionId = action.getId();
		if(actionId == this.changeActionId) {
			this.performAction(action);
			this.changeState();
		}
	}
	,getTextFields: function() {
		return this.textFields;
	}
	,getCompoundAnswers: function(correctAnswer) {
		var mathContent = new com.wiris.quizzes.impl.MathContent();
		mathContent.set(correctAnswer);
		return com.wiris.quizzes.impl.CompoundAnswerParser.parseCompoundAnswer(mathContent);
	}
	,newTextField: function(index) {
		var textField = new com.wiris.util.ui.component.TextField();
		textField.getStyle().setWidth(280);
		textField.setChangeAction(new com.wiris.util.ui.Action(this.changeActionId,"" + index));
		textField.addActionListener(this);
		if(com.wiris.quizzes.impl.ui.QuizzesContext.getInstance().isForceLTR()) textField.addClass(com.wiris.util.ui.component.TextField.CLASS_FORCE_LTR);
		return textField;
	}
	,updateFieldsImpl: function(slot,instance,model) {
		this.updating = true;
		this.slot = slot;
		this.instance = instance;
		if(model == null) {
			model = "";
			if(slot != null) {
				if(instance != null && instance.getSlotAnswer(slot) != null) {
					var studentAnswer = instance.getSlotAnswer(slot);
					if(this.getCompoundAnswers(studentAnswer).length > 0) model = studentAnswer;
				}
				if(model == "") {
					var correctAnswers = this.slot.getAuthorAnswers();
					if(correctAnswers.length > 0) model = correctAnswers[0].getValue();
				}
			}
		}
		this.compoundAnswers = com.wiris.quizzes.impl.ui.component.QuizzesCompoundTextField.expandCompoundAnswerLabelVariables(this.getCompoundAnswers(model),instance);
		this.removeAllComponents();
		this.labels = new Array();
		this.textFields = new Array();
		var _g1 = 0, _g = this.compoundAnswers.length;
		while(_g1 < _g) {
			var i = _g1++;
			var answer = this.compoundAnswers[i];
			var container = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
			container.addClass(com.wiris.quizzes.impl.ui.component.QuizzesCompoundTextField.CLASS_QUIZZES_COMPOUND_FIELD_ROW);
			container.getStyle().setWidthWithUnit(100,com.wiris.util.ui.Style.SIZE_UNIT_PERCENT);
			var answerLabel = com.wiris.quizzes.impl.ui.component.MathLabel.newWithText(answer[0]);
			var textField = this.newTextField(com.wiris.util.type.Arrays.indexOfElement(this.compoundAnswers,answer));
			this.labels.push(answerLabel);
			this.textFields.push(textField);
			container.addComponent(answerLabel);
			container.addComponent(textField);
			container.addMouseListener(this.answerField);
			this.addComponent(container);
		}
		this.updating = false;
	}
	,updateFields: function(slot,instance) {
		this.updateFieldsImpl(slot,instance,null);
	}
	,setReadOnly: function(readOnly) {
		var _g = 0, _g1 = this.textFields;
		while(_g < _g1.length) {
			var field = _g1[_g];
			++_g;
			field.setReadOnly(readOnly);
		}
	}
	,answerField: null
	,changeActionId: null
	,compoundAnswers: null
	,textFields: null
	,labels: null
	,instance: null
	,slot: null
	,updating: null
	,__class__: com.wiris.quizzes.impl.ui.component.QuizzesCompoundTextField
});
com.wiris.quizzes.impl.ui.component.QuizzesCompoundMathTypePopupTextField = $hxClasses["com.wiris.quizzes.impl.ui.component.QuizzesCompoundMathTypePopupTextField"] = function(slot,instance,answerField,mathtypeParameters) {
	this.easyModalClose = false;
	com.wiris.quizzes.impl.ui.component.QuizzesCompoundTextField.call(this,slot,instance,answerField);
	this.mathtypeParameters = mathtypeParameters;
};
com.wiris.quizzes.impl.ui.component.QuizzesCompoundMathTypePopupTextField.__name__ = ["com","wiris","quizzes","impl","ui","component","QuizzesCompoundMathTypePopupTextField"];
com.wiris.quizzes.impl.ui.component.QuizzesCompoundMathTypePopupTextField.__super__ = com.wiris.quizzes.impl.ui.component.QuizzesCompoundTextField;
com.wiris.quizzes.impl.ui.component.QuizzesCompoundMathTypePopupTextField.prototype = $extend(com.wiris.quizzes.impl.ui.component.QuizzesCompoundTextField.prototype,{
	setEasyModalClose: function(easyModalClose) {
		this.easyModalClose = easyModalClose;
		var _g = 0, _g1 = this.textFields;
		while(_g < _g1.length) {
			var field = _g1[_g];
			++_g;
			var textField = field;
			textField.setEasyModalClose(easyModalClose);
		}
	}
	,setGrammarUrl: function(grammarUrl,check) {
		var _g = 0, _g1 = this.textFields;
		while(_g < _g1.length) {
			var field = _g1[_g];
			++_g;
			var textField = field;
			textField.setGrammarUrl(grammarUrl,check);
		}
	}
	,setParameters: function(parameters) {
		var _g = 0, _g1 = this.textFields;
		while(_g < _g1.length) {
			var field = _g1[_g];
			++_g;
			var textField = field;
			textField.setParameters(parameters);
		}
	}
	,getAnswerValue: function(answer) {
		return answer;
	}
	,getValue: function() {
		var htmltools = new com.wiris.quizzes.impl.HTMLTools();
		var compoundAnswers = new Array();
		var i = HxOverrides.iter(this.compoundAnswers);
		var j = HxOverrides.iter(this.textFields);
		while(i.hasNext()) {
			var label = i.next()[0];
			var val = j.next().getValue();
			if(com.wiris.quizzes.impl.MathContent.getMathType(label) == com.wiris.quizzes.impl.MathContent.TYPE_TEXT) label = htmltools.textToMathML(label);
			if(com.wiris.quizzes.impl.MathContent.getMathType(val) == com.wiris.quizzes.impl.MathContent.TYPE_TEXT) val = htmltools.textToMathMLWithSemantics(val);
			compoundAnswers.push([label,val]);
		}
		return com.wiris.quizzes.impl.CompoundAnswerParser.joinCompoundAnswer(compoundAnswers).content;
	}
	,newTextField: function(index) {
		var textField = new com.wiris.quizzes.impl.ui.component.MathTypePopupTextField(this.mathtypeParameters);
		textField.setChangeAction(new com.wiris.util.ui.Action(this.changeActionId,"" + index));
		textField.addActionListener(this);
		textField.setEasyModalClose(this.easyModalClose);
		return textField;
	}
	,mathtypeParameters: null
	,easyModalClose: null
	,__class__: com.wiris.quizzes.impl.ui.component.QuizzesCompoundMathTypePopupTextField
});
com.wiris.quizzes.impl.ui.component.QuizzesOptionsFilterComponent = $hxClasses["com.wiris.quizzes.impl.ui.component.QuizzesOptionsFilterComponent"] = function(controller,activityId) {
	com.wiris.util.ui.component.FlowPanel.call(this,com.wiris.util.ui.component.FlowPanel.DIRECTION_TOP_TO_BOTTOM);
	this.addClass(com.wiris.quizzes.impl.ui.component.QuizzesOptionsFilterComponent.CLASS_OPTIONS_FILTER);
	this.label = com.wiris.util.ui.component.Label.newWithText(controller.t(com.wiris.quizzes.impl.ui.component.QuizzesOptionsFilterComponent.OPTIONS_FILTER_LABEL));
	var radioGroup = new com.wiris.util.ui.component.FlowPanel(com.wiris.util.ui.component.FlowPanel.DIRECTION_LEFT_TO_RIGHT);
	this.selectionController = com.wiris.util.ui.controller.SelectionController.newMutuallyExclusive(com.wiris.quizzes.impl.ui.component.QuizzesOptionsFilterComponent.OPTIONS_FILTER_ID);
	var relevantOptionsChip = com.wiris.util.ui.component.ChoiceChip.newChoiceChip(controller.t(com.wiris.quizzes.impl.ui.component.QuizzesOptionsFilterComponent.OPTIONS_FILTER_LABEL_RELEVANT_OPTIONS),com.wiris.quizzes.impl.ui.component.QuizzesOptionsFilterComponent.OPTIONS_FILTER_ID_RELEVANT_OPTIONS,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.QuizzesOptionsFilterComponent.OPTIONS_FILTER_ID_RELEVANT_OPTIONS,null),controller);
	relevantOptionsChip.setId(activityId + "RelevantOptionsChip");
	this.selectionController.addSelectable(relevantOptionsChip,true);
	var allOptionsChip = com.wiris.util.ui.component.ChoiceChip.newChoiceChip(controller.t(com.wiris.quizzes.impl.ui.component.QuizzesOptionsFilterComponent.OPTIONS_FILTER_LABEL_ALL_OPTIONS),com.wiris.quizzes.impl.ui.component.QuizzesOptionsFilterComponent.OPTIONS_FILTER_ID_ALL_OPTIONS,new com.wiris.util.ui.Action(com.wiris.quizzes.impl.ui.component.QuizzesOptionsFilterComponent.OPTIONS_FILTER_ID_ALL_OPTIONS,null),controller);
	allOptionsChip.setId(activityId + "AllOptionsChip");
	this.selectionController.addSelectable(allOptionsChip,false);
	radioGroup.addComponent(relevantOptionsChip);
	radioGroup.addComponent(allOptionsChip);
	this.addComponent(this.label);
	this.addComponent(radioGroup);
};
com.wiris.quizzes.impl.ui.component.QuizzesOptionsFilterComponent.__name__ = ["com","wiris","quizzes","impl","ui","component","QuizzesOptionsFilterComponent"];
com.wiris.quizzes.impl.ui.component.QuizzesOptionsFilterComponent.__super__ = com.wiris.util.ui.component.FlowPanel;
com.wiris.quizzes.impl.ui.component.QuizzesOptionsFilterComponent.prototype = $extend(com.wiris.util.ui.component.FlowPanel.prototype,{
	isOptionsFiltered: function() {
		return this.selectionController.isSelected(com.wiris.quizzes.impl.ui.component.QuizzesOptionsFilterComponent.OPTIONS_FILTER_ID_RELEVANT_OPTIONS);
	}
	,setOptionsFilter: function(enabled) {
		if(enabled) this.selectionController.setSelected(com.wiris.quizzes.impl.ui.component.QuizzesOptionsFilterComponent.OPTIONS_FILTER_ID_RELEVANT_OPTIONS,true); else this.selectionController.setSelected(com.wiris.quizzes.impl.ui.component.QuizzesOptionsFilterComponent.OPTIONS_FILTER_ID_ALL_OPTIONS,true);
	}
	,selectionController: null
	,label: null
	,__class__: com.wiris.quizzes.impl.ui.component.QuizzesOptionsFilterComponent
});
com.wiris.util.ui.component.BorderPanel = $hxClasses["com.wiris.util.ui.component.BorderPanel"] = function(overlap) {
	com.wiris.util.ui.component.Panel.call(this);
	this.addClass(com.wiris.util.ui.component.BorderPanel.CLASS_BORDER_PANEL);
	this.overlap = overlap;
	if(overlap) this.addClass(com.wiris.util.ui.component.BorderPanel.CLASS_BORDER_PANEL_OVERLAP);
	this.positions = new Array();
};
com.wiris.util.ui.component.BorderPanel.__name__ = ["com","wiris","util","ui","component","BorderPanel"];
com.wiris.util.ui.component.BorderPanel.__super__ = com.wiris.util.ui.component.Panel;
com.wiris.util.ui.component.BorderPanel.prototype = $extend(com.wiris.util.ui.component.Panel.prototype,{
	removeComponent: function(index) {
		this.positions.splice(index,1);
		com.wiris.util.ui.component.Panel.prototype.removeComponent.call(this,index);
	}
	,moveComponent: function(index,destination) {
		if(index != destination) {
			var position = this.positions.splice(index,1)[0];
			var newDestination = index < destination?destination - 1:destination;
			this.positions.splice(newDestination,0,position);
		}
		com.wiris.util.ui.component.Panel.prototype.moveComponent.call(this,index,destination);
	}
	,getPositions: function() {
		return this.positions;
	}
	,isOverlapping: function() {
		return this.overlap;
	}
	,insertComponentAt: function(component,index,position) {
		component.addClass(com.wiris.util.ui.com